<?php

namespace App\Http\Controllers;

use App\Models\Devis;
use App\Models\Document;
use App\Models\Dossier;
use App\Models\Facture;
use App\Models\Meeting;
use App\Models\Notification;
use App\Models\Observation;
use App\Models\Rapport;
use App\Models\TypeDocument;
use App\Models\User;
use Illuminate\Http\Request;
use Barryvdh\DomPDF\Facade\Pdf;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;

class PdfController extends Controller
{


    public function normal($id)
    {

        $sign = 0;
        $rapport = Rapport::with('piece', 'piece.typereparation', 'piece.operation', 'taux', 'documents')->withCount('documents')->whereId($id)->latest()->first();
        $dossier = Dossier::whereId($rapport->dossier_id)->with('document', 'company', 'garage', 'typeexpertise', 'shockpoint', 'contradictoire.adverse')->firstOrFail();
        // Allow viewing PDF even for signed rapports - removed restriction
        // Original check: if ($rapport->rapport_status_id == 2 || $rapport->rapport_status_id == 3)
        if ($rapport->rapport_status_id == 2 || $rapport->rapport_status_id == 3) {
            $sign = 1; // Mark as signed for proper PDF rendering with signature
        }

        if ($dossier->update != 0 && Auth::user()->role_id != 4 ||  $dossier->dossier_status_id == 3 && Auth::user()->role_id != 4) {
            return redirect()->route('Dossier.show', $dossier->id)->with('error', 'Dossier est interdit de le modifier Envoyer une demande a Admin ');
        }

        // if (!$rapport->taux) {
        //     return redirect()->back()->with('error', 'Merci de saisir les Taux');
        // }

        // if (!$rapport->piece) {
        //     return redirect()->back()->with('error', 'Merci de affecter les piece');
        // }

        $devis = Devis::where('dossier_id', $dossier->id)->first();
        $facture = Facture::where('dossier_id', $dossier->id)->first();
        $adpt = 0;
        $org = 0;
        $recup = 0;
        $montantpieces = 0;
        $vet = 0;
        $tva = 0;
        $ttc = 0;
        $fr = 0;
        $ttl = 0;
        $fr = 0;
        $taux = 0;
        $montantclient = 0;
        $montantcompany = 0;
        $tvaa = 0;
        $tvaa2 = 0;
        $main01 = 0;
        $main02 = 0;
        $main03 = 0;
        $main04 = 0;
        $main05 = 0;
        $main06 = 0;
        $main07 = 0;
        $ingr = 0;
        $sum = 0;
        $rem = 0;
        $remise = 0;
        $remisef = 0;
        $ht = 0;
        $montantpieces = 0;
        $chock = Document::where('dossier_id', $dossier->id)->where('type_document_id', 18)->first();
        $observations = Observation::where('dossier_id', $dossier->id)->where('for_rapport', 1)->get();
        foreach ($rapport->piece as $p) {
            if ($p->pivot->type_reparation_id == 1) {
                $recup += $p->pivot->prix_unitaire * $p->pivot->qte;
            }
            if ($p->pivot->type_reparation_id == 2) {
                $adpt += $p->pivot->prix_unitaire * $p->pivot->qte;
            }
            if ($p->pivot->type_reparation_id == 3) {
                $org += $p->pivot->prix_unitaire * $p->pivot->qte;
            }
        }
        if ($dossier->type_expertise_id != 14 && $dossier->mode_id != 7) {

            if ($rapport->piece) {
                foreach ($rapport->piece as $piece) {
                    if ($piece->pivot->type_reparation_id == 1) {
                        $montantpieces = $montantpieces + ($piece->pivot->prix_unitaire * $piece->pivot->qte);
                        $montantpieces = $montantpieces - ($piece->pivot->qte * $piece->pivot->prix_unitaire * $piece->pivot->remise / 100);
                        $remise = $remise + (($piece->pivot->qte * $piece->pivot->prix_unitaire * $piece->pivot->remise) / 100);
                        $vet = $vet +   ($piece->pivot->qte * $piece->pivot->prix_unitaire * $piece->pivot->vetuste / 100);
                    } else {
                        $rem = ($piece->pivot->qte * $piece->pivot->prix_unitaire) * ($piece->pivot->remise / 100);
                        $remise = $remise + $rem;

                        $tvaa = ($piece->pivot->prix_unitaire * $piece->pivot->qte - $rem) * 0.2;
                        $montantpieces = $montantpieces + ($piece->pivot->prix_unitaire * $piece->pivot->qte - $rem) + $tvaa;

                        // $montantpieces = $montantpieces - ($piece->pivot->qte * $piece->pivot->prix_unitaire * $piece->pivot->remise / 100);
                        $tvaa2 += $tvaa;
                        if ($rapport->taux) {
                            if ($rapport->taux->tva_deductible) {
                                $vet = $vet +   (($piece->pivot->qte * $piece->pivot->prix_unitaire) - $rem) * ($piece->pivot->vetuste / 100);
                            } else {
                                $vet = $vet +   ($piece->pivot->qte * $piece->pivot->prix_unitaire - $rem + $tvaa)  * ($piece->pivot->vetuste / 100);
                            }
                        } else {
                            $vet = $vet +   ($piece->pivot->qte * $piece->pivot->prix_unitaire - $rem) * ($piece->pivot->vetuste / 100);
                        }
                    }
                }
            }
            // else {
            //     return redirect()->back()->with('Merci de Ajouter Pieces au Rapport');
            // }
            // if ($rapport->taux) {
            //     if ($rapport->taux->tva_deductible) {
            //         $montantpieces = $montantpieces - $tvaa2;
            //     }
            // }
            // dd($tvaa2 , $montantpieces);

            if ($rapport->taux) {
                $remisep = ($rapport->taux->taux_mo_peinture * $rapport->taux->tp * $rapport->taux->remise_sur_total_mo_peinture) / 100;
                $montantpieces = $montantpieces - $remisep;
                $remise = $remise + $remisep;

                if ($rapport->taux->taux_ing) {
                    $taux_ing_metal = $rapport->taux->taux_ing_metal + $rapport->taux->taux_ing_metal * 0.2;
                    $taux_ing_metal_vernis = $rapport->taux->taux_ing_metal_vernis + $rapport->taux->taux_ing_metal_vernis * 0.2;
                    $taux_ing_nacre_vernis = $rapport->taux->taux_ing_nacre_vernis + $rapport->taux->taux_ing_nacre_vernis * 0.2;
                    $taux_ing_opaque = $rapport->taux->taux_ing_opaque + $rapport->taux->taux_ing_opaque * 0.2;
                    $taux_ing_opaque_vernis = $rapport->taux->taux_ing_opaque_vernis + $rapport->taux->taux_ing_opaque_vernis * 0.2;

                    $tva = $tvaa2 + $rapport->taux->taux_ing_opaque_vernis * 0.2 + $rapport->taux->taux_ing_opaque * 0.2 + $rapport->taux->taux_ing_nacre_vernis * 0.2 + $rapport->taux->taux_ing_metal_vernis * 0.2 + $rapport->taux->taux_ing_metal * 0.2;
                } else {
                    $taux_ing_metal = $rapport->taux->taux_ing_metal;
                    $taux_ing_metal_vernis = $rapport->taux->taux_ing_metal_vernis;
                    $taux_ing_nacre_vernis = $rapport->taux->taux_ing_nacre_vernis;
                    $taux_ing_opaque = $rapport->taux->taux_ing_opaque;
                    $taux_ing_opaque_vernis = $rapport->taux->taux_ing_opaque_vernis;
                    $tva = $tva + $tvaa2;
                }
                if ($rapport->taux->taux_tva) {
                    $main01 = $rapport->taux->taux_1 * $rapport->taux->t1 + $rapport->taux->taux_1 * $rapport->taux->t1 * 0.2;
                    $main02 = $rapport->taux->taux_2 * $rapport->taux->t2 + $rapport->taux->taux_2 * $rapport->taux->t2 * 0.2;
                    $main03 = $rapport->taux->taux_3 * $rapport->taux->t3 + $rapport->taux->taux_3 * $rapport->taux->t3 * 0.2;
                    $main04 = $rapport->taux->taux_mo_peinture * $rapport->taux->tp + $rapport->taux->taux_mo_peinture * $rapport->taux->tp * 0.2;
                    $main05 = $rapport->taux->taux_electricite * $rapport->taux->te + $rapport->taux->taux_electricite * $rapport->taux->te * 0.2;
                    $main06 = $rapport->taux->taux_controle * $rapport->taux->tc + $rapport->taux->taux_controle * $rapport->taux->tc * 0.2;
                    $main07 = $rapport->taux->taux_mecanique * $rapport->taux->tm + $rapport->taux->taux_mecanique * $rapport->taux->tm * 0.2;
                    $tva += $rapport->taux->taux_mecanique * $rapport->taux->tm * 0.2 + $rapport->taux->taux_controle * $rapport->taux->tc * 0.2 + $rapport->taux->taux_electricite * $rapport->taux->te * 0.2 + $rapport->taux->taux_mo_peinture * $rapport->taux->tp * 0.2 + $rapport->taux->taux_3 * $rapport->taux->t3 * 0.2 + $rapport->taux->taux_2 * $rapport->taux->t2 * 0.2 + $rapport->taux->taux_1 * $rapport->taux->t1 * 0.2;
                    $ingr = $taux_ing_metal + $taux_ing_metal_vernis + $taux_ing_nacre_vernis + $taux_ing_opaque + $taux_ing_opaque_vernis;
                    $sum =  $main01 + $main02 + $main03 + $main04 + $main05 + $main06 + $main07 + $ingr + $montantpieces;
                    $remisef = $rapport->taux->remise_facture + ($sum * ($rapport->taux->remise_facture1 / 100));
                    $fr =  $rapport->taux->franchise + (($sum)  * ($rapport->taux->franchise_fix / 100));
                    $ttl = $sum;
                } else {
                    $main01 = $rapport->taux->taux_1 * $rapport->taux->t1;
                    $main02 = $rapport->taux->taux_2 * $rapport->taux->t2;
                    $main03 = $rapport->taux->taux_3 * $rapport->taux->t3;
                    $main04 = $rapport->taux->taux_mo_peinture * $rapport->taux->tp;
                    $main05 = $rapport->taux->taux_electricite * $rapport->taux->te;
                    $main06 = $rapport->taux->taux_controle * $rapport->taux->tc;
                    $main07 = $rapport->taux->taux_mecanique * $rapport->taux->tm;
                    $ingr = $taux_ing_metal + $taux_ing_metal_vernis + $taux_ing_nacre_vernis + $taux_ing_opaque + $taux_ing_opaque_vernis;
                    $sum =  $main01 + $main02 + $main03 + $main04 + $main05 + $main06 + $main07 + $ingr + $montantpieces;
                    $remisef = $rapport->taux->remise_facture + ($sum * ($rapport->taux->remise_facture1 / 100));
                    $fr =  $rapport->taux->franchise + (($sum)  * ($rapport->taux->franchise_fix / 100));
                    $ttl = $sum;
                }

                $ht = $ttl - $tva;
                if ($rapport->taux->vetuste) {

                    if ($rapport->taux->tva_deductible) {
                        $montantclient =  $fr + $tva;
                        $montantcompany = $ttl - $tva - $vet - $fr;
                    } else {
                        $montantclient =  $fr;
                        $montantcompany = $ttl - $vet - $fr;
                    }
                } else {

                    if ($rapport->taux->tva_deductible) {
                        $montantclient = $vet + $fr + $tva;
                        $montantcompany = $ttl - $tva - $vet - $fr;
                    } else {
                        $montantclient = $vet + $fr;
                        $montantcompany = $ttl  - $vet - $fr;
                    }
                }
            }
            // else {
            //     return redirect()->back()->with('Merci de Ajouter Taux au Rapport');
            // }
        } else {
            if ($rapport->piece) {
                foreach ($rapport->piece as $piece) {
                    if ($piece->pivot->type_reparation_id == 1) {
                        $montantpieces = $montantpieces + ($piece->pivot->prix_unitaire * $piece->pivot->qte);
                        $montantpieces = $montantpieces - ($piece->pivot->qte * $piece->pivot->prix_unitaire * $piece->pivot->remise / 100);
                        $remise = $remise + (($piece->pivot->qte * $piece->pivot->prix_unitaire * $piece->pivot->remise) / 100);
                        $vet = $vet +   ($piece->pivot->qte * $piece->pivot->prix_unitaire * $piece->pivot->vetuste / 100);
                    } else {
                        $rem = ($piece->pivot->qte * $piece->pivot->prix_unitaire) * ($piece->pivot->remise / 100);
                        $remise = $remise + $rem;
                        $tvaa = ($piece->pivot->prix_unitaire * $piece->pivot->qte - $rem) * 0.2;
                        $montantpieces = $montantpieces + ($piece->pivot->prix_unitaire * $piece->pivot->qte - $rem) + $tvaa;

                        // $montantpieces = $montantpieces - ($piece->pivot->qte * $piece->pivot->prix_unitaire * $piece->pivot->remise / 100);
                        $tvaa2 += $tvaa;
                        if ($rapport->taux) {
                            if ($rapport->taux->tva_deductible) {
                                $vet = $vet +   (($piece->pivot->qte * $piece->pivot->prix_unitaire) - $rem) * ($piece->pivot->vetuste / 100);
                            } else {
                                $vet = $vet +   ($piece->pivot->qte * $piece->pivot->prix_unitaire - $rem + $tvaa)  * ($piece->pivot->vetuste / 100);
                            }
                        } else {
                            $vet = $vet +   ($piece->pivot->qte * $piece->pivot->prix_unitaire - $rem) * ($piece->pivot->vetuste / 100);
                        }
                    }
                }
            } else {
                return redirect()->back()->with('Merci de Ajouter Pieces au Rapport');
            }

            if ($rapport->taux) {
                // $montantpieces = $montantpieces - ($montantpieces * $rapport->taux->remise_piece / 100);
                $main01 =   $rapport->taux->forfait_mo_1;
                $main02 = $rapport->taux->forfait_mo_2;
                $main03 = $rapport->taux->forfait_mo_3;
                $main04 = $rapport->taux->forfait_peinture;
                $main05 = $rapport->taux->forfait_electricite;
                $main06 = $rapport->taux->forfait_controle;
                $main07 = $rapport->taux->forfait_mecanique;
                $ingr = $rapport->taux->forfait_ing_pieces;
                $sum = $main01 + $main02 + $main03 + $main04 + $main05 + $main06 + $main07 + $ingr + $montantpieces;
                $fr =  $rapport->taux->franchise + (($ttl)  * ($rapport->taux->franchise_fix / 100));
                $remisef = $rapport->taux->remise_facture + ($sum * ($rapport->taux->remise_facture1 / 100));
                $ttl = $sum;
                $ht = $ttl - $tva;
                if ($rapport->taux->vetuste) {

                    if ($rapport->taux->tva_deductible) {
                        $montantclient =  $fr + $tva;
                        $montantcompany = $ttl - $tva - $vet - $fr;
                    } else {
                        $montantclient =  $fr;
                        $montantcompany =  $ttl - $vet - $fr;
                    }
                } else {

                    if ($rapport->taux->tva_deductible) {
                        $montantclient = $vet + $fr + $tva;
                        $montantcompany = $ttl - $tva - $vet - $fr;
                    } else {
                        $montantclient = $vet + $fr;
                        $montantcompany = $ttl  - $vet - $fr;
                    }
                }
            } else {
                return redirect()->back()->with('Merci de Ajouter Taux au Rapport');
            }
        }
        $meeting = Meeting::where('dossier_id', $dossier->id)->where('meeting_status_id', 3)->first();
        $encours = Document::where('dossier_id', $dossier->id)->where('type_document_id', 7)->first();
        $apres = Document::where('dossier_id', $dossier->id)->where('type_document_id', 6)->first();

        $today = Carbon::now();
        $position = 0;
        $pdf = PDF::loadView('configuration.pdf.normalnew', compact('dossier', 'remise', 'encours', 'apres', 'devis', 'fr', 'vet', 'tva', 'observations', 'sign', 'rapport', 'chock', 'montantpieces', 'org', 'adpt', 'recup', 'ttl',  'main01', 'main02', 'main03', 'main04', 'main05', 'main06', 'main07', 'ingr', 'vet', 'montantclient', 'montantcompany', 'facture', 'meeting', 'position', 'ht'));

        return $pdf->stream();
    }

    public function avisdommage($id)
    {
        $dossier = Dossier::whereId($id)->with('rapport', 'document', 'company')->firstOrFail();
        if ($dossier->update != 0 && Auth::user()->role_id != 4 ||  $dossier->dossier_status_id == 3 && Auth::user()->role_id != 4) {
            return redirect()->route('Dossier.show', $dossier->id)->with('error', 'Dossier est interdit de le modifier Envoyer une demande a Admin ');
        }
        $today = Carbon::now();
        $pdf = Pdf::loadView('configuration.pdf.avis', compact('dossier', 'today'));
        $type = TypeDocument::whereId(17)->first();
        $filename = uniqid() . '.' . File::extension('pdf');
        $path = 'documents/' . $dossier->ref . '/' . $type->type . '/' . $filename;
        Storage::disk('s3')->put('documents/' . $dossier->ref . '/' . $type->type . '/' . $filename, $pdf->output());
        Document::updateOrCreate(['dossier_id' => $dossier->id, 'type_document_id' => $type->id], [
            'path' => $path,
        ]);
        $body = "A Génerer un Avis Dommage:" . $dossier->ref;
        Notification::create([
            'user_id' => Auth::user()->id,
            'dossier_id' => $dossier->id,
            'body' => $body
        ]);
        return $pdf->stream('s.pdf', compact('dossier', 'today'));
    }

    public function fft($id)
    {
        // dd($id);
        $dossier = Dossier::whereId($id)->with('lastmeet', 'document', 'company', 'garage')->firstOrFail();
        if ($dossier->update != 0 && Auth::user()->role_id != 4 ||  $dossier->dossier_status_id == 3 && Auth::user()->role_id != 4) {
            return redirect()->route('Dossier.show', $dossier->id)->with('error', 'Dossier est interdit de le modifier Envoyer une demande a Admin ');
        }
        if (!$dossier->garage) {
            return redirect()->back()->with('error', 'Merci de selectionner un garage');
        }
        $rapport = Rapport::with('piece', 'taux')->where('dossier_id', $dossier->id)->latest()->first();
        if (!$rapport) {
            return redirect()->back()->with('error', 'Besoin de Rapport');
        }
        $observations = Observation::where('dossier_id', $dossier->id)->get();
        $montantpieces = 0;
        $facture = Facture::where('dossier_id', $id)->where(function ($query) {
            $query->where('devis_status_id', 2)
                ->orWhere('devis_status_id', 7);
        })->with('facturestatus')->latest()->first();
        if (!$facture) {
            return redirect()->back()->with('error', 'Besoin de Facture Accord');
        }
        $org = 0;
        $recup = 0;
        $vet = 0;
        $adpt = 0;
        $tva = 0;
        $ttc = 0;
        $fr = 0;
        $ttl = 0;
        $ttlp = 0;
        $fr = 0;
        $tING = 0;
        $taux = 0;
        $montantclient = 0;
        $montantcompany = 0;
        $tvaa = 0;
        $tvaa2 = 0;
        foreach ($rapport->piece as $p) {
            if ($p->pivot->type_reparation_id == 1) {
                $recup += $p->pivot->prix_unitaire * $p->pivot->qte;
            }
            if ($p->pivot->type_reparation_id == 2) {
                $adpt += $p->pivot->prix_unitaire * $p->pivot->qte;
            }
            if ($p->pivot->type_reparation_id == 3) {
                $org += $p->pivot->prix_unitaire * $p->pivot->qte;
            }
        }
        if ($dossier->type_expertise_id != 14 && $dossier->mode_id != 7) {

            if ($rapport->piece) {
                foreach ($rapport->piece as $piece) {
                    if ($piece->pivot->type_reparation_id == 1) {
                        $montantpieces = $montantpieces + ($piece->pivot->prix_unitaire * $piece->pivot->qte);
                        $montantpieces = $montantpieces - ($piece->pivot->qte * $piece->pivot->prix_unitaire * $piece->pivot->remise / 100);
                        $vet = $vet +   ($piece->pivot->qte * $piece->pivot->prix_unitaire * $piece->pivot->vetuste / 100);
                    } else {
                        $rem = ($piece->pivot->qte * $piece->pivot->prix_unitaire) * ($piece->pivot->remise / 100);

                        $tvaa = ($piece->pivot->prix_unitaire * $piece->pivot->qte - $rem) * 0.2;
                        $montantpieces = $montantpieces + ($piece->pivot->prix_unitaire * $piece->pivot->qte - $rem) + $tvaa;

                        // $montantpieces = $montantpieces - ($piece->pivot->qte * $piece->pivot->prix_unitaire * $piece->pivot->remise / 100);
                        $tvaa2 += $tvaa;
                        if ($rapport->taux) {
                            if ($rapport->taux->tva_deductible) {
                                $vet = $vet +   (($piece->pivot->qte * $piece->pivot->prix_unitaire) - $rem) * ($piece->pivot->vetuste / 100);
                            } else {
                                $vet = $vet +   ($piece->pivot->qte * $piece->pivot->prix_unitaire - $rem + $tvaa)  * ($piece->pivot->vetuste / 100);
                            }
                        } else {
                            $vet = $vet +   ($piece->pivot->qte * $piece->pivot->prix_unitaire - $rem) * ($piece->pivot->vetuste / 100);
                        }
                    }
                }
            }
            // else {
            //     return redirect()->back()->with('Merci de Ajouter Pieces au Rapport');
            // }
            // if ($rapport->taux) {
            //     if ($rapport->taux->tva_deductible) {
            //         $montantpieces = $montantpieces - $tvaa2;
            //     }
            // }
            // dd($tvaa2 , $montantpieces);

            if ($rapport->taux) {
                $remisep = ($rapport->taux->taux_mo_peinture * $rapport->taux->tp * $rapport->taux->remise_sur_total_mo_peinture) / 100;
                $montantpieces = $montantpieces - $remisep;

                if ($rapport->taux->taux_ing) {
                    $taux_ing_metal = $rapport->taux->taux_ing_metal + $rapport->taux->taux_ing_metal * 0.2;
                    $taux_ing_metal_vernis = $rapport->taux->taux_ing_metal_vernis + $rapport->taux->taux_ing_metal_vernis * 0.2;
                    $taux_ing_nacre_vernis = $rapport->taux->taux_ing_nacre_vernis + $rapport->taux->taux_ing_nacre_vernis * 0.2;
                    $taux_ing_opaque = $rapport->taux->taux_ing_opaque + $rapport->taux->taux_ing_opaque * 0.2;
                    $taux_ing_opaque_vernis = $rapport->taux->taux_ing_opaque_vernis + $rapport->taux->taux_ing_opaque_vernis * 0.2;
                    $tING = $rapport->taux->taux_ing_metal + $rapport->taux->taux_ing_metal_vernis + $rapport->taux->taux_ing_nacre_vernis + $rapport->taux->taux_ing_opaque + $rapport->taux->taux_ing_opaque_vernis + $rapport->taux->forfait_ing_pieces;

                    $tva = $tvaa2 + $rapport->taux->taux_ing_opaque_vernis * 0.2 + $rapport->taux->taux_ing_opaque * 0.2 + $rapport->taux->taux_ing_nacre_vernis * 0.2 + $rapport->taux->taux_ing_metal_vernis * 0.2 + $rapport->taux->taux_ing_metal * 0.2;
                } else {
                    $taux_ing_metal = $rapport->taux->taux_ing_metal;
                    $taux_ing_metal_vernis = $rapport->taux->taux_ing_metal_vernis;
                    $taux_ing_nacre_vernis = $rapport->taux->taux_ing_nacre_vernis;
                    $taux_ing_opaque = $rapport->taux->taux_ing_opaque;
                    $taux_ing_opaque_vernis = $rapport->taux->taux_ing_opaque_vernis;
                    $tva = $tva + $tvaa2;
                }
                if ($rapport->taux->taux_tva) {
                    $main01 = $rapport->taux->taux_1 * $rapport->taux->t1 + $rapport->taux->taux_1 * $rapport->taux->t1 * 0.2;
                    $main02 = $rapport->taux->taux_2 * $rapport->taux->t2 + $rapport->taux->taux_2 * $rapport->taux->t2 * 0.2;
                    $main03 = $rapport->taux->taux_3 * $rapport->taux->t3 + $rapport->taux->taux_3 * $rapport->taux->t3 * 0.2;
                    $main04 = $rapport->taux->taux_mo_peinture * $rapport->taux->tp + $rapport->taux->taux_mo_peinture * $rapport->taux->tp * 0.2;
                    $main05 = $rapport->taux->taux_electricite * $rapport->taux->te + $rapport->taux->taux_electricite * $rapport->taux->te * 0.2;
                    $main06 = $rapport->taux->taux_controle * $rapport->taux->tc + $rapport->taux->taux_controle * $rapport->taux->tc * 0.2;
                    $main07 = $rapport->taux->taux_mecanique * $rapport->taux->tm + $rapport->taux->taux_mecanique * $rapport->taux->tm * 0.2;
                    $tva += $rapport->taux->taux_mecanique * $rapport->taux->tm * 0.2 + $rapport->taux->taux_controle * $rapport->taux->tc * 0.2 + $rapport->taux->taux_electricite * $rapport->taux->te * 0.2 + $rapport->taux->taux_mo_peinture * $rapport->taux->tp * 0.2 + $rapport->taux->taux_3 * $rapport->taux->t3 * 0.2 + $rapport->taux->taux_2 * $rapport->taux->t2 * 0.2 + $rapport->taux->taux_1 * $rapport->taux->t1 * 0.2;
                    $ingr = $taux_ing_metal + $taux_ing_metal_vernis + $taux_ing_nacre_vernis + $taux_ing_opaque + $taux_ing_opaque_vernis;
                    $sum =  $main01 + $main02 + $main03 + $main04 + $main05 + $main06 + $main07 + $ingr + $montantpieces;
                    $remise = $rapport->taux->remise_facture + ($sum * ($rapport->taux->remise_facture1 / 100));
                    $fr =  $rapport->taux->franchise + (($sum)  * ($rapport->taux->franchise_fix / 100));
                    $ttl = $sum;
                } else {
                    $main01 = $rapport->taux->taux_1 * $rapport->taux->t1;
                    $main02 = $rapport->taux->taux_2 * $rapport->taux->t2;
                    $main03 = $rapport->taux->taux_3 * $rapport->taux->t3;
                    $main04 = $rapport->taux->taux_mo_peinture * $rapport->taux->tp;
                    $main05 = $rapport->taux->taux_electricite * $rapport->taux->te;
                    $main06 = $rapport->taux->taux_controle * $rapport->taux->tc;
                    $main07 = $rapport->taux->taux_mecanique * $rapport->taux->tm;
                    $ingr = $taux_ing_metal + $taux_ing_metal_vernis + $taux_ing_nacre_vernis + $taux_ing_opaque + $taux_ing_opaque_vernis;
                    $sum =  $main01 + $main02 + $main03 + $main04 + $main05 + $main06 + $main07 + $ingr + $montantpieces;
                    $remise = $rapport->taux->remise_facture + ($sum * ($rapport->taux->remise_facture1 / 100));
                    $fr =  $rapport->taux->franchise + (($sum)  * ($rapport->taux->franchise_fix / 100));
                    $ttl = $sum;
                }
                $ht = $ttl - $tva;
                if ($rapport->taux->vetuste) {

                    if ($rapport->taux->tva_deductible) {
                        $montantclient =  $fr + $tva;
                        $montantcompany = $ttl - $tva - $vet - $fr;
                    } else {
                        $montantclient =  $fr;
                        $montantcompany =  $ttl - $vet - $fr;
                    }
                } else {

                    if ($rapport->taux->tva_deductible) {
                        $montantclient = $vet + $fr + $tva;
                        $montantcompany = $ttl - $tva - $vet - $fr;
                    } else {
                        $montantclient = $vet + $fr;
                        $montantcompany = $ttl  - $vet - $fr;
                    }
                }
            }
            // else {
            //     return redirect()->back()->with('Merci de Ajouter Taux au Rapport');
            // }
        } else {
            if ($rapport->piece) {
                foreach ($rapport->piece as $piece) {
                    if ($piece->pivot->type_reparation_id == 1) {
                        $montantpieces = $montantpieces + ($piece->pivot->prix_unitaire * $piece->pivot->qte);
                        $montantpieces = $montantpieces - ($piece->pivot->qte * $piece->pivot->prix_unitaire * $piece->pivot->remise / 100);

                        $vet = $vet +   ($piece->pivot->qte * $piece->pivot->prix_unitaire * $piece->pivot->vetuste / 100);
                    } else {
                        $rem = ($piece->pivot->qte * $piece->pivot->prix_unitaire) * ($piece->pivot->remise / 100);

                        $tvaa = ($piece->pivot->prix_unitaire * $piece->pivot->qte - $rem) * 0.2;
                        $montantpieces = $montantpieces + ($piece->pivot->prix_unitaire * $piece->pivot->qte - $rem) + $tvaa;

                        // $montantpieces = $montantpieces - ($piece->pivot->qte * $piece->pivot->prix_unitaire * $piece->pivot->remise / 100);
                        $tvaa2 += $tvaa;
                        if ($rapport->taux) {
                            if ($rapport->taux->tva_deductible) {
                                $vet = $vet +   (($piece->pivot->qte * $piece->pivot->prix_unitaire) - $rem) * ($piece->pivot->vetuste / 100);
                            } else {
                                $vet = $vet +   ($piece->pivot->qte * $piece->pivot->prix_unitaire - $rem + $tvaa)  * ($piece->pivot->vetuste / 100);
                            }
                        } else {
                            $vet = $vet +   ($piece->pivot->qte * $piece->pivot->prix_unitaire - $rem) * ($piece->pivot->vetuste / 100);
                        }
                    }
                }
            } else {
                return redirect()->back()->with('Merci de Ajouter Pieces au Rapport');
            }

            if ($rapport->taux) {
                // $montantpieces = $montantpieces - ($montantpieces * $rapport->taux->remise_piece / 100);
                $main01 =   $rapport->taux->forfait_mo_1;
                $main02 = $rapport->taux->forfait_mo_2;
                $main03 = $rapport->taux->forfait_mo_3;
                $main04 = $rapport->taux->forfait_peinture;
                $main05 = $rapport->taux->forfait_electricite;
                $main06 = $rapport->taux->forfait_controle;
                $main07 = $rapport->taux->forfait_mecanique;
                $ingr = $rapport->taux->forfait_ing_pieces;
                $sum = $main01 + $main02 + $main03 + $main04 + $main05 + $main06 + $main07 + $ingr + $montantpieces;
                $fr =  $rapport->taux->franchise + (($ttl)  * ($rapport->taux->franchise_fix / 100));
                $remise = $rapport->taux->remise_facture + ($sum * ($rapport->taux->remise_facture1 / 100));
                $ttl = $sum;
                $ht = $ttl - $tva;
                if ($rapport->taux->vetuste) {

                    if ($rapport->taux->tva_deductible) {
                        $montantclient =  $fr + $tva;
                        $montantcompany = $ttl - $tva - $vet - $fr;
                    } else {
                        $montantclient =  $fr;
                        $montantcompany =  $ttl - $vet - $fr;
                    }
                } else {

                    if ($rapport->taux->tva_deductible) {
                        $montantclient = $vet + $fr + $tva;
                        $montantcompany = $ttl - $tva - $vet - $fr;
                    } else {
                        $montantclient = $vet + $fr;
                        $montantcompany = $ttl  - $vet - $fr;
                    }
                }
            } else {
                return redirect()->back()->with('Merci de Ajouter Taux au Rapport');
            }
        }



        $now = Carbon::now();
        $pdf = Pdf::loadView('configuration.pdf.fft', compact('dossier', 'vet', 'ttl', 'tva', 'tING', 'montantpieces', 'montantclient', 'montantcompany', 'ttc', 'fr', 'taux', 'facture', 'now', 'ttl', 'tva', 'rapport'));
        $type = TypeDocument::whereId(13)->first();
        $filename = uniqid() . '.' . File::extension('pdf');
        $path = 'documents/' . $dossier->ref . '/' . $type->type . '/' . $filename;
        Storage::disk('s3')->put('documents/' . $dossier->ref . '/' . $type->type . '/' . $filename, $pdf->output());
        Document::updateOrCreate(['dossier_id' => $dossier->id, 'type_document_id' => $type->id], [
            'path' => $path,
        ]);
        $body = "A Génerer un Fiche Fin Traveaux:" . $dossier->ref;
        Notification::create([
            'user_id' => Auth::user()->id,
            'dossier_id' => $dossier->id,
            'body' => $body
        ]);
        return $pdf->stream('fft.pdf', compact('dossier', 'now'));
    }

    public function forfaitaire($id)
    {
        $sign = 1;
        $user = User::whereId(Auth::user()->id)->with('seuil')->first();
        $dossier = Dossier::whereId($id)->with('insured', 'opponent', 'vehiculemodel.brand', 'lastmeet', 'onerapport', 'montant')->withCount('shockpoint')->firstOrFail();
        if ($dossier->update != 0 && Auth::user()->role_id != 4 ||  $dossier->dossier_status_id == 3 && Auth::user()->role_id != 4) {
            return redirect()->route('Dossier.show', $dossier->id)->with('error', 'Dossier est interdit de le modifier Envoyer une demande a Admin ');
        }

        if ($dossier->mode_id != 7 && $dossier->type_expertise_id != 14) {
            return redirect()->route('Dossier.show', $dossier->id)->with('error', 'Dossier n est pas forfaitaire');
        }
        if ($dossier->shockpoint_count < 1) {
            return redirect()->route('Dossier.show', $dossier->id)->with('error', 'Ajouter les Points de chock');
        }
        $forf = Document::where('dossier_id', $id)->where('type_document_id', 16)->count();

        $devis = Devis::where('dossier_id', $id)->with('piece', 'taux')
            ->where('devis_status_id', 2)
            ->Orwhere('devis_status_id', 7)->latest()->first();
        $forfait = 0;

        if (!$devis) {
            return redirect()->back()->with('error', 'Besoin Devis Accord');
        }
        $adaptable = 0;
        $recup = 0;
        $origine = 0;
        $peinture = 0;
        $ttlp = 0;
        $ing = 0;

        if ($devis->piece) {
            foreach ($devis->piece as $piece) {
                if ($piece->type_reparation_id == 1) {
                    $adaptable++;
                } elseif ($piece->type_reparation_id == 2) {
                    $origine++;
                } elseif ($piece->type_reparation_id == 3) {
                    $recup++;
                } elseif ($piece->type_reparation_id == 4) {
                    $peinture++;
                }
                $ttlp = $ttlp + $piece->pivot->prix_unitaire * $piece->pivot->qte;
            }
        }

        $ttl = 0;
        $ttc = 0;
        // $ttlp = $ttlp - $ttlp * ($devis->taux->remise_piece / 100);
        $fr = 0;
        if ($devis->taux) {
            $forfait = $devis->taux->forfait_mo_1 + $devis->taux->forfait_mo_2 + $devis->taux->forfait_mo_3 + $devis->taux->forfait_mecanique + $devis->taux->forfait_electricite + $devis->taux->forfait_controle;
            $peinture = $devis->taux->forfait_peinture;
            $ing = $devis->taux->forfait_ing_pieces;
            $ttl = $ttlp + $forfait + $peinture + $ing;
            $fr = $devis->taux->franchise + ($ttl * $devis->taux->franchise_fix / 100);
        }
        $ttl = $dossier->montant->montant_accord;


        $chock = Document::where('dossier_id', $dossier->id)->where('type_document_id', 18)->first();
        $pdf = Pdf::loadView('configuration.pdf.forfait', compact('dossier',  'fr', 'forfait', 'ing', 'peinture', 'chock', 'devis', 'adaptable', 'origine', 'recup', 'peinture', 'ttc', 'ttlp', 'ttl', 'sign'));
        $type = TypeDocument::whereId(16)->first();
        $filename = uniqid() . '.' . File::extension('pdf');
        $path = 'documents/' . $dossier->ref . '/' . $type->type . '/' . $filename;
        Storage::disk('s3')->put('documents/' . $dossier->ref . '/' . $type->type . '/' . $filename, $pdf->output());
        $doc = Document::updateOrCreate(['dossier_id' => $dossier->id, 'type_document_id' => $type->id], [
            'path' => $path,
        ]);

        $body = "A Génerer un Rapport Forfaitaire :" . $dossier->ref;
        Notification::create([
            'user_id' => Auth::user()->id,
            'dossier_id' => $dossier->id,
            'body' => $body
        ]);

        return $pdf->stream('forfaitaire.pdf');
    }

    public function note($id)
    {
        $dossier = Dossier::whereId($id)->with('rapport', 'document', 'company')->firstOrFail();
        $pdf = Pdf::loadView('configuration.pdf.note', compact('dossier'));
        $body = "A Creer une Note Honoraire:" . $dossier->ref;
        Notification::create([
            'user_id' => Auth::user()->id,
            'dossier_id' => $dossier->id,
            'body' => $body
        ]);

        return $pdf->stream('noteHonoraire.pdf');
    }

    public function accord($id)
    {
        $devis = Devis::whereId($id)->with('piece', 'taux', 'montant')->first();
        $dossier = Dossier::whereId($devis->dossier_id)->with( 'company', 'typevehicule', 'vehiculemodel','montant')->firstOrFail();

        if ($dossier->update != 0 && Auth::user()->role_id != 4 ||  $dossier->dossier_status_id == 3 && Auth::user()->role_id != 4) {
            return redirect()->route('Dossier.show', $dossier->id)->with('error', 'Dossier est interdit de le modifier Envoyer une demande a Admin ');
        }

        $adpt = 0;
        $org = 0;
        $recup = 0;
        $montantpieces = 0;
        $vet = 0;
        $tva = 0;
        $ttc = 0;
        $fr = 0;
        $ttl = 0;
        $fr = 0;
        $taux = 0;
        $montantclient = 0;
        $montantcompany = 0;
        $tvaa = 0;
        $tvaa2 = 0;
        $main01 = 0;
        $main02 = 0;
        $main03 = 0;
        $main04 = 0;
        $main05 = 0;
        $main06 = 0;
        $main07 = 0;
        $ingr = 0;
        $sum = 0;
        $rem = 0;
        $remise = 0;
        $remisef = 0;
        $ht = 0;
        $montantpieces = 0;

        if ($devis->devis_status_id == 2 || $devis->devis_status_id == 7) {
            // if ($devis->taux || $devis->piece) {
            //     if ($devis->montant) {
            //         $ttl = $devis->montant->montant_accord;

            //     } else {
            //         $ttl = $dossier->montant->montant_accord;
            //     }
            //     $pdf = PDF::loadView('configuration.pdf.accord', compact('dossier', 'remise', 'devis', 'fr', 'vet', 'tva',  'montantpieces', 'org', 'adpt', 'recup', 'ttl',  'main01', 'main02', 'main03', 'main04', 'main05', 'main06', 'main07', 'ingr', 'vet', 'montantclient', 'montantcompany',  'ht'));
            //     return $pdf->stream('accord.pdf');
            // }

            if ($dossier->type_expertise_id != 14 && $dossier->mode_id != 7) {

                if ($devis->piece) {
                    foreach ($devis->piece as $piece) {
                        if ($piece->pivot->type_reparation_id == 1) {
                            $montantpieces = $montantpieces + ($piece->pivot->prix_unitaire * $piece->pivot->qte);
                            $montantpieces = $montantpieces - ($piece->pivot->qte * $piece->pivot->prix_unitaire * $piece->pivot->remise / 100);
                            $remise = $remise + (($piece->pivot->qte * $piece->pivot->prix_unitaire * $piece->pivot->remise) / 100);
                            $vet = $vet +   ($piece->pivot->qte * $piece->pivot->prix_unitaire * $piece->pivot->vetuste / 100);
                        } else {
                            $rem = ($piece->pivot->qte * $piece->pivot->prix_unitaire) * ($piece->pivot->remise / 100);
                            $remise = $remise + $rem;

                            $tvaa = ($piece->pivot->prix_unitaire * $piece->pivot->qte - $rem) * 0.2;
                            $montantpieces = $montantpieces + ($piece->pivot->prix_unitaire * $piece->pivot->qte - $rem) + $tvaa;

                            // $montantpieces = $montantpieces - ($piece->pivot->qte * $piece->pivot->prix_unitaire * $piece->pivot->remise / 100);
                            $tvaa2 += $tvaa;
                            if ($devis->taux) {
                                if ($devis->taux->tva_deductible) {
                                    $vet = $vet +   (($piece->pivot->qte * $piece->pivot->prix_unitaire) - $rem) * ($piece->pivot->vetuste / 100);
                                } else {
                                    $vet = $vet +   ($piece->pivot->qte * $piece->pivot->prix_unitaire - $rem + $tvaa)  * ($piece->pivot->vetuste / 100);
                                }
                            } else {
                                $vet = $vet +   ($piece->pivot->qte * $piece->pivot->prix_unitaire - $rem) * ($piece->pivot->vetuste / 100);
                            }
                        }
                    }
                } else {
                    return redirect()->back()->with('error', 'Merci de Ajouter Pieces au devis');
                }
                if ($devis->taux) {
                    if ($devis->taux->tva_deductible) {
                        $montantpieces = $montantpieces - $tvaa2;
                    }
                }

                if ($devis->taux) {
                    $remisep = ($devis->taux->taux_mo_peinture * $devis->taux->tp * $devis->taux->remise_sur_total_mo_peinture) / 100;
                    $montantpieces = $montantpieces - $remisep;
                    $remise = $remise + $remisep;

                    if ($devis->taux->taux_ing) {
                        $taux_ing_metal = $devis->taux->taux_ing_metal + $devis->taux->taux_ing_metal * 0.2;
                        $taux_ing_metal_vernis = $devis->taux->taux_ing_metal_vernis + $devis->taux->taux_ing_metal_vernis * 0.2;
                        $taux_ing_nacre_vernis = $devis->taux->taux_ing_nacre_vernis + $devis->taux->taux_ing_nacre_vernis * 0.2;
                        $taux_ing_opaque = $devis->taux->taux_ing_opaque + $devis->taux->taux_ing_opaque * 0.2;
                        $taux_ing_opaque_vernis = $devis->taux->taux_ing_opaque_vernis + $devis->taux->taux_ing_opaque_vernis * 0.2;

                        $tva = $tvaa2 + $devis->taux->taux_ing_opaque_vernis * 0.2 + $devis->taux->taux_ing_opaque * 0.2 + $devis->taux->taux_ing_nacre_vernis * 0.2 + $devis->taux->taux_ing_metal_vernis * 0.2 + $devis->taux->taux_ing_metal * 0.2;
                    } else {
                        $taux_ing_metal = $devis->taux->taux_ing_metal;
                        $taux_ing_metal_vernis = $devis->taux->taux_ing_metal_vernis;
                        $taux_ing_nacre_vernis = $devis->taux->taux_ing_nacre_vernis;
                        $taux_ing_opaque = $devis->taux->taux_ing_opaque;
                        $taux_ing_opaque_vernis = $devis->taux->taux_ing_opaque_vernis;
                        $tva = $tva + $tvaa2;
                    }
                    if ($devis->taux->taux_tva) {
                        $main01 = $devis->taux->taux_1 * $devis->taux->t1 + $devis->taux->taux_1 * $devis->taux->t1 * 0.2;
                        $main02 = $devis->taux->taux_2 * $devis->taux->t2 + $devis->taux->taux_2 * $devis->taux->t2 * 0.2;
                        $main03 = $devis->taux->taux_3 * $devis->taux->t3 + $devis->taux->taux_3 * $devis->taux->t3 * 0.2;
                        $main04 = $devis->taux->taux_mo_peinture * $devis->taux->tp + $devis->taux->taux_mo_peinture * $devis->taux->tp * 0.2;
                        $main05 = $devis->taux->taux_electricite * $devis->taux->te + $devis->taux->taux_electricite * $devis->taux->te * 0.2;
                        $main06 = $devis->taux->taux_controle * $devis->taux->tc + $devis->taux->taux_controle * $devis->taux->tc * 0.2;
                        $main07 = $devis->taux->taux_mecanique * $devis->taux->tm + $devis->taux->taux_mecanique * $devis->taux->tm * 0.2;
                        $tva += $devis->taux->taux_mecanique * $devis->taux->tm * 0.2 + $devis->taux->taux_controle * $devis->taux->tc * 0.2 + $devis->taux->taux_electricite * $devis->taux->te * 0.2 + $devis->taux->taux_mo_peinture * $devis->taux->tp * 0.2 + $devis->taux->taux_3 * $devis->taux->t3 * 0.2 + $devis->taux->taux_2 * $devis->taux->t2 * 0.2 + $devis->taux->taux_1 * $devis->taux->t1 * 0.2;
                        $ingr = $taux_ing_metal + $taux_ing_metal_vernis + $taux_ing_nacre_vernis + $taux_ing_opaque + $taux_ing_opaque_vernis;
                        $sum =  $main01 + $main02 + $main03 + $main04 + $main05 + $main06 + $main07 + $ingr + $montantpieces;
                        $remisef = $devis->taux->remise_facture + ($sum * ($devis->taux->remise_facture1 / 100));
                        $fr =  $devis->taux->franchise + (($sum)  * ($devis->taux->franchise_fix / 100));
                        $ttl = $sum;
                    } else {
                        $main01 = $devis->taux->taux_1 * $devis->taux->t1;
                        $main02 = $devis->taux->taux_2 * $devis->taux->t2;
                        $main03 = $devis->taux->taux_3 * $devis->taux->t3;
                        $main04 = $devis->taux->taux_mo_peinture * $devis->taux->tp;
                        $main05 = $devis->taux->taux_electricite * $devis->taux->te;
                        $main06 = $devis->taux->taux_controle * $devis->taux->tc;
                        $main07 = $devis->taux->taux_mecanique * $devis->taux->tm;
                        $ingr = $taux_ing_metal + $taux_ing_metal_vernis + $taux_ing_nacre_vernis + $taux_ing_opaque + $taux_ing_opaque_vernis;
                        $sum =  $main01 + $main02 + $main03 + $main04 + $main05 + $main06 + $main07 + $ingr + $montantpieces;
                        $remisef = $devis->taux->remise_facture + ($sum * ($devis->taux->remise_facture1 / 100));
                        $fr =  $devis->taux->franchise + (($sum)  * ($devis->taux->franchise_fix / 100));
                        $ttl = $sum;
                    }

                    $ht = $ttl - $tva;
                    if ($devis->taux->vetuste) {

                        if ($devis->taux->tva_deductible) {
                            $montantclient =  $fr + $tva;
                            $montantcompany = $ttl - $tva + $vet - $fr;
                        } else {
                            $montantclient =  $fr;
                            $montantcompany = $vet + $ttl - $fr;
                        }
                    } else {

                        if ($devis->taux->tva_deductible) {
                            $montantclient = $vet + $fr + $tva;
                            $montantcompany = $ttl - $tva - $vet - $fr;
                        } else {
                            $montantclient = $vet + $fr;
                            $montantcompany = $ttl  - $vet - $fr;
                        }
                    }
                } else {
                    return redirect()->back()->with('error', 'Merci de Ajouter Taux au devis');
                }

                $pdf = PDF::loadView('configuration.pdf.accord', compact('dossier', 'remise', 'devis', 'fr', 'vet', 'tva',  'montantpieces', 'org', 'adpt', 'recup', 'ttl',  'main01', 'main02', 'main03', 'main04', 'main05', 'main06', 'main07', 'ingr', 'vet', 'montantclient', 'montantcompany',  'ht'));
                return $pdf->stream('accord.pdf');
            } else {
                if ($devis->piece) {
                    foreach ($devis->piece as $piece) {
                        if ($piece->pivot->type_reparation_id == 1) {
                            $montantpieces = $montantpieces + ($piece->pivot->prix_unitaire * $piece->pivot->qte);
                            $montantpieces = $montantpieces - ($piece->pivot->qte * $piece->pivot->prix_unitaire * $piece->pivot->remise / 100);
                            $remise = $remise + (($piece->pivot->qte * $piece->pivot->prix_unitaire * $piece->pivot->remise) / 100);
                            $vet = $vet +   ($piece->pivot->qte * $piece->pivot->prix_unitaire * $piece->pivot->vetuste / 100);
                        } else {
                            $rem = ($piece->pivot->qte * $piece->pivot->prix_unitaire) * ($piece->pivot->remise / 100);
                            $remise = $remise + $rem;
                            $tvaa = ($piece->pivot->prix_unitaire * $piece->pivot->qte - $rem) * 0.2;
                            $montantpieces = $montantpieces + ($piece->pivot->prix_unitaire * $piece->pivot->qte - $rem) + $tvaa;

                            // $montantpieces = $montantpieces - ($piece->pivot->qte * $piece->pivot->prix_unitaire * $piece->pivot->remise / 100);
                            $tvaa2 += $tvaa;
                            if ($devis->taux) {
                                if ($devis->taux->tva_deductible) {
                                    $vet = $vet +   (($piece->pivot->qte * $piece->pivot->prix_unitaire) - $rem) * ($piece->pivot->vetuste / 100);
                                } else {
                                    $vet = $vet +   ($piece->pivot->qte * $piece->pivot->prix_unitaire - $rem + $tvaa)  * ($piece->pivot->vetuste / 100);
                                }
                            } else {
                                $vet = $vet +   ($piece->pivot->qte * $piece->pivot->prix_unitaire - $rem) * ($piece->pivot->vetuste / 100);
                            }
                        }
                    }
                } else {
                    return redirect()->back()->with('error', 'Merci de Ajouter Pieces au Devis');
                }

                if ($devis->taux) {
                    // $montantpieces = $montantpieces - ($montantpieces * $devis->taux->remise_piece / 100);
                    $main01 =   $devis->taux->forfait_mo_1;
                    $main02 = $devis->taux->forfait_mo_2;
                    $main03 = $devis->taux->forfait_mo_3;
                    $main04 = $devis->taux->forfait_peinture;
                    $main05 = $devis->taux->forfait_electricite;
                    $main06 = $devis->taux->forfait_controle;
                    $main07 = $devis->taux->forfait_mecanique;
                    $ingr = $devis->taux->forfait_ing_pieces;
                    $sum = $main01 + $main02 + $main03 + $main04 + $main05 + $main06 + $main07 + $ingr + $montantpieces;
                    $fr =  $devis->taux->franchise + (($ttl)  * ($devis->taux->franchise_fix / 100));
                    $remisef = $devis->taux->remise_facture + ($sum * ($devis->taux->remise_facture1 / 100));
                    $ttl = $sum;
                    $ht = $ttl - $tva;
                    if ($devis->taux->vetuste) {

                        if ($devis->taux->tva_deductible) {
                            $montantclient =  $fr + $tva;
                            $montantcompany = $ttl - $tva + $vet - $fr;
                        } else {
                            $montantclient =  $fr;
                            $montantcompany = $vet + $ttl - $fr;
                        }
                    } else {

                        if ($devis->taux->tva_deductible) {
                            $montantclient = $vet + $fr + $tva;
                            $montantcompany = $ttl - $tva - $vet - $fr;
                        } else {
                            $montantclient = $vet + $fr;
                            $montantcompany = $ttl  - $vet - $fr;
                        }
                    }
                } else {
                    return redirect()->back()->with('error', 'Merci de Ajouter Taux au Devis');
                }

                $pdf = PDF::loadView('configuration.pdf.accord', compact('dossier', 'remise', 'devis', 'fr', 'vet', 'tva',  'montantpieces', 'org', 'adpt', 'recup', 'ttl',  'main01', 'main02', 'main03', 'main04', 'main05', 'main06', 'main07', 'ingr', 'vet', 'montantclient', 'montantcompany',  'ht'));
                return $pdf->stream('accord.pdf');
            }
        } else {
            return redirect()->back()->with('error', 'Besoin accord');
        }
    }


    public function preliminaire($id)
    {
        $dossier = Dossier::whereId($id)->with('document', 'devis', 'company', 'typevehicule', 'vehiculemodel')->firstOrFail();
        if ($dossier->update != 0 && Auth::user()->role_id != 4 ||  $dossier->dossier_status_id == 3 && Auth::user()->role_id != 4) {
            return redirect()->route('Dossier.show', $dossier->id)->with('error', 'Dossier est interdit de le modifier Envoyer une demande a Admin ');
        }
        $deviscount = Devis::where('dossier_id', $id)->where(function ($query) {
            $query->where('devis_status_id', 2)
                ->orWhere('devis_status_id', 7);
        })->count();
        if ($deviscount == 0) {
            return redirect()->back()->with('error', 'en Attente de Accord de devis');
        }
        $devis = Devis::where('dossier_id', $id)->with('piece', 'taux', 'montant')->where(function ($query) {
            $query->where('devis_status_id', 2)
                ->orWhere('devis_status_id', 7);
        })->latest()->first();
        $ttl = 0;
        $vet = 0;
        $ttc = 0;
        $tvaa2 = 0;
        $tva = 0;
        $main01 = 0;
        $main02 = 0;
        $main03 = 0;
        $main04 = 0;
        $main05 = 0;
        $main06 = 0;
        $main07 = 0;
        $ingr = 0;
        $vet = 0;
        $sum = 0;
        $montantpieces = 0;
        $remisep = 0;
        $mo = 0;
        $dif = 0;

        if ($devis->piece) {
            foreach ($devis->piece as $piece) {

                if ($piece->pivot->type_reparation_id == 1) {
                    $montantpieces = $montantpieces + ($piece->pivot->prix_unitaire * $piece->pivot->qte);
                } else {
                    $tvaa = $piece->pivot->prix_unitaire * $piece->pivot->qte * 0.2;
                    $montantpieces = $montantpieces + ($piece->pivot->prix_unitaire * $piece->pivot->qte + $tvaa);
                    $tvaa2 += $tvaa;
                }
                $vet = $vet +   ($piece->pivot->qte * $piece->pivot->prix_unitaire * $piece->pivot->vetuste / 100) + ($piece->pivot->qte * $piece->pivot->prix_unitaire * $piece->pivot->remise / 100);
            }
            if ($devis->taux) {
                if ($devis->taux->tva_deductible) {
                    $montantpieces = $montantpieces - $tvaa2;
                }
            }
        } else {
            $ttc = $devis->montant->montant_accord;
            $pdf = Pdf::loadView('configuration.pdf.preliminaire', compact('dossier', 'ttc', 'dif', 'ttl', 'main01', 'main02', 'main03', 'tva', 'main04', 'main05', 'main06', 'main07', 'ingr', 'vet', 'montantpieces'));
            $type = TypeDocument::whereId(15)->first();
            $filename = uniqid() . '.' . File::extension('pdf');
            $path = 'documents/' . $dossier->ref . '/' . $type->type . '/' . $filename;
            Storage::disk('s3')->put('documents/' . $dossier->ref . '/' . $type->type . '/' . $filename, $pdf->output());
            Document::updateOrCreate(['dossier_id' => $dossier->id, 'type_document_id' => $type->id], [
                'path' => $path,
            ]);
            $body = "A Génerer un Rapport Preliminaire :" . $devis->dossier->ref;
            Notification::create([
                'user_id' => Auth::user()->id,
                'dossier_id' => $devis->dossier->id,
                'body' => $body
            ]);
            return $pdf->stream();
        }
        // dd($tvaa2);

        if ($devis->taux) {
            // $remisep = ($piece->taux->taux_mo_peinture  * $piece->taux->tp  * $piece->taux->remise_sur_total_mo_peinture) / 100;
            if ($devis->taux->taux_tva) {
                $main01 = $devis->taux->taux_1 * $devis->taux->t1 + $devis->taux->taux_1 * $devis->taux->t1 * 0.2;
                $main02 = $devis->taux->taux_2 * $devis->taux->t2 + $devis->taux->taux_2 * $devis->taux->t2 * 0.2;
                $main03 = $devis->taux->taux_3 * $devis->taux->t3 + $devis->taux->taux_3 * $devis->taux->t3 * 0.2;
                $main04 = $devis->taux->taux_mo_peinture * $devis->taux->tp + $devis->taux->taux_mo_peinture * $devis->taux->tp * 0.2 - $remisep;
                $main05 = $devis->taux->taux_electricite * $devis->taux->te + $devis->taux->taux_electricite * $devis->taux->te * 0.2;
                $main06 = $devis->taux->taux_controle * $devis->taux->tc + $devis->taux->taux_controle * $devis->taux->tc * 0.2;
                $main07 = $devis->taux->taux_mecanique * $devis->taux->tm + $devis->taux->taux_mecanique * $devis->taux->tm * 0.2;
                $tva += $devis->taux->taux_mecanique * $devis->taux->tm * 0.2 + $devis->taux->taux_controle * $devis->taux->tc * 0.2 + $devis->taux->taux_electricite * $devis->taux->te * 0.2 + $devis->taux->taux_mo_peinture * $devis->taux->tp * 0.2 + $devis->taux->taux_3 * $devis->taux->t3 * 0.2 + $devis->taux->taux_2 * $devis->taux->t2 * 0.2 + $devis->taux->taux_1 * $devis->taux->t1 * 0.2;
                $mo =  $main01 + $main02 + $main03 + $main04 + $main05 + $main06 + $main07;
            } else {
                $main01 = $devis->taux->taux_1 * $devis->taux->t1;
                $main02 = $devis->taux->taux_2 * $devis->taux->t2;
                $main03 = $devis->taux->taux_3 * $devis->taux->t3;
                $main04 = $devis->taux->taux_mo_peinture * $devis->taux->tp;
                $main05 = $devis->taux->taux_electricite * $devis->taux->te;
                $main06 = $devis->taux->taux_controle * $devis->taux->tc;
                $main07 = $devis->taux->taux_mecanique * $devis->taux->tm;
                $mo = $main01  + $main02 + $main03 + $main04 + $main05 + $main06 + $main07;
            }


            if ($devis->taux->taux_ing) {
                $taux_ing_metal = $devis->taux->taux_ing_metal + $devis->taux->taux_ing_metal * 0.2;
                $taux_ing_metal_vernis = $devis->taux->taux_ing_metal_vernis + $devis->taux->taux_ing_metal_vernis * 0.2;
                $taux_ing_nacre_vernis = $devis->taux->taux_ing_nacre_vernis + $devis->taux->taux_ing_nacre_vernis * 0.2;
                $taux_ing_opaque = $devis->taux->taux_ing_opaque + $devis->taux->taux_ing_opaque * 0.2;
                $taux_ing_opaque_vernis = $devis->taux->taux_ing_opaque_vernis + $devis->taux->taux_ing_opaque_vernis * 0.2;
                $ingr = $taux_ing_metal + $taux_ing_metal_vernis + $taux_ing_nacre_vernis + $taux_ing_opaque + $taux_ing_opaque_vernis;
                $tva = $tvaa2 + $devis->taux->taux_ing_opaque_vernis * 0.2 + $devis->taux->taux_ing_opaque * 0.2 + $devis->taux->taux_ing_nacre_vernis * 0.2 + $devis->taux->taux_ing_metal_vernis * 0.2 + $devis->taux->taux_ing_metal * 0.2;
            } else {
                $taux_ing_metal = $devis->taux->taux_ing_metal;
                $taux_ing_metal_vernis = $devis->taux->taux_ing_metal_vernis;
                $taux_ing_nacre_vernis = $devis->taux->taux_ing_nacre_vernis;
                $taux_ing_opaque = $devis->taux->taux_ing_opaque;
                $taux_ing_opaque_vernis = $devis->taux->taux_ing_opaque_vernis;
                $tva = $tva + $tvaa2;
                $ingr = $taux_ing_metal + $taux_ing_metal_vernis + $taux_ing_nacre_vernis + $taux_ing_opaque + $taux_ing_opaque_vernis;
            }
            // dd($mo,$ingr);

            // $sum =  $main01 + $main02 + $main03 + $main04 + $main05 + $main06 + $main07 + $ingr + $montantpieces;
            $sum = $mo + $ingr + $montantpieces;;

            $remise = $devis->taux->remise_facture + ($sum * ($devis->taux->remise_facture1 / 100));
            $fr =  $devis->taux->franchise + (($sum)  * ($devis->taux->franchise_fix / 100));
            $ttc = $sum;
        } else {
            $ttc = $devis->montant->montant_accord;
            $pdf = Pdf::loadView('configuration.pdf.preliminaire', compact('dossier', 'ttc', 'dif', 'ttl', 'main01', 'main02', 'main03', 'main04', 'main05', 'main06', 'main07', 'ingr', 'vet', 'tva', 'montantpieces'));
            $type = TypeDocument::whereId(15)->first();
            $filename = uniqid() . '.' . File::extension('pdf');
            $path = 'documents/' . $dossier->ref . '/' . $type->type . '/' . $filename;
            Storage::disk('s3')->put('documents/' . $dossier->ref . '/' . $type->type . '/' . $filename, $pdf->output());
            Document::updateOrCreate(['dossier_id' => $dossier->id, 'type_document_id' => $type->id], [
                'path' => $path,
            ]);
            $body = "A Génerer un Rapport Preliminaire :" . $devis->dossier->ref;
            Notification::create([
                'user_id' => Auth::user()->id,
                'dossier_id' => $devis->dossier->id,
                'body' => $body
            ]);
            return $pdf->stream();
        }
        $dif = $dossier->valeurvenale - $dossier->valeurepave;
        $pdf = Pdf::loadView('configuration.pdf.preliminaire', compact('dossier', 'ttc', 'dif', 'ttl', 'main01', 'main02', 'main03', 'main04', 'tva', 'main05', 'main06', 'main07', 'ingr', 'vet', 'montantpieces'));
        $type = TypeDocument::whereId(15)->first();
        $filename = uniqid() . '.' . File::extension('pdf');
        $path = 'documents/' . $dossier->ref . '/' . $type->type . '/' . $filename;
        Storage::disk('s3')->put('documents/' . $dossier->ref . '/' . $type->type . '/' . $filename, $pdf->output());
        Document::updateOrCreate(['dossier_id' => $dossier->id, 'type_document_id' => $type->id], [
            'path' => $path,
        ]);
        $body = "A Génerer un Rapport Preliminaire :" . $devis->dossier->ref;
        Notification::create([
            'user_id' => Auth::user()->id,
            'dossier_id' => $devis->dossier->id,
            'body' => $body
        ]);

        return $pdf->stream('preliminaire.pdf');
    }

    public function reformeTechnique(Request $request, $id)
    {
        // dd($request);
        $array_img = $request->img;
        $array_body = $request->body;
        $array = [];
        // dd($array_img);
        for ($i = 0; $i < count($array_img); $i++) {
            if ($array_body[$i] != null) {
                array_push($array, array('img' => $array_img[$i], 'body' => $array_body[$i]));
            }
        }

        $conclusion = $request->conclusion;
        $dommage = $request->dommage;


        // $document = Document::whereIn('type_document_id', [5, 6, 7])->first();
        $dossier = Dossier::whereId($id)->firstOrFail();
        $chock = Document::where('dossier_id', $dossier->id)->where('type_document_id', 18)->first();

        if (!$chock) {
            return redirect()->route('Dossier.show', $dossier->id)->with('error', 'Merci de selectionner les Point de chock Avant le rapport  ');
        }
        if ($request->voiture) {
            $voiture = Document::where('dossier_id', $dossier->id)->whereId($request->voiture)->first();
        } else {
            $voiture = Document::where('dossier_id', $dossier->id)->where('type_document_id', 18)->first();
        }
        if ($dossier->update != 0 && Auth::user()->role_id != 4 ||  $dossier->dossier_status_id == 3 && Auth::user()->role_id != 4) {
            return redirect()->route('Dossier.show', $dossier->id)->with('error', 'Dossier est interdit de le modifier Envoyer une demande a Admin ');
        }

        $today = Carbon::today();

        if ($dossier->dossier_status_id == 3 && Auth::user()->role_id != 4) {
            return redirect()->route('Dossier.show', $dossier->id)->with('error', 'Dossier est interdit de le modifier Envoyer une demande a Admin ');
        }
        $pdf = Pdf::loadView('configuration.pdf.reformeTechnique', compact('array', 'conclusion', 'dommage',  'dossier', 'today', 'chock', 'voiture',));

        $type = TypeDocument::whereId(14)->first();
        $filename = uniqid() . '.' . File::extension('pdf');
        $path = 'documents/' . $dossier->ref . '/' . $type->type . '/' . $filename;
        Storage::disk('s3')->put('documents/' . $dossier->ref . '/' . $type->type . '/' . $filename, $pdf->output());
        Document::updateOrCreate(['dossier_id' => $dossier->id, 'type_document_id' => $type->id], [
            'path' => $path,
        ]);

        $body = "A Créer un Rapport  Technique :" . $dossier->ref;
        Notification::create([
            'user_id' => Auth::user()->id,
            'dossier_id' => $dossier->id,
            'body' => $body
        ]);

        return redirect()->route('dossier.ref', $dossier->id);
    }

    // public function reforme($id)
    // {
    //     $dossier = Dossier::whereId($id)->with('rapport', 'document', 'company')->firstOrFail();
    //     $img = Document::where('dossier_id',$dossier->id)->whereIn('type_document_id',['5,6,7'])->inRandomOrder()->first();
    //     $docs = Document::where('dossier_id',$dossier->id)->whereIn('type_document_id',['5,6,7'])->take(4)->get();
    //     $pdf = Pdf::loadView('configuration.pdf.reforme', compact('dossier','docs','img'));
    //     $type = TypeDocument::whereId(15)->firstOrFail();

    //     // $filename = uniqid() . '.' . File::extension('pdf');
    //     // $path = 'documents/' . $dossier->ref . '/' . $type->type . '/' . $filename;
    //     // Storage::disk('s3')->put('documents/' . $dossier->ref . '/' . $type->type . '/' . $filename, $pdf->output());
    //     // Document::create([
    //     //     'path' => $path,
    //     //     'type_document_id' => $type->id,
    //     //     'dossier_id' => $dossier->id,
    //     // ]);

    //     return $pdf->stream('reforme.pdf');
    // }

    public function canevas($id)
    {

        $dossier = Dossier::whereId($id)->with('lastmeet', 'document', 'company', 'garage')->firstOrFail();
        if ($dossier->update != 0 && Auth::user()->role_id != 4 ||  $dossier->dossier_status_id == 3 && Auth::user()->role_id != 4) {
            return redirect()->route('Dossier.show', $dossier->id)->with('error', 'Dossier est interdit de le modifier Envoyer une demande a Admin ');
        }
        // if ($dossier->mode_id != 7) {
        //     return redirect()->back()->with('error', 'Dossier n est pas prise en charge ');
        // }
        if (!$dossier->garage) {
            return redirect()->back()->with('error', 'Merci de selectionner un garage');
        }
        $rapport = Rapport::with('piece', 'taux')->where('dossier_id', $dossier->id)->whereIn('rapport_status_id', [2, 3])->latest()->first();
        if (!$rapport) {
            return redirect()->back()->with('error', 'Besoin de Rapport Signer');
        }

        $observations = Observation::where('dossier_id', $id)->where('for_rapport', 1)->get();
        $pdf = Pdf::loadView('configuration.pdf.canevas', compact('dossier', 'rapport', 'observations'));

        $type = TypeDocument::whereId(34)->first();
        $filename = uniqid() . '.' . File::extension('pdf');
        $path = 'documents/' . $dossier->ref . '/' . $type->type . '/' . $filename;
        Storage::disk('s3')->put('documents/' . $dossier->ref . '/' . $type->type . '/' . $filename, $pdf->output());
        Document::updateOrCreate(['dossier_id' => $dossier->id, 'type_document_id' => $type->id], [
            'path' => $path,
        ]);

        $body = "A Génerer un Canevas:" . $dossier->ref;
        Notification::create([
            'user_id' => Auth::user()->id,
            'dossier_id' => $dossier->id,
            'body' => $body
        ]);

        return $pdf->stream();
    }


    public function req($id)
    {

        $dossier = Dossier::whereId($id)->with('lastmeet', 'document', 'company', 'garage')->firstOrFail();
        if ($dossier->update != 0 && Auth::user()->role_id != 4 ||  $dossier->dossier_status_id == 3 && Auth::user()->role_id != 4) {
            return redirect()->route('Dossier.show', $dossier->id)->with('error', 'Dossier est interdit de le modifier Envoyer une demande a Admin ');
        }

        $pdf = Pdf::loadView('configuration.pdf.req', compact('dossier'));
        return $pdf->stream();
    }
}
