<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('dossiers', function (Blueprint $table) {
            $table->double('valeurneuf')->nullable();
            $table->double('valeuradire')->nullable();
            $table->double('horssinistre')->nullable();
            $table->double('valeurepave')->nullable();
            $table->double('valeurvenale')->nullable();
            $table->foreignId('type_vehicule_id')->nullable()->constrained()->onDelete(null);

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('dossiers', function (Blueprint $table) {
            $table->dropColumn('valeurneuf')->nullable();
            $table->dropColumn('valeuradire')->nullable();
            $table->dropColumn('horssinistre')->nullable();
            $table->dropColumn('valeurepave')->nullable();
            $table->dropColumn('valeurevenale')->nullable();
            $table->dropConstrainedForeignId('type_vehicule_id');
        });
    }
};
