<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('calculators', function (Blueprint $table) {
            $table->id();
            $table->foreignId("category_id");
            $table->foreignId("carburant_id");
            $table->foreignId("etat_id")->nullable();
            $table->foreignId("pf_id");
            $table->bigInteger("pourcentage")->nullable();
            $table->bigInteger("annee")->nullable();
            $table->bigInteger("max")->nullable();
            $table->bigInteger("min")->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('calculators');
    }
};
