/*!
 * jQuery JavaScript Library v3.6.0
 * https://jquery.com/
 *
 * Includes Sizzle.js
 * https://sizzlejs.com/
 *
 * Copyright OpenJS Foundation and other contributors
 * Released under the MIT license
 * https://jquery.org/license
 *
 * Date: 2021-03-02T17:08Z
 */
(function (global, factory) {
    "use strict";

    if (typeof module === "object" && typeof module.exports === "object") {
        // For CommonJS and CommonJS-like environments where a proper `window`
        // is present, execute the factory and get jQuery.
        // For environments that do not have a `window` with a `document`
        // (such as Node.js), expose a factory as module.exports.
        // This accentuates the need for the creation of a real `window`.
        // e.g. var jQuery = require("jquery")(window);
        // See ticket #14549 for more info.
        module.exports = global.document
            ? factory(global, true)
            : function (w) {
                  if (!w.document) {
                      throw new Error(
                          "jQuery requires a window with a document"
                      );
                  }
                  return factory(w);
              };
    } else {
        factory(global);
    }

    // Pass this if window is not defined yet
})(typeof window !== "undefined" ? window : this, function (window, noGlobal) {
    // Edge <= 12 - 13+, Firefox <=18 - 45+, IE 10 - 11, Safari 5.1 - 9+, iOS 6 - 9.1
    // throw exceptions when non-strict code (e.g., ASP.NET 4.5) accesses strict mode
    // arguments.callee.caller (trac-13335). But as of jQuery 3.0 (2016), strict mode should be common
    // enough that all such attempts are guarded in a try block.
    "use strict";

    var arr = [];

    var getProto = Object.getPrototypeOf;

    var slice = arr.slice;

    var flat = arr.flat
        ? function (array) {
              return arr.flat.call(array);
          }
        : function (array) {
              return arr.concat.apply([], array);
          };

    var push = arr.push;

    var indexOf = arr.indexOf;

    var class2type = {};

    var toString = class2type.toString;

    var hasOwn = class2type.hasOwnProperty;

    var fnToString = hasOwn.toString;

    var ObjectFunctionString = fnToString.call(Object);

    var support = {};

    var isFunction = function isFunction(obj) {
        // Support: Chrome <=57, Firefox <=52
        // In some browsers, typeof returns "function" for HTML <object> elements
        // (i.e., `typeof document.createElement( "object" ) === "function"`).
        // We don't want to classify *any* DOM node as a function.
        // Support: QtWeb <=3.8.5, WebKit <=534.34, wkhtmltopdf tool <=0.12.5
        // Plus for old WebKit, typeof returns "function" for HTML collections
        // (e.g., `typeof document.getElementsByTagName("div") === "function"`). (gh-4756)
        return (
            typeof obj === "function" &&
            typeof obj.nodeType !== "number" &&
            typeof obj.item !== "function"
        );
    };

    var isWindow = function isWindow(obj) {
        return obj != null && obj === obj.window;
    };

    var document = window.document;

    var preservedScriptAttributes = {
        type: true,
        src: true,
        nonce: true,
        noModule: true,
    };

    function DOMEval(code, node, doc) {
        doc = doc || document;

        var i,
            val,
            script = doc.createElement("script");

        script.text = code;
        if (node) {
            for (i in preservedScriptAttributes) {
                // Support: Firefox 64+, Edge 18+
                // Some browsers don't support the "nonce" property on scripts.
                // On the other hand, just using `getAttribute` is not enough as
                // the `nonce` attribute is reset to an empty string whenever it
                // becomes browsing-context connected.
                // See https://github.com/whatwg/html/issues/2369
                // See https://html.spec.whatwg.org/#nonce-attributes
                // The `node.getAttribute` check was added for the sake of
                // `jQuery.globalEval` so that it can fake a nonce-containing node
                // via an object.
                val = node[i] || (node.getAttribute && node.getAttribute(i));
                if (val) {
                    script.setAttribute(i, val);
                }
            }
        }
        doc.head.appendChild(script).parentNode.removeChild(script);
    }

    function toType(obj) {
        if (obj == null) {
            return obj + "";
        }

        // Support: Android <=2.3 only (functionish RegExp)
        return typeof obj === "object" || typeof obj === "function"
            ? class2type[toString.call(obj)] || "object"
            : typeof obj;
    }
    /* global Symbol */
    // Defining this global in .eslintrc.json would create a danger of using the global
    // unguarded in another place, it seems safer to define global only for this module

    var version = "3.6.0",
        // Define a local copy of jQuery
        jQuery = function (selector, context) {
            // The jQuery object is actually just the init constructor 'enhanced'
            // Need init if jQuery is called (just allow error to be thrown if not included)
            return new jQuery.fn.init(selector, context);
        };

    jQuery.fn = jQuery.prototype = {
        // The current version of jQuery being used
        jquery: version,

        constructor: jQuery,

        // The default length of a jQuery object is 0
        length: 0,

        toArray: function () {
            return slice.call(this);
        },

        // Get the Nth element in the matched element set OR
        // Get the whole matched element set as a clean array
        get: function (num) {
            // Return all the elements in a clean array
            if (num == null) {
                return slice.call(this);
            }

            // Return just the one element from the set
            return num < 0 ? this[num + this.length] : this[num];
        },

        // Take an array of elements and push it onto the stack
        // (returning the new matched element set)
        pushStack: function (elems) {
            // Build a new jQuery matched element set
            var ret = jQuery.merge(this.constructor(), elems);

            // Add the old object onto the stack (as a reference)
            ret.prevObject = this;

            // Return the newly-formed element set
            return ret;
        },

        // Execute a callback for every element in the matched set.
        each: function (callback) {
            return jQuery.each(this, callback);
        },

        map: function (callback) {
            return this.pushStack(
                jQuery.map(this, function (elem, i) {
                    return callback.call(elem, i, elem);
                })
            );
        },

        slice: function () {
            return this.pushStack(slice.apply(this, arguments));
        },

        first: function () {
            return this.eq(0);
        },

        last: function () {
            return this.eq(-1);
        },

        even: function () {
            return this.pushStack(
                jQuery.grep(this, function (_elem, i) {
                    return (i + 1) % 2;
                })
            );
        },

        odd: function () {
            return this.pushStack(
                jQuery.grep(this, function (_elem, i) {
                    return i % 2;
                })
            );
        },

        eq: function (i) {
            var len = this.length,
                j = +i + (i < 0 ? len : 0);
            return this.pushStack(j >= 0 && j < len ? [this[j]] : []);
        },

        end: function () {
            return this.prevObject || this.constructor();
        },

        // For internal use only.
        // Behaves like an Array's method, not like a jQuery method.
        push: push,
        sort: arr.sort,
        splice: arr.splice,
    };

    jQuery.extend = jQuery.fn.extend = function () {
        var options,
            name,
            src,
            copy,
            copyIsArray,
            clone,
            target = arguments[0] || {},
            i = 1,
            length = arguments.length,
            deep = false;

        // Handle a deep copy situation
        if (typeof target === "boolean") {
            deep = target;

            // Skip the boolean and the target
            target = arguments[i] || {};
            i++;
        }

        // Handle case when target is a string or something (possible in deep copy)
        if (typeof target !== "object" && !isFunction(target)) {
            target = {};
        }

        // Extend jQuery itself if only one argument is passed
        if (i === length) {
            target = this;
            i--;
        }

        for (; i < length; i++) {
            // Only deal with non-null/undefined values
            if ((options = arguments[i]) != null) {
                // Extend the base object
                for (name in options) {
                    copy = options[name];

                    // Prevent Object.prototype pollution
                    // Prevent never-ending loop
                    if (name === "__proto__" || target === copy) {
                        continue;
                    }

                    // Recurse if we're merging plain objects or arrays
                    if (
                        deep &&
                        copy &&
                        (jQuery.isPlainObject(copy) ||
                            (copyIsArray = Array.isArray(copy)))
                    ) {
                        src = target[name];

                        // Ensure proper type for the source value
                        if (copyIsArray && !Array.isArray(src)) {
                            clone = [];
                        } else if (!copyIsArray && !jQuery.isPlainObject(src)) {
                            clone = {};
                        } else {
                            clone = src;
                        }
                        copyIsArray = false;

                        // Never move original objects, clone them
                        target[name] = jQuery.extend(deep, clone, copy);

                        // Don't bring in undefined values
                    } else if (copy !== undefined) {
                        target[name] = copy;
                    }
                }
            }
        }

        // Return the modified object
        return target;
    };

    jQuery.extend({
        // Unique for each copy of jQuery on the page
        expando: "jQuery" + (version + Math.random()).replace(/\D/g, ""),

        // Assume jQuery is ready without the ready module
        isReady: true,

        error: function (msg) {
            throw new Error(msg);
        },

        noop: function () {},

        isPlainObject: function (obj) {
            var proto, Ctor;

            // Detect obvious negatives
            // Use toString instead of jQuery.type to catch host objects
            if (!obj || toString.call(obj) !== "[object Object]") {
                return false;
            }

            proto = getProto(obj);

            // Objects with no prototype (e.g., `Object.create( null )`) are plain
            if (!proto) {
                return true;
            }

            // Objects with prototype are plain iff they were constructed by a global Object function
            Ctor = hasOwn.call(proto, "constructor") && proto.constructor;
            return (
                typeof Ctor === "function" &&
                fnToString.call(Ctor) === ObjectFunctionString
            );
        },

        isEmptyObject: function (obj) {
            var name;

            for (name in obj) {
                return false;
            }
            return true;
        },

        // Evaluates a script in a provided context; falls back to the global one
        // if not specified.
        globalEval: function (code, options, doc) {
            DOMEval(code, { nonce: options && options.nonce }, doc);
        },

        each: function (obj, callback) {
            var length,
                i = 0;

            if (isArrayLike(obj)) {
                length = obj.length;
                for (; i < length; i++) {
                    if (callback.call(obj[i], i, obj[i]) === false) {
                        break;
                    }
                }
            } else {
                for (i in obj) {
                    if (callback.call(obj[i], i, obj[i]) === false) {
                        break;
                    }
                }
            }

            return obj;
        },

        // results is for internal usage only
        makeArray: function (arr, results) {
            var ret = results || [];

            if (arr != null) {
                if (isArrayLike(Object(arr))) {
                    jQuery.merge(ret, typeof arr === "string" ? [arr] : arr);
                } else {
                    push.call(ret, arr);
                }
            }

            return ret;
        },

        inArray: function (elem, arr, i) {
            return arr == null ? -1 : indexOf.call(arr, elem, i);
        },

        // Support: Android <=4.0 only, PhantomJS 1 only
        // push.apply(_, arraylike) throws on ancient WebKit
        merge: function (first, second) {
            var len = +second.length,
                j = 0,
                i = first.length;

            for (; j < len; j++) {
                first[i++] = second[j];
            }

            first.length = i;

            return first;
        },

        grep: function (elems, callback, invert) {
            var callbackInverse,
                matches = [],
                i = 0,
                length = elems.length,
                callbackExpect = !invert;

            // Go through the array, only saving the items
            // that pass the validator function
            for (; i < length; i++) {
                callbackInverse = !callback(elems[i], i);
                if (callbackInverse !== callbackExpect) {
                    matches.push(elems[i]);
                }
            }

            return matches;
        },

        // arg is for internal usage only
        map: function (elems, callback, arg) {
            var length,
                value,
                i = 0,
                ret = [];

            // Go through the array, translating each of the items to their new values
            if (isArrayLike(elems)) {
                length = elems.length;
                for (; i < length; i++) {
                    value = callback(elems[i], i, arg);

                    if (value != null) {
                        ret.push(value);
                    }
                }

                // Go through every key on the object,
            } else {
                for (i in elems) {
                    value = callback(elems[i], i, arg);

                    if (value != null) {
                        ret.push(value);
                    }
                }
            }

            // Flatten any nested arrays
            return flat(ret);
        },

        // A global GUID counter for objects
        guid: 1,

        // jQuery.support is not used in Core but other projects attach their
        // properties to it so it needs to exist.
        support: support,
    });

    if (typeof Symbol === "function") {
        jQuery.fn[Symbol.iterator] = arr[Symbol.iterator];
    }

    // Populate the class2type map
    jQuery.each(
        "Boolean Number String Function Array Date RegExp Object Error Symbol".split(
            " "
        ),
        function (_i, name) {
            class2type["[object " + name + "]"] = name.toLowerCase();
        }
    );

    function isArrayLike(obj) {
        // Support: real iOS 8.2 only (not reproducible in simulator)
        // `in` check used to prevent JIT error (gh-2145)
        // hasOwn isn't used here due to false negatives
        // regarding Nodelist length in IE
        var length = !!obj && "length" in obj && obj.length,
            type = toType(obj);

        if (isFunction(obj) || isWindow(obj)) {
            return false;
        }

        return (
            type === "array" ||
            length === 0 ||
            (typeof length === "number" && length > 0 && length - 1 in obj)
        );
    }
    var Sizzle =
        /*!
         * Sizzle CSS Selector Engine v2.3.6
         * https://sizzlejs.com/
         *
         * Copyright JS Foundation and other contributors
         * Released under the MIT license
         * https://js.foundation/
         *
         * Date: 2021-02-16
         */
        (function (window) {
            var i,
                support,
                Expr,
                getText,
                isXML,
                tokenize,
                compile,
                select,
                outermostContext,
                sortInput,
                hasDuplicate,
                // Local document vars
                setDocument,
                document,
                docElem,
                documentIsHTML,
                rbuggyQSA,
                rbuggyMatches,
                matches,
                contains,
                // Instance-specific data
                expando = "sizzle" + 1 * new Date(),
                preferredDoc = window.document,
                dirruns = 0,
                done = 0,
                classCache = createCache(),
                tokenCache = createCache(),
                compilerCache = createCache(),
                nonnativeSelectorCache = createCache(),
                sortOrder = function (a, b) {
                    if (a === b) {
                        hasDuplicate = true;
                    }
                    return 0;
                },
                // Instance methods
                hasOwn = {}.hasOwnProperty,
                arr = [],
                pop = arr.pop,
                pushNative = arr.push,
                push = arr.push,
                slice = arr.slice,
                // Use a stripped-down indexOf as it's faster than native
                // https://jsperf.com/thor-indexof-vs-for/5
                indexOf = function (list, elem) {
                    var i = 0,
                        len = list.length;
                    for (; i < len; i++) {
                        if (list[i] === elem) {
                            return i;
                        }
                    }
                    return -1;
                },
                booleans =
                    "checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|" +
                    "ismap|loop|multiple|open|readonly|required|scoped",
                // Regular expressions

                // http://www.w3.org/TR/css3-selectors/#whitespace
                whitespace = "[\\x20\\t\\r\\n\\f]",
                // https://www.w3.org/TR/css-syntax-3/#ident-token-diagram
                identifier =
                    "(?:\\\\[\\da-fA-F]{1,6}" +
                    whitespace +
                    "?|\\\\[^\\r\\n\\f]|[\\w-]|[^\0-\\x7f])+",
                // Attribute selectors: http://www.w3.org/TR/selectors/#attribute-selectors
                attributes =
                    "\\[" +
                    whitespace +
                    "*(" +
                    identifier +
                    ")(?:" +
                    whitespace +
                    // Operator (capture 2)
                    "*([*^$|!~]?=)" +
                    whitespace +
                    // "Attribute values must be CSS identifiers [capture 5]
                    // or strings [capture 3 or capture 4]"
                    "*(?:'((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\"|(" +
                    identifier +
                    "))|)" +
                    whitespace +
                    "*\\]",
                pseudos =
                    ":(" +
                    identifier +
                    ")(?:\\((" +
                    // To reduce the number of selectors needing tokenize in the preFilter, prefer arguments:
                    // 1. quoted (capture 3; capture 4 or capture 5)
                    "('((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\")|" +
                    // 2. simple (capture 6)
                    "((?:\\\\.|[^\\\\()[\\]]|" +
                    attributes +
                    ")*)|" +
                    // 3. anything else (capture 2)
                    ".*" +
                    ")\\)|)",
                // Leading and non-escaped trailing whitespace, capturing some non-whitespace characters preceding the latter
                rwhitespace = new RegExp(whitespace + "+", "g"),
                rtrim = new RegExp(
                    "^" +
                        whitespace +
                        "+|((?:^|[^\\\\])(?:\\\\.)*)" +
                        whitespace +
                        "+$",
                    "g"
                ),
                rcomma = new RegExp("^" + whitespace + "*," + whitespace + "*"),
                rcombinators = new RegExp(
                    "^" +
                        whitespace +
                        "*([>+~]|" +
                        whitespace +
                        ")" +
                        whitespace +
                        "*"
                ),
                rdescend = new RegExp(whitespace + "|>"),
                rpseudo = new RegExp(pseudos),
                ridentifier = new RegExp("^" + identifier + "$"),
                matchExpr = {
                    ID: new RegExp("^#(" + identifier + ")"),
                    CLASS: new RegExp("^\\.(" + identifier + ")"),
                    TAG: new RegExp("^(" + identifier + "|[*])"),
                    ATTR: new RegExp("^" + attributes),
                    PSEUDO: new RegExp("^" + pseudos),
                    CHILD: new RegExp(
                        "^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\(" +
                            whitespace +
                            "*(even|odd|(([+-]|)(\\d*)n|)" +
                            whitespace +
                            "*(?:([+-]|)" +
                            whitespace +
                            "*(\\d+)|))" +
                            whitespace +
                            "*\\)|)",
                        "i"
                    ),
                    bool: new RegExp("^(?:" + booleans + ")$", "i"),

                    // For use in libraries implementing .is()
                    // We use this for POS matching in `select`
                    needsContext: new RegExp(
                        "^" +
                            whitespace +
                            "*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\(" +
                            whitespace +
                            "*((?:-\\d)?\\d*)" +
                            whitespace +
                            "*\\)|)(?=[^-]|$)",
                        "i"
                    ),
                },
                rhtml = /HTML$/i,
                rinputs = /^(?:input|select|textarea|button)$/i,
                rheader = /^h\d$/i,
                rnative = /^[^{]+\{\s*\[native \w/,
                // Easily-parseable/retrievable ID or TAG or CLASS selectors
                rquickExpr = /^(?:#([\w-]+)|(\w+)|\.([\w-]+))$/,
                rsibling = /[+~]/,
                // CSS escapes
                // http://www.w3.org/TR/CSS21/syndata.html#escaped-characters
                runescape = new RegExp(
                    "\\\\[\\da-fA-F]{1,6}" +
                        whitespace +
                        "?|\\\\([^\\r\\n\\f])",
                    "g"
                ),
                funescape = function (escape, nonHex) {
                    var high = "0x" + escape.slice(1) - 0x10000;

                    return nonHex
                        ? // Strip the backslash prefix from a non-hex escape sequence
                          nonHex
                        : // Replace a hexadecimal escape sequence with the encoded Unicode code point
                        // Support: IE <=11+
                        // For values outside the Basic Multilingual Plane (BMP), manually construct a
                        // surrogate pair
                        high < 0
                        ? String.fromCharCode(high + 0x10000)
                        : String.fromCharCode(
                              (high >> 10) | 0xd800,
                              (high & 0x3ff) | 0xdc00
                          );
                },
                // CSS string/identifier serialization
                // https://drafts.csswg.org/cssom/#common-serializing-idioms
                rcssescape =
                    /([\0-\x1f\x7f]|^-?\d)|^-$|[^\0-\x1f\x7f-\uFFFF\w-]/g,
                fcssescape = function (ch, asCodePoint) {
                    if (asCodePoint) {
                        // U+0000 NULL becomes U+FFFD REPLACEMENT CHARACTER
                        if (ch === "\0") {
                            return "\uFFFD";
                        }

                        // Control characters and (dependent upon position) numbers get escaped as code points
                        return (
                            ch.slice(0, -1) +
                            "\\" +
                            ch.charCodeAt(ch.length - 1).toString(16) +
                            " "
                        );
                    }

                    // Other potentially-special ASCII characters get backslash-escaped
                    return "\\" + ch;
                },
                // Used for iframes
                // See setDocument()
                // Removing the function wrapper causes a "Permission Denied"
                // error in IE
                unloadHandler = function () {
                    setDocument();
                },
                inDisabledFieldset = addCombinator(
                    function (elem) {
                        return (
                            elem.disabled === true &&
                            elem.nodeName.toLowerCase() === "fieldset"
                        );
                    },
                    { dir: "parentNode", next: "legend" }
                );

            // Optimize for push.apply( _, NodeList )
            try {
                push.apply(
                    (arr = slice.call(preferredDoc.childNodes)),
                    preferredDoc.childNodes
                );

                // Support: Android<4.0
                // Detect silently failing push.apply
                // eslint-disable-next-line no-unused-expressions
                arr[preferredDoc.childNodes.length].nodeType;
            } catch (e) {
                push = {
                    apply: arr.length
                        ? // Leverage slice if possible
                          function (target, els) {
                              pushNative.apply(target, slice.call(els));
                          }
                        : // Support: IE<9
                          // Otherwise append directly
                          function (target, els) {
                              var j = target.length,
                                  i = 0;

                              // Can't trust NodeList.length
                              while ((target[j++] = els[i++])) {}
                              target.length = j - 1;
                          },
                };
            }

            function Sizzle(selector, context, results, seed) {
                var m,
                    i,
                    elem,
                    nid,
                    match,
                    groups,
                    newSelector,
                    newContext = context && context.ownerDocument,
                    // nodeType defaults to 9, since context defaults to document
                    nodeType = context ? context.nodeType : 9;

                results = results || [];

                // Return early from calls with invalid selector or context
                if (
                    typeof selector !== "string" ||
                    !selector ||
                    (nodeType !== 1 && nodeType !== 9 && nodeType !== 11)
                ) {
                    return results;
                }

                // Try to shortcut find operations (as opposed to filters) in HTML documents
                if (!seed) {
                    setDocument(context);
                    context = context || document;

                    if (documentIsHTML) {
                        // If the selector is sufficiently simple, try using a "get*By*" DOM method
                        // (excepting DocumentFragment context, where the methods don't exist)
                        if (
                            nodeType !== 11 &&
                            (match = rquickExpr.exec(selector))
                        ) {
                            // ID selector
                            if ((m = match[1])) {
                                // Document context
                                if (nodeType === 9) {
                                    if ((elem = context.getElementById(m))) {
                                        // Support: IE, Opera, Webkit
                                        // TODO: identify versions
                                        // getElementById can match elements by name instead of ID
                                        if (elem.id === m) {
                                            results.push(elem);
                                            return results;
                                        }
                                    } else {
                                        return results;
                                    }

                                    // Element context
                                } else {
                                    // Support: IE, Opera, Webkit
                                    // TODO: identify versions
                                    // getElementById can match elements by name instead of ID
                                    if (
                                        newContext &&
                                        (elem = newContext.getElementById(m)) &&
                                        contains(context, elem) &&
                                        elem.id === m
                                    ) {
                                        results.push(elem);
                                        return results;
                                    }
                                }

                                // Type selector
                            } else if (match[2]) {
                                push.apply(
                                    results,
                                    context.getElementsByTagName(selector)
                                );
                                return results;

                                // Class selector
                            } else if (
                                (m = match[3]) &&
                                support.getElementsByClassName &&
                                context.getElementsByClassName
                            ) {
                                push.apply(
                                    results,
                                    context.getElementsByClassName(m)
                                );
                                return results;
                            }
                        }

                        // Take advantage of querySelectorAll
                        if (
                            support.qsa &&
                            !nonnativeSelectorCache[selector + " "] &&
                            (!rbuggyQSA || !rbuggyQSA.test(selector)) &&
                            // Support: IE 8 only
                            // Exclude object elements
                            (nodeType !== 1 ||
                                context.nodeName.toLowerCase() !== "object")
                        ) {
                            newSelector = selector;
                            newContext = context;

                            // qSA considers elements outside a scoping root when evaluating child or
                            // descendant combinators, which is not what we want.
                            // In such cases, we work around the behavior by prefixing every selector in the
                            // list with an ID selector referencing the scope context.
                            // The technique has to be used as well when a leading combinator is used
                            // as such selectors are not recognized by querySelectorAll.
                            // Thanks to Andrew Dupont for this technique.
                            if (
                                nodeType === 1 &&
                                (rdescend.test(selector) ||
                                    rcombinators.test(selector))
                            ) {
                                // Expand context for sibling selectors
                                newContext =
                                    (rsibling.test(selector) &&
                                        testContext(context.parentNode)) ||
                                    context;

                                // We can use :scope instead of the ID hack if the browser
                                // supports it & if we're not changing the context.
                                if (newContext !== context || !support.scope) {
                                    // Capture the context ID, setting it first if necessary
                                    if ((nid = context.getAttribute("id"))) {
                                        nid = nid.replace(
                                            rcssescape,
                                            fcssescape
                                        );
                                    } else {
                                        context.setAttribute(
                                            "id",
                                            (nid = expando)
                                        );
                                    }
                                }

                                // Prefix every selector in the list
                                groups = tokenize(selector);
                                i = groups.length;
                                while (i--) {
                                    groups[i] =
                                        (nid ? "#" + nid : ":scope") +
                                        " " +
                                        toSelector(groups[i]);
                                }
                                newSelector = groups.join(",");
                            }

                            try {
                                push.apply(
                                    results,
                                    newContext.querySelectorAll(newSelector)
                                );
                                return results;
                            } catch (qsaError) {
                                nonnativeSelectorCache(selector, true);
                            } finally {
                                if (nid === expando) {
                                    context.removeAttribute("id");
                                }
                            }
                        }
                    }
                }

                // All others
                return select(
                    selector.replace(rtrim, "$1"),
                    context,
                    results,
                    seed
                );
            }

            /**
             * Create key-value caches of limited size
             * @returns {function(string, object)} Returns the Object data after storing it on itself with
             *	property name the (space-suffixed) string and (if the cache is larger than Expr.cacheLength)
             *	deleting the oldest entry
             */
            function createCache() {
                var keys = [];

                function cache(key, value) {
                    // Use (key + " ") to avoid collision with native prototype properties (see Issue #157)
                    if (keys.push(key + " ") > Expr.cacheLength) {
                        // Only keep the most recent entries
                        delete cache[keys.shift()];
                    }
                    return (cache[key + " "] = value);
                }
                return cache;
            }

            /**
             * Mark a function for special use by Sizzle
             * @param {Function} fn The function to mark
             */
            function markFunction(fn) {
                fn[expando] = true;
                return fn;
            }

            /**
             * Support testing using an element
             * @param {Function} fn Passed the created element and returns a boolean result
             */
            function assert(fn) {
                var el = document.createElement("fieldset");

                try {
                    return !!fn(el);
                } catch (e) {
                    return false;
                } finally {
                    // Remove from its parent by default
                    if (el.parentNode) {
                        el.parentNode.removeChild(el);
                    }

                    // release memory in IE
                    el = null;
                }
            }

            /**
             * Adds the same handler for all of the specified attrs
             * @param {String} attrs Pipe-separated list of attributes
             * @param {Function} handler The method that will be applied
             */
            function addHandle(attrs, handler) {
                var arr = attrs.split("|"),
                    i = arr.length;

                while (i--) {
                    Expr.attrHandle[arr[i]] = handler;
                }
            }

            /**
             * Checks document order of two siblings
             * @param {Element} a
             * @param {Element} b
             * @returns {Number} Returns less than 0 if a precedes b, greater than 0 if a follows b
             */
            function siblingCheck(a, b) {
                var cur = b && a,
                    diff =
                        cur &&
                        a.nodeType === 1 &&
                        b.nodeType === 1 &&
                        a.sourceIndex - b.sourceIndex;

                // Use IE sourceIndex if available on both nodes
                if (diff) {
                    return diff;
                }

                // Check if b follows a
                if (cur) {
                    while ((cur = cur.nextSibling)) {
                        if (cur === b) {
                            return -1;
                        }
                    }
                }

                return a ? 1 : -1;
            }

            /**
             * Returns a function to use in pseudos for input types
             * @param {String} type
             */
            function createInputPseudo(type) {
                return function (elem) {
                    var name = elem.nodeName.toLowerCase();
                    return name === "input" && elem.type === type;
                };
            }

            /**
             * Returns a function to use in pseudos for buttons
             * @param {String} type
             */
            function createButtonPseudo(type) {
                return function (elem) {
                    var name = elem.nodeName.toLowerCase();
                    return (
                        (name === "input" || name === "button") &&
                        elem.type === type
                    );
                };
            }

            /**
             * Returns a function to use in pseudos for :enabled/:disabled
             * @param {Boolean} disabled true for :disabled; false for :enabled
             */
            function createDisabledPseudo(disabled) {
                // Known :disabled false positives: fieldset[disabled] > legend:nth-of-type(n+2) :can-disable
                return function (elem) {
                    // Only certain elements can match :enabled or :disabled
                    // https://html.spec.whatwg.org/multipage/scripting.html#selector-enabled
                    // https://html.spec.whatwg.org/multipage/scripting.html#selector-disabled
                    if ("form" in elem) {
                        // Check for inherited disabledness on relevant non-disabled elements:
                        // * listed form-associated elements in a disabled fieldset
                        //   https://html.spec.whatwg.org/multipage/forms.html#category-listed
                        //   https://html.spec.whatwg.org/multipage/forms.html#concept-fe-disabled
                        // * option elements in a disabled optgroup
                        //   https://html.spec.whatwg.org/multipage/forms.html#concept-option-disabled
                        // All such elements have a "form" property.
                        if (elem.parentNode && elem.disabled === false) {
                            // Option elements defer to a parent optgroup if present
                            if ("label" in elem) {
                                if ("label" in elem.parentNode) {
                                    return (
                                        elem.parentNode.disabled === disabled
                                    );
                                } else {
                                    return elem.disabled === disabled;
                                }
                            }

                            // Support: IE 6 - 11
                            // Use the isDisabled shortcut property to check for disabled fieldset ancestors
                            return (
                                elem.isDisabled === disabled ||
                                // Where there is no isDisabled, check manually
                                /* jshint -W018 */
                                (elem.isDisabled !== !disabled &&
                                    inDisabledFieldset(elem) === disabled)
                            );
                        }

                        return elem.disabled === disabled;

                        // Try to winnow out elements that can't be disabled before trusting the disabled property.
                        // Some victims get caught in our net (label, legend, menu, track), but it shouldn't
                        // even exist on them, let alone have a boolean value.
                    } else if ("label" in elem) {
                        return elem.disabled === disabled;
                    }

                    // Remaining elements are neither :enabled nor :disabled
                    return false;
                };
            }

            /**
             * Returns a function to use in pseudos for positionals
             * @param {Function} fn
             */
            function createPositionalPseudo(fn) {
                return markFunction(function (argument) {
                    argument = +argument;
                    return markFunction(function (seed, matches) {
                        var j,
                            matchIndexes = fn([], seed.length, argument),
                            i = matchIndexes.length;

                        // Match elements found at the specified indexes
                        while (i--) {
                            if (seed[(j = matchIndexes[i])]) {
                                seed[j] = !(matches[j] = seed[j]);
                            }
                        }
                    });
                });
            }

            /**
             * Checks a node for validity as a Sizzle context
             * @param {Element|Object=} context
             * @returns {Element|Object|Boolean} The input node if acceptable, otherwise a falsy value
             */
            function testContext(context) {
                return (
                    context &&
                    typeof context.getElementsByTagName !== "undefined" &&
                    context
                );
            }

            // Expose support vars for convenience
            support = Sizzle.support = {};

            /**
             * Detects XML nodes
             * @param {Element|Object} elem An element or a document
             * @returns {Boolean} True iff elem is a non-HTML XML node
             */
            isXML = Sizzle.isXML = function (elem) {
                var namespace = elem && elem.namespaceURI,
                    docElem =
                        elem && (elem.ownerDocument || elem).documentElement;

                // Support: IE <=8
                // Assume HTML when documentElement doesn't yet exist, such as inside loading iframes
                // https://bugs.jquery.com/ticket/4833
                return !rhtml.test(
                    namespace || (docElem && docElem.nodeName) || "HTML"
                );
            };

            /**
             * Sets document-related variables once based on the current document
             * @param {Element|Object} [doc] An element or document object to use to set the document
             * @returns {Object} Returns the current document
             */
            setDocument = Sizzle.setDocument = function (node) {
                var hasCompare,
                    subWindow,
                    doc = node ? node.ownerDocument || node : preferredDoc;

                // Return early if doc is invalid or already selected
                // Support: IE 11+, Edge 17 - 18+
                // IE/Edge sometimes throw a "Permission denied" error when strict-comparing
                // two documents; shallow comparisons work.
                // eslint-disable-next-line eqeqeq
                if (
                    doc == document ||
                    doc.nodeType !== 9 ||
                    !doc.documentElement
                ) {
                    return document;
                }

                // Update global variables
                document = doc;
                docElem = document.documentElement;
                documentIsHTML = !isXML(document);

                // Support: IE 9 - 11+, Edge 12 - 18+
                // Accessing iframe documents after unload throws "permission denied" errors (jQuery #13936)
                // Support: IE 11+, Edge 17 - 18+
                // IE/Edge sometimes throw a "Permission denied" error when strict-comparing
                // two documents; shallow comparisons work.
                // eslint-disable-next-line eqeqeq
                if (
                    preferredDoc != document &&
                    (subWindow = document.defaultView) &&
                    subWindow.top !== subWindow
                ) {
                    // Support: IE 11, Edge
                    if (subWindow.addEventListener) {
                        subWindow.addEventListener(
                            "unload",
                            unloadHandler,
                            false
                        );

                        // Support: IE 9 - 10 only
                    } else if (subWindow.attachEvent) {
                        subWindow.attachEvent("onunload", unloadHandler);
                    }
                }

                // Support: IE 8 - 11+, Edge 12 - 18+, Chrome <=16 - 25 only, Firefox <=3.6 - 31 only,
                // Safari 4 - 5 only, Opera <=11.6 - 12.x only
                // IE/Edge & older browsers don't support the :scope pseudo-class.
                // Support: Safari 6.0 only
                // Safari 6.0 supports :scope but it's an alias of :root there.
                support.scope = assert(function (el) {
                    docElem
                        .appendChild(el)
                        .appendChild(document.createElement("div"));
                    return (
                        typeof el.querySelectorAll !== "undefined" &&
                        !el.querySelectorAll(":scope fieldset div").length
                    );
                });

                /* Attributes
	---------------------------------------------------------------------- */

                // Support: IE<8
                // Verify that getAttribute really returns attributes and not properties
                // (excepting IE8 booleans)
                support.attributes = assert(function (el) {
                    el.className = "i";
                    return !el.getAttribute("className");
                });

                /* getElement(s)By*
	---------------------------------------------------------------------- */

                // Check if getElementsByTagName("*") returns only elements
                support.getElementsByTagName = assert(function (el) {
                    el.appendChild(document.createComment(""));
                    return !el.getElementsByTagName("*").length;
                });

                // Support: IE<9
                support.getElementsByClassName = rnative.test(
                    document.getElementsByClassName
                );

                // Support: IE<10
                // Check if getElementById returns elements by name
                // The broken getElementById methods don't pick up programmatically-set names,
                // so use a roundabout getElementsByName test
                support.getById = assert(function (el) {
                    docElem.appendChild(el).id = expando;
                    return (
                        !document.getElementsByName ||
                        !document.getElementsByName(expando).length
                    );
                });

                // ID filter and find
                if (support.getById) {
                    Expr.filter["ID"] = function (id) {
                        var attrId = id.replace(runescape, funescape);
                        return function (elem) {
                            return elem.getAttribute("id") === attrId;
                        };
                    };
                    Expr.find["ID"] = function (id, context) {
                        if (
                            typeof context.getElementById !== "undefined" &&
                            documentIsHTML
                        ) {
                            var elem = context.getElementById(id);
                            return elem ? [elem] : [];
                        }
                    };
                } else {
                    Expr.filter["ID"] = function (id) {
                        var attrId = id.replace(runescape, funescape);
                        return function (elem) {
                            var node =
                                typeof elem.getAttributeNode !== "undefined" &&
                                elem.getAttributeNode("id");
                            return node && node.value === attrId;
                        };
                    };

                    // Support: IE 6 - 7 only
                    // getElementById is not reliable as a find shortcut
                    Expr.find["ID"] = function (id, context) {
                        if (
                            typeof context.getElementById !== "undefined" &&
                            documentIsHTML
                        ) {
                            var node,
                                i,
                                elems,
                                elem = context.getElementById(id);

                            if (elem) {
                                // Verify the id attribute
                                node = elem.getAttributeNode("id");
                                if (node && node.value === id) {
                                    return [elem];
                                }

                                // Fall back on getElementsByName
                                elems = context.getElementsByName(id);
                                i = 0;
                                while ((elem = elems[i++])) {
                                    node = elem.getAttributeNode("id");
                                    if (node && node.value === id) {
                                        return [elem];
                                    }
                                }
                            }

                            return [];
                        }
                    };
                }

                // Tag
                Expr.find["TAG"] = support.getElementsByTagName
                    ? function (tag, context) {
                          if (
                              typeof context.getElementsByTagName !==
                              "undefined"
                          ) {
                              return context.getElementsByTagName(tag);

                              // DocumentFragment nodes don't have gEBTN
                          } else if (support.qsa) {
                              return context.querySelectorAll(tag);
                          }
                      }
                    : function (tag, context) {
                          var elem,
                              tmp = [],
                              i = 0,
                              // By happy coincidence, a (broken) gEBTN appears on DocumentFragment nodes too
                              results = context.getElementsByTagName(tag);

                          // Filter out possible comments
                          if (tag === "*") {
                              while ((elem = results[i++])) {
                                  if (elem.nodeType === 1) {
                                      tmp.push(elem);
                                  }
                              }

                              return tmp;
                          }
                          return results;
                      };

                // Class
                Expr.find["CLASS"] =
                    support.getElementsByClassName &&
                    function (className, context) {
                        if (
                            typeof context.getElementsByClassName !==
                                "undefined" &&
                            documentIsHTML
                        ) {
                            return context.getElementsByClassName(className);
                        }
                    };

                /* QSA/matchesSelector
	---------------------------------------------------------------------- */

                // QSA and matchesSelector support

                // matchesSelector(:active) reports false when true (IE9/Opera 11.5)
                rbuggyMatches = [];

                // qSa(:focus) reports false when true (Chrome 21)
                // We allow this because of a bug in IE8/9 that throws an error
                // whenever `document.activeElement` is accessed on an iframe
                // So, we allow :focus to pass through QSA all the time to avoid the IE error
                // See https://bugs.jquery.com/ticket/13378
                rbuggyQSA = [];

                if ((support.qsa = rnative.test(document.querySelectorAll))) {
                    // Build QSA regex
                    // Regex strategy adopted from Diego Perini
                    assert(function (el) {
                        var input;

                        // Select is set to empty string on purpose
                        // This is to test IE's treatment of not explicitly
                        // setting a boolean content attribute,
                        // since its presence should be enough
                        // https://bugs.jquery.com/ticket/12359
                        docElem.appendChild(el).innerHTML =
                            "<a id='" +
                            expando +
                            "'></a>" +
                            "<select id='" +
                            expando +
                            "-\r\\' msallowcapture=''>" +
                            "<option selected=''></option></select>";

                        // Support: IE8, Opera 11-12.16
                        // Nothing should be selected when empty strings follow ^= or $= or *=
                        // The test attribute must be unknown in Opera but "safe" for WinRT
                        // https://msdn.microsoft.com/en-us/library/ie/hh465388.aspx#attribute_section
                        if (
                            el.querySelectorAll("[msallowcapture^='']").length
                        ) {
                            rbuggyQSA.push(
                                "[*^$]=" + whitespace + "*(?:''|\"\")"
                            );
                        }

                        // Support: IE8
                        // Boolean attributes and "value" are not treated correctly
                        if (!el.querySelectorAll("[selected]").length) {
                            rbuggyQSA.push(
                                "\\[" +
                                    whitespace +
                                    "*(?:value|" +
                                    booleans +
                                    ")"
                            );
                        }

                        // Support: Chrome<29, Android<4.4, Safari<7.0+, iOS<7.0+, PhantomJS<1.9.8+
                        if (
                            !el.querySelectorAll("[id~=" + expando + "-]")
                                .length
                        ) {
                            rbuggyQSA.push("~=");
                        }

                        // Support: IE 11+, Edge 15 - 18+
                        // IE 11/Edge don't find elements on a `[name='']` query in some cases.
                        // Adding a temporary attribute to the document before the selection works
                        // around the issue.
                        // Interestingly, IE 10 & older don't seem to have the issue.
                        input = document.createElement("input");
                        input.setAttribute("name", "");
                        el.appendChild(input);
                        if (!el.querySelectorAll("[name='']").length) {
                            rbuggyQSA.push(
                                "\\[" +
                                    whitespace +
                                    "*name" +
                                    whitespace +
                                    "*=" +
                                    whitespace +
                                    "*(?:''|\"\")"
                            );
                        }

                        // Webkit/Opera - :checked should return selected option elements
                        // http://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked
                        // IE8 throws error here and will not see later tests
                        if (!el.querySelectorAll(":checked").length) {
                            rbuggyQSA.push(":checked");
                        }

                        // Support: Safari 8+, iOS 8+
                        // https://bugs.webkit.org/show_bug.cgi?id=136851
                        // In-page `selector#id sibling-combinator selector` fails
                        if (
                            !el.querySelectorAll("a#" + expando + "+*").length
                        ) {
                            rbuggyQSA.push(".#.+[+~]");
                        }

                        // Support: Firefox <=3.6 - 5 only
                        // Old Firefox doesn't throw on a badly-escaped identifier.
                        el.querySelectorAll("\\\f");
                        rbuggyQSA.push("[\\r\\n\\f]");
                    });

                    assert(function (el) {
                        el.innerHTML =
                            "<a href='' disabled='disabled'></a>" +
                            "<select disabled='disabled'><option/></select>";

                        // Support: Windows 8 Native Apps
                        // The type and name attributes are restricted during .innerHTML assignment
                        var input = document.createElement("input");
                        input.setAttribute("type", "hidden");
                        el.appendChild(input).setAttribute("name", "D");

                        // Support: IE8
                        // Enforce case-sensitivity of name attribute
                        if (el.querySelectorAll("[name=d]").length) {
                            rbuggyQSA.push("name" + whitespace + "*[*^$|!~]?=");
                        }

                        // FF 3.5 - :enabled/:disabled and hidden elements (hidden elements are still enabled)
                        // IE8 throws error here and will not see later tests
                        if (el.querySelectorAll(":enabled").length !== 2) {
                            rbuggyQSA.push(":enabled", ":disabled");
                        }

                        // Support: IE9-11+
                        // IE's :disabled selector does not pick up the children of disabled fieldsets
                        docElem.appendChild(el).disabled = true;
                        if (el.querySelectorAll(":disabled").length !== 2) {
                            rbuggyQSA.push(":enabled", ":disabled");
                        }

                        // Support: Opera 10 - 11 only
                        // Opera 10-11 does not throw on post-comma invalid pseudos
                        el.querySelectorAll("*,:x");
                        rbuggyQSA.push(",.*:");
                    });
                }

                if (
                    (support.matchesSelector = rnative.test(
                        (matches =
                            docElem.matches ||
                            docElem.webkitMatchesSelector ||
                            docElem.mozMatchesSelector ||
                            docElem.oMatchesSelector ||
                            docElem.msMatchesSelector)
                    ))
                ) {
                    assert(function (el) {
                        // Check to see if it's possible to do matchesSelector
                        // on a disconnected node (IE 9)
                        support.disconnectedMatch = matches.call(el, "*");

                        // This should fail with an exception
                        // Gecko does not error, returns false instead
                        matches.call(el, "[s!='']:x");
                        rbuggyMatches.push("!=", pseudos);
                    });
                }

                rbuggyQSA = rbuggyQSA.length && new RegExp(rbuggyQSA.join("|"));
                rbuggyMatches =
                    rbuggyMatches.length && new RegExp(rbuggyMatches.join("|"));

                /* Contains
	---------------------------------------------------------------------- */
                hasCompare = rnative.test(docElem.compareDocumentPosition);

                // Element contains another
                // Purposefully self-exclusive
                // As in, an element does not contain itself
                contains =
                    hasCompare || rnative.test(docElem.contains)
                        ? function (a, b) {
                              var adown =
                                      a.nodeType === 9 ? a.documentElement : a,
                                  bup = b && b.parentNode;
                              return (
                                  a === bup ||
                                  !!(
                                      bup &&
                                      bup.nodeType === 1 &&
                                      (adown.contains
                                          ? adown.contains(bup)
                                          : a.compareDocumentPosition &&
                                            a.compareDocumentPosition(bup) & 16)
                                  )
                              );
                          }
                        : function (a, b) {
                              if (b) {
                                  while ((b = b.parentNode)) {
                                      if (b === a) {
                                          return true;
                                      }
                                  }
                              }
                              return false;
                          };

                /* Sorting
	---------------------------------------------------------------------- */

                // Document order sorting
                sortOrder = hasCompare
                    ? function (a, b) {
                          // Flag for duplicate removal
                          if (a === b) {
                              hasDuplicate = true;
                              return 0;
                          }

                          // Sort on method existence if only one input has compareDocumentPosition
                          var compare =
                              !a.compareDocumentPosition -
                              !b.compareDocumentPosition;
                          if (compare) {
                              return compare;
                          }

                          // Calculate position if both inputs belong to the same document
                          // Support: IE 11+, Edge 17 - 18+
                          // IE/Edge sometimes throw a "Permission denied" error when strict-comparing
                          // two documents; shallow comparisons work.
                          // eslint-disable-next-line eqeqeq
                          compare =
                              (a.ownerDocument || a) == (b.ownerDocument || b)
                                  ? a.compareDocumentPosition(b)
                                  : // Otherwise we know they are disconnected
                                    1;

                          // Disconnected nodes
                          if (
                              compare & 1 ||
                              (!support.sortDetached &&
                                  b.compareDocumentPosition(a) === compare)
                          ) {
                              // Choose the first element that is related to our preferred document
                              // Support: IE 11+, Edge 17 - 18+
                              // IE/Edge sometimes throw a "Permission denied" error when strict-comparing
                              // two documents; shallow comparisons work.
                              // eslint-disable-next-line eqeqeq
                              if (
                                  a == document ||
                                  (a.ownerDocument == preferredDoc &&
                                      contains(preferredDoc, a))
                              ) {
                                  return -1;
                              }

                              // Support: IE 11+, Edge 17 - 18+
                              // IE/Edge sometimes throw a "Permission denied" error when strict-comparing
                              // two documents; shallow comparisons work.
                              // eslint-disable-next-line eqeqeq
                              if (
                                  b == document ||
                                  (b.ownerDocument == preferredDoc &&
                                      contains(preferredDoc, b))
                              ) {
                                  return 1;
                              }

                              // Maintain original order
                              return sortInput
                                  ? indexOf(sortInput, a) -
                                        indexOf(sortInput, b)
                                  : 0;
                          }

                          return compare & 4 ? -1 : 1;
                      }
                    : function (a, b) {
                          // Exit early if the nodes are identical
                          if (a === b) {
                              hasDuplicate = true;
                              return 0;
                          }

                          var cur,
                              i = 0,
                              aup = a.parentNode,
                              bup = b.parentNode,
                              ap = [a],
                              bp = [b];

                          // Parentless nodes are either documents or disconnected
                          if (!aup || !bup) {
                              // Support: IE 11+, Edge 17 - 18+
                              // IE/Edge sometimes throw a "Permission denied" error when strict-comparing
                              // two documents; shallow comparisons work.
                              /* eslint-disable eqeqeq */
                              return a == document
                                  ? -1
                                  : b == document
                                  ? 1
                                  : /* eslint-enable eqeqeq */
                                  aup
                                  ? -1
                                  : bup
                                  ? 1
                                  : sortInput
                                  ? indexOf(sortInput, a) -
                                    indexOf(sortInput, b)
                                  : 0;

                              // If the nodes are siblings, we can do a quick check
                          } else if (aup === bup) {
                              return siblingCheck(a, b);
                          }

                          // Otherwise we need full lists of their ancestors for comparison
                          cur = a;
                          while ((cur = cur.parentNode)) {
                              ap.unshift(cur);
                          }
                          cur = b;
                          while ((cur = cur.parentNode)) {
                              bp.unshift(cur);
                          }

                          // Walk down the tree looking for a discrepancy
                          while (ap[i] === bp[i]) {
                              i++;
                          }

                          return i
                              ? // Do a sibling check if the nodes have a common ancestor
                                siblingCheck(ap[i], bp[i])
                              : // Otherwise nodes in our document sort first
                              // Support: IE 11+, Edge 17 - 18+
                              // IE/Edge sometimes throw a "Permission denied" error when strict-comparing
                              // two documents; shallow comparisons work.
                              /* eslint-disable eqeqeq */
                              ap[i] == preferredDoc
                              ? -1
                              : bp[i] == preferredDoc
                              ? 1
                              : /* eslint-enable eqeqeq */
                                0;
                      };

                return document;
            };

            Sizzle.matches = function (expr, elements) {
                return Sizzle(expr, null, null, elements);
            };

            Sizzle.matchesSelector = function (elem, expr) {
                setDocument(elem);

                if (
                    support.matchesSelector &&
                    documentIsHTML &&
                    !nonnativeSelectorCache[expr + " "] &&
                    (!rbuggyMatches || !rbuggyMatches.test(expr)) &&
                    (!rbuggyQSA || !rbuggyQSA.test(expr))
                ) {
                    try {
                        var ret = matches.call(elem, expr);

                        // IE 9's matchesSelector returns false on disconnected nodes
                        if (
                            ret ||
                            support.disconnectedMatch ||
                            // As well, disconnected nodes are said to be in a document
                            // fragment in IE 9
                            (elem.document && elem.document.nodeType !== 11)
                        ) {
                            return ret;
                        }
                    } catch (e) {
                        nonnativeSelectorCache(expr, true);
                    }
                }

                return Sizzle(expr, document, null, [elem]).length > 0;
            };

            Sizzle.contains = function (context, elem) {
                // Set document vars if needed
                // Support: IE 11+, Edge 17 - 18+
                // IE/Edge sometimes throw a "Permission denied" error when strict-comparing
                // two documents; shallow comparisons work.
                // eslint-disable-next-line eqeqeq
                if ((context.ownerDocument || context) != document) {
                    setDocument(context);
                }
                return contains(context, elem);
            };

            Sizzle.attr = function (elem, name) {
                // Set document vars if needed
                // Support: IE 11+, Edge 17 - 18+
                // IE/Edge sometimes throw a "Permission denied" error when strict-comparing
                // two documents; shallow comparisons work.
                // eslint-disable-next-line eqeqeq
                if ((elem.ownerDocument || elem) != document) {
                    setDocument(elem);
                }

                var fn = Expr.attrHandle[name.toLowerCase()],
                    // Don't get fooled by Object.prototype properties (jQuery #13807)
                    val =
                        fn && hasOwn.call(Expr.attrHandle, name.toLowerCase())
                            ? fn(elem, name, !documentIsHTML)
                            : undefined;

                return val !== undefined
                    ? val
                    : support.attributes || !documentIsHTML
                    ? elem.getAttribute(name)
                    : (val = elem.getAttributeNode(name)) && val.specified
                    ? val.value
                    : null;
            };

            Sizzle.escape = function (sel) {
                return (sel + "").replace(rcssescape, fcssescape);
            };

            Sizzle.error = function (msg) {
                throw new Error(
                    "Syntax error, unrecognized expression: " + msg
                );
            };

            /**
             * Document sorting and removing duplicates
             * @param {ArrayLike} results
             */
            Sizzle.uniqueSort = function (results) {
                var elem,
                    duplicates = [],
                    j = 0,
                    i = 0;

                // Unless we *know* we can detect duplicates, assume their presence
                hasDuplicate = !support.detectDuplicates;
                sortInput = !support.sortStable && results.slice(0);
                results.sort(sortOrder);

                if (hasDuplicate) {
                    while ((elem = results[i++])) {
                        if (elem === results[i]) {
                            j = duplicates.push(i);
                        }
                    }
                    while (j--) {
                        results.splice(duplicates[j], 1);
                    }
                }

                // Clear input after sorting to release objects
                // See https://github.com/jquery/sizzle/pull/225
                sortInput = null;

                return results;
            };

            /**
             * Utility function for retrieving the text value of an array of DOM nodes
             * @param {Array|Element} elem
             */
            getText = Sizzle.getText = function (elem) {
                var node,
                    ret = "",
                    i = 0,
                    nodeType = elem.nodeType;

                if (!nodeType) {
                    // If no nodeType, this is expected to be an array
                    while ((node = elem[i++])) {
                        // Do not traverse comment nodes
                        ret += getText(node);
                    }
                } else if (
                    nodeType === 1 ||
                    nodeType === 9 ||
                    nodeType === 11
                ) {
                    // Use textContent for elements
                    // innerText usage removed for consistency of new lines (jQuery #11153)
                    if (typeof elem.textContent === "string") {
                        return elem.textContent;
                    } else {
                        // Traverse its children
                        for (
                            elem = elem.firstChild;
                            elem;
                            elem = elem.nextSibling
                        ) {
                            ret += getText(elem);
                        }
                    }
                } else if (nodeType === 3 || nodeType === 4) {
                    return elem.nodeValue;
                }

                // Do not include comment or processing instruction nodes

                return ret;
            };

            Expr = Sizzle.selectors = {
                // Can be adjusted by the user
                cacheLength: 50,

                createPseudo: markFunction,

                match: matchExpr,

                attrHandle: {},

                find: {},

                relative: {
                    ">": { dir: "parentNode", first: true },
                    " ": { dir: "parentNode" },
                    "+": { dir: "previousSibling", first: true },
                    "~": { dir: "previousSibling" },
                },

                preFilter: {
                    ATTR: function (match) {
                        match[1] = match[1].replace(runescape, funescape);

                        // Move the given value to match[3] whether quoted or unquoted
                        match[3] = (
                            match[3] ||
                            match[4] ||
                            match[5] ||
                            ""
                        ).replace(runescape, funescape);

                        if (match[2] === "~=") {
                            match[3] = " " + match[3] + " ";
                        }

                        return match.slice(0, 4);
                    },

                    CHILD: function (match) {
                        /* matches from matchExpr["CHILD"]
				1 type (only|nth|...)
				2 what (child|of-type)
				3 argument (even|odd|\d*|\d*n([+-]\d+)?|...)
				4 xn-component of xn+y argument ([+-]?\d*n|)
				5 sign of xn-component
				6 x of xn-component
				7 sign of y-component
				8 y of y-component
			*/
                        match[1] = match[1].toLowerCase();

                        if (match[1].slice(0, 3) === "nth") {
                            // nth-* requires argument
                            if (!match[3]) {
                                Sizzle.error(match[0]);
                            }

                            // numeric x and y parameters for Expr.filter.CHILD
                            // remember that false/true cast respectively to 0/1
                            match[4] = +(match[4]
                                ? match[5] + (match[6] || 1)
                                : 2 *
                                  (match[3] === "even" || match[3] === "odd"));
                            match[5] = +(
                                match[7] + match[8] || match[3] === "odd"
                            );

                            // other types prohibit arguments
                        } else if (match[3]) {
                            Sizzle.error(match[0]);
                        }

                        return match;
                    },

                    PSEUDO: function (match) {
                        var excess,
                            unquoted = !match[6] && match[2];

                        if (matchExpr["CHILD"].test(match[0])) {
                            return null;
                        }

                        // Accept quoted arguments as-is
                        if (match[3]) {
                            match[2] = match[4] || match[5] || "";

                            // Strip excess characters from unquoted arguments
                        } else if (
                            unquoted &&
                            rpseudo.test(unquoted) &&
                            // Get excess from tokenize (recursively)
                            (excess = tokenize(unquoted, true)) &&
                            // advance to the next closing parenthesis
                            (excess =
                                unquoted.indexOf(
                                    ")",
                                    unquoted.length - excess
                                ) - unquoted.length)
                        ) {
                            // excess is a negative index
                            match[0] = match[0].slice(0, excess);
                            match[2] = unquoted.slice(0, excess);
                        }

                        // Return only captures needed by the pseudo filter method (type and argument)
                        return match.slice(0, 3);
                    },
                },

                filter: {
                    TAG: function (nodeNameSelector) {
                        var nodeName = nodeNameSelector
                            .replace(runescape, funescape)
                            .toLowerCase();
                        return nodeNameSelector === "*"
                            ? function () {
                                  return true;
                              }
                            : function (elem) {
                                  return (
                                      elem.nodeName &&
                                      elem.nodeName.toLowerCase() === nodeName
                                  );
                              };
                    },

                    CLASS: function (className) {
                        var pattern = classCache[className + " "];

                        return (
                            pattern ||
                            ((pattern = new RegExp(
                                "(^|" +
                                    whitespace +
                                    ")" +
                                    className +
                                    "(" +
                                    whitespace +
                                    "|$)"
                            )) &&
                                classCache(className, function (elem) {
                                    return pattern.test(
                                        (typeof elem.className === "string" &&
                                            elem.className) ||
                                            (typeof elem.getAttribute !==
                                                "undefined" &&
                                                elem.getAttribute("class")) ||
                                            ""
                                    );
                                }))
                        );
                    },

                    ATTR: function (name, operator, check) {
                        return function (elem) {
                            var result = Sizzle.attr(elem, name);

                            if (result == null) {
                                return operator === "!=";
                            }
                            if (!operator) {
                                return true;
                            }

                            result += "";

                            /* eslint-disable max-len */

                            return operator === "="
                                ? result === check
                                : operator === "!="
                                ? result !== check
                                : operator === "^="
                                ? check && result.indexOf(check) === 0
                                : operator === "*="
                                ? check && result.indexOf(check) > -1
                                : operator === "$="
                                ? check && result.slice(-check.length) === check
                                : operator === "~="
                                ? (
                                      " " +
                                      result.replace(rwhitespace, " ") +
                                      " "
                                  ).indexOf(check) > -1
                                : operator === "|="
                                ? result === check ||
                                  result.slice(0, check.length + 1) ===
                                      check + "-"
                                : false;
                            /* eslint-enable max-len */
                        };
                    },

                    CHILD: function (type, what, _argument, first, last) {
                        var simple = type.slice(0, 3) !== "nth",
                            forward = type.slice(-4) !== "last",
                            ofType = what === "of-type";

                        return first === 1 && last === 0
                            ? // Shortcut for :nth-*(n)
                              function (elem) {
                                  return !!elem.parentNode;
                              }
                            : function (elem, _context, xml) {
                                  var cache,
                                      uniqueCache,
                                      outerCache,
                                      node,
                                      nodeIndex,
                                      start,
                                      dir =
                                          simple !== forward
                                              ? "nextSibling"
                                              : "previousSibling",
                                      parent = elem.parentNode,
                                      name =
                                          ofType && elem.nodeName.toLowerCase(),
                                      useCache = !xml && !ofType,
                                      diff = false;

                                  if (parent) {
                                      // :(first|last|only)-(child|of-type)
                                      if (simple) {
                                          while (dir) {
                                              node = elem;
                                              while ((node = node[dir])) {
                                                  if (
                                                      ofType
                                                          ? node.nodeName.toLowerCase() ===
                                                            name
                                                          : node.nodeType === 1
                                                  ) {
                                                      return false;
                                                  }
                                              }

                                              // Reverse direction for :only-* (if we haven't yet done so)
                                              start = dir =
                                                  type === "only" &&
                                                  !start &&
                                                  "nextSibling";
                                          }
                                          return true;
                                      }

                                      start = [
                                          forward
                                              ? parent.firstChild
                                              : parent.lastChild,
                                      ];

                                      // non-xml :nth-child(...) stores cache data on `parent`
                                      if (forward && useCache) {
                                          // Seek `elem` from a previously-cached index

                                          // ...in a gzip-friendly way
                                          node = parent;
                                          outerCache =
                                              node[expando] ||
                                              (node[expando] = {});

                                          // Support: IE <9 only
                                          // Defend against cloned attroperties (jQuery gh-1709)
                                          uniqueCache =
                                              outerCache[node.uniqueID] ||
                                              (outerCache[node.uniqueID] = {});

                                          cache = uniqueCache[type] || [];
                                          nodeIndex =
                                              cache[0] === dirruns && cache[1];
                                          diff = nodeIndex && cache[2];
                                          node =
                                              nodeIndex &&
                                              parent.childNodes[nodeIndex];

                                          while (
                                              (node =
                                                  (++nodeIndex &&
                                                      node &&
                                                      node[dir]) ||
                                                  // Fallback to seeking `elem` from the start
                                                  (diff = nodeIndex = 0) ||
                                                  start.pop())
                                          ) {
                                              // When found, cache indexes on `parent` and break
                                              if (
                                                  node.nodeType === 1 &&
                                                  ++diff &&
                                                  node === elem
                                              ) {
                                                  uniqueCache[type] = [
                                                      dirruns,
                                                      nodeIndex,
                                                      diff,
                                                  ];
                                                  break;
                                              }
                                          }
                                      } else {
                                          // Use previously-cached element index if available
                                          if (useCache) {
                                              // ...in a gzip-friendly way
                                              node = elem;
                                              outerCache =
                                                  node[expando] ||
                                                  (node[expando] = {});

                                              // Support: IE <9 only
                                              // Defend against cloned attroperties (jQuery gh-1709)
                                              uniqueCache =
                                                  outerCache[node.uniqueID] ||
                                                  (outerCache[node.uniqueID] =
                                                      {});

                                              cache = uniqueCache[type] || [];
                                              nodeIndex =
                                                  cache[0] === dirruns &&
                                                  cache[1];
                                              diff = nodeIndex;
                                          }

                                          // xml :nth-child(...)
                                          // or :nth-last-child(...) or :nth(-last)?-of-type(...)
                                          if (diff === false) {
                                              // Use the same loop as above to seek `elem` from the start
                                              while (
                                                  (node =
                                                      (++nodeIndex &&
                                                          node &&
                                                          node[dir]) ||
                                                      (diff = nodeIndex = 0) ||
                                                      start.pop())
                                              ) {
                                                  if (
                                                      (ofType
                                                          ? node.nodeName.toLowerCase() ===
                                                            name
                                                          : node.nodeType ===
                                                            1) &&
                                                      ++diff
                                                  ) {
                                                      // Cache the index of each encountered element
                                                      if (useCache) {
                                                          outerCache =
                                                              node[expando] ||
                                                              (node[expando] =
                                                                  {});

                                                          // Support: IE <9 only
                                                          // Defend against cloned attroperties (jQuery gh-1709)
                                                          uniqueCache =
                                                              outerCache[
                                                                  node.uniqueID
                                                              ] ||
                                                              (outerCache[
                                                                  node.uniqueID
                                                              ] = {});

                                                          uniqueCache[type] = [
                                                              dirruns,
                                                              diff,
                                                          ];
                                                      }

                                                      if (node === elem) {
                                                          break;
                                                      }
                                                  }
                                              }
                                          }
                                      }

                                      // Incorporate the offset, then check against cycle size
                                      diff -= last;
                                      return (
                                          diff === first ||
                                          (diff % first === 0 &&
                                              diff / first >= 0)
                                      );
                                  }
                              };
                    },

                    PSEUDO: function (pseudo, argument) {
                        // pseudo-class names are case-insensitive
                        // http://www.w3.org/TR/selectors/#pseudo-classes
                        // Prioritize by case sensitivity in case custom pseudos are added with uppercase letters
                        // Remember that setFilters inherits from pseudos
                        var args,
                            fn =
                                Expr.pseudos[pseudo] ||
                                Expr.setFilters[pseudo.toLowerCase()] ||
                                Sizzle.error("unsupported pseudo: " + pseudo);

                        // The user may use createPseudo to indicate that
                        // arguments are needed to create the filter function
                        // just as Sizzle does
                        if (fn[expando]) {
                            return fn(argument);
                        }

                        // But maintain support for old signatures
                        if (fn.length > 1) {
                            args = [pseudo, pseudo, "", argument];
                            return Expr.setFilters.hasOwnProperty(
                                pseudo.toLowerCase()
                            )
                                ? markFunction(function (seed, matches) {
                                      var idx,
                                          matched = fn(seed, argument),
                                          i = matched.length;
                                      while (i--) {
                                          idx = indexOf(seed, matched[i]);
                                          seed[idx] = !(matches[idx] =
                                              matched[i]);
                                      }
                                  })
                                : function (elem) {
                                      return fn(elem, 0, args);
                                  };
                        }

                        return fn;
                    },
                },

                pseudos: {
                    // Potentially complex pseudos
                    not: markFunction(function (selector) {
                        // Trim the selector passed to compile
                        // to avoid treating leading and trailing
                        // spaces as combinators
                        var input = [],
                            results = [],
                            matcher = compile(selector.replace(rtrim, "$1"));

                        return matcher[expando]
                            ? markFunction(function (
                                  seed,
                                  matches,
                                  _context,
                                  xml
                              ) {
                                  var elem,
                                      unmatched = matcher(seed, null, xml, []),
                                      i = seed.length;

                                  // Match elements unmatched by `matcher`
                                  while (i--) {
                                      if ((elem = unmatched[i])) {
                                          seed[i] = !(matches[i] = elem);
                                      }
                                  }
                              })
                            : function (elem, _context, xml) {
                                  input[0] = elem;
                                  matcher(input, null, xml, results);

                                  // Don't keep the element (issue #299)
                                  input[0] = null;
                                  return !results.pop();
                              };
                    }),

                    has: markFunction(function (selector) {
                        return function (elem) {
                            return Sizzle(selector, elem).length > 0;
                        };
                    }),

                    contains: markFunction(function (text) {
                        text = text.replace(runescape, funescape);
                        return function (elem) {
                            return (
                                (elem.textContent || getText(elem)).indexOf(
                                    text
                                ) > -1
                            );
                        };
                    }),

                    // "Whether an element is represented by a :lang() selector
                    // is based solely on the element's language value
                    // being equal to the identifier C,
                    // or beginning with the identifier C immediately followed by "-".
                    // The matching of C against the element's language value is performed case-insensitively.
                    // The identifier C does not have to be a valid language name."
                    // http://www.w3.org/TR/selectors/#lang-pseudo
                    lang: markFunction(function (lang) {
                        // lang value must be a valid identifier
                        if (!ridentifier.test(lang || "")) {
                            Sizzle.error("unsupported lang: " + lang);
                        }
                        lang = lang.replace(runescape, funescape).toLowerCase();
                        return function (elem) {
                            var elemLang;
                            do {
                                if (
                                    (elemLang = documentIsHTML
                                        ? elem.lang
                                        : elem.getAttribute("xml:lang") ||
                                          elem.getAttribute("lang"))
                                ) {
                                    elemLang = elemLang.toLowerCase();
                                    return (
                                        elemLang === lang ||
                                        elemLang.indexOf(lang + "-") === 0
                                    );
                                }
                            } while ((elem = elem.parentNode) && elem.nodeType === 1);
                            return false;
                        };
                    }),

                    // Miscellaneous
                    target: function (elem) {
                        var hash = window.location && window.location.hash;
                        return hash && hash.slice(1) === elem.id;
                    },

                    root: function (elem) {
                        return elem === docElem;
                    },

                    focus: function (elem) {
                        return (
                            elem === document.activeElement &&
                            (!document.hasFocus || document.hasFocus()) &&
                            !!(elem.type || elem.href || ~elem.tabIndex)
                        );
                    },

                    // Boolean properties
                    enabled: createDisabledPseudo(false),
                    disabled: createDisabledPseudo(true),

                    checked: function (elem) {
                        // In CSS3, :checked should return both checked and selected elements
                        // http://www.w3.org/TR/2011/REC-css3-selectors-20110929/#checked
                        var nodeName = elem.nodeName.toLowerCase();
                        return (
                            (nodeName === "input" && !!elem.checked) ||
                            (nodeName === "option" && !!elem.selected)
                        );
                    },

                    selected: function (elem) {
                        // Accessing this property makes selected-by-default
                        // options in Safari work properly
                        if (elem.parentNode) {
                            // eslint-disable-next-line no-unused-expressions
                            elem.parentNode.selectedIndex;
                        }

                        return elem.selected === true;
                    },

                    // Contents
                    empty: function (elem) {
                        // http://www.w3.org/TR/selectors/#empty-pseudo
                        // :empty is negated by element (1) or content nodes (text: 3; cdata: 4; entity ref: 5),
                        //   but not by others (comment: 8; processing instruction: 7; etc.)
                        // nodeType < 6 works because attributes (2) do not appear as children
                        for (
                            elem = elem.firstChild;
                            elem;
                            elem = elem.nextSibling
                        ) {
                            if (elem.nodeType < 6) {
                                return false;
                            }
                        }
                        return true;
                    },

                    parent: function (elem) {
                        return !Expr.pseudos["empty"](elem);
                    },

                    // Element/input types
                    header: function (elem) {
                        return rheader.test(elem.nodeName);
                    },

                    input: function (elem) {
                        return rinputs.test(elem.nodeName);
                    },

                    button: function (elem) {
                        var name = elem.nodeName.toLowerCase();
                        return (
                            (name === "input" && elem.type === "button") ||
                            name === "button"
                        );
                    },

                    text: function (elem) {
                        var attr;
                        return (
                            elem.nodeName.toLowerCase() === "input" &&
                            elem.type === "text" &&
                            // Support: IE<8
                            // New HTML5 attribute values (e.g., "search") appear with elem.type === "text"
                            ((attr = elem.getAttribute("type")) == null ||
                                attr.toLowerCase() === "text")
                        );
                    },

                    // Position-in-collection
                    first: createPositionalPseudo(function () {
                        return [0];
                    }),

                    last: createPositionalPseudo(function (
                        _matchIndexes,
                        length
                    ) {
                        return [length - 1];
                    }),

                    eq: createPositionalPseudo(function (
                        _matchIndexes,
                        length,
                        argument
                    ) {
                        return [argument < 0 ? argument + length : argument];
                    }),

                    even: createPositionalPseudo(function (
                        matchIndexes,
                        length
                    ) {
                        var i = 0;
                        for (; i < length; i += 2) {
                            matchIndexes.push(i);
                        }
                        return matchIndexes;
                    }),

                    odd: createPositionalPseudo(function (
                        matchIndexes,
                        length
                    ) {
                        var i = 1;
                        for (; i < length; i += 2) {
                            matchIndexes.push(i);
                        }
                        return matchIndexes;
                    }),

                    lt: createPositionalPseudo(function (
                        matchIndexes,
                        length,
                        argument
                    ) {
                        var i =
                            argument < 0
                                ? argument + length
                                : argument > length
                                ? length
                                : argument;
                        for (; --i >= 0; ) {
                            matchIndexes.push(i);
                        }
                        return matchIndexes;
                    }),

                    gt: createPositionalPseudo(function (
                        matchIndexes,
                        length,
                        argument
                    ) {
                        var i = argument < 0 ? argument + length : argument;
                        for (; ++i < length; ) {
                            matchIndexes.push(i);
                        }
                        return matchIndexes;
                    }),
                },
            };

            Expr.pseudos["nth"] = Expr.pseudos["eq"];

            // Add button/input type pseudos
            for (i in {
                radio: true,
                checkbox: true,
                file: true,
                password: true,
                image: true,
            }) {
                Expr.pseudos[i] = createInputPseudo(i);
            }
            for (i in { submit: true, reset: true }) {
                Expr.pseudos[i] = createButtonPseudo(i);
            }

            // Easy API for creating new setFilters
            function setFilters() {}
            setFilters.prototype = Expr.filters = Expr.pseudos;
            Expr.setFilters = new setFilters();

            tokenize = Sizzle.tokenize = function (selector, parseOnly) {
                var matched,
                    match,
                    tokens,
                    type,
                    soFar,
                    groups,
                    preFilters,
                    cached = tokenCache[selector + " "];

                if (cached) {
                    return parseOnly ? 0 : cached.slice(0);
                }

                soFar = selector;
                groups = [];
                preFilters = Expr.preFilter;

                while (soFar) {
                    // Comma and first run
                    if (!matched || (match = rcomma.exec(soFar))) {
                        if (match) {
                            // Don't consume trailing commas as valid
                            soFar = soFar.slice(match[0].length) || soFar;
                        }
                        groups.push((tokens = []));
                    }

                    matched = false;

                    // Combinators
                    if ((match = rcombinators.exec(soFar))) {
                        matched = match.shift();
                        tokens.push({
                            value: matched,

                            // Cast descendant combinators to space
                            type: match[0].replace(rtrim, " "),
                        });
                        soFar = soFar.slice(matched.length);
                    }

                    // Filters
                    for (type in Expr.filter) {
                        if (
                            (match = matchExpr[type].exec(soFar)) &&
                            (!preFilters[type] ||
                                (match = preFilters[type](match)))
                        ) {
                            matched = match.shift();
                            tokens.push({
                                value: matched,
                                type: type,
                                matches: match,
                            });
                            soFar = soFar.slice(matched.length);
                        }
                    }

                    if (!matched) {
                        break;
                    }
                }

                // Return the length of the invalid excess
                // if we're just parsing
                // Otherwise, throw an error or return tokens
                return parseOnly
                    ? soFar.length
                    : soFar
                    ? Sizzle.error(selector)
                    : // Cache the tokens
                      tokenCache(selector, groups).slice(0);
            };

            function toSelector(tokens) {
                var i = 0,
                    len = tokens.length,
                    selector = "";
                for (; i < len; i++) {
                    selector += tokens[i].value;
                }
                return selector;
            }

            function addCombinator(matcher, combinator, base) {
                var dir = combinator.dir,
                    skip = combinator.next,
                    key = skip || dir,
                    checkNonElements = base && key === "parentNode",
                    doneName = done++;

                return combinator.first
                    ? // Check against closest ancestor/preceding element
                      function (elem, context, xml) {
                          while ((elem = elem[dir])) {
                              if (elem.nodeType === 1 || checkNonElements) {
                                  return matcher(elem, context, xml);
                              }
                          }
                          return false;
                      }
                    : // Check against all ancestor/preceding elements
                      function (elem, context, xml) {
                          var oldCache,
                              uniqueCache,
                              outerCache,
                              newCache = [dirruns, doneName];

                          // We can't set arbitrary data on XML nodes, so they don't benefit from combinator caching
                          if (xml) {
                              while ((elem = elem[dir])) {
                                  if (elem.nodeType === 1 || checkNonElements) {
                                      if (matcher(elem, context, xml)) {
                                          return true;
                                      }
                                  }
                              }
                          } else {
                              while ((elem = elem[dir])) {
                                  if (elem.nodeType === 1 || checkNonElements) {
                                      outerCache =
                                          elem[expando] || (elem[expando] = {});

                                      // Support: IE <9 only
                                      // Defend against cloned attroperties (jQuery gh-1709)
                                      uniqueCache =
                                          outerCache[elem.uniqueID] ||
                                          (outerCache[elem.uniqueID] = {});

                                      if (
                                          skip &&
                                          skip === elem.nodeName.toLowerCase()
                                      ) {
                                          elem = elem[dir] || elem;
                                      } else if (
                                          (oldCache = uniqueCache[key]) &&
                                          oldCache[0] === dirruns &&
                                          oldCache[1] === doneName
                                      ) {
                                          // Assign to newCache so results back-propagate to previous elements
                                          return (newCache[2] = oldCache[2]);
                                      } else {
                                          // Reuse newcache so results back-propagate to previous elements
                                          uniqueCache[key] = newCache;

                                          // A match means we're done; a fail means we have to keep checking
                                          if (
                                              (newCache[2] = matcher(
                                                  elem,
                                                  context,
                                                  xml
                                              ))
                                          ) {
                                              return true;
                                          }
                                      }
                                  }
                              }
                          }
                          return false;
                      };
            }

            function elementMatcher(matchers) {
                return matchers.length > 1
                    ? function (elem, context, xml) {
                          var i = matchers.length;
                          while (i--) {
                              if (!matchers[i](elem, context, xml)) {
                                  return false;
                              }
                          }
                          return true;
                      }
                    : matchers[0];
            }

            function multipleContexts(selector, contexts, results) {
                var i = 0,
                    len = contexts.length;
                for (; i < len; i++) {
                    Sizzle(selector, contexts[i], results);
                }
                return results;
            }

            function condense(unmatched, map, filter, context, xml) {
                var elem,
                    newUnmatched = [],
                    i = 0,
                    len = unmatched.length,
                    mapped = map != null;

                for (; i < len; i++) {
                    if ((elem = unmatched[i])) {
                        if (!filter || filter(elem, context, xml)) {
                            newUnmatched.push(elem);
                            if (mapped) {
                                map.push(i);
                            }
                        }
                    }
                }

                return newUnmatched;
            }

            function setMatcher(
                preFilter,
                selector,
                matcher,
                postFilter,
                postFinder,
                postSelector
            ) {
                if (postFilter && !postFilter[expando]) {
                    postFilter = setMatcher(postFilter);
                }
                if (postFinder && !postFinder[expando]) {
                    postFinder = setMatcher(postFinder, postSelector);
                }
                return markFunction(function (seed, results, context, xml) {
                    var temp,
                        i,
                        elem,
                        preMap = [],
                        postMap = [],
                        preexisting = results.length,
                        // Get initial elements from seed or context
                        elems =
                            seed ||
                            multipleContexts(
                                selector || "*",
                                context.nodeType ? [context] : context,
                                []
                            ),
                        // Prefilter to get matcher input, preserving a map for seed-results synchronization
                        matcherIn =
                            preFilter && (seed || !selector)
                                ? condense(
                                      elems,
                                      preMap,
                                      preFilter,
                                      context,
                                      xml
                                  )
                                : elems,
                        matcherOut = matcher
                            ? // If we have a postFinder, or filtered seed, or non-seed postFilter or preexisting results,
                              postFinder ||
                              (seed ? preFilter : preexisting || postFilter)
                                ? // ...intermediate processing is necessary
                                  []
                                : // ...otherwise use results directly
                                  results
                            : matcherIn;

                    // Find primary matches
                    if (matcher) {
                        matcher(matcherIn, matcherOut, context, xml);
                    }

                    // Apply postFilter
                    if (postFilter) {
                        temp = condense(matcherOut, postMap);
                        postFilter(temp, [], context, xml);

                        // Un-match failing elements by moving them back to matcherIn
                        i = temp.length;
                        while (i--) {
                            if ((elem = temp[i])) {
                                matcherOut[postMap[i]] = !(matcherIn[
                                    postMap[i]
                                ] = elem);
                            }
                        }
                    }

                    if (seed) {
                        if (postFinder || preFilter) {
                            if (postFinder) {
                                // Get the final matcherOut by condensing this intermediate into postFinder contexts
                                temp = [];
                                i = matcherOut.length;
                                while (i--) {
                                    if ((elem = matcherOut[i])) {
                                        // Restore matcherIn since elem is not yet a final match
                                        temp.push((matcherIn[i] = elem));
                                    }
                                }
                                postFinder(null, (matcherOut = []), temp, xml);
                            }

                            // Move matched elements from seed to results to keep them synchronized
                            i = matcherOut.length;
                            while (i--) {
                                if (
                                    (elem = matcherOut[i]) &&
                                    (temp = postFinder
                                        ? indexOf(seed, elem)
                                        : preMap[i]) > -1
                                ) {
                                    seed[temp] = !(results[temp] = elem);
                                }
                            }
                        }

                        // Add elements to results, through postFinder if defined
                    } else {
                        matcherOut = condense(
                            matcherOut === results
                                ? matcherOut.splice(
                                      preexisting,
                                      matcherOut.length
                                  )
                                : matcherOut
                        );
                        if (postFinder) {
                            postFinder(null, results, matcherOut, xml);
                        } else {
                            push.apply(results, matcherOut);
                        }
                    }
                });
            }

            function matcherFromTokens(tokens) {
                var checkContext,
                    matcher,
                    j,
                    len = tokens.length,
                    leadingRelative = Expr.relative[tokens[0].type],
                    implicitRelative = leadingRelative || Expr.relative[" "],
                    i = leadingRelative ? 1 : 0,
                    // The foundational matcher ensures that elements are reachable from top-level context(s)
                    matchContext = addCombinator(
                        function (elem) {
                            return elem === checkContext;
                        },
                        implicitRelative,
                        true
                    ),
                    matchAnyContext = addCombinator(
                        function (elem) {
                            return indexOf(checkContext, elem) > -1;
                        },
                        implicitRelative,
                        true
                    ),
                    matchers = [
                        function (elem, context, xml) {
                            var ret =
                                (!leadingRelative &&
                                    (xml || context !== outermostContext)) ||
                                ((checkContext = context).nodeType
                                    ? matchContext(elem, context, xml)
                                    : matchAnyContext(elem, context, xml));

                            // Avoid hanging onto element (issue #299)
                            checkContext = null;
                            return ret;
                        },
                    ];

                for (; i < len; i++) {
                    if ((matcher = Expr.relative[tokens[i].type])) {
                        matchers = [
                            addCombinator(elementMatcher(matchers), matcher),
                        ];
                    } else {
                        matcher = Expr.filter[tokens[i].type].apply(
                            null,
                            tokens[i].matches
                        );

                        // Return special upon seeing a positional matcher
                        if (matcher[expando]) {
                            // Find the next relative operator (if any) for proper handling
                            j = ++i;
                            for (; j < len; j++) {
                                if (Expr.relative[tokens[j].type]) {
                                    break;
                                }
                            }
                            return setMatcher(
                                i > 1 && elementMatcher(matchers),
                                i > 1 &&
                                    toSelector(
                                        // If the preceding token was a descendant combinator, insert an implicit any-element `*`
                                        tokens.slice(0, i - 1).concat({
                                            value:
                                                tokens[i - 2].type === " "
                                                    ? "*"
                                                    : "",
                                        })
                                    ).replace(rtrim, "$1"),
                                matcher,
                                i < j && matcherFromTokens(tokens.slice(i, j)),
                                j < len &&
                                    matcherFromTokens(
                                        (tokens = tokens.slice(j))
                                    ),
                                j < len && toSelector(tokens)
                            );
                        }
                        matchers.push(matcher);
                    }
                }

                return elementMatcher(matchers);
            }

            function matcherFromGroupMatchers(elementMatchers, setMatchers) {
                var bySet = setMatchers.length > 0,
                    byElement = elementMatchers.length > 0,
                    superMatcher = function (
                        seed,
                        context,
                        xml,
                        results,
                        outermost
                    ) {
                        var elem,
                            j,
                            matcher,
                            matchedCount = 0,
                            i = "0",
                            unmatched = seed && [],
                            setMatched = [],
                            contextBackup = outermostContext,
                            // We must always have either seed elements or outermost context
                            elems =
                                seed ||
                                (byElement && Expr.find["TAG"]("*", outermost)),
                            // Use integer dirruns iff this is the outermost matcher
                            dirrunsUnique = (dirruns +=
                                contextBackup == null
                                    ? 1
                                    : Math.random() || 0.1),
                            len = elems.length;

                        if (outermost) {
                            // Support: IE 11+, Edge 17 - 18+
                            // IE/Edge sometimes throw a "Permission denied" error when strict-comparing
                            // two documents; shallow comparisons work.
                            // eslint-disable-next-line eqeqeq
                            outermostContext =
                                context == document || context || outermost;
                        }

                        // Add elements passing elementMatchers directly to results
                        // Support: IE<9, Safari
                        // Tolerate NodeList properties (IE: "length"; Safari: <number>) matching elements by id
                        for (; i !== len && (elem = elems[i]) != null; i++) {
                            if (byElement && elem) {
                                j = 0;

                                // Support: IE 11+, Edge 17 - 18+
                                // IE/Edge sometimes throw a "Permission denied" error when strict-comparing
                                // two documents; shallow comparisons work.
                                // eslint-disable-next-line eqeqeq
                                if (
                                    !context &&
                                    elem.ownerDocument != document
                                ) {
                                    setDocument(elem);
                                    xml = !documentIsHTML;
                                }
                                while ((matcher = elementMatchers[j++])) {
                                    if (
                                        matcher(elem, context || document, xml)
                                    ) {
                                        results.push(elem);
                                        break;
                                    }
                                }
                                if (outermost) {
                                    dirruns = dirrunsUnique;
                                }
                            }

                            // Track unmatched elements for set filters
                            if (bySet) {
                                // They will have gone through all possible matchers
                                if ((elem = !matcher && elem)) {
                                    matchedCount--;
                                }

                                // Lengthen the array for every element, matched or not
                                if (seed) {
                                    unmatched.push(elem);
                                }
                            }
                        }

                        // `i` is now the count of elements visited above, and adding it to `matchedCount`
                        // makes the latter nonnegative.
                        matchedCount += i;

                        // Apply set filters to unmatched elements
                        // NOTE: This can be skipped if there are no unmatched elements (i.e., `matchedCount`
                        // equals `i`), unless we didn't visit _any_ elements in the above loop because we have
                        // no element matchers and no seed.
                        // Incrementing an initially-string "0" `i` allows `i` to remain a string only in that
                        // case, which will result in a "00" `matchedCount` that differs from `i` but is also
                        // numerically zero.
                        if (bySet && i !== matchedCount) {
                            j = 0;
                            while ((matcher = setMatchers[j++])) {
                                matcher(unmatched, setMatched, context, xml);
                            }

                            if (seed) {
                                // Reintegrate element matches to eliminate the need for sorting
                                if (matchedCount > 0) {
                                    while (i--) {
                                        if (!(unmatched[i] || setMatched[i])) {
                                            setMatched[i] = pop.call(results);
                                        }
                                    }
                                }

                                // Discard index placeholder values to get only actual matches
                                setMatched = condense(setMatched);
                            }

                            // Add matches to results
                            push.apply(results, setMatched);

                            // Seedless set matches succeeding multiple successful matchers stipulate sorting
                            if (
                                outermost &&
                                !seed &&
                                setMatched.length > 0 &&
                                matchedCount + setMatchers.length > 1
                            ) {
                                Sizzle.uniqueSort(results);
                            }
                        }

                        // Override manipulation of globals by nested matchers
                        if (outermost) {
                            dirruns = dirrunsUnique;
                            outermostContext = contextBackup;
                        }

                        return unmatched;
                    };

                return bySet ? markFunction(superMatcher) : superMatcher;
            }

            compile = Sizzle.compile = function (
                selector,
                match /* Internal Use Only */
            ) {
                var i,
                    setMatchers = [],
                    elementMatchers = [],
                    cached = compilerCache[selector + " "];

                if (!cached) {
                    // Generate a function of recursive functions that can be used to check each element
                    if (!match) {
                        match = tokenize(selector);
                    }
                    i = match.length;
                    while (i--) {
                        cached = matcherFromTokens(match[i]);
                        if (cached[expando]) {
                            setMatchers.push(cached);
                        } else {
                            elementMatchers.push(cached);
                        }
                    }

                    // Cache the compiled function
                    cached = compilerCache(
                        selector,
                        matcherFromGroupMatchers(elementMatchers, setMatchers)
                    );

                    // Save selector and tokenization
                    cached.selector = selector;
                }
                return cached;
            };

            /**
             * A low-level selection function that works with Sizzle's compiled
             *  selector functions
             * @param {String|Function} selector A selector or a pre-compiled
             *  selector function built with Sizzle.compile
             * @param {Element} context
             * @param {Array} [results]
             * @param {Array} [seed] A set of elements to match against
             */
            select = Sizzle.select = function (
                selector,
                context,
                results,
                seed
            ) {
                var i,
                    tokens,
                    token,
                    type,
                    find,
                    compiled = typeof selector === "function" && selector,
                    match =
                        !seed &&
                        tokenize((selector = compiled.selector || selector));

                results = results || [];

                // Try to minimize operations if there is only one selector in the list and no seed
                // (the latter of which guarantees us context)
                if (match.length === 1) {
                    // Reduce context if the leading compound selector is an ID
                    tokens = match[0] = match[0].slice(0);
                    if (
                        tokens.length > 2 &&
                        (token = tokens[0]).type === "ID" &&
                        context.nodeType === 9 &&
                        documentIsHTML &&
                        Expr.relative[tokens[1].type]
                    ) {
                        context = (Expr.find["ID"](
                            token.matches[0].replace(runescape, funescape),
                            context
                        ) || [])[0];
                        if (!context) {
                            return results;

                            // Precompiled matchers will still verify ancestry, so step up a level
                        } else if (compiled) {
                            context = context.parentNode;
                        }

                        selector = selector.slice(tokens.shift().value.length);
                    }

                    // Fetch a seed set for right-to-left matching
                    i = matchExpr["needsContext"].test(selector)
                        ? 0
                        : tokens.length;
                    while (i--) {
                        token = tokens[i];

                        // Abort if we hit a combinator
                        if (Expr.relative[(type = token.type)]) {
                            break;
                        }
                        if ((find = Expr.find[type])) {
                            // Search, expanding context for leading sibling combinators
                            if (
                                (seed = find(
                                    token.matches[0].replace(
                                        runescape,
                                        funescape
                                    ),
                                    (rsibling.test(tokens[0].type) &&
                                        testContext(context.parentNode)) ||
                                        context
                                ))
                            ) {
                                // If seed is empty or no tokens remain, we can return early
                                tokens.splice(i, 1);
                                selector = seed.length && toSelector(tokens);
                                if (!selector) {
                                    push.apply(results, seed);
                                    return results;
                                }

                                break;
                            }
                        }
                    }
                }

                // Compile and execute a filtering function if one is not provided
                // Provide `match` to avoid retokenization if we modified the selector above
                (compiled || compile(selector, match))(
                    seed,
                    context,
                    !documentIsHTML,
                    results,
                    !context ||
                        (rsibling.test(selector) &&
                            testContext(context.parentNode)) ||
                        context
                );
                return results;
            };

            // One-time assignments

            // Sort stability
            support.sortStable =
                expando.split("").sort(sortOrder).join("") === expando;

            // Support: Chrome 14-35+
            // Always assume duplicates if they aren't passed to the comparison function
            support.detectDuplicates = !!hasDuplicate;

            // Initialize against the default document
            setDocument();

            // Support: Webkit<537.32 - Safari 6.0.3/Chrome 25 (fixed in Chrome 27)
            // Detached nodes confoundingly follow *each other*
            support.sortDetached = assert(function (el) {
                // Should return 1, but returns 4 (following)
                return (
                    el.compareDocumentPosition(
                        document.createElement("fieldset")
                    ) & 1
                );
            });

            // Support: IE<8
            // Prevent attribute/property "interpolation"
            // https://msdn.microsoft.com/en-us/library/ms536429%28VS.85%29.aspx
            if (
                !assert(function (el) {
                    el.innerHTML = "<a href='#'></a>";
                    return el.firstChild.getAttribute("href") === "#";
                })
            ) {
                addHandle(
                    "type|href|height|width",
                    function (elem, name, isXML) {
                        if (!isXML) {
                            return elem.getAttribute(
                                name,
                                name.toLowerCase() === "type" ? 1 : 2
                            );
                        }
                    }
                );
            }

            // Support: IE<9
            // Use defaultValue in place of getAttribute("value")
            if (
                !support.attributes ||
                !assert(function (el) {
                    el.innerHTML = "<input/>";
                    el.firstChild.setAttribute("value", "");
                    return el.firstChild.getAttribute("value") === "";
                })
            ) {
                addHandle("value", function (elem, _name, isXML) {
                    if (!isXML && elem.nodeName.toLowerCase() === "input") {
                        return elem.defaultValue;
                    }
                });
            }

            // Support: IE<9
            // Use getAttributeNode to fetch booleans when getAttribute lies
            if (
                !assert(function (el) {
                    return el.getAttribute("disabled") == null;
                })
            ) {
                addHandle(booleans, function (elem, name, isXML) {
                    var val;
                    if (!isXML) {
                        return elem[name] === true
                            ? name.toLowerCase()
                            : (val = elem.getAttributeNode(name)) &&
                              val.specified
                            ? val.value
                            : null;
                    }
                });
            }

            return Sizzle;
        })(window);

    jQuery.find = Sizzle;
    jQuery.expr = Sizzle.selectors;

    // Deprecated
    jQuery.expr[":"] = jQuery.expr.pseudos;
    jQuery.uniqueSort = jQuery.unique = Sizzle.uniqueSort;
    jQuery.text = Sizzle.getText;
    jQuery.isXMLDoc = Sizzle.isXML;
    jQuery.contains = Sizzle.contains;
    jQuery.escapeSelector = Sizzle.escape;

    var dir = function (elem, dir, until) {
        var matched = [],
            truncate = until !== undefined;

        while ((elem = elem[dir]) && elem.nodeType !== 9) {
            if (elem.nodeType === 1) {
                if (truncate && jQuery(elem).is(until)) {
                    break;
                }
                matched.push(elem);
            }
        }
        return matched;
    };

    var siblings = function (n, elem) {
        var matched = [];

        for (; n; n = n.nextSibling) {
            if (n.nodeType === 1 && n !== elem) {
                matched.push(n);
            }
        }

        return matched;
    };

    var rneedsContext = jQuery.expr.match.needsContext;

    function nodeName(elem, name) {
        return (
            elem.nodeName && elem.nodeName.toLowerCase() === name.toLowerCase()
        );
    }
    var rsingleTag =
        /^<([a-z][^\/\0>:\x20\t\r\n\f]*)[\x20\t\r\n\f]*\/?>(?:<\/\1>|)$/i;

    // Implement the identical functionality for filter and not
    function winnow(elements, qualifier, not) {
        if (isFunction(qualifier)) {
            return jQuery.grep(elements, function (elem, i) {
                return !!qualifier.call(elem, i, elem) !== not;
            });
        }

        // Single element
        if (qualifier.nodeType) {
            return jQuery.grep(elements, function (elem) {
                return (elem === qualifier) !== not;
            });
        }

        // Arraylike of elements (jQuery, arguments, Array)
        if (typeof qualifier !== "string") {
            return jQuery.grep(elements, function (elem) {
                return indexOf.call(qualifier, elem) > -1 !== not;
            });
        }

        // Filtered directly for both simple and complex selectors
        return jQuery.filter(qualifier, elements, not);
    }

    jQuery.filter = function (expr, elems, not) {
        var elem = elems[0];

        if (not) {
            expr = ":not(" + expr + ")";
        }

        if (elems.length === 1 && elem.nodeType === 1) {
            return jQuery.find.matchesSelector(elem, expr) ? [elem] : [];
        }

        return jQuery.find.matches(
            expr,
            jQuery.grep(elems, function (elem) {
                return elem.nodeType === 1;
            })
        );
    };

    jQuery.fn.extend({
        find: function (selector) {
            var i,
                ret,
                len = this.length,
                self = this;

            if (typeof selector !== "string") {
                return this.pushStack(
                    jQuery(selector).filter(function () {
                        for (i = 0; i < len; i++) {
                            if (jQuery.contains(self[i], this)) {
                                return true;
                            }
                        }
                    })
                );
            }

            ret = this.pushStack([]);

            for (i = 0; i < len; i++) {
                jQuery.find(selector, self[i], ret);
            }

            return len > 1 ? jQuery.uniqueSort(ret) : ret;
        },
        filter: function (selector) {
            return this.pushStack(winnow(this, selector || [], false));
        },
        not: function (selector) {
            return this.pushStack(winnow(this, selector || [], true));
        },
        is: function (selector) {
            return !!winnow(
                this,

                // If this is a positional/relative selector, check membership in the returned set
                // so $("p:first").is("p:last") won't return true for a doc with two "p".
                typeof selector === "string" && rneedsContext.test(selector)
                    ? jQuery(selector)
                    : selector || [],
                false
            ).length;
        },
    });

    // Initialize a jQuery object

    // A central reference to the root jQuery(document)
    var rootjQuery,
        // A simple way to check for HTML strings
        // Prioritize #id over <tag> to avoid XSS via location.hash (#9521)
        // Strict HTML recognition (#11290: must start with <)
        // Shortcut simple #id case for speed
        rquickExpr = /^(?:\s*(<[\w\W]+>)[^>]*|#([\w-]+))$/,
        init = (jQuery.fn.init = function (selector, context, root) {
            var match, elem;

            // HANDLE: $(""), $(null), $(undefined), $(false)
            if (!selector) {
                return this;
            }

            // Method init() accepts an alternate rootjQuery
            // so migrate can support jQuery.sub (gh-2101)
            root = root || rootjQuery;

            // Handle HTML strings
            if (typeof selector === "string") {
                if (
                    selector[0] === "<" &&
                    selector[selector.length - 1] === ">" &&
                    selector.length >= 3
                ) {
                    // Assume that strings that start and end with <> are HTML and skip the regex check
                    match = [null, selector, null];
                } else {
                    match = rquickExpr.exec(selector);
                }

                // Match html or make sure no context is specified for #id
                if (match && (match[1] || !context)) {
                    // HANDLE: $(html) -> $(array)
                    if (match[1]) {
                        context =
                            context instanceof jQuery ? context[0] : context;

                        // Option to run scripts is true for back-compat
                        // Intentionally let the error be thrown if parseHTML is not present
                        jQuery.merge(
                            this,
                            jQuery.parseHTML(
                                match[1],
                                context && context.nodeType
                                    ? context.ownerDocument || context
                                    : document,
                                true
                            )
                        );

                        // HANDLE: $(html, props)
                        if (
                            rsingleTag.test(match[1]) &&
                            jQuery.isPlainObject(context)
                        ) {
                            for (match in context) {
                                // Properties of context are called as methods if possible
                                if (isFunction(this[match])) {
                                    this[match](context[match]);

                                    // ...and otherwise set as attributes
                                } else {
                                    this.attr(match, context[match]);
                                }
                            }
                        }

                        return this;

                        // HANDLE: $(#id)
                    } else {
                        elem = document.getElementById(match[2]);

                        if (elem) {
                            // Inject the element directly into the jQuery object
                            this[0] = elem;
                            this.length = 1;
                        }
                        return this;
                    }

                    // HANDLE: $(expr, $(...))
                } else if (!context || context.jquery) {
                    return (context || root).find(selector);

                    // HANDLE: $(expr, context)
                    // (which is just equivalent to: $(context).find(expr)
                } else {
                    return this.constructor(context).find(selector);
                }

                // HANDLE: $(DOMElement)
            } else if (selector.nodeType) {
                this[0] = selector;
                this.length = 1;
                return this;

                // HANDLE: $(function)
                // Shortcut for document ready
            } else if (isFunction(selector)) {
                return root.ready !== undefined
                    ? root.ready(selector)
                    : // Execute immediately if ready is not present
                      selector(jQuery);
            }

            return jQuery.makeArray(selector, this);
        });

    // Give the init function the jQuery prototype for later instantiation
    init.prototype = jQuery.fn;

    // Initialize central reference
    rootjQuery = jQuery(document);

    var rparentsprev = /^(?:parents|prev(?:Until|All))/,
        // Methods guaranteed to produce a unique set when starting from a unique set
        guaranteedUnique = {
            children: true,
            contents: true,
            next: true,
            prev: true,
        };

    jQuery.fn.extend({
        has: function (target) {
            var targets = jQuery(target, this),
                l = targets.length;

            return this.filter(function () {
                var i = 0;
                for (; i < l; i++) {
                    if (jQuery.contains(this, targets[i])) {
                        return true;
                    }
                }
            });
        },

        closest: function (selectors, context) {
            var cur,
                i = 0,
                l = this.length,
                matched = [],
                targets = typeof selectors !== "string" && jQuery(selectors);

            // Positional selectors never match, since there's no _selection_ context
            if (!rneedsContext.test(selectors)) {
                for (; i < l; i++) {
                    for (
                        cur = this[i];
                        cur && cur !== context;
                        cur = cur.parentNode
                    ) {
                        // Always skip document fragments
                        if (
                            cur.nodeType < 11 &&
                            (targets
                                ? targets.index(cur) > -1
                                : // Don't pass non-elements to Sizzle
                                  cur.nodeType === 1 &&
                                  jQuery.find.matchesSelector(cur, selectors))
                        ) {
                            matched.push(cur);
                            break;
                        }
                    }
                }
            }

            return this.pushStack(
                matched.length > 1 ? jQuery.uniqueSort(matched) : matched
            );
        },

        // Determine the position of an element within the set
        index: function (elem) {
            // No argument, return index in parent
            if (!elem) {
                return this[0] && this[0].parentNode
                    ? this.first().prevAll().length
                    : -1;
            }

            // Index in selector
            if (typeof elem === "string") {
                return indexOf.call(jQuery(elem), this[0]);
            }

            // Locate the position of the desired element
            return indexOf.call(
                this,

                // If it receives a jQuery object, the first element is used
                elem.jquery ? elem[0] : elem
            );
        },

        add: function (selector, context) {
            return this.pushStack(
                jQuery.uniqueSort(
                    jQuery.merge(this.get(), jQuery(selector, context))
                )
            );
        },

        addBack: function (selector) {
            return this.add(
                selector == null
                    ? this.prevObject
                    : this.prevObject.filter(selector)
            );
        },
    });

    function sibling(cur, dir) {
        while ((cur = cur[dir]) && cur.nodeType !== 1) {}
        return cur;
    }

    jQuery.each(
        {
            parent: function (elem) {
                var parent = elem.parentNode;
                return parent && parent.nodeType !== 11 ? parent : null;
            },
            parents: function (elem) {
                return dir(elem, "parentNode");
            },
            parentsUntil: function (elem, _i, until) {
                return dir(elem, "parentNode", until);
            },
            next: function (elem) {
                return sibling(elem, "nextSibling");
            },
            prev: function (elem) {
                return sibling(elem, "previousSibling");
            },
            nextAll: function (elem) {
                return dir(elem, "nextSibling");
            },
            prevAll: function (elem) {
                return dir(elem, "previousSibling");
            },
            nextUntil: function (elem, _i, until) {
                return dir(elem, "nextSibling", until);
            },
            prevUntil: function (elem, _i, until) {
                return dir(elem, "previousSibling", until);
            },
            siblings: function (elem) {
                return siblings((elem.parentNode || {}).firstChild, elem);
            },
            children: function (elem) {
                return siblings(elem.firstChild);
            },
            contents: function (elem) {
                if (
                    elem.contentDocument != null &&
                    // Support: IE 11+
                    // <object> elements with no `data` attribute has an object
                    // `contentDocument` with a `null` prototype.
                    getProto(elem.contentDocument)
                ) {
                    return elem.contentDocument;
                }

                // Support: IE 9 - 11 only, iOS 7 only, Android Browser <=4.3 only
                // Treat the template element as a regular one in browsers that
                // don't support it.
                if (nodeName(elem, "template")) {
                    elem = elem.content || elem;
                }

                return jQuery.merge([], elem.childNodes);
            },
        },
        function (name, fn) {
            jQuery.fn[name] = function (until, selector) {
                var matched = jQuery.map(this, fn, until);

                if (name.slice(-5) !== "Until") {
                    selector = until;
                }

                if (selector && typeof selector === "string") {
                    matched = jQuery.filter(selector, matched);
                }

                if (this.length > 1) {
                    // Remove duplicates
                    if (!guaranteedUnique[name]) {
                        jQuery.uniqueSort(matched);
                    }

                    // Reverse order for parents* and prev-derivatives
                    if (rparentsprev.test(name)) {
                        matched.reverse();
                    }
                }

                return this.pushStack(matched);
            };
        }
    );
    var rnothtmlwhite = /[^\x20\t\r\n\f]+/g;

    // Convert String-formatted options into Object-formatted ones
    function createOptions(options) {
        var object = {};
        jQuery.each(options.match(rnothtmlwhite) || [], function (_, flag) {
            object[flag] = true;
        });
        return object;
    }

    /*
     * Create a callback list using the following parameters:
     *
     *	options: an optional list of space-separated options that will change how
     *			the callback list behaves or a more traditional option object
     *
     * By default a callback list will act like an event callback list and can be
     * "fired" multiple times.
     *
     * Possible options:
     *
     *	once:			will ensure the callback list can only be fired once (like a Deferred)
     *
     *	memory:			will keep track of previous values and will call any callback added
     *					after the list has been fired right away with the latest "memorized"
     *					values (like a Deferred)
     *
     *	unique:			will ensure a callback can only be added once (no duplicate in the list)
     *
     *	stopOnFalse:	interrupt callings when a callback returns false
     *
     */
    jQuery.Callbacks = function (options) {
        // Convert options from String-formatted to Object-formatted if needed
        // (we check in cache first)
        options =
            typeof options === "string"
                ? createOptions(options)
                : jQuery.extend({}, options);

        var // Flag to know if list is currently firing
            firing,
            // Last fire value for non-forgettable lists
            memory,
            // Flag to know if list was already fired
            fired,
            // Flag to prevent firing
            locked,
            // Actual callback list
            list = [],
            // Queue of execution data for repeatable lists
            queue = [],
            // Index of currently firing callback (modified by add/remove as needed)
            firingIndex = -1,
            // Fire callbacks
            fire = function () {
                // Enforce single-firing
                locked = locked || options.once;

                // Execute callbacks for all pending executions,
                // respecting firingIndex overrides and runtime changes
                fired = firing = true;
                for (; queue.length; firingIndex = -1) {
                    memory = queue.shift();
                    while (++firingIndex < list.length) {
                        // Run callback and check for early termination
                        if (
                            list[firingIndex].apply(memory[0], memory[1]) ===
                                false &&
                            options.stopOnFalse
                        ) {
                            // Jump to end and forget the data so .add doesn't re-fire
                            firingIndex = list.length;
                            memory = false;
                        }
                    }
                }

                // Forget the data if we're done with it
                if (!options.memory) {
                    memory = false;
                }

                firing = false;

                // Clean up if we're done firing for good
                if (locked) {
                    // Keep an empty list if we have data for future add calls
                    if (memory) {
                        list = [];

                        // Otherwise, this object is spent
                    } else {
                        list = "";
                    }
                }
            },
            // Actual Callbacks object
            self = {
                // Add a callback or a collection of callbacks to the list
                add: function () {
                    if (list) {
                        // If we have memory from a past run, we should fire after adding
                        if (memory && !firing) {
                            firingIndex = list.length - 1;
                            queue.push(memory);
                        }

                        (function add(args) {
                            jQuery.each(args, function (_, arg) {
                                if (isFunction(arg)) {
                                    if (!options.unique || !self.has(arg)) {
                                        list.push(arg);
                                    }
                                } else if (
                                    arg &&
                                    arg.length &&
                                    toType(arg) !== "string"
                                ) {
                                    // Inspect recursively
                                    add(arg);
                                }
                            });
                        })(arguments);

                        if (memory && !firing) {
                            fire();
                        }
                    }
                    return this;
                },

                // Remove a callback from the list
                remove: function () {
                    jQuery.each(arguments, function (_, arg) {
                        var index;
                        while (
                            (index = jQuery.inArray(arg, list, index)) > -1
                        ) {
                            list.splice(index, 1);

                            // Handle firing indexes
                            if (index <= firingIndex) {
                                firingIndex--;
                            }
                        }
                    });
                    return this;
                },

                // Check if a given callback is in the list.
                // If no argument is given, return whether or not list has callbacks attached.
                has: function (fn) {
                    return fn ? jQuery.inArray(fn, list) > -1 : list.length > 0;
                },

                // Remove all callbacks from the list
                empty: function () {
                    if (list) {
                        list = [];
                    }
                    return this;
                },

                // Disable .fire and .add
                // Abort any current/pending executions
                // Clear all callbacks and values
                disable: function () {
                    locked = queue = [];
                    list = memory = "";
                    return this;
                },
                disabled: function () {
                    return !list;
                },

                // Disable .fire
                // Also disable .add unless we have memory (since it would have no effect)
                // Abort any pending executions
                lock: function () {
                    locked = queue = [];
                    if (!memory && !firing) {
                        list = memory = "";
                    }
                    return this;
                },
                locked: function () {
                    return !!locked;
                },

                // Call all callbacks with the given context and arguments
                fireWith: function (context, args) {
                    if (!locked) {
                        args = args || [];
                        args = [context, args.slice ? args.slice() : args];
                        queue.push(args);
                        if (!firing) {
                            fire();
                        }
                    }
                    return this;
                },

                // Call all the callbacks with the given arguments
                fire: function () {
                    self.fireWith(this, arguments);
                    return this;
                },

                // To know if the callbacks have already been called at least once
                fired: function () {
                    return !!fired;
                },
            };

        return self;
    };

    function Identity(v) {
        return v;
    }
    function Thrower(ex) {
        throw ex;
    }

    function adoptValue(value, resolve, reject, noValue) {
        var method;

        try {
            // Check for promise aspect first to privilege synchronous behavior
            if (value && isFunction((method = value.promise))) {
                method.call(value).done(resolve).fail(reject);

                // Other thenables
            } else if (value && isFunction((method = value.then))) {
                method.call(value, resolve, reject);

                // Other non-thenables
            } else {
                // Control `resolve` arguments by letting Array#slice cast boolean `noValue` to integer:
                // * false: [ value ].slice( 0 ) => resolve( value )
                // * true: [ value ].slice( 1 ) => resolve()
                resolve.apply(undefined, [value].slice(noValue));
            }

            // For Promises/A+, convert exceptions into rejections
            // Since jQuery.when doesn't unwrap thenables, we can skip the extra checks appearing in
            // Deferred#then to conditionally suppress rejection.
        } catch (value) {
            // Support: Android 4.0 only
            // Strict mode functions invoked without .call/.apply get global-object context
            reject.apply(undefined, [value]);
        }
    }

    jQuery.extend({
        Deferred: function (func) {
            var tuples = [
                    // action, add listener, callbacks,
                    // ... .then handlers, argument index, [final state]
                    [
                        "notify",
                        "progress",
                        jQuery.Callbacks("memory"),
                        jQuery.Callbacks("memory"),
                        2,
                    ],
                    [
                        "resolve",
                        "done",
                        jQuery.Callbacks("once memory"),
                        jQuery.Callbacks("once memory"),
                        0,
                        "resolved",
                    ],
                    [
                        "reject",
                        "fail",
                        jQuery.Callbacks("once memory"),
                        jQuery.Callbacks("once memory"),
                        1,
                        "rejected",
                    ],
                ],
                state = "pending",
                promise = {
                    state: function () {
                        return state;
                    },
                    always: function () {
                        deferred.done(arguments).fail(arguments);
                        return this;
                    },
                    catch: function (fn) {
                        return promise.then(null, fn);
                    },

                    // Keep pipe for back-compat
                    pipe: function (/* fnDone, fnFail, fnProgress */) {
                        var fns = arguments;

                        return jQuery
                            .Deferred(function (newDefer) {
                                jQuery.each(tuples, function (_i, tuple) {
                                    // Map tuples (progress, done, fail) to arguments (done, fail, progress)
                                    var fn =
                                        isFunction(fns[tuple[4]]) &&
                                        fns[tuple[4]];

                                    // deferred.progress(function() { bind to newDefer or newDefer.notify })
                                    // deferred.done(function() { bind to newDefer or newDefer.resolve })
                                    // deferred.fail(function() { bind to newDefer or newDefer.reject })
                                    deferred[tuple[1]](function () {
                                        var returned =
                                            fn && fn.apply(this, arguments);
                                        if (
                                            returned &&
                                            isFunction(returned.promise)
                                        ) {
                                            returned
                                                .promise()
                                                .progress(newDefer.notify)
                                                .done(newDefer.resolve)
                                                .fail(newDefer.reject);
                                        } else {
                                            newDefer[tuple[0] + "With"](
                                                this,
                                                fn ? [returned] : arguments
                                            );
                                        }
                                    });
                                });
                                fns = null;
                            })
                            .promise();
                    },
                    then: function (onFulfilled, onRejected, onProgress) {
                        var maxDepth = 0;
                        function resolve(depth, deferred, handler, special) {
                            return function () {
                                var that = this,
                                    args = arguments,
                                    mightThrow = function () {
                                        var returned, then;

                                        // Support: Promises/A+ section 2.3.3.3.3
                                        // https://promisesaplus.com/#point-59
                                        // Ignore double-resolution attempts
                                        if (depth < maxDepth) {
                                            return;
                                        }

                                        returned = handler.apply(that, args);

                                        // Support: Promises/A+ section 2.3.1
                                        // https://promisesaplus.com/#point-48
                                        if (returned === deferred.promise()) {
                                            throw new TypeError(
                                                "Thenable self-resolution"
                                            );
                                        }

                                        // Support: Promises/A+ sections 2.3.3.1, 3.5
                                        // https://promisesaplus.com/#point-54
                                        // https://promisesaplus.com/#point-75
                                        // Retrieve `then` only once
                                        then =
                                            returned &&
                                            // Support: Promises/A+ section 2.3.4
                                            // https://promisesaplus.com/#point-64
                                            // Only check objects and functions for thenability
                                            (typeof returned === "object" ||
                                                typeof returned ===
                                                    "function") &&
                                            returned.then;

                                        // Handle a returned thenable
                                        if (isFunction(then)) {
                                            // Special processors (notify) just wait for resolution
                                            if (special) {
                                                then.call(
                                                    returned,
                                                    resolve(
                                                        maxDepth,
                                                        deferred,
                                                        Identity,
                                                        special
                                                    ),
                                                    resolve(
                                                        maxDepth,
                                                        deferred,
                                                        Thrower,
                                                        special
                                                    )
                                                );

                                                // Normal processors (resolve) also hook into progress
                                            } else {
                                                // ...and disregard older resolution values
                                                maxDepth++;

                                                then.call(
                                                    returned,
                                                    resolve(
                                                        maxDepth,
                                                        deferred,
                                                        Identity,
                                                        special
                                                    ),
                                                    resolve(
                                                        maxDepth,
                                                        deferred,
                                                        Thrower,
                                                        special
                                                    ),
                                                    resolve(
                                                        maxDepth,
                                                        deferred,
                                                        Identity,
                                                        deferred.notifyWith
                                                    )
                                                );
                                            }

                                            // Handle all other returned values
                                        } else {
                                            // Only substitute handlers pass on context
                                            // and multiple values (non-spec behavior)
                                            if (handler !== Identity) {
                                                that = undefined;
                                                args = [returned];
                                            }

                                            // Process the value(s)
                                            // Default process is resolve
                                            (special || deferred.resolveWith)(
                                                that,
                                                args
                                            );
                                        }
                                    },
                                    // Only normal processors (resolve) catch and reject exceptions
                                    process = special
                                        ? mightThrow
                                        : function () {
                                              try {
                                                  mightThrow();
                                              } catch (e) {
                                                  if (
                                                      jQuery.Deferred
                                                          .exceptionHook
                                                  ) {
                                                      jQuery.Deferred.exceptionHook(
                                                          e,
                                                          process.stackTrace
                                                      );
                                                  }

                                                  // Support: Promises/A+ section 2.3.3.3.4.1
                                                  // https://promisesaplus.com/#point-61
                                                  // Ignore post-resolution exceptions
                                                  if (depth + 1 >= maxDepth) {
                                                      // Only substitute handlers pass on context
                                                      // and multiple values (non-spec behavior)
                                                      if (handler !== Thrower) {
                                                          that = undefined;
                                                          args = [e];
                                                      }

                                                      deferred.rejectWith(
                                                          that,
                                                          args
                                                      );
                                                  }
                                              }
                                          };

                                // Support: Promises/A+ section 2.3.3.3.1
                                // https://promisesaplus.com/#point-57
                                // Re-resolve promises immediately to dodge false rejection from
                                // subsequent errors
                                if (depth) {
                                    process();
                                } else {
                                    // Call an optional hook to record the stack, in case of exception
                                    // since it's otherwise lost when execution goes async
                                    if (jQuery.Deferred.getStackHook) {
                                        process.stackTrace =
                                            jQuery.Deferred.getStackHook();
                                    }
                                    window.setTimeout(process);
                                }
                            };
                        }

                        return jQuery
                            .Deferred(function (newDefer) {
                                // progress_handlers.add( ... )
                                tuples[0][3].add(
                                    resolve(
                                        0,
                                        newDefer,
                                        isFunction(onProgress)
                                            ? onProgress
                                            : Identity,
                                        newDefer.notifyWith
                                    )
                                );

                                // fulfilled_handlers.add( ... )
                                tuples[1][3].add(
                                    resolve(
                                        0,
                                        newDefer,
                                        isFunction(onFulfilled)
                                            ? onFulfilled
                                            : Identity
                                    )
                                );

                                // rejected_handlers.add( ... )
                                tuples[2][3].add(
                                    resolve(
                                        0,
                                        newDefer,
                                        isFunction(onRejected)
                                            ? onRejected
                                            : Thrower
                                    )
                                );
                            })
                            .promise();
                    },

                    // Get a promise for this deferred
                    // If obj is provided, the promise aspect is added to the object
                    promise: function (obj) {
                        return obj != null
                            ? jQuery.extend(obj, promise)
                            : promise;
                    },
                },
                deferred = {};

            // Add list-specific methods
            jQuery.each(tuples, function (i, tuple) {
                var list = tuple[2],
                    stateString = tuple[5];

                // promise.progress = list.add
                // promise.done = list.add
                // promise.fail = list.add
                promise[tuple[1]] = list.add;

                // Handle state
                if (stateString) {
                    list.add(
                        function () {
                            // state = "resolved" (i.e., fulfilled)
                            // state = "rejected"
                            state = stateString;
                        },

                        // rejected_callbacks.disable
                        // fulfilled_callbacks.disable
                        tuples[3 - i][2].disable,

                        // rejected_handlers.disable
                        // fulfilled_handlers.disable
                        tuples[3 - i][3].disable,

                        // progress_callbacks.lock
                        tuples[0][2].lock,

                        // progress_handlers.lock
                        tuples[0][3].lock
                    );
                }

                // progress_handlers.fire
                // fulfilled_handlers.fire
                // rejected_handlers.fire
                list.add(tuple[3].fire);

                // deferred.notify = function() { deferred.notifyWith(...) }
                // deferred.resolve = function() { deferred.resolveWith(...) }
                // deferred.reject = function() { deferred.rejectWith(...) }
                deferred[tuple[0]] = function () {
                    deferred[tuple[0] + "With"](
                        this === deferred ? undefined : this,
                        arguments
                    );
                    return this;
                };

                // deferred.notifyWith = list.fireWith
                // deferred.resolveWith = list.fireWith
                // deferred.rejectWith = list.fireWith
                deferred[tuple[0] + "With"] = list.fireWith;
            });

            // Make the deferred a promise
            promise.promise(deferred);

            // Call given func if any
            if (func) {
                func.call(deferred, deferred);
            }

            // All done!
            return deferred;
        },

        // Deferred helper
        when: function (singleValue) {
            var // count of uncompleted subordinates
                remaining = arguments.length,
                // count of unprocessed arguments
                i = remaining,
                // subordinate fulfillment data
                resolveContexts = Array(i),
                resolveValues = slice.call(arguments),
                // the primary Deferred
                primary = jQuery.Deferred(),
                // subordinate callback factory
                updateFunc = function (i) {
                    return function (value) {
                        resolveContexts[i] = this;
                        resolveValues[i] =
                            arguments.length > 1
                                ? slice.call(arguments)
                                : value;
                        if (!--remaining) {
                            primary.resolveWith(resolveContexts, resolveValues);
                        }
                    };
                };

            // Single- and empty arguments are adopted like Promise.resolve
            if (remaining <= 1) {
                adoptValue(
                    singleValue,
                    primary.done(updateFunc(i)).resolve,
                    primary.reject,
                    !remaining
                );

                // Use .then() to unwrap secondary thenables (cf. gh-3000)
                if (
                    primary.state() === "pending" ||
                    isFunction(resolveValues[i] && resolveValues[i].then)
                ) {
                    return primary.then();
                }
            }

            // Multiple arguments are aggregated like Promise.all array elements
            while (i--) {
                adoptValue(resolveValues[i], updateFunc(i), primary.reject);
            }

            return primary.promise();
        },
    });

    // These usually indicate a programmer mistake during development,
    // warn about them ASAP rather than swallowing them by default.
    var rerrorNames = /^(Eval|Internal|Range|Reference|Syntax|Type|URI)Error$/;

    jQuery.Deferred.exceptionHook = function (error, stack) {
        // Support: IE 8 - 9 only
        // Console exists when dev tools are open, which can happen at any time
        if (
            window.console &&
            window.console.warn &&
            error &&
            rerrorNames.test(error.name)
        ) {
            window.console.warn(
                "jQuery.Deferred exception: " + error.message,
                error.stack,
                stack
            );
        }
    };

    jQuery.readyException = function (error) {
        window.setTimeout(function () {
            throw error;
        });
    };

    // The deferred used on DOM ready
    var readyList = jQuery.Deferred();

    jQuery.fn.ready = function (fn) {
        readyList
            .then(fn)

            // Wrap jQuery.readyException in a function so that the lookup
            // happens at the time of error handling instead of callback
            // registration.
            .catch(function (error) {
                jQuery.readyException(error);
            });

        return this;
    };

    jQuery.extend({
        // Is the DOM ready to be used? Set to true once it occurs.
        isReady: false,

        // A counter to track how many items to wait for before
        // the ready event fires. See #6781
        readyWait: 1,

        // Handle when the DOM is ready
        ready: function (wait) {
            // Abort if there are pending holds or we're already ready
            if (wait === true ? --jQuery.readyWait : jQuery.isReady) {
                return;
            }

            // Remember that the DOM is ready
            jQuery.isReady = true;

            // If a normal DOM Ready event fired, decrement, and wait if need be
            if (wait !== true && --jQuery.readyWait > 0) {
                return;
            }

            // If there are functions bound, to execute
            readyList.resolveWith(document, [jQuery]);
        },
    });

    jQuery.ready.then = readyList.then;

    // The ready event handler and self cleanup method
    function completed() {
        document.removeEventListener("DOMContentLoaded", completed);
        window.removeEventListener("load", completed);
        jQuery.ready();
    }

    // Catch cases where $(document).ready() is called
    // after the browser event has already occurred.
    // Support: IE <=9 - 10 only
    // Older IE sometimes signals "interactive" too soon
    if (
        document.readyState === "complete" ||
        (document.readyState !== "loading" &&
            !document.documentElement.doScroll)
    ) {
        // Handle it asynchronously to allow scripts the opportunity to delay ready
        window.setTimeout(jQuery.ready);
    } else {
        // Use the handy event callback
        document.addEventListener("DOMContentLoaded", completed);

        // A fallback to window.onload, that will always work
        window.addEventListener("load", completed);
    }

    // Multifunctional method to get and set values of a collection
    // The value/s can optionally be executed if it's a function
    var access = function (elems, fn, key, value, chainable, emptyGet, raw) {
        var i = 0,
            len = elems.length,
            bulk = key == null;

        // Sets many values
        if (toType(key) === "object") {
            chainable = true;
            for (i in key) {
                access(elems, fn, i, key[i], true, emptyGet, raw);
            }

            // Sets one value
        } else if (value !== undefined) {
            chainable = true;

            if (!isFunction(value)) {
                raw = true;
            }

            if (bulk) {
                // Bulk operations run against the entire set
                if (raw) {
                    fn.call(elems, value);
                    fn = null;

                    // ...except when executing function values
                } else {
                    bulk = fn;
                    fn = function (elem, _key, value) {
                        return bulk.call(jQuery(elem), value);
                    };
                }
            }

            if (fn) {
                for (; i < len; i++) {
                    fn(
                        elems[i],
                        key,
                        raw ? value : value.call(elems[i], i, fn(elems[i], key))
                    );
                }
            }
        }

        if (chainable) {
            return elems;
        }

        // Gets
        if (bulk) {
            return fn.call(elems);
        }

        return len ? fn(elems[0], key) : emptyGet;
    };

    // Matches dashed string for camelizing
    var rmsPrefix = /^-ms-/,
        rdashAlpha = /-([a-z])/g;

    // Used by camelCase as callback to replace()
    function fcamelCase(_all, letter) {
        return letter.toUpperCase();
    }

    // Convert dashed to camelCase; used by the css and data modules
    // Support: IE <=9 - 11, Edge 12 - 15
    // Microsoft forgot to hump their vendor prefix (#9572)
    function camelCase(string) {
        return string.replace(rmsPrefix, "ms-").replace(rdashAlpha, fcamelCase);
    }
    var acceptData = function (owner) {
        // Accepts only:
        //  - Node
        //    - Node.ELEMENT_NODE
        //    - Node.DOCUMENT_NODE
        //  - Object
        //    - Any
        return owner.nodeType === 1 || owner.nodeType === 9 || !+owner.nodeType;
    };

    function Data() {
        this.expando = jQuery.expando + Data.uid++;
    }

    Data.uid = 1;

    Data.prototype = {
        cache: function (owner) {
            // Check if the owner object already has a cache
            var value = owner[this.expando];

            // If not, create one
            if (!value) {
                value = {};

                // We can accept data for non-element nodes in modern browsers,
                // but we should not, see #8335.
                // Always return an empty object.
                if (acceptData(owner)) {
                    // If it is a node unlikely to be stringify-ed or looped over
                    // use plain assignment
                    if (owner.nodeType) {
                        owner[this.expando] = value;

                        // Otherwise secure it in a non-enumerable property
                        // configurable must be true to allow the property to be
                        // deleted when data is removed
                    } else {
                        Object.defineProperty(owner, this.expando, {
                            value: value,
                            configurable: true,
                        });
                    }
                }
            }

            return value;
        },
        set: function (owner, data, value) {
            var prop,
                cache = this.cache(owner);

            // Handle: [ owner, key, value ] args
            // Always use camelCase key (gh-2257)
            if (typeof data === "string") {
                cache[camelCase(data)] = value;

                // Handle: [ owner, { properties } ] args
            } else {
                // Copy the properties one-by-one to the cache object
                for (prop in data) {
                    cache[camelCase(prop)] = data[prop];
                }
            }
            return cache;
        },
        get: function (owner, key) {
            return key === undefined
                ? this.cache(owner)
                : // Always use camelCase key (gh-2257)
                  owner[this.expando] && owner[this.expando][camelCase(key)];
        },
        access: function (owner, key, value) {
            // In cases where either:
            //
            //   1. No key was specified
            //   2. A string key was specified, but no value provided
            //
            // Take the "read" path and allow the get method to determine
            // which value to return, respectively either:
            //
            //   1. The entire cache object
            //   2. The data stored at the key
            //
            if (
                key === undefined ||
                (key && typeof key === "string" && value === undefined)
            ) {
                return this.get(owner, key);
            }

            // When the key is not a string, or both a key and value
            // are specified, set or extend (existing objects) with either:
            //
            //   1. An object of properties
            //   2. A key and value
            //
            this.set(owner, key, value);

            // Since the "set" path can have two possible entry points
            // return the expected data based on which path was taken[*]
            return value !== undefined ? value : key;
        },
        remove: function (owner, key) {
            var i,
                cache = owner[this.expando];

            if (cache === undefined) {
                return;
            }

            if (key !== undefined) {
                // Support array or space separated string of keys
                if (Array.isArray(key)) {
                    // If key is an array of keys...
                    // We always set camelCase keys, so remove that.
                    key = key.map(camelCase);
                } else {
                    key = camelCase(key);

                    // If a key with the spaces exists, use it.
                    // Otherwise, create an array by matching non-whitespace
                    key = key in cache ? [key] : key.match(rnothtmlwhite) || [];
                }

                i = key.length;

                while (i--) {
                    delete cache[key[i]];
                }
            }

            // Remove the expando if there's no more data
            if (key === undefined || jQuery.isEmptyObject(cache)) {
                // Support: Chrome <=35 - 45
                // Webkit & Blink performance suffers when deleting properties
                // from DOM nodes, so set to undefined instead
                // https://bugs.chromium.org/p/chromium/issues/detail?id=378607 (bug restricted)
                if (owner.nodeType) {
                    owner[this.expando] = undefined;
                } else {
                    delete owner[this.expando];
                }
            }
        },
        hasData: function (owner) {
            var cache = owner[this.expando];
            return cache !== undefined && !jQuery.isEmptyObject(cache);
        },
    };
    var dataPriv = new Data();

    var dataUser = new Data();

    //	Implementation Summary
    //
    //	1. Enforce API surface and semantic compatibility with 1.9.x branch
    //	2. Improve the module's maintainability by reducing the storage
    //		paths to a single mechanism.
    //	3. Use the same single mechanism to support "private" and "user" data.
    //	4. _Never_ expose "private" data to user code (TODO: Drop _data, _removeData)
    //	5. Avoid exposing implementation details on user objects (eg. expando properties)
    //	6. Provide a clear path for implementation upgrade to WeakMap in 2014

    var rbrace = /^(?:\{[\w\W]*\}|\[[\w\W]*\])$/,
        rmultiDash = /[A-Z]/g;

    function getData(data) {
        if (data === "true") {
            return true;
        }

        if (data === "false") {
            return false;
        }

        if (data === "null") {
            return null;
        }

        // Only convert to a number if it doesn't change the string
        if (data === +data + "") {
            return +data;
        }

        if (rbrace.test(data)) {
            return JSON.parse(data);
        }

        return data;
    }

    function dataAttr(elem, key, data) {
        var name;

        // If nothing was found internally, try to fetch any
        // data from the HTML5 data-* attribute
        if (data === undefined && elem.nodeType === 1) {
            name = "data-" + key.replace(rmultiDash, "-$&").toLowerCase();
            data = elem.getAttribute(name);

            if (typeof data === "string") {
                try {
                    data = getData(data);
                } catch (e) {}

                // Make sure we set the data so it isn't changed later
                dataUser.set(elem, key, data);
            } else {
                data = undefined;
            }
        }
        return data;
    }

    jQuery.extend({
        hasData: function (elem) {
            return dataUser.hasData(elem) || dataPriv.hasData(elem);
        },

        data: function (elem, name, data) {
            return dataUser.access(elem, name, data);
        },

        removeData: function (elem, name) {
            dataUser.remove(elem, name);
        },

        // TODO: Now that all calls to _data and _removeData have been replaced
        // with direct calls to dataPriv methods, these can be deprecated.
        _data: function (elem, name, data) {
            return dataPriv.access(elem, name, data);
        },

        _removeData: function (elem, name) {
            dataPriv.remove(elem, name);
        },
    });

    jQuery.fn.extend({
        data: function (key, value) {
            var i,
                name,
                data,
                elem = this[0],
                attrs = elem && elem.attributes;

            // Gets all values
            if (key === undefined) {
                if (this.length) {
                    data = dataUser.get(elem);

                    if (
                        elem.nodeType === 1 &&
                        !dataPriv.get(elem, "hasDataAttrs")
                    ) {
                        i = attrs.length;
                        while (i--) {
                            // Support: IE 11 only
                            // The attrs elements can be null (#14894)
                            if (attrs[i]) {
                                name = attrs[i].name;
                                if (name.indexOf("data-") === 0) {
                                    name = camelCase(name.slice(5));
                                    dataAttr(elem, name, data[name]);
                                }
                            }
                        }
                        dataPriv.set(elem, "hasDataAttrs", true);
                    }
                }

                return data;
            }

            // Sets multiple values
            if (typeof key === "object") {
                return this.each(function () {
                    dataUser.set(this, key);
                });
            }

            return access(
                this,
                function (value) {
                    var data;

                    // The calling jQuery object (element matches) is not empty
                    // (and therefore has an element appears at this[ 0 ]) and the
                    // `value` parameter was not undefined. An empty jQuery object
                    // will result in `undefined` for elem = this[ 0 ] which will
                    // throw an exception if an attempt to read a data cache is made.
                    if (elem && value === undefined) {
                        // Attempt to get data from the cache
                        // The key will always be camelCased in Data
                        data = dataUser.get(elem, key);
                        if (data !== undefined) {
                            return data;
                        }

                        // Attempt to "discover" the data in
                        // HTML5 custom data-* attrs
                        data = dataAttr(elem, key);
                        if (data !== undefined) {
                            return data;
                        }

                        // We tried really hard, but the data doesn't exist.
                        return;
                    }

                    // Set the data...
                    this.each(function () {
                        // We always store the camelCased key
                        dataUser.set(this, key, value);
                    });
                },
                null,
                value,
                arguments.length > 1,
                null,
                true
            );
        },

        removeData: function (key) {
            return this.each(function () {
                dataUser.remove(this, key);
            });
        },
    });

    jQuery.extend({
        queue: function (elem, type, data) {
            var queue;

            if (elem) {
                type = (type || "fx") + "queue";
                queue = dataPriv.get(elem, type);

                // Speed up dequeue by getting out quickly if this is just a lookup
                if (data) {
                    if (!queue || Array.isArray(data)) {
                        queue = dataPriv.access(
                            elem,
                            type,
                            jQuery.makeArray(data)
                        );
                    } else {
                        queue.push(data);
                    }
                }
                return queue || [];
            }
        },

        dequeue: function (elem, type) {
            type = type || "fx";

            var queue = jQuery.queue(elem, type),
                startLength = queue.length,
                fn = queue.shift(),
                hooks = jQuery._queueHooks(elem, type),
                next = function () {
                    jQuery.dequeue(elem, type);
                };

            // If the fx queue is dequeued, always remove the progress sentinel
            if (fn === "inprogress") {
                fn = queue.shift();
                startLength--;
            }

            if (fn) {
                // Add a progress sentinel to prevent the fx queue from being
                // automatically dequeued
                if (type === "fx") {
                    queue.unshift("inprogress");
                }

                // Clear up the last queue stop function
                delete hooks.stop;
                fn.call(elem, next, hooks);
            }

            if (!startLength && hooks) {
                hooks.empty.fire();
            }
        },

        // Not public - generate a queueHooks object, or return the current one
        _queueHooks: function (elem, type) {
            var key = type + "queueHooks";
            return (
                dataPriv.get(elem, key) ||
                dataPriv.access(elem, key, {
                    empty: jQuery.Callbacks("once memory").add(function () {
                        dataPriv.remove(elem, [type + "queue", key]);
                    }),
                })
            );
        },
    });

    jQuery.fn.extend({
        queue: function (type, data) {
            var setter = 2;

            if (typeof type !== "string") {
                data = type;
                type = "fx";
                setter--;
            }

            if (arguments.length < setter) {
                return jQuery.queue(this[0], type);
            }

            return data === undefined
                ? this
                : this.each(function () {
                      var queue = jQuery.queue(this, type, data);

                      // Ensure a hooks for this queue
                      jQuery._queueHooks(this, type);

                      if (type === "fx" && queue[0] !== "inprogress") {
                          jQuery.dequeue(this, type);
                      }
                  });
        },
        dequeue: function (type) {
            return this.each(function () {
                jQuery.dequeue(this, type);
            });
        },
        clearQueue: function (type) {
            return this.queue(type || "fx", []);
        },

        // Get a promise resolved when queues of a certain type
        // are emptied (fx is the type by default)
        promise: function (type, obj) {
            var tmp,
                count = 1,
                defer = jQuery.Deferred(),
                elements = this,
                i = this.length,
                resolve = function () {
                    if (!--count) {
                        defer.resolveWith(elements, [elements]);
                    }
                };

            if (typeof type !== "string") {
                obj = type;
                type = undefined;
            }
            type = type || "fx";

            while (i--) {
                tmp = dataPriv.get(elements[i], type + "queueHooks");
                if (tmp && tmp.empty) {
                    count++;
                    tmp.empty.add(resolve);
                }
            }
            resolve();
            return defer.promise(obj);
        },
    });
    var pnum = /[+-]?(?:\d*\.|)\d+(?:[eE][+-]?\d+|)/.source;

    var rcssNum = new RegExp("^(?:([+-])=|)(" + pnum + ")([a-z%]*)$", "i");

    var cssExpand = ["Top", "Right", "Bottom", "Left"];

    var documentElement = document.documentElement;

    var isAttached = function (elem) {
            return jQuery.contains(elem.ownerDocument, elem);
        },
        composed = { composed: true };

    // Support: IE 9 - 11+, Edge 12 - 18+, iOS 10.0 - 10.2 only
    // Check attachment across shadow DOM boundaries when possible (gh-3504)
    // Support: iOS 10.0-10.2 only
    // Early iOS 10 versions support `attachShadow` but not `getRootNode`,
    // leading to errors. We need to check for `getRootNode`.
    if (documentElement.getRootNode) {
        isAttached = function (elem) {
            return (
                jQuery.contains(elem.ownerDocument, elem) ||
                elem.getRootNode(composed) === elem.ownerDocument
            );
        };
    }
    var isHiddenWithinTree = function (elem, el) {
        // isHiddenWithinTree might be called from jQuery#filter function;
        // in that case, element will be second argument
        elem = el || elem;

        // Inline style trumps all
        return (
            elem.style.display === "none" ||
            (elem.style.display === "" &&
                // Otherwise, check computed style
                // Support: Firefox <=43 - 45
                // Disconnected elements can have computed display: none, so first confirm that elem is
                // in the document.
                isAttached(elem) &&
                jQuery.css(elem, "display") === "none")
        );
    };

    function adjustCSS(elem, prop, valueParts, tween) {
        var adjusted,
            scale,
            maxIterations = 20,
            currentValue = tween
                ? function () {
                      return tween.cur();
                  }
                : function () {
                      return jQuery.css(elem, prop, "");
                  },
            initial = currentValue(),
            unit =
                (valueParts && valueParts[3]) ||
                (jQuery.cssNumber[prop] ? "" : "px"),
            // Starting value computation is required for potential unit mismatches
            initialInUnit =
                elem.nodeType &&
                (jQuery.cssNumber[prop] || (unit !== "px" && +initial)) &&
                rcssNum.exec(jQuery.css(elem, prop));

        if (initialInUnit && initialInUnit[3] !== unit) {
            // Support: Firefox <=54
            // Halve the iteration target value to prevent interference from CSS upper bounds (gh-2144)
            initial = initial / 2;

            // Trust units reported by jQuery.css
            unit = unit || initialInUnit[3];

            // Iteratively approximate from a nonzero starting point
            initialInUnit = +initial || 1;

            while (maxIterations--) {
                // Evaluate and update our best guess (doubling guesses that zero out).
                // Finish if the scale equals or crosses 1 (making the old*new product non-positive).
                jQuery.style(elem, prop, initialInUnit + unit);
                if (
                    (1 - scale) *
                        (1 - (scale = currentValue() / initial || 0.5)) <=
                    0
                ) {
                    maxIterations = 0;
                }
                initialInUnit = initialInUnit / scale;
            }

            initialInUnit = initialInUnit * 2;
            jQuery.style(elem, prop, initialInUnit + unit);

            // Make sure we update the tween properties later on
            valueParts = valueParts || [];
        }

        if (valueParts) {
            initialInUnit = +initialInUnit || +initial || 0;

            // Apply relative offset (+=/-=) if specified
            adjusted = valueParts[1]
                ? initialInUnit + (valueParts[1] + 1) * valueParts[2]
                : +valueParts[2];
            if (tween) {
                tween.unit = unit;
                tween.start = initialInUnit;
                tween.end = adjusted;
            }
        }
        return adjusted;
    }

    var defaultDisplayMap = {};

    function getDefaultDisplay(elem) {
        var temp,
            doc = elem.ownerDocument,
            nodeName = elem.nodeName,
            display = defaultDisplayMap[nodeName];

        if (display) {
            return display;
        }

        temp = doc.body.appendChild(doc.createElement(nodeName));
        display = jQuery.css(temp, "display");

        temp.parentNode.removeChild(temp);

        if (display === "none") {
            display = "block";
        }
        defaultDisplayMap[nodeName] = display;

        return display;
    }

    function showHide(elements, show) {
        var display,
            elem,
            values = [],
            index = 0,
            length = elements.length;

        // Determine new display value for elements that need to change
        for (; index < length; index++) {
            elem = elements[index];
            if (!elem.style) {
                continue;
            }

            display = elem.style.display;
            if (show) {
                // Since we force visibility upon cascade-hidden elements, an immediate (and slow)
                // check is required in this first loop unless we have a nonempty display value (either
                // inline or about-to-be-restored)
                if (display === "none") {
                    values[index] = dataPriv.get(elem, "display") || null;
                    if (!values[index]) {
                        elem.style.display = "";
                    }
                }
                if (elem.style.display === "" && isHiddenWithinTree(elem)) {
                    values[index] = getDefaultDisplay(elem);
                }
            } else {
                if (display !== "none") {
                    values[index] = "none";

                    // Remember what we're overwriting
                    dataPriv.set(elem, "display", display);
                }
            }
        }

        // Set the display of the elements in a second loop to avoid constant reflow
        for (index = 0; index < length; index++) {
            if (values[index] != null) {
                elements[index].style.display = values[index];
            }
        }

        return elements;
    }

    jQuery.fn.extend({
        show: function () {
            return showHide(this, true);
        },
        hide: function () {
            return showHide(this);
        },
        toggle: function (state) {
            if (typeof state === "boolean") {
                return state ? this.show() : this.hide();
            }

            return this.each(function () {
                if (isHiddenWithinTree(this)) {
                    jQuery(this).show();
                } else {
                    jQuery(this).hide();
                }
            });
        },
    });
    var rcheckableType = /^(?:checkbox|radio)$/i;

    var rtagName = /<([a-z][^\/\0>\x20\t\r\n\f]*)/i;

    var rscriptType = /^$|^module$|\/(?:java|ecma)script/i;

    (function () {
        var fragment = document.createDocumentFragment(),
            div = fragment.appendChild(document.createElement("div")),
            input = document.createElement("input");

        // Support: Android 4.0 - 4.3 only
        // Check state lost if the name is set (#11217)
        // Support: Windows Web Apps (WWA)
        // `name` and `type` must use .setAttribute for WWA (#14901)
        input.setAttribute("type", "radio");
        input.setAttribute("checked", "checked");
        input.setAttribute("name", "t");

        div.appendChild(input);

        // Support: Android <=4.1 only
        // Older WebKit doesn't clone checked state correctly in fragments
        support.checkClone = div
            .cloneNode(true)
            .cloneNode(true).lastChild.checked;

        // Support: IE <=11 only
        // Make sure textarea (and checkbox) defaultValue is properly cloned
        div.innerHTML = "<textarea>x</textarea>";
        support.noCloneChecked = !!div.cloneNode(true).lastChild.defaultValue;

        // Support: IE <=9 only
        // IE <=9 replaces <option> tags with their contents when inserted outside of
        // the select element.
        div.innerHTML = "<option></option>";
        support.option = !!div.lastChild;
    })();

    // We have to close these tags to support XHTML (#13200)
    var wrapMap = {
        // XHTML parsers do not magically insert elements in the
        // same way that tag soup parsers do. So we cannot shorten
        // this by omitting <tbody> or other required elements.
        thead: [1, "<table>", "</table>"],
        col: [2, "<table><colgroup>", "</colgroup></table>"],
        tr: [2, "<table><tbody>", "</tbody></table>"],
        td: [3, "<table><tbody><tr>", "</tr></tbody></table>"],

        _default: [0, "", ""],
    };

    wrapMap.tbody =
        wrapMap.tfoot =
        wrapMap.colgroup =
        wrapMap.caption =
            wrapMap.thead;
    wrapMap.th = wrapMap.td;

    // Support: IE <=9 only
    if (!support.option) {
        wrapMap.optgroup = wrapMap.option = [
            1,
            "<select multiple='multiple'>",
            "</select>",
        ];
    }

    function getAll(context, tag) {
        // Support: IE <=9 - 11 only
        // Use typeof to avoid zero-argument method invocation on host objects (#15151)
        var ret;

        if (typeof context.getElementsByTagName !== "undefined") {
            ret = context.getElementsByTagName(tag || "*");
        } else if (typeof context.querySelectorAll !== "undefined") {
            ret = context.querySelectorAll(tag || "*");
        } else {
            ret = [];
        }

        if (tag === undefined || (tag && nodeName(context, tag))) {
            return jQuery.merge([context], ret);
        }

        return ret;
    }

    // Mark scripts as having already been evaluated
    function setGlobalEval(elems, refElements) {
        var i = 0,
            l = elems.length;

        for (; i < l; i++) {
            dataPriv.set(
                elems[i],
                "globalEval",
                !refElements || dataPriv.get(refElements[i], "globalEval")
            );
        }
    }

    var rhtml = /<|&#?\w+;/;

    function buildFragment(elems, context, scripts, selection, ignored) {
        var elem,
            tmp,
            tag,
            wrap,
            attached,
            j,
            fragment = context.createDocumentFragment(),
            nodes = [],
            i = 0,
            l = elems.length;

        for (; i < l; i++) {
            elem = elems[i];

            if (elem || elem === 0) {
                // Add nodes directly
                if (toType(elem) === "object") {
                    // Support: Android <=4.0 only, PhantomJS 1 only
                    // push.apply(_, arraylike) throws on ancient WebKit
                    jQuery.merge(nodes, elem.nodeType ? [elem] : elem);

                    // Convert non-html into a text node
                } else if (!rhtml.test(elem)) {
                    nodes.push(context.createTextNode(elem));

                    // Convert html into DOM nodes
                } else {
                    tmp =
                        tmp ||
                        fragment.appendChild(context.createElement("div"));

                    // Deserialize a standard representation
                    tag = (rtagName.exec(elem) || ["", ""])[1].toLowerCase();
                    wrap = wrapMap[tag] || wrapMap._default;
                    tmp.innerHTML =
                        wrap[1] + jQuery.htmlPrefilter(elem) + wrap[2];

                    // Descend through wrappers to the right content
                    j = wrap[0];
                    while (j--) {
                        tmp = tmp.lastChild;
                    }

                    // Support: Android <=4.0 only, PhantomJS 1 only
                    // push.apply(_, arraylike) throws on ancient WebKit
                    jQuery.merge(nodes, tmp.childNodes);

                    // Remember the top-level container
                    tmp = fragment.firstChild;

                    // Ensure the created nodes are orphaned (#12392)
                    tmp.textContent = "";
                }
            }
        }

        // Remove wrapper from fragment
        fragment.textContent = "";

        i = 0;
        while ((elem = nodes[i++])) {
            // Skip elements already in the context collection (trac-4087)
            if (selection && jQuery.inArray(elem, selection) > -1) {
                if (ignored) {
                    ignored.push(elem);
                }
                continue;
            }

            attached = isAttached(elem);

            // Append to fragment
            tmp = getAll(fragment.appendChild(elem), "script");

            // Preserve script evaluation history
            if (attached) {
                setGlobalEval(tmp);
            }

            // Capture executables
            if (scripts) {
                j = 0;
                while ((elem = tmp[j++])) {
                    if (rscriptType.test(elem.type || "")) {
                        scripts.push(elem);
                    }
                }
            }
        }

        return fragment;
    }

    var rtypenamespace = /^([^.]*)(?:\.(.+)|)/;

    function returnTrue() {
        return true;
    }

    function returnFalse() {
        return false;
    }

    // Support: IE <=9 - 11+
    // focus() and blur() are asynchronous, except when they are no-op.
    // So expect focus to be synchronous when the element is already active,
    // and blur to be synchronous when the element is not already active.
    // (focus and blur are always synchronous in other supported browsers,
    // this just defines when we can count on it).
    function expectSync(elem, type) {
        return (elem === safeActiveElement()) === (type === "focus");
    }

    // Support: IE <=9 only
    // Accessing document.activeElement can throw unexpectedly
    // https://bugs.jquery.com/ticket/13393
    function safeActiveElement() {
        try {
            return document.activeElement;
        } catch (err) {}
    }

    function on(elem, types, selector, data, fn, one) {
        var origFn, type;

        // Types can be a map of types/handlers
        if (typeof types === "object") {
            // ( types-Object, selector, data )
            if (typeof selector !== "string") {
                // ( types-Object, data )
                data = data || selector;
                selector = undefined;
            }
            for (type in types) {
                on(elem, type, selector, data, types[type], one);
            }
            return elem;
        }

        if (data == null && fn == null) {
            // ( types, fn )
            fn = selector;
            data = selector = undefined;
        } else if (fn == null) {
            if (typeof selector === "string") {
                // ( types, selector, fn )
                fn = data;
                data = undefined;
            } else {
                // ( types, data, fn )
                fn = data;
                data = selector;
                selector = undefined;
            }
        }
        if (fn === false) {
            fn = returnFalse;
        } else if (!fn) {
            return elem;
        }

        if (one === 1) {
            origFn = fn;
            fn = function (event) {
                // Can use an empty set, since event contains the info
                jQuery().off(event);
                return origFn.apply(this, arguments);
            };

            // Use same guid so caller can remove using origFn
            fn.guid = origFn.guid || (origFn.guid = jQuery.guid++);
        }
        return elem.each(function () {
            jQuery.event.add(this, types, fn, data, selector);
        });
    }

    /*
     * Helper functions for managing events -- not part of the public interface.
     * Props to Dean Edwards' addEvent library for many of the ideas.
     */
    jQuery.event = {
        global: {},

        add: function (elem, types, handler, data, selector) {
            var handleObjIn,
                eventHandle,
                tmp,
                events,
                t,
                handleObj,
                special,
                handlers,
                type,
                namespaces,
                origType,
                elemData = dataPriv.get(elem);

            // Only attach events to objects that accept data
            if (!acceptData(elem)) {
                return;
            }

            // Caller can pass in an object of custom data in lieu of the handler
            if (handler.handler) {
                handleObjIn = handler;
                handler = handleObjIn.handler;
                selector = handleObjIn.selector;
            }

            // Ensure that invalid selectors throw exceptions at attach time
            // Evaluate against documentElement in case elem is a non-element node (e.g., document)
            if (selector) {
                jQuery.find.matchesSelector(documentElement, selector);
            }

            // Make sure that the handler has a unique ID, used to find/remove it later
            if (!handler.guid) {
                handler.guid = jQuery.guid++;
            }

            // Init the element's event structure and main handler, if this is the first
            if (!(events = elemData.events)) {
                events = elemData.events = Object.create(null);
            }
            if (!(eventHandle = elemData.handle)) {
                eventHandle = elemData.handle = function (e) {
                    // Discard the second event of a jQuery.event.trigger() and
                    // when an event is called after a page has unloaded
                    return typeof jQuery !== "undefined" &&
                        jQuery.event.triggered !== e.type
                        ? jQuery.event.dispatch.apply(elem, arguments)
                        : undefined;
                };
            }

            // Handle multiple events separated by a space
            types = (types || "").match(rnothtmlwhite) || [""];
            t = types.length;
            while (t--) {
                tmp = rtypenamespace.exec(types[t]) || [];
                type = origType = tmp[1];
                namespaces = (tmp[2] || "").split(".").sort();

                // There *must* be a type, no attaching namespace-only handlers
                if (!type) {
                    continue;
                }

                // If event changes its type, use the special event handlers for the changed type
                special = jQuery.event.special[type] || {};

                // If selector defined, determine special event api type, otherwise given type
                type =
                    (selector ? special.delegateType : special.bindType) ||
                    type;

                // Update special based on newly reset type
                special = jQuery.event.special[type] || {};

                // handleObj is passed to all event handlers
                handleObj = jQuery.extend(
                    {
                        type: type,
                        origType: origType,
                        data: data,
                        handler: handler,
                        guid: handler.guid,
                        selector: selector,
                        needsContext:
                            selector &&
                            jQuery.expr.match.needsContext.test(selector),
                        namespace: namespaces.join("."),
                    },
                    handleObjIn
                );

                // Init the event handler queue if we're the first
                if (!(handlers = events[type])) {
                    handlers = events[type] = [];
                    handlers.delegateCount = 0;

                    // Only use addEventListener if the special events handler returns false
                    if (
                        !special.setup ||
                        special.setup.call(
                            elem,
                            data,
                            namespaces,
                            eventHandle
                        ) === false
                    ) {
                        if (elem.addEventListener) {
                            elem.addEventListener(type, eventHandle);
                        }
                    }
                }

                if (special.add) {
                    special.add.call(elem, handleObj);

                    if (!handleObj.handler.guid) {
                        handleObj.handler.guid = handler.guid;
                    }
                }

                // Add to the element's handler list, delegates in front
                if (selector) {
                    handlers.splice(handlers.delegateCount++, 0, handleObj);
                } else {
                    handlers.push(handleObj);
                }

                // Keep track of which events have ever been used, for event optimization
                jQuery.event.global[type] = true;
            }
        },

        // Detach an event or set of events from an element
        remove: function (elem, types, handler, selector, mappedTypes) {
            var j,
                origCount,
                tmp,
                events,
                t,
                handleObj,
                special,
                handlers,
                type,
                namespaces,
                origType,
                elemData = dataPriv.hasData(elem) && dataPriv.get(elem);

            if (!elemData || !(events = elemData.events)) {
                return;
            }

            // Once for each type.namespace in types; type may be omitted
            types = (types || "").match(rnothtmlwhite) || [""];
            t = types.length;
            while (t--) {
                tmp = rtypenamespace.exec(types[t]) || [];
                type = origType = tmp[1];
                namespaces = (tmp[2] || "").split(".").sort();

                // Unbind all events (on this namespace, if provided) for the element
                if (!type) {
                    for (type in events) {
                        jQuery.event.remove(
                            elem,
                            type + types[t],
                            handler,
                            selector,
                            true
                        );
                    }
                    continue;
                }

                special = jQuery.event.special[type] || {};
                type =
                    (selector ? special.delegateType : special.bindType) ||
                    type;
                handlers = events[type] || [];
                tmp =
                    tmp[2] &&
                    new RegExp(
                        "(^|\\.)" + namespaces.join("\\.(?:.*\\.|)") + "(\\.|$)"
                    );

                // Remove matching events
                origCount = j = handlers.length;
                while (j--) {
                    handleObj = handlers[j];

                    if (
                        (mappedTypes || origType === handleObj.origType) &&
                        (!handler || handler.guid === handleObj.guid) &&
                        (!tmp || tmp.test(handleObj.namespace)) &&
                        (!selector ||
                            selector === handleObj.selector ||
                            (selector === "**" && handleObj.selector))
                    ) {
                        handlers.splice(j, 1);

                        if (handleObj.selector) {
                            handlers.delegateCount--;
                        }
                        if (special.remove) {
                            special.remove.call(elem, handleObj);
                        }
                    }
                }

                // Remove generic event handler if we removed something and no more handlers exist
                // (avoids potential for endless recursion during removal of special event handlers)
                if (origCount && !handlers.length) {
                    if (
                        !special.teardown ||
                        special.teardown.call(
                            elem,
                            namespaces,
                            elemData.handle
                        ) === false
                    ) {
                        jQuery.removeEvent(elem, type, elemData.handle);
                    }

                    delete events[type];
                }
            }

            // Remove data and the expando if it's no longer used
            if (jQuery.isEmptyObject(events)) {
                dataPriv.remove(elem, "handle events");
            }
        },

        dispatch: function (nativeEvent) {
            var i,
                j,
                ret,
                matched,
                handleObj,
                handlerQueue,
                args = new Array(arguments.length),
                // Make a writable jQuery.Event from the native event object
                event = jQuery.event.fix(nativeEvent),
                handlers =
                    (dataPriv.get(this, "events") || Object.create(null))[
                        event.type
                    ] || [],
                special = jQuery.event.special[event.type] || {};

            // Use the fix-ed jQuery.Event rather than the (read-only) native event
            args[0] = event;

            for (i = 1; i < arguments.length; i++) {
                args[i] = arguments[i];
            }

            event.delegateTarget = this;

            // Call the preDispatch hook for the mapped type, and let it bail if desired
            if (
                special.preDispatch &&
                special.preDispatch.call(this, event) === false
            ) {
                return;
            }

            // Determine handlers
            handlerQueue = jQuery.event.handlers.call(this, event, handlers);

            // Run delegates first; they may want to stop propagation beneath us
            i = 0;
            while (
                (matched = handlerQueue[i++]) &&
                !event.isPropagationStopped()
            ) {
                event.currentTarget = matched.elem;

                j = 0;
                while (
                    (handleObj = matched.handlers[j++]) &&
                    !event.isImmediatePropagationStopped()
                ) {
                    // If the event is namespaced, then each handler is only invoked if it is
                    // specially universal or its namespaces are a superset of the event's.
                    if (
                        !event.rnamespace ||
                        handleObj.namespace === false ||
                        event.rnamespace.test(handleObj.namespace)
                    ) {
                        event.handleObj = handleObj;
                        event.data = handleObj.data;

                        ret = (
                            (jQuery.event.special[handleObj.origType] || {})
                                .handle || handleObj.handler
                        ).apply(matched.elem, args);

                        if (ret !== undefined) {
                            if ((event.result = ret) === false) {
                                event.preventDefault();
                                event.stopPropagation();
                            }
                        }
                    }
                }
            }

            // Call the postDispatch hook for the mapped type
            if (special.postDispatch) {
                special.postDispatch.call(this, event);
            }

            return event.result;
        },

        handlers: function (event, handlers) {
            var i,
                handleObj,
                sel,
                matchedHandlers,
                matchedSelectors,
                handlerQueue = [],
                delegateCount = handlers.delegateCount,
                cur = event.target;

            // Find delegate handlers
            if (
                delegateCount &&
                // Support: IE <=9
                // Black-hole SVG <use> instance trees (trac-13180)
                cur.nodeType &&
                // Support: Firefox <=42
                // Suppress spec-violating clicks indicating a non-primary pointer button (trac-3861)
                // https://www.w3.org/TR/DOM-Level-3-Events/#event-type-click
                // Support: IE 11 only
                // ...but not arrow key "clicks" of radio inputs, which can have `button` -1 (gh-2343)
                !(event.type === "click" && event.button >= 1)
            ) {
                for (; cur !== this; cur = cur.parentNode || this) {
                    // Don't check non-elements (#13208)
                    // Don't process clicks on disabled elements (#6911, #8165, #11382, #11764)
                    if (
                        cur.nodeType === 1 &&
                        !(event.type === "click" && cur.disabled === true)
                    ) {
                        matchedHandlers = [];
                        matchedSelectors = {};
                        for (i = 0; i < delegateCount; i++) {
                            handleObj = handlers[i];

                            // Don't conflict with Object.prototype properties (#13203)
                            sel = handleObj.selector + " ";

                            if (matchedSelectors[sel] === undefined) {
                                matchedSelectors[sel] = handleObj.needsContext
                                    ? jQuery(sel, this).index(cur) > -1
                                    : jQuery.find(sel, this, null, [cur])
                                          .length;
                            }
                            if (matchedSelectors[sel]) {
                                matchedHandlers.push(handleObj);
                            }
                        }
                        if (matchedHandlers.length) {
                            handlerQueue.push({
                                elem: cur,
                                handlers: matchedHandlers,
                            });
                        }
                    }
                }
            }

            // Add the remaining (directly-bound) handlers
            cur = this;
            if (delegateCount < handlers.length) {
                handlerQueue.push({
                    elem: cur,
                    handlers: handlers.slice(delegateCount),
                });
            }

            return handlerQueue;
        },

        addProp: function (name, hook) {
            Object.defineProperty(jQuery.Event.prototype, name, {
                enumerable: true,
                configurable: true,

                get: isFunction(hook)
                    ? function () {
                          if (this.originalEvent) {
                              return hook(this.originalEvent);
                          }
                      }
                    : function () {
                          if (this.originalEvent) {
                              return this.originalEvent[name];
                          }
                      },

                set: function (value) {
                    Object.defineProperty(this, name, {
                        enumerable: true,
                        configurable: true,
                        writable: true,
                        value: value,
                    });
                },
            });
        },

        fix: function (originalEvent) {
            return originalEvent[jQuery.expando]
                ? originalEvent
                : new jQuery.Event(originalEvent);
        },

        special: {
            load: {
                // Prevent triggered image.load events from bubbling to window.load
                noBubble: true,
            },
            click: {
                // Utilize native event to ensure correct state for checkable inputs
                setup: function (data) {
                    // For mutual compressibility with _default, replace `this` access with a local var.
                    // `|| data` is dead code meant only to preserve the variable through minification.
                    var el = this || data;

                    // Claim the first handler
                    if (
                        rcheckableType.test(el.type) &&
                        el.click &&
                        nodeName(el, "input")
                    ) {
                        // dataPriv.set( el, "click", ... )
                        leverageNative(el, "click", returnTrue);
                    }

                    // Return false to allow normal processing in the caller
                    return false;
                },
                trigger: function (data) {
                    // For mutual compressibility with _default, replace `this` access with a local var.
                    // `|| data` is dead code meant only to preserve the variable through minification.
                    var el = this || data;

                    // Force setup before triggering a click
                    if (
                        rcheckableType.test(el.type) &&
                        el.click &&
                        nodeName(el, "input")
                    ) {
                        leverageNative(el, "click");
                    }

                    // Return non-false to allow normal event-path propagation
                    return true;
                },

                // For cross-browser consistency, suppress native .click() on links
                // Also prevent it if we're currently inside a leveraged native-event stack
                _default: function (event) {
                    var target = event.target;
                    return (
                        (rcheckableType.test(target.type) &&
                            target.click &&
                            nodeName(target, "input") &&
                            dataPriv.get(target, "click")) ||
                        nodeName(target, "a")
                    );
                },
            },

            beforeunload: {
                postDispatch: function (event) {
                    // Support: Firefox 20+
                    // Firefox doesn't alert if the returnValue field is not set.
                    if (event.result !== undefined && event.originalEvent) {
                        event.originalEvent.returnValue = event.result;
                    }
                },
            },
        },
    };

    // Ensure the presence of an event listener that handles manually-triggered
    // synthetic events by interrupting progress until reinvoked in response to
    // *native* events that it fires directly, ensuring that state changes have
    // already occurred before other listeners are invoked.
    function leverageNative(el, type, expectSync) {
        // Missing expectSync indicates a trigger call, which must force setup through jQuery.event.add
        if (!expectSync) {
            if (dataPriv.get(el, type) === undefined) {
                jQuery.event.add(el, type, returnTrue);
            }
            return;
        }

        // Register the controller as a special universal handler for all event namespaces
        dataPriv.set(el, type, false);
        jQuery.event.add(el, type, {
            namespace: false,
            handler: function (event) {
                var notAsync,
                    result,
                    saved = dataPriv.get(this, type);

                if (event.isTrigger & 1 && this[type]) {
                    // Interrupt processing of the outer synthetic .trigger()ed event
                    // Saved data should be false in such cases, but might be a leftover capture object
                    // from an async native handler (gh-4350)
                    if (!saved.length) {
                        // Store arguments for use when handling the inner native event
                        // There will always be at least one argument (an event object), so this array
                        // will not be confused with a leftover capture object.
                        saved = slice.call(arguments);
                        dataPriv.set(this, type, saved);

                        // Trigger the native event and capture its result
                        // Support: IE <=9 - 11+
                        // focus() and blur() are asynchronous
                        notAsync = expectSync(this, type);
                        this[type]();
                        result = dataPriv.get(this, type);
                        if (saved !== result || notAsync) {
                            dataPriv.set(this, type, false);
                        } else {
                            result = {};
                        }
                        if (saved !== result) {
                            // Cancel the outer synthetic event
                            event.stopImmediatePropagation();
                            event.preventDefault();

                            // Support: Chrome 86+
                            // In Chrome, if an element having a focusout handler is blurred by
                            // clicking outside of it, it invokes the handler synchronously. If
                            // that handler calls `.remove()` on the element, the data is cleared,
                            // leaving `result` undefined. We need to guard against this.
                            return result && result.value;
                        }

                        // If this is an inner synthetic event for an event with a bubbling surrogate
                        // (focus or blur), assume that the surrogate already propagated from triggering the
                        // native event and prevent that from happening again here.
                        // This technically gets the ordering wrong w.r.t. to `.trigger()` (in which the
                        // bubbling surrogate propagates *after* the non-bubbling base), but that seems
                        // less bad than duplication.
                    } else if (
                        (jQuery.event.special[type] || {}).delegateType
                    ) {
                        event.stopPropagation();
                    }

                    // If this is a native event triggered above, everything is now in order
                    // Fire an inner synthetic event with the original arguments
                } else if (saved.length) {
                    // ...and capture the result
                    dataPriv.set(this, type, {
                        value: jQuery.event.trigger(
                            // Support: IE <=9 - 11+
                            // Extend with the prototype to reset the above stopImmediatePropagation()
                            jQuery.extend(saved[0], jQuery.Event.prototype),
                            saved.slice(1),
                            this
                        ),
                    });

                    // Abort handling of the native event
                    event.stopImmediatePropagation();
                }
            },
        });
    }

    jQuery.removeEvent = function (elem, type, handle) {
        // This "if" is needed for plain objects
        if (elem.removeEventListener) {
            elem.removeEventListener(type, handle);
        }
    };

    jQuery.Event = function (src, props) {
        // Allow instantiation without the 'new' keyword
        if (!(this instanceof jQuery.Event)) {
            return new jQuery.Event(src, props);
        }

        // Event object
        if (src && src.type) {
            this.originalEvent = src;
            this.type = src.type;

            // Events bubbling up the document may have been marked as prevented
            // by a handler lower down the tree; reflect the correct value.
            this.isDefaultPrevented =
                src.defaultPrevented ||
                (src.defaultPrevented === undefined &&
                    // Support: Android <=2.3 only
                    src.returnValue === false)
                    ? returnTrue
                    : returnFalse;

            // Create target properties
            // Support: Safari <=6 - 7 only
            // Target should not be a text node (#504, #13143)
            this.target =
                src.target && src.target.nodeType === 3
                    ? src.target.parentNode
                    : src.target;

            this.currentTarget = src.currentTarget;
            this.relatedTarget = src.relatedTarget;

            // Event type
        } else {
            this.type = src;
        }

        // Put explicitly provided properties onto the event object
        if (props) {
            jQuery.extend(this, props);
        }

        // Create a timestamp if incoming event doesn't have one
        this.timeStamp = (src && src.timeStamp) || Date.now();

        // Mark it as fixed
        this[jQuery.expando] = true;
    };

    // jQuery.Event is based on DOM3 Events as specified by the ECMAScript Language Binding
    // https://www.w3.org/TR/2003/WD-DOM-Level-3-Events-20030331/ecma-script-binding.html
    jQuery.Event.prototype = {
        constructor: jQuery.Event,
        isDefaultPrevented: returnFalse,
        isPropagationStopped: returnFalse,
        isImmediatePropagationStopped: returnFalse,
        isSimulated: false,

        preventDefault: function () {
            var e = this.originalEvent;

            this.isDefaultPrevented = returnTrue;

            if (e && !this.isSimulated) {
                e.preventDefault();
            }
        },
        stopPropagation: function () {
            var e = this.originalEvent;

            this.isPropagationStopped = returnTrue;

            if (e && !this.isSimulated) {
                e.stopPropagation();
            }
        },
        stopImmediatePropagation: function () {
            var e = this.originalEvent;

            this.isImmediatePropagationStopped = returnTrue;

            if (e && !this.isSimulated) {
                e.stopImmediatePropagation();
            }

            this.stopPropagation();
        },
    };

    // Includes all common event props including KeyEvent and MouseEvent specific props
    jQuery.each(
        {
            altKey: true,
            bubbles: true,
            cancelable: true,
            changedTouches: true,
            ctrlKey: true,
            detail: true,
            eventPhase: true,
            metaKey: true,
            pageX: true,
            pageY: true,
            shiftKey: true,
            view: true,
            char: true,
            code: true,
            charCode: true,
            key: true,
            keyCode: true,
            button: true,
            buttons: true,
            clientX: true,
            clientY: true,
            offsetX: true,
            offsetY: true,
            pointerId: true,
            pointerType: true,
            screenX: true,
            screenY: true,
            targetTouches: true,
            toElement: true,
            touches: true,
            which: true,
        },
        jQuery.event.addProp
    );

    jQuery.each(
        { focus: "focusin", blur: "focusout" },
        function (type, delegateType) {
            jQuery.event.special[type] = {
                // Utilize native event if possible so blur/focus sequence is correct
                setup: function () {
                    // Claim the first handler
                    // dataPriv.set( this, "focus", ... )
                    // dataPriv.set( this, "blur", ... )
                    leverageNative(this, type, expectSync);

                    // Return false to allow normal processing in the caller
                    return false;
                },
                trigger: function () {
                    // Force setup before trigger
                    leverageNative(this, type);

                    // Return non-false to allow normal event-path propagation
                    return true;
                },

                // Suppress native focus or blur as it's already being fired
                // in leverageNative.
                _default: function () {
                    return true;
                },

                delegateType: delegateType,
            };
        }
    );

    // Create mouseenter/leave events using mouseover/out and event-time checks
    // so that event delegation works in jQuery.
    // Do the same for pointerenter/pointerleave and pointerover/pointerout
    //
    // Support: Safari 7 only
    // Safari sends mouseenter too often; see:
    // https://bugs.chromium.org/p/chromium/issues/detail?id=470258
    // for the description of the bug (it existed in older Chrome versions as well).
    jQuery.each(
        {
            mouseenter: "mouseover",
            mouseleave: "mouseout",
            pointerenter: "pointerover",
            pointerleave: "pointerout",
        },
        function (orig, fix) {
            jQuery.event.special[orig] = {
                delegateType: fix,
                bindType: fix,

                handle: function (event) {
                    var ret,
                        target = this,
                        related = event.relatedTarget,
                        handleObj = event.handleObj;

                    // For mouseenter/leave call the handler if related is outside the target.
                    // NB: No relatedTarget if the mouse left/entered the browser window
                    if (
                        !related ||
                        (related !== target &&
                            !jQuery.contains(target, related))
                    ) {
                        event.type = handleObj.origType;
                        ret = handleObj.handler.apply(this, arguments);
                        event.type = fix;
                    }
                    return ret;
                },
            };
        }
    );

    jQuery.fn.extend({
        on: function (types, selector, data, fn) {
            return on(this, types, selector, data, fn);
        },
        one: function (types, selector, data, fn) {
            return on(this, types, selector, data, fn, 1);
        },
        off: function (types, selector, fn) {
            var handleObj, type;
            if (types && types.preventDefault && types.handleObj) {
                // ( event )  dispatched jQuery.Event
                handleObj = types.handleObj;
                jQuery(types.delegateTarget).off(
                    handleObj.namespace
                        ? handleObj.origType + "." + handleObj.namespace
                        : handleObj.origType,
                    handleObj.selector,
                    handleObj.handler
                );
                return this;
            }
            if (typeof types === "object") {
                // ( types-object [, selector] )
                for (type in types) {
                    this.off(type, selector, types[type]);
                }
                return this;
            }
            if (selector === false || typeof selector === "function") {
                // ( types [, fn] )
                fn = selector;
                selector = undefined;
            }
            if (fn === false) {
                fn = returnFalse;
            }
            return this.each(function () {
                jQuery.event.remove(this, types, fn, selector);
            });
        },
    });

    var // Support: IE <=10 - 11, Edge 12 - 13 only
        // In IE/Edge using regex groups here causes severe slowdowns.
        // See https://connect.microsoft.com/IE/feedback/details/1736512/
        rnoInnerhtml = /<script|<style|<link/i,
        // checked="checked" or checked
        rchecked = /checked\s*(?:[^=]|=\s*.checked.)/i,
        rcleanScript = /^\s*<!(?:\[CDATA\[|--)|(?:\]\]|--)>\s*$/g;

    // Prefer a tbody over its parent table for containing new rows
    function manipulationTarget(elem, content) {
        if (
            nodeName(elem, "table") &&
            nodeName(
                content.nodeType !== 11 ? content : content.firstChild,
                "tr"
            )
        ) {
            return jQuery(elem).children("tbody")[0] || elem;
        }

        return elem;
    }

    // Replace/restore the type attribute of script elements for safe DOM manipulation
    function disableScript(elem) {
        elem.type = (elem.getAttribute("type") !== null) + "/" + elem.type;
        return elem;
    }
    function restoreScript(elem) {
        if ((elem.type || "").slice(0, 5) === "true/") {
            elem.type = elem.type.slice(5);
        } else {
            elem.removeAttribute("type");
        }

        return elem;
    }

    function cloneCopyEvent(src, dest) {
        var i, l, type, pdataOld, udataOld, udataCur, events;

        if (dest.nodeType !== 1) {
            return;
        }

        // 1. Copy private data: events, handlers, etc.
        if (dataPriv.hasData(src)) {
            pdataOld = dataPriv.get(src);
            events = pdataOld.events;

            if (events) {
                dataPriv.remove(dest, "handle events");

                for (type in events) {
                    for (i = 0, l = events[type].length; i < l; i++) {
                        jQuery.event.add(dest, type, events[type][i]);
                    }
                }
            }
        }

        // 2. Copy user data
        if (dataUser.hasData(src)) {
            udataOld = dataUser.access(src);
            udataCur = jQuery.extend({}, udataOld);

            dataUser.set(dest, udataCur);
        }
    }

    // Fix IE bugs, see support tests
    function fixInput(src, dest) {
        var nodeName = dest.nodeName.toLowerCase();

        // Fails to persist the checked state of a cloned checkbox or radio button.
        if (nodeName === "input" && rcheckableType.test(src.type)) {
            dest.checked = src.checked;

            // Fails to return the selected option to the default selected state when cloning options
        } else if (nodeName === "input" || nodeName === "textarea") {
            dest.defaultValue = src.defaultValue;
        }
    }

    function domManip(collection, args, callback, ignored) {
        // Flatten any nested arrays
        args = flat(args);

        var fragment,
            first,
            scripts,
            hasScripts,
            node,
            doc,
            i = 0,
            l = collection.length,
            iNoClone = l - 1,
            value = args[0],
            valueIsFunction = isFunction(value);

        // We can't cloneNode fragments that contain checked, in WebKit
        if (
            valueIsFunction ||
            (l > 1 &&
                typeof value === "string" &&
                !support.checkClone &&
                rchecked.test(value))
        ) {
            return collection.each(function (index) {
                var self = collection.eq(index);
                if (valueIsFunction) {
                    args[0] = value.call(this, index, self.html());
                }
                domManip(self, args, callback, ignored);
            });
        }

        if (l) {
            fragment = buildFragment(
                args,
                collection[0].ownerDocument,
                false,
                collection,
                ignored
            );
            first = fragment.firstChild;

            if (fragment.childNodes.length === 1) {
                fragment = first;
            }

            // Require either new content or an interest in ignored elements to invoke the callback
            if (first || ignored) {
                scripts = jQuery.map(getAll(fragment, "script"), disableScript);
                hasScripts = scripts.length;

                // Use the original fragment for the last item
                // instead of the first because it can end up
                // being emptied incorrectly in certain situations (#8070).
                for (; i < l; i++) {
                    node = fragment;

                    if (i !== iNoClone) {
                        node = jQuery.clone(node, true, true);

                        // Keep references to cloned scripts for later restoration
                        if (hasScripts) {
                            // Support: Android <=4.0 only, PhantomJS 1 only
                            // push.apply(_, arraylike) throws on ancient WebKit
                            jQuery.merge(scripts, getAll(node, "script"));
                        }
                    }

                    callback.call(collection[i], node, i);
                }

                if (hasScripts) {
                    doc = scripts[scripts.length - 1].ownerDocument;

                    // Reenable scripts
                    jQuery.map(scripts, restoreScript);

                    // Evaluate executable scripts on first document insertion
                    for (i = 0; i < hasScripts; i++) {
                        node = scripts[i];
                        if (
                            rscriptType.test(node.type || "") &&
                            !dataPriv.access(node, "globalEval") &&
                            jQuery.contains(doc, node)
                        ) {
                            if (
                                node.src &&
                                (node.type || "").toLowerCase() !== "module"
                            ) {
                                // Optional AJAX dependency, but won't run scripts if not present
                                if (jQuery._evalUrl && !node.noModule) {
                                    jQuery._evalUrl(
                                        node.src,
                                        {
                                            nonce:
                                                node.nonce ||
                                                node.getAttribute("nonce"),
                                        },
                                        doc
                                    );
                                }
                            } else {
                                DOMEval(
                                    node.textContent.replace(rcleanScript, ""),
                                    node,
                                    doc
                                );
                            }
                        }
                    }
                }
            }
        }

        return collection;
    }

    function remove(elem, selector, keepData) {
        var node,
            nodes = selector ? jQuery.filter(selector, elem) : elem,
            i = 0;

        for (; (node = nodes[i]) != null; i++) {
            if (!keepData && node.nodeType === 1) {
                jQuery.cleanData(getAll(node));
            }

            if (node.parentNode) {
                if (keepData && isAttached(node)) {
                    setGlobalEval(getAll(node, "script"));
                }
                node.parentNode.removeChild(node);
            }
        }

        return elem;
    }

    jQuery.extend({
        htmlPrefilter: function (html) {
            return html;
        },

        clone: function (elem, dataAndEvents, deepDataAndEvents) {
            var i,
                l,
                srcElements,
                destElements,
                clone = elem.cloneNode(true),
                inPage = isAttached(elem);

            // Fix IE cloning issues
            if (
                !support.noCloneChecked &&
                (elem.nodeType === 1 || elem.nodeType === 11) &&
                !jQuery.isXMLDoc(elem)
            ) {
                // We eschew Sizzle here for performance reasons: https://jsperf.com/getall-vs-sizzle/2
                destElements = getAll(clone);
                srcElements = getAll(elem);

                for (i = 0, l = srcElements.length; i < l; i++) {
                    fixInput(srcElements[i], destElements[i]);
                }
            }

            // Copy the events from the original to the clone
            if (dataAndEvents) {
                if (deepDataAndEvents) {
                    srcElements = srcElements || getAll(elem);
                    destElements = destElements || getAll(clone);

                    for (i = 0, l = srcElements.length; i < l; i++) {
                        cloneCopyEvent(srcElements[i], destElements[i]);
                    }
                } else {
                    cloneCopyEvent(elem, clone);
                }
            }

            // Preserve script evaluation history
            destElements = getAll(clone, "script");
            if (destElements.length > 0) {
                setGlobalEval(destElements, !inPage && getAll(elem, "script"));
            }

            // Return the cloned set
            return clone;
        },

        cleanData: function (elems) {
            var data,
                elem,
                type,
                special = jQuery.event.special,
                i = 0;

            for (; (elem = elems[i]) !== undefined; i++) {
                if (acceptData(elem)) {
                    if ((data = elem[dataPriv.expando])) {
                        if (data.events) {
                            for (type in data.events) {
                                if (special[type]) {
                                    jQuery.event.remove(elem, type);

                                    // This is a shortcut to avoid jQuery.event.remove's overhead
                                } else {
                                    jQuery.removeEvent(elem, type, data.handle);
                                }
                            }
                        }

                        // Support: Chrome <=35 - 45+
                        // Assign undefined instead of using delete, see Data#remove
                        elem[dataPriv.expando] = undefined;
                    }
                    if (elem[dataUser.expando]) {
                        // Support: Chrome <=35 - 45+
                        // Assign undefined instead of using delete, see Data#remove
                        elem[dataUser.expando] = undefined;
                    }
                }
            }
        },
    });

    jQuery.fn.extend({
        detach: function (selector) {
            return remove(this, selector, true);
        },

        remove: function (selector) {
            return remove(this, selector);
        },

        text: function (value) {
            return access(
                this,
                function (value) {
                    return value === undefined
                        ? jQuery.text(this)
                        : this.empty().each(function () {
                              if (
                                  this.nodeType === 1 ||
                                  this.nodeType === 11 ||
                                  this.nodeType === 9
                              ) {
                                  this.textContent = value;
                              }
                          });
                },
                null,
                value,
                arguments.length
            );
        },

        append: function () {
            return domManip(this, arguments, function (elem) {
                if (
                    this.nodeType === 1 ||
                    this.nodeType === 11 ||
                    this.nodeType === 9
                ) {
                    var target = manipulationTarget(this, elem);
                    target.appendChild(elem);
                }
            });
        },

        prepend: function () {
            return domManip(this, arguments, function (elem) {
                if (
                    this.nodeType === 1 ||
                    this.nodeType === 11 ||
                    this.nodeType === 9
                ) {
                    var target = manipulationTarget(this, elem);
                    target.insertBefore(elem, target.firstChild);
                }
            });
        },

        before: function () {
            return domManip(this, arguments, function (elem) {
                if (this.parentNode) {
                    this.parentNode.insertBefore(elem, this);
                }
            });
        },

        after: function () {
            return domManip(this, arguments, function (elem) {
                if (this.parentNode) {
                    this.parentNode.insertBefore(elem, this.nextSibling);
                }
            });
        },

        empty: function () {
            var elem,
                i = 0;

            for (; (elem = this[i]) != null; i++) {
                if (elem.nodeType === 1) {
                    // Prevent memory leaks
                    jQuery.cleanData(getAll(elem, false));

                    // Remove any remaining nodes
                    elem.textContent = "";
                }
            }

            return this;
        },

        clone: function (dataAndEvents, deepDataAndEvents) {
            dataAndEvents = dataAndEvents == null ? false : dataAndEvents;
            deepDataAndEvents =
                deepDataAndEvents == null ? dataAndEvents : deepDataAndEvents;

            return this.map(function () {
                return jQuery.clone(this, dataAndEvents, deepDataAndEvents);
            });
        },

        html: function (value) {
            return access(
                this,
                function (value) {
                    var elem = this[0] || {},
                        i = 0,
                        l = this.length;

                    if (value === undefined && elem.nodeType === 1) {
                        return elem.innerHTML;
                    }

                    // See if we can take a shortcut and just use innerHTML
                    if (
                        typeof value === "string" &&
                        !rnoInnerhtml.test(value) &&
                        !wrapMap[
                            (rtagName.exec(value) || ["", ""])[1].toLowerCase()
                        ]
                    ) {
                        value = jQuery.htmlPrefilter(value);

                        try {
                            for (; i < l; i++) {
                                elem = this[i] || {};

                                // Remove element nodes and prevent memory leaks
                                if (elem.nodeType === 1) {
                                    jQuery.cleanData(getAll(elem, false));
                                    elem.innerHTML = value;
                                }
                            }

                            elem = 0;

                            // If using innerHTML throws an exception, use the fallback method
                        } catch (e) {}
                    }

                    if (elem) {
                        this.empty().append(value);
                    }
                },
                null,
                value,
                arguments.length
            );
        },

        replaceWith: function () {
            var ignored = [];

            // Make the changes, replacing each non-ignored context element with the new content
            return domManip(
                this,
                arguments,
                function (elem) {
                    var parent = this.parentNode;

                    if (jQuery.inArray(this, ignored) < 0) {
                        jQuery.cleanData(getAll(this));
                        if (parent) {
                            parent.replaceChild(elem, this);
                        }
                    }

                    // Force callback invocation
                },
                ignored
            );
        },
    });

    jQuery.each(
        {
            appendTo: "append",
            prependTo: "prepend",
            insertBefore: "before",
            insertAfter: "after",
            replaceAll: "replaceWith",
        },
        function (name, original) {
            jQuery.fn[name] = function (selector) {
                var elems,
                    ret = [],
                    insert = jQuery(selector),
                    last = insert.length - 1,
                    i = 0;

                for (; i <= last; i++) {
                    elems = i === last ? this : this.clone(true);
                    jQuery(insert[i])[original](elems);

                    // Support: Android <=4.0 only, PhantomJS 1 only
                    // .get() because push.apply(_, arraylike) throws on ancient WebKit
                    push.apply(ret, elems.get());
                }

                return this.pushStack(ret);
            };
        }
    );
    var rnumnonpx = new RegExp("^(" + pnum + ")(?!px)[a-z%]+$", "i");

    var getStyles = function (elem) {
        // Support: IE <=11 only, Firefox <=30 (#15098, #14150)
        // IE throws on elements created in popups
        // FF meanwhile throws on frame elements through "defaultView.getComputedStyle"
        var view = elem.ownerDocument.defaultView;

        if (!view || !view.opener) {
            view = window;
        }

        return view.getComputedStyle(elem);
    };

    var swap = function (elem, options, callback) {
        var ret,
            name,
            old = {};

        // Remember the old values, and insert the new ones
        for (name in options) {
            old[name] = elem.style[name];
            elem.style[name] = options[name];
        }

        ret = callback.call(elem);

        // Revert the old values
        for (name in options) {
            elem.style[name] = old[name];
        }

        return ret;
    };

    var rboxStyle = new RegExp(cssExpand.join("|"), "i");

    (function () {
        // Executing both pixelPosition & boxSizingReliable tests require only one layout
        // so they're executed at the same time to save the second computation.
        function computeStyleTests() {
            // This is a singleton, we need to execute it only once
            if (!div) {
                return;
            }

            container.style.cssText =
                "position:absolute;left:-11111px;width:60px;" +
                "margin-top:1px;padding:0;border:0";
            div.style.cssText =
                "position:relative;display:block;box-sizing:border-box;overflow:scroll;" +
                "margin:auto;border:1px;padding:1px;" +
                "width:60%;top:1%";
            documentElement.appendChild(container).appendChild(div);

            var divStyle = window.getComputedStyle(div);
            pixelPositionVal = divStyle.top !== "1%";

            // Support: Android 4.0 - 4.3 only, Firefox <=3 - 44
            reliableMarginLeftVal =
                roundPixelMeasures(divStyle.marginLeft) === 12;

            // Support: Android 4.0 - 4.3 only, Safari <=9.1 - 10.1, iOS <=7.0 - 9.3
            // Some styles come back with percentage values, even though they shouldn't
            div.style.right = "60%";
            pixelBoxStylesVal = roundPixelMeasures(divStyle.right) === 36;

            // Support: IE 9 - 11 only
            // Detect misreporting of content dimensions for box-sizing:border-box elements
            boxSizingReliableVal = roundPixelMeasures(divStyle.width) === 36;

            // Support: IE 9 only
            // Detect overflow:scroll screwiness (gh-3699)
            // Support: Chrome <=64
            // Don't get tricked when zoom affects offsetWidth (gh-4029)
            div.style.position = "absolute";
            scrollboxSizeVal = roundPixelMeasures(div.offsetWidth / 3) === 12;

            documentElement.removeChild(container);

            // Nullify the div so it wouldn't be stored in the memory and
            // it will also be a sign that checks already performed
            div = null;
        }

        function roundPixelMeasures(measure) {
            return Math.round(parseFloat(measure));
        }

        var pixelPositionVal,
            boxSizingReliableVal,
            scrollboxSizeVal,
            pixelBoxStylesVal,
            reliableTrDimensionsVal,
            reliableMarginLeftVal,
            container = document.createElement("div"),
            div = document.createElement("div");

        // Finish early in limited (non-browser) environments
        if (!div.style) {
            return;
        }

        // Support: IE <=9 - 11 only
        // Style of cloned element affects source element cloned (#8908)
        div.style.backgroundClip = "content-box";
        div.cloneNode(true).style.backgroundClip = "";
        support.clearCloneStyle = div.style.backgroundClip === "content-box";

        jQuery.extend(support, {
            boxSizingReliable: function () {
                computeStyleTests();
                return boxSizingReliableVal;
            },
            pixelBoxStyles: function () {
                computeStyleTests();
                return pixelBoxStylesVal;
            },
            pixelPosition: function () {
                computeStyleTests();
                return pixelPositionVal;
            },
            reliableMarginLeft: function () {
                computeStyleTests();
                return reliableMarginLeftVal;
            },
            scrollboxSize: function () {
                computeStyleTests();
                return scrollboxSizeVal;
            },

            // Support: IE 9 - 11+, Edge 15 - 18+
            // IE/Edge misreport `getComputedStyle` of table rows with width/height
            // set in CSS while `offset*` properties report correct values.
            // Behavior in IE 9 is more subtle than in newer versions & it passes
            // some versions of this test; make sure not to make it pass there!
            //
            // Support: Firefox 70+
            // Only Firefox includes border widths
            // in computed dimensions. (gh-4529)
            reliableTrDimensions: function () {
                var table, tr, trChild, trStyle;
                if (reliableTrDimensionsVal == null) {
                    table = document.createElement("table");
                    tr = document.createElement("tr");
                    trChild = document.createElement("div");

                    table.style.cssText =
                        "position:absolute;left:-11111px;border-collapse:separate";
                    tr.style.cssText = "border:1px solid";

                    // Support: Chrome 86+
                    // Height set through cssText does not get applied.
                    // Computed height then comes back as 0.
                    tr.style.height = "1px";
                    trChild.style.height = "9px";

                    // Support: Android 8 Chrome 86+
                    // In our bodyBackground.html iframe,
                    // display for all div elements is set to "inline",
                    // which causes a problem only in Android 8 Chrome 86.
                    // Ensuring the div is display: block
                    // gets around this issue.
                    trChild.style.display = "block";

                    documentElement
                        .appendChild(table)
                        .appendChild(tr)
                        .appendChild(trChild);

                    trStyle = window.getComputedStyle(tr);
                    reliableTrDimensionsVal =
                        parseInt(trStyle.height, 10) +
                            parseInt(trStyle.borderTopWidth, 10) +
                            parseInt(trStyle.borderBottomWidth, 10) ===
                        tr.offsetHeight;

                    documentElement.removeChild(table);
                }
                return reliableTrDimensionsVal;
            },
        });
    })();

    function curCSS(elem, name, computed) {
        var width,
            minWidth,
            maxWidth,
            ret,
            // Support: Firefox 51+
            // Retrieving style before computed somehow
            // fixes an issue with getting wrong values
            // on detached elements
            style = elem.style;

        computed = computed || getStyles(elem);

        // getPropertyValue is needed for:
        //   .css('filter') (IE 9 only, #12537)
        //   .css('--customProperty) (#3144)
        if (computed) {
            ret = computed.getPropertyValue(name) || computed[name];

            if (ret === "" && !isAttached(elem)) {
                ret = jQuery.style(elem, name);
            }

            // A tribute to the "awesome hack by Dean Edwards"
            // Android Browser returns percentage for some values,
            // but width seems to be reliably pixels.
            // This is against the CSSOM draft spec:
            // https://drafts.csswg.org/cssom/#resolved-values
            if (
                !support.pixelBoxStyles() &&
                rnumnonpx.test(ret) &&
                rboxStyle.test(name)
            ) {
                // Remember the original values
                width = style.width;
                minWidth = style.minWidth;
                maxWidth = style.maxWidth;

                // Put in the new values to get a computed value out
                style.minWidth = style.maxWidth = style.width = ret;
                ret = computed.width;

                // Revert the changed values
                style.width = width;
                style.minWidth = minWidth;
                style.maxWidth = maxWidth;
            }
        }

        return ret !== undefined
            ? // Support: IE <=9 - 11 only
              // IE returns zIndex value as an integer.
              ret + ""
            : ret;
    }

    function addGetHookIf(conditionFn, hookFn) {
        // Define the hook, we'll check on the first run if it's really needed.
        return {
            get: function () {
                if (conditionFn()) {
                    // Hook not needed (or it's not possible to use it due
                    // to missing dependency), remove it.
                    delete this.get;
                    return;
                }

                // Hook needed; redefine it so that the support test is not executed again.
                return (this.get = hookFn).apply(this, arguments);
            },
        };
    }

    var cssPrefixes = ["Webkit", "Moz", "ms"],
        emptyStyle = document.createElement("div").style,
        vendorProps = {};

    // Return a vendor-prefixed property or undefined
    function vendorPropName(name) {
        // Check for vendor prefixed names
        var capName = name[0].toUpperCase() + name.slice(1),
            i = cssPrefixes.length;

        while (i--) {
            name = cssPrefixes[i] + capName;
            if (name in emptyStyle) {
                return name;
            }
        }
    }

    // Return a potentially-mapped jQuery.cssProps or vendor prefixed property
    function finalPropName(name) {
        var final = jQuery.cssProps[name] || vendorProps[name];

        if (final) {
            return final;
        }
        if (name in emptyStyle) {
            return name;
        }
        return (vendorProps[name] = vendorPropName(name) || name);
    }

    var // Swappable if display is none or starts with table
        // except "table", "table-cell", or "table-caption"
        // See here for display values: https://developer.mozilla.org/en-US/docs/CSS/display
        rdisplayswap = /^(none|table(?!-c[ea]).+)/,
        rcustomProp = /^--/,
        cssShow = {
            position: "absolute",
            visibility: "hidden",
            display: "block",
        },
        cssNormalTransform = {
            letterSpacing: "0",
            fontWeight: "400",
        };

    function setPositiveNumber(_elem, value, subtract) {
        // Any relative (+/-) values have already been
        // normalized at this point
        var matches = rcssNum.exec(value);
        return matches
            ? // Guard against undefined "subtract", e.g., when used as in cssHooks
              Math.max(0, matches[2] - (subtract || 0)) + (matches[3] || "px")
            : value;
    }

    function boxModelAdjustment(
        elem,
        dimension,
        box,
        isBorderBox,
        styles,
        computedVal
    ) {
        var i = dimension === "width" ? 1 : 0,
            extra = 0,
            delta = 0;

        // Adjustment may not be necessary
        if (box === (isBorderBox ? "border" : "content")) {
            return 0;
        }

        for (; i < 4; i += 2) {
            // Both box models exclude margin
            if (box === "margin") {
                delta += jQuery.css(elem, box + cssExpand[i], true, styles);
            }

            // If we get here with a content-box, we're seeking "padding" or "border" or "margin"
            if (!isBorderBox) {
                // Add padding
                delta += jQuery.css(
                    elem,
                    "padding" + cssExpand[i],
                    true,
                    styles
                );

                // For "border" or "margin", add border
                if (box !== "padding") {
                    delta += jQuery.css(
                        elem,
                        "border" + cssExpand[i] + "Width",
                        true,
                        styles
                    );

                    // But still keep track of it otherwise
                } else {
                    extra += jQuery.css(
                        elem,
                        "border" + cssExpand[i] + "Width",
                        true,
                        styles
                    );
                }

                // If we get here with a border-box (content + padding + border), we're seeking "content" or
                // "padding" or "margin"
            } else {
                // For "content", subtract padding
                if (box === "content") {
                    delta -= jQuery.css(
                        elem,
                        "padding" + cssExpand[i],
                        true,
                        styles
                    );
                }

                // For "content" or "padding", subtract border
                if (box !== "margin") {
                    delta -= jQuery.css(
                        elem,
                        "border" + cssExpand[i] + "Width",
                        true,
                        styles
                    );
                }
            }
        }

        // Account for positive content-box scroll gutter when requested by providing computedVal
        if (!isBorderBox && computedVal >= 0) {
            // offsetWidth/offsetHeight is a rounded sum of content, padding, scroll gutter, and border
            // Assuming integer scroll gutter, subtract the rest and round down
            delta +=
                Math.max(
                    0,
                    Math.ceil(
                        elem[
                            "offset" +
                                dimension[0].toUpperCase() +
                                dimension.slice(1)
                        ] -
                            computedVal -
                            delta -
                            extra -
                            0.5

                        // If offsetWidth/offsetHeight is unknown, then we can't determine content-box scroll gutter
                        // Use an explicit zero to avoid NaN (gh-3964)
                    )
                ) || 0;
        }

        return delta;
    }

    function getWidthOrHeight(elem, dimension, extra) {
        // Start with computed style
        var styles = getStyles(elem),
            // To avoid forcing a reflow, only fetch boxSizing if we need it (gh-4322).
            // Fake content-box until we know it's needed to know the true value.
            boxSizingNeeded = !support.boxSizingReliable() || extra,
            isBorderBox =
                boxSizingNeeded &&
                jQuery.css(elem, "boxSizing", false, styles) === "border-box",
            valueIsBorderBox = isBorderBox,
            val = curCSS(elem, dimension, styles),
            offsetProp =
                "offset" + dimension[0].toUpperCase() + dimension.slice(1);

        // Support: Firefox <=54
        // Return a confounding non-pixel value or feign ignorance, as appropriate.
        if (rnumnonpx.test(val)) {
            if (!extra) {
                return val;
            }
            val = "auto";
        }

        // Support: IE 9 - 11 only
        // Use offsetWidth/offsetHeight for when box sizing is unreliable.
        // In those cases, the computed value can be trusted to be border-box.
        if (
            ((!support.boxSizingReliable() && isBorderBox) ||
                // Support: IE 10 - 11+, Edge 15 - 18+
                // IE/Edge misreport `getComputedStyle` of table rows with width/height
                // set in CSS while `offset*` properties report correct values.
                // Interestingly, in some cases IE 9 doesn't suffer from this issue.
                (!support.reliableTrDimensions() && nodeName(elem, "tr")) ||
                // Fall back to offsetWidth/offsetHeight when value is "auto"
                // This happens for inline elements with no explicit setting (gh-3571)
                val === "auto" ||
                // Support: Android <=4.1 - 4.3 only
                // Also use offsetWidth/offsetHeight for misreported inline dimensions (gh-3602)
                (!parseFloat(val) &&
                    jQuery.css(elem, "display", false, styles) === "inline")) &&
            // Make sure the element is visible & connected
            elem.getClientRects().length
        ) {
            isBorderBox =
                jQuery.css(elem, "boxSizing", false, styles) === "border-box";

            // Where available, offsetWidth/offsetHeight approximate border box dimensions.
            // Where not available (e.g., SVG), assume unreliable box-sizing and interpret the
            // retrieved value as a content box dimension.
            valueIsBorderBox = offsetProp in elem;
            if (valueIsBorderBox) {
                val = elem[offsetProp];
            }
        }

        // Normalize "" and auto
        val = parseFloat(val) || 0;

        // Adjust for the element's box model
        return (
            val +
            boxModelAdjustment(
                elem,
                dimension,
                extra || (isBorderBox ? "border" : "content"),
                valueIsBorderBox,
                styles,

                // Provide the current computed size to request scroll gutter calculation (gh-3589)
                val
            ) +
            "px"
        );
    }

    jQuery.extend({
        // Add in style property hooks for overriding the default
        // behavior of getting and setting a style property
        cssHooks: {
            opacity: {
                get: function (elem, computed) {
                    if (computed) {
                        // We should always get a number back from opacity
                        var ret = curCSS(elem, "opacity");
                        return ret === "" ? "1" : ret;
                    }
                },
            },
        },

        // Don't automatically add "px" to these possibly-unitless properties
        cssNumber: {
            animationIterationCount: true,
            columnCount: true,
            fillOpacity: true,
            flexGrow: true,
            flexShrink: true,
            fontWeight: true,
            gridArea: true,
            gridColumn: true,
            gridColumnEnd: true,
            gridColumnStart: true,
            gridRow: true,
            gridRowEnd: true,
            gridRowStart: true,
            lineHeight: true,
            opacity: true,
            order: true,
            orphans: true,
            widows: true,
            zIndex: true,
            zoom: true,
        },

        // Add in properties whose names you wish to fix before
        // setting or getting the value
        cssProps: {},

        // Get and set the style property on a DOM Node
        style: function (elem, name, value, extra) {
            // Don't set styles on text and comment nodes
            if (
                !elem ||
                elem.nodeType === 3 ||
                elem.nodeType === 8 ||
                !elem.style
            ) {
                return;
            }

            // Make sure that we're working with the right name
            var ret,
                type,
                hooks,
                origName = camelCase(name),
                isCustomProp = rcustomProp.test(name),
                style = elem.style;

            // Make sure that we're working with the right name. We don't
            // want to query the value if it is a CSS custom property
            // since they are user-defined.
            if (!isCustomProp) {
                name = finalPropName(origName);
            }

            // Gets hook for the prefixed version, then unprefixed version
            hooks = jQuery.cssHooks[name] || jQuery.cssHooks[origName];

            // Check if we're setting a value
            if (value !== undefined) {
                type = typeof value;

                // Convert "+=" or "-=" to relative numbers (#7345)
                if (
                    type === "string" &&
                    (ret = rcssNum.exec(value)) &&
                    ret[1]
                ) {
                    value = adjustCSS(elem, name, ret);

                    // Fixes bug #9237
                    type = "number";
                }

                // Make sure that null and NaN values aren't set (#7116)
                if (value == null || value !== value) {
                    return;
                }

                // If a number was passed in, add the unit (except for certain CSS properties)
                // The isCustomProp check can be removed in jQuery 4.0 when we only auto-append
                // "px" to a few hardcoded values.
                if (type === "number" && !isCustomProp) {
                    value +=
                        (ret && ret[3]) ||
                        (jQuery.cssNumber[origName] ? "" : "px");
                }

                // background-* props affect original clone's values
                if (
                    !support.clearCloneStyle &&
                    value === "" &&
                    name.indexOf("background") === 0
                ) {
                    style[name] = "inherit";
                }

                // If a hook was provided, use that value, otherwise just set the specified value
                if (
                    !hooks ||
                    !("set" in hooks) ||
                    (value = hooks.set(elem, value, extra)) !== undefined
                ) {
                    if (isCustomProp) {
                        style.setProperty(name, value);
                    } else {
                        style[name] = value;
                    }
                }
            } else {
                // If a hook was provided get the non-computed value from there
                if (
                    hooks &&
                    "get" in hooks &&
                    (ret = hooks.get(elem, false, extra)) !== undefined
                ) {
                    return ret;
                }

                // Otherwise just get the value from the style object
                return style[name];
            }
        },

        css: function (elem, name, extra, styles) {
            var val,
                num,
                hooks,
                origName = camelCase(name),
                isCustomProp = rcustomProp.test(name);

            // Make sure that we're working with the right name. We don't
            // want to modify the value if it is a CSS custom property
            // since they are user-defined.
            if (!isCustomProp) {
                name = finalPropName(origName);
            }

            // Try prefixed name followed by the unprefixed name
            hooks = jQuery.cssHooks[name] || jQuery.cssHooks[origName];

            // If a hook was provided get the computed value from there
            if (hooks && "get" in hooks) {
                val = hooks.get(elem, true, extra);
            }

            // Otherwise, if a way to get the computed value exists, use that
            if (val === undefined) {
                val = curCSS(elem, name, styles);
            }

            // Convert "normal" to computed value
            if (val === "normal" && name in cssNormalTransform) {
                val = cssNormalTransform[name];
            }

            // Make numeric if forced or a qualifier was provided and val looks numeric
            if (extra === "" || extra) {
                num = parseFloat(val);
                return extra === true || isFinite(num) ? num || 0 : val;
            }

            return val;
        },
    });

    jQuery.each(["height", "width"], function (_i, dimension) {
        jQuery.cssHooks[dimension] = {
            get: function (elem, computed, extra) {
                if (computed) {
                    // Certain elements can have dimension info if we invisibly show them
                    // but it must have a current display style that would benefit
                    return rdisplayswap.test(jQuery.css(elem, "display")) &&
                        // Support: Safari 8+
                        // Table columns in Safari have non-zero offsetWidth & zero
                        // getBoundingClientRect().width unless display is changed.
                        // Support: IE <=11 only
                        // Running getBoundingClientRect on a disconnected node
                        // in IE throws an error.
                        (!elem.getClientRects().length ||
                            !elem.getBoundingClientRect().width)
                        ? swap(elem, cssShow, function () {
                              return getWidthOrHeight(elem, dimension, extra);
                          })
                        : getWidthOrHeight(elem, dimension, extra);
                }
            },

            set: function (elem, value, extra) {
                var matches,
                    styles = getStyles(elem),
                    // Only read styles.position if the test has a chance to fail
                    // to avoid forcing a reflow.
                    scrollboxSizeBuggy =
                        !support.scrollboxSize() &&
                        styles.position === "absolute",
                    // To avoid forcing a reflow, only fetch boxSizing if we need it (gh-3991)
                    boxSizingNeeded = scrollboxSizeBuggy || extra,
                    isBorderBox =
                        boxSizingNeeded &&
                        jQuery.css(elem, "boxSizing", false, styles) ===
                            "border-box",
                    subtract = extra
                        ? boxModelAdjustment(
                              elem,
                              dimension,
                              extra,
                              isBorderBox,
                              styles
                          )
                        : 0;

                // Account for unreliable border-box dimensions by comparing offset* to computed and
                // faking a content-box to get border and padding (gh-3699)
                if (isBorderBox && scrollboxSizeBuggy) {
                    subtract -= Math.ceil(
                        elem[
                            "offset" +
                                dimension[0].toUpperCase() +
                                dimension.slice(1)
                        ] -
                            parseFloat(styles[dimension]) -
                            boxModelAdjustment(
                                elem,
                                dimension,
                                "border",
                                false,
                                styles
                            ) -
                            0.5
                    );
                }

                // Convert to pixels if value adjustment is needed
                if (
                    subtract &&
                    (matches = rcssNum.exec(value)) &&
                    (matches[3] || "px") !== "px"
                ) {
                    elem.style[dimension] = value;
                    value = jQuery.css(elem, dimension);
                }

                return setPositiveNumber(elem, value, subtract);
            },
        };
    });

    jQuery.cssHooks.marginLeft = addGetHookIf(
        support.reliableMarginLeft,
        function (elem, computed) {
            if (computed) {
                return (
                    (parseFloat(curCSS(elem, "marginLeft")) ||
                        elem.getBoundingClientRect().left -
                            swap(elem, { marginLeft: 0 }, function () {
                                return elem.getBoundingClientRect().left;
                            })) + "px"
                );
            }
        }
    );

    // These hooks are used by animate to expand properties
    jQuery.each(
        {
            margin: "",
            padding: "",
            border: "Width",
        },
        function (prefix, suffix) {
            jQuery.cssHooks[prefix + suffix] = {
                expand: function (value) {
                    var i = 0,
                        expanded = {},
                        // Assumes a single number if not a string
                        parts =
                            typeof value === "string"
                                ? value.split(" ")
                                : [value];

                    for (; i < 4; i++) {
                        expanded[prefix + cssExpand[i] + suffix] =
                            parts[i] || parts[i - 2] || parts[0];
                    }

                    return expanded;
                },
            };

            if (prefix !== "margin") {
                jQuery.cssHooks[prefix + suffix].set = setPositiveNumber;
            }
        }
    );

    jQuery.fn.extend({
        css: function (name, value) {
            return access(
                this,
                function (elem, name, value) {
                    var styles,
                        len,
                        map = {},
                        i = 0;

                    if (Array.isArray(name)) {
                        styles = getStyles(elem);
                        len = name.length;

                        for (; i < len; i++) {
                            map[name[i]] = jQuery.css(
                                elem,
                                name[i],
                                false,
                                styles
                            );
                        }

                        return map;
                    }

                    return value !== undefined
                        ? jQuery.style(elem, name, value)
                        : jQuery.css(elem, name);
                },
                name,
                value,
                arguments.length > 1
            );
        },
    });

    function Tween(elem, options, prop, end, easing) {
        return new Tween.prototype.init(elem, options, prop, end, easing);
    }
    jQuery.Tween = Tween;

    Tween.prototype = {
        constructor: Tween,
        init: function (elem, options, prop, end, easing, unit) {
            this.elem = elem;
            this.prop = prop;
            this.easing = easing || jQuery.easing._default;
            this.options = options;
            this.start = this.now = this.cur();
            this.end = end;
            this.unit = unit || (jQuery.cssNumber[prop] ? "" : "px");
        },
        cur: function () {
            var hooks = Tween.propHooks[this.prop];

            return hooks && hooks.get
                ? hooks.get(this)
                : Tween.propHooks._default.get(this);
        },
        run: function (percent) {
            var eased,
                hooks = Tween.propHooks[this.prop];

            if (this.options.duration) {
                this.pos = eased = jQuery.easing[this.easing](
                    percent,
                    this.options.duration * percent,
                    0,
                    1,
                    this.options.duration
                );
            } else {
                this.pos = eased = percent;
            }
            this.now = (this.end - this.start) * eased + this.start;

            if (this.options.step) {
                this.options.step.call(this.elem, this.now, this);
            }

            if (hooks && hooks.set) {
                hooks.set(this);
            } else {
                Tween.propHooks._default.set(this);
            }
            return this;
        },
    };

    Tween.prototype.init.prototype = Tween.prototype;

    Tween.propHooks = {
        _default: {
            get: function (tween) {
                var result;

                // Use a property on the element directly when it is not a DOM element,
                // or when there is no matching style property that exists.
                if (
                    tween.elem.nodeType !== 1 ||
                    (tween.elem[tween.prop] != null &&
                        tween.elem.style[tween.prop] == null)
                ) {
                    return tween.elem[tween.prop];
                }

                // Passing an empty string as a 3rd parameter to .css will automatically
                // attempt a parseFloat and fallback to a string if the parse fails.
                // Simple values such as "10px" are parsed to Float;
                // complex values such as "rotate(1rad)" are returned as-is.
                result = jQuery.css(tween.elem, tween.prop, "");

                // Empty strings, null, undefined and "auto" are converted to 0.
                return !result || result === "auto" ? 0 : result;
            },
            set: function (tween) {
                // Use step hook for back compat.
                // Use cssHook if its there.
                // Use .style if available and use plain properties where available.
                if (jQuery.fx.step[tween.prop]) {
                    jQuery.fx.step[tween.prop](tween);
                } else if (
                    tween.elem.nodeType === 1 &&
                    (jQuery.cssHooks[tween.prop] ||
                        tween.elem.style[finalPropName(tween.prop)] != null)
                ) {
                    jQuery.style(
                        tween.elem,
                        tween.prop,
                        tween.now + tween.unit
                    );
                } else {
                    tween.elem[tween.prop] = tween.now;
                }
            },
        },
    };

    // Support: IE <=9 only
    // Panic based approach to setting things on disconnected nodes
    Tween.propHooks.scrollTop = Tween.propHooks.scrollLeft = {
        set: function (tween) {
            if (tween.elem.nodeType && tween.elem.parentNode) {
                tween.elem[tween.prop] = tween.now;
            }
        },
    };

    jQuery.easing = {
        linear: function (p) {
            return p;
        },
        swing: function (p) {
            return 0.5 - Math.cos(p * Math.PI) / 2;
        },
        _default: "swing",
    };

    jQuery.fx = Tween.prototype.init;

    // Back compat <1.8 extension point
    jQuery.fx.step = {};

    var fxNow,
        inProgress,
        rfxtypes = /^(?:toggle|show|hide)$/,
        rrun = /queueHooks$/;

    function schedule() {
        if (inProgress) {
            if (document.hidden === false && window.requestAnimationFrame) {
                window.requestAnimationFrame(schedule);
            } else {
                window.setTimeout(schedule, jQuery.fx.interval);
            }

            jQuery.fx.tick();
        }
    }

    // Animations created synchronously will run synchronously
    function createFxNow() {
        window.setTimeout(function () {
            fxNow = undefined;
        });
        return (fxNow = Date.now());
    }

    // Generate parameters to create a standard animation
    function genFx(type, includeWidth) {
        var which,
            i = 0,
            attrs = { height: type };

        // If we include width, step value is 1 to do all cssExpand values,
        // otherwise step value is 2 to skip over Left and Right
        includeWidth = includeWidth ? 1 : 0;
        for (; i < 4; i += 2 - includeWidth) {
            which = cssExpand[i];
            attrs["margin" + which] = attrs["padding" + which] = type;
        }

        if (includeWidth) {
            attrs.opacity = attrs.width = type;
        }

        return attrs;
    }

    function createTween(value, prop, animation) {
        var tween,
            collection = (Animation.tweeners[prop] || []).concat(
                Animation.tweeners["*"]
            ),
            index = 0,
            length = collection.length;
        for (; index < length; index++) {
            if ((tween = collection[index].call(animation, prop, value))) {
                // We're done with this property
                return tween;
            }
        }
    }

    function defaultPrefilter(elem, props, opts) {
        var prop,
            value,
            toggle,
            hooks,
            oldfire,
            propTween,
            restoreDisplay,
            display,
            isBox = "width" in props || "height" in props,
            anim = this,
            orig = {},
            style = elem.style,
            hidden = elem.nodeType && isHiddenWithinTree(elem),
            dataShow = dataPriv.get(elem, "fxshow");

        // Queue-skipping animations hijack the fx hooks
        if (!opts.queue) {
            hooks = jQuery._queueHooks(elem, "fx");
            if (hooks.unqueued == null) {
                hooks.unqueued = 0;
                oldfire = hooks.empty.fire;
                hooks.empty.fire = function () {
                    if (!hooks.unqueued) {
                        oldfire();
                    }
                };
            }
            hooks.unqueued++;

            anim.always(function () {
                // Ensure the complete handler is called before this completes
                anim.always(function () {
                    hooks.unqueued--;
                    if (!jQuery.queue(elem, "fx").length) {
                        hooks.empty.fire();
                    }
                });
            });
        }

        // Detect show/hide animations
        for (prop in props) {
            value = props[prop];
            if (rfxtypes.test(value)) {
                delete props[prop];
                toggle = toggle || value === "toggle";
                if (value === (hidden ? "hide" : "show")) {
                    // Pretend to be hidden if this is a "show" and
                    // there is still data from a stopped show/hide
                    if (
                        value === "show" &&
                        dataShow &&
                        dataShow[prop] !== undefined
                    ) {
                        hidden = true;

                        // Ignore all other no-op show/hide data
                    } else {
                        continue;
                    }
                }
                orig[prop] =
                    (dataShow && dataShow[prop]) || jQuery.style(elem, prop);
            }
        }

        // Bail out if this is a no-op like .hide().hide()
        propTween = !jQuery.isEmptyObject(props);
        if (!propTween && jQuery.isEmptyObject(orig)) {
            return;
        }

        // Restrict "overflow" and "display" styles during box animations
        if (isBox && elem.nodeType === 1) {
            // Support: IE <=9 - 11, Edge 12 - 15
            // Record all 3 overflow attributes because IE does not infer the shorthand
            // from identically-valued overflowX and overflowY and Edge just mirrors
            // the overflowX value there.
            opts.overflow = [style.overflow, style.overflowX, style.overflowY];

            // Identify a display type, preferring old show/hide data over the CSS cascade
            restoreDisplay = dataShow && dataShow.display;
            if (restoreDisplay == null) {
                restoreDisplay = dataPriv.get(elem, "display");
            }
            display = jQuery.css(elem, "display");
            if (display === "none") {
                if (restoreDisplay) {
                    display = restoreDisplay;
                } else {
                    // Get nonempty value(s) by temporarily forcing visibility
                    showHide([elem], true);
                    restoreDisplay = elem.style.display || restoreDisplay;
                    display = jQuery.css(elem, "display");
                    showHide([elem]);
                }
            }

            // Animate inline elements as inline-block
            if (
                display === "inline" ||
                (display === "inline-block" && restoreDisplay != null)
            ) {
                if (jQuery.css(elem, "float") === "none") {
                    // Restore the original display value at the end of pure show/hide animations
                    if (!propTween) {
                        anim.done(function () {
                            style.display = restoreDisplay;
                        });
                        if (restoreDisplay == null) {
                            display = style.display;
                            restoreDisplay = display === "none" ? "" : display;
                        }
                    }
                    style.display = "inline-block";
                }
            }
        }

        if (opts.overflow) {
            style.overflow = "hidden";
            anim.always(function () {
                style.overflow = opts.overflow[0];
                style.overflowX = opts.overflow[1];
                style.overflowY = opts.overflow[2];
            });
        }

        // Implement show/hide animations
        propTween = false;
        for (prop in orig) {
            // General show/hide setup for this element animation
            if (!propTween) {
                if (dataShow) {
                    if ("hidden" in dataShow) {
                        hidden = dataShow.hidden;
                    }
                } else {
                    dataShow = dataPriv.access(elem, "fxshow", {
                        display: restoreDisplay,
                    });
                }

                // Store hidden/visible for toggle so `.stop().toggle()` "reverses"
                if (toggle) {
                    dataShow.hidden = !hidden;
                }

                // Show elements before animating them
                if (hidden) {
                    showHide([elem], true);
                }

                /* eslint-disable no-loop-func */

                anim.done(function () {
                    /* eslint-enable no-loop-func */

                    // The final step of a "hide" animation is actually hiding the element
                    if (!hidden) {
                        showHide([elem]);
                    }
                    dataPriv.remove(elem, "fxshow");
                    for (prop in orig) {
                        jQuery.style(elem, prop, orig[prop]);
                    }
                });
            }

            // Per-property setup
            propTween = createTween(hidden ? dataShow[prop] : 0, prop, anim);
            if (!(prop in dataShow)) {
                dataShow[prop] = propTween.start;
                if (hidden) {
                    propTween.end = propTween.start;
                    propTween.start = 0;
                }
            }
        }
    }

    function propFilter(props, specialEasing) {
        var index, name, easing, value, hooks;

        // camelCase, specialEasing and expand cssHook pass
        for (index in props) {
            name = camelCase(index);
            easing = specialEasing[name];
            value = props[index];
            if (Array.isArray(value)) {
                easing = value[1];
                value = props[index] = value[0];
            }

            if (index !== name) {
                props[name] = value;
                delete props[index];
            }

            hooks = jQuery.cssHooks[name];
            if (hooks && "expand" in hooks) {
                value = hooks.expand(value);
                delete props[name];

                // Not quite $.extend, this won't overwrite existing keys.
                // Reusing 'index' because we have the correct "name"
                for (index in value) {
                    if (!(index in props)) {
                        props[index] = value[index];
                        specialEasing[index] = easing;
                    }
                }
            } else {
                specialEasing[name] = easing;
            }
        }
    }

    function Animation(elem, properties, options) {
        var result,
            stopped,
            index = 0,
            length = Animation.prefilters.length,
            deferred = jQuery.Deferred().always(function () {
                // Don't match elem in the :animated selector
                delete tick.elem;
            }),
            tick = function () {
                if (stopped) {
                    return false;
                }
                var currentTime = fxNow || createFxNow(),
                    remaining = Math.max(
                        0,
                        animation.startTime + animation.duration - currentTime
                    ),
                    // Support: Android 2.3 only
                    // Archaic crash bug won't allow us to use `1 - ( 0.5 || 0 )` (#12497)
                    temp = remaining / animation.duration || 0,
                    percent = 1 - temp,
                    index = 0,
                    length = animation.tweens.length;

                for (; index < length; index++) {
                    animation.tweens[index].run(percent);
                }

                deferred.notifyWith(elem, [animation, percent, remaining]);

                // If there's more to do, yield
                if (percent < 1 && length) {
                    return remaining;
                }

                // If this was an empty animation, synthesize a final progress notification
                if (!length) {
                    deferred.notifyWith(elem, [animation, 1, 0]);
                }

                // Resolve the animation and report its conclusion
                deferred.resolveWith(elem, [animation]);
                return false;
            },
            animation = deferred.promise({
                elem: elem,
                props: jQuery.extend({}, properties),
                opts: jQuery.extend(
                    true,
                    {
                        specialEasing: {},
                        easing: jQuery.easing._default,
                    },
                    options
                ),
                originalProperties: properties,
                originalOptions: options,
                startTime: fxNow || createFxNow(),
                duration: options.duration,
                tweens: [],
                createTween: function (prop, end) {
                    var tween = jQuery.Tween(
                        elem,
                        animation.opts,
                        prop,
                        end,
                        animation.opts.specialEasing[prop] ||
                            animation.opts.easing
                    );
                    animation.tweens.push(tween);
                    return tween;
                },
                stop: function (gotoEnd) {
                    var index = 0,
                        // If we are going to the end, we want to run all the tweens
                        // otherwise we skip this part
                        length = gotoEnd ? animation.tweens.length : 0;
                    if (stopped) {
                        return this;
                    }
                    stopped = true;
                    for (; index < length; index++) {
                        animation.tweens[index].run(1);
                    }

                    // Resolve when we played the last frame; otherwise, reject
                    if (gotoEnd) {
                        deferred.notifyWith(elem, [animation, 1, 0]);
                        deferred.resolveWith(elem, [animation, gotoEnd]);
                    } else {
                        deferred.rejectWith(elem, [animation, gotoEnd]);
                    }
                    return this;
                },
            }),
            props = animation.props;

        propFilter(props, animation.opts.specialEasing);

        for (; index < length; index++) {
            result = Animation.prefilters[index].call(
                animation,
                elem,
                props,
                animation.opts
            );
            if (result) {
                if (isFunction(result.stop)) {
                    jQuery._queueHooks(
                        animation.elem,
                        animation.opts.queue
                    ).stop = result.stop.bind(result);
                }
                return result;
            }
        }

        jQuery.map(props, createTween, animation);

        if (isFunction(animation.opts.start)) {
            animation.opts.start.call(elem, animation);
        }

        // Attach callbacks from options
        animation
            .progress(animation.opts.progress)
            .done(animation.opts.done, animation.opts.complete)
            .fail(animation.opts.fail)
            .always(animation.opts.always);

        jQuery.fx.timer(
            jQuery.extend(tick, {
                elem: elem,
                anim: animation,
                queue: animation.opts.queue,
            })
        );

        return animation;
    }

    jQuery.Animation = jQuery.extend(Animation, {
        tweeners: {
            "*": [
                function (prop, value) {
                    var tween = this.createTween(prop, value);
                    adjustCSS(tween.elem, prop, rcssNum.exec(value), tween);
                    return tween;
                },
            ],
        },

        tweener: function (props, callback) {
            if (isFunction(props)) {
                callback = props;
                props = ["*"];
            } else {
                props = props.match(rnothtmlwhite);
            }

            var prop,
                index = 0,
                length = props.length;

            for (; index < length; index++) {
                prop = props[index];
                Animation.tweeners[prop] = Animation.tweeners[prop] || [];
                Animation.tweeners[prop].unshift(callback);
            }
        },

        prefilters: [defaultPrefilter],

        prefilter: function (callback, prepend) {
            if (prepend) {
                Animation.prefilters.unshift(callback);
            } else {
                Animation.prefilters.push(callback);
            }
        },
    });

    jQuery.speed = function (speed, easing, fn) {
        var opt =
            speed && typeof speed === "object"
                ? jQuery.extend({}, speed)
                : {
                      complete:
                          fn || (!fn && easing) || (isFunction(speed) && speed),
                      duration: speed,
                      easing:
                          (fn && easing) ||
                          (easing && !isFunction(easing) && easing),
                  };

        // Go to the end state if fx are off
        if (jQuery.fx.off) {
            opt.duration = 0;
        } else {
            if (typeof opt.duration !== "number") {
                if (opt.duration in jQuery.fx.speeds) {
                    opt.duration = jQuery.fx.speeds[opt.duration];
                } else {
                    opt.duration = jQuery.fx.speeds._default;
                }
            }
        }

        // Normalize opt.queue - true/undefined/null -> "fx"
        if (opt.queue == null || opt.queue === true) {
            opt.queue = "fx";
        }

        // Queueing
        opt.old = opt.complete;

        opt.complete = function () {
            if (isFunction(opt.old)) {
                opt.old.call(this);
            }

            if (opt.queue) {
                jQuery.dequeue(this, opt.queue);
            }
        };

        return opt;
    };

    jQuery.fn.extend({
        fadeTo: function (speed, to, easing, callback) {
            // Show any hidden elements after setting opacity to 0
            return (
                this.filter(isHiddenWithinTree)
                    .css("opacity", 0)
                    .show()

                    // Animate to the value specified
                    .end()
                    .animate({ opacity: to }, speed, easing, callback)
            );
        },
        animate: function (prop, speed, easing, callback) {
            var empty = jQuery.isEmptyObject(prop),
                optall = jQuery.speed(speed, easing, callback),
                doAnimation = function () {
                    // Operate on a copy of prop so per-property easing won't be lost
                    var anim = Animation(this, jQuery.extend({}, prop), optall);

                    // Empty animations, or finishing resolves immediately
                    if (empty || dataPriv.get(this, "finish")) {
                        anim.stop(true);
                    }
                };

            doAnimation.finish = doAnimation;

            return empty || optall.queue === false
                ? this.each(doAnimation)
                : this.queue(optall.queue, doAnimation);
        },
        stop: function (type, clearQueue, gotoEnd) {
            var stopQueue = function (hooks) {
                var stop = hooks.stop;
                delete hooks.stop;
                stop(gotoEnd);
            };

            if (typeof type !== "string") {
                gotoEnd = clearQueue;
                clearQueue = type;
                type = undefined;
            }
            if (clearQueue) {
                this.queue(type || "fx", []);
            }

            return this.each(function () {
                var dequeue = true,
                    index = type != null && type + "queueHooks",
                    timers = jQuery.timers,
                    data = dataPriv.get(this);

                if (index) {
                    if (data[index] && data[index].stop) {
                        stopQueue(data[index]);
                    }
                } else {
                    for (index in data) {
                        if (
                            data[index] &&
                            data[index].stop &&
                            rrun.test(index)
                        ) {
                            stopQueue(data[index]);
                        }
                    }
                }

                for (index = timers.length; index--; ) {
                    if (
                        timers[index].elem === this &&
                        (type == null || timers[index].queue === type)
                    ) {
                        timers[index].anim.stop(gotoEnd);
                        dequeue = false;
                        timers.splice(index, 1);
                    }
                }

                // Start the next in the queue if the last step wasn't forced.
                // Timers currently will call their complete callbacks, which
                // will dequeue but only if they were gotoEnd.
                if (dequeue || !gotoEnd) {
                    jQuery.dequeue(this, type);
                }
            });
        },
        finish: function (type) {
            if (type !== false) {
                type = type || "fx";
            }
            return this.each(function () {
                var index,
                    data = dataPriv.get(this),
                    queue = data[type + "queue"],
                    hooks = data[type + "queueHooks"],
                    timers = jQuery.timers,
                    length = queue ? queue.length : 0;

                // Enable finishing flag on private data
                data.finish = true;

                // Empty the queue first
                jQuery.queue(this, type, []);

                if (hooks && hooks.stop) {
                    hooks.stop.call(this, true);
                }

                // Look for any active animations, and finish them
                for (index = timers.length; index--; ) {
                    if (
                        timers[index].elem === this &&
                        timers[index].queue === type
                    ) {
                        timers[index].anim.stop(true);
                        timers.splice(index, 1);
                    }
                }

                // Look for any animations in the old queue and finish them
                for (index = 0; index < length; index++) {
                    if (queue[index] && queue[index].finish) {
                        queue[index].finish.call(this);
                    }
                }

                // Turn off finishing flag
                delete data.finish;
            });
        },
    });

    jQuery.each(["toggle", "show", "hide"], function (_i, name) {
        var cssFn = jQuery.fn[name];
        jQuery.fn[name] = function (speed, easing, callback) {
            return speed == null || typeof speed === "boolean"
                ? cssFn.apply(this, arguments)
                : this.animate(genFx(name, true), speed, easing, callback);
        };
    });

    // Generate shortcuts for custom animations
    jQuery.each(
        {
            slideDown: genFx("show"),
            slideUp: genFx("hide"),
            slideToggle: genFx("toggle"),
            fadeIn: { opacity: "show" },
            fadeOut: { opacity: "hide" },
            fadeToggle: { opacity: "toggle" },
        },
        function (name, props) {
            jQuery.fn[name] = function (speed, easing, callback) {
                return this.animate(props, speed, easing, callback);
            };
        }
    );

    jQuery.timers = [];
    jQuery.fx.tick = function () {
        var timer,
            i = 0,
            timers = jQuery.timers;

        fxNow = Date.now();

        for (; i < timers.length; i++) {
            timer = timers[i];

            // Run the timer and safely remove it when done (allowing for external removal)
            if (!timer() && timers[i] === timer) {
                timers.splice(i--, 1);
            }
        }

        if (!timers.length) {
            jQuery.fx.stop();
        }
        fxNow = undefined;
    };

    jQuery.fx.timer = function (timer) {
        jQuery.timers.push(timer);
        jQuery.fx.start();
    };

    jQuery.fx.interval = 13;
    jQuery.fx.start = function () {
        if (inProgress) {
            return;
        }

        inProgress = true;
        schedule();
    };

    jQuery.fx.stop = function () {
        inProgress = null;
    };

    jQuery.fx.speeds = {
        slow: 600,
        fast: 200,

        // Default speed
        _default: 400,
    };

    // Based off of the plugin by Clint Helfers, with permission.
    // https://web.archive.org/web/20100324014747/http://blindsignals.com/index.php/2009/07/jquery-delay/
    jQuery.fn.delay = function (time, type) {
        time = jQuery.fx ? jQuery.fx.speeds[time] || time : time;
        type = type || "fx";

        return this.queue(type, function (next, hooks) {
            var timeout = window.setTimeout(next, time);
            hooks.stop = function () {
                window.clearTimeout(timeout);
            };
        });
    };

    (function () {
        var input = document.createElement("input"),
            select = document.createElement("select"),
            opt = select.appendChild(document.createElement("option"));

        input.type = "checkbox";

        // Support: Android <=4.3 only
        // Default value for a checkbox should be "on"
        support.checkOn = input.value !== "";

        // Support: IE <=11 only
        // Must access selectedIndex to make default options select
        support.optSelected = opt.selected;

        // Support: IE <=11 only
        // An input loses its value after becoming a radio
        input = document.createElement("input");
        input.value = "t";
        input.type = "radio";
        support.radioValue = input.value === "t";
    })();

    var boolHook,
        attrHandle = jQuery.expr.attrHandle;

    jQuery.fn.extend({
        attr: function (name, value) {
            return access(this, jQuery.attr, name, value, arguments.length > 1);
        },

        removeAttr: function (name) {
            return this.each(function () {
                jQuery.removeAttr(this, name);
            });
        },
    });

    jQuery.extend({
        attr: function (elem, name, value) {
            var ret,
                hooks,
                nType = elem.nodeType;

            // Don't get/set attributes on text, comment and attribute nodes
            if (nType === 3 || nType === 8 || nType === 2) {
                return;
            }

            // Fallback to prop when attributes are not supported
            if (typeof elem.getAttribute === "undefined") {
                return jQuery.prop(elem, name, value);
            }

            // Attribute hooks are determined by the lowercase version
            // Grab necessary hook if one is defined
            if (nType !== 1 || !jQuery.isXMLDoc(elem)) {
                hooks =
                    jQuery.attrHooks[name.toLowerCase()] ||
                    (jQuery.expr.match.bool.test(name) ? boolHook : undefined);
            }

            if (value !== undefined) {
                if (value === null) {
                    jQuery.removeAttr(elem, name);
                    return;
                }

                if (
                    hooks &&
                    "set" in hooks &&
                    (ret = hooks.set(elem, value, name)) !== undefined
                ) {
                    return ret;
                }

                elem.setAttribute(name, value + "");
                return value;
            }

            if (
                hooks &&
                "get" in hooks &&
                (ret = hooks.get(elem, name)) !== null
            ) {
                return ret;
            }

            ret = jQuery.find.attr(elem, name);

            // Non-existent attributes return null, we normalize to undefined
            return ret == null ? undefined : ret;
        },

        attrHooks: {
            type: {
                set: function (elem, value) {
                    if (
                        !support.radioValue &&
                        value === "radio" &&
                        nodeName(elem, "input")
                    ) {
                        var val = elem.value;
                        elem.setAttribute("type", value);
                        if (val) {
                            elem.value = val;
                        }
                        return value;
                    }
                },
            },
        },

        removeAttr: function (elem, value) {
            var name,
                i = 0,
                // Attribute names can contain non-HTML whitespace characters
                // https://html.spec.whatwg.org/multipage/syntax.html#attributes-2
                attrNames = value && value.match(rnothtmlwhite);

            if (attrNames && elem.nodeType === 1) {
                while ((name = attrNames[i++])) {
                    elem.removeAttribute(name);
                }
            }
        },
    });

    // Hooks for boolean attributes
    boolHook = {
        set: function (elem, value, name) {
            if (value === false) {
                // Remove boolean attributes when set to false
                jQuery.removeAttr(elem, name);
            } else {
                elem.setAttribute(name, name);
            }
            return name;
        },
    };

    jQuery.each(
        jQuery.expr.match.bool.source.match(/\w+/g),
        function (_i, name) {
            var getter = attrHandle[name] || jQuery.find.attr;

            attrHandle[name] = function (elem, name, isXML) {
                var ret,
                    handle,
                    lowercaseName = name.toLowerCase();

                if (!isXML) {
                    // Avoid an infinite loop by temporarily removing this function from the getter
                    handle = attrHandle[lowercaseName];
                    attrHandle[lowercaseName] = ret;
                    ret =
                        getter(elem, name, isXML) != null
                            ? lowercaseName
                            : null;
                    attrHandle[lowercaseName] = handle;
                }
                return ret;
            };
        }
    );

    var rfocusable = /^(?:input|select|textarea|button)$/i,
        rclickable = /^(?:a|area)$/i;

    jQuery.fn.extend({
        prop: function (name, value) {
            return access(this, jQuery.prop, name, value, arguments.length > 1);
        },

        removeProp: function (name) {
            return this.each(function () {
                delete this[jQuery.propFix[name] || name];
            });
        },
    });

    jQuery.extend({
        prop: function (elem, name, value) {
            var ret,
                hooks,
                nType = elem.nodeType;

            // Don't get/set properties on text, comment and attribute nodes
            if (nType === 3 || nType === 8 || nType === 2) {
                return;
            }

            if (nType !== 1 || !jQuery.isXMLDoc(elem)) {
                // Fix name and attach hooks
                name = jQuery.propFix[name] || name;
                hooks = jQuery.propHooks[name];
            }

            if (value !== undefined) {
                if (
                    hooks &&
                    "set" in hooks &&
                    (ret = hooks.set(elem, value, name)) !== undefined
                ) {
                    return ret;
                }

                return (elem[name] = value);
            }

            if (
                hooks &&
                "get" in hooks &&
                (ret = hooks.get(elem, name)) !== null
            ) {
                return ret;
            }

            return elem[name];
        },

        propHooks: {
            tabIndex: {
                get: function (elem) {
                    // Support: IE <=9 - 11 only
                    // elem.tabIndex doesn't always return the
                    // correct value when it hasn't been explicitly set
                    // https://web.archive.org/web/20141116233347/http://fluidproject.org/blog/2008/01/09/getting-setting-and-removing-tabindex-values-with-javascript/
                    // Use proper attribute retrieval(#12072)
                    var tabindex = jQuery.find.attr(elem, "tabindex");

                    if (tabindex) {
                        return parseInt(tabindex, 10);
                    }

                    if (
                        rfocusable.test(elem.nodeName) ||
                        (rclickable.test(elem.nodeName) && elem.href)
                    ) {
                        return 0;
                    }

                    return -1;
                },
            },
        },

        propFix: {
            for: "htmlFor",
            class: "className",
        },
    });

    // Support: IE <=11 only
    // Accessing the selectedIndex property
    // forces the browser to respect setting selected
    // on the option
    // The getter ensures a default option is selected
    // when in an optgroup
    // eslint rule "no-unused-expressions" is disabled for this code
    // since it considers such accessions noop
    if (!support.optSelected) {
        jQuery.propHooks.selected = {
            get: function (elem) {
                /* eslint no-unused-expressions: "off" */

                var parent = elem.parentNode;
                if (parent && parent.parentNode) {
                    parent.parentNode.selectedIndex;
                }
                return null;
            },
            set: function (elem) {
                /* eslint no-unused-expressions: "off" */

                var parent = elem.parentNode;
                if (parent) {
                    parent.selectedIndex;

                    if (parent.parentNode) {
                        parent.parentNode.selectedIndex;
                    }
                }
            },
        };
    }

    jQuery.each(
        [
            "tabIndex",
            "readOnly",
            "maxLength",
            "cellSpacing",
            "cellPadding",
            "rowSpan",
            "colSpan",
            "useMap",
            "frameBorder",
            "contentEditable",
        ],
        function () {
            jQuery.propFix[this.toLowerCase()] = this;
        }
    );

    // Strip and collapse whitespace according to HTML spec
    // https://infra.spec.whatwg.org/#strip-and-collapse-ascii-whitespace
    function stripAndCollapse(value) {
        var tokens = value.match(rnothtmlwhite) || [];
        return tokens.join(" ");
    }

    function getClass(elem) {
        return (elem.getAttribute && elem.getAttribute("class")) || "";
    }

    function classesToArray(value) {
        if (Array.isArray(value)) {
            return value;
        }
        if (typeof value === "string") {
            return value.match(rnothtmlwhite) || [];
        }
        return [];
    }

    jQuery.fn.extend({
        addClass: function (value) {
            var classes,
                elem,
                cur,
                curValue,
                clazz,
                j,
                finalValue,
                i = 0;

            if (isFunction(value)) {
                return this.each(function (j) {
                    jQuery(this).addClass(value.call(this, j, getClass(this)));
                });
            }

            classes = classesToArray(value);

            if (classes.length) {
                while ((elem = this[i++])) {
                    curValue = getClass(elem);
                    cur =
                        elem.nodeType === 1 &&
                        " " + stripAndCollapse(curValue) + " ";

                    if (cur) {
                        j = 0;
                        while ((clazz = classes[j++])) {
                            if (cur.indexOf(" " + clazz + " ") < 0) {
                                cur += clazz + " ";
                            }
                        }

                        // Only assign if different to avoid unneeded rendering.
                        finalValue = stripAndCollapse(cur);
                        if (curValue !== finalValue) {
                            elem.setAttribute("class", finalValue);
                        }
                    }
                }
            }

            return this;
        },

        removeClass: function (value) {
            var classes,
                elem,
                cur,
                curValue,
                clazz,
                j,
                finalValue,
                i = 0;

            if (isFunction(value)) {
                return this.each(function (j) {
                    jQuery(this).removeClass(
                        value.call(this, j, getClass(this))
                    );
                });
            }

            if (!arguments.length) {
                return this.attr("class", "");
            }

            classes = classesToArray(value);

            if (classes.length) {
                while ((elem = this[i++])) {
                    curValue = getClass(elem);

                    // This expression is here for better compressibility (see addClass)
                    cur =
                        elem.nodeType === 1 &&
                        " " + stripAndCollapse(curValue) + " ";

                    if (cur) {
                        j = 0;
                        while ((clazz = classes[j++])) {
                            // Remove *all* instances
                            while (cur.indexOf(" " + clazz + " ") > -1) {
                                cur = cur.replace(" " + clazz + " ", " ");
                            }
                        }

                        // Only assign if different to avoid unneeded rendering.
                        finalValue = stripAndCollapse(cur);
                        if (curValue !== finalValue) {
                            elem.setAttribute("class", finalValue);
                        }
                    }
                }
            }

            return this;
        },

        toggleClass: function (value, stateVal) {
            var type = typeof value,
                isValidValue = type === "string" || Array.isArray(value);

            if (typeof stateVal === "boolean" && isValidValue) {
                return stateVal
                    ? this.addClass(value)
                    : this.removeClass(value);
            }

            if (isFunction(value)) {
                return this.each(function (i) {
                    jQuery(this).toggleClass(
                        value.call(this, i, getClass(this), stateVal),
                        stateVal
                    );
                });
            }

            return this.each(function () {
                var className, i, self, classNames;

                if (isValidValue) {
                    // Toggle individual class names
                    i = 0;
                    self = jQuery(this);
                    classNames = classesToArray(value);

                    while ((className = classNames[i++])) {
                        // Check each className given, space separated list
                        if (self.hasClass(className)) {
                            self.removeClass(className);
                        } else {
                            self.addClass(className);
                        }
                    }

                    // Toggle whole class name
                } else if (value === undefined || type === "boolean") {
                    className = getClass(this);
                    if (className) {
                        // Store className if set
                        dataPriv.set(this, "__className__", className);
                    }

                    // If the element has a class name or if we're passed `false`,
                    // then remove the whole classname (if there was one, the above saved it).
                    // Otherwise bring back whatever was previously saved (if anything),
                    // falling back to the empty string if nothing was stored.
                    if (this.setAttribute) {
                        this.setAttribute(
                            "class",
                            className || value === false
                                ? ""
                                : dataPriv.get(this, "__className__") || ""
                        );
                    }
                }
            });
        },

        hasClass: function (selector) {
            var className,
                elem,
                i = 0;

            className = " " + selector + " ";
            while ((elem = this[i++])) {
                if (
                    elem.nodeType === 1 &&
                    (" " + stripAndCollapse(getClass(elem)) + " ").indexOf(
                        className
                    ) > -1
                ) {
                    return true;
                }
            }

            return false;
        },
    });

    var rreturn = /\r/g;

    jQuery.fn.extend({
        val: function (value) {
            var hooks,
                ret,
                valueIsFunction,
                elem = this[0];

            if (!arguments.length) {
                if (elem) {
                    hooks =
                        jQuery.valHooks[elem.type] ||
                        jQuery.valHooks[elem.nodeName.toLowerCase()];

                    if (
                        hooks &&
                        "get" in hooks &&
                        (ret = hooks.get(elem, "value")) !== undefined
                    ) {
                        return ret;
                    }

                    ret = elem.value;

                    // Handle most common string cases
                    if (typeof ret === "string") {
                        return ret.replace(rreturn, "");
                    }

                    // Handle cases where value is null/undef or number
                    return ret == null ? "" : ret;
                }

                return;
            }

            valueIsFunction = isFunction(value);

            return this.each(function (i) {
                var val;

                if (this.nodeType !== 1) {
                    return;
                }

                if (valueIsFunction) {
                    val = value.call(this, i, jQuery(this).val());
                } else {
                    val = value;
                }

                // Treat null/undefined as ""; convert numbers to string
                if (val == null) {
                    val = "";
                } else if (typeof val === "number") {
                    val += "";
                } else if (Array.isArray(val)) {
                    val = jQuery.map(val, function (value) {
                        return value == null ? "" : value + "";
                    });
                }

                hooks =
                    jQuery.valHooks[this.type] ||
                    jQuery.valHooks[this.nodeName.toLowerCase()];

                // If set returns undefined, fall back to normal setting
                if (
                    !hooks ||
                    !("set" in hooks) ||
                    hooks.set(this, val, "value") === undefined
                ) {
                    this.value = val;
                }
            });
        },
    });

    jQuery.extend({
        valHooks: {
            option: {
                get: function (elem) {
                    var val = jQuery.find.attr(elem, "value");
                    return val != null
                        ? val
                        : // Support: IE <=10 - 11 only
                          // option.text throws exceptions (#14686, #14858)
                          // Strip and collapse whitespace
                          // https://html.spec.whatwg.org/#strip-and-collapse-whitespace
                          stripAndCollapse(jQuery.text(elem));
                },
            },
            select: {
                get: function (elem) {
                    var value,
                        option,
                        i,
                        options = elem.options,
                        index = elem.selectedIndex,
                        one = elem.type === "select-one",
                        values = one ? null : [],
                        max = one ? index + 1 : options.length;

                    if (index < 0) {
                        i = max;
                    } else {
                        i = one ? index : 0;
                    }

                    // Loop through all the selected options
                    for (; i < max; i++) {
                        option = options[i];

                        // Support: IE <=9 only
                        // IE8-9 doesn't update selected after form reset (#2551)
                        if (
                            (option.selected || i === index) &&
                            // Don't return options that are disabled or in a disabled optgroup
                            !option.disabled &&
                            (!option.parentNode.disabled ||
                                !nodeName(option.parentNode, "optgroup"))
                        ) {
                            // Get the specific value for the option
                            value = jQuery(option).val();

                            // We don't need an array for one selects
                            if (one) {
                                return value;
                            }

                            // Multi-Selects return an array
                            values.push(value);
                        }
                    }

                    return values;
                },

                set: function (elem, value) {
                    var optionSet,
                        option,
                        options = elem.options,
                        values = jQuery.makeArray(value),
                        i = options.length;

                    while (i--) {
                        option = options[i];

                        /* eslint-disable no-cond-assign */

                        if (
                            (option.selected =
                                jQuery.inArray(
                                    jQuery.valHooks.option.get(option),
                                    values
                                ) > -1)
                        ) {
                            optionSet = true;
                        }

                        /* eslint-enable no-cond-assign */
                    }

                    // Force browsers to behave consistently when non-matching value is set
                    if (!optionSet) {
                        elem.selectedIndex = -1;
                    }
                    return values;
                },
            },
        },
    });

    // Radios and checkboxes getter/setter
    jQuery.each(["radio", "checkbox"], function () {
        jQuery.valHooks[this] = {
            set: function (elem, value) {
                if (Array.isArray(value)) {
                    return (elem.checked =
                        jQuery.inArray(jQuery(elem).val(), value) > -1);
                }
            },
        };
        if (!support.checkOn) {
            jQuery.valHooks[this].get = function (elem) {
                return elem.getAttribute("value") === null ? "on" : elem.value;
            };
        }
    });

    // Return jQuery for attributes-only inclusion

    support.focusin = "onfocusin" in window;

    var rfocusMorph = /^(?:focusinfocus|focusoutblur)$/,
        stopPropagationCallback = function (e) {
            e.stopPropagation();
        };

    jQuery.extend(jQuery.event, {
        trigger: function (event, data, elem, onlyHandlers) {
            var i,
                cur,
                tmp,
                bubbleType,
                ontype,
                handle,
                special,
                lastElement,
                eventPath = [elem || document],
                type = hasOwn.call(event, "type") ? event.type : event,
                namespaces = hasOwn.call(event, "namespace")
                    ? event.namespace.split(".")
                    : [];

            cur = lastElement = tmp = elem = elem || document;

            // Don't do events on text and comment nodes
            if (elem.nodeType === 3 || elem.nodeType === 8) {
                return;
            }

            // focus/blur morphs to focusin/out; ensure we're not firing them right now
            if (rfocusMorph.test(type + jQuery.event.triggered)) {
                return;
            }

            if (type.indexOf(".") > -1) {
                // Namespaced trigger; create a regexp to match event type in handle()
                namespaces = type.split(".");
                type = namespaces.shift();
                namespaces.sort();
            }
            ontype = type.indexOf(":") < 0 && "on" + type;

            // Caller can pass in a jQuery.Event object, Object, or just an event type string
            event = event[jQuery.expando]
                ? event
                : new jQuery.Event(type, typeof event === "object" && event);

            // Trigger bitmask: & 1 for native handlers; & 2 for jQuery (always true)
            event.isTrigger = onlyHandlers ? 2 : 3;
            event.namespace = namespaces.join(".");
            event.rnamespace = event.namespace
                ? new RegExp(
                      "(^|\\.)" + namespaces.join("\\.(?:.*\\.|)") + "(\\.|$)"
                  )
                : null;

            // Clean up the event in case it is being reused
            event.result = undefined;
            if (!event.target) {
                event.target = elem;
            }

            // Clone any incoming data and prepend the event, creating the handler arg list
            data = data == null ? [event] : jQuery.makeArray(data, [event]);

            // Allow special events to draw outside the lines
            special = jQuery.event.special[type] || {};
            if (
                !onlyHandlers &&
                special.trigger &&
                special.trigger.apply(elem, data) === false
            ) {
                return;
            }

            // Determine event propagation path in advance, per W3C events spec (#9951)
            // Bubble up to document, then to window; watch for a global ownerDocument var (#9724)
            if (!onlyHandlers && !special.noBubble && !isWindow(elem)) {
                bubbleType = special.delegateType || type;
                if (!rfocusMorph.test(bubbleType + type)) {
                    cur = cur.parentNode;
                }
                for (; cur; cur = cur.parentNode) {
                    eventPath.push(cur);
                    tmp = cur;
                }

                // Only add window if we got to document (e.g., not plain obj or detached DOM)
                if (tmp === (elem.ownerDocument || document)) {
                    eventPath.push(
                        tmp.defaultView || tmp.parentWindow || window
                    );
                }
            }

            // Fire handlers on the event path
            i = 0;
            while ((cur = eventPath[i++]) && !event.isPropagationStopped()) {
                lastElement = cur;
                event.type = i > 1 ? bubbleType : special.bindType || type;

                // jQuery handler
                handle =
                    (dataPriv.get(cur, "events") || Object.create(null))[
                        event.type
                    ] && dataPriv.get(cur, "handle");
                if (handle) {
                    handle.apply(cur, data);
                }

                // Native handler
                handle = ontype && cur[ontype];
                if (handle && handle.apply && acceptData(cur)) {
                    event.result = handle.apply(cur, data);
                    if (event.result === false) {
                        event.preventDefault();
                    }
                }
            }
            event.type = type;

            // If nobody prevented the default action, do it now
            if (!onlyHandlers && !event.isDefaultPrevented()) {
                if (
                    (!special._default ||
                        special._default.apply(eventPath.pop(), data) ===
                            false) &&
                    acceptData(elem)
                ) {
                    // Call a native DOM method on the target with the same name as the event.
                    // Don't do default actions on window, that's where global variables be (#6170)
                    if (ontype && isFunction(elem[type]) && !isWindow(elem)) {
                        // Don't re-trigger an onFOO event when we call its FOO() method
                        tmp = elem[ontype];

                        if (tmp) {
                            elem[ontype] = null;
                        }

                        // Prevent re-triggering of the same event, since we already bubbled it above
                        jQuery.event.triggered = type;

                        if (event.isPropagationStopped()) {
                            lastElement.addEventListener(
                                type,
                                stopPropagationCallback
                            );
                        }

                        elem[type]();

                        if (event.isPropagationStopped()) {
                            lastElement.removeEventListener(
                                type,
                                stopPropagationCallback
                            );
                        }

                        jQuery.event.triggered = undefined;

                        if (tmp) {
                            elem[ontype] = tmp;
                        }
                    }
                }
            }

            return event.result;
        },

        // Piggyback on a donor event to simulate a different one
        // Used only for `focus(in | out)` events
        simulate: function (type, elem, event) {
            var e = jQuery.extend(new jQuery.Event(), event, {
                type: type,
                isSimulated: true,
            });

            jQuery.event.trigger(e, null, elem);
        },
    });

    jQuery.fn.extend({
        trigger: function (type, data) {
            return this.each(function () {
                jQuery.event.trigger(type, data, this);
            });
        },
        triggerHandler: function (type, data) {
            var elem = this[0];
            if (elem) {
                return jQuery.event.trigger(type, data, elem, true);
            }
        },
    });

    // Support: Firefox <=44
    // Firefox doesn't have focus(in | out) events
    // Related ticket - https://bugzilla.mozilla.org/show_bug.cgi?id=687787
    //
    // Support: Chrome <=48 - 49, Safari <=9.0 - 9.1
    // focus(in | out) events fire after focus & blur events,
    // which is spec violation - http://www.w3.org/TR/DOM-Level-3-Events/#events-focusevent-event-order
    // Related ticket - https://bugs.chromium.org/p/chromium/issues/detail?id=449857
    if (!support.focusin) {
        jQuery.each(
            { focus: "focusin", blur: "focusout" },
            function (orig, fix) {
                // Attach a single capturing handler on the document while someone wants focusin/focusout
                var handler = function (event) {
                    jQuery.event.simulate(
                        fix,
                        event.target,
                        jQuery.event.fix(event)
                    );
                };

                jQuery.event.special[fix] = {
                    setup: function () {
                        // Handle: regular nodes (via `this.ownerDocument`), window
                        // (via `this.document`) & document (via `this`).
                        var doc = this.ownerDocument || this.document || this,
                            attaches = dataPriv.access(doc, fix);

                        if (!attaches) {
                            doc.addEventListener(orig, handler, true);
                        }
                        dataPriv.access(doc, fix, (attaches || 0) + 1);
                    },
                    teardown: function () {
                        var doc = this.ownerDocument || this.document || this,
                            attaches = dataPriv.access(doc, fix) - 1;

                        if (!attaches) {
                            doc.removeEventListener(orig, handler, true);
                            dataPriv.remove(doc, fix);
                        } else {
                            dataPriv.access(doc, fix, attaches);
                        }
                    },
                };
            }
        );
    }
    var location = window.location;

    var nonce = { guid: Date.now() };

    var rquery = /\?/;

    // Cross-browser xml parsing
    jQuery.parseXML = function (data) {
        var xml, parserErrorElem;
        if (!data || typeof data !== "string") {
            return null;
        }

        // Support: IE 9 - 11 only
        // IE throws on parseFromString with invalid input.
        try {
            xml = new window.DOMParser().parseFromString(data, "text/xml");
        } catch (e) {}

        parserErrorElem = xml && xml.getElementsByTagName("parsererror")[0];
        if (!xml || parserErrorElem) {
            jQuery.error(
                "Invalid XML: " +
                    (parserErrorElem
                        ? jQuery
                              .map(parserErrorElem.childNodes, function (el) {
                                  return el.textContent;
                              })
                              .join("\n")
                        : data)
            );
        }
        return xml;
    };

    var rbracket = /\[\]$/,
        rCRLF = /\r?\n/g,
        rsubmitterTypes = /^(?:submit|button|image|reset|file)$/i,
        rsubmittable = /^(?:input|select|textarea|keygen)/i;

    function buildParams(prefix, obj, traditional, add) {
        var name;

        if (Array.isArray(obj)) {
            // Serialize array item.
            jQuery.each(obj, function (i, v) {
                if (traditional || rbracket.test(prefix)) {
                    // Treat each array item as a scalar.
                    add(prefix, v);
                } else {
                    // Item is non-scalar (array or object), encode its numeric index.
                    buildParams(
                        prefix +
                            "[" +
                            (typeof v === "object" && v != null ? i : "") +
                            "]",
                        v,
                        traditional,
                        add
                    );
                }
            });
        } else if (!traditional && toType(obj) === "object") {
            // Serialize object item.
            for (name in obj) {
                buildParams(
                    prefix + "[" + name + "]",
                    obj[name],
                    traditional,
                    add
                );
            }
        } else {
            // Serialize scalar item.
            add(prefix, obj);
        }
    }

    // Serialize an array of form elements or a set of
    // key/values into a query string
    jQuery.param = function (a, traditional) {
        var prefix,
            s = [],
            add = function (key, valueOrFunction) {
                // If value is a function, invoke it and use its return value
                var value = isFunction(valueOrFunction)
                    ? valueOrFunction()
                    : valueOrFunction;

                s[s.length] =
                    encodeURIComponent(key) +
                    "=" +
                    encodeURIComponent(value == null ? "" : value);
            };

        if (a == null) {
            return "";
        }

        // If an array was passed in, assume that it is an array of form elements.
        if (Array.isArray(a) || (a.jquery && !jQuery.isPlainObject(a))) {
            // Serialize the form elements
            jQuery.each(a, function () {
                add(this.name, this.value);
            });
        } else {
            // If traditional, encode the "old" way (the way 1.3.2 or older
            // did it), otherwise encode params recursively.
            for (prefix in a) {
                buildParams(prefix, a[prefix], traditional, add);
            }
        }

        // Return the resulting serialization
        return s.join("&");
    };

    jQuery.fn.extend({
        serialize: function () {
            return jQuery.param(this.serializeArray());
        },
        serializeArray: function () {
            return this.map(function () {
                // Can add propHook for "elements" to filter or add form elements
                var elements = jQuery.prop(this, "elements");
                return elements ? jQuery.makeArray(elements) : this;
            })
                .filter(function () {
                    var type = this.type;

                    // Use .is( ":disabled" ) so that fieldset[disabled] works
                    return (
                        this.name &&
                        !jQuery(this).is(":disabled") &&
                        rsubmittable.test(this.nodeName) &&
                        !rsubmitterTypes.test(type) &&
                        (this.checked || !rcheckableType.test(type))
                    );
                })
                .map(function (_i, elem) {
                    var val = jQuery(this).val();

                    if (val == null) {
                        return null;
                    }

                    if (Array.isArray(val)) {
                        return jQuery.map(val, function (val) {
                            return {
                                name: elem.name,
                                value: val.replace(rCRLF, "\r\n"),
                            };
                        });
                    }

                    return {
                        name: elem.name,
                        value: val.replace(rCRLF, "\r\n"),
                    };
                })
                .get();
        },
    });

    var r20 = /%20/g,
        rhash = /#.*$/,
        rantiCache = /([?&])_=[^&]*/,
        rheaders = /^(.*?):[ \t]*([^\r\n]*)$/gm,
        // #7653, #8125, #8152: local protocol detection
        rlocalProtocol =
            /^(?:about|app|app-storage|.+-extension|file|res|widget):$/,
        rnoContent = /^(?:GET|HEAD)$/,
        rprotocol = /^\/\//,
        /* Prefilters
         * 1) They are useful to introduce custom dataTypes (see ajax/jsonp.js for an example)
         * 2) These are called:
         *    - BEFORE asking for a transport
         *    - AFTER param serialization (s.data is a string if s.processData is true)
         * 3) key is the dataType
         * 4) the catchall symbol "*" can be used
         * 5) execution will start with transport dataType and THEN continue down to "*" if needed
         */
        prefilters = {},
        /* Transports bindings
         * 1) key is the dataType
         * 2) the catchall symbol "*" can be used
         * 3) selection will start with transport dataType and THEN go to "*" if needed
         */
        transports = {},
        // Avoid comment-prolog char sequence (#10098); must appease lint and evade compression
        allTypes = "*/".concat("*"),
        // Anchor tag for parsing the document origin
        originAnchor = document.createElement("a");

    originAnchor.href = location.href;

    // Base "constructor" for jQuery.ajaxPrefilter and jQuery.ajaxTransport
    function addToPrefiltersOrTransports(structure) {
        // dataTypeExpression is optional and defaults to "*"
        return function (dataTypeExpression, func) {
            if (typeof dataTypeExpression !== "string") {
                func = dataTypeExpression;
                dataTypeExpression = "*";
            }

            var dataType,
                i = 0,
                dataTypes =
                    dataTypeExpression.toLowerCase().match(rnothtmlwhite) || [];

            if (isFunction(func)) {
                // For each dataType in the dataTypeExpression
                while ((dataType = dataTypes[i++])) {
                    // Prepend if requested
                    if (dataType[0] === "+") {
                        dataType = dataType.slice(1) || "*";
                        (structure[dataType] =
                            structure[dataType] || []).unshift(func);

                        // Otherwise append
                    } else {
                        (structure[dataType] = structure[dataType] || []).push(
                            func
                        );
                    }
                }
            }
        };
    }

    // Base inspection function for prefilters and transports
    function inspectPrefiltersOrTransports(
        structure,
        options,
        originalOptions,
        jqXHR
    ) {
        var inspected = {},
            seekingTransport = structure === transports;

        function inspect(dataType) {
            var selected;
            inspected[dataType] = true;
            jQuery.each(
                structure[dataType] || [],
                function (_, prefilterOrFactory) {
                    var dataTypeOrTransport = prefilterOrFactory(
                        options,
                        originalOptions,
                        jqXHR
                    );
                    if (
                        typeof dataTypeOrTransport === "string" &&
                        !seekingTransport &&
                        !inspected[dataTypeOrTransport]
                    ) {
                        options.dataTypes.unshift(dataTypeOrTransport);
                        inspect(dataTypeOrTransport);
                        return false;
                    } else if (seekingTransport) {
                        return !(selected = dataTypeOrTransport);
                    }
                }
            );
            return selected;
        }

        return (
            inspect(options.dataTypes[0]) || (!inspected["*"] && inspect("*"))
        );
    }

    // A special extend for ajax options
    // that takes "flat" options (not to be deep extended)
    // Fixes #9887
    function ajaxExtend(target, src) {
        var key,
            deep,
            flatOptions = jQuery.ajaxSettings.flatOptions || {};

        for (key in src) {
            if (src[key] !== undefined) {
                (flatOptions[key] ? target : deep || (deep = {}))[key] =
                    src[key];
            }
        }
        if (deep) {
            jQuery.extend(true, target, deep);
        }

        return target;
    }

    /* Handles responses to an ajax request:
     * - finds the right dataType (mediates between content-type and expected dataType)
     * - returns the corresponding response
     */
    function ajaxHandleResponses(s, jqXHR, responses) {
        var ct,
            type,
            finalDataType,
            firstDataType,
            contents = s.contents,
            dataTypes = s.dataTypes;

        // Remove auto dataType and get content-type in the process
        while (dataTypes[0] === "*") {
            dataTypes.shift();
            if (ct === undefined) {
                ct = s.mimeType || jqXHR.getResponseHeader("Content-Type");
            }
        }

        // Check if we're dealing with a known content-type
        if (ct) {
            for (type in contents) {
                if (contents[type] && contents[type].test(ct)) {
                    dataTypes.unshift(type);
                    break;
                }
            }
        }

        // Check to see if we have a response for the expected dataType
        if (dataTypes[0] in responses) {
            finalDataType = dataTypes[0];
        } else {
            // Try convertible dataTypes
            for (type in responses) {
                if (!dataTypes[0] || s.converters[type + " " + dataTypes[0]]) {
                    finalDataType = type;
                    break;
                }
                if (!firstDataType) {
                    firstDataType = type;
                }
            }

            // Or just use first one
            finalDataType = finalDataType || firstDataType;
        }

        // If we found a dataType
        // We add the dataType to the list if needed
        // and return the corresponding response
        if (finalDataType) {
            if (finalDataType !== dataTypes[0]) {
                dataTypes.unshift(finalDataType);
            }
            return responses[finalDataType];
        }
    }

    /* Chain conversions given the request and the original response
     * Also sets the responseXXX fields on the jqXHR instance
     */
    function ajaxConvert(s, response, jqXHR, isSuccess) {
        var conv2,
            current,
            conv,
            tmp,
            prev,
            converters = {},
            // Work with a copy of dataTypes in case we need to modify it for conversion
            dataTypes = s.dataTypes.slice();

        // Create converters map with lowercased keys
        if (dataTypes[1]) {
            for (conv in s.converters) {
                converters[conv.toLowerCase()] = s.converters[conv];
            }
        }

        current = dataTypes.shift();

        // Convert to each sequential dataType
        while (current) {
            if (s.responseFields[current]) {
                jqXHR[s.responseFields[current]] = response;
            }

            // Apply the dataFilter if provided
            if (!prev && isSuccess && s.dataFilter) {
                response = s.dataFilter(response, s.dataType);
            }

            prev = current;
            current = dataTypes.shift();

            if (current) {
                // There's only work to do if current dataType is non-auto
                if (current === "*") {
                    current = prev;

                    // Convert response if prev dataType is non-auto and differs from current
                } else if (prev !== "*" && prev !== current) {
                    // Seek a direct converter
                    conv =
                        converters[prev + " " + current] ||
                        converters["* " + current];

                    // If none found, seek a pair
                    if (!conv) {
                        for (conv2 in converters) {
                            // If conv2 outputs current
                            tmp = conv2.split(" ");
                            if (tmp[1] === current) {
                                // If prev can be converted to accepted input
                                conv =
                                    converters[prev + " " + tmp[0]] ||
                                    converters["* " + tmp[0]];
                                if (conv) {
                                    // Condense equivalence converters
                                    if (conv === true) {
                                        conv = converters[conv2];

                                        // Otherwise, insert the intermediate dataType
                                    } else if (converters[conv2] !== true) {
                                        current = tmp[0];
                                        dataTypes.unshift(tmp[1]);
                                    }
                                    break;
                                }
                            }
                        }
                    }

                    // Apply converter (if not an equivalence)
                    if (conv !== true) {
                        // Unless errors are allowed to bubble, catch and return them
                        if (conv && s.throws) {
                            response = conv(response);
                        } else {
                            try {
                                response = conv(response);
                            } catch (e) {
                                return {
                                    state: "parsererror",
                                    error: conv
                                        ? e
                                        : "No conversion from " +
                                          prev +
                                          " to " +
                                          current,
                                };
                            }
                        }
                    }
                }
            }
        }

        return { state: "success", data: response };
    }

    jQuery.extend({
        // Counter for holding the number of active queries
        active: 0,

        // Last-Modified header cache for next request
        lastModified: {},
        etag: {},

        ajaxSettings: {
            url: location.href,
            type: "GET",
            isLocal: rlocalProtocol.test(location.protocol),
            global: true,
            processData: true,
            async: true,
            contentType: "application/x-www-form-urlencoded; charset=UTF-8",

            /*
		timeout: 0,
		data: null,
		dataType: null,
		username: null,
		password: null,
		cache: null,
		throws: false,
		traditional: false,
		headers: {},
		*/

            accepts: {
                "*": allTypes,
                text: "text/plain",
                html: "text/html",
                xml: "application/xml, text/xml",
                json: "application/json, text/javascript",
            },

            contents: {
                xml: /\bxml\b/,
                html: /\bhtml/,
                json: /\bjson\b/,
            },

            responseFields: {
                xml: "responseXML",
                text: "responseText",
                json: "responseJSON",
            },

            // Data converters
            // Keys separate source (or catchall "*") and destination types with a single space
            converters: {
                // Convert anything to text
                "* text": String,

                // Text to html (true = no transformation)
                "text html": true,

                // Evaluate text as a json expression
                "text json": JSON.parse,

                // Parse text as xml
                "text xml": jQuery.parseXML,
            },

            // For options that shouldn't be deep extended:
            // you can add your own custom options here if
            // and when you create one that shouldn't be
            // deep extended (see ajaxExtend)
            flatOptions: {
                url: true,
                context: true,
            },
        },

        // Creates a full fledged settings object into target
        // with both ajaxSettings and settings fields.
        // If target is omitted, writes into ajaxSettings.
        ajaxSetup: function (target, settings) {
            return settings
                ? // Building a settings object
                  ajaxExtend(ajaxExtend(target, jQuery.ajaxSettings), settings)
                : // Extending ajaxSettings
                  ajaxExtend(jQuery.ajaxSettings, target);
        },

        ajaxPrefilter: addToPrefiltersOrTransports(prefilters),
        ajaxTransport: addToPrefiltersOrTransports(transports),

        // Main method
        ajax: function (url, options) {
            // If url is an object, simulate pre-1.5 signature
            if (typeof url === "object") {
                options = url;
                url = undefined;
            }

            // Force options to be an object
            options = options || {};

            var transport,
                // URL without anti-cache param
                cacheURL,
                // Response headers
                responseHeadersString,
                responseHeaders,
                // timeout handle
                timeoutTimer,
                // Url cleanup var
                urlAnchor,
                // Request state (becomes false upon send and true upon completion)
                completed,
                // To know if global events are to be dispatched
                fireGlobals,
                // Loop variable
                i,
                // uncached part of the url
                uncached,
                // Create the final options object
                s = jQuery.ajaxSetup({}, options),
                // Callbacks context
                callbackContext = s.context || s,
                // Context for global events is callbackContext if it is a DOM node or jQuery collection
                globalEventContext =
                    s.context &&
                    (callbackContext.nodeType || callbackContext.jquery)
                        ? jQuery(callbackContext)
                        : jQuery.event,
                // Deferreds
                deferred = jQuery.Deferred(),
                completeDeferred = jQuery.Callbacks("once memory"),
                // Status-dependent callbacks
                statusCode = s.statusCode || {},
                // Headers (they are sent all at once)
                requestHeaders = {},
                requestHeadersNames = {},
                // Default abort message
                strAbort = "canceled",
                // Fake xhr
                jqXHR = {
                    readyState: 0,

                    // Builds headers hashtable if needed
                    getResponseHeader: function (key) {
                        var match;
                        if (completed) {
                            if (!responseHeaders) {
                                responseHeaders = {};
                                while (
                                    (match = rheaders.exec(
                                        responseHeadersString
                                    ))
                                ) {
                                    responseHeaders[
                                        match[1].toLowerCase() + " "
                                    ] = (
                                        responseHeaders[
                                            match[1].toLowerCase() + " "
                                        ] || []
                                    ).concat(match[2]);
                                }
                            }
                            match = responseHeaders[key.toLowerCase() + " "];
                        }
                        return match == null ? null : match.join(", ");
                    },

                    // Raw string
                    getAllResponseHeaders: function () {
                        return completed ? responseHeadersString : null;
                    },

                    // Caches the header
                    setRequestHeader: function (name, value) {
                        if (completed == null) {
                            name = requestHeadersNames[name.toLowerCase()] =
                                requestHeadersNames[name.toLowerCase()] || name;
                            requestHeaders[name] = value;
                        }
                        return this;
                    },

                    // Overrides response content-type header
                    overrideMimeType: function (type) {
                        if (completed == null) {
                            s.mimeType = type;
                        }
                        return this;
                    },

                    // Status-dependent callbacks
                    statusCode: function (map) {
                        var code;
                        if (map) {
                            if (completed) {
                                // Execute the appropriate callbacks
                                jqXHR.always(map[jqXHR.status]);
                            } else {
                                // Lazy-add the new callbacks in a way that preserves old ones
                                for (code in map) {
                                    statusCode[code] = [
                                        statusCode[code],
                                        map[code],
                                    ];
                                }
                            }
                        }
                        return this;
                    },

                    // Cancel the request
                    abort: function (statusText) {
                        var finalText = statusText || strAbort;
                        if (transport) {
                            transport.abort(finalText);
                        }
                        done(0, finalText);
                        return this;
                    },
                };

            // Attach deferreds
            deferred.promise(jqXHR);

            // Add protocol if not provided (prefilters might expect it)
            // Handle falsy url in the settings object (#10093: consistency with old signature)
            // We also use the url parameter if available
            s.url = ((url || s.url || location.href) + "").replace(
                rprotocol,
                location.protocol + "//"
            );

            // Alias method option to type as per ticket #12004
            s.type = options.method || options.type || s.method || s.type;

            // Extract dataTypes list
            s.dataTypes = (s.dataType || "*")
                .toLowerCase()
                .match(rnothtmlwhite) || [""];

            // A cross-domain request is in order when the origin doesn't match the current origin.
            if (s.crossDomain == null) {
                urlAnchor = document.createElement("a");

                // Support: IE <=8 - 11, Edge 12 - 15
                // IE throws exception on accessing the href property if url is malformed,
                // e.g. http://example.com:80x/
                try {
                    urlAnchor.href = s.url;

                    // Support: IE <=8 - 11 only
                    // Anchor's host property isn't correctly set when s.url is relative
                    urlAnchor.href = urlAnchor.href;
                    s.crossDomain =
                        originAnchor.protocol + "//" + originAnchor.host !==
                        urlAnchor.protocol + "//" + urlAnchor.host;
                } catch (e) {
                    // If there is an error parsing the URL, assume it is crossDomain,
                    // it can be rejected by the transport if it is invalid
                    s.crossDomain = true;
                }
            }

            // Convert data if not already a string
            if (s.data && s.processData && typeof s.data !== "string") {
                s.data = jQuery.param(s.data, s.traditional);
            }

            // Apply prefilters
            inspectPrefiltersOrTransports(prefilters, s, options, jqXHR);

            // If request was aborted inside a prefilter, stop there
            if (completed) {
                return jqXHR;
            }

            // We can fire global events as of now if asked to
            // Don't fire events if jQuery.event is undefined in an AMD-usage scenario (#15118)
            fireGlobals = jQuery.event && s.global;

            // Watch for a new set of requests
            if (fireGlobals && jQuery.active++ === 0) {
                jQuery.event.trigger("ajaxStart");
            }

            // Uppercase the type
            s.type = s.type.toUpperCase();

            // Determine if request has content
            s.hasContent = !rnoContent.test(s.type);

            // Save the URL in case we're toying with the If-Modified-Since
            // and/or If-None-Match header later on
            // Remove hash to simplify url manipulation
            cacheURL = s.url.replace(rhash, "");

            // More options handling for requests with no content
            if (!s.hasContent) {
                // Remember the hash so we can put it back
                uncached = s.url.slice(cacheURL.length);

                // If data is available and should be processed, append data to url
                if (s.data && (s.processData || typeof s.data === "string")) {
                    cacheURL += (rquery.test(cacheURL) ? "&" : "?") + s.data;

                    // #9682: remove data so that it's not used in an eventual retry
                    delete s.data;
                }

                // Add or update anti-cache param if needed
                if (s.cache === false) {
                    cacheURL = cacheURL.replace(rantiCache, "$1");
                    uncached =
                        (rquery.test(cacheURL) ? "&" : "?") +
                        "_=" +
                        nonce.guid++ +
                        uncached;
                }

                // Put hash and anti-cache on the URL that will be requested (gh-1732)
                s.url = cacheURL + uncached;

                // Change '%20' to '+' if this is encoded form body content (gh-2658)
            } else if (
                s.data &&
                s.processData &&
                (s.contentType || "").indexOf(
                    "application/x-www-form-urlencoded"
                ) === 0
            ) {
                s.data = s.data.replace(r20, "+");
            }

            // Set the If-Modified-Since and/or If-None-Match header, if in ifModified mode.
            if (s.ifModified) {
                if (jQuery.lastModified[cacheURL]) {
                    jqXHR.setRequestHeader(
                        "If-Modified-Since",
                        jQuery.lastModified[cacheURL]
                    );
                }
                if (jQuery.etag[cacheURL]) {
                    jqXHR.setRequestHeader(
                        "If-None-Match",
                        jQuery.etag[cacheURL]
                    );
                }
            }

            // Set the correct header, if data is being sent
            if (
                (s.data && s.hasContent && s.contentType !== false) ||
                options.contentType
            ) {
                jqXHR.setRequestHeader("Content-Type", s.contentType);
            }

            // Set the Accepts header for the server, depending on the dataType
            jqXHR.setRequestHeader(
                "Accept",
                s.dataTypes[0] && s.accepts[s.dataTypes[0]]
                    ? s.accepts[s.dataTypes[0]] +
                          (s.dataTypes[0] !== "*"
                              ? ", " + allTypes + "; q=0.01"
                              : "")
                    : s.accepts["*"]
            );

            // Check for headers option
            for (i in s.headers) {
                jqXHR.setRequestHeader(i, s.headers[i]);
            }

            // Allow custom headers/mimetypes and early abort
            if (
                s.beforeSend &&
                (s.beforeSend.call(callbackContext, jqXHR, s) === false ||
                    completed)
            ) {
                // Abort if not done already and return
                return jqXHR.abort();
            }

            // Aborting is no longer a cancellation
            strAbort = "abort";

            // Install callbacks on deferreds
            completeDeferred.add(s.complete);
            jqXHR.done(s.success);
            jqXHR.fail(s.error);

            // Get transport
            transport = inspectPrefiltersOrTransports(
                transports,
                s,
                options,
                jqXHR
            );

            // If no transport, we auto-abort
            if (!transport) {
                done(-1, "No Transport");
            } else {
                jqXHR.readyState = 1;

                // Send global event
                if (fireGlobals) {
                    globalEventContext.trigger("ajaxSend", [jqXHR, s]);
                }

                // If request was aborted inside ajaxSend, stop there
                if (completed) {
                    return jqXHR;
                }

                // Timeout
                if (s.async && s.timeout > 0) {
                    timeoutTimer = window.setTimeout(function () {
                        jqXHR.abort("timeout");
                    }, s.timeout);
                }

                try {
                    completed = false;
                    transport.send(requestHeaders, done);
                } catch (e) {
                    // Rethrow post-completion exceptions
                    if (completed) {
                        throw e;
                    }

                    // Propagate others as results
                    done(-1, e);
                }
            }

            // Callback for when everything is done
            function done(status, nativeStatusText, responses, headers) {
                var isSuccess,
                    success,
                    error,
                    response,
                    modified,
                    statusText = nativeStatusText;

                // Ignore repeat invocations
                if (completed) {
                    return;
                }

                completed = true;

                // Clear timeout if it exists
                if (timeoutTimer) {
                    window.clearTimeout(timeoutTimer);
                }

                // Dereference transport for early garbage collection
                // (no matter how long the jqXHR object will be used)
                transport = undefined;

                // Cache response headers
                responseHeadersString = headers || "";

                // Set readyState
                jqXHR.readyState = status > 0 ? 4 : 0;

                // Determine if successful
                isSuccess = (status >= 200 && status < 300) || status === 304;

                // Get response data
                if (responses) {
                    response = ajaxHandleResponses(s, jqXHR, responses);
                }

                // Use a noop converter for missing script but not if jsonp
                if (
                    !isSuccess &&
                    jQuery.inArray("script", s.dataTypes) > -1 &&
                    jQuery.inArray("json", s.dataTypes) < 0
                ) {
                    s.converters["text script"] = function () {};
                }

                // Convert no matter what (that way responseXXX fields are always set)
                response = ajaxConvert(s, response, jqXHR, isSuccess);

                // If successful, handle type chaining
                if (isSuccess) {
                    // Set the If-Modified-Since and/or If-None-Match header, if in ifModified mode.
                    if (s.ifModified) {
                        modified = jqXHR.getResponseHeader("Last-Modified");
                        if (modified) {
                            jQuery.lastModified[cacheURL] = modified;
                        }
                        modified = jqXHR.getResponseHeader("etag");
                        if (modified) {
                            jQuery.etag[cacheURL] = modified;
                        }
                    }

                    // if no content
                    if (status === 204 || s.type === "HEAD") {
                        statusText = "nocontent";

                        // if not modified
                    } else if (status === 304) {
                        statusText = "notmodified";

                        // If we have data, let's convert it
                    } else {
                        statusText = response.state;
                        success = response.data;
                        error = response.error;
                        isSuccess = !error;
                    }
                } else {
                    // Extract error from statusText and normalize for non-aborts
                    error = statusText;
                    if (status || !statusText) {
                        statusText = "error";
                        if (status < 0) {
                            status = 0;
                        }
                    }
                }

                // Set data for the fake xhr object
                jqXHR.status = status;
                jqXHR.statusText = (nativeStatusText || statusText) + "";

                // Success/Error
                if (isSuccess) {
                    deferred.resolveWith(callbackContext, [
                        success,
                        statusText,
                        jqXHR,
                    ]);
                } else {
                    deferred.rejectWith(callbackContext, [
                        jqXHR,
                        statusText,
                        error,
                    ]);
                }

                // Status-dependent callbacks
                jqXHR.statusCode(statusCode);
                statusCode = undefined;

                if (fireGlobals) {
                    globalEventContext.trigger(
                        isSuccess ? "ajaxSuccess" : "ajaxError",
                        [jqXHR, s, isSuccess ? success : error]
                    );
                }

                // Complete
                completeDeferred.fireWith(callbackContext, [jqXHR, statusText]);

                if (fireGlobals) {
                    globalEventContext.trigger("ajaxComplete", [jqXHR, s]);

                    // Handle the global AJAX counter
                    if (!--jQuery.active) {
                        jQuery.event.trigger("ajaxStop");
                    }
                }
            }

            return jqXHR;
        },

        getJSON: function (url, data, callback) {
            return jQuery.get(url, data, callback, "json");
        },

        getScript: function (url, callback) {
            return jQuery.get(url, undefined, callback, "script");
        },
    });

    jQuery.each(["get", "post"], function (_i, method) {
        jQuery[method] = function (url, data, callback, type) {
            // Shift arguments if data argument was omitted
            if (isFunction(data)) {
                type = type || callback;
                callback = data;
                data = undefined;
            }

            // The url can be an options object (which then must have .url)
            return jQuery.ajax(
                jQuery.extend(
                    {
                        url: url,
                        type: method,
                        dataType: type,
                        data: data,
                        success: callback,
                    },
                    jQuery.isPlainObject(url) && url
                )
            );
        };
    });

    jQuery.ajaxPrefilter(function (s) {
        var i;
        for (i in s.headers) {
            if (i.toLowerCase() === "content-type") {
                s.contentType = s.headers[i] || "";
            }
        }
    });

    jQuery._evalUrl = function (url, options, doc) {
        return jQuery.ajax({
            url: url,

            // Make this explicit, since user can override this through ajaxSetup (#11264)
            type: "GET",
            dataType: "script",
            cache: true,
            async: false,
            global: false,

            // Only evaluate the response if it is successful (gh-4126)
            // dataFilter is not invoked for failure responses, so using it instead
            // of the default converter is kludgy but it works.
            converters: {
                "text script": function () {},
            },
            dataFilter: function (response) {
                jQuery.globalEval(response, options, doc);
            },
        });
    };

    jQuery.fn.extend({
        wrapAll: function (html) {
            var wrap;

            if (this[0]) {
                if (isFunction(html)) {
                    html = html.call(this[0]);
                }

                // The elements to wrap the target around
                wrap = jQuery(html, this[0].ownerDocument).eq(0).clone(true);

                if (this[0].parentNode) {
                    wrap.insertBefore(this[0]);
                }

                wrap.map(function () {
                    var elem = this;

                    while (elem.firstElementChild) {
                        elem = elem.firstElementChild;
                    }

                    return elem;
                }).append(this);
            }

            return this;
        },

        wrapInner: function (html) {
            if (isFunction(html)) {
                return this.each(function (i) {
                    jQuery(this).wrapInner(html.call(this, i));
                });
            }

            return this.each(function () {
                var self = jQuery(this),
                    contents = self.contents();

                if (contents.length) {
                    contents.wrapAll(html);
                } else {
                    self.append(html);
                }
            });
        },

        wrap: function (html) {
            var htmlIsFunction = isFunction(html);

            return this.each(function (i) {
                jQuery(this).wrapAll(
                    htmlIsFunction ? html.call(this, i) : html
                );
            });
        },

        unwrap: function (selector) {
            this.parent(selector)
                .not("body")
                .each(function () {
                    jQuery(this).replaceWith(this.childNodes);
                });
            return this;
        },
    });

    jQuery.expr.pseudos.hidden = function (elem) {
        return !jQuery.expr.pseudos.visible(elem);
    };
    jQuery.expr.pseudos.visible = function (elem) {
        return !!(
            elem.offsetWidth ||
            elem.offsetHeight ||
            elem.getClientRects().length
        );
    };

    jQuery.ajaxSettings.xhr = function () {
        try {
            return new window.XMLHttpRequest();
        } catch (e) {}
    };

    var xhrSuccessStatus = {
            // File protocol always yields status code 0, assume 200
            0: 200,

            // Support: IE <=9 only
            // #1450: sometimes IE returns 1223 when it should be 204
            1223: 204,
        },
        xhrSupported = jQuery.ajaxSettings.xhr();

    support.cors = !!xhrSupported && "withCredentials" in xhrSupported;
    support.ajax = xhrSupported = !!xhrSupported;

    jQuery.ajaxTransport(function (options) {
        var callback, errorCallback;

        // Cross domain only allowed if supported through XMLHttpRequest
        if (support.cors || (xhrSupported && !options.crossDomain)) {
            return {
                send: function (headers, complete) {
                    var i,
                        xhr = options.xhr();

                    xhr.open(
                        options.type,
                        options.url,
                        options.async,
                        options.username,
                        options.password
                    );

                    // Apply custom fields if provided
                    if (options.xhrFields) {
                        for (i in options.xhrFields) {
                            xhr[i] = options.xhrFields[i];
                        }
                    }

                    // Override mime type if needed
                    if (options.mimeType && xhr.overrideMimeType) {
                        xhr.overrideMimeType(options.mimeType);
                    }

                    // X-Requested-With header
                    // For cross-domain requests, seeing as conditions for a preflight are
                    // akin to a jigsaw puzzle, we simply never set it to be sure.
                    // (it can always be set on a per-request basis or even using ajaxSetup)
                    // For same-domain requests, won't change header if already provided.
                    if (!options.crossDomain && !headers["X-Requested-With"]) {
                        headers["X-Requested-With"] = "XMLHttpRequest";
                    }

                    // Set headers
                    for (i in headers) {
                        xhr.setRequestHeader(i, headers[i]);
                    }

                    // Callback
                    callback = function (type) {
                        return function () {
                            if (callback) {
                                callback =
                                    errorCallback =
                                    xhr.onload =
                                    xhr.onerror =
                                    xhr.onabort =
                                    xhr.ontimeout =
                                    xhr.onreadystatechange =
                                        null;

                                if (type === "abort") {
                                    xhr.abort();
                                } else if (type === "error") {
                                    // Support: IE <=9 only
                                    // On a manual native abort, IE9 throws
                                    // errors on any property access that is not readyState
                                    if (typeof xhr.status !== "number") {
                                        complete(0, "error");
                                    } else {
                                        complete(
                                            // File: protocol always yields status 0; see #8605, #14207
                                            xhr.status,
                                            xhr.statusText
                                        );
                                    }
                                } else {
                                    complete(
                                        xhrSuccessStatus[xhr.status] ||
                                            xhr.status,
                                        xhr.statusText,

                                        // Support: IE <=9 only
                                        // IE9 has no XHR2 but throws on binary (trac-11426)
                                        // For XHR2 non-text, let the caller handle it (gh-2498)
                                        (xhr.responseType || "text") !==
                                            "text" ||
                                            typeof xhr.responseText !== "string"
                                            ? { binary: xhr.response }
                                            : { text: xhr.responseText },
                                        xhr.getAllResponseHeaders()
                                    );
                                }
                            }
                        };
                    };

                    // Listen to events
                    xhr.onload = callback();
                    errorCallback =
                        xhr.onerror =
                        xhr.ontimeout =
                            callback("error");

                    // Support: IE 9 only
                    // Use onreadystatechange to replace onabort
                    // to handle uncaught aborts
                    if (xhr.onabort !== undefined) {
                        xhr.onabort = errorCallback;
                    } else {
                        xhr.onreadystatechange = function () {
                            // Check readyState before timeout as it changes
                            if (xhr.readyState === 4) {
                                // Allow onerror to be called first,
                                // but that will not handle a native abort
                                // Also, save errorCallback to a variable
                                // as xhr.onerror cannot be accessed
                                window.setTimeout(function () {
                                    if (callback) {
                                        errorCallback();
                                    }
                                });
                            }
                        };
                    }

                    // Create the abort callback
                    callback = callback("abort");

                    try {
                        // Do send the request (this may raise an exception)
                        xhr.send((options.hasContent && options.data) || null);
                    } catch (e) {
                        // #14683: Only rethrow if this hasn't been notified as an error yet
                        if (callback) {
                            throw e;
                        }
                    }
                },

                abort: function () {
                    if (callback) {
                        callback();
                    }
                },
            };
        }
    });

    // Prevent auto-execution of scripts when no explicit dataType was provided (See gh-2432)
    jQuery.ajaxPrefilter(function (s) {
        if (s.crossDomain) {
            s.contents.script = false;
        }
    });

    // Install script dataType
    jQuery.ajaxSetup({
        accepts: {
            script:
                "text/javascript, application/javascript, " +
                "application/ecmascript, application/x-ecmascript",
        },
        contents: {
            script: /\b(?:java|ecma)script\b/,
        },
        converters: {
            "text script": function (text) {
                jQuery.globalEval(text);
                return text;
            },
        },
    });

    // Handle cache's special case and crossDomain
    jQuery.ajaxPrefilter("script", function (s) {
        if (s.cache === undefined) {
            s.cache = false;
        }
        if (s.crossDomain) {
            s.type = "GET";
        }
    });

    // Bind script tag hack transport
    jQuery.ajaxTransport("script", function (s) {
        // This transport only deals with cross domain or forced-by-attrs requests
        if (s.crossDomain || s.scriptAttrs) {
            var script, callback;
            return {
                send: function (_, complete) {
                    script = jQuery("<script>")
                        .attr(s.scriptAttrs || {})
                        .prop({ charset: s.scriptCharset, src: s.url })
                        .on(
                            "load error",
                            (callback = function (evt) {
                                script.remove();
                                callback = null;
                                if (evt) {
                                    complete(
                                        evt.type === "error" ? 404 : 200,
                                        evt.type
                                    );
                                }
                            })
                        );

                    // Use native DOM manipulation to avoid our domManip AJAX trickery
                    document.head.appendChild(script[0]);
                },
                abort: function () {
                    if (callback) {
                        callback();
                    }
                },
            };
        }
    });

    var oldCallbacks = [],
        rjsonp = /(=)\?(?=&|$)|\?\?/;

    // Default jsonp settings
    jQuery.ajaxSetup({
        jsonp: "callback",
        jsonpCallback: function () {
            var callback =
                oldCallbacks.pop() || jQuery.expando + "_" + nonce.guid++;
            this[callback] = true;
            return callback;
        },
    });

    // Detect, normalize options and install callbacks for jsonp requests
    jQuery.ajaxPrefilter("json jsonp", function (s, originalSettings, jqXHR) {
        var callbackName,
            overwritten,
            responseContainer,
            jsonProp =
                s.jsonp !== false &&
                (rjsonp.test(s.url)
                    ? "url"
                    : typeof s.data === "string" &&
                      (s.contentType || "").indexOf(
                          "application/x-www-form-urlencoded"
                      ) === 0 &&
                      rjsonp.test(s.data) &&
                      "data");

        // Handle iff the expected data type is "jsonp" or we have a parameter to set
        if (jsonProp || s.dataTypes[0] === "jsonp") {
            // Get callback name, remembering preexisting value associated with it
            callbackName = s.jsonpCallback = isFunction(s.jsonpCallback)
                ? s.jsonpCallback()
                : s.jsonpCallback;

            // Insert callback into url or form data
            if (jsonProp) {
                s[jsonProp] = s[jsonProp].replace(rjsonp, "$1" + callbackName);
            } else if (s.jsonp !== false) {
                s.url +=
                    (rquery.test(s.url) ? "&" : "?") +
                    s.jsonp +
                    "=" +
                    callbackName;
            }

            // Use data converter to retrieve json after script execution
            s.converters["script json"] = function () {
                if (!responseContainer) {
                    jQuery.error(callbackName + " was not called");
                }
                return responseContainer[0];
            };

            // Force json dataType
            s.dataTypes[0] = "json";

            // Install callback
            overwritten = window[callbackName];
            window[callbackName] = function () {
                responseContainer = arguments;
            };

            // Clean-up function (fires after converters)
            jqXHR.always(function () {
                // If previous value didn't exist - remove it
                if (overwritten === undefined) {
                    jQuery(window).removeProp(callbackName);

                    // Otherwise restore preexisting value
                } else {
                    window[callbackName] = overwritten;
                }

                // Save back as free
                if (s[callbackName]) {
                    // Make sure that re-using the options doesn't screw things around
                    s.jsonpCallback = originalSettings.jsonpCallback;

                    // Save the callback name for future use
                    oldCallbacks.push(callbackName);
                }

                // Call if it was a function and we have a response
                if (responseContainer && isFunction(overwritten)) {
                    overwritten(responseContainer[0]);
                }

                responseContainer = overwritten = undefined;
            });

            // Delegate to script
            return "script";
        }
    });

    // Support: Safari 8 only
    // In Safari 8 documents created via document.implementation.createHTMLDocument
    // collapse sibling forms: the second one becomes a child of the first one.
    // Because of that, this security measure has to be disabled in Safari 8.
    // https://bugs.webkit.org/show_bug.cgi?id=137337
    support.createHTMLDocument = (function () {
        var body = document.implementation.createHTMLDocument("").body;
        body.innerHTML = "<form></form><form></form>";
        return body.childNodes.length === 2;
    })();

    // Argument "data" should be string of html
    // context (optional): If specified, the fragment will be created in this context,
    // defaults to document
    // keepScripts (optional): If true, will include scripts passed in the html string
    jQuery.parseHTML = function (data, context, keepScripts) {
        if (typeof data !== "string") {
            return [];
        }
        if (typeof context === "boolean") {
            keepScripts = context;
            context = false;
        }

        var base, parsed, scripts;

        if (!context) {
            // Stop scripts or inline event handlers from being executed immediately
            // by using document.implementation
            if (support.createHTMLDocument) {
                context = document.implementation.createHTMLDocument("");

                // Set the base href for the created document
                // so any parsed elements with URLs
                // are based on the document's URL (gh-2965)
                base = context.createElement("base");
                base.href = document.location.href;
                context.head.appendChild(base);
            } else {
                context = document;
            }
        }

        parsed = rsingleTag.exec(data);
        scripts = !keepScripts && [];

        // Single tag
        if (parsed) {
            return [context.createElement(parsed[1])];
        }

        parsed = buildFragment([data], context, scripts);

        if (scripts && scripts.length) {
            jQuery(scripts).remove();
        }

        return jQuery.merge([], parsed.childNodes);
    };

    /**
     * Load a url into a page
     */
    jQuery.fn.load = function (url, params, callback) {
        var selector,
            type,
            response,
            self = this,
            off = url.indexOf(" ");

        if (off > -1) {
            selector = stripAndCollapse(url.slice(off));
            url = url.slice(0, off);
        }

        // If it's a function
        if (isFunction(params)) {
            // We assume that it's the callback
            callback = params;
            params = undefined;

            // Otherwise, build a param string
        } else if (params && typeof params === "object") {
            type = "POST";
        }

        // If we have elements to modify, make the request
        if (self.length > 0) {
            jQuery
                .ajax({
                    url: url,

                    // If "type" variable is undefined, then "GET" method will be used.
                    // Make value of this field explicit since
                    // user can override it through ajaxSetup method
                    type: type || "GET",
                    dataType: "html",
                    data: params,
                })
                .done(function (responseText) {
                    // Save response for use in complete callback
                    response = arguments;

                    self.html(
                        selector
                            ? // If a selector was specified, locate the right elements in a dummy div
                              // Exclude scripts to avoid IE 'Permission Denied' errors
                              jQuery("<div>")
                                  .append(jQuery.parseHTML(responseText))
                                  .find(selector)
                            : // Otherwise use the full result
                              responseText
                    );

                    // If the request succeeds, this function gets "data", "status", "jqXHR"
                    // but they are ignored because response was set above.
                    // If it fails, this function gets "jqXHR", "status", "error"
                })
                .always(
                    callback &&
                        function (jqXHR, status) {
                            self.each(function () {
                                callback.apply(
                                    this,
                                    response || [
                                        jqXHR.responseText,
                                        status,
                                        jqXHR,
                                    ]
                                );
                            });
                        }
                );
        }

        return this;
    };

    jQuery.expr.pseudos.animated = function (elem) {
        return jQuery.grep(jQuery.timers, function (fn) {
            return elem === fn.elem;
        }).length;
    };

    jQuery.offset = {
        setOffset: function (elem, options, i) {
            var curPosition,
                curLeft,
                curCSSTop,
                curTop,
                curOffset,
                curCSSLeft,
                calculatePosition,
                position = jQuery.css(elem, "position"),
                curElem = jQuery(elem),
                props = {};

            // Set position first, in-case top/left are set even on static elem
            if (position === "static") {
                elem.style.position = "relative";
            }

            curOffset = curElem.offset();
            curCSSTop = jQuery.css(elem, "top");
            curCSSLeft = jQuery.css(elem, "left");
            calculatePosition =
                (position === "absolute" || position === "fixed") &&
                (curCSSTop + curCSSLeft).indexOf("auto") > -1;

            // Need to be able to calculate position if either
            // top or left is auto and position is either absolute or fixed
            if (calculatePosition) {
                curPosition = curElem.position();
                curTop = curPosition.top;
                curLeft = curPosition.left;
            } else {
                curTop = parseFloat(curCSSTop) || 0;
                curLeft = parseFloat(curCSSLeft) || 0;
            }

            if (isFunction(options)) {
                // Use jQuery.extend here to allow modification of coordinates argument (gh-1848)
                options = options.call(elem, i, jQuery.extend({}, curOffset));
            }

            if (options.top != null) {
                props.top = options.top - curOffset.top + curTop;
            }
            if (options.left != null) {
                props.left = options.left - curOffset.left + curLeft;
            }

            if ("using" in options) {
                options.using.call(elem, props);
            } else {
                curElem.css(props);
            }
        },
    };

    jQuery.fn.extend({
        // offset() relates an element's border box to the document origin
        offset: function (options) {
            // Preserve chaining for setter
            if (arguments.length) {
                return options === undefined
                    ? this
                    : this.each(function (i) {
                          jQuery.offset.setOffset(this, options, i);
                      });
            }

            var rect,
                win,
                elem = this[0];

            if (!elem) {
                return;
            }

            // Return zeros for disconnected and hidden (display: none) elements (gh-2310)
            // Support: IE <=11 only
            // Running getBoundingClientRect on a
            // disconnected node in IE throws an error
            if (!elem.getClientRects().length) {
                return { top: 0, left: 0 };
            }

            // Get document-relative position by adding viewport scroll to viewport-relative gBCR
            rect = elem.getBoundingClientRect();
            win = elem.ownerDocument.defaultView;
            return {
                top: rect.top + win.pageYOffset,
                left: rect.left + win.pageXOffset,
            };
        },

        // position() relates an element's margin box to its offset parent's padding box
        // This corresponds to the behavior of CSS absolute positioning
        position: function () {
            if (!this[0]) {
                return;
            }

            var offsetParent,
                offset,
                doc,
                elem = this[0],
                parentOffset = { top: 0, left: 0 };

            // position:fixed elements are offset from the viewport, which itself always has zero offset
            if (jQuery.css(elem, "position") === "fixed") {
                // Assume position:fixed implies availability of getBoundingClientRect
                offset = elem.getBoundingClientRect();
            } else {
                offset = this.offset();

                // Account for the *real* offset parent, which can be the document or its root element
                // when a statically positioned element is identified
                doc = elem.ownerDocument;
                offsetParent = elem.offsetParent || doc.documentElement;
                while (
                    offsetParent &&
                    (offsetParent === doc.body ||
                        offsetParent === doc.documentElement) &&
                    jQuery.css(offsetParent, "position") === "static"
                ) {
                    offsetParent = offsetParent.parentNode;
                }
                if (
                    offsetParent &&
                    offsetParent !== elem &&
                    offsetParent.nodeType === 1
                ) {
                    // Incorporate borders into its offset, since they are outside its content origin
                    parentOffset = jQuery(offsetParent).offset();
                    parentOffset.top += jQuery.css(
                        offsetParent,
                        "borderTopWidth",
                        true
                    );
                    parentOffset.left += jQuery.css(
                        offsetParent,
                        "borderLeftWidth",
                        true
                    );
                }
            }

            // Subtract parent offsets and element margins
            return {
                top:
                    offset.top -
                    parentOffset.top -
                    jQuery.css(elem, "marginTop", true),
                left:
                    offset.left -
                    parentOffset.left -
                    jQuery.css(elem, "marginLeft", true),
            };
        },

        // This method will return documentElement in the following cases:
        // 1) For the element inside the iframe without offsetParent, this method will return
        //    documentElement of the parent window
        // 2) For the hidden or detached element
        // 3) For body or html element, i.e. in case of the html node - it will return itself
        //
        // but those exceptions were never presented as a real life use-cases
        // and might be considered as more preferable results.
        //
        // This logic, however, is not guaranteed and can change at any point in the future
        offsetParent: function () {
            return this.map(function () {
                var offsetParent = this.offsetParent;

                while (
                    offsetParent &&
                    jQuery.css(offsetParent, "position") === "static"
                ) {
                    offsetParent = offsetParent.offsetParent;
                }

                return offsetParent || documentElement;
            });
        },
    });

    // Create scrollLeft and scrollTop methods
    jQuery.each(
        { scrollLeft: "pageXOffset", scrollTop: "pageYOffset" },
        function (method, prop) {
            var top = "pageYOffset" === prop;

            jQuery.fn[method] = function (val) {
                return access(
                    this,
                    function (elem, method, val) {
                        // Coalesce documents and windows
                        var win;
                        if (isWindow(elem)) {
                            win = elem;
                        } else if (elem.nodeType === 9) {
                            win = elem.defaultView;
                        }

                        if (val === undefined) {
                            return win ? win[prop] : elem[method];
                        }

                        if (win) {
                            win.scrollTo(
                                !top ? val : win.pageXOffset,
                                top ? val : win.pageYOffset
                            );
                        } else {
                            elem[method] = val;
                        }
                    },
                    method,
                    val,
                    arguments.length
                );
            };
        }
    );

    // Support: Safari <=7 - 9.1, Chrome <=37 - 49
    // Add the top/left cssHooks using jQuery.fn.position
    // Webkit bug: https://bugs.webkit.org/show_bug.cgi?id=29084
    // Blink bug: https://bugs.chromium.org/p/chromium/issues/detail?id=589347
    // getComputedStyle returns percent when specified for top/left/bottom/right;
    // rather than make the css module depend on the offset module, just check for it here
    jQuery.each(["top", "left"], function (_i, prop) {
        jQuery.cssHooks[prop] = addGetHookIf(
            support.pixelPosition,
            function (elem, computed) {
                if (computed) {
                    computed = curCSS(elem, prop);

                    // If curCSS returns percentage, fallback to offset
                    return rnumnonpx.test(computed)
                        ? jQuery(elem).position()[prop] + "px"
                        : computed;
                }
            }
        );
    });

    // Create innerHeight, innerWidth, height, width, outerHeight and outerWidth methods
    jQuery.each({ Height: "height", Width: "width" }, function (name, type) {
        jQuery.each(
            {
                padding: "inner" + name,
                content: type,
                "": "outer" + name,
            },
            function (defaultExtra, funcName) {
                // Margin is only for outerHeight, outerWidth
                jQuery.fn[funcName] = function (margin, value) {
                    var chainable =
                            arguments.length &&
                            (defaultExtra || typeof margin !== "boolean"),
                        extra =
                            defaultExtra ||
                            (margin === true || value === true
                                ? "margin"
                                : "border");

                    return access(
                        this,
                        function (elem, type, value) {
                            var doc;

                            if (isWindow(elem)) {
                                // $( window ).outerWidth/Height return w/h including scrollbars (gh-1729)
                                return funcName.indexOf("outer") === 0
                                    ? elem["inner" + name]
                                    : elem.document.documentElement[
                                          "client" + name
                                      ];
                            }

                            // Get document width or height
                            if (elem.nodeType === 9) {
                                doc = elem.documentElement;

                                // Either scroll[Width/Height] or offset[Width/Height] or client[Width/Height],
                                // whichever is greatest
                                return Math.max(
                                    elem.body["scroll" + name],
                                    doc["scroll" + name],
                                    elem.body["offset" + name],
                                    doc["offset" + name],
                                    doc["client" + name]
                                );
                            }

                            return value === undefined
                                ? // Get width or height on the element, requesting but not forcing parseFloat
                                  jQuery.css(elem, type, extra)
                                : // Set width or height on the element
                                  jQuery.style(elem, type, value, extra);
                        },
                        type,
                        chainable ? margin : undefined,
                        chainable
                    );
                };
            }
        );
    });

    jQuery.each(
        [
            "ajaxStart",
            "ajaxStop",
            "ajaxComplete",
            "ajaxError",
            "ajaxSuccess",
            "ajaxSend",
        ],
        function (_i, type) {
            jQuery.fn[type] = function (fn) {
                return this.on(type, fn);
            };
        }
    );

    jQuery.fn.extend({
        bind: function (types, data, fn) {
            return this.on(types, null, data, fn);
        },
        unbind: function (types, fn) {
            return this.off(types, null, fn);
        },

        delegate: function (selector, types, data, fn) {
            return this.on(types, selector, data, fn);
        },
        undelegate: function (selector, types, fn) {
            // ( namespace ) or ( selector, types [, fn] )
            return arguments.length === 1
                ? this.off(selector, "**")
                : this.off(types, selector || "**", fn);
        },

        hover: function (fnOver, fnOut) {
            return this.mouseenter(fnOver).mouseleave(fnOut || fnOver);
        },
    });

    jQuery.each(
        (
            "blur focus focusin focusout resize scroll click dblclick " +
            "mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave " +
            "change select submit keydown keypress keyup contextmenu"
        ).split(" "),
        function (_i, name) {
            // Handle event binding
            jQuery.fn[name] = function (data, fn) {
                return arguments.length > 0
                    ? this.on(name, null, data, fn)
                    : this.trigger(name);
            };
        }
    );

    // Support: Android <=4.0 only
    // Make sure we trim BOM and NBSP
    var rtrim = /^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g;

    // Bind a function to a context, optionally partially applying any
    // arguments.
    // jQuery.proxy is deprecated to promote standards (specifically Function#bind)
    // However, it is not slated for removal any time soon
    jQuery.proxy = function (fn, context) {
        var tmp, args, proxy;

        if (typeof context === "string") {
            tmp = fn[context];
            context = fn;
            fn = tmp;
        }

        // Quick check to determine if target is callable, in the spec
        // this throws a TypeError, but we will just return undefined.
        if (!isFunction(fn)) {
            return undefined;
        }

        // Simulated bind
        args = slice.call(arguments, 2);
        proxy = function () {
            return fn.apply(
                context || this,
                args.concat(slice.call(arguments))
            );
        };

        // Set the guid of unique handler to the same of original handler, so it can be removed
        proxy.guid = fn.guid = fn.guid || jQuery.guid++;

        return proxy;
    };

    jQuery.holdReady = function (hold) {
        if (hold) {
            jQuery.readyWait++;
        } else {
            jQuery.ready(true);
        }
    };
    jQuery.isArray = Array.isArray;
    jQuery.parseJSON = JSON.parse;
    jQuery.nodeName = nodeName;
    jQuery.isFunction = isFunction;
    jQuery.isWindow = isWindow;
    jQuery.camelCase = camelCase;
    jQuery.type = toType;

    jQuery.now = Date.now;

    jQuery.isNumeric = function (obj) {
        // As of jQuery 3.0, isNumeric is limited to
        // strings and numbers (primitives or objects)
        // that can be coerced to finite numbers (gh-2662)
        var type = jQuery.type(obj);
        return (
            (type === "number" || type === "string") &&
            // parseFloat NaNs numeric-cast false positives ("")
            // ...but misinterprets leading-number strings, particularly hex literals ("0x...")
            // subtraction forces infinities to NaN
            !isNaN(obj - parseFloat(obj))
        );
    };

    jQuery.trim = function (text) {
        return text == null ? "" : (text + "").replace(rtrim, "");
    };

    // Register as a named AMD module, since jQuery can be concatenated with other
    // files that may use define, but not via a proper concatenation script that
    // understands anonymous AMD modules. A named AMD is safest and most robust
    // way to register. Lowercase jquery is used because AMD module names are
    // derived from file names, and jQuery is normally delivered in a lowercase
    // file name. Do this after creating the global so that if an AMD module wants
    // to call noConflict to hide this version of jQuery, it will work.

    // Note that for maximum portability, libraries that are not jQuery should
    // declare themselves as anonymous modules, and avoid setting a global if an
    // AMD loader is present. jQuery is a special case. For more information, see
    // https://github.com/jrburke/requirejs/wiki/Updating-existing-libraries#wiki-anon

    if (typeof define === "function" && define.amd) {
        define("jquery", [], function () {
            return jQuery;
        });
    }

    var // Map over jQuery in case of overwrite
        _jQuery = window.jQuery,
        // Map over the $ in case of overwrite
        _$ = window.$;

    jQuery.noConflict = function (deep) {
        if (window.$ === jQuery) {
            window.$ = _$;
        }

        if (deep && window.jQuery === jQuery) {
            window.jQuery = _jQuery;
        }

        return jQuery;
    };

    // Expose jQuery and $ identifiers, even in AMD
    // (#7102#comment:10, https://github.com/jquery/jquery/pull/557)
    // and CommonJS for browser emulators (#13566)
    if (typeof noGlobal === "undefined") {
        window.jQuery = window.$ = jQuery;
    }

    return jQuery;
});

/*!
 * Bootstrap v5.1.3 (https://getbootstrap.com/)
 * Copyright 2011-2021 The Bootstrap Authors (https://github.com/twbs/bootstrap/graphs/contributors)
 * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
 */
(function (global, factory) {
    typeof exports === "object" && typeof module !== "undefined"
        ? (module.exports = factory())
        : typeof define === "function" && define.amd
        ? define(factory)
        : ((global =
              typeof globalThis !== "undefined" ? globalThis : global || self),
          (global.bootstrap = factory()));
})(this, function () {
    "use strict";

    /**
     * --------------------------------------------------------------------------
     * Bootstrap (v5.1.3): util/index.js
     * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
     * --------------------------------------------------------------------------
     */
    const MAX_UID = 1000000;
    const MILLISECONDS_MULTIPLIER = 1000;
    const TRANSITION_END = "transitionend"; // Shoutout AngusCroll (https://goo.gl/pxwQGp)

    const toType = (obj) => {
        if (obj === null || obj === undefined) {
            return `${obj}`;
        }

        return {}.toString
            .call(obj)
            .match(/\s([a-z]+)/i)[1]
            .toLowerCase();
    };
    /**
     * --------------------------------------------------------------------------
     * Public Util Api
     * --------------------------------------------------------------------------
     */

    const getUID = (prefix) => {
        do {
            prefix += Math.floor(Math.random() * MAX_UID);
        } while (document.getElementById(prefix));

        return prefix;
    };

    const getSelector = (element) => {
        let selector = element.getAttribute("data-bs-target");

        if (!selector || selector === "#") {
            let hrefAttr = element.getAttribute("href"); // The only valid content that could double as a selector are IDs or classes,
            // so everything starting with `#` or `.`. If a "real" URL is used as the selector,
            // `document.querySelector` will rightfully complain it is invalid.
            // See https://github.com/twbs/bootstrap/issues/32273

            if (
                !hrefAttr ||
                (!hrefAttr.includes("#") && !hrefAttr.startsWith("."))
            ) {
                return null;
            } // Just in case some CMS puts out a full URL with the anchor appended

            if (hrefAttr.includes("#") && !hrefAttr.startsWith("#")) {
                hrefAttr = `#${hrefAttr.split("#")[1]}`;
            }

            selector = hrefAttr && hrefAttr !== "#" ? hrefAttr.trim() : null;
        }

        return selector;
    };

    const getSelectorFromElement = (element) => {
        const selector = getSelector(element);

        if (selector) {
            return document.querySelector(selector) ? selector : null;
        }

        return null;
    };

    const getElementFromSelector = (element) => {
        const selector = getSelector(element);
        return selector ? document.querySelector(selector) : null;
    };

    const getTransitionDurationFromElement = (element) => {
        if (!element) {
            return 0;
        } // Get transition-duration of the element

        let { transitionDuration, transitionDelay } =
            window.getComputedStyle(element);
        const floatTransitionDuration = Number.parseFloat(transitionDuration);
        const floatTransitionDelay = Number.parseFloat(transitionDelay); // Return 0 if element or transition duration is not found

        if (!floatTransitionDuration && !floatTransitionDelay) {
            return 0;
        } // If multiple durations are defined, take the first

        transitionDuration = transitionDuration.split(",")[0];
        transitionDelay = transitionDelay.split(",")[0];
        return (
            (Number.parseFloat(transitionDuration) +
                Number.parseFloat(transitionDelay)) *
            MILLISECONDS_MULTIPLIER
        );
    };

    const triggerTransitionEnd = (element) => {
        element.dispatchEvent(new Event(TRANSITION_END));
    };

    const isElement$1 = (obj) => {
        if (!obj || typeof obj !== "object") {
            return false;
        }

        if (typeof obj.jquery !== "undefined") {
            obj = obj[0];
        }

        return typeof obj.nodeType !== "undefined";
    };

    const getElement = (obj) => {
        if (isElement$1(obj)) {
            // it's a jQuery object or a node element
            return obj.jquery ? obj[0] : obj;
        }

        if (typeof obj === "string" && obj.length > 0) {
            return document.querySelector(obj);
        }

        return null;
    };

    const typeCheckConfig = (componentName, config, configTypes) => {
        Object.keys(configTypes).forEach((property) => {
            const expectedTypes = configTypes[property];
            const value = config[property];
            const valueType =
                value && isElement$1(value) ? "element" : toType(value);

            if (!new RegExp(expectedTypes).test(valueType)) {
                throw new TypeError(
                    `${componentName.toUpperCase()}: Option "${property}" provided type "${valueType}" but expected type "${expectedTypes}".`
                );
            }
        });
    };

    const isVisible = (element) => {
        if (!isElement$1(element) || element.getClientRects().length === 0) {
            return false;
        }

        return (
            getComputedStyle(element).getPropertyValue("visibility") ===
            "visible"
        );
    };

    const isDisabled = (element) => {
        if (!element || element.nodeType !== Node.ELEMENT_NODE) {
            return true;
        }

        if (element.classList.contains("disabled")) {
            return true;
        }

        if (typeof element.disabled !== "undefined") {
            return element.disabled;
        }

        return (
            element.hasAttribute("disabled") &&
            element.getAttribute("disabled") !== "false"
        );
    };

    const findShadowRoot = (element) => {
        if (!document.documentElement.attachShadow) {
            return null;
        } // Can find the shadow root otherwise it'll return the document

        if (typeof element.getRootNode === "function") {
            const root = element.getRootNode();
            return root instanceof ShadowRoot ? root : null;
        }

        if (element instanceof ShadowRoot) {
            return element;
        } // when we don't find a shadow root

        if (!element.parentNode) {
            return null;
        }

        return findShadowRoot(element.parentNode);
    };

    const noop = () => {};
    /**
     * Trick to restart an element's animation
     *
     * @param {HTMLElement} element
     * @return void
     *
     * @see https://www.charistheo.io/blog/2021/02/restart-a-css-animation-with-javascript/#restarting-a-css-animation
     */

    const reflow = (element) => {
        // eslint-disable-next-line no-unused-expressions
        element.offsetHeight;
    };

    const getjQuery = () => {
        const { jQuery } = window;

        if (jQuery && !document.body.hasAttribute("data-bs-no-jquery")) {
            return jQuery;
        }

        return null;
    };

    const DOMContentLoadedCallbacks = [];

    const onDOMContentLoaded = (callback) => {
        if (document.readyState === "loading") {
            // add listener on the first call when the document is in loading state
            if (!DOMContentLoadedCallbacks.length) {
                document.addEventListener("DOMContentLoaded", () => {
                    DOMContentLoadedCallbacks.forEach((callback) => callback());
                });
            }

            DOMContentLoadedCallbacks.push(callback);
        } else {
            callback();
        }
    };

    const isRTL = () => document.documentElement.dir === "rtl";

    const defineJQueryPlugin = (plugin) => {
        onDOMContentLoaded(() => {
            const $ = getjQuery();
            /* istanbul ignore if */

            if ($) {
                const name = plugin.NAME;
                const JQUERY_NO_CONFLICT = $.fn[name];
                $.fn[name] = plugin.jQueryInterface;
                $.fn[name].Constructor = plugin;

                $.fn[name].noConflict = () => {
                    $.fn[name] = JQUERY_NO_CONFLICT;
                    return plugin.jQueryInterface;
                };
            }
        });
    };

    const execute = (callback) => {
        if (typeof callback === "function") {
            callback();
        }
    };

    const executeAfterTransition = (
        callback,
        transitionElement,
        waitForTransition = true
    ) => {
        if (!waitForTransition) {
            execute(callback);
            return;
        }

        const durationPadding = 5;
        const emulatedDuration =
            getTransitionDurationFromElement(transitionElement) +
            durationPadding;
        let called = false;

        const handler = ({ target }) => {
            if (target !== transitionElement) {
                return;
            }

            called = true;
            transitionElement.removeEventListener(TRANSITION_END, handler);
            execute(callback);
        };

        transitionElement.addEventListener(TRANSITION_END, handler);
        setTimeout(() => {
            if (!called) {
                triggerTransitionEnd(transitionElement);
            }
        }, emulatedDuration);
    };
    /**
     * Return the previous/next element of a list.
     *
     * @param {array} list    The list of elements
     * @param activeElement   The active element
     * @param shouldGetNext   Choose to get next or previous element
     * @param isCycleAllowed
     * @return {Element|elem} The proper element
     */

    const getNextActiveElement = (
        list,
        activeElement,
        shouldGetNext,
        isCycleAllowed
    ) => {
        let index = list.indexOf(activeElement); // if the element does not exist in the list return an element depending on the direction and if cycle is allowed

        if (index === -1) {
            return list[!shouldGetNext && isCycleAllowed ? list.length - 1 : 0];
        }

        const listLength = list.length;
        index += shouldGetNext ? 1 : -1;

        if (isCycleAllowed) {
            index = (index + listLength) % listLength;
        }

        return list[Math.max(0, Math.min(index, listLength - 1))];
    };

    /**
     * --------------------------------------------------------------------------
     * Bootstrap (v5.1.3): dom/event-handler.js
     * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
     * --------------------------------------------------------------------------
     */
    /**
     * ------------------------------------------------------------------------
     * Constants
     * ------------------------------------------------------------------------
     */

    const namespaceRegex = /[^.]*(?=\..*)\.|.*/;
    const stripNameRegex = /\..*/;
    const stripUidRegex = /::\d+$/;
    const eventRegistry = {}; // Events storage

    let uidEvent = 1;
    const customEvents = {
        mouseenter: "mouseover",
        mouseleave: "mouseout",
    };
    const customEventsRegex = /^(mouseenter|mouseleave)/i;
    const nativeEvents = new Set([
        "click",
        "dblclick",
        "mouseup",
        "mousedown",
        "contextmenu",
        "mousewheel",
        "DOMMouseScroll",
        "mouseover",
        "mouseout",
        "mousemove",
        "selectstart",
        "selectend",
        "keydown",
        "keypress",
        "keyup",
        "orientationchange",
        "touchstart",
        "touchmove",
        "touchend",
        "touchcancel",
        "pointerdown",
        "pointermove",
        "pointerup",
        "pointerleave",
        "pointercancel",
        "gesturestart",
        "gesturechange",
        "gestureend",
        "focus",
        "blur",
        "change",
        "reset",
        "select",
        "submit",
        "focusin",
        "focusout",
        "load",
        "unload",
        "beforeunload",
        "resize",
        "move",
        "DOMContentLoaded",
        "readystatechange",
        "error",
        "abort",
        "scroll",
    ]);
    /**
     * ------------------------------------------------------------------------
     * Private methods
     * ------------------------------------------------------------------------
     */

    function getUidEvent(element, uid) {
        return (
            (uid && `${uid}::${uidEvent++}`) || element.uidEvent || uidEvent++
        );
    }

    function getEvent(element) {
        const uid = getUidEvent(element);
        element.uidEvent = uid;
        eventRegistry[uid] = eventRegistry[uid] || {};
        return eventRegistry[uid];
    }

    function bootstrapHandler(element, fn) {
        return function handler(event) {
            event.delegateTarget = element;

            if (handler.oneOff) {
                EventHandler.off(element, event.type, fn);
            }

            return fn.apply(element, [event]);
        };
    }

    function bootstrapDelegationHandler(element, selector, fn) {
        return function handler(event) {
            const domElements = element.querySelectorAll(selector);

            for (
                let { target } = event;
                target && target !== this;
                target = target.parentNode
            ) {
                for (let i = domElements.length; i--; ) {
                    if (domElements[i] === target) {
                        event.delegateTarget = target;

                        if (handler.oneOff) {
                            EventHandler.off(element, event.type, selector, fn);
                        }

                        return fn.apply(target, [event]);
                    }
                }
            } // To please ESLint

            return null;
        };
    }

    function findHandler(events, handler, delegationSelector = null) {
        const uidEventList = Object.keys(events);

        for (let i = 0, len = uidEventList.length; i < len; i++) {
            const event = events[uidEventList[i]];

            if (
                event.originalHandler === handler &&
                event.delegationSelector === delegationSelector
            ) {
                return event;
            }
        }

        return null;
    }

    function normalizeParams(originalTypeEvent, handler, delegationFn) {
        const delegation = typeof handler === "string";
        const originalHandler = delegation ? delegationFn : handler;
        let typeEvent = getTypeEvent(originalTypeEvent);
        const isNative = nativeEvents.has(typeEvent);

        if (!isNative) {
            typeEvent = originalTypeEvent;
        }

        return [delegation, originalHandler, typeEvent];
    }

    function addHandler(
        element,
        originalTypeEvent,
        handler,
        delegationFn,
        oneOff
    ) {
        if (typeof originalTypeEvent !== "string" || !element) {
            return;
        }

        if (!handler) {
            handler = delegationFn;
            delegationFn = null;
        } // in case of mouseenter or mouseleave wrap the handler within a function that checks for its DOM position
        // this prevents the handler from being dispatched the same way as mouseover or mouseout does

        if (customEventsRegex.test(originalTypeEvent)) {
            const wrapFn = (fn) => {
                return function (event) {
                    if (
                        !event.relatedTarget ||
                        (event.relatedTarget !== event.delegateTarget &&
                            !event.delegateTarget.contains(event.relatedTarget))
                    ) {
                        return fn.call(this, event);
                    }
                };
            };

            if (delegationFn) {
                delegationFn = wrapFn(delegationFn);
            } else {
                handler = wrapFn(handler);
            }
        }

        const [delegation, originalHandler, typeEvent] = normalizeParams(
            originalTypeEvent,
            handler,
            delegationFn
        );
        const events = getEvent(element);
        const handlers = events[typeEvent] || (events[typeEvent] = {});
        const previousFn = findHandler(
            handlers,
            originalHandler,
            delegation ? handler : null
        );

        if (previousFn) {
            previousFn.oneOff = previousFn.oneOff && oneOff;
            return;
        }

        const uid = getUidEvent(
            originalHandler,
            originalTypeEvent.replace(namespaceRegex, "")
        );
        const fn = delegation
            ? bootstrapDelegationHandler(element, handler, delegationFn)
            : bootstrapHandler(element, handler);
        fn.delegationSelector = delegation ? handler : null;
        fn.originalHandler = originalHandler;
        fn.oneOff = oneOff;
        fn.uidEvent = uid;
        handlers[uid] = fn;
        element.addEventListener(typeEvent, fn, delegation);
    }

    function removeHandler(
        element,
        events,
        typeEvent,
        handler,
        delegationSelector
    ) {
        const fn = findHandler(events[typeEvent], handler, delegationSelector);

        if (!fn) {
            return;
        }

        element.removeEventListener(typeEvent, fn, Boolean(delegationSelector));
        delete events[typeEvent][fn.uidEvent];
    }

    function removeNamespacedHandlers(element, events, typeEvent, namespace) {
        const storeElementEvent = events[typeEvent] || {};
        Object.keys(storeElementEvent).forEach((handlerKey) => {
            if (handlerKey.includes(namespace)) {
                const event = storeElementEvent[handlerKey];
                removeHandler(
                    element,
                    events,
                    typeEvent,
                    event.originalHandler,
                    event.delegationSelector
                );
            }
        });
    }

    function getTypeEvent(event) {
        // allow to get the native events from namespaced events ('click.bs.button' --> 'click')
        event = event.replace(stripNameRegex, "");
        return customEvents[event] || event;
    }

    const EventHandler = {
        on(element, event, handler, delegationFn) {
            addHandler(element, event, handler, delegationFn, false);
        },

        one(element, event, handler, delegationFn) {
            addHandler(element, event, handler, delegationFn, true);
        },

        off(element, originalTypeEvent, handler, delegationFn) {
            if (typeof originalTypeEvent !== "string" || !element) {
                return;
            }

            const [delegation, originalHandler, typeEvent] = normalizeParams(
                originalTypeEvent,
                handler,
                delegationFn
            );
            const inNamespace = typeEvent !== originalTypeEvent;
            const events = getEvent(element);
            const isNamespace = originalTypeEvent.startsWith(".");

            if (typeof originalHandler !== "undefined") {
                // Simplest case: handler is passed, remove that listener ONLY.
                if (!events || !events[typeEvent]) {
                    return;
                }

                removeHandler(
                    element,
                    events,
                    typeEvent,
                    originalHandler,
                    delegation ? handler : null
                );
                return;
            }

            if (isNamespace) {
                Object.keys(events).forEach((elementEvent) => {
                    removeNamespacedHandlers(
                        element,
                        events,
                        elementEvent,
                        originalTypeEvent.slice(1)
                    );
                });
            }

            const storeElementEvent = events[typeEvent] || {};
            Object.keys(storeElementEvent).forEach((keyHandlers) => {
                const handlerKey = keyHandlers.replace(stripUidRegex, "");

                if (!inNamespace || originalTypeEvent.includes(handlerKey)) {
                    const event = storeElementEvent[keyHandlers];
                    removeHandler(
                        element,
                        events,
                        typeEvent,
                        event.originalHandler,
                        event.delegationSelector
                    );
                }
            });
        },

        trigger(element, event, args) {
            if (typeof event !== "string" || !element) {
                return null;
            }

            const $ = getjQuery();
            const typeEvent = getTypeEvent(event);
            const inNamespace = event !== typeEvent;
            const isNative = nativeEvents.has(typeEvent);
            let jQueryEvent;
            let bubbles = true;
            let nativeDispatch = true;
            let defaultPrevented = false;
            let evt = null;

            if (inNamespace && $) {
                jQueryEvent = $.Event(event, args);
                $(element).trigger(jQueryEvent);
                bubbles = !jQueryEvent.isPropagationStopped();
                nativeDispatch = !jQueryEvent.isImmediatePropagationStopped();
                defaultPrevented = jQueryEvent.isDefaultPrevented();
            }

            if (isNative) {
                evt = document.createEvent("HTMLEvents");
                evt.initEvent(typeEvent, bubbles, true);
            } else {
                evt = new CustomEvent(event, {
                    bubbles,
                    cancelable: true,
                });
            } // merge custom information in our event

            if (typeof args !== "undefined") {
                Object.keys(args).forEach((key) => {
                    Object.defineProperty(evt, key, {
                        get() {
                            return args[key];
                        },
                    });
                });
            }

            if (defaultPrevented) {
                evt.preventDefault();
            }

            if (nativeDispatch) {
                element.dispatchEvent(evt);
            }

            if (evt.defaultPrevented && typeof jQueryEvent !== "undefined") {
                jQueryEvent.preventDefault();
            }

            return evt;
        },
    };

    /**
     * --------------------------------------------------------------------------
     * Bootstrap (v5.1.3): dom/data.js
     * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
     * --------------------------------------------------------------------------
     */

    /**
     * ------------------------------------------------------------------------
     * Constants
     * ------------------------------------------------------------------------
     */
    const elementMap = new Map();
    const Data = {
        set(element, key, instance) {
            if (!elementMap.has(element)) {
                elementMap.set(element, new Map());
            }

            const instanceMap = elementMap.get(element); // make it clear we only want one instance per element
            // can be removed later when multiple key/instances are fine to be used

            if (!instanceMap.has(key) && instanceMap.size !== 0) {
                // eslint-disable-next-line no-console
                console.error(
                    `Bootstrap doesn't allow more than one instance per element. Bound instance: ${
                        Array.from(instanceMap.keys())[0]
                    }.`
                );
                return;
            }

            instanceMap.set(key, instance);
        },

        get(element, key) {
            if (elementMap.has(element)) {
                return elementMap.get(element).get(key) || null;
            }

            return null;
        },

        remove(element, key) {
            if (!elementMap.has(element)) {
                return;
            }

            const instanceMap = elementMap.get(element);
            instanceMap.delete(key); // free up element references if there are no instances left for an element

            if (instanceMap.size === 0) {
                elementMap.delete(element);
            }
        },
    };

    /**
     * --------------------------------------------------------------------------
     * Bootstrap (v5.1.3): base-component.js
     * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
     * --------------------------------------------------------------------------
     */
    /**
     * ------------------------------------------------------------------------
     * Constants
     * ------------------------------------------------------------------------
     */

    const VERSION = "5.1.3";

    class BaseComponent {
        constructor(element) {
            element = getElement(element);

            if (!element) {
                return;
            }

            this._element = element;
            Data.set(this._element, this.constructor.DATA_KEY, this);
        }

        dispose() {
            Data.remove(this._element, this.constructor.DATA_KEY);
            EventHandler.off(this._element, this.constructor.EVENT_KEY);
            Object.getOwnPropertyNames(this).forEach((propertyName) => {
                this[propertyName] = null;
            });
        }

        _queueCallback(callback, element, isAnimated = true) {
            executeAfterTransition(callback, element, isAnimated);
        }
        /** Static */

        static getInstance(element) {
            return Data.get(getElement(element), this.DATA_KEY);
        }

        static getOrCreateInstance(element, config = {}) {
            return (
                this.getInstance(element) ||
                new this(element, typeof config === "object" ? config : null)
            );
        }

        static get VERSION() {
            return VERSION;
        }

        static get NAME() {
            throw new Error(
                'You have to implement the static method "NAME", for each component!'
            );
        }

        static get DATA_KEY() {
            return `bs.${this.NAME}`;
        }

        static get EVENT_KEY() {
            return `.${this.DATA_KEY}`;
        }
    }

    /**
     * --------------------------------------------------------------------------
     * Bootstrap (v5.1.3): util/component-functions.js
     * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
     * --------------------------------------------------------------------------
     */

    const enableDismissTrigger = (component, method = "hide") => {
        const clickEvent = `click.dismiss${component.EVENT_KEY}`;
        const name = component.NAME;
        EventHandler.on(
            document,
            clickEvent,
            `[data-bs-dismiss="${name}"]`,
            function (event) {
                if (["A", "AREA"].includes(this.tagName)) {
                    event.preventDefault();
                }

                if (isDisabled(this)) {
                    return;
                }

                const target =
                    getElementFromSelector(this) || this.closest(`.${name}`);
                const instance = component.getOrCreateInstance(target); // Method argument is left, for Alert and only, as it doesn't implement the 'hide' method

                instance[method]();
            }
        );
    };

    /**
     * --------------------------------------------------------------------------
     * Bootstrap (v5.1.3): alert.js
     * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
     * --------------------------------------------------------------------------
     */
    /**
     * ------------------------------------------------------------------------
     * Constants
     * ------------------------------------------------------------------------
     */

    const NAME$d = "alert";
    const DATA_KEY$c = "bs.alert";
    const EVENT_KEY$c = `.${DATA_KEY$c}`;
    const EVENT_CLOSE = `close${EVENT_KEY$c}`;
    const EVENT_CLOSED = `closed${EVENT_KEY$c}`;
    const CLASS_NAME_FADE$5 = "fade";
    const CLASS_NAME_SHOW$8 = "show";
    /**
     * ------------------------------------------------------------------------
     * Class Definition
     * ------------------------------------------------------------------------
     */

    class Alert extends BaseComponent {
        // Getters
        static get NAME() {
            return NAME$d;
        } // Public

        close() {
            const closeEvent = EventHandler.trigger(this._element, EVENT_CLOSE);

            if (closeEvent.defaultPrevented) {
                return;
            }

            this._element.classList.remove(CLASS_NAME_SHOW$8);

            const isAnimated =
                this._element.classList.contains(CLASS_NAME_FADE$5);

            this._queueCallback(
                () => this._destroyElement(),
                this._element,
                isAnimated
            );
        } // Private

        _destroyElement() {
            this._element.remove();

            EventHandler.trigger(this._element, EVENT_CLOSED);
            this.dispose();
        } // Static

        static jQueryInterface(config) {
            return this.each(function () {
                const data = Alert.getOrCreateInstance(this);

                if (typeof config !== "string") {
                    return;
                }

                if (
                    data[config] === undefined ||
                    config.startsWith("_") ||
                    config === "constructor"
                ) {
                    throw new TypeError(`No method named "${config}"`);
                }

                data[config](this);
            });
        }
    }
    /**
     * ------------------------------------------------------------------------
     * Data Api implementation
     * ------------------------------------------------------------------------
     */

    enableDismissTrigger(Alert, "close");
    /**
     * ------------------------------------------------------------------------
     * jQuery
     * ------------------------------------------------------------------------
     * add .Alert to jQuery only if jQuery is present
     */

    defineJQueryPlugin(Alert);

    /**
     * --------------------------------------------------------------------------
     * Bootstrap (v5.1.3): button.js
     * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
     * --------------------------------------------------------------------------
     */
    /**
     * ------------------------------------------------------------------------
     * Constants
     * ------------------------------------------------------------------------
     */

    const NAME$c = "button";
    const DATA_KEY$b = "bs.button";
    const EVENT_KEY$b = `.${DATA_KEY$b}`;
    const DATA_API_KEY$7 = ".data-api";
    const CLASS_NAME_ACTIVE$3 = "active";
    const SELECTOR_DATA_TOGGLE$5 = '[data-bs-toggle="button"]';
    const EVENT_CLICK_DATA_API$6 = `click${EVENT_KEY$b}${DATA_API_KEY$7}`;
    /**
     * ------------------------------------------------------------------------
     * Class Definition
     * ------------------------------------------------------------------------
     */

    class Button extends BaseComponent {
        // Getters
        static get NAME() {
            return NAME$c;
        } // Public

        toggle() {
            // Toggle class and sync the `aria-pressed` attribute with the return value of the `.toggle()` method
            this._element.setAttribute(
                "aria-pressed",
                this._element.classList.toggle(CLASS_NAME_ACTIVE$3)
            );
        } // Static

        static jQueryInterface(config) {
            return this.each(function () {
                const data = Button.getOrCreateInstance(this);

                if (config === "toggle") {
                    data[config]();
                }
            });
        }
    }
    /**
     * ------------------------------------------------------------------------
     * Data Api implementation
     * ------------------------------------------------------------------------
     */

    EventHandler.on(
        document,
        EVENT_CLICK_DATA_API$6,
        SELECTOR_DATA_TOGGLE$5,
        (event) => {
            event.preventDefault();
            const button = event.target.closest(SELECTOR_DATA_TOGGLE$5);
            const data = Button.getOrCreateInstance(button);
            data.toggle();
        }
    );
    /**
     * ------------------------------------------------------------------------
     * jQuery
     * ------------------------------------------------------------------------
     * add .Button to jQuery only if jQuery is present
     */

    defineJQueryPlugin(Button);

    /**
     * --------------------------------------------------------------------------
     * Bootstrap (v5.1.3): dom/manipulator.js
     * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
     * --------------------------------------------------------------------------
     */
    function normalizeData(val) {
        if (val === "true") {
            return true;
        }

        if (val === "false") {
            return false;
        }

        if (val === Number(val).toString()) {
            return Number(val);
        }

        if (val === "" || val === "null") {
            return null;
        }

        return val;
    }

    function normalizeDataKey(key) {
        return key.replace(/[A-Z]/g, (chr) => `-${chr.toLowerCase()}`);
    }

    const Manipulator = {
        setDataAttribute(element, key, value) {
            element.setAttribute(`data-bs-${normalizeDataKey(key)}`, value);
        },

        removeDataAttribute(element, key) {
            element.removeAttribute(`data-bs-${normalizeDataKey(key)}`);
        },

        getDataAttributes(element) {
            if (!element) {
                return {};
            }

            const attributes = {};
            Object.keys(element.dataset)
                .filter((key) => key.startsWith("bs"))
                .forEach((key) => {
                    let pureKey = key.replace(/^bs/, "");
                    pureKey =
                        pureKey.charAt(0).toLowerCase() +
                        pureKey.slice(1, pureKey.length);
                    attributes[pureKey] = normalizeData(element.dataset[key]);
                });
            return attributes;
        },

        getDataAttribute(element, key) {
            return normalizeData(
                element.getAttribute(`data-bs-${normalizeDataKey(key)}`)
            );
        },

        offset(element) {
            const rect = element.getBoundingClientRect();
            return {
                top: rect.top + window.pageYOffset,
                left: rect.left + window.pageXOffset,
            };
        },

        position(element) {
            return {
                top: element.offsetTop,
                left: element.offsetLeft,
            };
        },
    };

    /**
     * --------------------------------------------------------------------------
     * Bootstrap (v5.1.3): dom/selector-engine.js
     * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
     * --------------------------------------------------------------------------
     */
    const NODE_TEXT = 3;
    const SelectorEngine = {
        find(selector, element = document.documentElement) {
            return [].concat(
                ...Element.prototype.querySelectorAll.call(element, selector)
            );
        },

        findOne(selector, element = document.documentElement) {
            return Element.prototype.querySelector.call(element, selector);
        },

        children(element, selector) {
            return []
                .concat(...element.children)
                .filter((child) => child.matches(selector));
        },

        parents(element, selector) {
            const parents = [];
            let ancestor = element.parentNode;

            while (
                ancestor &&
                ancestor.nodeType === Node.ELEMENT_NODE &&
                ancestor.nodeType !== NODE_TEXT
            ) {
                if (ancestor.matches(selector)) {
                    parents.push(ancestor);
                }

                ancestor = ancestor.parentNode;
            }

            return parents;
        },

        prev(element, selector) {
            let previous = element.previousElementSibling;

            while (previous) {
                if (previous.matches(selector)) {
                    return [previous];
                }

                previous = previous.previousElementSibling;
            }

            return [];
        },

        next(element, selector) {
            let next = element.nextElementSibling;

            while (next) {
                if (next.matches(selector)) {
                    return [next];
                }

                next = next.nextElementSibling;
            }

            return [];
        },

        focusableChildren(element) {
            const focusables = [
                "a",
                "button",
                "input",
                "textarea",
                "select",
                "details",
                "[tabindex]",
                '[contenteditable="true"]',
            ]
                .map((selector) => `${selector}:not([tabindex^="-"])`)
                .join(", ");
            return this.find(focusables, element).filter(
                (el) => !isDisabled(el) && isVisible(el)
            );
        },
    };

    /**
     * --------------------------------------------------------------------------
     * Bootstrap (v5.1.3): carousel.js
     * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
     * --------------------------------------------------------------------------
     */
    /**
     * ------------------------------------------------------------------------
     * Constants
     * ------------------------------------------------------------------------
     */

    const NAME$b = "carousel";
    const DATA_KEY$a = "bs.carousel";
    const EVENT_KEY$a = `.${DATA_KEY$a}`;
    const DATA_API_KEY$6 = ".data-api";
    const ARROW_LEFT_KEY = "ArrowLeft";
    const ARROW_RIGHT_KEY = "ArrowRight";
    const TOUCHEVENT_COMPAT_WAIT = 500; // Time for mouse compat events to fire after touch

    const SWIPE_THRESHOLD = 40;
    const Default$a = {
        interval: 5000,
        keyboard: true,
        slide: false,
        pause: "hover",
        wrap: true,
        touch: true,
    };
    const DefaultType$a = {
        interval: "(number|boolean)",
        keyboard: "boolean",
        slide: "(boolean|string)",
        pause: "(string|boolean)",
        wrap: "boolean",
        touch: "boolean",
    };
    const ORDER_NEXT = "next";
    const ORDER_PREV = "prev";
    const DIRECTION_LEFT = "left";
    const DIRECTION_RIGHT = "right";
    const KEY_TO_DIRECTION = {
        [ARROW_LEFT_KEY]: DIRECTION_RIGHT,
        [ARROW_RIGHT_KEY]: DIRECTION_LEFT,
    };
    const EVENT_SLIDE = `slide${EVENT_KEY$a}`;
    const EVENT_SLID = `slid${EVENT_KEY$a}`;
    const EVENT_KEYDOWN = `keydown${EVENT_KEY$a}`;
    const EVENT_MOUSEENTER = `mouseenter${EVENT_KEY$a}`;
    const EVENT_MOUSELEAVE = `mouseleave${EVENT_KEY$a}`;
    const EVENT_TOUCHSTART = `touchstart${EVENT_KEY$a}`;
    const EVENT_TOUCHMOVE = `touchmove${EVENT_KEY$a}`;
    const EVENT_TOUCHEND = `touchend${EVENT_KEY$a}`;
    const EVENT_POINTERDOWN = `pointerdown${EVENT_KEY$a}`;
    const EVENT_POINTERUP = `pointerup${EVENT_KEY$a}`;
    const EVENT_DRAG_START = `dragstart${EVENT_KEY$a}`;
    const EVENT_LOAD_DATA_API$2 = `load${EVENT_KEY$a}${DATA_API_KEY$6}`;
    const EVENT_CLICK_DATA_API$5 = `click${EVENT_KEY$a}${DATA_API_KEY$6}`;
    const CLASS_NAME_CAROUSEL = "carousel";
    const CLASS_NAME_ACTIVE$2 = "active";
    const CLASS_NAME_SLIDE = "slide";
    const CLASS_NAME_END = "carousel-item-end";
    const CLASS_NAME_START = "carousel-item-start";
    const CLASS_NAME_NEXT = "carousel-item-next";
    const CLASS_NAME_PREV = "carousel-item-prev";
    const CLASS_NAME_POINTER_EVENT = "pointer-event";
    const SELECTOR_ACTIVE$1 = ".active";
    const SELECTOR_ACTIVE_ITEM = ".active.carousel-item";
    const SELECTOR_ITEM = ".carousel-item";
    const SELECTOR_ITEM_IMG = ".carousel-item img";
    const SELECTOR_NEXT_PREV = ".carousel-item-next, .carousel-item-prev";
    const SELECTOR_INDICATORS = ".carousel-indicators";
    const SELECTOR_INDICATOR = "[data-bs-target]";
    const SELECTOR_DATA_SLIDE = "[data-bs-slide], [data-bs-slide-to]";
    const SELECTOR_DATA_RIDE = '[data-bs-ride="carousel"]';
    const POINTER_TYPE_TOUCH = "touch";
    const POINTER_TYPE_PEN = "pen";
    /**
     * ------------------------------------------------------------------------
     * Class Definition
     * ------------------------------------------------------------------------
     */

    class Carousel extends BaseComponent {
        constructor(element, config) {
            super(element);
            this._items = null;
            this._interval = null;
            this._activeElement = null;
            this._isPaused = false;
            this._isSliding = false;
            this.touchTimeout = null;
            this.touchStartX = 0;
            this.touchDeltaX = 0;
            this._config = this._getConfig(config);
            this._indicatorsElement = SelectorEngine.findOne(
                SELECTOR_INDICATORS,
                this._element
            );
            this._touchSupported =
                "ontouchstart" in document.documentElement ||
                navigator.maxTouchPoints > 0;
            this._pointerEvent = Boolean(window.PointerEvent);

            this._addEventListeners();
        } // Getters

        static get Default() {
            return Default$a;
        }

        static get NAME() {
            return NAME$b;
        } // Public

        next() {
            this._slide(ORDER_NEXT);
        }

        nextWhenVisible() {
            // Don't call next when the page isn't visible
            // or the carousel or its parent isn't visible
            if (!document.hidden && isVisible(this._element)) {
                this.next();
            }
        }

        prev() {
            this._slide(ORDER_PREV);
        }

        pause(event) {
            if (!event) {
                this._isPaused = true;
            }

            if (SelectorEngine.findOne(SELECTOR_NEXT_PREV, this._element)) {
                triggerTransitionEnd(this._element);
                this.cycle(true);
            }

            clearInterval(this._interval);
            this._interval = null;
        }

        cycle(event) {
            if (!event) {
                this._isPaused = false;
            }

            if (this._interval) {
                clearInterval(this._interval);
                this._interval = null;
            }

            if (this._config && this._config.interval && !this._isPaused) {
                this._updateInterval();

                this._interval = setInterval(
                    (document.visibilityState
                        ? this.nextWhenVisible
                        : this.next
                    ).bind(this),
                    this._config.interval
                );
            }
        }

        to(index) {
            this._activeElement = SelectorEngine.findOne(
                SELECTOR_ACTIVE_ITEM,
                this._element
            );

            const activeIndex = this._getItemIndex(this._activeElement);

            if (index > this._items.length - 1 || index < 0) {
                return;
            }

            if (this._isSliding) {
                EventHandler.one(this._element, EVENT_SLID, () =>
                    this.to(index)
                );
                return;
            }

            if (activeIndex === index) {
                this.pause();
                this.cycle();
                return;
            }

            const order = index > activeIndex ? ORDER_NEXT : ORDER_PREV;

            this._slide(order, this._items[index]);
        } // Private

        _getConfig(config) {
            config = {
                ...Default$a,
                ...Manipulator.getDataAttributes(this._element),
                ...(typeof config === "object" ? config : {}),
            };
            typeCheckConfig(NAME$b, config, DefaultType$a);
            return config;
        }

        _handleSwipe() {
            const absDeltax = Math.abs(this.touchDeltaX);

            if (absDeltax <= SWIPE_THRESHOLD) {
                return;
            }

            const direction = absDeltax / this.touchDeltaX;
            this.touchDeltaX = 0;

            if (!direction) {
                return;
            }

            this._slide(direction > 0 ? DIRECTION_RIGHT : DIRECTION_LEFT);
        }

        _addEventListeners() {
            if (this._config.keyboard) {
                EventHandler.on(this._element, EVENT_KEYDOWN, (event) =>
                    this._keydown(event)
                );
            }

            if (this._config.pause === "hover") {
                EventHandler.on(this._element, EVENT_MOUSEENTER, (event) =>
                    this.pause(event)
                );
                EventHandler.on(this._element, EVENT_MOUSELEAVE, (event) =>
                    this.cycle(event)
                );
            }

            if (this._config.touch && this._touchSupported) {
                this._addTouchEventListeners();
            }
        }

        _addTouchEventListeners() {
            const hasPointerPenTouch = (event) => {
                return (
                    this._pointerEvent &&
                    (event.pointerType === POINTER_TYPE_PEN ||
                        event.pointerType === POINTER_TYPE_TOUCH)
                );
            };

            const start = (event) => {
                if (hasPointerPenTouch(event)) {
                    this.touchStartX = event.clientX;
                } else if (!this._pointerEvent) {
                    this.touchStartX = event.touches[0].clientX;
                }
            };

            const move = (event) => {
                // ensure swiping with one touch and not pinching
                this.touchDeltaX =
                    event.touches && event.touches.length > 1
                        ? 0
                        : event.touches[0].clientX - this.touchStartX;
            };

            const end = (event) => {
                if (hasPointerPenTouch(event)) {
                    this.touchDeltaX = event.clientX - this.touchStartX;
                }

                this._handleSwipe();

                if (this._config.pause === "hover") {
                    // If it's a touch-enabled device, mouseenter/leave are fired as
                    // part of the mouse compatibility events on first tap - the carousel
                    // would stop cycling until user tapped out of it;
                    // here, we listen for touchend, explicitly pause the carousel
                    // (as if it's the second time we tap on it, mouseenter compat event
                    // is NOT fired) and after a timeout (to allow for mouse compatibility
                    // events to fire) we explicitly restart cycling
                    this.pause();

                    if (this.touchTimeout) {
                        clearTimeout(this.touchTimeout);
                    }

                    this.touchTimeout = setTimeout(
                        (event) => this.cycle(event),
                        TOUCHEVENT_COMPAT_WAIT + this._config.interval
                    );
                }
            };

            SelectorEngine.find(SELECTOR_ITEM_IMG, this._element).forEach(
                (itemImg) => {
                    EventHandler.on(itemImg, EVENT_DRAG_START, (event) =>
                        event.preventDefault()
                    );
                }
            );

            if (this._pointerEvent) {
                EventHandler.on(this._element, EVENT_POINTERDOWN, (event) =>
                    start(event)
                );
                EventHandler.on(this._element, EVENT_POINTERUP, (event) =>
                    end(event)
                );

                this._element.classList.add(CLASS_NAME_POINTER_EVENT);
            } else {
                EventHandler.on(this._element, EVENT_TOUCHSTART, (event) =>
                    start(event)
                );
                EventHandler.on(this._element, EVENT_TOUCHMOVE, (event) =>
                    move(event)
                );
                EventHandler.on(this._element, EVENT_TOUCHEND, (event) =>
                    end(event)
                );
            }
        }

        _keydown(event) {
            if (/input|textarea/i.test(event.target.tagName)) {
                return;
            }

            const direction = KEY_TO_DIRECTION[event.key];

            if (direction) {
                event.preventDefault();

                this._slide(direction);
            }
        }

        _getItemIndex(element) {
            this._items =
                element && element.parentNode
                    ? SelectorEngine.find(SELECTOR_ITEM, element.parentNode)
                    : [];
            return this._items.indexOf(element);
        }

        _getItemByOrder(order, activeElement) {
            const isNext = order === ORDER_NEXT;
            return getNextActiveElement(
                this._items,
                activeElement,
                isNext,
                this._config.wrap
            );
        }

        _triggerSlideEvent(relatedTarget, eventDirectionName) {
            const targetIndex = this._getItemIndex(relatedTarget);

            const fromIndex = this._getItemIndex(
                SelectorEngine.findOne(SELECTOR_ACTIVE_ITEM, this._element)
            );

            return EventHandler.trigger(this._element, EVENT_SLIDE, {
                relatedTarget,
                direction: eventDirectionName,
                from: fromIndex,
                to: targetIndex,
            });
        }

        _setActiveIndicatorElement(element) {
            if (this._indicatorsElement) {
                const activeIndicator = SelectorEngine.findOne(
                    SELECTOR_ACTIVE$1,
                    this._indicatorsElement
                );
                activeIndicator.classList.remove(CLASS_NAME_ACTIVE$2);
                activeIndicator.removeAttribute("aria-current");
                const indicators = SelectorEngine.find(
                    SELECTOR_INDICATOR,
                    this._indicatorsElement
                );

                for (let i = 0; i < indicators.length; i++) {
                    if (
                        Number.parseInt(
                            indicators[i].getAttribute("data-bs-slide-to"),
                            10
                        ) === this._getItemIndex(element)
                    ) {
                        indicators[i].classList.add(CLASS_NAME_ACTIVE$2);
                        indicators[i].setAttribute("aria-current", "true");
                        break;
                    }
                }
            }
        }

        _updateInterval() {
            const element =
                this._activeElement ||
                SelectorEngine.findOne(SELECTOR_ACTIVE_ITEM, this._element);

            if (!element) {
                return;
            }

            const elementInterval = Number.parseInt(
                element.getAttribute("data-bs-interval"),
                10
            );

            if (elementInterval) {
                this._config.defaultInterval =
                    this._config.defaultInterval || this._config.interval;
                this._config.interval = elementInterval;
            } else {
                this._config.interval =
                    this._config.defaultInterval || this._config.interval;
            }
        }

        _slide(directionOrOrder, element) {
            const order = this._directionToOrder(directionOrOrder);

            const activeElement = SelectorEngine.findOne(
                SELECTOR_ACTIVE_ITEM,
                this._element
            );

            const activeElementIndex = this._getItemIndex(activeElement);

            const nextElement =
                element || this._getItemByOrder(order, activeElement);

            const nextElementIndex = this._getItemIndex(nextElement);

            const isCycling = Boolean(this._interval);
            const isNext = order === ORDER_NEXT;
            const directionalClassName = isNext
                ? CLASS_NAME_START
                : CLASS_NAME_END;
            const orderClassName = isNext ? CLASS_NAME_NEXT : CLASS_NAME_PREV;

            const eventDirectionName = this._orderToDirection(order);

            if (
                nextElement &&
                nextElement.classList.contains(CLASS_NAME_ACTIVE$2)
            ) {
                this._isSliding = false;
                return;
            }

            if (this._isSliding) {
                return;
            }

            const slideEvent = this._triggerSlideEvent(
                nextElement,
                eventDirectionName
            );

            if (slideEvent.defaultPrevented) {
                return;
            }

            if (!activeElement || !nextElement) {
                // Some weirdness is happening, so we bail
                return;
            }

            this._isSliding = true;

            if (isCycling) {
                this.pause();
            }

            this._setActiveIndicatorElement(nextElement);

            this._activeElement = nextElement;

            const triggerSlidEvent = () => {
                EventHandler.trigger(this._element, EVENT_SLID, {
                    relatedTarget: nextElement,
                    direction: eventDirectionName,
                    from: activeElementIndex,
                    to: nextElementIndex,
                });
            };

            if (this._element.classList.contains(CLASS_NAME_SLIDE)) {
                nextElement.classList.add(orderClassName);
                reflow(nextElement);
                activeElement.classList.add(directionalClassName);
                nextElement.classList.add(directionalClassName);

                const completeCallBack = () => {
                    nextElement.classList.remove(
                        directionalClassName,
                        orderClassName
                    );
                    nextElement.classList.add(CLASS_NAME_ACTIVE$2);
                    activeElement.classList.remove(
                        CLASS_NAME_ACTIVE$2,
                        orderClassName,
                        directionalClassName
                    );
                    this._isSliding = false;
                    setTimeout(triggerSlidEvent, 0);
                };

                this._queueCallback(completeCallBack, activeElement, true);
            } else {
                activeElement.classList.remove(CLASS_NAME_ACTIVE$2);
                nextElement.classList.add(CLASS_NAME_ACTIVE$2);
                this._isSliding = false;
                triggerSlidEvent();
            }

            if (isCycling) {
                this.cycle();
            }
        }

        _directionToOrder(direction) {
            if (![DIRECTION_RIGHT, DIRECTION_LEFT].includes(direction)) {
                return direction;
            }

            if (isRTL()) {
                return direction === DIRECTION_LEFT ? ORDER_PREV : ORDER_NEXT;
            }

            return direction === DIRECTION_LEFT ? ORDER_NEXT : ORDER_PREV;
        }

        _orderToDirection(order) {
            if (![ORDER_NEXT, ORDER_PREV].includes(order)) {
                return order;
            }

            if (isRTL()) {
                return order === ORDER_PREV ? DIRECTION_LEFT : DIRECTION_RIGHT;
            }

            return order === ORDER_PREV ? DIRECTION_RIGHT : DIRECTION_LEFT;
        } // Static

        static carouselInterface(element, config) {
            const data = Carousel.getOrCreateInstance(element, config);
            let { _config } = data;

            if (typeof config === "object") {
                _config = { ..._config, ...config };
            }

            const action = typeof config === "string" ? config : _config.slide;

            if (typeof config === "number") {
                data.to(config);
            } else if (typeof action === "string") {
                if (typeof data[action] === "undefined") {
                    throw new TypeError(`No method named "${action}"`);
                }

                data[action]();
            } else if (_config.interval && _config.ride) {
                data.pause();
                data.cycle();
            }
        }

        static jQueryInterface(config) {
            return this.each(function () {
                Carousel.carouselInterface(this, config);
            });
        }

        static dataApiClickHandler(event) {
            const target = getElementFromSelector(this);

            if (!target || !target.classList.contains(CLASS_NAME_CAROUSEL)) {
                return;
            }

            const config = {
                ...Manipulator.getDataAttributes(target),
                ...Manipulator.getDataAttributes(this),
            };
            const slideIndex = this.getAttribute("data-bs-slide-to");

            if (slideIndex) {
                config.interval = false;
            }

            Carousel.carouselInterface(target, config);

            if (slideIndex) {
                Carousel.getInstance(target).to(slideIndex);
            }

            event.preventDefault();
        }
    }
    /**
     * ------------------------------------------------------------------------
     * Data Api implementation
     * ------------------------------------------------------------------------
     */

    EventHandler.on(
        document,
        EVENT_CLICK_DATA_API$5,
        SELECTOR_DATA_SLIDE,
        Carousel.dataApiClickHandler
    );
    EventHandler.on(window, EVENT_LOAD_DATA_API$2, () => {
        const carousels = SelectorEngine.find(SELECTOR_DATA_RIDE);

        for (let i = 0, len = carousels.length; i < len; i++) {
            Carousel.carouselInterface(
                carousels[i],
                Carousel.getInstance(carousels[i])
            );
        }
    });
    /**
     * ------------------------------------------------------------------------
     * jQuery
     * ------------------------------------------------------------------------
     * add .Carousel to jQuery only if jQuery is present
     */

    defineJQueryPlugin(Carousel);

    /**
     * --------------------------------------------------------------------------
     * Bootstrap (v5.1.3): collapse.js
     * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
     * --------------------------------------------------------------------------
     */
    /**
     * ------------------------------------------------------------------------
     * Constants
     * ------------------------------------------------------------------------
     */

    const NAME$a = "collapse";
    const DATA_KEY$9 = "bs.collapse";
    const EVENT_KEY$9 = `.${DATA_KEY$9}`;
    const DATA_API_KEY$5 = ".data-api";
    const Default$9 = {
        toggle: true,
        parent: null,
    };
    const DefaultType$9 = {
        toggle: "boolean",
        parent: "(null|element)",
    };
    const EVENT_SHOW$5 = `show${EVENT_KEY$9}`;
    const EVENT_SHOWN$5 = `shown${EVENT_KEY$9}`;
    const EVENT_HIDE$5 = `hide${EVENT_KEY$9}`;
    const EVENT_HIDDEN$5 = `hidden${EVENT_KEY$9}`;
    const EVENT_CLICK_DATA_API$4 = `click${EVENT_KEY$9}${DATA_API_KEY$5}`;
    const CLASS_NAME_SHOW$7 = "show";
    const CLASS_NAME_COLLAPSE = "collapse";
    const CLASS_NAME_COLLAPSING = "collapsing";
    const CLASS_NAME_COLLAPSED = "collapsed";
    const CLASS_NAME_DEEPER_CHILDREN = `:scope .${CLASS_NAME_COLLAPSE} .${CLASS_NAME_COLLAPSE}`;
    const CLASS_NAME_HORIZONTAL = "collapse-horizontal";
    const WIDTH = "width";
    const HEIGHT = "height";
    const SELECTOR_ACTIVES = ".collapse.show, .collapse.collapsing";
    const SELECTOR_DATA_TOGGLE$4 = '[data-bs-toggle="collapse"]';
    /**
     * ------------------------------------------------------------------------
     * Class Definition
     * ------------------------------------------------------------------------
     */

    class Collapse extends BaseComponent {
        constructor(element, config) {
            super(element);
            this._isTransitioning = false;
            this._config = this._getConfig(config);
            this._triggerArray = [];
            const toggleList = SelectorEngine.find(SELECTOR_DATA_TOGGLE$4);

            for (let i = 0, len = toggleList.length; i < len; i++) {
                const elem = toggleList[i];
                const selector = getSelectorFromElement(elem);
                const filterElement = SelectorEngine.find(selector).filter(
                    (foundElem) => foundElem === this._element
                );

                if (selector !== null && filterElement.length) {
                    this._selector = selector;

                    this._triggerArray.push(elem);
                }
            }

            this._initializeChildren();

            if (!this._config.parent) {
                this._addAriaAndCollapsedClass(
                    this._triggerArray,
                    this._isShown()
                );
            }

            if (this._config.toggle) {
                this.toggle();
            }
        } // Getters

        static get Default() {
            return Default$9;
        }

        static get NAME() {
            return NAME$a;
        } // Public

        toggle() {
            if (this._isShown()) {
                this.hide();
            } else {
                this.show();
            }
        }

        show() {
            if (this._isTransitioning || this._isShown()) {
                return;
            }

            let actives = [];
            let activesData;

            if (this._config.parent) {
                const children = SelectorEngine.find(
                    CLASS_NAME_DEEPER_CHILDREN,
                    this._config.parent
                );
                actives = SelectorEngine.find(
                    SELECTOR_ACTIVES,
                    this._config.parent
                ).filter((elem) => !children.includes(elem)); // remove children if greater depth
            }

            const container = SelectorEngine.findOne(this._selector);

            if (actives.length) {
                const tempActiveData = actives.find(
                    (elem) => container !== elem
                );
                activesData = tempActiveData
                    ? Collapse.getInstance(tempActiveData)
                    : null;

                if (activesData && activesData._isTransitioning) {
                    return;
                }
            }

            const startEvent = EventHandler.trigger(
                this._element,
                EVENT_SHOW$5
            );

            if (startEvent.defaultPrevented) {
                return;
            }

            actives.forEach((elemActive) => {
                if (container !== elemActive) {
                    Collapse.getOrCreateInstance(elemActive, {
                        toggle: false,
                    }).hide();
                }

                if (!activesData) {
                    Data.set(elemActive, DATA_KEY$9, null);
                }
            });

            const dimension = this._getDimension();

            this._element.classList.remove(CLASS_NAME_COLLAPSE);

            this._element.classList.add(CLASS_NAME_COLLAPSING);

            this._element.style[dimension] = 0;

            this._addAriaAndCollapsedClass(this._triggerArray, true);

            this._isTransitioning = true;

            const complete = () => {
                this._isTransitioning = false;

                this._element.classList.remove(CLASS_NAME_COLLAPSING);

                this._element.classList.add(
                    CLASS_NAME_COLLAPSE,
                    CLASS_NAME_SHOW$7
                );

                this._element.style[dimension] = "";
                EventHandler.trigger(this._element, EVENT_SHOWN$5);
            };

            const capitalizedDimension =
                dimension[0].toUpperCase() + dimension.slice(1);
            const scrollSize = `scroll${capitalizedDimension}`;

            this._queueCallback(complete, this._element, true);

            this._element.style[dimension] = `${this._element[scrollSize]}px`;
        }

        hide() {
            if (this._isTransitioning || !this._isShown()) {
                return;
            }

            const startEvent = EventHandler.trigger(
                this._element,
                EVENT_HIDE$5
            );

            if (startEvent.defaultPrevented) {
                return;
            }

            const dimension = this._getDimension();

            this._element.style[dimension] = `${
                this._element.getBoundingClientRect()[dimension]
            }px`;
            reflow(this._element);

            this._element.classList.add(CLASS_NAME_COLLAPSING);

            this._element.classList.remove(
                CLASS_NAME_COLLAPSE,
                CLASS_NAME_SHOW$7
            );

            const triggerArrayLength = this._triggerArray.length;

            for (let i = 0; i < triggerArrayLength; i++) {
                const trigger = this._triggerArray[i];
                const elem = getElementFromSelector(trigger);

                if (elem && !this._isShown(elem)) {
                    this._addAriaAndCollapsedClass([trigger], false);
                }
            }

            this._isTransitioning = true;

            const complete = () => {
                this._isTransitioning = false;

                this._element.classList.remove(CLASS_NAME_COLLAPSING);

                this._element.classList.add(CLASS_NAME_COLLAPSE);

                EventHandler.trigger(this._element, EVENT_HIDDEN$5);
            };

            this._element.style[dimension] = "";

            this._queueCallback(complete, this._element, true);
        }

        _isShown(element = this._element) {
            return element.classList.contains(CLASS_NAME_SHOW$7);
        } // Private

        _getConfig(config) {
            config = {
                ...Default$9,
                ...Manipulator.getDataAttributes(this._element),
                ...config,
            };
            config.toggle = Boolean(config.toggle); // Coerce string values

            config.parent = getElement(config.parent);
            typeCheckConfig(NAME$a, config, DefaultType$9);
            return config;
        }

        _getDimension() {
            return this._element.classList.contains(CLASS_NAME_HORIZONTAL)
                ? WIDTH
                : HEIGHT;
        }

        _initializeChildren() {
            if (!this._config.parent) {
                return;
            }

            const children = SelectorEngine.find(
                CLASS_NAME_DEEPER_CHILDREN,
                this._config.parent
            );
            SelectorEngine.find(SELECTOR_DATA_TOGGLE$4, this._config.parent)
                .filter((elem) => !children.includes(elem))
                .forEach((element) => {
                    const selected = getElementFromSelector(element);

                    if (selected) {
                        this._addAriaAndCollapsedClass(
                            [element],
                            this._isShown(selected)
                        );
                    }
                });
        }

        _addAriaAndCollapsedClass(triggerArray, isOpen) {
            if (!triggerArray.length) {
                return;
            }

            triggerArray.forEach((elem) => {
                if (isOpen) {
                    elem.classList.remove(CLASS_NAME_COLLAPSED);
                } else {
                    elem.classList.add(CLASS_NAME_COLLAPSED);
                }

                elem.setAttribute("aria-expanded", isOpen);
            });
        } // Static

        static jQueryInterface(config) {
            return this.each(function () {
                const _config = {};

                if (typeof config === "string" && /show|hide/.test(config)) {
                    _config.toggle = false;
                }

                const data = Collapse.getOrCreateInstance(this, _config);

                if (typeof config === "string") {
                    if (typeof data[config] === "undefined") {
                        throw new TypeError(`No method named "${config}"`);
                    }

                    data[config]();
                }
            });
        }
    }
    /**
     * ------------------------------------------------------------------------
     * Data Api implementation
     * ------------------------------------------------------------------------
     */

    EventHandler.on(
        document,
        EVENT_CLICK_DATA_API$4,
        SELECTOR_DATA_TOGGLE$4,
        function (event) {
            // preventDefault only for <a> elements (which change the URL) not inside the collapsible element
            if (
                event.target.tagName === "A" ||
                (event.delegateTarget && event.delegateTarget.tagName === "A")
            ) {
                event.preventDefault();
            }

            const selector = getSelectorFromElement(this);
            const selectorElements = SelectorEngine.find(selector);
            selectorElements.forEach((element) => {
                Collapse.getOrCreateInstance(element, {
                    toggle: false,
                }).toggle();
            });
        }
    );
    /**
     * ------------------------------------------------------------------------
     * jQuery
     * ------------------------------------------------------------------------
     * add .Collapse to jQuery only if jQuery is present
     */

    defineJQueryPlugin(Collapse);

    var top = "top";
    var bottom = "bottom";
    var right = "right";
    var left = "left";
    var auto = "auto";
    var basePlacements = [top, bottom, right, left];
    var start = "start";
    var end = "end";
    var clippingParents = "clippingParents";
    var viewport = "viewport";
    var popper = "popper";
    var reference = "reference";
    var variationPlacements = /*#__PURE__*/ basePlacements.reduce(function (
        acc,
        placement
    ) {
        return acc.concat([placement + "-" + start, placement + "-" + end]);
    },
    []);
    var placements = /*#__PURE__*/ []
        .concat(basePlacements, [auto])
        .reduce(function (acc, placement) {
            return acc.concat([
                placement,
                placement + "-" + start,
                placement + "-" + end,
            ]);
        }, []); // modifiers that need to read the DOM

    var beforeRead = "beforeRead";
    var read = "read";
    var afterRead = "afterRead"; // pure-logic modifiers

    var beforeMain = "beforeMain";
    var main = "main";
    var afterMain = "afterMain"; // modifier with the purpose to write to the DOM (or write into a framework state)

    var beforeWrite = "beforeWrite";
    var write = "write";
    var afterWrite = "afterWrite";
    var modifierPhases = [
        beforeRead,
        read,
        afterRead,
        beforeMain,
        main,
        afterMain,
        beforeWrite,
        write,
        afterWrite,
    ];

    function getNodeName(element) {
        return element ? (element.nodeName || "").toLowerCase() : null;
    }

    function getWindow(node) {
        if (node == null) {
            return window;
        }

        if (node.toString() !== "[object Window]") {
            var ownerDocument = node.ownerDocument;
            return ownerDocument ? ownerDocument.defaultView || window : window;
        }

        return node;
    }

    function isElement(node) {
        var OwnElement = getWindow(node).Element;
        return node instanceof OwnElement || node instanceof Element;
    }

    function isHTMLElement(node) {
        var OwnElement = getWindow(node).HTMLElement;
        return node instanceof OwnElement || node instanceof HTMLElement;
    }

    function isShadowRoot(node) {
        // IE 11 has no ShadowRoot
        if (typeof ShadowRoot === "undefined") {
            return false;
        }

        var OwnElement = getWindow(node).ShadowRoot;
        return node instanceof OwnElement || node instanceof ShadowRoot;
    }

    // and applies them to the HTMLElements such as popper and arrow

    function applyStyles(_ref) {
        var state = _ref.state;
        Object.keys(state.elements).forEach(function (name) {
            var style = state.styles[name] || {};
            var attributes = state.attributes[name] || {};
            var element = state.elements[name]; // arrow is optional + virtual elements

            if (!isHTMLElement(element) || !getNodeName(element)) {
                return;
            } // Flow doesn't support to extend this property, but it's the most
            // effective way to apply styles to an HTMLElement
            // $FlowFixMe[cannot-write]

            Object.assign(element.style, style);
            Object.keys(attributes).forEach(function (name) {
                var value = attributes[name];

                if (value === false) {
                    element.removeAttribute(name);
                } else {
                    element.setAttribute(name, value === true ? "" : value);
                }
            });
        });
    }

    function effect$2(_ref2) {
        var state = _ref2.state;
        var initialStyles = {
            popper: {
                position: state.options.strategy,
                left: "0",
                top: "0",
                margin: "0",
            },
            arrow: {
                position: "absolute",
            },
            reference: {},
        };
        Object.assign(state.elements.popper.style, initialStyles.popper);
        state.styles = initialStyles;

        if (state.elements.arrow) {
            Object.assign(state.elements.arrow.style, initialStyles.arrow);
        }

        return function () {
            Object.keys(state.elements).forEach(function (name) {
                var element = state.elements[name];
                var attributes = state.attributes[name] || {};
                var styleProperties = Object.keys(
                    state.styles.hasOwnProperty(name)
                        ? state.styles[name]
                        : initialStyles[name]
                ); // Set all values to an empty string to unset them

                var style = styleProperties.reduce(function (style, property) {
                    style[property] = "";
                    return style;
                }, {}); // arrow is optional + virtual elements

                if (!isHTMLElement(element) || !getNodeName(element)) {
                    return;
                }

                Object.assign(element.style, style);
                Object.keys(attributes).forEach(function (attribute) {
                    element.removeAttribute(attribute);
                });
            });
        };
    } // eslint-disable-next-line import/no-unused-modules

    const applyStyles$1 = {
        name: "applyStyles",
        enabled: true,
        phase: "write",
        fn: applyStyles,
        effect: effect$2,
        requires: ["computeStyles"],
    };

    function getBasePlacement(placement) {
        return placement.split("-")[0];
    }

    // import { isHTMLElement } from './instanceOf';
    function getBoundingClientRect(
        element, // eslint-disable-next-line unused-imports/no-unused-vars
        includeScale
    ) {
        var rect = element.getBoundingClientRect();
        var scaleX = 1;
        var scaleY = 1; // FIXME:
        // `offsetWidth` returns an integer while `getBoundingClientRect`
        // returns a float. This results in `scaleX` or `scaleY` being
        // non-1 when it should be for elements that aren't a full pixel in
        // width or height.
        // if (isHTMLElement(element) && includeScale) {
        //   const offsetHeight = element.offsetHeight;
        //   const offsetWidth = element.offsetWidth;
        //   // Do not attempt to divide by 0, otherwise we get `Infinity` as scale
        //   // Fallback to 1 in case both values are `0`
        //   if (offsetWidth > 0) {
        //     scaleX = rect.width / offsetWidth || 1;
        //   }
        //   if (offsetHeight > 0) {
        //     scaleY = rect.height / offsetHeight || 1;
        //   }
        // }

        return {
            width: rect.width / scaleX,
            height: rect.height / scaleY,
            top: rect.top / scaleY,
            right: rect.right / scaleX,
            bottom: rect.bottom / scaleY,
            left: rect.left / scaleX,
            x: rect.left / scaleX,
            y: rect.top / scaleY,
        };
    }

    // means it doesn't take into account transforms.

    function getLayoutRect(element) {
        var clientRect = getBoundingClientRect(element); // Use the clientRect sizes if it's not been transformed.
        // Fixes https://github.com/popperjs/popper-core/issues/1223

        var width = element.offsetWidth;
        var height = element.offsetHeight;

        if (Math.abs(clientRect.width - width) <= 1) {
            width = clientRect.width;
        }

        if (Math.abs(clientRect.height - height) <= 1) {
            height = clientRect.height;
        }

        return {
            x: element.offsetLeft,
            y: element.offsetTop,
            width: width,
            height: height,
        };
    }

    function contains(parent, child) {
        var rootNode = child.getRootNode && child.getRootNode(); // First, attempt with faster native method

        if (parent.contains(child)) {
            return true;
        } // then fallback to custom implementation with Shadow DOM support
        else if (rootNode && isShadowRoot(rootNode)) {
            var next = child;

            do {
                if (next && parent.isSameNode(next)) {
                    return true;
                } // $FlowFixMe[prop-missing]: need a better way to handle this...

                next = next.parentNode || next.host;
            } while (next);
        } // Give up, the result is false

        return false;
    }

    function getComputedStyle$1(element) {
        return getWindow(element).getComputedStyle(element);
    }

    function isTableElement(element) {
        return ["table", "td", "th"].indexOf(getNodeName(element)) >= 0;
    }

    function getDocumentElement(element) {
        // $FlowFixMe[incompatible-return]: assume body is always available
        return (
            (isElement(element)
                ? element.ownerDocument // $FlowFixMe[prop-missing]
                : element.document) || window.document
        ).documentElement;
    }

    function getParentNode(element) {
        if (getNodeName(element) === "html") {
            return element;
        }

        return (
            // this is a quicker (but less type safe) way to save quite some bytes from the bundle
            // $FlowFixMe[incompatible-return]
            // $FlowFixMe[prop-missing]
            element.assignedSlot || // step into the shadow DOM of the parent of a slotted node
            element.parentNode || // DOM Element detected
            (isShadowRoot(element) ? element.host : null) || // ShadowRoot detected
            // $FlowFixMe[incompatible-call]: HTMLElement is a Node
            getDocumentElement(element) // fallback
        );
    }

    function getTrueOffsetParent(element) {
        if (
            !isHTMLElement(element) || // https://github.com/popperjs/popper-core/issues/837
            getComputedStyle$1(element).position === "fixed"
        ) {
            return null;
        }

        return element.offsetParent;
    } // `.offsetParent` reports `null` for fixed elements, while absolute elements
    // return the containing block

    function getContainingBlock(element) {
        var isFirefox =
            navigator.userAgent.toLowerCase().indexOf("firefox") !== -1;
        var isIE = navigator.userAgent.indexOf("Trident") !== -1;

        if (isIE && isHTMLElement(element)) {
            // In IE 9, 10 and 11 fixed elements containing block is always established by the viewport
            var elementCss = getComputedStyle$1(element);

            if (elementCss.position === "fixed") {
                return null;
            }
        }

        var currentNode = getParentNode(element);

        while (
            isHTMLElement(currentNode) &&
            ["html", "body"].indexOf(getNodeName(currentNode)) < 0
        ) {
            var css = getComputedStyle$1(currentNode); // This is non-exhaustive but covers the most common CSS properties that
            // create a containing block.
            // https://developer.mozilla.org/en-US/docs/Web/CSS/Containing_block#identifying_the_containing_block

            if (
                css.transform !== "none" ||
                css.perspective !== "none" ||
                css.contain === "paint" ||
                ["transform", "perspective"].indexOf(css.willChange) !== -1 ||
                (isFirefox && css.willChange === "filter") ||
                (isFirefox && css.filter && css.filter !== "none")
            ) {
                return currentNode;
            } else {
                currentNode = currentNode.parentNode;
            }
        }

        return null;
    } // Gets the closest ancestor positioned element. Handles some edge cases,
    // such as table ancestors and cross browser bugs.

    function getOffsetParent(element) {
        var window = getWindow(element);
        var offsetParent = getTrueOffsetParent(element);

        while (
            offsetParent &&
            isTableElement(offsetParent) &&
            getComputedStyle$1(offsetParent).position === "static"
        ) {
            offsetParent = getTrueOffsetParent(offsetParent);
        }

        if (
            offsetParent &&
            (getNodeName(offsetParent) === "html" ||
                (getNodeName(offsetParent) === "body" &&
                    getComputedStyle$1(offsetParent).position === "static"))
        ) {
            return window;
        }

        return offsetParent || getContainingBlock(element) || window;
    }

    function getMainAxisFromPlacement(placement) {
        return ["top", "bottom"].indexOf(placement) >= 0 ? "x" : "y";
    }

    var max = Math.max;
    var min = Math.min;
    var round = Math.round;

    function within(min$1, value, max$1) {
        return max(min$1, min(value, max$1));
    }

    function getFreshSideObject() {
        return {
            top: 0,
            right: 0,
            bottom: 0,
            left: 0,
        };
    }

    function mergePaddingObject(paddingObject) {
        return Object.assign({}, getFreshSideObject(), paddingObject);
    }

    function expandToHashMap(value, keys) {
        return keys.reduce(function (hashMap, key) {
            hashMap[key] = value;
            return hashMap;
        }, {});
    }

    var toPaddingObject = function toPaddingObject(padding, state) {
        padding =
            typeof padding === "function"
                ? padding(
                      Object.assign({}, state.rects, {
                          placement: state.placement,
                      })
                  )
                : padding;
        return mergePaddingObject(
            typeof padding !== "number"
                ? padding
                : expandToHashMap(padding, basePlacements)
        );
    };

    function arrow(_ref) {
        var _state$modifiersData$;

        var state = _ref.state,
            name = _ref.name,
            options = _ref.options;
        var arrowElement = state.elements.arrow;
        var popperOffsets = state.modifiersData.popperOffsets;
        var basePlacement = getBasePlacement(state.placement);
        var axis = getMainAxisFromPlacement(basePlacement);
        var isVertical = [left, right].indexOf(basePlacement) >= 0;
        var len = isVertical ? "height" : "width";

        if (!arrowElement || !popperOffsets) {
            return;
        }

        var paddingObject = toPaddingObject(options.padding, state);
        var arrowRect = getLayoutRect(arrowElement);
        var minProp = axis === "y" ? top : left;
        var maxProp = axis === "y" ? bottom : right;
        var endDiff =
            state.rects.reference[len] +
            state.rects.reference[axis] -
            popperOffsets[axis] -
            state.rects.popper[len];
        var startDiff = popperOffsets[axis] - state.rects.reference[axis];
        var arrowOffsetParent = getOffsetParent(arrowElement);
        var clientSize = arrowOffsetParent
            ? axis === "y"
                ? arrowOffsetParent.clientHeight || 0
                : arrowOffsetParent.clientWidth || 0
            : 0;
        var centerToReference = endDiff / 2 - startDiff / 2; // Make sure the arrow doesn't overflow the popper if the center point is
        // outside of the popper bounds

        var min = paddingObject[minProp];
        var max = clientSize - arrowRect[len] - paddingObject[maxProp];
        var center = clientSize / 2 - arrowRect[len] / 2 + centerToReference;
        var offset = within(min, center, max); // Prevents breaking syntax highlighting...

        var axisProp = axis;
        state.modifiersData[name] =
            ((_state$modifiersData$ = {}),
            (_state$modifiersData$[axisProp] = offset),
            (_state$modifiersData$.centerOffset = offset - center),
            _state$modifiersData$);
    }

    function effect$1(_ref2) {
        var state = _ref2.state,
            options = _ref2.options;
        var _options$element = options.element,
            arrowElement =
                _options$element === void 0
                    ? "[data-popper-arrow]"
                    : _options$element;

        if (arrowElement == null) {
            return;
        } // CSS selector

        if (typeof arrowElement === "string") {
            arrowElement = state.elements.popper.querySelector(arrowElement);

            if (!arrowElement) {
                return;
            }
        }

        if (!contains(state.elements.popper, arrowElement)) {
            return;
        }

        state.elements.arrow = arrowElement;
    } // eslint-disable-next-line import/no-unused-modules

    const arrow$1 = {
        name: "arrow",
        enabled: true,
        phase: "main",
        fn: arrow,
        effect: effect$1,
        requires: ["popperOffsets"],
        requiresIfExists: ["preventOverflow"],
    };

    function getVariation(placement) {
        return placement.split("-")[1];
    }

    var unsetSides = {
        top: "auto",
        right: "auto",
        bottom: "auto",
        left: "auto",
    }; // Round the offsets to the nearest suitable subpixel based on the DPR.
    // Zooming can change the DPR, but it seems to report a value that will
    // cleanly divide the values into the appropriate subpixels.

    function roundOffsetsByDPR(_ref) {
        var x = _ref.x,
            y = _ref.y;
        var win = window;
        var dpr = win.devicePixelRatio || 1;
        return {
            x: round(round(x * dpr) / dpr) || 0,
            y: round(round(y * dpr) / dpr) || 0,
        };
    }

    function mapToStyles(_ref2) {
        var _Object$assign2;

        var popper = _ref2.popper,
            popperRect = _ref2.popperRect,
            placement = _ref2.placement,
            variation = _ref2.variation,
            offsets = _ref2.offsets,
            position = _ref2.position,
            gpuAcceleration = _ref2.gpuAcceleration,
            adaptive = _ref2.adaptive,
            roundOffsets = _ref2.roundOffsets;

        var _ref3 =
                roundOffsets === true
                    ? roundOffsetsByDPR(offsets)
                    : typeof roundOffsets === "function"
                    ? roundOffsets(offsets)
                    : offsets,
            _ref3$x = _ref3.x,
            x = _ref3$x === void 0 ? 0 : _ref3$x,
            _ref3$y = _ref3.y,
            y = _ref3$y === void 0 ? 0 : _ref3$y;

        var hasX = offsets.hasOwnProperty("x");
        var hasY = offsets.hasOwnProperty("y");
        var sideX = left;
        var sideY = top;
        var win = window;

        if (adaptive) {
            var offsetParent = getOffsetParent(popper);
            var heightProp = "clientHeight";
            var widthProp = "clientWidth";

            if (offsetParent === getWindow(popper)) {
                offsetParent = getDocumentElement(popper);

                if (
                    getComputedStyle$1(offsetParent).position !== "static" &&
                    position === "absolute"
                ) {
                    heightProp = "scrollHeight";
                    widthProp = "scrollWidth";
                }
            } // $FlowFixMe[incompatible-cast]: force type refinement, we compare offsetParent with window above, but Flow doesn't detect it

            offsetParent = offsetParent;

            if (
                placement === top ||
                ((placement === left || placement === right) &&
                    variation === end)
            ) {
                sideY = bottom; // $FlowFixMe[prop-missing]

                y -= offsetParent[heightProp] - popperRect.height;
                y *= gpuAcceleration ? 1 : -1;
            }

            if (
                placement === left ||
                ((placement === top || placement === bottom) &&
                    variation === end)
            ) {
                sideX = right; // $FlowFixMe[prop-missing]

                x -= offsetParent[widthProp] - popperRect.width;
                x *= gpuAcceleration ? 1 : -1;
            }
        }

        var commonStyles = Object.assign(
            {
                position: position,
            },
            adaptive && unsetSides
        );

        if (gpuAcceleration) {
            var _Object$assign;

            return Object.assign(
                {},
                commonStyles,
                ((_Object$assign = {}),
                (_Object$assign[sideY] = hasY ? "0" : ""),
                (_Object$assign[sideX] = hasX ? "0" : ""),
                (_Object$assign.transform =
                    (win.devicePixelRatio || 1) <= 1
                        ? "translate(" + x + "px, " + y + "px)"
                        : "translate3d(" + x + "px, " + y + "px, 0)"),
                _Object$assign)
            );
        }

        return Object.assign(
            {},
            commonStyles,
            ((_Object$assign2 = {}),
            (_Object$assign2[sideY] = hasY ? y + "px" : ""),
            (_Object$assign2[sideX] = hasX ? x + "px" : ""),
            (_Object$assign2.transform = ""),
            _Object$assign2)
        );
    }

    function computeStyles(_ref4) {
        var state = _ref4.state,
            options = _ref4.options;
        var _options$gpuAccelerat = options.gpuAcceleration,
            gpuAcceleration =
                _options$gpuAccelerat === void 0 ? true : _options$gpuAccelerat,
            _options$adaptive = options.adaptive,
            adaptive = _options$adaptive === void 0 ? true : _options$adaptive,
            _options$roundOffsets = options.roundOffsets,
            roundOffsets =
                _options$roundOffsets === void 0 ? true : _options$roundOffsets;

        var commonStyles = {
            placement: getBasePlacement(state.placement),
            variation: getVariation(state.placement),
            popper: state.elements.popper,
            popperRect: state.rects.popper,
            gpuAcceleration: gpuAcceleration,
        };

        if (state.modifiersData.popperOffsets != null) {
            state.styles.popper = Object.assign(
                {},
                state.styles.popper,
                mapToStyles(
                    Object.assign({}, commonStyles, {
                        offsets: state.modifiersData.popperOffsets,
                        position: state.options.strategy,
                        adaptive: adaptive,
                        roundOffsets: roundOffsets,
                    })
                )
            );
        }

        if (state.modifiersData.arrow != null) {
            state.styles.arrow = Object.assign(
                {},
                state.styles.arrow,
                mapToStyles(
                    Object.assign({}, commonStyles, {
                        offsets: state.modifiersData.arrow,
                        position: "absolute",
                        adaptive: false,
                        roundOffsets: roundOffsets,
                    })
                )
            );
        }

        state.attributes.popper = Object.assign({}, state.attributes.popper, {
            "data-popper-placement": state.placement,
        });
    } // eslint-disable-next-line import/no-unused-modules

    const computeStyles$1 = {
        name: "computeStyles",
        enabled: true,
        phase: "beforeWrite",
        fn: computeStyles,
        data: {},
    };

    var passive = {
        passive: true,
    };

    function effect(_ref) {
        var state = _ref.state,
            instance = _ref.instance,
            options = _ref.options;
        var _options$scroll = options.scroll,
            scroll = _options$scroll === void 0 ? true : _options$scroll,
            _options$resize = options.resize,
            resize = _options$resize === void 0 ? true : _options$resize;
        var window = getWindow(state.elements.popper);
        var scrollParents = [].concat(
            state.scrollParents.reference,
            state.scrollParents.popper
        );

        if (scroll) {
            scrollParents.forEach(function (scrollParent) {
                scrollParent.addEventListener(
                    "scroll",
                    instance.update,
                    passive
                );
            });
        }

        if (resize) {
            window.addEventListener("resize", instance.update, passive);
        }

        return function () {
            if (scroll) {
                scrollParents.forEach(function (scrollParent) {
                    scrollParent.removeEventListener(
                        "scroll",
                        instance.update,
                        passive
                    );
                });
            }

            if (resize) {
                window.removeEventListener("resize", instance.update, passive);
            }
        };
    } // eslint-disable-next-line import/no-unused-modules

    const eventListeners = {
        name: "eventListeners",
        enabled: true,
        phase: "write",
        fn: function fn() {},
        effect: effect,
        data: {},
    };

    var hash$1 = {
        left: "right",
        right: "left",
        bottom: "top",
        top: "bottom",
    };
    function getOppositePlacement(placement) {
        return placement.replace(/left|right|bottom|top/g, function (matched) {
            return hash$1[matched];
        });
    }

    var hash = {
        start: "end",
        end: "start",
    };
    function getOppositeVariationPlacement(placement) {
        return placement.replace(/start|end/g, function (matched) {
            return hash[matched];
        });
    }

    function getWindowScroll(node) {
        var win = getWindow(node);
        var scrollLeft = win.pageXOffset;
        var scrollTop = win.pageYOffset;
        return {
            scrollLeft: scrollLeft,
            scrollTop: scrollTop,
        };
    }

    function getWindowScrollBarX(element) {
        // If <html> has a CSS width greater than the viewport, then this will be
        // incorrect for RTL.
        // Popper 1 is broken in this case and never had a bug report so let's assume
        // it's not an issue. I don't think anyone ever specifies width on <html>
        // anyway.
        // Browsers where the left scrollbar doesn't cause an issue report `0` for
        // this (e.g. Edge 2019, IE11, Safari)
        return (
            getBoundingClientRect(getDocumentElement(element)).left +
            getWindowScroll(element).scrollLeft
        );
    }

    function getViewportRect(element) {
        var win = getWindow(element);
        var html = getDocumentElement(element);
        var visualViewport = win.visualViewport;
        var width = html.clientWidth;
        var height = html.clientHeight;
        var x = 0;
        var y = 0; // NB: This isn't supported on iOS <= 12. If the keyboard is open, the popper
        // can be obscured underneath it.
        // Also, `html.clientHeight` adds the bottom bar height in Safari iOS, even
        // if it isn't open, so if this isn't available, the popper will be detected
        // to overflow the bottom of the screen too early.

        if (visualViewport) {
            width = visualViewport.width;
            height = visualViewport.height; // Uses Layout Viewport (like Chrome; Safari does not currently)
            // In Chrome, it returns a value very close to 0 (+/-) but contains rounding
            // errors due to floating point numbers, so we need to check precision.
            // Safari returns a number <= 0, usually < -1 when pinch-zoomed
            // Feature detection fails in mobile emulation mode in Chrome.
            // Math.abs(win.innerWidth / visualViewport.scale - visualViewport.width) <
            // 0.001
            // Fallback here: "Not Safari" userAgent

            if (!/^((?!chrome|android).)*safari/i.test(navigator.userAgent)) {
                x = visualViewport.offsetLeft;
                y = visualViewport.offsetTop;
            }
        }

        return {
            width: width,
            height: height,
            x: x + getWindowScrollBarX(element),
            y: y,
        };
    }

    // of the `<html>` and `<body>` rect bounds if horizontally scrollable

    function getDocumentRect(element) {
        var _element$ownerDocumen;

        var html = getDocumentElement(element);
        var winScroll = getWindowScroll(element);
        var body =
            (_element$ownerDocumen = element.ownerDocument) == null
                ? void 0
                : _element$ownerDocumen.body;
        var width = max(
            html.scrollWidth,
            html.clientWidth,
            body ? body.scrollWidth : 0,
            body ? body.clientWidth : 0
        );
        var height = max(
            html.scrollHeight,
            html.clientHeight,
            body ? body.scrollHeight : 0,
            body ? body.clientHeight : 0
        );
        var x = -winScroll.scrollLeft + getWindowScrollBarX(element);
        var y = -winScroll.scrollTop;

        if (getComputedStyle$1(body || html).direction === "rtl") {
            x += max(html.clientWidth, body ? body.clientWidth : 0) - width;
        }

        return {
            width: width,
            height: height,
            x: x,
            y: y,
        };
    }

    function isScrollParent(element) {
        // Firefox wants us to check `-x` and `-y` variations as well
        var _getComputedStyle = getComputedStyle$1(element),
            overflow = _getComputedStyle.overflow,
            overflowX = _getComputedStyle.overflowX,
            overflowY = _getComputedStyle.overflowY;

        return /auto|scroll|overlay|hidden/.test(
            overflow + overflowY + overflowX
        );
    }

    function getScrollParent(node) {
        if (["html", "body", "#document"].indexOf(getNodeName(node)) >= 0) {
            // $FlowFixMe[incompatible-return]: assume body is always available
            return node.ownerDocument.body;
        }

        if (isHTMLElement(node) && isScrollParent(node)) {
            return node;
        }

        return getScrollParent(getParentNode(node));
    }

    /*
  given a DOM element, return the list of all scroll parents, up the list of ancesors
  until we get to the top window object. This list is what we attach scroll listeners
  to, because if any of these parent elements scroll, we'll need to re-calculate the
  reference element's position.
  */

    function listScrollParents(element, list) {
        var _element$ownerDocumen;

        if (list === void 0) {
            list = [];
        }

        var scrollParent = getScrollParent(element);
        var isBody =
            scrollParent ===
            ((_element$ownerDocumen = element.ownerDocument) == null
                ? void 0
                : _element$ownerDocumen.body);
        var win = getWindow(scrollParent);
        var target = isBody
            ? [win].concat(
                  win.visualViewport || [],
                  isScrollParent(scrollParent) ? scrollParent : []
              )
            : scrollParent;
        var updatedList = list.concat(target);
        return isBody
            ? updatedList // $FlowFixMe[incompatible-call]: isBody tells us target will be an HTMLElement here
            : updatedList.concat(listScrollParents(getParentNode(target)));
    }

    function rectToClientRect(rect) {
        return Object.assign({}, rect, {
            left: rect.x,
            top: rect.y,
            right: rect.x + rect.width,
            bottom: rect.y + rect.height,
        });
    }

    function getInnerBoundingClientRect(element) {
        var rect = getBoundingClientRect(element);
        rect.top = rect.top + element.clientTop;
        rect.left = rect.left + element.clientLeft;
        rect.bottom = rect.top + element.clientHeight;
        rect.right = rect.left + element.clientWidth;
        rect.width = element.clientWidth;
        rect.height = element.clientHeight;
        rect.x = rect.left;
        rect.y = rect.top;
        return rect;
    }

    function getClientRectFromMixedType(element, clippingParent) {
        return clippingParent === viewport
            ? rectToClientRect(getViewportRect(element))
            : isHTMLElement(clippingParent)
            ? getInnerBoundingClientRect(clippingParent)
            : rectToClientRect(getDocumentRect(getDocumentElement(element)));
    } // A "clipping parent" is an overflowable container with the characteristic of
    // clipping (or hiding) overflowing elements with a position different from
    // `initial`

    function getClippingParents(element) {
        var clippingParents = listScrollParents(getParentNode(element));
        var canEscapeClipping =
            ["absolute", "fixed"].indexOf(
                getComputedStyle$1(element).position
            ) >= 0;
        var clipperElement =
            canEscapeClipping && isHTMLElement(element)
                ? getOffsetParent(element)
                : element;

        if (!isElement(clipperElement)) {
            return [];
        } // $FlowFixMe[incompatible-return]: https://github.com/facebook/flow/issues/1414

        return clippingParents.filter(function (clippingParent) {
            return (
                isElement(clippingParent) &&
                contains(clippingParent, clipperElement) &&
                getNodeName(clippingParent) !== "body"
            );
        });
    } // Gets the maximum area that the element is visible in due to any number of
    // clipping parents

    function getClippingRect(element, boundary, rootBoundary) {
        var mainClippingParents =
            boundary === "clippingParents"
                ? getClippingParents(element)
                : [].concat(boundary);
        var clippingParents = [].concat(mainClippingParents, [rootBoundary]);
        var firstClippingParent = clippingParents[0];
        var clippingRect = clippingParents.reduce(function (
            accRect,
            clippingParent
        ) {
            var rect = getClientRectFromMixedType(element, clippingParent);
            accRect.top = max(rect.top, accRect.top);
            accRect.right = min(rect.right, accRect.right);
            accRect.bottom = min(rect.bottom, accRect.bottom);
            accRect.left = max(rect.left, accRect.left);
            return accRect;
        },
        getClientRectFromMixedType(element, firstClippingParent));
        clippingRect.width = clippingRect.right - clippingRect.left;
        clippingRect.height = clippingRect.bottom - clippingRect.top;
        clippingRect.x = clippingRect.left;
        clippingRect.y = clippingRect.top;
        return clippingRect;
    }

    function computeOffsets(_ref) {
        var reference = _ref.reference,
            element = _ref.element,
            placement = _ref.placement;
        var basePlacement = placement ? getBasePlacement(placement) : null;
        var variation = placement ? getVariation(placement) : null;
        var commonX = reference.x + reference.width / 2 - element.width / 2;
        var commonY = reference.y + reference.height / 2 - element.height / 2;
        var offsets;

        switch (basePlacement) {
            case top:
                offsets = {
                    x: commonX,
                    y: reference.y - element.height,
                };
                break;

            case bottom:
                offsets = {
                    x: commonX,
                    y: reference.y + reference.height,
                };
                break;

            case right:
                offsets = {
                    x: reference.x + reference.width,
                    y: commonY,
                };
                break;

            case left:
                offsets = {
                    x: reference.x - element.width,
                    y: commonY,
                };
                break;

            default:
                offsets = {
                    x: reference.x,
                    y: reference.y,
                };
        }

        var mainAxis = basePlacement
            ? getMainAxisFromPlacement(basePlacement)
            : null;

        if (mainAxis != null) {
            var len = mainAxis === "y" ? "height" : "width";

            switch (variation) {
                case start:
                    offsets[mainAxis] =
                        offsets[mainAxis] -
                        (reference[len] / 2 - element[len] / 2);
                    break;

                case end:
                    offsets[mainAxis] =
                        offsets[mainAxis] +
                        (reference[len] / 2 - element[len] / 2);
                    break;
            }
        }

        return offsets;
    }

    function detectOverflow(state, options) {
        if (options === void 0) {
            options = {};
        }

        var _options = options,
            _options$placement = _options.placement,
            placement =
                _options$placement === void 0
                    ? state.placement
                    : _options$placement,
            _options$boundary = _options.boundary,
            boundary =
                _options$boundary === void 0
                    ? clippingParents
                    : _options$boundary,
            _options$rootBoundary = _options.rootBoundary,
            rootBoundary =
                _options$rootBoundary === void 0
                    ? viewport
                    : _options$rootBoundary,
            _options$elementConte = _options.elementContext,
            elementContext =
                _options$elementConte === void 0
                    ? popper
                    : _options$elementConte,
            _options$altBoundary = _options.altBoundary,
            altBoundary =
                _options$altBoundary === void 0 ? false : _options$altBoundary,
            _options$padding = _options.padding,
            padding = _options$padding === void 0 ? 0 : _options$padding;
        var paddingObject = mergePaddingObject(
            typeof padding !== "number"
                ? padding
                : expandToHashMap(padding, basePlacements)
        );
        var altContext = elementContext === popper ? reference : popper;
        var popperRect = state.rects.popper;
        var element = state.elements[altBoundary ? altContext : elementContext];
        var clippingClientRect = getClippingRect(
            isElement(element)
                ? element
                : element.contextElement ||
                      getDocumentElement(state.elements.popper),
            boundary,
            rootBoundary
        );
        var referenceClientRect = getBoundingClientRect(
            state.elements.reference
        );
        var popperOffsets = computeOffsets({
            reference: referenceClientRect,
            element: popperRect,
            strategy: "absolute",
            placement: placement,
        });
        var popperClientRect = rectToClientRect(
            Object.assign({}, popperRect, popperOffsets)
        );
        var elementClientRect =
            elementContext === popper ? popperClientRect : referenceClientRect; // positive = overflowing the clipping rect
        // 0 or negative = within the clipping rect

        var overflowOffsets = {
            top:
                clippingClientRect.top -
                elementClientRect.top +
                paddingObject.top,
            bottom:
                elementClientRect.bottom -
                clippingClientRect.bottom +
                paddingObject.bottom,
            left:
                clippingClientRect.left -
                elementClientRect.left +
                paddingObject.left,
            right:
                elementClientRect.right -
                clippingClientRect.right +
                paddingObject.right,
        };
        var offsetData = state.modifiersData.offset; // Offsets can be applied only to the popper element

        if (elementContext === popper && offsetData) {
            var offset = offsetData[placement];
            Object.keys(overflowOffsets).forEach(function (key) {
                var multiply = [right, bottom].indexOf(key) >= 0 ? 1 : -1;
                var axis = [top, bottom].indexOf(key) >= 0 ? "y" : "x";
                overflowOffsets[key] += offset[axis] * multiply;
            });
        }

        return overflowOffsets;
    }

    function computeAutoPlacement(state, options) {
        if (options === void 0) {
            options = {};
        }

        var _options = options,
            placement = _options.placement,
            boundary = _options.boundary,
            rootBoundary = _options.rootBoundary,
            padding = _options.padding,
            flipVariations = _options.flipVariations,
            _options$allowedAutoP = _options.allowedAutoPlacements,
            allowedAutoPlacements =
                _options$allowedAutoP === void 0
                    ? placements
                    : _options$allowedAutoP;
        var variation = getVariation(placement);
        var placements$1 = variation
            ? flipVariations
                ? variationPlacements
                : variationPlacements.filter(function (placement) {
                      return getVariation(placement) === variation;
                  })
            : basePlacements;
        var allowedPlacements = placements$1.filter(function (placement) {
            return allowedAutoPlacements.indexOf(placement) >= 0;
        });

        if (allowedPlacements.length === 0) {
            allowedPlacements = placements$1;
        } // $FlowFixMe[incompatible-type]: Flow seems to have problems with two array unions...

        var overflows = allowedPlacements.reduce(function (acc, placement) {
            acc[placement] = detectOverflow(state, {
                placement: placement,
                boundary: boundary,
                rootBoundary: rootBoundary,
                padding: padding,
            })[getBasePlacement(placement)];
            return acc;
        }, {});
        return Object.keys(overflows).sort(function (a, b) {
            return overflows[a] - overflows[b];
        });
    }

    function getExpandedFallbackPlacements(placement) {
        if (getBasePlacement(placement) === auto) {
            return [];
        }

        var oppositePlacement = getOppositePlacement(placement);
        return [
            getOppositeVariationPlacement(placement),
            oppositePlacement,
            getOppositeVariationPlacement(oppositePlacement),
        ];
    }

    function flip(_ref) {
        var state = _ref.state,
            options = _ref.options,
            name = _ref.name;

        if (state.modifiersData[name]._skip) {
            return;
        }

        var _options$mainAxis = options.mainAxis,
            checkMainAxis =
                _options$mainAxis === void 0 ? true : _options$mainAxis,
            _options$altAxis = options.altAxis,
            checkAltAxis =
                _options$altAxis === void 0 ? true : _options$altAxis,
            specifiedFallbackPlacements = options.fallbackPlacements,
            padding = options.padding,
            boundary = options.boundary,
            rootBoundary = options.rootBoundary,
            altBoundary = options.altBoundary,
            _options$flipVariatio = options.flipVariations,
            flipVariations =
                _options$flipVariatio === void 0 ? true : _options$flipVariatio,
            allowedAutoPlacements = options.allowedAutoPlacements;
        var preferredPlacement = state.options.placement;
        var basePlacement = getBasePlacement(preferredPlacement);
        var isBasePlacement = basePlacement === preferredPlacement;
        var fallbackPlacements =
            specifiedFallbackPlacements ||
            (isBasePlacement || !flipVariations
                ? [getOppositePlacement(preferredPlacement)]
                : getExpandedFallbackPlacements(preferredPlacement));
        var placements = [preferredPlacement]
            .concat(fallbackPlacements)
            .reduce(function (acc, placement) {
                return acc.concat(
                    getBasePlacement(placement) === auto
                        ? computeAutoPlacement(state, {
                              placement: placement,
                              boundary: boundary,
                              rootBoundary: rootBoundary,
                              padding: padding,
                              flipVariations: flipVariations,
                              allowedAutoPlacements: allowedAutoPlacements,
                          })
                        : placement
                );
            }, []);
        var referenceRect = state.rects.reference;
        var popperRect = state.rects.popper;
        var checksMap = new Map();
        var makeFallbackChecks = true;
        var firstFittingPlacement = placements[0];

        for (var i = 0; i < placements.length; i++) {
            var placement = placements[i];

            var _basePlacement = getBasePlacement(placement);

            var isStartVariation = getVariation(placement) === start;
            var isVertical = [top, bottom].indexOf(_basePlacement) >= 0;
            var len = isVertical ? "width" : "height";
            var overflow = detectOverflow(state, {
                placement: placement,
                boundary: boundary,
                rootBoundary: rootBoundary,
                altBoundary: altBoundary,
                padding: padding,
            });
            var mainVariationSide = isVertical
                ? isStartVariation
                    ? right
                    : left
                : isStartVariation
                ? bottom
                : top;

            if (referenceRect[len] > popperRect[len]) {
                mainVariationSide = getOppositePlacement(mainVariationSide);
            }

            var altVariationSide = getOppositePlacement(mainVariationSide);
            var checks = [];

            if (checkMainAxis) {
                checks.push(overflow[_basePlacement] <= 0);
            }

            if (checkAltAxis) {
                checks.push(
                    overflow[mainVariationSide] <= 0,
                    overflow[altVariationSide] <= 0
                );
            }

            if (
                checks.every(function (check) {
                    return check;
                })
            ) {
                firstFittingPlacement = placement;
                makeFallbackChecks = false;
                break;
            }

            checksMap.set(placement, checks);
        }

        if (makeFallbackChecks) {
            // `2` may be desired in some cases â€“ research later
            var numberOfChecks = flipVariations ? 3 : 1;

            var _loop = function _loop(_i) {
                var fittingPlacement = placements.find(function (placement) {
                    var checks = checksMap.get(placement);

                    if (checks) {
                        return checks.slice(0, _i).every(function (check) {
                            return check;
                        });
                    }
                });

                if (fittingPlacement) {
                    firstFittingPlacement = fittingPlacement;
                    return "break";
                }
            };

            for (var _i = numberOfChecks; _i > 0; _i--) {
                var _ret = _loop(_i);

                if (_ret === "break") break;
            }
        }

        if (state.placement !== firstFittingPlacement) {
            state.modifiersData[name]._skip = true;
            state.placement = firstFittingPlacement;
            state.reset = true;
        }
    } // eslint-disable-next-line import/no-unused-modules

    const flip$1 = {
        name: "flip",
        enabled: true,
        phase: "main",
        fn: flip,
        requiresIfExists: ["offset"],
        data: {
            _skip: false,
        },
    };

    function getSideOffsets(overflow, rect, preventedOffsets) {
        if (preventedOffsets === void 0) {
            preventedOffsets = {
                x: 0,
                y: 0,
            };
        }

        return {
            top: overflow.top - rect.height - preventedOffsets.y,
            right: overflow.right - rect.width + preventedOffsets.x,
            bottom: overflow.bottom - rect.height + preventedOffsets.y,
            left: overflow.left - rect.width - preventedOffsets.x,
        };
    }

    function isAnySideFullyClipped(overflow) {
        return [top, right, bottom, left].some(function (side) {
            return overflow[side] >= 0;
        });
    }

    function hide(_ref) {
        var state = _ref.state,
            name = _ref.name;
        var referenceRect = state.rects.reference;
        var popperRect = state.rects.popper;
        var preventedOffsets = state.modifiersData.preventOverflow;
        var referenceOverflow = detectOverflow(state, {
            elementContext: "reference",
        });
        var popperAltOverflow = detectOverflow(state, {
            altBoundary: true,
        });
        var referenceClippingOffsets = getSideOffsets(
            referenceOverflow,
            referenceRect
        );
        var popperEscapeOffsets = getSideOffsets(
            popperAltOverflow,
            popperRect,
            preventedOffsets
        );
        var isReferenceHidden = isAnySideFullyClipped(referenceClippingOffsets);
        var hasPopperEscaped = isAnySideFullyClipped(popperEscapeOffsets);
        state.modifiersData[name] = {
            referenceClippingOffsets: referenceClippingOffsets,
            popperEscapeOffsets: popperEscapeOffsets,
            isReferenceHidden: isReferenceHidden,
            hasPopperEscaped: hasPopperEscaped,
        };
        state.attributes.popper = Object.assign({}, state.attributes.popper, {
            "data-popper-reference-hidden": isReferenceHidden,
            "data-popper-escaped": hasPopperEscaped,
        });
    } // eslint-disable-next-line import/no-unused-modules

    const hide$1 = {
        name: "hide",
        enabled: true,
        phase: "main",
        requiresIfExists: ["preventOverflow"],
        fn: hide,
    };

    function distanceAndSkiddingToXY(placement, rects, offset) {
        var basePlacement = getBasePlacement(placement);
        var invertDistance = [left, top].indexOf(basePlacement) >= 0 ? -1 : 1;

        var _ref =
                typeof offset === "function"
                    ? offset(
                          Object.assign({}, rects, {
                              placement: placement,
                          })
                      )
                    : offset,
            skidding = _ref[0],
            distance = _ref[1];

        skidding = skidding || 0;
        distance = (distance || 0) * invertDistance;
        return [left, right].indexOf(basePlacement) >= 0
            ? {
                  x: distance,
                  y: skidding,
              }
            : {
                  x: skidding,
                  y: distance,
              };
    }

    function offset(_ref2) {
        var state = _ref2.state,
            options = _ref2.options,
            name = _ref2.name;
        var _options$offset = options.offset,
            offset = _options$offset === void 0 ? [0, 0] : _options$offset;
        var data = placements.reduce(function (acc, placement) {
            acc[placement] = distanceAndSkiddingToXY(
                placement,
                state.rects,
                offset
            );
            return acc;
        }, {});
        var _data$state$placement = data[state.placement],
            x = _data$state$placement.x,
            y = _data$state$placement.y;

        if (state.modifiersData.popperOffsets != null) {
            state.modifiersData.popperOffsets.x += x;
            state.modifiersData.popperOffsets.y += y;
        }

        state.modifiersData[name] = data;
    } // eslint-disable-next-line import/no-unused-modules

    const offset$1 = {
        name: "offset",
        enabled: true,
        phase: "main",
        requires: ["popperOffsets"],
        fn: offset,
    };

    function popperOffsets(_ref) {
        var state = _ref.state,
            name = _ref.name;
        // Offsets are the actual position the popper needs to have to be
        // properly positioned near its reference element
        // This is the most basic placement, and will be adjusted by
        // the modifiers in the next step
        state.modifiersData[name] = computeOffsets({
            reference: state.rects.reference,
            element: state.rects.popper,
            strategy: "absolute",
            placement: state.placement,
        });
    } // eslint-disable-next-line import/no-unused-modules

    const popperOffsets$1 = {
        name: "popperOffsets",
        enabled: true,
        phase: "read",
        fn: popperOffsets,
        data: {},
    };

    function getAltAxis(axis) {
        return axis === "x" ? "y" : "x";
    }

    function preventOverflow(_ref) {
        var state = _ref.state,
            options = _ref.options,
            name = _ref.name;
        var _options$mainAxis = options.mainAxis,
            checkMainAxis =
                _options$mainAxis === void 0 ? true : _options$mainAxis,
            _options$altAxis = options.altAxis,
            checkAltAxis =
                _options$altAxis === void 0 ? false : _options$altAxis,
            boundary = options.boundary,
            rootBoundary = options.rootBoundary,
            altBoundary = options.altBoundary,
            padding = options.padding,
            _options$tether = options.tether,
            tether = _options$tether === void 0 ? true : _options$tether,
            _options$tetherOffset = options.tetherOffset,
            tetherOffset =
                _options$tetherOffset === void 0 ? 0 : _options$tetherOffset;
        var overflow = detectOverflow(state, {
            boundary: boundary,
            rootBoundary: rootBoundary,
            padding: padding,
            altBoundary: altBoundary,
        });
        var basePlacement = getBasePlacement(state.placement);
        var variation = getVariation(state.placement);
        var isBasePlacement = !variation;
        var mainAxis = getMainAxisFromPlacement(basePlacement);
        var altAxis = getAltAxis(mainAxis);
        var popperOffsets = state.modifiersData.popperOffsets;
        var referenceRect = state.rects.reference;
        var popperRect = state.rects.popper;
        var tetherOffsetValue =
            typeof tetherOffset === "function"
                ? tetherOffset(
                      Object.assign({}, state.rects, {
                          placement: state.placement,
                      })
                  )
                : tetherOffset;
        var data = {
            x: 0,
            y: 0,
        };

        if (!popperOffsets) {
            return;
        }

        if (checkMainAxis || checkAltAxis) {
            var mainSide = mainAxis === "y" ? top : left;
            var altSide = mainAxis === "y" ? bottom : right;
            var len = mainAxis === "y" ? "height" : "width";
            var offset = popperOffsets[mainAxis];
            var min$1 = popperOffsets[mainAxis] + overflow[mainSide];
            var max$1 = popperOffsets[mainAxis] - overflow[altSide];
            var additive = tether ? -popperRect[len] / 2 : 0;
            var minLen =
                variation === start ? referenceRect[len] : popperRect[len];
            var maxLen =
                variation === start ? -popperRect[len] : -referenceRect[len]; // We need to include the arrow in the calculation so the arrow doesn't go
            // outside the reference bounds

            var arrowElement = state.elements.arrow;
            var arrowRect =
                tether && arrowElement
                    ? getLayoutRect(arrowElement)
                    : {
                          width: 0,
                          height: 0,
                      };
            var arrowPaddingObject = state.modifiersData["arrow#persistent"]
                ? state.modifiersData["arrow#persistent"].padding
                : getFreshSideObject();
            var arrowPaddingMin = arrowPaddingObject[mainSide];
            var arrowPaddingMax = arrowPaddingObject[altSide]; // If the reference length is smaller than the arrow length, we don't want
            // to include its full size in the calculation. If the reference is small
            // and near the edge of a boundary, the popper can overflow even if the
            // reference is not overflowing as well (e.g. virtual elements with no
            // width or height)

            var arrowLen = within(0, referenceRect[len], arrowRect[len]);
            var minOffset = isBasePlacement
                ? referenceRect[len] / 2 -
                  additive -
                  arrowLen -
                  arrowPaddingMin -
                  tetherOffsetValue
                : minLen - arrowLen - arrowPaddingMin - tetherOffsetValue;
            var maxOffset = isBasePlacement
                ? -referenceRect[len] / 2 +
                  additive +
                  arrowLen +
                  arrowPaddingMax +
                  tetherOffsetValue
                : maxLen + arrowLen + arrowPaddingMax + tetherOffsetValue;
            var arrowOffsetParent =
                state.elements.arrow && getOffsetParent(state.elements.arrow);
            var clientOffset = arrowOffsetParent
                ? mainAxis === "y"
                    ? arrowOffsetParent.clientTop || 0
                    : arrowOffsetParent.clientLeft || 0
                : 0;
            var offsetModifierValue = state.modifiersData.offset
                ? state.modifiersData.offset[state.placement][mainAxis]
                : 0;
            var tetherMin =
                popperOffsets[mainAxis] +
                minOffset -
                offsetModifierValue -
                clientOffset;
            var tetherMax =
                popperOffsets[mainAxis] + maxOffset - offsetModifierValue;

            if (checkMainAxis) {
                var preventedOffset = within(
                    tether ? min(min$1, tetherMin) : min$1,
                    offset,
                    tether ? max(max$1, tetherMax) : max$1
                );
                popperOffsets[mainAxis] = preventedOffset;
                data[mainAxis] = preventedOffset - offset;
            }

            if (checkAltAxis) {
                var _mainSide = mainAxis === "x" ? top : left;

                var _altSide = mainAxis === "x" ? bottom : right;

                var _offset = popperOffsets[altAxis];

                var _min = _offset + overflow[_mainSide];

                var _max = _offset - overflow[_altSide];

                var _preventedOffset = within(
                    tether ? min(_min, tetherMin) : _min,
                    _offset,
                    tether ? max(_max, tetherMax) : _max
                );

                popperOffsets[altAxis] = _preventedOffset;
                data[altAxis] = _preventedOffset - _offset;
            }
        }

        state.modifiersData[name] = data;
    } // eslint-disable-next-line import/no-unused-modules

    const preventOverflow$1 = {
        name: "preventOverflow",
        enabled: true,
        phase: "main",
        fn: preventOverflow,
        requiresIfExists: ["offset"],
    };

    function getHTMLElementScroll(element) {
        return {
            scrollLeft: element.scrollLeft,
            scrollTop: element.scrollTop,
        };
    }

    function getNodeScroll(node) {
        if (node === getWindow(node) || !isHTMLElement(node)) {
            return getWindowScroll(node);
        } else {
            return getHTMLElementScroll(node);
        }
    }

    function isElementScaled(element) {
        var rect = element.getBoundingClientRect();
        var scaleX = rect.width / element.offsetWidth || 1;
        var scaleY = rect.height / element.offsetHeight || 1;
        return scaleX !== 1 || scaleY !== 1;
    } // Returns the composite rect of an element relative to its offsetParent.
    // Composite means it takes into account transforms as well as layout.

    function getCompositeRect(elementOrVirtualElement, offsetParent, isFixed) {
        if (isFixed === void 0) {
            isFixed = false;
        }

        var isOffsetParentAnElement = isHTMLElement(offsetParent);
        isHTMLElement(offsetParent) && isElementScaled(offsetParent);
        var documentElement = getDocumentElement(offsetParent);
        var rect = getBoundingClientRect(elementOrVirtualElement);
        var scroll = {
            scrollLeft: 0,
            scrollTop: 0,
        };
        var offsets = {
            x: 0,
            y: 0,
        };

        if (isOffsetParentAnElement || (!isOffsetParentAnElement && !isFixed)) {
            if (
                getNodeName(offsetParent) !== "body" || // https://github.com/popperjs/popper-core/issues/1078
                isScrollParent(documentElement)
            ) {
                scroll = getNodeScroll(offsetParent);
            }

            if (isHTMLElement(offsetParent)) {
                offsets = getBoundingClientRect(offsetParent);
                offsets.x += offsetParent.clientLeft;
                offsets.y += offsetParent.clientTop;
            } else if (documentElement) {
                offsets.x = getWindowScrollBarX(documentElement);
            }
        }

        return {
            x: rect.left + scroll.scrollLeft - offsets.x,
            y: rect.top + scroll.scrollTop - offsets.y,
            width: rect.width,
            height: rect.height,
        };
    }

    function order(modifiers) {
        var map = new Map();
        var visited = new Set();
        var result = [];
        modifiers.forEach(function (modifier) {
            map.set(modifier.name, modifier);
        }); // On visiting object, check for its dependencies and visit them recursively

        function sort(modifier) {
            visited.add(modifier.name);
            var requires = [].concat(
                modifier.requires || [],
                modifier.requiresIfExists || []
            );
            requires.forEach(function (dep) {
                if (!visited.has(dep)) {
                    var depModifier = map.get(dep);

                    if (depModifier) {
                        sort(depModifier);
                    }
                }
            });
            result.push(modifier);
        }

        modifiers.forEach(function (modifier) {
            if (!visited.has(modifier.name)) {
                // check for visited object
                sort(modifier);
            }
        });
        return result;
    }

    function orderModifiers(modifiers) {
        // order based on dependencies
        var orderedModifiers = order(modifiers); // order based on phase

        return modifierPhases.reduce(function (acc, phase) {
            return acc.concat(
                orderedModifiers.filter(function (modifier) {
                    return modifier.phase === phase;
                })
            );
        }, []);
    }

    function debounce(fn) {
        var pending;
        return function () {
            if (!pending) {
                pending = new Promise(function (resolve) {
                    Promise.resolve().then(function () {
                        pending = undefined;
                        resolve(fn());
                    });
                });
            }

            return pending;
        };
    }

    function mergeByName(modifiers) {
        var merged = modifiers.reduce(function (merged, current) {
            var existing = merged[current.name];
            merged[current.name] = existing
                ? Object.assign({}, existing, current, {
                      options: Object.assign(
                          {},
                          existing.options,
                          current.options
                      ),
                      data: Object.assign({}, existing.data, current.data),
                  })
                : current;
            return merged;
        }, {}); // IE11 does not support Object.values

        return Object.keys(merged).map(function (key) {
            return merged[key];
        });
    }

    var DEFAULT_OPTIONS = {
        placement: "bottom",
        modifiers: [],
        strategy: "absolute",
    };

    function areValidElements() {
        for (
            var _len = arguments.length, args = new Array(_len), _key = 0;
            _key < _len;
            _key++
        ) {
            args[_key] = arguments[_key];
        }

        return !args.some(function (element) {
            return !(
                element && typeof element.getBoundingClientRect === "function"
            );
        });
    }

    function popperGenerator(generatorOptions) {
        if (generatorOptions === void 0) {
            generatorOptions = {};
        }

        var _generatorOptions = generatorOptions,
            _generatorOptions$def = _generatorOptions.defaultModifiers,
            defaultModifiers =
                _generatorOptions$def === void 0 ? [] : _generatorOptions$def,
            _generatorOptions$def2 = _generatorOptions.defaultOptions,
            defaultOptions =
                _generatorOptions$def2 === void 0
                    ? DEFAULT_OPTIONS
                    : _generatorOptions$def2;
        return function createPopper(reference, popper, options) {
            if (options === void 0) {
                options = defaultOptions;
            }

            var state = {
                placement: "bottom",
                orderedModifiers: [],
                options: Object.assign({}, DEFAULT_OPTIONS, defaultOptions),
                modifiersData: {},
                elements: {
                    reference: reference,
                    popper: popper,
                },
                attributes: {},
                styles: {},
            };
            var effectCleanupFns = [];
            var isDestroyed = false;
            var instance = {
                state: state,
                setOptions: function setOptions(setOptionsAction) {
                    var options =
                        typeof setOptionsAction === "function"
                            ? setOptionsAction(state.options)
                            : setOptionsAction;
                    cleanupModifierEffects();
                    state.options = Object.assign(
                        {},
                        defaultOptions,
                        state.options,
                        options
                    );
                    state.scrollParents = {
                        reference: isElement(reference)
                            ? listScrollParents(reference)
                            : reference.contextElement
                            ? listScrollParents(reference.contextElement)
                            : [],
                        popper: listScrollParents(popper),
                    }; // Orders the modifiers based on their dependencies and `phase`
                    // properties

                    var orderedModifiers = orderModifiers(
                        mergeByName(
                            [].concat(defaultModifiers, state.options.modifiers)
                        )
                    ); // Strip out disabled modifiers

                    state.orderedModifiers = orderedModifiers.filter(function (
                        m
                    ) {
                        return m.enabled;
                    }); // Validate the provided modifiers so that the consumer will get warned

                    runModifierEffects();
                    return instance.update();
                },
                // Sync update â€“ it will always be executed, even if not necessary. This
                // is useful for low frequency updates where sync behavior simplifies the
                // logic.
                // For high frequency updates (e.g. `resize` and `scroll` events), always
                // prefer the async Popper#update method
                forceUpdate: function forceUpdate() {
                    if (isDestroyed) {
                        return;
                    }

                    var _state$elements = state.elements,
                        reference = _state$elements.reference,
                        popper = _state$elements.popper; // Don't proceed if `reference` or `popper` are not valid elements
                    // anymore

                    if (!areValidElements(reference, popper)) {
                        return;
                    } // Store the reference and popper rects to be read by modifiers

                    state.rects = {
                        reference: getCompositeRect(
                            reference,
                            getOffsetParent(popper),
                            state.options.strategy === "fixed"
                        ),
                        popper: getLayoutRect(popper),
                    }; // Modifiers have the ability to reset the current update cycle. The
                    // most common use case for this is the `flip` modifier changing the
                    // placement, which then needs to re-run all the modifiers, because the
                    // logic was previously ran for the previous placement and is therefore
                    // stale/incorrect

                    state.reset = false;
                    state.placement = state.options.placement; // On each update cycle, the `modifiersData` property for each modifier
                    // is filled with the initial data specified by the modifier. This means
                    // it doesn't persist and is fresh on each update.
                    // To ensure persistent data, use `${name}#persistent`

                    state.orderedModifiers.forEach(function (modifier) {
                        return (state.modifiersData[modifier.name] =
                            Object.assign({}, modifier.data));
                    });

                    for (
                        var index = 0;
                        index < state.orderedModifiers.length;
                        index++
                    ) {
                        if (state.reset === true) {
                            state.reset = false;
                            index = -1;
                            continue;
                        }

                        var _state$orderedModifie =
                                state.orderedModifiers[index],
                            fn = _state$orderedModifie.fn,
                            _state$orderedModifie2 =
                                _state$orderedModifie.options,
                            _options =
                                _state$orderedModifie2 === void 0
                                    ? {}
                                    : _state$orderedModifie2,
                            name = _state$orderedModifie.name;

                        if (typeof fn === "function") {
                            state =
                                fn({
                                    state: state,
                                    options: _options,
                                    name: name,
                                    instance: instance,
                                }) || state;
                        }
                    }
                },
                // Async and optimistically optimized update â€“ it will not be executed if
                // not necessary (debounced to run at most once-per-tick)
                update: debounce(function () {
                    return new Promise(function (resolve) {
                        instance.forceUpdate();
                        resolve(state);
                    });
                }),
                destroy: function destroy() {
                    cleanupModifierEffects();
                    isDestroyed = true;
                },
            };

            if (!areValidElements(reference, popper)) {
                return instance;
            }

            instance.setOptions(options).then(function (state) {
                if (!isDestroyed && options.onFirstUpdate) {
                    options.onFirstUpdate(state);
                }
            }); // Modifiers have the ability to execute arbitrary code before the first
            // update cycle runs. They will be executed in the same order as the update
            // cycle. This is useful when a modifier adds some persistent data that
            // other modifiers need to use, but the modifier is run after the dependent
            // one.

            function runModifierEffects() {
                state.orderedModifiers.forEach(function (_ref3) {
                    var name = _ref3.name,
                        _ref3$options = _ref3.options,
                        options = _ref3$options === void 0 ? {} : _ref3$options,
                        effect = _ref3.effect;

                    if (typeof effect === "function") {
                        var cleanupFn = effect({
                            state: state,
                            name: name,
                            instance: instance,
                            options: options,
                        });

                        var noopFn = function noopFn() {};

                        effectCleanupFns.push(cleanupFn || noopFn);
                    }
                });
            }

            function cleanupModifierEffects() {
                effectCleanupFns.forEach(function (fn) {
                    return fn();
                });
                effectCleanupFns = [];
            }

            return instance;
        };
    }
    var createPopper$2 = /*#__PURE__*/ popperGenerator(); // eslint-disable-next-line import/no-unused-modules

    var defaultModifiers$1 = [
        eventListeners,
        popperOffsets$1,
        computeStyles$1,
        applyStyles$1,
    ];
    var createPopper$1 = /*#__PURE__*/ popperGenerator({
        defaultModifiers: defaultModifiers$1,
    }); // eslint-disable-next-line import/no-unused-modules

    var defaultModifiers = [
        eventListeners,
        popperOffsets$1,
        computeStyles$1,
        applyStyles$1,
        offset$1,
        flip$1,
        preventOverflow$1,
        arrow$1,
        hide$1,
    ];
    var createPopper = /*#__PURE__*/ popperGenerator({
        defaultModifiers: defaultModifiers,
    }); // eslint-disable-next-line import/no-unused-modules

    const Popper = /*#__PURE__*/ Object.freeze({
        __proto__: null,
        popperGenerator,
        detectOverflow,
        createPopperBase: createPopper$2,
        createPopper,
        createPopperLite: createPopper$1,
        top,
        bottom,
        right,
        left,
        auto,
        basePlacements,
        start,
        end,
        clippingParents,
        viewport,
        popper,
        reference,
        variationPlacements,
        placements,
        beforeRead,
        read,
        afterRead,
        beforeMain,
        main,
        afterMain,
        beforeWrite,
        write,
        afterWrite,
        modifierPhases,
        applyStyles: applyStyles$1,
        arrow: arrow$1,
        computeStyles: computeStyles$1,
        eventListeners,
        flip: flip$1,
        hide: hide$1,
        offset: offset$1,
        popperOffsets: popperOffsets$1,
        preventOverflow: preventOverflow$1,
    });

    /**
     * --------------------------------------------------------------------------
     * Bootstrap (v5.1.3): dropdown.js
     * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
     * --------------------------------------------------------------------------
     */
    /**
     * ------------------------------------------------------------------------
     * Constants
     * ------------------------------------------------------------------------
     */

    const NAME$9 = "dropdown";
    const DATA_KEY$8 = "bs.dropdown";
    const EVENT_KEY$8 = `.${DATA_KEY$8}`;
    const DATA_API_KEY$4 = ".data-api";
    const ESCAPE_KEY$2 = "Escape";
    const SPACE_KEY = "Space";
    const TAB_KEY$1 = "Tab";
    const ARROW_UP_KEY = "ArrowUp";
    const ARROW_DOWN_KEY = "ArrowDown";
    const RIGHT_MOUSE_BUTTON = 2; // MouseEvent.button value for the secondary button, usually the right button

    const REGEXP_KEYDOWN = new RegExp(
        `${ARROW_UP_KEY}|${ARROW_DOWN_KEY}|${ESCAPE_KEY$2}`
    );
    const EVENT_HIDE$4 = `hide${EVENT_KEY$8}`;
    const EVENT_HIDDEN$4 = `hidden${EVENT_KEY$8}`;
    const EVENT_SHOW$4 = `show${EVENT_KEY$8}`;
    const EVENT_SHOWN$4 = `shown${EVENT_KEY$8}`;
    const EVENT_CLICK_DATA_API$3 = `click${EVENT_KEY$8}${DATA_API_KEY$4}`;
    const EVENT_KEYDOWN_DATA_API = `keydown${EVENT_KEY$8}${DATA_API_KEY$4}`;
    const EVENT_KEYUP_DATA_API = `keyup${EVENT_KEY$8}${DATA_API_KEY$4}`;
    const CLASS_NAME_SHOW$6 = "show";
    const CLASS_NAME_DROPUP = "dropup";
    const CLASS_NAME_DROPEND = "dropend";
    const CLASS_NAME_DROPSTART = "dropstart";
    const CLASS_NAME_NAVBAR = "navbar";
    const SELECTOR_DATA_TOGGLE$3 = '[data-bs-toggle="dropdown"]';
    const SELECTOR_MENU = ".dropdown-menu";
    const SELECTOR_NAVBAR_NAV = ".navbar-nav";
    const SELECTOR_VISIBLE_ITEMS =
        ".dropdown-menu .dropdown-item:not(.disabled):not(:disabled)";
    const PLACEMENT_TOP = isRTL() ? "top-end" : "top-start";
    const PLACEMENT_TOPEND = isRTL() ? "top-start" : "top-end";
    const PLACEMENT_BOTTOM = isRTL() ? "bottom-end" : "bottom-start";
    const PLACEMENT_BOTTOMEND = isRTL() ? "bottom-start" : "bottom-end";
    const PLACEMENT_RIGHT = isRTL() ? "left-start" : "right-start";
    const PLACEMENT_LEFT = isRTL() ? "right-start" : "left-start";
    const Default$8 = {
        offset: [0, 2],
        boundary: "clippingParents",
        reference: "toggle",
        display: "dynamic",
        popperConfig: null,
        autoClose: true,
    };
    const DefaultType$8 = {
        offset: "(array|string|function)",
        boundary: "(string|element)",
        reference: "(string|element|object)",
        display: "string",
        popperConfig: "(null|object|function)",
        autoClose: "(boolean|string)",
    };
    /**
     * ------------------------------------------------------------------------
     * Class Definition
     * ------------------------------------------------------------------------
     */

    class Dropdown extends BaseComponent {
        constructor(element, config) {
            super(element);
            this._popper = null;
            this._config = this._getConfig(config);
            this._menu = this._getMenuElement();
            this._inNavbar = this._detectNavbar();
        } // Getters

        static get Default() {
            return Default$8;
        }

        static get DefaultType() {
            return DefaultType$8;
        }

        static get NAME() {
            return NAME$9;
        } // Public

        toggle() {
            return this._isShown() ? this.hide() : this.show();
        }

        show() {
            if (isDisabled(this._element) || this._isShown(this._menu)) {
                return;
            }

            const relatedTarget = {
                relatedTarget: this._element,
            };
            const showEvent = EventHandler.trigger(
                this._element,
                EVENT_SHOW$4,
                relatedTarget
            );

            if (showEvent.defaultPrevented) {
                return;
            }

            const parent = Dropdown.getParentFromElement(this._element); // Totally disable Popper for Dropdowns in Navbar

            if (this._inNavbar) {
                Manipulator.setDataAttribute(this._menu, "popper", "none");
            } else {
                this._createPopper(parent);
            } // If this is a touch-enabled device we add extra
            // empty mouseover listeners to the body's immediate children;
            // only needed because of broken event delegation on iOS
            // https://www.quirksmode.org/blog/archives/2014/02/mouse_event_bub.html

            if (
                "ontouchstart" in document.documentElement &&
                !parent.closest(SELECTOR_NAVBAR_NAV)
            ) {
                []
                    .concat(...document.body.children)
                    .forEach((elem) =>
                        EventHandler.on(elem, "mouseover", noop)
                    );
            }

            this._element.focus();

            this._element.setAttribute("aria-expanded", true);

            this._menu.classList.add(CLASS_NAME_SHOW$6);

            this._element.classList.add(CLASS_NAME_SHOW$6);

            EventHandler.trigger(this._element, EVENT_SHOWN$4, relatedTarget);
        }

        hide() {
            if (isDisabled(this._element) || !this._isShown(this._menu)) {
                return;
            }

            const relatedTarget = {
                relatedTarget: this._element,
            };

            this._completeHide(relatedTarget);
        }

        dispose() {
            if (this._popper) {
                this._popper.destroy();
            }

            super.dispose();
        }

        update() {
            this._inNavbar = this._detectNavbar();

            if (this._popper) {
                this._popper.update();
            }
        } // Private

        _completeHide(relatedTarget) {
            const hideEvent = EventHandler.trigger(
                this._element,
                EVENT_HIDE$4,
                relatedTarget
            );

            if (hideEvent.defaultPrevented) {
                return;
            } // If this is a touch-enabled device we remove the extra
            // empty mouseover listeners we added for iOS support

            if ("ontouchstart" in document.documentElement) {
                []
                    .concat(...document.body.children)
                    .forEach((elem) =>
                        EventHandler.off(elem, "mouseover", noop)
                    );
            }

            if (this._popper) {
                this._popper.destroy();
            }

            this._menu.classList.remove(CLASS_NAME_SHOW$6);

            this._element.classList.remove(CLASS_NAME_SHOW$6);

            this._element.setAttribute("aria-expanded", "false");

            Manipulator.removeDataAttribute(this._menu, "popper");
            EventHandler.trigger(this._element, EVENT_HIDDEN$4, relatedTarget);
        }

        _getConfig(config) {
            config = {
                ...this.constructor.Default,
                ...Manipulator.getDataAttributes(this._element),
                ...config,
            };
            typeCheckConfig(NAME$9, config, this.constructor.DefaultType);

            if (
                typeof config.reference === "object" &&
                !isElement$1(config.reference) &&
                typeof config.reference.getBoundingClientRect !== "function"
            ) {
                // Popper virtual elements require a getBoundingClientRect method
                throw new TypeError(
                    `${NAME$9.toUpperCase()}: Option "reference" provided type "object" without a required "getBoundingClientRect" method.`
                );
            }

            return config;
        }

        _createPopper(parent) {
            if (typeof Popper === "undefined") {
                throw new TypeError(
                    "Bootstrap's dropdowns require Popper (https://popper.js.org)"
                );
            }

            let referenceElement = this._element;

            if (this._config.reference === "parent") {
                referenceElement = parent;
            } else if (isElement$1(this._config.reference)) {
                referenceElement = getElement(this._config.reference);
            } else if (typeof this._config.reference === "object") {
                referenceElement = this._config.reference;
            }

            const popperConfig = this._getPopperConfig();

            const isDisplayStatic = popperConfig.modifiers.find(
                (modifier) =>
                    modifier.name === "applyStyles" &&
                    modifier.enabled === false
            );
            this._popper = createPopper(
                referenceElement,
                this._menu,
                popperConfig
            );

            if (isDisplayStatic) {
                Manipulator.setDataAttribute(this._menu, "popper", "static");
            }
        }

        _isShown(element = this._element) {
            return element.classList.contains(CLASS_NAME_SHOW$6);
        }

        _getMenuElement() {
            return SelectorEngine.next(this._element, SELECTOR_MENU)[0];
        }

        _getPlacement() {
            const parentDropdown = this._element.parentNode;

            if (parentDropdown.classList.contains(CLASS_NAME_DROPEND)) {
                return PLACEMENT_RIGHT;
            }

            if (parentDropdown.classList.contains(CLASS_NAME_DROPSTART)) {
                return PLACEMENT_LEFT;
            } // We need to trim the value because custom properties can also include spaces

            const isEnd =
                getComputedStyle(this._menu)
                    .getPropertyValue("--bs-position")
                    .trim() === "end";

            if (parentDropdown.classList.contains(CLASS_NAME_DROPUP)) {
                return isEnd ? PLACEMENT_TOPEND : PLACEMENT_TOP;
            }

            return isEnd ? PLACEMENT_BOTTOMEND : PLACEMENT_BOTTOM;
        }

        _detectNavbar() {
            return this._element.closest(`.${CLASS_NAME_NAVBAR}`) !== null;
        }

        _getOffset() {
            const { offset } = this._config;

            if (typeof offset === "string") {
                return offset.split(",").map((val) => Number.parseInt(val, 10));
            }

            if (typeof offset === "function") {
                return (popperData) => offset(popperData, this._element);
            }

            return offset;
        }

        _getPopperConfig() {
            const defaultBsPopperConfig = {
                placement: this._getPlacement(),
                modifiers: [
                    {
                        name: "preventOverflow",
                        options: {
                            boundary: this._config.boundary,
                        },
                    },
                    {
                        name: "offset",
                        options: {
                            offset: this._getOffset(),
                        },
                    },
                ],
            }; // Disable Popper if we have a static display

            if (this._config.display === "static") {
                defaultBsPopperConfig.modifiers = [
                    {
                        name: "applyStyles",
                        enabled: false,
                    },
                ];
            }

            return {
                ...defaultBsPopperConfig,
                ...(typeof this._config.popperConfig === "function"
                    ? this._config.popperConfig(defaultBsPopperConfig)
                    : this._config.popperConfig),
            };
        }

        _selectMenuItem({ key, target }) {
            const items = SelectorEngine.find(
                SELECTOR_VISIBLE_ITEMS,
                this._menu
            ).filter(isVisible);

            if (!items.length) {
                return;
            } // if target isn't included in items (e.g. when expanding the dropdown)
            // allow cycling to get the last item in case key equals ARROW_UP_KEY

            getNextActiveElement(
                items,
                target,
                key === ARROW_DOWN_KEY,
                !items.includes(target)
            ).focus();
        } // Static

        static jQueryInterface(config) {
            return this.each(function () {
                const data = Dropdown.getOrCreateInstance(this, config);

                if (typeof config !== "string") {
                    return;
                }

                if (typeof data[config] === "undefined") {
                    throw new TypeError(`No method named "${config}"`);
                }

                data[config]();
            });
        }

        static clearMenus(event) {
            if (
                event &&
                (event.button === RIGHT_MOUSE_BUTTON ||
                    (event.type === "keyup" && event.key !== TAB_KEY$1))
            ) {
                return;
            }

            const toggles = SelectorEngine.find(SELECTOR_DATA_TOGGLE$3);

            for (let i = 0, len = toggles.length; i < len; i++) {
                const context = Dropdown.getInstance(toggles[i]);

                if (!context || context._config.autoClose === false) {
                    continue;
                }

                if (!context._isShown()) {
                    continue;
                }

                const relatedTarget = {
                    relatedTarget: context._element,
                };

                if (event) {
                    const composedPath = event.composedPath();
                    const isMenuTarget = composedPath.includes(context._menu);

                    if (
                        composedPath.includes(context._element) ||
                        (context._config.autoClose === "inside" &&
                            !isMenuTarget) ||
                        (context._config.autoClose === "outside" &&
                            isMenuTarget)
                    ) {
                        continue;
                    } // Tab navigation through the dropdown menu or events from contained inputs shouldn't close the menu

                    if (
                        context._menu.contains(event.target) &&
                        ((event.type === "keyup" && event.key === TAB_KEY$1) ||
                            /input|select|option|textarea|form/i.test(
                                event.target.tagName
                            ))
                    ) {
                        continue;
                    }

                    if (event.type === "click") {
                        relatedTarget.clickEvent = event;
                    }
                }

                context._completeHide(relatedTarget);
            }
        }

        static getParentFromElement(element) {
            return getElementFromSelector(element) || element.parentNode;
        }

        static dataApiKeydownHandler(event) {
            // If not input/textarea:
            //  - And not a key in REGEXP_KEYDOWN => not a dropdown command
            // If input/textarea:
            //  - If space key => not a dropdown command
            //  - If key is other than escape
            //    - If key is not up or down => not a dropdown command
            //    - If trigger inside the menu => not a dropdown command
            if (
                /input|textarea/i.test(event.target.tagName)
                    ? event.key === SPACE_KEY ||
                      (event.key !== ESCAPE_KEY$2 &&
                          ((event.key !== ARROW_DOWN_KEY &&
                              event.key !== ARROW_UP_KEY) ||
                              event.target.closest(SELECTOR_MENU)))
                    : !REGEXP_KEYDOWN.test(event.key)
            ) {
                return;
            }

            const isActive = this.classList.contains(CLASS_NAME_SHOW$6);

            if (!isActive && event.key === ESCAPE_KEY$2) {
                return;
            }

            event.preventDefault();
            event.stopPropagation();

            if (isDisabled(this)) {
                return;
            }

            const getToggleButton = this.matches(SELECTOR_DATA_TOGGLE$3)
                ? this
                : SelectorEngine.prev(this, SELECTOR_DATA_TOGGLE$3)[0];
            const instance = Dropdown.getOrCreateInstance(getToggleButton);

            if (event.key === ESCAPE_KEY$2) {
                instance.hide();
                return;
            }

            if (event.key === ARROW_UP_KEY || event.key === ARROW_DOWN_KEY) {
                if (!isActive) {
                    instance.show();
                }

                instance._selectMenuItem(event);

                return;
            }

            if (!isActive || event.key === SPACE_KEY) {
                Dropdown.clearMenus();
            }
        }
    }
    /**
     * ------------------------------------------------------------------------
     * Data Api implementation
     * ------------------------------------------------------------------------
     */

    EventHandler.on(
        document,
        EVENT_KEYDOWN_DATA_API,
        SELECTOR_DATA_TOGGLE$3,
        Dropdown.dataApiKeydownHandler
    );
    EventHandler.on(
        document,
        EVENT_KEYDOWN_DATA_API,
        SELECTOR_MENU,
        Dropdown.dataApiKeydownHandler
    );
    EventHandler.on(document, EVENT_CLICK_DATA_API$3, Dropdown.clearMenus);
    EventHandler.on(document, EVENT_KEYUP_DATA_API, Dropdown.clearMenus);
    EventHandler.on(
        document,
        EVENT_CLICK_DATA_API$3,
        SELECTOR_DATA_TOGGLE$3,
        function (event) {
            event.preventDefault();
            Dropdown.getOrCreateInstance(this).toggle();
        }
    );
    /**
     * ------------------------------------------------------------------------
     * jQuery
     * ------------------------------------------------------------------------
     * add .Dropdown to jQuery only if jQuery is present
     */

    defineJQueryPlugin(Dropdown);

    /**
     * --------------------------------------------------------------------------
     * Bootstrap (v5.1.3): util/scrollBar.js
     * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
     * --------------------------------------------------------------------------
     */
    const SELECTOR_FIXED_CONTENT =
        ".fixed-top, .fixed-bottom, .is-fixed, .sticky-top";
    const SELECTOR_STICKY_CONTENT = ".sticky-top";

    class ScrollBarHelper {
        constructor() {
            this._element = document.body;
        }

        getWidth() {
            // https://developer.mozilla.org/en-US/docs/Web/API/Window/innerWidth#usage_notes
            const documentWidth = document.documentElement.clientWidth;
            return Math.abs(window.innerWidth - documentWidth);
        }

        hide() {
            const width = this.getWidth();

            this._disableOverFlow(); // give padding to element to balance the hidden scrollbar width

            this._setElementAttributes(
                this._element,
                "paddingRight",
                (calculatedValue) => calculatedValue + width
            ); // trick: We adjust positive paddingRight and negative marginRight to sticky-top elements to keep showing fullwidth

            this._setElementAttributes(
                SELECTOR_FIXED_CONTENT,
                "paddingRight",
                (calculatedValue) => calculatedValue + width
            );

            this._setElementAttributes(
                SELECTOR_STICKY_CONTENT,
                "marginRight",
                (calculatedValue) => calculatedValue - width
            );
        }

        _disableOverFlow() {
            this._saveInitialAttribute(this._element, "overflow");

            this._element.style.overflow = "hidden";
        }

        _setElementAttributes(selector, styleProp, callback) {
            const scrollbarWidth = this.getWidth();

            const manipulationCallBack = (element) => {
                if (
                    element !== this._element &&
                    window.innerWidth > element.clientWidth + scrollbarWidth
                ) {
                    return;
                }

                this._saveInitialAttribute(element, styleProp);

                const calculatedValue =
                    window.getComputedStyle(element)[styleProp];
                element.style[styleProp] = `${callback(
                    Number.parseFloat(calculatedValue)
                )}px`;
            };

            this._applyManipulationCallback(selector, manipulationCallBack);
        }

        reset() {
            this._resetElementAttributes(this._element, "overflow");

            this._resetElementAttributes(this._element, "paddingRight");

            this._resetElementAttributes(
                SELECTOR_FIXED_CONTENT,
                "paddingRight"
            );

            this._resetElementAttributes(
                SELECTOR_STICKY_CONTENT,
                "marginRight"
            );
        }

        _saveInitialAttribute(element, styleProp) {
            const actualValue = element.style[styleProp];

            if (actualValue) {
                Manipulator.setDataAttribute(element, styleProp, actualValue);
            }
        }

        _resetElementAttributes(selector, styleProp) {
            const manipulationCallBack = (element) => {
                const value = Manipulator.getDataAttribute(element, styleProp);

                if (typeof value === "undefined") {
                    element.style.removeProperty(styleProp);
                } else {
                    Manipulator.removeDataAttribute(element, styleProp);
                    element.style[styleProp] = value;
                }
            };

            this._applyManipulationCallback(selector, manipulationCallBack);
        }

        _applyManipulationCallback(selector, callBack) {
            if (isElement$1(selector)) {
                callBack(selector);
            } else {
                SelectorEngine.find(selector, this._element).forEach(callBack);
            }
        }

        isOverflowing() {
            return this.getWidth() > 0;
        }
    }

    /**
     * --------------------------------------------------------------------------
     * Bootstrap (v5.1.3): util/backdrop.js
     * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
     * --------------------------------------------------------------------------
     */
    const Default$7 = {
        className: "modal-backdrop",
        isVisible: true,
        // if false, we use the backdrop helper without adding any element to the dom
        isAnimated: false,
        rootElement: "body",
        // give the choice to place backdrop under different elements
        clickCallback: null,
    };
    const DefaultType$7 = {
        className: "string",
        isVisible: "boolean",
        isAnimated: "boolean",
        rootElement: "(element|string)",
        clickCallback: "(function|null)",
    };
    const NAME$8 = "backdrop";
    const CLASS_NAME_FADE$4 = "fade";
    const CLASS_NAME_SHOW$5 = "show";
    const EVENT_MOUSEDOWN = `mousedown.bs.${NAME$8}`;

    class Backdrop {
        constructor(config) {
            this._config = this._getConfig(config);
            this._isAppended = false;
            this._element = null;
        }

        show(callback) {
            if (!this._config.isVisible) {
                execute(callback);
                return;
            }

            this._append();

            if (this._config.isAnimated) {
                reflow(this._getElement());
            }

            this._getElement().classList.add(CLASS_NAME_SHOW$5);

            this._emulateAnimation(() => {
                execute(callback);
            });
        }

        hide(callback) {
            if (!this._config.isVisible) {
                execute(callback);
                return;
            }

            this._getElement().classList.remove(CLASS_NAME_SHOW$5);

            this._emulateAnimation(() => {
                this.dispose();
                execute(callback);
            });
        } // Private

        _getElement() {
            if (!this._element) {
                const backdrop = document.createElement("div");
                backdrop.className = this._config.className;

                if (this._config.isAnimated) {
                    backdrop.classList.add(CLASS_NAME_FADE$4);
                }

                this._element = backdrop;
            }

            return this._element;
        }

        _getConfig(config) {
            config = {
                ...Default$7,
                ...(typeof config === "object" ? config : {}),
            }; // use getElement() with the default "body" to get a fresh Element on each instantiation

            config.rootElement = getElement(config.rootElement);
            typeCheckConfig(NAME$8, config, DefaultType$7);
            return config;
        }

        _append() {
            if (this._isAppended) {
                return;
            }

            this._config.rootElement.append(this._getElement());

            EventHandler.on(this._getElement(), EVENT_MOUSEDOWN, () => {
                execute(this._config.clickCallback);
            });
            this._isAppended = true;
        }

        dispose() {
            if (!this._isAppended) {
                return;
            }

            EventHandler.off(this._element, EVENT_MOUSEDOWN);

            this._element.remove();

            this._isAppended = false;
        }

        _emulateAnimation(callback) {
            executeAfterTransition(
                callback,
                this._getElement(),
                this._config.isAnimated
            );
        }
    }

    /**
     * --------------------------------------------------------------------------
     * Bootstrap (v5.1.3): util/focustrap.js
     * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
     * --------------------------------------------------------------------------
     */
    const Default$6 = {
        trapElement: null,
        // The element to trap focus inside of
        autofocus: true,
    };
    const DefaultType$6 = {
        trapElement: "element",
        autofocus: "boolean",
    };
    const NAME$7 = "focustrap";
    const DATA_KEY$7 = "bs.focustrap";
    const EVENT_KEY$7 = `.${DATA_KEY$7}`;
    const EVENT_FOCUSIN$1 = `focusin${EVENT_KEY$7}`;
    const EVENT_KEYDOWN_TAB = `keydown.tab${EVENT_KEY$7}`;
    const TAB_KEY = "Tab";
    const TAB_NAV_FORWARD = "forward";
    const TAB_NAV_BACKWARD = "backward";

    class FocusTrap {
        constructor(config) {
            this._config = this._getConfig(config);
            this._isActive = false;
            this._lastTabNavDirection = null;
        }

        activate() {
            const { trapElement, autofocus } = this._config;

            if (this._isActive) {
                return;
            }

            if (autofocus) {
                trapElement.focus();
            }

            EventHandler.off(document, EVENT_KEY$7); // guard against infinite focus loop

            EventHandler.on(document, EVENT_FOCUSIN$1, (event) =>
                this._handleFocusin(event)
            );
            EventHandler.on(document, EVENT_KEYDOWN_TAB, (event) =>
                this._handleKeydown(event)
            );
            this._isActive = true;
        }

        deactivate() {
            if (!this._isActive) {
                return;
            }

            this._isActive = false;
            EventHandler.off(document, EVENT_KEY$7);
        } // Private

        _handleFocusin(event) {
            const { target } = event;
            const { trapElement } = this._config;

            if (
                target === document ||
                target === trapElement ||
                trapElement.contains(target)
            ) {
                return;
            }

            const elements = SelectorEngine.focusableChildren(trapElement);

            if (elements.length === 0) {
                trapElement.focus();
            } else if (this._lastTabNavDirection === TAB_NAV_BACKWARD) {
                elements[elements.length - 1].focus();
            } else {
                elements[0].focus();
            }
        }

        _handleKeydown(event) {
            if (event.key !== TAB_KEY) {
                return;
            }

            this._lastTabNavDirection = event.shiftKey
                ? TAB_NAV_BACKWARD
                : TAB_NAV_FORWARD;
        }

        _getConfig(config) {
            config = {
                ...Default$6,
                ...(typeof config === "object" ? config : {}),
            };
            typeCheckConfig(NAME$7, config, DefaultType$6);
            return config;
        }
    }

    /**
     * --------------------------------------------------------------------------
     * Bootstrap (v5.1.3): modal.js
     * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
     * --------------------------------------------------------------------------
     */
    /**
     * ------------------------------------------------------------------------
     * Constants
     * ------------------------------------------------------------------------
     */

    const NAME$6 = "modal";
    const DATA_KEY$6 = "bs.modal";
    const EVENT_KEY$6 = `.${DATA_KEY$6}`;
    const DATA_API_KEY$3 = ".data-api";
    const ESCAPE_KEY$1 = "Escape";
    const Default$5 = {
        backdrop: true,
        keyboard: true,
        focus: true,
    };
    const DefaultType$5 = {
        backdrop: "(boolean|string)",
        keyboard: "boolean",
        focus: "boolean",
    };
    const EVENT_HIDE$3 = `hide${EVENT_KEY$6}`;
    const EVENT_HIDE_PREVENTED = `hidePrevented${EVENT_KEY$6}`;
    const EVENT_HIDDEN$3 = `hidden${EVENT_KEY$6}`;
    const EVENT_SHOW$3 = `show${EVENT_KEY$6}`;
    const EVENT_SHOWN$3 = `shown${EVENT_KEY$6}`;
    const EVENT_RESIZE = `resize${EVENT_KEY$6}`;
    const EVENT_CLICK_DISMISS = `click.dismiss${EVENT_KEY$6}`;
    const EVENT_KEYDOWN_DISMISS$1 = `keydown.dismiss${EVENT_KEY$6}`;
    const EVENT_MOUSEUP_DISMISS = `mouseup.dismiss${EVENT_KEY$6}`;
    const EVENT_MOUSEDOWN_DISMISS = `mousedown.dismiss${EVENT_KEY$6}`;
    const EVENT_CLICK_DATA_API$2 = `click${EVENT_KEY$6}${DATA_API_KEY$3}`;
    const CLASS_NAME_OPEN = "modal-open";
    const CLASS_NAME_FADE$3 = "fade";
    const CLASS_NAME_SHOW$4 = "show";
    const CLASS_NAME_STATIC = "modal-static";
    const OPEN_SELECTOR$1 = ".modal.show";
    const SELECTOR_DIALOG = ".modal-dialog";
    const SELECTOR_MODAL_BODY = ".modal-body";
    const SELECTOR_DATA_TOGGLE$2 = '[data-bs-toggle="modal"]';
    /**
     * ------------------------------------------------------------------------
     * Class Definition
     * ------------------------------------------------------------------------
     */

    class Modal extends BaseComponent {
        constructor(element, config) {
            super(element);
            this._config = this._getConfig(config);
            this._dialog = SelectorEngine.findOne(
                SELECTOR_DIALOG,
                this._element
            );
            this._backdrop = this._initializeBackDrop();
            this._focustrap = this._initializeFocusTrap();
            this._isShown = false;
            this._ignoreBackdropClick = false;
            this._isTransitioning = false;
            this._scrollBar = new ScrollBarHelper();
        } // Getters

        static get Default() {
            return Default$5;
        }

        static get NAME() {
            return NAME$6;
        } // Public

        toggle(relatedTarget) {
            return this._isShown ? this.hide() : this.show(relatedTarget);
        }

        show(relatedTarget) {
            if (this._isShown || this._isTransitioning) {
                return;
            }

            const showEvent = EventHandler.trigger(
                this._element,
                EVENT_SHOW$3,
                {
                    relatedTarget,
                }
            );

            if (showEvent.defaultPrevented) {
                return;
            }

            this._isShown = true;

            if (this._isAnimated()) {
                this._isTransitioning = true;
            }

            this._scrollBar.hide();

            document.body.classList.add(CLASS_NAME_OPEN);

            this._adjustDialog();

            this._setEscapeEvent();

            this._setResizeEvent();

            EventHandler.on(this._dialog, EVENT_MOUSEDOWN_DISMISS, () => {
                EventHandler.one(
                    this._element,
                    EVENT_MOUSEUP_DISMISS,
                    (event) => {
                        if (event.target === this._element) {
                            this._ignoreBackdropClick = true;
                        }
                    }
                );
            });

            this._showBackdrop(() => this._showElement(relatedTarget));
        }

        hide() {
            if (!this._isShown || this._isTransitioning) {
                return;
            }

            const hideEvent = EventHandler.trigger(this._element, EVENT_HIDE$3);

            if (hideEvent.defaultPrevented) {
                return;
            }

            this._isShown = false;

            const isAnimated = this._isAnimated();

            if (isAnimated) {
                this._isTransitioning = true;
            }

            this._setEscapeEvent();

            this._setResizeEvent();

            this._focustrap.deactivate();

            this._element.classList.remove(CLASS_NAME_SHOW$4);

            EventHandler.off(this._element, EVENT_CLICK_DISMISS);
            EventHandler.off(this._dialog, EVENT_MOUSEDOWN_DISMISS);

            this._queueCallback(
                () => this._hideModal(),
                this._element,
                isAnimated
            );
        }

        dispose() {
            [window, this._dialog].forEach((htmlElement) =>
                EventHandler.off(htmlElement, EVENT_KEY$6)
            );

            this._backdrop.dispose();

            this._focustrap.deactivate();

            super.dispose();
        }

        handleUpdate() {
            this._adjustDialog();
        } // Private

        _initializeBackDrop() {
            return new Backdrop({
                isVisible: Boolean(this._config.backdrop),
                // 'static' option will be translated to true, and booleans will keep their value
                isAnimated: this._isAnimated(),
            });
        }

        _initializeFocusTrap() {
            return new FocusTrap({
                trapElement: this._element,
            });
        }

        _getConfig(config) {
            config = {
                ...Default$5,
                ...Manipulator.getDataAttributes(this._element),
                ...(typeof config === "object" ? config : {}),
            };
            typeCheckConfig(NAME$6, config, DefaultType$5);
            return config;
        }

        _showElement(relatedTarget) {
            const isAnimated = this._isAnimated();

            const modalBody = SelectorEngine.findOne(
                SELECTOR_MODAL_BODY,
                this._dialog
            );

            if (
                !this._element.parentNode ||
                this._element.parentNode.nodeType !== Node.ELEMENT_NODE
            ) {
                // Don't move modal's DOM position
                document.body.append(this._element);
            }

            this._element.style.display = "block";

            this._element.removeAttribute("aria-hidden");

            this._element.setAttribute("aria-modal", true);

            this._element.setAttribute("role", "dialog");

            this._element.scrollTop = 0;

            if (modalBody) {
                modalBody.scrollTop = 0;
            }

            if (isAnimated) {
                reflow(this._element);
            }

            this._element.classList.add(CLASS_NAME_SHOW$4);

            const transitionComplete = () => {
                if (this._config.focus) {
                    this._focustrap.activate();
                }

                this._isTransitioning = false;
                EventHandler.trigger(this._element, EVENT_SHOWN$3, {
                    relatedTarget,
                });
            };

            this._queueCallback(transitionComplete, this._dialog, isAnimated);
        }

        _setEscapeEvent() {
            if (this._isShown) {
                EventHandler.on(
                    this._element,
                    EVENT_KEYDOWN_DISMISS$1,
                    (event) => {
                        if (
                            this._config.keyboard &&
                            event.key === ESCAPE_KEY$1
                        ) {
                            event.preventDefault();
                            this.hide();
                        } else if (
                            !this._config.keyboard &&
                            event.key === ESCAPE_KEY$1
                        ) {
                            this._triggerBackdropTransition();
                        }
                    }
                );
            } else {
                EventHandler.off(this._element, EVENT_KEYDOWN_DISMISS$1);
            }
        }

        _setResizeEvent() {
            if (this._isShown) {
                EventHandler.on(window, EVENT_RESIZE, () =>
                    this._adjustDialog()
                );
            } else {
                EventHandler.off(window, EVENT_RESIZE);
            }
        }

        _hideModal() {
            this._element.style.display = "none";

            this._element.setAttribute("aria-hidden", true);

            this._element.removeAttribute("aria-modal");

            this._element.removeAttribute("role");

            this._isTransitioning = false;

            this._backdrop.hide(() => {
                document.body.classList.remove(CLASS_NAME_OPEN);

                this._resetAdjustments();

                this._scrollBar.reset();

                EventHandler.trigger(this._element, EVENT_HIDDEN$3);
            });
        }

        _showBackdrop(callback) {
            EventHandler.on(this._element, EVENT_CLICK_DISMISS, (event) => {
                if (this._ignoreBackdropClick) {
                    this._ignoreBackdropClick = false;
                    return;
                }

                if (event.target !== event.currentTarget) {
                    return;
                }

                if (this._config.backdrop === true) {
                    this.hide();
                } else if (this._config.backdrop === "static") {
                    this._triggerBackdropTransition();
                }
            });

            this._backdrop.show(callback);
        }

        _isAnimated() {
            return this._element.classList.contains(CLASS_NAME_FADE$3);
        }

        _triggerBackdropTransition() {
            const hideEvent = EventHandler.trigger(
                this._element,
                EVENT_HIDE_PREVENTED
            );

            if (hideEvent.defaultPrevented) {
                return;
            }

            const { classList, scrollHeight, style } = this._element;
            const isModalOverflowing =
                scrollHeight > document.documentElement.clientHeight; // return if the following background transition hasn't yet completed

            if (
                (!isModalOverflowing && style.overflowY === "hidden") ||
                classList.contains(CLASS_NAME_STATIC)
            ) {
                return;
            }

            if (!isModalOverflowing) {
                style.overflowY = "hidden";
            }

            classList.add(CLASS_NAME_STATIC);

            this._queueCallback(() => {
                classList.remove(CLASS_NAME_STATIC);

                if (!isModalOverflowing) {
                    this._queueCallback(() => {
                        style.overflowY = "";
                    }, this._dialog);
                }
            }, this._dialog);

            this._element.focus();
        } // ----------------------------------------------------------------------
        // the following methods are used to handle overflowing modals
        // ----------------------------------------------------------------------

        _adjustDialog() {
            const isModalOverflowing =
                this._element.scrollHeight >
                document.documentElement.clientHeight;

            const scrollbarWidth = this._scrollBar.getWidth();

            const isBodyOverflowing = scrollbarWidth > 0;

            if (
                (!isBodyOverflowing && isModalOverflowing && !isRTL()) ||
                (isBodyOverflowing && !isModalOverflowing && isRTL())
            ) {
                this._element.style.paddingLeft = `${scrollbarWidth}px`;
            }

            if (
                (isBodyOverflowing && !isModalOverflowing && !isRTL()) ||
                (!isBodyOverflowing && isModalOverflowing && isRTL())
            ) {
                this._element.style.paddingRight = `${scrollbarWidth}px`;
            }
        }

        _resetAdjustments() {
            this._element.style.paddingLeft = "";
            this._element.style.paddingRight = "";
        } // Static

        static jQueryInterface(config, relatedTarget) {
            return this.each(function () {
                const data = Modal.getOrCreateInstance(this, config);

                if (typeof config !== "string") {
                    return;
                }

                if (typeof data[config] === "undefined") {
                    throw new TypeError(`No method named "${config}"`);
                }

                data[config](relatedTarget);
            });
        }
    }
    /**
     * ------------------------------------------------------------------------
     * Data Api implementation
     * ------------------------------------------------------------------------
     */

    EventHandler.on(
        document,
        EVENT_CLICK_DATA_API$2,
        SELECTOR_DATA_TOGGLE$2,
        function (event) {
            const target = getElementFromSelector(this);

            if (["A", "AREA"].includes(this.tagName)) {
                event.preventDefault();
            }

            EventHandler.one(target, EVENT_SHOW$3, (showEvent) => {
                if (showEvent.defaultPrevented) {
                    // only register focus restorer if modal will actually get shown
                    return;
                }

                EventHandler.one(target, EVENT_HIDDEN$3, () => {
                    if (isVisible(this)) {
                        this.focus();
                    }
                });
            }); // avoid conflict when clicking moddal toggler while another one is open

            const allReadyOpen = SelectorEngine.findOne(OPEN_SELECTOR$1);

            if (allReadyOpen) {
                Modal.getInstance(allReadyOpen).hide();
            }

            const data = Modal.getOrCreateInstance(target);
            data.toggle(this);
        }
    );
    enableDismissTrigger(Modal);
    /**
     * ------------------------------------------------------------------------
     * jQuery
     * ------------------------------------------------------------------------
     * add .Modal to jQuery only if jQuery is present
     */

    defineJQueryPlugin(Modal);

    /**
     * --------------------------------------------------------------------------
     * Bootstrap (v5.1.3): offcanvas.js
     * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
     * --------------------------------------------------------------------------
     */
    /**
     * ------------------------------------------------------------------------
     * Constants
     * ------------------------------------------------------------------------
     */

    const NAME$5 = "offcanvas";
    const DATA_KEY$5 = "bs.offcanvas";
    const EVENT_KEY$5 = `.${DATA_KEY$5}`;
    const DATA_API_KEY$2 = ".data-api";
    const EVENT_LOAD_DATA_API$1 = `load${EVENT_KEY$5}${DATA_API_KEY$2}`;
    const ESCAPE_KEY = "Escape";
    const Default$4 = {
        backdrop: true,
        keyboard: true,
        scroll: false,
    };
    const DefaultType$4 = {
        backdrop: "boolean",
        keyboard: "boolean",
        scroll: "boolean",
    };
    const CLASS_NAME_SHOW$3 = "show";
    const CLASS_NAME_BACKDROP = "offcanvas-backdrop";
    const OPEN_SELECTOR = ".offcanvas.show";
    const EVENT_SHOW$2 = `show${EVENT_KEY$5}`;
    const EVENT_SHOWN$2 = `shown${EVENT_KEY$5}`;
    const EVENT_HIDE$2 = `hide${EVENT_KEY$5}`;
    const EVENT_HIDDEN$2 = `hidden${EVENT_KEY$5}`;
    const EVENT_CLICK_DATA_API$1 = `click${EVENT_KEY$5}${DATA_API_KEY$2}`;
    const EVENT_KEYDOWN_DISMISS = `keydown.dismiss${EVENT_KEY$5}`;
    const SELECTOR_DATA_TOGGLE$1 = '[data-bs-toggle="offcanvas"]';
    /**
     * ------------------------------------------------------------------------
     * Class Definition
     * ------------------------------------------------------------------------
     */

    class Offcanvas extends BaseComponent {
        constructor(element, config) {
            super(element);
            this._config = this._getConfig(config);
            this._isShown = false;
            this._backdrop = this._initializeBackDrop();
            this._focustrap = this._initializeFocusTrap();

            this._addEventListeners();
        } // Getters

        static get NAME() {
            return NAME$5;
        }

        static get Default() {
            return Default$4;
        } // Public

        toggle(relatedTarget) {
            return this._isShown ? this.hide() : this.show(relatedTarget);
        }

        show(relatedTarget) {
            if (this._isShown) {
                return;
            }

            const showEvent = EventHandler.trigger(
                this._element,
                EVENT_SHOW$2,
                {
                    relatedTarget,
                }
            );

            if (showEvent.defaultPrevented) {
                return;
            }

            this._isShown = true;
            this._element.style.visibility = "visible";

            this._backdrop.show();

            if (!this._config.scroll) {
                new ScrollBarHelper().hide();
            }

            this._element.removeAttribute("aria-hidden");

            this._element.setAttribute("aria-modal", true);

            this._element.setAttribute("role", "dialog");

            this._element.classList.add(CLASS_NAME_SHOW$3);

            const completeCallBack = () => {
                if (!this._config.scroll) {
                    this._focustrap.activate();
                }

                EventHandler.trigger(this._element, EVENT_SHOWN$2, {
                    relatedTarget,
                });
            };

            this._queueCallback(completeCallBack, this._element, true);
        }

        hide() {
            if (!this._isShown) {
                return;
            }

            const hideEvent = EventHandler.trigger(this._element, EVENT_HIDE$2);

            if (hideEvent.defaultPrevented) {
                return;
            }

            this._focustrap.deactivate();

            this._element.blur();

            this._isShown = false;

            this._element.classList.remove(CLASS_NAME_SHOW$3);

            this._backdrop.hide();

            const completeCallback = () => {
                this._element.setAttribute("aria-hidden", true);

                this._element.removeAttribute("aria-modal");

                this._element.removeAttribute("role");

                this._element.style.visibility = "hidden";

                if (!this._config.scroll) {
                    new ScrollBarHelper().reset();
                }

                EventHandler.trigger(this._element, EVENT_HIDDEN$2);
            };

            this._queueCallback(completeCallback, this._element, true);
        }

        dispose() {
            this._backdrop.dispose();

            this._focustrap.deactivate();

            super.dispose();
        } // Private

        _getConfig(config) {
            config = {
                ...Default$4,
                ...Manipulator.getDataAttributes(this._element),
                ...(typeof config === "object" ? config : {}),
            };
            typeCheckConfig(NAME$5, config, DefaultType$4);
            return config;
        }

        _initializeBackDrop() {
            return new Backdrop({
                className: CLASS_NAME_BACKDROP,
                isVisible: this._config.backdrop,
                isAnimated: true,
                rootElement: this._element.parentNode,
                clickCallback: () => this.hide(),
            });
        }

        _initializeFocusTrap() {
            return new FocusTrap({
                trapElement: this._element,
            });
        }

        _addEventListeners() {
            EventHandler.on(this._element, EVENT_KEYDOWN_DISMISS, (event) => {
                if (this._config.keyboard && event.key === ESCAPE_KEY) {
                    this.hide();
                }
            });
        } // Static

        static jQueryInterface(config) {
            return this.each(function () {
                const data = Offcanvas.getOrCreateInstance(this, config);

                if (typeof config !== "string") {
                    return;
                }

                if (
                    data[config] === undefined ||
                    config.startsWith("_") ||
                    config === "constructor"
                ) {
                    throw new TypeError(`No method named "${config}"`);
                }

                data[config](this);
            });
        }
    }
    /**
     * ------------------------------------------------------------------------
     * Data Api implementation
     * ------------------------------------------------------------------------
     */

    EventHandler.on(
        document,
        EVENT_CLICK_DATA_API$1,
        SELECTOR_DATA_TOGGLE$1,
        function (event) {
            const target = getElementFromSelector(this);

            if (["A", "AREA"].includes(this.tagName)) {
                event.preventDefault();
            }

            if (isDisabled(this)) {
                return;
            }

            EventHandler.one(target, EVENT_HIDDEN$2, () => {
                // focus on trigger when it is closed
                if (isVisible(this)) {
                    this.focus();
                }
            }); // avoid conflict when clicking a toggler of an offcanvas, while another is open

            const allReadyOpen = SelectorEngine.findOne(OPEN_SELECTOR);

            if (allReadyOpen && allReadyOpen !== target) {
                Offcanvas.getInstance(allReadyOpen).hide();
            }

            const data = Offcanvas.getOrCreateInstance(target);
            data.toggle(this);
        }
    );
    EventHandler.on(window, EVENT_LOAD_DATA_API$1, () =>
        SelectorEngine.find(OPEN_SELECTOR).forEach((el) =>
            Offcanvas.getOrCreateInstance(el).show()
        )
    );
    enableDismissTrigger(Offcanvas);
    /**
     * ------------------------------------------------------------------------
     * jQuery
     * ------------------------------------------------------------------------
     */

    defineJQueryPlugin(Offcanvas);

    /**
     * --------------------------------------------------------------------------
     * Bootstrap (v5.1.3): util/sanitizer.js
     * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
     * --------------------------------------------------------------------------
     */
    const uriAttributes = new Set([
        "background",
        "cite",
        "href",
        "itemtype",
        "longdesc",
        "poster",
        "src",
        "xlink:href",
    ]);
    const ARIA_ATTRIBUTE_PATTERN = /^aria-[\w-]*$/i;
    /**
     * A pattern that recognizes a commonly useful subset of URLs that are safe.
     *
     * Shoutout to Angular https://github.com/angular/angular/blob/12.2.x/packages/core/src/sanitization/url_sanitizer.ts
     */

    const SAFE_URL_PATTERN =
        /^(?:(?:https?|mailto|ftp|tel|file|sms):|[^#&/:?]*(?:[#/?]|$))/i;
    /**
     * A pattern that matches safe data URLs. Only matches image, video and audio types.
     *
     * Shoutout to Angular https://github.com/angular/angular/blob/12.2.x/packages/core/src/sanitization/url_sanitizer.ts
     */

    const DATA_URL_PATTERN =
        /^data:(?:image\/(?:bmp|gif|jpeg|jpg|png|tiff|webp)|video\/(?:mpeg|mp4|ogg|webm)|audio\/(?:mp3|oga|ogg|opus));base64,[\d+/a-z]+=*$/i;

    const allowedAttribute = (attribute, allowedAttributeList) => {
        const attributeName = attribute.nodeName.toLowerCase();

        if (allowedAttributeList.includes(attributeName)) {
            if (uriAttributes.has(attributeName)) {
                return Boolean(
                    SAFE_URL_PATTERN.test(attribute.nodeValue) ||
                        DATA_URL_PATTERN.test(attribute.nodeValue)
                );
            }

            return true;
        }

        const regExp = allowedAttributeList.filter(
            (attributeRegex) => attributeRegex instanceof RegExp
        ); // Check if a regular expression validates the attribute.

        for (let i = 0, len = regExp.length; i < len; i++) {
            if (regExp[i].test(attributeName)) {
                return true;
            }
        }

        return false;
    };

    const DefaultAllowlist = {
        // Global attributes allowed on any supplied element below.
        "*": ["class", "dir", "id", "lang", "role", ARIA_ATTRIBUTE_PATTERN],
        a: ["target", "href", "title", "rel"],
        area: [],
        b: [],
        br: [],
        col: [],
        code: [],
        div: [],
        em: [],
        hr: [],
        h1: [],
        h2: [],
        h3: [],
        h4: [],
        h5: [],
        h6: [],
        i: [],
        img: ["src", "srcset", "alt", "title", "width", "height"],
        li: [],
        ol: [],
        p: [],
        pre: [],
        s: [],
        small: [],
        span: [],
        sub: [],
        sup: [],
        strong: [],
        u: [],
        ul: [],
    };
    function sanitizeHtml(unsafeHtml, allowList, sanitizeFn) {
        if (!unsafeHtml.length) {
            return unsafeHtml;
        }

        if (sanitizeFn && typeof sanitizeFn === "function") {
            return sanitizeFn(unsafeHtml);
        }

        const domParser = new window.DOMParser();
        const createdDocument = domParser.parseFromString(
            unsafeHtml,
            "text/html"
        );
        const elements = [].concat(
            ...createdDocument.body.querySelectorAll("*")
        );

        for (let i = 0, len = elements.length; i < len; i++) {
            const element = elements[i];
            const elementName = element.nodeName.toLowerCase();

            if (!Object.keys(allowList).includes(elementName)) {
                element.remove();
                continue;
            }

            const attributeList = [].concat(...element.attributes);
            const allowedAttributes = [].concat(
                allowList["*"] || [],
                allowList[elementName] || []
            );
            attributeList.forEach((attribute) => {
                if (!allowedAttribute(attribute, allowedAttributes)) {
                    element.removeAttribute(attribute.nodeName);
                }
            });
        }

        return createdDocument.body.innerHTML;
    }

    /**
     * --------------------------------------------------------------------------
     * Bootstrap (v5.1.3): tooltip.js
     * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
     * --------------------------------------------------------------------------
     */
    /**
     * ------------------------------------------------------------------------
     * Constants
     * ------------------------------------------------------------------------
     */

    const NAME$4 = "tooltip";
    const DATA_KEY$4 = "bs.tooltip";
    const EVENT_KEY$4 = `.${DATA_KEY$4}`;
    const CLASS_PREFIX$1 = "bs-tooltip";
    const DISALLOWED_ATTRIBUTES = new Set([
        "sanitize",
        "allowList",
        "sanitizeFn",
    ]);
    const DefaultType$3 = {
        animation: "boolean",
        template: "string",
        title: "(string|element|function)",
        trigger: "string",
        delay: "(number|object)",
        html: "boolean",
        selector: "(string|boolean)",
        placement: "(string|function)",
        offset: "(array|string|function)",
        container: "(string|element|boolean)",
        fallbackPlacements: "array",
        boundary: "(string|element)",
        customClass: "(string|function)",
        sanitize: "boolean",
        sanitizeFn: "(null|function)",
        allowList: "object",
        popperConfig: "(null|object|function)",
    };
    const AttachmentMap = {
        AUTO: "auto",
        TOP: "top",
        RIGHT: isRTL() ? "left" : "right",
        BOTTOM: "bottom",
        LEFT: isRTL() ? "right" : "left",
    };
    const Default$3 = {
        animation: true,
        template:
            '<div class="tooltip" role="tooltip">' +
            '<div class="tooltip-arrow"></div>' +
            '<div class="tooltip-inner"></div>' +
            "</div>",
        trigger: "hover focus",
        title: "",
        delay: 0,
        html: false,
        selector: false,
        placement: "top",
        offset: [0, 0],
        container: false,
        fallbackPlacements: ["top", "right", "bottom", "left"],
        boundary: "clippingParents",
        customClass: "",
        sanitize: true,
        sanitizeFn: null,
        allowList: DefaultAllowlist,
        popperConfig: null,
    };
    const Event$2 = {
        HIDE: `hide${EVENT_KEY$4}`,
        HIDDEN: `hidden${EVENT_KEY$4}`,
        SHOW: `show${EVENT_KEY$4}`,
        SHOWN: `shown${EVENT_KEY$4}`,
        INSERTED: `inserted${EVENT_KEY$4}`,
        CLICK: `click${EVENT_KEY$4}`,
        FOCUSIN: `focusin${EVENT_KEY$4}`,
        FOCUSOUT: `focusout${EVENT_KEY$4}`,
        MOUSEENTER: `mouseenter${EVENT_KEY$4}`,
        MOUSELEAVE: `mouseleave${EVENT_KEY$4}`,
    };
    const CLASS_NAME_FADE$2 = "fade";
    const CLASS_NAME_MODAL = "modal";
    const CLASS_NAME_SHOW$2 = "show";
    const HOVER_STATE_SHOW = "show";
    const HOVER_STATE_OUT = "out";
    const SELECTOR_TOOLTIP_INNER = ".tooltip-inner";
    const SELECTOR_MODAL = `.${CLASS_NAME_MODAL}`;
    const EVENT_MODAL_HIDE = "hide.bs.modal";
    const TRIGGER_HOVER = "hover";
    const TRIGGER_FOCUS = "focus";
    const TRIGGER_CLICK = "click";
    const TRIGGER_MANUAL = "manual";
    /**
     * ------------------------------------------------------------------------
     * Class Definition
     * ------------------------------------------------------------------------
     */

    class Tooltip extends BaseComponent {
        constructor(element, config) {
            if (typeof Popper === "undefined") {
                throw new TypeError(
                    "Bootstrap's tooltips require Popper (https://popper.js.org)"
                );
            }

            super(element); // private

            this._isEnabled = true;
            this._timeout = 0;
            this._hoverState = "";
            this._activeTrigger = {};
            this._popper = null; // Protected

            this._config = this._getConfig(config);
            this.tip = null;

            this._setListeners();
        } // Getters

        static get Default() {
            return Default$3;
        }

        static get NAME() {
            return NAME$4;
        }

        static get Event() {
            return Event$2;
        }

        static get DefaultType() {
            return DefaultType$3;
        } // Public

        enable() {
            this._isEnabled = true;
        }

        disable() {
            this._isEnabled = false;
        }

        toggleEnabled() {
            this._isEnabled = !this._isEnabled;
        }

        toggle(event) {
            if (!this._isEnabled) {
                return;
            }

            if (event) {
                const context = this._initializeOnDelegatedTarget(event);

                context._activeTrigger.click = !context._activeTrigger.click;

                if (context._isWithActiveTrigger()) {
                    context._enter(null, context);
                } else {
                    context._leave(null, context);
                }
            } else {
                if (
                    this.getTipElement().classList.contains(CLASS_NAME_SHOW$2)
                ) {
                    this._leave(null, this);

                    return;
                }

                this._enter(null, this);
            }
        }

        dispose() {
            clearTimeout(this._timeout);
            EventHandler.off(
                this._element.closest(SELECTOR_MODAL),
                EVENT_MODAL_HIDE,
                this._hideModalHandler
            );

            if (this.tip) {
                this.tip.remove();
            }

            this._disposePopper();

            super.dispose();
        }

        show() {
            if (this._element.style.display === "none") {
                throw new Error("Please use show on visible elements");
            }

            if (!(this.isWithContent() && this._isEnabled)) {
                return;
            }

            const showEvent = EventHandler.trigger(
                this._element,
                this.constructor.Event.SHOW
            );
            const shadowRoot = findShadowRoot(this._element);
            const isInTheDom =
                shadowRoot === null
                    ? this._element.ownerDocument.documentElement.contains(
                          this._element
                      )
                    : shadowRoot.contains(this._element);

            if (showEvent.defaultPrevented || !isInTheDom) {
                return;
            } // A trick to recreate a tooltip in case a new title is given by using the NOT documented `data-bs-original-title`
            // This will be removed later in favor of a `setContent` method

            if (
                this.constructor.NAME === "tooltip" &&
                this.tip &&
                this.getTitle() !==
                    this.tip.querySelector(SELECTOR_TOOLTIP_INNER).innerHTML
            ) {
                this._disposePopper();

                this.tip.remove();
                this.tip = null;
            }

            const tip = this.getTipElement();
            const tipId = getUID(this.constructor.NAME);
            tip.setAttribute("id", tipId);

            this._element.setAttribute("aria-describedby", tipId);

            if (this._config.animation) {
                tip.classList.add(CLASS_NAME_FADE$2);
            }

            const placement =
                typeof this._config.placement === "function"
                    ? this._config.placement.call(this, tip, this._element)
                    : this._config.placement;

            const attachment = this._getAttachment(placement);

            this._addAttachmentClass(attachment);

            const { container } = this._config;
            Data.set(tip, this.constructor.DATA_KEY, this);

            if (
                !this._element.ownerDocument.documentElement.contains(this.tip)
            ) {
                container.append(tip);
                EventHandler.trigger(
                    this._element,
                    this.constructor.Event.INSERTED
                );
            }

            if (this._popper) {
                this._popper.update();
            } else {
                this._popper = createPopper(
                    this._element,
                    tip,
                    this._getPopperConfig(attachment)
                );
            }

            tip.classList.add(CLASS_NAME_SHOW$2);

            const customClass = this._resolvePossibleFunction(
                this._config.customClass
            );

            if (customClass) {
                tip.classList.add(...customClass.split(" "));
            } // If this is a touch-enabled device we add extra
            // empty mouseover listeners to the body's immediate children;
            // only needed because of broken event delegation on iOS
            // https://www.quirksmode.org/blog/archives/2014/02/mouse_event_bub.html

            if ("ontouchstart" in document.documentElement) {
                [].concat(...document.body.children).forEach((element) => {
                    EventHandler.on(element, "mouseover", noop);
                });
            }

            const complete = () => {
                const prevHoverState = this._hoverState;
                this._hoverState = null;
                EventHandler.trigger(
                    this._element,
                    this.constructor.Event.SHOWN
                );

                if (prevHoverState === HOVER_STATE_OUT) {
                    this._leave(null, this);
                }
            };

            const isAnimated = this.tip.classList.contains(CLASS_NAME_FADE$2);

            this._queueCallback(complete, this.tip, isAnimated);
        }

        hide() {
            if (!this._popper) {
                return;
            }

            const tip = this.getTipElement();

            const complete = () => {
                if (this._isWithActiveTrigger()) {
                    return;
                }

                if (this._hoverState !== HOVER_STATE_SHOW) {
                    tip.remove();
                }

                this._cleanTipClass();

                this._element.removeAttribute("aria-describedby");

                EventHandler.trigger(
                    this._element,
                    this.constructor.Event.HIDDEN
                );

                this._disposePopper();
            };

            const hideEvent = EventHandler.trigger(
                this._element,
                this.constructor.Event.HIDE
            );

            if (hideEvent.defaultPrevented) {
                return;
            }

            tip.classList.remove(CLASS_NAME_SHOW$2); // If this is a touch-enabled device we remove the extra
            // empty mouseover listeners we added for iOS support

            if ("ontouchstart" in document.documentElement) {
                []
                    .concat(...document.body.children)
                    .forEach((element) =>
                        EventHandler.off(element, "mouseover", noop)
                    );
            }

            this._activeTrigger[TRIGGER_CLICK] = false;
            this._activeTrigger[TRIGGER_FOCUS] = false;
            this._activeTrigger[TRIGGER_HOVER] = false;
            const isAnimated = this.tip.classList.contains(CLASS_NAME_FADE$2);

            this._queueCallback(complete, this.tip, isAnimated);

            this._hoverState = "";
        }

        update() {
            if (this._popper !== null) {
                this._popper.update();
            }
        } // Protected

        isWithContent() {
            return Boolean(this.getTitle());
        }

        getTipElement() {
            if (this.tip) {
                return this.tip;
            }

            const element = document.createElement("div");
            element.innerHTML = this._config.template;
            const tip = element.children[0];
            this.setContent(tip);
            tip.classList.remove(CLASS_NAME_FADE$2, CLASS_NAME_SHOW$2);
            this.tip = tip;
            return this.tip;
        }

        setContent(tip) {
            this._sanitizeAndSetContent(
                tip,
                this.getTitle(),
                SELECTOR_TOOLTIP_INNER
            );
        }

        _sanitizeAndSetContent(template, content, selector) {
            const templateElement = SelectorEngine.findOne(selector, template);

            if (!content && templateElement) {
                templateElement.remove();
                return;
            } // we use append for html objects to maintain js events

            this.setElementContent(templateElement, content);
        }

        setElementContent(element, content) {
            if (element === null) {
                return;
            }

            if (isElement$1(content)) {
                content = getElement(content); // content is a DOM node or a jQuery

                if (this._config.html) {
                    if (content.parentNode !== element) {
                        element.innerHTML = "";
                        element.append(content);
                    }
                } else {
                    element.textContent = content.textContent;
                }

                return;
            }

            if (this._config.html) {
                if (this._config.sanitize) {
                    content = sanitizeHtml(
                        content,
                        this._config.allowList,
                        this._config.sanitizeFn
                    );
                }

                element.innerHTML = content;
            } else {
                element.textContent = content;
            }
        }

        getTitle() {
            const title =
                this._element.getAttribute("data-bs-original-title") ||
                this._config.title;

            return this._resolvePossibleFunction(title);
        }

        updateAttachment(attachment) {
            if (attachment === "right") {
                return "end";
            }

            if (attachment === "left") {
                return "start";
            }

            return attachment;
        } // Private

        _initializeOnDelegatedTarget(event, context) {
            return (
                context ||
                this.constructor.getOrCreateInstance(
                    event.delegateTarget,
                    this._getDelegateConfig()
                )
            );
        }

        _getOffset() {
            const { offset } = this._config;

            if (typeof offset === "string") {
                return offset.split(",").map((val) => Number.parseInt(val, 10));
            }

            if (typeof offset === "function") {
                return (popperData) => offset(popperData, this._element);
            }

            return offset;
        }

        _resolvePossibleFunction(content) {
            return typeof content === "function"
                ? content.call(this._element)
                : content;
        }

        _getPopperConfig(attachment) {
            const defaultBsPopperConfig = {
                placement: attachment,
                modifiers: [
                    {
                        name: "flip",
                        options: {
                            fallbackPlacements: this._config.fallbackPlacements,
                        },
                    },
                    {
                        name: "offset",
                        options: {
                            offset: this._getOffset(),
                        },
                    },
                    {
                        name: "preventOverflow",
                        options: {
                            boundary: this._config.boundary,
                        },
                    },
                    {
                        name: "arrow",
                        options: {
                            element: `.${this.constructor.NAME}-arrow`,
                        },
                    },
                    {
                        name: "onChange",
                        enabled: true,
                        phase: "afterWrite",
                        fn: (data) => this._handlePopperPlacementChange(data),
                    },
                ],
                onFirstUpdate: (data) => {
                    if (data.options.placement !== data.placement) {
                        this._handlePopperPlacementChange(data);
                    }
                },
            };
            return {
                ...defaultBsPopperConfig,
                ...(typeof this._config.popperConfig === "function"
                    ? this._config.popperConfig(defaultBsPopperConfig)
                    : this._config.popperConfig),
            };
        }

        _addAttachmentClass(attachment) {
            this.getTipElement().classList.add(
                `${this._getBasicClassPrefix()}-${this.updateAttachment(
                    attachment
                )}`
            );
        }

        _getAttachment(placement) {
            return AttachmentMap[placement.toUpperCase()];
        }

        _setListeners() {
            const triggers = this._config.trigger.split(" ");

            triggers.forEach((trigger) => {
                if (trigger === "click") {
                    EventHandler.on(
                        this._element,
                        this.constructor.Event.CLICK,
                        this._config.selector,
                        (event) => this.toggle(event)
                    );
                } else if (trigger !== TRIGGER_MANUAL) {
                    const eventIn =
                        trigger === TRIGGER_HOVER
                            ? this.constructor.Event.MOUSEENTER
                            : this.constructor.Event.FOCUSIN;
                    const eventOut =
                        trigger === TRIGGER_HOVER
                            ? this.constructor.Event.MOUSELEAVE
                            : this.constructor.Event.FOCUSOUT;
                    EventHandler.on(
                        this._element,
                        eventIn,
                        this._config.selector,
                        (event) => this._enter(event)
                    );
                    EventHandler.on(
                        this._element,
                        eventOut,
                        this._config.selector,
                        (event) => this._leave(event)
                    );
                }
            });

            this._hideModalHandler = () => {
                if (this._element) {
                    this.hide();
                }
            };

            EventHandler.on(
                this._element.closest(SELECTOR_MODAL),
                EVENT_MODAL_HIDE,
                this._hideModalHandler
            );

            if (this._config.selector) {
                this._config = {
                    ...this._config,
                    trigger: "manual",
                    selector: "",
                };
            } else {
                this._fixTitle();
            }
        }

        _fixTitle() {
            const title = this._element.getAttribute("title");

            const originalTitleType = typeof this._element.getAttribute(
                "data-bs-original-title"
            );

            if (title || originalTitleType !== "string") {
                this._element.setAttribute(
                    "data-bs-original-title",
                    title || ""
                );

                if (
                    title &&
                    !this._element.getAttribute("aria-label") &&
                    !this._element.textContent
                ) {
                    this._element.setAttribute("aria-label", title);
                }

                this._element.setAttribute("title", "");
            }
        }

        _enter(event, context) {
            context = this._initializeOnDelegatedTarget(event, context);

            if (event) {
                context._activeTrigger[
                    event.type === "focusin" ? TRIGGER_FOCUS : TRIGGER_HOVER
                ] = true;
            }

            if (
                context.getTipElement().classList.contains(CLASS_NAME_SHOW$2) ||
                context._hoverState === HOVER_STATE_SHOW
            ) {
                context._hoverState = HOVER_STATE_SHOW;
                return;
            }

            clearTimeout(context._timeout);
            context._hoverState = HOVER_STATE_SHOW;

            if (!context._config.delay || !context._config.delay.show) {
                context.show();
                return;
            }

            context._timeout = setTimeout(() => {
                if (context._hoverState === HOVER_STATE_SHOW) {
                    context.show();
                }
            }, context._config.delay.show);
        }

        _leave(event, context) {
            context = this._initializeOnDelegatedTarget(event, context);

            if (event) {
                context._activeTrigger[
                    event.type === "focusout" ? TRIGGER_FOCUS : TRIGGER_HOVER
                ] = context._element.contains(event.relatedTarget);
            }

            if (context._isWithActiveTrigger()) {
                return;
            }

            clearTimeout(context._timeout);
            context._hoverState = HOVER_STATE_OUT;

            if (!context._config.delay || !context._config.delay.hide) {
                context.hide();
                return;
            }

            context._timeout = setTimeout(() => {
                if (context._hoverState === HOVER_STATE_OUT) {
                    context.hide();
                }
            }, context._config.delay.hide);
        }

        _isWithActiveTrigger() {
            for (const trigger in this._activeTrigger) {
                if (this._activeTrigger[trigger]) {
                    return true;
                }
            }

            return false;
        }

        _getConfig(config) {
            const dataAttributes = Manipulator.getDataAttributes(this._element);
            Object.keys(dataAttributes).forEach((dataAttr) => {
                if (DISALLOWED_ATTRIBUTES.has(dataAttr)) {
                    delete dataAttributes[dataAttr];
                }
            });
            config = {
                ...this.constructor.Default,
                ...dataAttributes,
                ...(typeof config === "object" && config ? config : {}),
            };
            config.container =
                config.container === false
                    ? document.body
                    : getElement(config.container);

            if (typeof config.delay === "number") {
                config.delay = {
                    show: config.delay,
                    hide: config.delay,
                };
            }

            if (typeof config.title === "number") {
                config.title = config.title.toString();
            }

            if (typeof config.content === "number") {
                config.content = config.content.toString();
            }

            typeCheckConfig(NAME$4, config, this.constructor.DefaultType);

            if (config.sanitize) {
                config.template = sanitizeHtml(
                    config.template,
                    config.allowList,
                    config.sanitizeFn
                );
            }

            return config;
        }

        _getDelegateConfig() {
            const config = {};

            for (const key in this._config) {
                if (this.constructor.Default[key] !== this._config[key]) {
                    config[key] = this._config[key];
                }
            } // In the future can be replaced with:
            // const keysWithDifferentValues = Object.entries(this._config).filter(entry => this.constructor.Default[entry[0]] !== this._config[entry[0]])
            // `Object.fromEntries(keysWithDifferentValues)`

            return config;
        }

        _cleanTipClass() {
            const tip = this.getTipElement();
            const basicClassPrefixRegex = new RegExp(
                `(^|\\s)${this._getBasicClassPrefix()}\\S+`,
                "g"
            );
            const tabClass = tip
                .getAttribute("class")
                .match(basicClassPrefixRegex);

            if (tabClass !== null && tabClass.length > 0) {
                tabClass
                    .map((token) => token.trim())
                    .forEach((tClass) => tip.classList.remove(tClass));
            }
        }

        _getBasicClassPrefix() {
            return CLASS_PREFIX$1;
        }

        _handlePopperPlacementChange(popperData) {
            const { state } = popperData;

            if (!state) {
                return;
            }

            this.tip = state.elements.popper;

            this._cleanTipClass();

            this._addAttachmentClass(this._getAttachment(state.placement));
        }

        _disposePopper() {
            if (this._popper) {
                this._popper.destroy();

                this._popper = null;
            }
        } // Static

        static jQueryInterface(config) {
            return this.each(function () {
                const data = Tooltip.getOrCreateInstance(this, config);

                if (typeof config === "string") {
                    if (typeof data[config] === "undefined") {
                        throw new TypeError(`No method named "${config}"`);
                    }

                    data[config]();
                }
            });
        }
    }
    /**
     * ------------------------------------------------------------------------
     * jQuery
     * ------------------------------------------------------------------------
     * add .Tooltip to jQuery only if jQuery is present
     */

    defineJQueryPlugin(Tooltip);

    /**
     * --------------------------------------------------------------------------
     * Bootstrap (v5.1.3): popover.js
     * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
     * --------------------------------------------------------------------------
     */
    /**
     * ------------------------------------------------------------------------
     * Constants
     * ------------------------------------------------------------------------
     */

    const NAME$3 = "popover";
    const DATA_KEY$3 = "bs.popover";
    const EVENT_KEY$3 = `.${DATA_KEY$3}`;
    const CLASS_PREFIX = "bs-popover";
    const Default$2 = {
        ...Tooltip.Default,
        placement: "right",
        offset: [0, 8],
        trigger: "click",
        content: "",
        template:
            '<div class="popover" role="tooltip">' +
            '<div class="popover-arrow"></div>' +
            '<h3 class="popover-header"></h3>' +
            '<div class="popover-body"></div>' +
            "</div>",
    };
    const DefaultType$2 = {
        ...Tooltip.DefaultType,
        content: "(string|element|function)",
    };
    const Event$1 = {
        HIDE: `hide${EVENT_KEY$3}`,
        HIDDEN: `hidden${EVENT_KEY$3}`,
        SHOW: `show${EVENT_KEY$3}`,
        SHOWN: `shown${EVENT_KEY$3}`,
        INSERTED: `inserted${EVENT_KEY$3}`,
        CLICK: `click${EVENT_KEY$3}`,
        FOCUSIN: `focusin${EVENT_KEY$3}`,
        FOCUSOUT: `focusout${EVENT_KEY$3}`,
        MOUSEENTER: `mouseenter${EVENT_KEY$3}`,
        MOUSELEAVE: `mouseleave${EVENT_KEY$3}`,
    };
    const SELECTOR_TITLE = ".popover-header";
    const SELECTOR_CONTENT = ".popover-body";
    /**
     * ------------------------------------------------------------------------
     * Class Definition
     * ------------------------------------------------------------------------
     */

    class Popover extends Tooltip {
        // Getters
        static get Default() {
            return Default$2;
        }

        static get NAME() {
            return NAME$3;
        }

        static get Event() {
            return Event$1;
        }

        static get DefaultType() {
            return DefaultType$2;
        } // Overrides

        isWithContent() {
            return this.getTitle() || this._getContent();
        }

        setContent(tip) {
            this._sanitizeAndSetContent(tip, this.getTitle(), SELECTOR_TITLE);

            this._sanitizeAndSetContent(
                tip,
                this._getContent(),
                SELECTOR_CONTENT
            );
        } // Private

        _getContent() {
            return this._resolvePossibleFunction(this._config.content);
        }

        _getBasicClassPrefix() {
            return CLASS_PREFIX;
        } // Static

        static jQueryInterface(config) {
            return this.each(function () {
                const data = Popover.getOrCreateInstance(this, config);

                if (typeof config === "string") {
                    if (typeof data[config] === "undefined") {
                        throw new TypeError(`No method named "${config}"`);
                    }

                    data[config]();
                }
            });
        }
    }
    /**
     * ------------------------------------------------------------------------
     * jQuery
     * ------------------------------------------------------------------------
     * add .Popover to jQuery only if jQuery is present
     */

    defineJQueryPlugin(Popover);

    /**
     * --------------------------------------------------------------------------
     * Bootstrap (v5.1.3): scrollspy.js
     * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
     * --------------------------------------------------------------------------
     */
    /**
     * ------------------------------------------------------------------------
     * Constants
     * ------------------------------------------------------------------------
     */

    const NAME$2 = "scrollspy";
    const DATA_KEY$2 = "bs.scrollspy";
    const EVENT_KEY$2 = `.${DATA_KEY$2}`;
    const DATA_API_KEY$1 = ".data-api";
    const Default$1 = {
        offset: 10,
        method: "auto",
        target: "",
    };
    const DefaultType$1 = {
        offset: "number",
        method: "string",
        target: "(string|element)",
    };
    const EVENT_ACTIVATE = `activate${EVENT_KEY$2}`;
    const EVENT_SCROLL = `scroll${EVENT_KEY$2}`;
    const EVENT_LOAD_DATA_API = `load${EVENT_KEY$2}${DATA_API_KEY$1}`;
    const CLASS_NAME_DROPDOWN_ITEM = "dropdown-item";
    const CLASS_NAME_ACTIVE$1 = "active";
    const SELECTOR_DATA_SPY = '[data-bs-spy="scroll"]';
    const SELECTOR_NAV_LIST_GROUP$1 = ".nav, .list-group";
    const SELECTOR_NAV_LINKS = ".nav-link";
    const SELECTOR_NAV_ITEMS = ".nav-item";
    const SELECTOR_LIST_ITEMS = ".list-group-item";
    const SELECTOR_LINK_ITEMS = `${SELECTOR_NAV_LINKS}, ${SELECTOR_LIST_ITEMS}, .${CLASS_NAME_DROPDOWN_ITEM}`;
    const SELECTOR_DROPDOWN$1 = ".dropdown";
    const SELECTOR_DROPDOWN_TOGGLE$1 = ".dropdown-toggle";
    const METHOD_OFFSET = "offset";
    const METHOD_POSITION = "position";
    /**
     * ------------------------------------------------------------------------
     * Class Definition
     * ------------------------------------------------------------------------
     */

    class ScrollSpy extends BaseComponent {
        constructor(element, config) {
            super(element);
            this._scrollElement =
                this._element.tagName === "BODY" ? window : this._element;
            this._config = this._getConfig(config);
            this._offsets = [];
            this._targets = [];
            this._activeTarget = null;
            this._scrollHeight = 0;
            EventHandler.on(this._scrollElement, EVENT_SCROLL, () =>
                this._process()
            );
            this.refresh();

            this._process();
        } // Getters

        static get Default() {
            return Default$1;
        }

        static get NAME() {
            return NAME$2;
        } // Public

        refresh() {
            const autoMethod =
                this._scrollElement === this._scrollElement.window
                    ? METHOD_OFFSET
                    : METHOD_POSITION;
            const offsetMethod =
                this._config.method === "auto"
                    ? autoMethod
                    : this._config.method;
            const offsetBase =
                offsetMethod === METHOD_POSITION ? this._getScrollTop() : 0;
            this._offsets = [];
            this._targets = [];
            this._scrollHeight = this._getScrollHeight();
            const targets = SelectorEngine.find(
                SELECTOR_LINK_ITEMS,
                this._config.target
            );
            targets
                .map((element) => {
                    const targetSelector = getSelectorFromElement(element);
                    const target = targetSelector
                        ? SelectorEngine.findOne(targetSelector)
                        : null;

                    if (target) {
                        const targetBCR = target.getBoundingClientRect();

                        if (targetBCR.width || targetBCR.height) {
                            return [
                                Manipulator[offsetMethod](target).top +
                                    offsetBase,
                                targetSelector,
                            ];
                        }
                    }

                    return null;
                })
                .filter((item) => item)
                .sort((a, b) => a[0] - b[0])
                .forEach((item) => {
                    this._offsets.push(item[0]);

                    this._targets.push(item[1]);
                });
        }

        dispose() {
            EventHandler.off(this._scrollElement, EVENT_KEY$2);
            super.dispose();
        } // Private

        _getConfig(config) {
            config = {
                ...Default$1,
                ...Manipulator.getDataAttributes(this._element),
                ...(typeof config === "object" && config ? config : {}),
            };
            config.target =
                getElement(config.target) || document.documentElement;
            typeCheckConfig(NAME$2, config, DefaultType$1);
            return config;
        }

        _getScrollTop() {
            return this._scrollElement === window
                ? this._scrollElement.pageYOffset
                : this._scrollElement.scrollTop;
        }

        _getScrollHeight() {
            return (
                this._scrollElement.scrollHeight ||
                Math.max(
                    document.body.scrollHeight,
                    document.documentElement.scrollHeight
                )
            );
        }

        _getOffsetHeight() {
            return this._scrollElement === window
                ? window.innerHeight
                : this._scrollElement.getBoundingClientRect().height;
        }

        _process() {
            const scrollTop = this._getScrollTop() + this._config.offset;

            const scrollHeight = this._getScrollHeight();

            const maxScroll =
                this._config.offset + scrollHeight - this._getOffsetHeight();

            if (this._scrollHeight !== scrollHeight) {
                this.refresh();
            }

            if (scrollTop >= maxScroll) {
                const target = this._targets[this._targets.length - 1];

                if (this._activeTarget !== target) {
                    this._activate(target);
                }

                return;
            }

            if (
                this._activeTarget &&
                scrollTop < this._offsets[0] &&
                this._offsets[0] > 0
            ) {
                this._activeTarget = null;

                this._clear();

                return;
            }

            for (let i = this._offsets.length; i--; ) {
                const isActiveTarget =
                    this._activeTarget !== this._targets[i] &&
                    scrollTop >= this._offsets[i] &&
                    (typeof this._offsets[i + 1] === "undefined" ||
                        scrollTop < this._offsets[i + 1]);

                if (isActiveTarget) {
                    this._activate(this._targets[i]);
                }
            }
        }

        _activate(target) {
            this._activeTarget = target;

            this._clear();

            const queries = SELECTOR_LINK_ITEMS.split(",").map(
                (selector) =>
                    `${selector}[data-bs-target="${target}"],${selector}[href="${target}"]`
            );
            const link = SelectorEngine.findOne(
                queries.join(","),
                this._config.target
            );
            link.classList.add(CLASS_NAME_ACTIVE$1);

            if (link.classList.contains(CLASS_NAME_DROPDOWN_ITEM)) {
                SelectorEngine.findOne(
                    SELECTOR_DROPDOWN_TOGGLE$1,
                    link.closest(SELECTOR_DROPDOWN$1)
                ).classList.add(CLASS_NAME_ACTIVE$1);
            } else {
                SelectorEngine.parents(link, SELECTOR_NAV_LIST_GROUP$1).forEach(
                    (listGroup) => {
                        // Set triggered links parents as active
                        // With both <ul> and <nav> markup a parent is the previous sibling of any nav ancestor
                        SelectorEngine.prev(
                            listGroup,
                            `${SELECTOR_NAV_LINKS}, ${SELECTOR_LIST_ITEMS}`
                        ).forEach((item) =>
                            item.classList.add(CLASS_NAME_ACTIVE$1)
                        ); // Handle special case when .nav-link is inside .nav-item

                        SelectorEngine.prev(
                            listGroup,
                            SELECTOR_NAV_ITEMS
                        ).forEach((navItem) => {
                            SelectorEngine.children(
                                navItem,
                                SELECTOR_NAV_LINKS
                            ).forEach((item) =>
                                item.classList.add(CLASS_NAME_ACTIVE$1)
                            );
                        });
                    }
                );
            }

            EventHandler.trigger(this._scrollElement, EVENT_ACTIVATE, {
                relatedTarget: target,
            });
        }

        _clear() {
            SelectorEngine.find(SELECTOR_LINK_ITEMS, this._config.target)
                .filter((node) => node.classList.contains(CLASS_NAME_ACTIVE$1))
                .forEach((node) => node.classList.remove(CLASS_NAME_ACTIVE$1));
        } // Static

        static jQueryInterface(config) {
            return this.each(function () {
                const data = ScrollSpy.getOrCreateInstance(this, config);

                if (typeof config !== "string") {
                    return;
                }

                if (typeof data[config] === "undefined") {
                    throw new TypeError(`No method named "${config}"`);
                }

                data[config]();
            });
        }
    }
    /**
     * ------------------------------------------------------------------------
     * Data Api implementation
     * ------------------------------------------------------------------------
     */

    EventHandler.on(window, EVENT_LOAD_DATA_API, () => {
        SelectorEngine.find(SELECTOR_DATA_SPY).forEach(
            (spy) => new ScrollSpy(spy)
        );
    });
    /**
     * ------------------------------------------------------------------------
     * jQuery
     * ------------------------------------------------------------------------
     * add .ScrollSpy to jQuery only if jQuery is present
     */

    defineJQueryPlugin(ScrollSpy);

    /**
     * --------------------------------------------------------------------------
     * Bootstrap (v5.1.3): tab.js
     * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
     * --------------------------------------------------------------------------
     */
    /**
     * ------------------------------------------------------------------------
     * Constants
     * ------------------------------------------------------------------------
     */

    const NAME$1 = "tab";
    const DATA_KEY$1 = "bs.tab";
    const EVENT_KEY$1 = `.${DATA_KEY$1}`;
    const DATA_API_KEY = ".data-api";
    const EVENT_HIDE$1 = `hide${EVENT_KEY$1}`;
    const EVENT_HIDDEN$1 = `hidden${EVENT_KEY$1}`;
    const EVENT_SHOW$1 = `show${EVENT_KEY$1}`;
    const EVENT_SHOWN$1 = `shown${EVENT_KEY$1}`;
    const EVENT_CLICK_DATA_API = `click${EVENT_KEY$1}${DATA_API_KEY}`;
    const CLASS_NAME_DROPDOWN_MENU = "dropdown-menu";
    const CLASS_NAME_ACTIVE = "active";
    const CLASS_NAME_FADE$1 = "fade";
    const CLASS_NAME_SHOW$1 = "show";
    const SELECTOR_DROPDOWN = ".dropdown";
    const SELECTOR_NAV_LIST_GROUP = ".nav, .list-group";
    const SELECTOR_ACTIVE = ".active";
    const SELECTOR_ACTIVE_UL = ":scope > li > .active";
    const SELECTOR_DATA_TOGGLE =
        '[data-bs-toggle="tab"], [data-bs-toggle="pill"], [data-bs-toggle="list"]';
    const SELECTOR_DROPDOWN_TOGGLE = ".dropdown-toggle";
    const SELECTOR_DROPDOWN_ACTIVE_CHILD = ":scope > .dropdown-menu .active";
    /**
     * ------------------------------------------------------------------------
     * Class Definition
     * ------------------------------------------------------------------------
     */

    class Tab extends BaseComponent {
        // Getters
        static get NAME() {
            return NAME$1;
        } // Public

        show() {
            if (
                this._element.parentNode &&
                this._element.parentNode.nodeType === Node.ELEMENT_NODE &&
                this._element.classList.contains(CLASS_NAME_ACTIVE)
            ) {
                return;
            }

            let previous;
            const target = getElementFromSelector(this._element);

            const listElement = this._element.closest(SELECTOR_NAV_LIST_GROUP);

            if (listElement) {
                const itemSelector =
                    listElement.nodeName === "UL" ||
                    listElement.nodeName === "OL"
                        ? SELECTOR_ACTIVE_UL
                        : SELECTOR_ACTIVE;
                previous = SelectorEngine.find(itemSelector, listElement);
                previous = previous[previous.length - 1];
            }

            const hideEvent = previous
                ? EventHandler.trigger(previous, EVENT_HIDE$1, {
                      relatedTarget: this._element,
                  })
                : null;
            const showEvent = EventHandler.trigger(
                this._element,
                EVENT_SHOW$1,
                {
                    relatedTarget: previous,
                }
            );

            if (
                showEvent.defaultPrevented ||
                (hideEvent !== null && hideEvent.defaultPrevented)
            ) {
                return;
            }

            this._activate(this._element, listElement);

            const complete = () => {
                EventHandler.trigger(previous, EVENT_HIDDEN$1, {
                    relatedTarget: this._element,
                });
                EventHandler.trigger(this._element, EVENT_SHOWN$1, {
                    relatedTarget: previous,
                });
            };

            if (target) {
                this._activate(target, target.parentNode, complete);
            } else {
                complete();
            }
        } // Private

        _activate(element, container, callback) {
            const activeElements =
                container &&
                (container.nodeName === "UL" || container.nodeName === "OL")
                    ? SelectorEngine.find(SELECTOR_ACTIVE_UL, container)
                    : SelectorEngine.children(container, SELECTOR_ACTIVE);
            const active = activeElements[0];
            const isTransitioning =
                callback &&
                active &&
                active.classList.contains(CLASS_NAME_FADE$1);

            const complete = () =>
                this._transitionComplete(element, active, callback);

            if (active && isTransitioning) {
                active.classList.remove(CLASS_NAME_SHOW$1);

                this._queueCallback(complete, element, true);
            } else {
                complete();
            }
        }

        _transitionComplete(element, active, callback) {
            if (active) {
                active.classList.remove(CLASS_NAME_ACTIVE);
                const dropdownChild = SelectorEngine.findOne(
                    SELECTOR_DROPDOWN_ACTIVE_CHILD,
                    active.parentNode
                );

                if (dropdownChild) {
                    dropdownChild.classList.remove(CLASS_NAME_ACTIVE);
                }

                if (active.getAttribute("role") === "tab") {
                    active.setAttribute("aria-selected", false);
                }
            }

            element.classList.add(CLASS_NAME_ACTIVE);

            if (element.getAttribute("role") === "tab") {
                element.setAttribute("aria-selected", true);
            }

            reflow(element);

            if (element.classList.contains(CLASS_NAME_FADE$1)) {
                element.classList.add(CLASS_NAME_SHOW$1);
            }

            let parent = element.parentNode;

            if (parent && parent.nodeName === "LI") {
                parent = parent.parentNode;
            }

            if (parent && parent.classList.contains(CLASS_NAME_DROPDOWN_MENU)) {
                const dropdownElement = element.closest(SELECTOR_DROPDOWN);

                if (dropdownElement) {
                    SelectorEngine.find(
                        SELECTOR_DROPDOWN_TOGGLE,
                        dropdownElement
                    ).forEach((dropdown) =>
                        dropdown.classList.add(CLASS_NAME_ACTIVE)
                    );
                }

                element.setAttribute("aria-expanded", true);
            }

            if (callback) {
                callback();
            }
        } // Static

        static jQueryInterface(config) {
            return this.each(function () {
                const data = Tab.getOrCreateInstance(this);

                if (typeof config === "string") {
                    if (typeof data[config] === "undefined") {
                        throw new TypeError(`No method named "${config}"`);
                    }

                    data[config]();
                }
            });
        }
    }
    /**
     * ------------------------------------------------------------------------
     * Data Api implementation
     * ------------------------------------------------------------------------
     */

    EventHandler.on(
        document,
        EVENT_CLICK_DATA_API,
        SELECTOR_DATA_TOGGLE,
        function (event) {
            if (["A", "AREA"].includes(this.tagName)) {
                event.preventDefault();
            }

            if (isDisabled(this)) {
                return;
            }

            const data = Tab.getOrCreateInstance(this);
            data.show();
        }
    );
    /**
     * ------------------------------------------------------------------------
     * jQuery
     * ------------------------------------------------------------------------
     * add .Tab to jQuery only if jQuery is present
     */

    defineJQueryPlugin(Tab);

    /**
     * --------------------------------------------------------------------------
     * Bootstrap (v5.1.3): toast.js
     * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
     * --------------------------------------------------------------------------
     */
    /**
     * ------------------------------------------------------------------------
     * Constants
     * ------------------------------------------------------------------------
     */

    const NAME = "toast";
    const DATA_KEY = "bs.toast";
    const EVENT_KEY = `.${DATA_KEY}`;
    const EVENT_MOUSEOVER = `mouseover${EVENT_KEY}`;
    const EVENT_MOUSEOUT = `mouseout${EVENT_KEY}`;
    const EVENT_FOCUSIN = `focusin${EVENT_KEY}`;
    const EVENT_FOCUSOUT = `focusout${EVENT_KEY}`;
    const EVENT_HIDE = `hide${EVENT_KEY}`;
    const EVENT_HIDDEN = `hidden${EVENT_KEY}`;
    const EVENT_SHOW = `show${EVENT_KEY}`;
    const EVENT_SHOWN = `shown${EVENT_KEY}`;
    const CLASS_NAME_FADE = "fade";
    const CLASS_NAME_HIDE = "hide"; // @deprecated - kept here only for backwards compatibility

    const CLASS_NAME_SHOW = "show";
    const CLASS_NAME_SHOWING = "showing";
    const DefaultType = {
        animation: "boolean",
        autohide: "boolean",
        delay: "number",
    };
    const Default = {
        animation: true,
        autohide: true,
        delay: 5000,
    };
    /**
     * ------------------------------------------------------------------------
     * Class Definition
     * ------------------------------------------------------------------------
     */

    class Toast extends BaseComponent {
        constructor(element, config) {
            super(element);
            this._config = this._getConfig(config);
            this._timeout = null;
            this._hasMouseInteraction = false;
            this._hasKeyboardInteraction = false;

            this._setListeners();
        } // Getters

        static get DefaultType() {
            return DefaultType;
        }

        static get Default() {
            return Default;
        }

        static get NAME() {
            return NAME;
        } // Public

        show() {
            const showEvent = EventHandler.trigger(this._element, EVENT_SHOW);

            if (showEvent.defaultPrevented) {
                return;
            }

            this._clearTimeout();

            if (this._config.animation) {
                this._element.classList.add(CLASS_NAME_FADE);
            }

            const complete = () => {
                this._element.classList.remove(CLASS_NAME_SHOWING);

                EventHandler.trigger(this._element, EVENT_SHOWN);

                this._maybeScheduleHide();
            };

            this._element.classList.remove(CLASS_NAME_HIDE); // @deprecated

            reflow(this._element);

            this._element.classList.add(CLASS_NAME_SHOW);

            this._element.classList.add(CLASS_NAME_SHOWING);

            this._queueCallback(
                complete,
                this._element,
                this._config.animation
            );
        }

        hide() {
            if (!this._element.classList.contains(CLASS_NAME_SHOW)) {
                return;
            }

            const hideEvent = EventHandler.trigger(this._element, EVENT_HIDE);

            if (hideEvent.defaultPrevented) {
                return;
            }

            const complete = () => {
                this._element.classList.add(CLASS_NAME_HIDE); // @deprecated

                this._element.classList.remove(CLASS_NAME_SHOWING);

                this._element.classList.remove(CLASS_NAME_SHOW);

                EventHandler.trigger(this._element, EVENT_HIDDEN);
            };

            this._element.classList.add(CLASS_NAME_SHOWING);

            this._queueCallback(
                complete,
                this._element,
                this._config.animation
            );
        }

        dispose() {
            this._clearTimeout();

            if (this._element.classList.contains(CLASS_NAME_SHOW)) {
                this._element.classList.remove(CLASS_NAME_SHOW);
            }

            super.dispose();
        } // Private

        _getConfig(config) {
            config = {
                ...Default,
                ...Manipulator.getDataAttributes(this._element),
                ...(typeof config === "object" && config ? config : {}),
            };
            typeCheckConfig(NAME, config, this.constructor.DefaultType);
            return config;
        }

        _maybeScheduleHide() {
            if (!this._config.autohide) {
                return;
            }

            if (this._hasMouseInteraction || this._hasKeyboardInteraction) {
                return;
            }

            this._timeout = setTimeout(() => {
                this.hide();
            }, this._config.delay);
        }

        _onInteraction(event, isInteracting) {
            switch (event.type) {
                case "mouseover":
                case "mouseout":
                    this._hasMouseInteraction = isInteracting;
                    break;

                case "focusin":
                case "focusout":
                    this._hasKeyboardInteraction = isInteracting;
                    break;
            }

            if (isInteracting) {
                this._clearTimeout();

                return;
            }

            const nextElement = event.relatedTarget;

            if (
                this._element === nextElement ||
                this._element.contains(nextElement)
            ) {
                return;
            }

            this._maybeScheduleHide();
        }

        _setListeners() {
            EventHandler.on(this._element, EVENT_MOUSEOVER, (event) =>
                this._onInteraction(event, true)
            );
            EventHandler.on(this._element, EVENT_MOUSEOUT, (event) =>
                this._onInteraction(event, false)
            );
            EventHandler.on(this._element, EVENT_FOCUSIN, (event) =>
                this._onInteraction(event, true)
            );
            EventHandler.on(this._element, EVENT_FOCUSOUT, (event) =>
                this._onInteraction(event, false)
            );
        }

        _clearTimeout() {
            clearTimeout(this._timeout);
            this._timeout = null;
        } // Static

        static jQueryInterface(config) {
            return this.each(function () {
                const data = Toast.getOrCreateInstance(this, config);

                if (typeof config === "string") {
                    if (typeof data[config] === "undefined") {
                        throw new TypeError(`No method named "${config}"`);
                    }

                    data[config](this);
                }
            });
        }
    }

    enableDismissTrigger(Toast);
    /**
     * ------------------------------------------------------------------------
     * jQuery
     * ------------------------------------------------------------------------
     * add .Toast to jQuery only if jQuery is present
     */

    defineJQueryPlugin(Toast);

    /**
     * --------------------------------------------------------------------------
     * Bootstrap (v5.1.3): index.umd.js
     * Licensed under MIT (https://github.com/twbs/bootstrap/blob/main/LICENSE)
     * --------------------------------------------------------------------------
     */
    const index_umd = {
        Alert,
        Button,
        Carousel,
        Collapse,
        Dropdown,
        Modal,
        Offcanvas,
        Popover,
        ScrollSpy,
        Tab,
        Toast,
        Tooltip,
    };

    return index_umd;
});
//# sourceMappingURL=bootstrap.bundle.js.map

//! moment.js
//! version : 2.29.1
//! authors : Tim Wood, Iskren Chernev, Moment.js contributors
//! license : MIT
//! momentjs.com

(function (global, factory) {
    typeof exports === "object" && typeof module !== "undefined"
        ? (module.exports = factory())
        : typeof define === "function" && define.amd
        ? define(factory)
        : (global.moment = factory());
})(this, function () {
    "use strict";

    var hookCallback;

    function hooks() {
        return hookCallback.apply(null, arguments);
    }

    // This is done to register the method called with moment()
    // without creating circular dependencies.
    function setHookCallback(callback) {
        hookCallback = callback;
    }

    function isArray(input) {
        return (
            input instanceof Array ||
            Object.prototype.toString.call(input) === "[object Array]"
        );
    }

    function isObject(input) {
        // IE8 will treat undefined and null as object if it wasn't for
        // input != null
        return (
            input != null &&
            Object.prototype.toString.call(input) === "[object Object]"
        );
    }

    function hasOwnProp(a, b) {
        return Object.prototype.hasOwnProperty.call(a, b);
    }

    function isObjectEmpty(obj) {
        if (Object.getOwnPropertyNames) {
            return Object.getOwnPropertyNames(obj).length === 0;
        } else {
            var k;
            for (k in obj) {
                if (hasOwnProp(obj, k)) {
                    return false;
                }
            }
            return true;
        }
    }

    function isUndefined(input) {
        return input === void 0;
    }

    function isNumber(input) {
        return (
            typeof input === "number" ||
            Object.prototype.toString.call(input) === "[object Number]"
        );
    }

    function isDate(input) {
        return (
            input instanceof Date ||
            Object.prototype.toString.call(input) === "[object Date]"
        );
    }

    function map(arr, fn) {
        var res = [],
            i;
        for (i = 0; i < arr.length; ++i) {
            res.push(fn(arr[i], i));
        }
        return res;
    }

    function extend(a, b) {
        for (var i in b) {
            if (hasOwnProp(b, i)) {
                a[i] = b[i];
            }
        }

        if (hasOwnProp(b, "toString")) {
            a.toString = b.toString;
        }

        if (hasOwnProp(b, "valueOf")) {
            a.valueOf = b.valueOf;
        }

        return a;
    }

    function createUTC(input, format, locale, strict) {
        return createLocalOrUTC(input, format, locale, strict, true).utc();
    }

    function defaultParsingFlags() {
        // We need to deep clone this object.
        return {
            empty: false,
            unusedTokens: [],
            unusedInput: [],
            overflow: -2,
            charsLeftOver: 0,
            nullInput: false,
            invalidEra: null,
            invalidMonth: null,
            invalidFormat: false,
            userInvalidated: false,
            iso: false,
            parsedDateParts: [],
            era: null,
            meridiem: null,
            rfc2822: false,
            weekdayMismatch: false,
        };
    }

    function getParsingFlags(m) {
        if (m._pf == null) {
            m._pf = defaultParsingFlags();
        }
        return m._pf;
    }

    var some;
    if (Array.prototype.some) {
        some = Array.prototype.some;
    } else {
        some = function (fun) {
            var t = Object(this),
                len = t.length >>> 0,
                i;

            for (i = 0; i < len; i++) {
                if (i in t && fun.call(this, t[i], i, t)) {
                    return true;
                }
            }

            return false;
        };
    }

    function isValid(m) {
        if (m._isValid == null) {
            var flags = getParsingFlags(m),
                parsedParts = some.call(flags.parsedDateParts, function (i) {
                    return i != null;
                }),
                isNowValid =
                    !isNaN(m._d.getTime()) &&
                    flags.overflow < 0 &&
                    !flags.empty &&
                    !flags.invalidEra &&
                    !flags.invalidMonth &&
                    !flags.invalidWeekday &&
                    !flags.weekdayMismatch &&
                    !flags.nullInput &&
                    !flags.invalidFormat &&
                    !flags.userInvalidated &&
                    (!flags.meridiem || (flags.meridiem && parsedParts));

            if (m._strict) {
                isNowValid =
                    isNowValid &&
                    flags.charsLeftOver === 0 &&
                    flags.unusedTokens.length === 0 &&
                    flags.bigHour === undefined;
            }

            if (Object.isFrozen == null || !Object.isFrozen(m)) {
                m._isValid = isNowValid;
            } else {
                return isNowValid;
            }
        }
        return m._isValid;
    }

    function createInvalid(flags) {
        var m = createUTC(NaN);
        if (flags != null) {
            extend(getParsingFlags(m), flags);
        } else {
            getParsingFlags(m).userInvalidated = true;
        }

        return m;
    }

    // Plugins that add properties should also add the key here (null value),
    // so we can properly clone ourselves.
    var momentProperties = (hooks.momentProperties = []),
        updateInProgress = false;

    function copyConfig(to, from) {
        var i, prop, val;

        if (!isUndefined(from._isAMomentObject)) {
            to._isAMomentObject = from._isAMomentObject;
        }
        if (!isUndefined(from._i)) {
            to._i = from._i;
        }
        if (!isUndefined(from._f)) {
            to._f = from._f;
        }
        if (!isUndefined(from._l)) {
            to._l = from._l;
        }
        if (!isUndefined(from._strict)) {
            to._strict = from._strict;
        }
        if (!isUndefined(from._tzm)) {
            to._tzm = from._tzm;
        }
        if (!isUndefined(from._isUTC)) {
            to._isUTC = from._isUTC;
        }
        if (!isUndefined(from._offset)) {
            to._offset = from._offset;
        }
        if (!isUndefined(from._pf)) {
            to._pf = getParsingFlags(from);
        }
        if (!isUndefined(from._locale)) {
            to._locale = from._locale;
        }

        if (momentProperties.length > 0) {
            for (i = 0; i < momentProperties.length; i++) {
                prop = momentProperties[i];
                val = from[prop];
                if (!isUndefined(val)) {
                    to[prop] = val;
                }
            }
        }

        return to;
    }

    // Moment prototype object
    function Moment(config) {
        copyConfig(this, config);
        this._d = new Date(config._d != null ? config._d.getTime() : NaN);
        if (!this.isValid()) {
            this._d = new Date(NaN);
        }
        // Prevent infinite loop in case updateOffset creates new moment
        // objects.
        if (updateInProgress === false) {
            updateInProgress = true;
            hooks.updateOffset(this);
            updateInProgress = false;
        }
    }

    function isMoment(obj) {
        return (
            obj instanceof Moment ||
            (obj != null && obj._isAMomentObject != null)
        );
    }

    function warn(msg) {
        if (
            hooks.suppressDeprecationWarnings === false &&
            typeof console !== "undefined" &&
            console.warn
        ) {
            console.warn("Deprecation warning: " + msg);
        }
    }

    function deprecate(msg, fn) {
        var firstTime = true;

        return extend(function () {
            if (hooks.deprecationHandler != null) {
                hooks.deprecationHandler(null, msg);
            }
            if (firstTime) {
                var args = [],
                    arg,
                    i,
                    key;
                for (i = 0; i < arguments.length; i++) {
                    arg = "";
                    if (typeof arguments[i] === "object") {
                        arg += "\n[" + i + "] ";
                        for (key in arguments[0]) {
                            if (hasOwnProp(arguments[0], key)) {
                                arg += key + ": " + arguments[0][key] + ", ";
                            }
                        }
                        arg = arg.slice(0, -2); // Remove trailing comma and space
                    } else {
                        arg = arguments[i];
                    }
                    args.push(arg);
                }
                warn(
                    msg +
                        "\nArguments: " +
                        Array.prototype.slice.call(args).join("") +
                        "\n" +
                        new Error().stack
                );
                firstTime = false;
            }
            return fn.apply(this, arguments);
        }, fn);
    }

    var deprecations = {};

    function deprecateSimple(name, msg) {
        if (hooks.deprecationHandler != null) {
            hooks.deprecationHandler(name, msg);
        }
        if (!deprecations[name]) {
            warn(msg);
            deprecations[name] = true;
        }
    }

    hooks.suppressDeprecationWarnings = false;
    hooks.deprecationHandler = null;

    function isFunction(input) {
        return (
            (typeof Function !== "undefined" && input instanceof Function) ||
            Object.prototype.toString.call(input) === "[object Function]"
        );
    }

    function set(config) {
        var prop, i;
        for (i in config) {
            if (hasOwnProp(config, i)) {
                prop = config[i];
                if (isFunction(prop)) {
                    this[i] = prop;
                } else {
                    this["_" + i] = prop;
                }
            }
        }
        this._config = config;
        // Lenient ordinal parsing accepts just a number in addition to
        // number + (possibly) stuff coming from _dayOfMonthOrdinalParse.
        // TODO: Remove "ordinalParse" fallback in next major release.
        this._dayOfMonthOrdinalParseLenient = new RegExp(
            (this._dayOfMonthOrdinalParse.source || this._ordinalParse.source) +
                "|" +
                /\d{1,2}/.source
        );
    }

    function mergeConfigs(parentConfig, childConfig) {
        var res = extend({}, parentConfig),
            prop;
        for (prop in childConfig) {
            if (hasOwnProp(childConfig, prop)) {
                if (
                    isObject(parentConfig[prop]) &&
                    isObject(childConfig[prop])
                ) {
                    res[prop] = {};
                    extend(res[prop], parentConfig[prop]);
                    extend(res[prop], childConfig[prop]);
                } else if (childConfig[prop] != null) {
                    res[prop] = childConfig[prop];
                } else {
                    delete res[prop];
                }
            }
        }
        for (prop in parentConfig) {
            if (
                hasOwnProp(parentConfig, prop) &&
                !hasOwnProp(childConfig, prop) &&
                isObject(parentConfig[prop])
            ) {
                // make sure changes to properties don't modify parent config
                res[prop] = extend({}, res[prop]);
            }
        }
        return res;
    }

    function Locale(config) {
        if (config != null) {
            this.set(config);
        }
    }

    var keys;

    if (Object.keys) {
        keys = Object.keys;
    } else {
        keys = function (obj) {
            var i,
                res = [];
            for (i in obj) {
                if (hasOwnProp(obj, i)) {
                    res.push(i);
                }
            }
            return res;
        };
    }

    var defaultCalendar = {
        sameDay: "[Today at] LT",
        nextDay: "[Tomorrow at] LT",
        nextWeek: "dddd [at] LT",
        lastDay: "[Yesterday at] LT",
        lastWeek: "[Last] dddd [at] LT",
        sameElse: "L",
    };

    function calendar(key, mom, now) {
        var output = this._calendar[key] || this._calendar["sameElse"];
        return isFunction(output) ? output.call(mom, now) : output;
    }

    function zeroFill(number, targetLength, forceSign) {
        var absNumber = "" + Math.abs(number),
            zerosToFill = targetLength - absNumber.length,
            sign = number >= 0;
        return (
            (sign ? (forceSign ? "+" : "") : "-") +
            Math.pow(10, Math.max(0, zerosToFill)).toString().substr(1) +
            absNumber
        );
    }

    var formattingTokens =
            /(\[[^\[]*\])|(\\)?([Hh]mm(ss)?|Mo|MM?M?M?|Do|DDDo|DD?D?D?|ddd?d?|do?|w[o|w]?|W[o|W]?|Qo?|N{1,5}|YYYYYY|YYYYY|YYYY|YY|y{2,4}|yo?|gg(ggg?)?|GG(GGG?)?|e|E|a|A|hh?|HH?|kk?|mm?|ss?|S{1,9}|x|X|zz?|ZZ?|.)/g,
        localFormattingTokens = /(\[[^\[]*\])|(\\)?(LTS|LT|LL?L?L?|l{1,4})/g,
        formatFunctions = {},
        formatTokenFunctions = {};

    // token:    'M'
    // padded:   ['MM', 2]
    // ordinal:  'Mo'
    // callback: function () { this.month() + 1 }
    function addFormatToken(token, padded, ordinal, callback) {
        var func = callback;
        if (typeof callback === "string") {
            func = function () {
                return this[callback]();
            };
        }
        if (token) {
            formatTokenFunctions[token] = func;
        }
        if (padded) {
            formatTokenFunctions[padded[0]] = function () {
                return zeroFill(
                    func.apply(this, arguments),
                    padded[1],
                    padded[2]
                );
            };
        }
        if (ordinal) {
            formatTokenFunctions[ordinal] = function () {
                return this.localeData().ordinal(
                    func.apply(this, arguments),
                    token
                );
            };
        }
    }

    function removeFormattingTokens(input) {
        if (input.match(/\[[\s\S]/)) {
            return input.replace(/^\[|\]$/g, "");
        }
        return input.replace(/\\/g, "");
    }

    function makeFormatFunction(format) {
        var array = format.match(formattingTokens),
            i,
            length;

        for (i = 0, length = array.length; i < length; i++) {
            if (formatTokenFunctions[array[i]]) {
                array[i] = formatTokenFunctions[array[i]];
            } else {
                array[i] = removeFormattingTokens(array[i]);
            }
        }

        return function (mom) {
            var output = "",
                i;
            for (i = 0; i < length; i++) {
                output += isFunction(array[i])
                    ? array[i].call(mom, format)
                    : array[i];
            }
            return output;
        };
    }

    // format date using native date object
    function formatMoment(m, format) {
        if (!m.isValid()) {
            return m.localeData().invalidDate();
        }

        format = expandFormat(format, m.localeData());
        formatFunctions[format] =
            formatFunctions[format] || makeFormatFunction(format);

        return formatFunctions[format](m);
    }

    function expandFormat(format, locale) {
        var i = 5;

        function replaceLongDateFormatTokens(input) {
            return locale.longDateFormat(input) || input;
        }

        localFormattingTokens.lastIndex = 0;
        while (i >= 0 && localFormattingTokens.test(format)) {
            format = format.replace(
                localFormattingTokens,
                replaceLongDateFormatTokens
            );
            localFormattingTokens.lastIndex = 0;
            i -= 1;
        }

        return format;
    }

    var defaultLongDateFormat = {
        LTS: "h:mm:ss A",
        LT: "h:mm A",
        L: "MM/DD/YYYY",
        LL: "MMMM D, YYYY",
        LLL: "MMMM D, YYYY h:mm A",
        LLLL: "dddd, MMMM D, YYYY h:mm A",
    };

    function longDateFormat(key) {
        var format = this._longDateFormat[key],
            formatUpper = this._longDateFormat[key.toUpperCase()];

        if (format || !formatUpper) {
            return format;
        }

        this._longDateFormat[key] = formatUpper
            .match(formattingTokens)
            .map(function (tok) {
                if (
                    tok === "MMMM" ||
                    tok === "MM" ||
                    tok === "DD" ||
                    tok === "dddd"
                ) {
                    return tok.slice(1);
                }
                return tok;
            })
            .join("");

        return this._longDateFormat[key];
    }

    var defaultInvalidDate = "Invalid date";

    function invalidDate() {
        return this._invalidDate;
    }

    var defaultOrdinal = "%d",
        defaultDayOfMonthOrdinalParse = /\d{1,2}/;

    function ordinal(number) {
        return this._ordinal.replace("%d", number);
    }

    var defaultRelativeTime = {
        future: "in %s",
        past: "%s ago",
        s: "a few seconds",
        ss: "%d seconds",
        m: "a minute",
        mm: "%d minutes",
        h: "an hour",
        hh: "%d hours",
        d: "a day",
        dd: "%d days",
        w: "a week",
        ww: "%d weeks",
        M: "a month",
        MM: "%d months",
        y: "a year",
        yy: "%d years",
    };

    function relativeTime(number, withoutSuffix, string, isFuture) {
        var output = this._relativeTime[string];
        return isFunction(output)
            ? output(number, withoutSuffix, string, isFuture)
            : output.replace(/%d/i, number);
    }

    function pastFuture(diff, output) {
        var format = this._relativeTime[diff > 0 ? "future" : "past"];
        return isFunction(format)
            ? format(output)
            : format.replace(/%s/i, output);
    }

    var aliases = {};

    function addUnitAlias(unit, shorthand) {
        var lowerCase = unit.toLowerCase();
        aliases[lowerCase] =
            aliases[lowerCase + "s"] =
            aliases[shorthand] =
                unit;
    }

    function normalizeUnits(units) {
        return typeof units === "string"
            ? aliases[units] || aliases[units.toLowerCase()]
            : undefined;
    }

    function normalizeObjectUnits(inputObject) {
        var normalizedInput = {},
            normalizedProp,
            prop;

        for (prop in inputObject) {
            if (hasOwnProp(inputObject, prop)) {
                normalizedProp = normalizeUnits(prop);
                if (normalizedProp) {
                    normalizedInput[normalizedProp] = inputObject[prop];
                }
            }
        }

        return normalizedInput;
    }

    var priorities = {};

    function addUnitPriority(unit, priority) {
        priorities[unit] = priority;
    }

    function getPrioritizedUnits(unitsObj) {
        var units = [],
            u;
        for (u in unitsObj) {
            if (hasOwnProp(unitsObj, u)) {
                units.push({ unit: u, priority: priorities[u] });
            }
        }
        units.sort(function (a, b) {
            return a.priority - b.priority;
        });
        return units;
    }

    function isLeapYear(year) {
        return (year % 4 === 0 && year % 100 !== 0) || year % 400 === 0;
    }

    function absFloor(number) {
        if (number < 0) {
            // -0 -> 0
            return Math.ceil(number) || 0;
        } else {
            return Math.floor(number);
        }
    }

    function toInt(argumentForCoercion) {
        var coercedNumber = +argumentForCoercion,
            value = 0;

        if (coercedNumber !== 0 && isFinite(coercedNumber)) {
            value = absFloor(coercedNumber);
        }

        return value;
    }

    function makeGetSet(unit, keepTime) {
        return function (value) {
            if (value != null) {
                set$1(this, unit, value);
                hooks.updateOffset(this, keepTime);
                return this;
            } else {
                return get(this, unit);
            }
        };
    }

    function get(mom, unit) {
        return mom.isValid()
            ? mom._d["get" + (mom._isUTC ? "UTC" : "") + unit]()
            : NaN;
    }

    function set$1(mom, unit, value) {
        if (mom.isValid() && !isNaN(value)) {
            if (
                unit === "FullYear" &&
                isLeapYear(mom.year()) &&
                mom.month() === 1 &&
                mom.date() === 29
            ) {
                value = toInt(value);
                mom._d["set" + (mom._isUTC ? "UTC" : "") + unit](
                    value,
                    mom.month(),
                    daysInMonth(value, mom.month())
                );
            } else {
                mom._d["set" + (mom._isUTC ? "UTC" : "") + unit](value);
            }
        }
    }

    // MOMENTS

    function stringGet(units) {
        units = normalizeUnits(units);
        if (isFunction(this[units])) {
            return this[units]();
        }
        return this;
    }

    function stringSet(units, value) {
        if (typeof units === "object") {
            units = normalizeObjectUnits(units);
            var prioritized = getPrioritizedUnits(units),
                i;
            for (i = 0; i < prioritized.length; i++) {
                this[prioritized[i].unit](units[prioritized[i].unit]);
            }
        } else {
            units = normalizeUnits(units);
            if (isFunction(this[units])) {
                return this[units](value);
            }
        }
        return this;
    }

    var match1 = /\d/, //       0 - 9
        match2 = /\d\d/, //      00 - 99
        match3 = /\d{3}/, //     000 - 999
        match4 = /\d{4}/, //    0000 - 9999
        match6 = /[+-]?\d{6}/, // -999999 - 999999
        match1to2 = /\d\d?/, //       0 - 99
        match3to4 = /\d\d\d\d?/, //     999 - 9999
        match5to6 = /\d\d\d\d\d\d?/, //   99999 - 999999
        match1to3 = /\d{1,3}/, //       0 - 999
        match1to4 = /\d{1,4}/, //       0 - 9999
        match1to6 = /[+-]?\d{1,6}/, // -999999 - 999999
        matchUnsigned = /\d+/, //       0 - inf
        matchSigned = /[+-]?\d+/, //    -inf - inf
        matchOffset = /Z|[+-]\d\d:?\d\d/gi, // +00:00 -00:00 +0000 -0000 or Z
        matchShortOffset = /Z|[+-]\d\d(?::?\d\d)?/gi, // +00 -00 +00:00 -00:00 +0000 -0000 or Z
        matchTimestamp = /[+-]?\d+(\.\d{1,3})?/, // 123456789 123456789.123
        // any word (or two) characters or numbers including two/three word month in arabic.
        // includes scottish gaelic two word and hyphenated months
        matchWord =
            /[0-9]{0,256}['a-z\u00A0-\u05FF\u0700-\uD7FF\uF900-\uFDCF\uFDF0-\uFF07\uFF10-\uFFEF]{1,256}|[\u0600-\u06FF\/]{1,256}(\s*?[\u0600-\u06FF]{1,256}){1,2}/i,
        regexes;

    regexes = {};

    function addRegexToken(token, regex, strictRegex) {
        regexes[token] = isFunction(regex)
            ? regex
            : function (isStrict, localeData) {
                  return isStrict && strictRegex ? strictRegex : regex;
              };
    }

    function getParseRegexForToken(token, config) {
        if (!hasOwnProp(regexes, token)) {
            return new RegExp(unescapeFormat(token));
        }

        return regexes[token](config._strict, config._locale);
    }

    // Code from http://stackoverflow.com/questions/3561493/is-there-a-regexp-escape-function-in-javascript
    function unescapeFormat(s) {
        return regexEscape(
            s
                .replace("\\", "")
                .replace(
                    /\\(\[)|\\(\])|\[([^\]\[]*)\]|\\(.)/g,
                    function (matched, p1, p2, p3, p4) {
                        return p1 || p2 || p3 || p4;
                    }
                )
        );
    }

    function regexEscape(s) {
        return s.replace(/[-\/\\^$*+?.()|[\]{}]/g, "\\$&");
    }

    var tokens = {};

    function addParseToken(token, callback) {
        var i,
            func = callback;
        if (typeof token === "string") {
            token = [token];
        }
        if (isNumber(callback)) {
            func = function (input, array) {
                array[callback] = toInt(input);
            };
        }
        for (i = 0; i < token.length; i++) {
            tokens[token[i]] = func;
        }
    }

    function addWeekParseToken(token, callback) {
        addParseToken(token, function (input, array, config, token) {
            config._w = config._w || {};
            callback(input, config._w, config, token);
        });
    }

    function addTimeToArrayFromToken(token, input, config) {
        if (input != null && hasOwnProp(tokens, token)) {
            tokens[token](input, config._a, config, token);
        }
    }

    var YEAR = 0,
        MONTH = 1,
        DATE = 2,
        HOUR = 3,
        MINUTE = 4,
        SECOND = 5,
        MILLISECOND = 6,
        WEEK = 7,
        WEEKDAY = 8;

    function mod(n, x) {
        return ((n % x) + x) % x;
    }

    var indexOf;

    if (Array.prototype.indexOf) {
        indexOf = Array.prototype.indexOf;
    } else {
        indexOf = function (o) {
            // I know
            var i;
            for (i = 0; i < this.length; ++i) {
                if (this[i] === o) {
                    return i;
                }
            }
            return -1;
        };
    }

    function daysInMonth(year, month) {
        if (isNaN(year) || isNaN(month)) {
            return NaN;
        }
        var modMonth = mod(month, 12);
        year += (month - modMonth) / 12;
        return modMonth === 1
            ? isLeapYear(year)
                ? 29
                : 28
            : 31 - ((modMonth % 7) % 2);
    }

    // FORMATTING

    addFormatToken("M", ["MM", 2], "Mo", function () {
        return this.month() + 1;
    });

    addFormatToken("MMM", 0, 0, function (format) {
        return this.localeData().monthsShort(this, format);
    });

    addFormatToken("MMMM", 0, 0, function (format) {
        return this.localeData().months(this, format);
    });

    // ALIASES

    addUnitAlias("month", "M");

    // PRIORITY

    addUnitPriority("month", 8);

    // PARSING

    addRegexToken("M", match1to2);
    addRegexToken("MM", match1to2, match2);
    addRegexToken("MMM", function (isStrict, locale) {
        return locale.monthsShortRegex(isStrict);
    });
    addRegexToken("MMMM", function (isStrict, locale) {
        return locale.monthsRegex(isStrict);
    });

    addParseToken(["M", "MM"], function (input, array) {
        array[MONTH] = toInt(input) - 1;
    });

    addParseToken(["MMM", "MMMM"], function (input, array, config, token) {
        var month = config._locale.monthsParse(input, token, config._strict);
        // if we didn't find a month name, mark the date as invalid.
        if (month != null) {
            array[MONTH] = month;
        } else {
            getParsingFlags(config).invalidMonth = input;
        }
    });

    // LOCALES

    var defaultLocaleMonths =
            "January_February_March_April_May_June_July_August_September_October_November_December".split(
                "_"
            ),
        defaultLocaleMonthsShort =
            "Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_"),
        MONTHS_IN_FORMAT = /D[oD]?(\[[^\[\]]*\]|\s)+MMMM?/,
        defaultMonthsShortRegex = matchWord,
        defaultMonthsRegex = matchWord;

    function localeMonths(m, format) {
        if (!m) {
            return isArray(this._months)
                ? this._months
                : this._months["standalone"];
        }
        return isArray(this._months)
            ? this._months[m.month()]
            : this._months[
                  (this._months.isFormat || MONTHS_IN_FORMAT).test(format)
                      ? "format"
                      : "standalone"
              ][m.month()];
    }

    function localeMonthsShort(m, format) {
        if (!m) {
            return isArray(this._monthsShort)
                ? this._monthsShort
                : this._monthsShort["standalone"];
        }
        return isArray(this._monthsShort)
            ? this._monthsShort[m.month()]
            : this._monthsShort[
                  MONTHS_IN_FORMAT.test(format) ? "format" : "standalone"
              ][m.month()];
    }

    function handleStrictParse(monthName, format, strict) {
        var i,
            ii,
            mom,
            llc = monthName.toLocaleLowerCase();
        if (!this._monthsParse) {
            // this is not used
            this._monthsParse = [];
            this._longMonthsParse = [];
            this._shortMonthsParse = [];
            for (i = 0; i < 12; ++i) {
                mom = createUTC([2000, i]);
                this._shortMonthsParse[i] = this.monthsShort(
                    mom,
                    ""
                ).toLocaleLowerCase();
                this._longMonthsParse[i] = this.months(
                    mom,
                    ""
                ).toLocaleLowerCase();
            }
        }

        if (strict) {
            if (format === "MMM") {
                ii = indexOf.call(this._shortMonthsParse, llc);
                return ii !== -1 ? ii : null;
            } else {
                ii = indexOf.call(this._longMonthsParse, llc);
                return ii !== -1 ? ii : null;
            }
        } else {
            if (format === "MMM") {
                ii = indexOf.call(this._shortMonthsParse, llc);
                if (ii !== -1) {
                    return ii;
                }
                ii = indexOf.call(this._longMonthsParse, llc);
                return ii !== -1 ? ii : null;
            } else {
                ii = indexOf.call(this._longMonthsParse, llc);
                if (ii !== -1) {
                    return ii;
                }
                ii = indexOf.call(this._shortMonthsParse, llc);
                return ii !== -1 ? ii : null;
            }
        }
    }

    function localeMonthsParse(monthName, format, strict) {
        var i, mom, regex;

        if (this._monthsParseExact) {
            return handleStrictParse.call(this, monthName, format, strict);
        }

        if (!this._monthsParse) {
            this._monthsParse = [];
            this._longMonthsParse = [];
            this._shortMonthsParse = [];
        }

        // TODO: add sorting
        // Sorting makes sure if one month (or abbr) is a prefix of another
        // see sorting in computeMonthsParse
        for (i = 0; i < 12; i++) {
            // make the regex if we don't have it already
            mom = createUTC([2000, i]);
            if (strict && !this._longMonthsParse[i]) {
                this._longMonthsParse[i] = new RegExp(
                    "^" + this.months(mom, "").replace(".", "") + "$",
                    "i"
                );
                this._shortMonthsParse[i] = new RegExp(
                    "^" + this.monthsShort(mom, "").replace(".", "") + "$",
                    "i"
                );
            }
            if (!strict && !this._monthsParse[i]) {
                regex =
                    "^" +
                    this.months(mom, "") +
                    "|^" +
                    this.monthsShort(mom, "");
                this._monthsParse[i] = new RegExp(regex.replace(".", ""), "i");
            }
            // test the regex
            if (
                strict &&
                format === "MMMM" &&
                this._longMonthsParse[i].test(monthName)
            ) {
                return i;
            } else if (
                strict &&
                format === "MMM" &&
                this._shortMonthsParse[i].test(monthName)
            ) {
                return i;
            } else if (!strict && this._monthsParse[i].test(monthName)) {
                return i;
            }
        }
    }

    // MOMENTS

    function setMonth(mom, value) {
        var dayOfMonth;

        if (!mom.isValid()) {
            // No op
            return mom;
        }

        if (typeof value === "string") {
            if (/^\d+$/.test(value)) {
                value = toInt(value);
            } else {
                value = mom.localeData().monthsParse(value);
                // TODO: Another silent failure?
                if (!isNumber(value)) {
                    return mom;
                }
            }
        }

        dayOfMonth = Math.min(mom.date(), daysInMonth(mom.year(), value));
        mom._d["set" + (mom._isUTC ? "UTC" : "") + "Month"](value, dayOfMonth);
        return mom;
    }

    function getSetMonth(value) {
        if (value != null) {
            setMonth(this, value);
            hooks.updateOffset(this, true);
            return this;
        } else {
            return get(this, "Month");
        }
    }

    function getDaysInMonth() {
        return daysInMonth(this.year(), this.month());
    }

    function monthsShortRegex(isStrict) {
        if (this._monthsParseExact) {
            if (!hasOwnProp(this, "_monthsRegex")) {
                computeMonthsParse.call(this);
            }
            if (isStrict) {
                return this._monthsShortStrictRegex;
            } else {
                return this._monthsShortRegex;
            }
        } else {
            if (!hasOwnProp(this, "_monthsShortRegex")) {
                this._monthsShortRegex = defaultMonthsShortRegex;
            }
            return this._monthsShortStrictRegex && isStrict
                ? this._monthsShortStrictRegex
                : this._monthsShortRegex;
        }
    }

    function monthsRegex(isStrict) {
        if (this._monthsParseExact) {
            if (!hasOwnProp(this, "_monthsRegex")) {
                computeMonthsParse.call(this);
            }
            if (isStrict) {
                return this._monthsStrictRegex;
            } else {
                return this._monthsRegex;
            }
        } else {
            if (!hasOwnProp(this, "_monthsRegex")) {
                this._monthsRegex = defaultMonthsRegex;
            }
            return this._monthsStrictRegex && isStrict
                ? this._monthsStrictRegex
                : this._monthsRegex;
        }
    }

    function computeMonthsParse() {
        function cmpLenRev(a, b) {
            return b.length - a.length;
        }

        var shortPieces = [],
            longPieces = [],
            mixedPieces = [],
            i,
            mom;
        for (i = 0; i < 12; i++) {
            // make the regex if we don't have it already
            mom = createUTC([2000, i]);
            shortPieces.push(this.monthsShort(mom, ""));
            longPieces.push(this.months(mom, ""));
            mixedPieces.push(this.months(mom, ""));
            mixedPieces.push(this.monthsShort(mom, ""));
        }
        // Sorting makes sure if one month (or abbr) is a prefix of another it
        // will match the longer piece.
        shortPieces.sort(cmpLenRev);
        longPieces.sort(cmpLenRev);
        mixedPieces.sort(cmpLenRev);
        for (i = 0; i < 12; i++) {
            shortPieces[i] = regexEscape(shortPieces[i]);
            longPieces[i] = regexEscape(longPieces[i]);
        }
        for (i = 0; i < 24; i++) {
            mixedPieces[i] = regexEscape(mixedPieces[i]);
        }

        this._monthsRegex = new RegExp("^(" + mixedPieces.join("|") + ")", "i");
        this._monthsShortRegex = this._monthsRegex;
        this._monthsStrictRegex = new RegExp(
            "^(" + longPieces.join("|") + ")",
            "i"
        );
        this._monthsShortStrictRegex = new RegExp(
            "^(" + shortPieces.join("|") + ")",
            "i"
        );
    }

    // FORMATTING

    addFormatToken("Y", 0, 0, function () {
        var y = this.year();
        return y <= 9999 ? zeroFill(y, 4) : "+" + y;
    });

    addFormatToken(0, ["YY", 2], 0, function () {
        return this.year() % 100;
    });

    addFormatToken(0, ["YYYY", 4], 0, "year");
    addFormatToken(0, ["YYYYY", 5], 0, "year");
    addFormatToken(0, ["YYYYYY", 6, true], 0, "year");

    // ALIASES

    addUnitAlias("year", "y");

    // PRIORITIES

    addUnitPriority("year", 1);

    // PARSING

    addRegexToken("Y", matchSigned);
    addRegexToken("YY", match1to2, match2);
    addRegexToken("YYYY", match1to4, match4);
    addRegexToken("YYYYY", match1to6, match6);
    addRegexToken("YYYYYY", match1to6, match6);

    addParseToken(["YYYYY", "YYYYYY"], YEAR);
    addParseToken("YYYY", function (input, array) {
        array[YEAR] =
            input.length === 2 ? hooks.parseTwoDigitYear(input) : toInt(input);
    });
    addParseToken("YY", function (input, array) {
        array[YEAR] = hooks.parseTwoDigitYear(input);
    });
    addParseToken("Y", function (input, array) {
        array[YEAR] = parseInt(input, 10);
    });

    // HELPERS

    function daysInYear(year) {
        return isLeapYear(year) ? 366 : 365;
    }

    // HOOKS

    hooks.parseTwoDigitYear = function (input) {
        return toInt(input) + (toInt(input) > 68 ? 1900 : 2000);
    };

    // MOMENTS

    var getSetYear = makeGetSet("FullYear", true);

    function getIsLeapYear() {
        return isLeapYear(this.year());
    }

    function createDate(y, m, d, h, M, s, ms) {
        // can't just apply() to create a date:
        // https://stackoverflow.com/q/181348
        var date;
        // the date constructor remaps years 0-99 to 1900-1999
        if (y < 100 && y >= 0) {
            // preserve leap years using a full 400 year cycle, then reset
            date = new Date(y + 400, m, d, h, M, s, ms);
            if (isFinite(date.getFullYear())) {
                date.setFullYear(y);
            }
        } else {
            date = new Date(y, m, d, h, M, s, ms);
        }

        return date;
    }

    function createUTCDate(y) {
        var date, args;
        // the Date.UTC function remaps years 0-99 to 1900-1999
        if (y < 100 && y >= 0) {
            args = Array.prototype.slice.call(arguments);
            // preserve leap years using a full 400 year cycle, then reset
            args[0] = y + 400;
            date = new Date(Date.UTC.apply(null, args));
            if (isFinite(date.getUTCFullYear())) {
                date.setUTCFullYear(y);
            }
        } else {
            date = new Date(Date.UTC.apply(null, arguments));
        }

        return date;
    }

    // start-of-first-week - start-of-year
    function firstWeekOffset(year, dow, doy) {
        var // first-week day -- which january is always in the first week (4 for iso, 1 for other)
            fwd = 7 + dow - doy,
            // first-week day local weekday -- which local weekday is fwd
            fwdlw = (7 + createUTCDate(year, 0, fwd).getUTCDay() - dow) % 7;

        return -fwdlw + fwd - 1;
    }

    // https://en.wikipedia.org/wiki/ISO_week_date#Calculating_a_date_given_the_year.2C_week_number_and_weekday
    function dayOfYearFromWeeks(year, week, weekday, dow, doy) {
        var localWeekday = (7 + weekday - dow) % 7,
            weekOffset = firstWeekOffset(year, dow, doy),
            dayOfYear = 1 + 7 * (week - 1) + localWeekday + weekOffset,
            resYear,
            resDayOfYear;

        if (dayOfYear <= 0) {
            resYear = year - 1;
            resDayOfYear = daysInYear(resYear) + dayOfYear;
        } else if (dayOfYear > daysInYear(year)) {
            resYear = year + 1;
            resDayOfYear = dayOfYear - daysInYear(year);
        } else {
            resYear = year;
            resDayOfYear = dayOfYear;
        }

        return {
            year: resYear,
            dayOfYear: resDayOfYear,
        };
    }

    function weekOfYear(mom, dow, doy) {
        var weekOffset = firstWeekOffset(mom.year(), dow, doy),
            week = Math.floor((mom.dayOfYear() - weekOffset - 1) / 7) + 1,
            resWeek,
            resYear;

        if (week < 1) {
            resYear = mom.year() - 1;
            resWeek = week + weeksInYear(resYear, dow, doy);
        } else if (week > weeksInYear(mom.year(), dow, doy)) {
            resWeek = week - weeksInYear(mom.year(), dow, doy);
            resYear = mom.year() + 1;
        } else {
            resYear = mom.year();
            resWeek = week;
        }

        return {
            week: resWeek,
            year: resYear,
        };
    }

    function weeksInYear(year, dow, doy) {
        var weekOffset = firstWeekOffset(year, dow, doy),
            weekOffsetNext = firstWeekOffset(year + 1, dow, doy);
        return (daysInYear(year) - weekOffset + weekOffsetNext) / 7;
    }

    // FORMATTING

    addFormatToken("w", ["ww", 2], "wo", "week");
    addFormatToken("W", ["WW", 2], "Wo", "isoWeek");

    // ALIASES

    addUnitAlias("week", "w");
    addUnitAlias("isoWeek", "W");

    // PRIORITIES

    addUnitPriority("week", 5);
    addUnitPriority("isoWeek", 5);

    // PARSING

    addRegexToken("w", match1to2);
    addRegexToken("ww", match1to2, match2);
    addRegexToken("W", match1to2);
    addRegexToken("WW", match1to2, match2);

    addWeekParseToken(
        ["w", "ww", "W", "WW"],
        function (input, week, config, token) {
            week[token.substr(0, 1)] = toInt(input);
        }
    );

    // HELPERS

    // LOCALES

    function localeWeek(mom) {
        return weekOfYear(mom, this._week.dow, this._week.doy).week;
    }

    var defaultLocaleWeek = {
        dow: 0, // Sunday is the first day of the week.
        doy: 6, // The week that contains Jan 6th is the first week of the year.
    };

    function localeFirstDayOfWeek() {
        return this._week.dow;
    }

    function localeFirstDayOfYear() {
        return this._week.doy;
    }

    // MOMENTS

    function getSetWeek(input) {
        var week = this.localeData().week(this);
        return input == null ? week : this.add((input - week) * 7, "d");
    }

    function getSetISOWeek(input) {
        var week = weekOfYear(this, 1, 4).week;
        return input == null ? week : this.add((input - week) * 7, "d");
    }

    // FORMATTING

    addFormatToken("d", 0, "do", "day");

    addFormatToken("dd", 0, 0, function (format) {
        return this.localeData().weekdaysMin(this, format);
    });

    addFormatToken("ddd", 0, 0, function (format) {
        return this.localeData().weekdaysShort(this, format);
    });

    addFormatToken("dddd", 0, 0, function (format) {
        return this.localeData().weekdays(this, format);
    });

    addFormatToken("e", 0, 0, "weekday");
    addFormatToken("E", 0, 0, "isoWeekday");

    // ALIASES

    addUnitAlias("day", "d");
    addUnitAlias("weekday", "e");
    addUnitAlias("isoWeekday", "E");

    // PRIORITY
    addUnitPriority("day", 11);
    addUnitPriority("weekday", 11);
    addUnitPriority("isoWeekday", 11);

    // PARSING

    addRegexToken("d", match1to2);
    addRegexToken("e", match1to2);
    addRegexToken("E", match1to2);
    addRegexToken("dd", function (isStrict, locale) {
        return locale.weekdaysMinRegex(isStrict);
    });
    addRegexToken("ddd", function (isStrict, locale) {
        return locale.weekdaysShortRegex(isStrict);
    });
    addRegexToken("dddd", function (isStrict, locale) {
        return locale.weekdaysRegex(isStrict);
    });

    addWeekParseToken(
        ["dd", "ddd", "dddd"],
        function (input, week, config, token) {
            var weekday = config._locale.weekdaysParse(
                input,
                token,
                config._strict
            );
            // if we didn't get a weekday name, mark the date as invalid
            if (weekday != null) {
                week.d = weekday;
            } else {
                getParsingFlags(config).invalidWeekday = input;
            }
        }
    );

    addWeekParseToken(["d", "e", "E"], function (input, week, config, token) {
        week[token] = toInt(input);
    });

    // HELPERS

    function parseWeekday(input, locale) {
        if (typeof input !== "string") {
            return input;
        }

        if (!isNaN(input)) {
            return parseInt(input, 10);
        }

        input = locale.weekdaysParse(input);
        if (typeof input === "number") {
            return input;
        }

        return null;
    }

    function parseIsoWeekday(input, locale) {
        if (typeof input === "string") {
            return locale.weekdaysParse(input) % 7 || 7;
        }
        return isNaN(input) ? null : input;
    }

    // LOCALES
    function shiftWeekdays(ws, n) {
        return ws.slice(n, 7).concat(ws.slice(0, n));
    }

    var defaultLocaleWeekdays =
            "Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split(
                "_"
            ),
        defaultLocaleWeekdaysShort = "Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"),
        defaultLocaleWeekdaysMin = "Su_Mo_Tu_We_Th_Fr_Sa".split("_"),
        defaultWeekdaysRegex = matchWord,
        defaultWeekdaysShortRegex = matchWord,
        defaultWeekdaysMinRegex = matchWord;

    function localeWeekdays(m, format) {
        var weekdays = isArray(this._weekdays)
            ? this._weekdays
            : this._weekdays[
                  m && m !== true && this._weekdays.isFormat.test(format)
                      ? "format"
                      : "standalone"
              ];
        return m === true
            ? shiftWeekdays(weekdays, this._week.dow)
            : m
            ? weekdays[m.day()]
            : weekdays;
    }

    function localeWeekdaysShort(m) {
        return m === true
            ? shiftWeekdays(this._weekdaysShort, this._week.dow)
            : m
            ? this._weekdaysShort[m.day()]
            : this._weekdaysShort;
    }

    function localeWeekdaysMin(m) {
        return m === true
            ? shiftWeekdays(this._weekdaysMin, this._week.dow)
            : m
            ? this._weekdaysMin[m.day()]
            : this._weekdaysMin;
    }

    function handleStrictParse$1(weekdayName, format, strict) {
        var i,
            ii,
            mom,
            llc = weekdayName.toLocaleLowerCase();
        if (!this._weekdaysParse) {
            this._weekdaysParse = [];
            this._shortWeekdaysParse = [];
            this._minWeekdaysParse = [];

            for (i = 0; i < 7; ++i) {
                mom = createUTC([2000, 1]).day(i);
                this._minWeekdaysParse[i] = this.weekdaysMin(
                    mom,
                    ""
                ).toLocaleLowerCase();
                this._shortWeekdaysParse[i] = this.weekdaysShort(
                    mom,
                    ""
                ).toLocaleLowerCase();
                this._weekdaysParse[i] = this.weekdays(
                    mom,
                    ""
                ).toLocaleLowerCase();
            }
        }

        if (strict) {
            if (format === "dddd") {
                ii = indexOf.call(this._weekdaysParse, llc);
                return ii !== -1 ? ii : null;
            } else if (format === "ddd") {
                ii = indexOf.call(this._shortWeekdaysParse, llc);
                return ii !== -1 ? ii : null;
            } else {
                ii = indexOf.call(this._minWeekdaysParse, llc);
                return ii !== -1 ? ii : null;
            }
        } else {
            if (format === "dddd") {
                ii = indexOf.call(this._weekdaysParse, llc);
                if (ii !== -1) {
                    return ii;
                }
                ii = indexOf.call(this._shortWeekdaysParse, llc);
                if (ii !== -1) {
                    return ii;
                }
                ii = indexOf.call(this._minWeekdaysParse, llc);
                return ii !== -1 ? ii : null;
            } else if (format === "ddd") {
                ii = indexOf.call(this._shortWeekdaysParse, llc);
                if (ii !== -1) {
                    return ii;
                }
                ii = indexOf.call(this._weekdaysParse, llc);
                if (ii !== -1) {
                    return ii;
                }
                ii = indexOf.call(this._minWeekdaysParse, llc);
                return ii !== -1 ? ii : null;
            } else {
                ii = indexOf.call(this._minWeekdaysParse, llc);
                if (ii !== -1) {
                    return ii;
                }
                ii = indexOf.call(this._weekdaysParse, llc);
                if (ii !== -1) {
                    return ii;
                }
                ii = indexOf.call(this._shortWeekdaysParse, llc);
                return ii !== -1 ? ii : null;
            }
        }
    }

    function localeWeekdaysParse(weekdayName, format, strict) {
        var i, mom, regex;

        if (this._weekdaysParseExact) {
            return handleStrictParse$1.call(this, weekdayName, format, strict);
        }

        if (!this._weekdaysParse) {
            this._weekdaysParse = [];
            this._minWeekdaysParse = [];
            this._shortWeekdaysParse = [];
            this._fullWeekdaysParse = [];
        }

        for (i = 0; i < 7; i++) {
            // make the regex if we don't have it already

            mom = createUTC([2000, 1]).day(i);
            if (strict && !this._fullWeekdaysParse[i]) {
                this._fullWeekdaysParse[i] = new RegExp(
                    "^" + this.weekdays(mom, "").replace(".", "\\.?") + "$",
                    "i"
                );
                this._shortWeekdaysParse[i] = new RegExp(
                    "^" +
                        this.weekdaysShort(mom, "").replace(".", "\\.?") +
                        "$",
                    "i"
                );
                this._minWeekdaysParse[i] = new RegExp(
                    "^" + this.weekdaysMin(mom, "").replace(".", "\\.?") + "$",
                    "i"
                );
            }
            if (!this._weekdaysParse[i]) {
                regex =
                    "^" +
                    this.weekdays(mom, "") +
                    "|^" +
                    this.weekdaysShort(mom, "") +
                    "|^" +
                    this.weekdaysMin(mom, "");
                this._weekdaysParse[i] = new RegExp(
                    regex.replace(".", ""),
                    "i"
                );
            }
            // test the regex
            if (
                strict &&
                format === "dddd" &&
                this._fullWeekdaysParse[i].test(weekdayName)
            ) {
                return i;
            } else if (
                strict &&
                format === "ddd" &&
                this._shortWeekdaysParse[i].test(weekdayName)
            ) {
                return i;
            } else if (
                strict &&
                format === "dd" &&
                this._minWeekdaysParse[i].test(weekdayName)
            ) {
                return i;
            } else if (!strict && this._weekdaysParse[i].test(weekdayName)) {
                return i;
            }
        }
    }

    // MOMENTS

    function getSetDayOfWeek(input) {
        if (!this.isValid()) {
            return input != null ? this : NaN;
        }
        var day = this._isUTC ? this._d.getUTCDay() : this._d.getDay();
        if (input != null) {
            input = parseWeekday(input, this.localeData());
            return this.add(input - day, "d");
        } else {
            return day;
        }
    }

    function getSetLocaleDayOfWeek(input) {
        if (!this.isValid()) {
            return input != null ? this : NaN;
        }
        var weekday = (this.day() + 7 - this.localeData()._week.dow) % 7;
        return input == null ? weekday : this.add(input - weekday, "d");
    }

    function getSetISODayOfWeek(input) {
        if (!this.isValid()) {
            return input != null ? this : NaN;
        }

        // behaves the same as moment#day except
        // as a getter, returns 7 instead of 0 (1-7 range instead of 0-6)
        // as a setter, sunday should belong to the previous week.

        if (input != null) {
            var weekday = parseIsoWeekday(input, this.localeData());
            return this.day(this.day() % 7 ? weekday : weekday - 7);
        } else {
            return this.day() || 7;
        }
    }

    function weekdaysRegex(isStrict) {
        if (this._weekdaysParseExact) {
            if (!hasOwnProp(this, "_weekdaysRegex")) {
                computeWeekdaysParse.call(this);
            }
            if (isStrict) {
                return this._weekdaysStrictRegex;
            } else {
                return this._weekdaysRegex;
            }
        } else {
            if (!hasOwnProp(this, "_weekdaysRegex")) {
                this._weekdaysRegex = defaultWeekdaysRegex;
            }
            return this._weekdaysStrictRegex && isStrict
                ? this._weekdaysStrictRegex
                : this._weekdaysRegex;
        }
    }

    function weekdaysShortRegex(isStrict) {
        if (this._weekdaysParseExact) {
            if (!hasOwnProp(this, "_weekdaysRegex")) {
                computeWeekdaysParse.call(this);
            }
            if (isStrict) {
                return this._weekdaysShortStrictRegex;
            } else {
                return this._weekdaysShortRegex;
            }
        } else {
            if (!hasOwnProp(this, "_weekdaysShortRegex")) {
                this._weekdaysShortRegex = defaultWeekdaysShortRegex;
            }
            return this._weekdaysShortStrictRegex && isStrict
                ? this._weekdaysShortStrictRegex
                : this._weekdaysShortRegex;
        }
    }

    function weekdaysMinRegex(isStrict) {
        if (this._weekdaysParseExact) {
            if (!hasOwnProp(this, "_weekdaysRegex")) {
                computeWeekdaysParse.call(this);
            }
            if (isStrict) {
                return this._weekdaysMinStrictRegex;
            } else {
                return this._weekdaysMinRegex;
            }
        } else {
            if (!hasOwnProp(this, "_weekdaysMinRegex")) {
                this._weekdaysMinRegex = defaultWeekdaysMinRegex;
            }
            return this._weekdaysMinStrictRegex && isStrict
                ? this._weekdaysMinStrictRegex
                : this._weekdaysMinRegex;
        }
    }

    function computeWeekdaysParse() {
        function cmpLenRev(a, b) {
            return b.length - a.length;
        }

        var minPieces = [],
            shortPieces = [],
            longPieces = [],
            mixedPieces = [],
            i,
            mom,
            minp,
            shortp,
            longp;
        for (i = 0; i < 7; i++) {
            // make the regex if we don't have it already
            mom = createUTC([2000, 1]).day(i);
            minp = regexEscape(this.weekdaysMin(mom, ""));
            shortp = regexEscape(this.weekdaysShort(mom, ""));
            longp = regexEscape(this.weekdays(mom, ""));
            minPieces.push(minp);
            shortPieces.push(shortp);
            longPieces.push(longp);
            mixedPieces.push(minp);
            mixedPieces.push(shortp);
            mixedPieces.push(longp);
        }
        // Sorting makes sure if one weekday (or abbr) is a prefix of another it
        // will match the longer piece.
        minPieces.sort(cmpLenRev);
        shortPieces.sort(cmpLenRev);
        longPieces.sort(cmpLenRev);
        mixedPieces.sort(cmpLenRev);

        this._weekdaysRegex = new RegExp(
            "^(" + mixedPieces.join("|") + ")",
            "i"
        );
        this._weekdaysShortRegex = this._weekdaysRegex;
        this._weekdaysMinRegex = this._weekdaysRegex;

        this._weekdaysStrictRegex = new RegExp(
            "^(" + longPieces.join("|") + ")",
            "i"
        );
        this._weekdaysShortStrictRegex = new RegExp(
            "^(" + shortPieces.join("|") + ")",
            "i"
        );
        this._weekdaysMinStrictRegex = new RegExp(
            "^(" + minPieces.join("|") + ")",
            "i"
        );
    }

    // FORMATTING

    function hFormat() {
        return this.hours() % 12 || 12;
    }

    function kFormat() {
        return this.hours() || 24;
    }

    addFormatToken("H", ["HH", 2], 0, "hour");
    addFormatToken("h", ["hh", 2], 0, hFormat);
    addFormatToken("k", ["kk", 2], 0, kFormat);

    addFormatToken("hmm", 0, 0, function () {
        return "" + hFormat.apply(this) + zeroFill(this.minutes(), 2);
    });

    addFormatToken("hmmss", 0, 0, function () {
        return (
            "" +
            hFormat.apply(this) +
            zeroFill(this.minutes(), 2) +
            zeroFill(this.seconds(), 2)
        );
    });

    addFormatToken("Hmm", 0, 0, function () {
        return "" + this.hours() + zeroFill(this.minutes(), 2);
    });

    addFormatToken("Hmmss", 0, 0, function () {
        return (
            "" +
            this.hours() +
            zeroFill(this.minutes(), 2) +
            zeroFill(this.seconds(), 2)
        );
    });

    function meridiem(token, lowercase) {
        addFormatToken(token, 0, 0, function () {
            return this.localeData().meridiem(
                this.hours(),
                this.minutes(),
                lowercase
            );
        });
    }

    meridiem("a", true);
    meridiem("A", false);

    // ALIASES

    addUnitAlias("hour", "h");

    // PRIORITY
    addUnitPriority("hour", 13);

    // PARSING

    function matchMeridiem(isStrict, locale) {
        return locale._meridiemParse;
    }

    addRegexToken("a", matchMeridiem);
    addRegexToken("A", matchMeridiem);
    addRegexToken("H", match1to2);
    addRegexToken("h", match1to2);
    addRegexToken("k", match1to2);
    addRegexToken("HH", match1to2, match2);
    addRegexToken("hh", match1to2, match2);
    addRegexToken("kk", match1to2, match2);

    addRegexToken("hmm", match3to4);
    addRegexToken("hmmss", match5to6);
    addRegexToken("Hmm", match3to4);
    addRegexToken("Hmmss", match5to6);

    addParseToken(["H", "HH"], HOUR);
    addParseToken(["k", "kk"], function (input, array, config) {
        var kInput = toInt(input);
        array[HOUR] = kInput === 24 ? 0 : kInput;
    });
    addParseToken(["a", "A"], function (input, array, config) {
        config._isPm = config._locale.isPM(input);
        config._meridiem = input;
    });
    addParseToken(["h", "hh"], function (input, array, config) {
        array[HOUR] = toInt(input);
        getParsingFlags(config).bigHour = true;
    });
    addParseToken("hmm", function (input, array, config) {
        var pos = input.length - 2;
        array[HOUR] = toInt(input.substr(0, pos));
        array[MINUTE] = toInt(input.substr(pos));
        getParsingFlags(config).bigHour = true;
    });
    addParseToken("hmmss", function (input, array, config) {
        var pos1 = input.length - 4,
            pos2 = input.length - 2;
        array[HOUR] = toInt(input.substr(0, pos1));
        array[MINUTE] = toInt(input.substr(pos1, 2));
        array[SECOND] = toInt(input.substr(pos2));
        getParsingFlags(config).bigHour = true;
    });
    addParseToken("Hmm", function (input, array, config) {
        var pos = input.length - 2;
        array[HOUR] = toInt(input.substr(0, pos));
        array[MINUTE] = toInt(input.substr(pos));
    });
    addParseToken("Hmmss", function (input, array, config) {
        var pos1 = input.length - 4,
            pos2 = input.length - 2;
        array[HOUR] = toInt(input.substr(0, pos1));
        array[MINUTE] = toInt(input.substr(pos1, 2));
        array[SECOND] = toInt(input.substr(pos2));
    });

    // LOCALES

    function localeIsPM(input) {
        // IE8 Quirks Mode & IE7 Standards Mode do not allow accessing strings like arrays
        // Using charAt should be more compatible.
        return (input + "").toLowerCase().charAt(0) === "p";
    }

    var defaultLocaleMeridiemParse = /[ap]\.?m?\.?/i,
        // Setting the hour should keep the time, because the user explicitly
        // specified which hour they want. So trying to maintain the same hour (in
        // a new timezone) makes sense. Adding/subtracting hours does not follow
        // this rule.
        getSetHour = makeGetSet("Hours", true);

    function localeMeridiem(hours, minutes, isLower) {
        if (hours > 11) {
            return isLower ? "pm" : "PM";
        } else {
            return isLower ? "am" : "AM";
        }
    }

    var baseConfig = {
        calendar: defaultCalendar,
        longDateFormat: defaultLongDateFormat,
        invalidDate: defaultInvalidDate,
        ordinal: defaultOrdinal,
        dayOfMonthOrdinalParse: defaultDayOfMonthOrdinalParse,
        relativeTime: defaultRelativeTime,

        months: defaultLocaleMonths,
        monthsShort: defaultLocaleMonthsShort,

        week: defaultLocaleWeek,

        weekdays: defaultLocaleWeekdays,
        weekdaysMin: defaultLocaleWeekdaysMin,
        weekdaysShort: defaultLocaleWeekdaysShort,

        meridiemParse: defaultLocaleMeridiemParse,
    };

    // internal storage for locale config files
    var locales = {},
        localeFamilies = {},
        globalLocale;

    function commonPrefix(arr1, arr2) {
        var i,
            minl = Math.min(arr1.length, arr2.length);
        for (i = 0; i < minl; i += 1) {
            if (arr1[i] !== arr2[i]) {
                return i;
            }
        }
        return minl;
    }

    function normalizeLocale(key) {
        return key ? key.toLowerCase().replace("_", "-") : key;
    }

    // pick the locale from the array
    // try ['en-au', 'en-gb'] as 'en-au', 'en-gb', 'en', as in move through the list trying each
    // substring from most specific to least, but move to the next array item if it's a more specific variant than the current root
    function chooseLocale(names) {
        var i = 0,
            j,
            next,
            locale,
            split;

        while (i < names.length) {
            split = normalizeLocale(names[i]).split("-");
            j = split.length;
            next = normalizeLocale(names[i + 1]);
            next = next ? next.split("-") : null;
            while (j > 0) {
                locale = loadLocale(split.slice(0, j).join("-"));
                if (locale) {
                    return locale;
                }
                if (
                    next &&
                    next.length >= j &&
                    commonPrefix(split, next) >= j - 1
                ) {
                    //the next array item is better than a shallower substring of this one
                    break;
                }
                j--;
            }
            i++;
        }
        return globalLocale;
    }

    function loadLocale(name) {
        var oldLocale = null,
            aliasedRequire;
        // TODO: Find a better way to register and load all the locales in Node
        if (
            locales[name] === undefined &&
            typeof module !== "undefined" &&
            module &&
            module.exports
        ) {
            try {
                oldLocale = globalLocale._abbr;
                aliasedRequire = require;
                aliasedRequire("./locale/" + name);
                getSetGlobalLocale(oldLocale);
            } catch (e) {
                // mark as not found to avoid repeating expensive file require call causing high CPU
                // when trying to find en-US, en_US, en-us for every format call
                locales[name] = null; // null means not found
            }
        }
        return locales[name];
    }

    // This function will load locale and then set the global locale.  If
    // no arguments are passed in, it will simply return the current global
    // locale key.
    function getSetGlobalLocale(key, values) {
        var data;
        if (key) {
            if (isUndefined(values)) {
                data = getLocale(key);
            } else {
                data = defineLocale(key, values);
            }

            if (data) {
                // moment.duration._locale = moment._locale = data;
                globalLocale = data;
            } else {
                if (typeof console !== "undefined" && console.warn) {
                    //warn user if arguments are passed but the locale could not be set
                    console.warn(
                        "Locale " +
                            key +
                            " not found. Did you forget to load it?"
                    );
                }
            }
        }

        return globalLocale._abbr;
    }

    function defineLocale(name, config) {
        if (config !== null) {
            var locale,
                parentConfig = baseConfig;
            config.abbr = name;
            if (locales[name] != null) {
                deprecateSimple(
                    "defineLocaleOverride",
                    "use moment.updateLocale(localeName, config) to change " +
                        "an existing locale. moment.defineLocale(localeName, " +
                        "config) should only be used for creating a new locale " +
                        "See http://momentjs.com/guides/#/warnings/define-locale/ for more info."
                );
                parentConfig = locales[name]._config;
            } else if (config.parentLocale != null) {
                if (locales[config.parentLocale] != null) {
                    parentConfig = locales[config.parentLocale]._config;
                } else {
                    locale = loadLocale(config.parentLocale);
                    if (locale != null) {
                        parentConfig = locale._config;
                    } else {
                        if (!localeFamilies[config.parentLocale]) {
                            localeFamilies[config.parentLocale] = [];
                        }
                        localeFamilies[config.parentLocale].push({
                            name: name,
                            config: config,
                        });
                        return null;
                    }
                }
            }
            locales[name] = new Locale(mergeConfigs(parentConfig, config));

            if (localeFamilies[name]) {
                localeFamilies[name].forEach(function (x) {
                    defineLocale(x.name, x.config);
                });
            }

            // backwards compat for now: also set the locale
            // make sure we set the locale AFTER all child locales have been
            // created, so we won't end up with the child locale set.
            getSetGlobalLocale(name);

            return locales[name];
        } else {
            // useful for testing
            delete locales[name];
            return null;
        }
    }

    function updateLocale(name, config) {
        if (config != null) {
            var locale,
                tmpLocale,
                parentConfig = baseConfig;

            if (locales[name] != null && locales[name].parentLocale != null) {
                // Update existing child locale in-place to avoid memory-leaks
                locales[name].set(mergeConfigs(locales[name]._config, config));
            } else {
                // MERGE
                tmpLocale = loadLocale(name);
                if (tmpLocale != null) {
                    parentConfig = tmpLocale._config;
                }
                config = mergeConfigs(parentConfig, config);
                if (tmpLocale == null) {
                    // updateLocale is called for creating a new locale
                    // Set abbr so it will have a name (getters return
                    // undefined otherwise).
                    config.abbr = name;
                }
                locale = new Locale(config);
                locale.parentLocale = locales[name];
                locales[name] = locale;
            }

            // backwards compat for now: also set the locale
            getSetGlobalLocale(name);
        } else {
            // pass null for config to unupdate, useful for tests
            if (locales[name] != null) {
                if (locales[name].parentLocale != null) {
                    locales[name] = locales[name].parentLocale;
                    if (name === getSetGlobalLocale()) {
                        getSetGlobalLocale(name);
                    }
                } else if (locales[name] != null) {
                    delete locales[name];
                }
            }
        }
        return locales[name];
    }

    // returns locale data
    function getLocale(key) {
        var locale;

        if (key && key._locale && key._locale._abbr) {
            key = key._locale._abbr;
        }

        if (!key) {
            return globalLocale;
        }

        if (!isArray(key)) {
            //short-circuit everything else
            locale = loadLocale(key);
            if (locale) {
                return locale;
            }
            key = [key];
        }

        return chooseLocale(key);
    }

    function listLocales() {
        return keys(locales);
    }

    function checkOverflow(m) {
        var overflow,
            a = m._a;

        if (a && getParsingFlags(m).overflow === -2) {
            overflow =
                a[MONTH] < 0 || a[MONTH] > 11
                    ? MONTH
                    : a[DATE] < 1 || a[DATE] > daysInMonth(a[YEAR], a[MONTH])
                    ? DATE
                    : a[HOUR] < 0 ||
                      a[HOUR] > 24 ||
                      (a[HOUR] === 24 &&
                          (a[MINUTE] !== 0 ||
                              a[SECOND] !== 0 ||
                              a[MILLISECOND] !== 0))
                    ? HOUR
                    : a[MINUTE] < 0 || a[MINUTE] > 59
                    ? MINUTE
                    : a[SECOND] < 0 || a[SECOND] > 59
                    ? SECOND
                    : a[MILLISECOND] < 0 || a[MILLISECOND] > 999
                    ? MILLISECOND
                    : -1;

            if (
                getParsingFlags(m)._overflowDayOfYear &&
                (overflow < YEAR || overflow > DATE)
            ) {
                overflow = DATE;
            }
            if (getParsingFlags(m)._overflowWeeks && overflow === -1) {
                overflow = WEEK;
            }
            if (getParsingFlags(m)._overflowWeekday && overflow === -1) {
                overflow = WEEKDAY;
            }

            getParsingFlags(m).overflow = overflow;
        }

        return m;
    }

    // iso 8601 regex
    // 0000-00-00 0000-W00 or 0000-W00-0 + T + 00 or 00:00 or 00:00:00 or 00:00:00.000 + +00:00 or +0000 or +00)
    var extendedIsoRegex =
            /^\s*((?:[+-]\d{6}|\d{4})-(?:\d\d-\d\d|W\d\d-\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?::\d\d(?::\d\d(?:[.,]\d+)?)?)?)([+-]\d\d(?::?\d\d)?|\s*Z)?)?$/,
        basicIsoRegex =
            /^\s*((?:[+-]\d{6}|\d{4})(?:\d\d\d\d|W\d\d\d|W\d\d|\d\d\d|\d\d|))(?:(T| )(\d\d(?:\d\d(?:\d\d(?:[.,]\d+)?)?)?)([+-]\d\d(?::?\d\d)?|\s*Z)?)?$/,
        tzRegex = /Z|[+-]\d\d(?::?\d\d)?/,
        isoDates = [
            ["YYYYYY-MM-DD", /[+-]\d{6}-\d\d-\d\d/],
            ["YYYY-MM-DD", /\d{4}-\d\d-\d\d/],
            ["GGGG-[W]WW-E", /\d{4}-W\d\d-\d/],
            ["GGGG-[W]WW", /\d{4}-W\d\d/, false],
            ["YYYY-DDD", /\d{4}-\d{3}/],
            ["YYYY-MM", /\d{4}-\d\d/, false],
            ["YYYYYYMMDD", /[+-]\d{10}/],
            ["YYYYMMDD", /\d{8}/],
            ["GGGG[W]WWE", /\d{4}W\d{3}/],
            ["GGGG[W]WW", /\d{4}W\d{2}/, false],
            ["YYYYDDD", /\d{7}/],
            ["YYYYMM", /\d{6}/, false],
            ["YYYY", /\d{4}/, false],
        ],
        // iso time formats and regexes
        isoTimes = [
            ["HH:mm:ss.SSSS", /\d\d:\d\d:\d\d\.\d+/],
            ["HH:mm:ss,SSSS", /\d\d:\d\d:\d\d,\d+/],
            ["HH:mm:ss", /\d\d:\d\d:\d\d/],
            ["HH:mm", /\d\d:\d\d/],
            ["HHmmss.SSSS", /\d\d\d\d\d\d\.\d+/],
            ["HHmmss,SSSS", /\d\d\d\d\d\d,\d+/],
            ["HHmmss", /\d\d\d\d\d\d/],
            ["HHmm", /\d\d\d\d/],
            ["HH", /\d\d/],
        ],
        aspNetJsonRegex = /^\/?Date\((-?\d+)/i,
        // RFC 2822 regex: For details see https://tools.ietf.org/html/rfc2822#section-3.3
        rfc2822 =
            /^(?:(Mon|Tue|Wed|Thu|Fri|Sat|Sun),?\s)?(\d{1,2})\s(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\s(\d{2,4})\s(\d\d):(\d\d)(?::(\d\d))?\s(?:(UT|GMT|[ECMP][SD]T)|([Zz])|([+-]\d{4}))$/,
        obsOffsets = {
            UT: 0,
            GMT: 0,
            EDT: -4 * 60,
            EST: -5 * 60,
            CDT: -5 * 60,
            CST: -6 * 60,
            MDT: -6 * 60,
            MST: -7 * 60,
            PDT: -7 * 60,
            PST: -8 * 60,
        };

    // date from iso format
    function configFromISO(config) {
        var i,
            l,
            string = config._i,
            match = extendedIsoRegex.exec(string) || basicIsoRegex.exec(string),
            allowTime,
            dateFormat,
            timeFormat,
            tzFormat;

        if (match) {
            getParsingFlags(config).iso = true;

            for (i = 0, l = isoDates.length; i < l; i++) {
                if (isoDates[i][1].exec(match[1])) {
                    dateFormat = isoDates[i][0];
                    allowTime = isoDates[i][2] !== false;
                    break;
                }
            }
            if (dateFormat == null) {
                config._isValid = false;
                return;
            }
            if (match[3]) {
                for (i = 0, l = isoTimes.length; i < l; i++) {
                    if (isoTimes[i][1].exec(match[3])) {
                        // match[2] should be 'T' or space
                        timeFormat = (match[2] || " ") + isoTimes[i][0];
                        break;
                    }
                }
                if (timeFormat == null) {
                    config._isValid = false;
                    return;
                }
            }
            if (!allowTime && timeFormat != null) {
                config._isValid = false;
                return;
            }
            if (match[4]) {
                if (tzRegex.exec(match[4])) {
                    tzFormat = "Z";
                } else {
                    config._isValid = false;
                    return;
                }
            }
            config._f = dateFormat + (timeFormat || "") + (tzFormat || "");
            configFromStringAndFormat(config);
        } else {
            config._isValid = false;
        }
    }

    function extractFromRFC2822Strings(
        yearStr,
        monthStr,
        dayStr,
        hourStr,
        minuteStr,
        secondStr
    ) {
        var result = [
            untruncateYear(yearStr),
            defaultLocaleMonthsShort.indexOf(monthStr),
            parseInt(dayStr, 10),
            parseInt(hourStr, 10),
            parseInt(minuteStr, 10),
        ];

        if (secondStr) {
            result.push(parseInt(secondStr, 10));
        }

        return result;
    }

    function untruncateYear(yearStr) {
        var year = parseInt(yearStr, 10);
        if (year <= 49) {
            return 2000 + year;
        } else if (year <= 999) {
            return 1900 + year;
        }
        return year;
    }

    function preprocessRFC2822(s) {
        // Remove comments and folding whitespace and replace multiple-spaces with a single space
        return s
            .replace(/\([^)]*\)|[\n\t]/g, " ")
            .replace(/(\s\s+)/g, " ")
            .replace(/^\s\s*/, "")
            .replace(/\s\s*$/, "");
    }

    function checkWeekday(weekdayStr, parsedInput, config) {
        if (weekdayStr) {
            // TODO: Replace the vanilla JS Date object with an independent day-of-week check.
            var weekdayProvided =
                    defaultLocaleWeekdaysShort.indexOf(weekdayStr),
                weekdayActual = new Date(
                    parsedInput[0],
                    parsedInput[1],
                    parsedInput[2]
                ).getDay();
            if (weekdayProvided !== weekdayActual) {
                getParsingFlags(config).weekdayMismatch = true;
                config._isValid = false;
                return false;
            }
        }
        return true;
    }

    function calculateOffset(obsOffset, militaryOffset, numOffset) {
        if (obsOffset) {
            return obsOffsets[obsOffset];
        } else if (militaryOffset) {
            // the only allowed military tz is Z
            return 0;
        } else {
            var hm = parseInt(numOffset, 10),
                m = hm % 100,
                h = (hm - m) / 100;
            return h * 60 + m;
        }
    }

    // date and time from ref 2822 format
    function configFromRFC2822(config) {
        var match = rfc2822.exec(preprocessRFC2822(config._i)),
            parsedArray;
        if (match) {
            parsedArray = extractFromRFC2822Strings(
                match[4],
                match[3],
                match[2],
                match[5],
                match[6],
                match[7]
            );
            if (!checkWeekday(match[1], parsedArray, config)) {
                return;
            }

            config._a = parsedArray;
            config._tzm = calculateOffset(match[8], match[9], match[10]);

            config._d = createUTCDate.apply(null, config._a);
            config._d.setUTCMinutes(config._d.getUTCMinutes() - config._tzm);

            getParsingFlags(config).rfc2822 = true;
        } else {
            config._isValid = false;
        }
    }

    // date from 1) ASP.NET, 2) ISO, 3) RFC 2822 formats, or 4) optional fallback if parsing isn't strict
    function configFromString(config) {
        var matched = aspNetJsonRegex.exec(config._i);
        if (matched !== null) {
            config._d = new Date(+matched[1]);
            return;
        }

        configFromISO(config);
        if (config._isValid === false) {
            delete config._isValid;
        } else {
            return;
        }

        configFromRFC2822(config);
        if (config._isValid === false) {
            delete config._isValid;
        } else {
            return;
        }

        if (config._strict) {
            config._isValid = false;
        } else {
            // Final attempt, use Input Fallback
            hooks.createFromInputFallback(config);
        }
    }

    hooks.createFromInputFallback = deprecate(
        "value provided is not in a recognized RFC2822 or ISO format. moment construction falls back to js Date(), " +
            "which is not reliable across all browsers and versions. Non RFC2822/ISO date formats are " +
            "discouraged. Please refer to http://momentjs.com/guides/#/warnings/js-date/ for more info.",
        function (config) {
            config._d = new Date(config._i + (config._useUTC ? " UTC" : ""));
        }
    );

    // Pick the first defined of two or three arguments.
    function defaults(a, b, c) {
        if (a != null) {
            return a;
        }
        if (b != null) {
            return b;
        }
        return c;
    }

    function currentDateArray(config) {
        // hooks is actually the exported moment object
        var nowValue = new Date(hooks.now());
        if (config._useUTC) {
            return [
                nowValue.getUTCFullYear(),
                nowValue.getUTCMonth(),
                nowValue.getUTCDate(),
            ];
        }
        return [
            nowValue.getFullYear(),
            nowValue.getMonth(),
            nowValue.getDate(),
        ];
    }

    // convert an array to a date.
    // the array should mirror the parameters below
    // note: all values past the year are optional and will default to the lowest possible value.
    // [year, month, day , hour, minute, second, millisecond]
    function configFromArray(config) {
        var i,
            date,
            input = [],
            currentDate,
            expectedWeekday,
            yearToUse;

        if (config._d) {
            return;
        }

        currentDate = currentDateArray(config);

        //compute day of the year from weeks and weekdays
        if (config._w && config._a[DATE] == null && config._a[MONTH] == null) {
            dayOfYearFromWeekInfo(config);
        }

        //if the day of the year is set, figure out what it is
        if (config._dayOfYear != null) {
            yearToUse = defaults(config._a[YEAR], currentDate[YEAR]);

            if (
                config._dayOfYear > daysInYear(yearToUse) ||
                config._dayOfYear === 0
            ) {
                getParsingFlags(config)._overflowDayOfYear = true;
            }

            date = createUTCDate(yearToUse, 0, config._dayOfYear);
            config._a[MONTH] = date.getUTCMonth();
            config._a[DATE] = date.getUTCDate();
        }

        // Default to current date.
        // * if no year, month, day of month are given, default to today
        // * if day of month is given, default month and year
        // * if month is given, default only year
        // * if year is given, don't default anything
        for (i = 0; i < 3 && config._a[i] == null; ++i) {
            config._a[i] = input[i] = currentDate[i];
        }

        // Zero out whatever was not defaulted, including time
        for (; i < 7; i++) {
            config._a[i] = input[i] =
                config._a[i] == null ? (i === 2 ? 1 : 0) : config._a[i];
        }

        // Check for 24:00:00.000
        if (
            config._a[HOUR] === 24 &&
            config._a[MINUTE] === 0 &&
            config._a[SECOND] === 0 &&
            config._a[MILLISECOND] === 0
        ) {
            config._nextDay = true;
            config._a[HOUR] = 0;
        }

        config._d = (config._useUTC ? createUTCDate : createDate).apply(
            null,
            input
        );
        expectedWeekday = config._useUTC
            ? config._d.getUTCDay()
            : config._d.getDay();

        // Apply timezone offset from input. The actual utcOffset can be changed
        // with parseZone.
        if (config._tzm != null) {
            config._d.setUTCMinutes(config._d.getUTCMinutes() - config._tzm);
        }

        if (config._nextDay) {
            config._a[HOUR] = 24;
        }

        // check for mismatching day of week
        if (
            config._w &&
            typeof config._w.d !== "undefined" &&
            config._w.d !== expectedWeekday
        ) {
            getParsingFlags(config).weekdayMismatch = true;
        }
    }

    function dayOfYearFromWeekInfo(config) {
        var w,
            weekYear,
            week,
            weekday,
            dow,
            doy,
            temp,
            weekdayOverflow,
            curWeek;

        w = config._w;
        if (w.GG != null || w.W != null || w.E != null) {
            dow = 1;
            doy = 4;

            // TODO: We need to take the current isoWeekYear, but that depends on
            // how we interpret now (local, utc, fixed offset). So create
            // a now version of current config (take local/utc/offset flags, and
            // create now).
            weekYear = defaults(
                w.GG,
                config._a[YEAR],
                weekOfYear(createLocal(), 1, 4).year
            );
            week = defaults(w.W, 1);
            weekday = defaults(w.E, 1);
            if (weekday < 1 || weekday > 7) {
                weekdayOverflow = true;
            }
        } else {
            dow = config._locale._week.dow;
            doy = config._locale._week.doy;

            curWeek = weekOfYear(createLocal(), dow, doy);

            weekYear = defaults(w.gg, config._a[YEAR], curWeek.year);

            // Default to current week.
            week = defaults(w.w, curWeek.week);

            if (w.d != null) {
                // weekday -- low day numbers are considered next week
                weekday = w.d;
                if (weekday < 0 || weekday > 6) {
                    weekdayOverflow = true;
                }
            } else if (w.e != null) {
                // local weekday -- counting starts from beginning of week
                weekday = w.e + dow;
                if (w.e < 0 || w.e > 6) {
                    weekdayOverflow = true;
                }
            } else {
                // default to beginning of week
                weekday = dow;
            }
        }
        if (week < 1 || week > weeksInYear(weekYear, dow, doy)) {
            getParsingFlags(config)._overflowWeeks = true;
        } else if (weekdayOverflow != null) {
            getParsingFlags(config)._overflowWeekday = true;
        } else {
            temp = dayOfYearFromWeeks(weekYear, week, weekday, dow, doy);
            config._a[YEAR] = temp.year;
            config._dayOfYear = temp.dayOfYear;
        }
    }

    // constant that refers to the ISO standard
    hooks.ISO_8601 = function () {};

    // constant that refers to the RFC 2822 form
    hooks.RFC_2822 = function () {};

    // date from string and format string
    function configFromStringAndFormat(config) {
        // TODO: Move this to another part of the creation flow to prevent circular deps
        if (config._f === hooks.ISO_8601) {
            configFromISO(config);
            return;
        }
        if (config._f === hooks.RFC_2822) {
            configFromRFC2822(config);
            return;
        }
        config._a = [];
        getParsingFlags(config).empty = true;

        // This array is used to make a Date, either with `new Date` or `Date.UTC`
        var string = "" + config._i,
            i,
            parsedInput,
            tokens,
            token,
            skipped,
            stringLength = string.length,
            totalParsedInputLength = 0,
            era;

        tokens =
            expandFormat(config._f, config._locale).match(formattingTokens) ||
            [];

        for (i = 0; i < tokens.length; i++) {
            token = tokens[i];
            parsedInput = (string.match(getParseRegexForToken(token, config)) ||
                [])[0];
            if (parsedInput) {
                skipped = string.substr(0, string.indexOf(parsedInput));
                if (skipped.length > 0) {
                    getParsingFlags(config).unusedInput.push(skipped);
                }
                string = string.slice(
                    string.indexOf(parsedInput) + parsedInput.length
                );
                totalParsedInputLength += parsedInput.length;
            }
            // don't parse if it's not a known token
            if (formatTokenFunctions[token]) {
                if (parsedInput) {
                    getParsingFlags(config).empty = false;
                } else {
                    getParsingFlags(config).unusedTokens.push(token);
                }
                addTimeToArrayFromToken(token, parsedInput, config);
            } else if (config._strict && !parsedInput) {
                getParsingFlags(config).unusedTokens.push(token);
            }
        }

        // add remaining unparsed input length to the string
        getParsingFlags(config).charsLeftOver =
            stringLength - totalParsedInputLength;
        if (string.length > 0) {
            getParsingFlags(config).unusedInput.push(string);
        }

        // clear _12h flag if hour is <= 12
        if (
            config._a[HOUR] <= 12 &&
            getParsingFlags(config).bigHour === true &&
            config._a[HOUR] > 0
        ) {
            getParsingFlags(config).bigHour = undefined;
        }

        getParsingFlags(config).parsedDateParts = config._a.slice(0);
        getParsingFlags(config).meridiem = config._meridiem;
        // handle meridiem
        config._a[HOUR] = meridiemFixWrap(
            config._locale,
            config._a[HOUR],
            config._meridiem
        );

        // handle era
        era = getParsingFlags(config).era;
        if (era !== null) {
            config._a[YEAR] = config._locale.erasConvertYear(
                era,
                config._a[YEAR]
            );
        }

        configFromArray(config);
        checkOverflow(config);
    }

    function meridiemFixWrap(locale, hour, meridiem) {
        var isPm;

        if (meridiem == null) {
            // nothing to do
            return hour;
        }
        if (locale.meridiemHour != null) {
            return locale.meridiemHour(hour, meridiem);
        } else if (locale.isPM != null) {
            // Fallback
            isPm = locale.isPM(meridiem);
            if (isPm && hour < 12) {
                hour += 12;
            }
            if (!isPm && hour === 12) {
                hour = 0;
            }
            return hour;
        } else {
            // this is not supposed to happen
            return hour;
        }
    }

    // date from string and array of format strings
    function configFromStringAndArray(config) {
        var tempConfig,
            bestMoment,
            scoreToBeat,
            i,
            currentScore,
            validFormatFound,
            bestFormatIsValid = false;

        if (config._f.length === 0) {
            getParsingFlags(config).invalidFormat = true;
            config._d = new Date(NaN);
            return;
        }

        for (i = 0; i < config._f.length; i++) {
            currentScore = 0;
            validFormatFound = false;
            tempConfig = copyConfig({}, config);
            if (config._useUTC != null) {
                tempConfig._useUTC = config._useUTC;
            }
            tempConfig._f = config._f[i];
            configFromStringAndFormat(tempConfig);

            if (isValid(tempConfig)) {
                validFormatFound = true;
            }

            // if there is any input that was not parsed add a penalty for that format
            currentScore += getParsingFlags(tempConfig).charsLeftOver;

            //or tokens
            currentScore +=
                getParsingFlags(tempConfig).unusedTokens.length * 10;

            getParsingFlags(tempConfig).score = currentScore;

            if (!bestFormatIsValid) {
                if (
                    scoreToBeat == null ||
                    currentScore < scoreToBeat ||
                    validFormatFound
                ) {
                    scoreToBeat = currentScore;
                    bestMoment = tempConfig;
                    if (validFormatFound) {
                        bestFormatIsValid = true;
                    }
                }
            } else {
                if (currentScore < scoreToBeat) {
                    scoreToBeat = currentScore;
                    bestMoment = tempConfig;
                }
            }
        }

        extend(config, bestMoment || tempConfig);
    }

    function configFromObject(config) {
        if (config._d) {
            return;
        }

        var i = normalizeObjectUnits(config._i),
            dayOrDate = i.day === undefined ? i.date : i.day;
        config._a = map(
            [
                i.year,
                i.month,
                dayOrDate,
                i.hour,
                i.minute,
                i.second,
                i.millisecond,
            ],
            function (obj) {
                return obj && parseInt(obj, 10);
            }
        );

        configFromArray(config);
    }

    function createFromConfig(config) {
        var res = new Moment(checkOverflow(prepareConfig(config)));
        if (res._nextDay) {
            // Adding is smart enough around DST
            res.add(1, "d");
            res._nextDay = undefined;
        }

        return res;
    }

    function prepareConfig(config) {
        var input = config._i,
            format = config._f;

        config._locale = config._locale || getLocale(config._l);

        if (input === null || (format === undefined && input === "")) {
            return createInvalid({ nullInput: true });
        }

        if (typeof input === "string") {
            config._i = input = config._locale.preparse(input);
        }

        if (isMoment(input)) {
            return new Moment(checkOverflow(input));
        } else if (isDate(input)) {
            config._d = input;
        } else if (isArray(format)) {
            configFromStringAndArray(config);
        } else if (format) {
            configFromStringAndFormat(config);
        } else {
            configFromInput(config);
        }

        if (!isValid(config)) {
            config._d = null;
        }

        return config;
    }

    function configFromInput(config) {
        var input = config._i;
        if (isUndefined(input)) {
            config._d = new Date(hooks.now());
        } else if (isDate(input)) {
            config._d = new Date(input.valueOf());
        } else if (typeof input === "string") {
            configFromString(config);
        } else if (isArray(input)) {
            config._a = map(input.slice(0), function (obj) {
                return parseInt(obj, 10);
            });
            configFromArray(config);
        } else if (isObject(input)) {
            configFromObject(config);
        } else if (isNumber(input)) {
            // from milliseconds
            config._d = new Date(input);
        } else {
            hooks.createFromInputFallback(config);
        }
    }

    function createLocalOrUTC(input, format, locale, strict, isUTC) {
        var c = {};

        if (format === true || format === false) {
            strict = format;
            format = undefined;
        }

        if (locale === true || locale === false) {
            strict = locale;
            locale = undefined;
        }

        if (
            (isObject(input) && isObjectEmpty(input)) ||
            (isArray(input) && input.length === 0)
        ) {
            input = undefined;
        }
        // object construction must be done this way.
        // https://github.com/moment/moment/issues/1423
        c._isAMomentObject = true;
        c._useUTC = c._isUTC = isUTC;
        c._l = locale;
        c._i = input;
        c._f = format;
        c._strict = strict;

        return createFromConfig(c);
    }

    function createLocal(input, format, locale, strict) {
        return createLocalOrUTC(input, format, locale, strict, false);
    }

    var prototypeMin = deprecate(
            "moment().min is deprecated, use moment.max instead. http://momentjs.com/guides/#/warnings/min-max/",
            function () {
                var other = createLocal.apply(null, arguments);
                if (this.isValid() && other.isValid()) {
                    return other < this ? this : other;
                } else {
                    return createInvalid();
                }
            }
        ),
        prototypeMax = deprecate(
            "moment().max is deprecated, use moment.min instead. http://momentjs.com/guides/#/warnings/min-max/",
            function () {
                var other = createLocal.apply(null, arguments);
                if (this.isValid() && other.isValid()) {
                    return other > this ? this : other;
                } else {
                    return createInvalid();
                }
            }
        );

    // Pick a moment m from moments so that m[fn](other) is true for all
    // other. This relies on the function fn to be transitive.
    //
    // moments should either be an array of moment objects or an array, whose
    // first element is an array of moment objects.
    function pickBy(fn, moments) {
        var res, i;
        if (moments.length === 1 && isArray(moments[0])) {
            moments = moments[0];
        }
        if (!moments.length) {
            return createLocal();
        }
        res = moments[0];
        for (i = 1; i < moments.length; ++i) {
            if (!moments[i].isValid() || moments[i][fn](res)) {
                res = moments[i];
            }
        }
        return res;
    }

    // TODO: Use [].sort instead?
    function min() {
        var args = [].slice.call(arguments, 0);

        return pickBy("isBefore", args);
    }

    function max() {
        var args = [].slice.call(arguments, 0);

        return pickBy("isAfter", args);
    }

    var now = function () {
        return Date.now ? Date.now() : +new Date();
    };

    var ordering = [
        "year",
        "quarter",
        "month",
        "week",
        "day",
        "hour",
        "minute",
        "second",
        "millisecond",
    ];

    function isDurationValid(m) {
        var key,
            unitHasDecimal = false,
            i;
        for (key in m) {
            if (
                hasOwnProp(m, key) &&
                !(
                    indexOf.call(ordering, key) !== -1 &&
                    (m[key] == null || !isNaN(m[key]))
                )
            ) {
                return false;
            }
        }

        for (i = 0; i < ordering.length; ++i) {
            if (m[ordering[i]]) {
                if (unitHasDecimal) {
                    return false; // only allow non-integers for smallest unit
                }
                if (parseFloat(m[ordering[i]]) !== toInt(m[ordering[i]])) {
                    unitHasDecimal = true;
                }
            }
        }

        return true;
    }

    function isValid$1() {
        return this._isValid;
    }

    function createInvalid$1() {
        return createDuration(NaN);
    }

    function Duration(duration) {
        var normalizedInput = normalizeObjectUnits(duration),
            years = normalizedInput.year || 0,
            quarters = normalizedInput.quarter || 0,
            months = normalizedInput.month || 0,
            weeks = normalizedInput.week || normalizedInput.isoWeek || 0,
            days = normalizedInput.day || 0,
            hours = normalizedInput.hour || 0,
            minutes = normalizedInput.minute || 0,
            seconds = normalizedInput.second || 0,
            milliseconds = normalizedInput.millisecond || 0;

        this._isValid = isDurationValid(normalizedInput);

        // representation for dateAddRemove
        this._milliseconds =
            +milliseconds +
            seconds * 1e3 + // 1000
            minutes * 6e4 + // 1000 * 60
            hours * 1000 * 60 * 60; //using 1000 * 60 * 60 instead of 36e5 to avoid floating point rounding errors https://github.com/moment/moment/issues/2978
        // Because of dateAddRemove treats 24 hours as different from a
        // day when working around DST, we need to store them separately
        this._days = +days + weeks * 7;
        // It is impossible to translate months into days without knowing
        // which months you are are talking about, so we have to store
        // it separately.
        this._months = +months + quarters * 3 + years * 12;

        this._data = {};

        this._locale = getLocale();

        this._bubble();
    }

    function isDuration(obj) {
        return obj instanceof Duration;
    }

    function absRound(number) {
        if (number < 0) {
            return Math.round(-1 * number) * -1;
        } else {
            return Math.round(number);
        }
    }

    // compare two arrays, return the number of differences
    function compareArrays(array1, array2, dontConvert) {
        var len = Math.min(array1.length, array2.length),
            lengthDiff = Math.abs(array1.length - array2.length),
            diffs = 0,
            i;
        for (i = 0; i < len; i++) {
            if (
                (dontConvert && array1[i] !== array2[i]) ||
                (!dontConvert && toInt(array1[i]) !== toInt(array2[i]))
            ) {
                diffs++;
            }
        }
        return diffs + lengthDiff;
    }

    // FORMATTING

    function offset(token, separator) {
        addFormatToken(token, 0, 0, function () {
            var offset = this.utcOffset(),
                sign = "+";
            if (offset < 0) {
                offset = -offset;
                sign = "-";
            }
            return (
                sign +
                zeroFill(~~(offset / 60), 2) +
                separator +
                zeroFill(~~offset % 60, 2)
            );
        });
    }

    offset("Z", ":");
    offset("ZZ", "");

    // PARSING

    addRegexToken("Z", matchShortOffset);
    addRegexToken("ZZ", matchShortOffset);
    addParseToken(["Z", "ZZ"], function (input, array, config) {
        config._useUTC = true;
        config._tzm = offsetFromString(matchShortOffset, input);
    });

    // HELPERS

    // timezone chunker
    // '+10:00' > ['10',  '00']
    // '-1530'  > ['-15', '30']
    var chunkOffset = /([\+\-]|\d\d)/gi;

    function offsetFromString(matcher, string) {
        var matches = (string || "").match(matcher),
            chunk,
            parts,
            minutes;

        if (matches === null) {
            return null;
        }

        chunk = matches[matches.length - 1] || [];
        parts = (chunk + "").match(chunkOffset) || ["-", 0, 0];
        minutes = +(parts[1] * 60) + toInt(parts[2]);

        return minutes === 0 ? 0 : parts[0] === "+" ? minutes : -minutes;
    }

    // Return a moment from input, that is local/utc/zone equivalent to model.
    function cloneWithOffset(input, model) {
        var res, diff;
        if (model._isUTC) {
            res = model.clone();
            diff =
                (isMoment(input) || isDate(input)
                    ? input.valueOf()
                    : createLocal(input).valueOf()) - res.valueOf();
            // Use low-level api, because this fn is low-level api.
            res._d.setTime(res._d.valueOf() + diff);
            hooks.updateOffset(res, false);
            return res;
        } else {
            return createLocal(input).local();
        }
    }

    function getDateOffset(m) {
        // On Firefox.24 Date#getTimezoneOffset returns a floating point.
        // https://github.com/moment/moment/pull/1871
        return -Math.round(m._d.getTimezoneOffset());
    }

    // HOOKS

    // This function will be called whenever a moment is mutated.
    // It is intended to keep the offset in sync with the timezone.
    hooks.updateOffset = function () {};

    // MOMENTS

    // keepLocalTime = true means only change the timezone, without
    // affecting the local hour. So 5:31:26 +0300 --[utcOffset(2, true)]-->
    // 5:31:26 +0200 It is possible that 5:31:26 doesn't exist with offset
    // +0200, so we adjust the time as needed, to be valid.
    //
    // Keeping the time actually adds/subtracts (one hour)
    // from the actual represented time. That is why we call updateOffset
    // a second time. In case it wants us to change the offset again
    // _changeInProgress == true case, then we have to adjust, because
    // there is no such time in the given timezone.
    function getSetOffset(input, keepLocalTime, keepMinutes) {
        var offset = this._offset || 0,
            localAdjust;
        if (!this.isValid()) {
            return input != null ? this : NaN;
        }
        if (input != null) {
            if (typeof input === "string") {
                input = offsetFromString(matchShortOffset, input);
                if (input === null) {
                    return this;
                }
            } else if (Math.abs(input) < 16 && !keepMinutes) {
                input = input * 60;
            }
            if (!this._isUTC && keepLocalTime) {
                localAdjust = getDateOffset(this);
            }
            this._offset = input;
            this._isUTC = true;
            if (localAdjust != null) {
                this.add(localAdjust, "m");
            }
            if (offset !== input) {
                if (!keepLocalTime || this._changeInProgress) {
                    addSubtract(
                        this,
                        createDuration(input - offset, "m"),
                        1,
                        false
                    );
                } else if (!this._changeInProgress) {
                    this._changeInProgress = true;
                    hooks.updateOffset(this, true);
                    this._changeInProgress = null;
                }
            }
            return this;
        } else {
            return this._isUTC ? offset : getDateOffset(this);
        }
    }

    function getSetZone(input, keepLocalTime) {
        if (input != null) {
            if (typeof input !== "string") {
                input = -input;
            }

            this.utcOffset(input, keepLocalTime);

            return this;
        } else {
            return -this.utcOffset();
        }
    }

    function setOffsetToUTC(keepLocalTime) {
        return this.utcOffset(0, keepLocalTime);
    }

    function setOffsetToLocal(keepLocalTime) {
        if (this._isUTC) {
            this.utcOffset(0, keepLocalTime);
            this._isUTC = false;

            if (keepLocalTime) {
                this.subtract(getDateOffset(this), "m");
            }
        }
        return this;
    }

    function setOffsetToParsedOffset() {
        if (this._tzm != null) {
            this.utcOffset(this._tzm, false, true);
        } else if (typeof this._i === "string") {
            var tZone = offsetFromString(matchOffset, this._i);
            if (tZone != null) {
                this.utcOffset(tZone);
            } else {
                this.utcOffset(0, true);
            }
        }
        return this;
    }

    function hasAlignedHourOffset(input) {
        if (!this.isValid()) {
            return false;
        }
        input = input ? createLocal(input).utcOffset() : 0;

        return (this.utcOffset() - input) % 60 === 0;
    }

    function isDaylightSavingTime() {
        return (
            this.utcOffset() > this.clone().month(0).utcOffset() ||
            this.utcOffset() > this.clone().month(5).utcOffset()
        );
    }

    function isDaylightSavingTimeShifted() {
        if (!isUndefined(this._isDSTShifted)) {
            return this._isDSTShifted;
        }

        var c = {},
            other;

        copyConfig(c, this);
        c = prepareConfig(c);

        if (c._a) {
            other = c._isUTC ? createUTC(c._a) : createLocal(c._a);
            this._isDSTShifted =
                this.isValid() && compareArrays(c._a, other.toArray()) > 0;
        } else {
            this._isDSTShifted = false;
        }

        return this._isDSTShifted;
    }

    function isLocal() {
        return this.isValid() ? !this._isUTC : false;
    }

    function isUtcOffset() {
        return this.isValid() ? this._isUTC : false;
    }

    function isUtc() {
        return this.isValid() ? this._isUTC && this._offset === 0 : false;
    }

    // ASP.NET json date format regex
    var aspNetRegex = /^(-|\+)?(?:(\d*)[. ])?(\d+):(\d+)(?::(\d+)(\.\d*)?)?$/,
        // from http://docs.closure-library.googlecode.com/git/closure_goog_date_date.js.source.html
        // somewhat more in line with 4.4.3.2 2004 spec, but allows decimal anywhere
        // and further modified to allow for strings containing both week and day
        isoRegex =
            /^(-|\+)?P(?:([-+]?[0-9,.]*)Y)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)W)?(?:([-+]?[0-9,.]*)D)?(?:T(?:([-+]?[0-9,.]*)H)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)S)?)?$/;

    function createDuration(input, key) {
        var duration = input,
            // matching against regexp is expensive, do it on demand
            match = null,
            sign,
            ret,
            diffRes;

        if (isDuration(input)) {
            duration = {
                ms: input._milliseconds,
                d: input._days,
                M: input._months,
            };
        } else if (isNumber(input) || !isNaN(+input)) {
            duration = {};
            if (key) {
                duration[key] = +input;
            } else {
                duration.milliseconds = +input;
            }
        } else if ((match = aspNetRegex.exec(input))) {
            sign = match[1] === "-" ? -1 : 1;
            duration = {
                y: 0,
                d: toInt(match[DATE]) * sign,
                h: toInt(match[HOUR]) * sign,
                m: toInt(match[MINUTE]) * sign,
                s: toInt(match[SECOND]) * sign,
                ms: toInt(absRound(match[MILLISECOND] * 1000)) * sign, // the millisecond decimal point is included in the match
            };
        } else if ((match = isoRegex.exec(input))) {
            sign = match[1] === "-" ? -1 : 1;
            duration = {
                y: parseIso(match[2], sign),
                M: parseIso(match[3], sign),
                w: parseIso(match[4], sign),
                d: parseIso(match[5], sign),
                h: parseIso(match[6], sign),
                m: parseIso(match[7], sign),
                s: parseIso(match[8], sign),
            };
        } else if (duration == null) {
            // checks for null or undefined
            duration = {};
        } else if (
            typeof duration === "object" &&
            ("from" in duration || "to" in duration)
        ) {
            diffRes = momentsDifference(
                createLocal(duration.from),
                createLocal(duration.to)
            );

            duration = {};
            duration.ms = diffRes.milliseconds;
            duration.M = diffRes.months;
        }

        ret = new Duration(duration);

        if (isDuration(input) && hasOwnProp(input, "_locale")) {
            ret._locale = input._locale;
        }

        if (isDuration(input) && hasOwnProp(input, "_isValid")) {
            ret._isValid = input._isValid;
        }

        return ret;
    }

    createDuration.fn = Duration.prototype;
    createDuration.invalid = createInvalid$1;

    function parseIso(inp, sign) {
        // We'd normally use ~~inp for this, but unfortunately it also
        // converts floats to ints.
        // inp may be undefined, so careful calling replace on it.
        var res = inp && parseFloat(inp.replace(",", "."));
        // apply sign while we're at it
        return (isNaN(res) ? 0 : res) * sign;
    }

    function positiveMomentsDifference(base, other) {
        var res = {};

        res.months =
            other.month() - base.month() + (other.year() - base.year()) * 12;
        if (base.clone().add(res.months, "M").isAfter(other)) {
            --res.months;
        }

        res.milliseconds = +other - +base.clone().add(res.months, "M");

        return res;
    }

    function momentsDifference(base, other) {
        var res;
        if (!(base.isValid() && other.isValid())) {
            return { milliseconds: 0, months: 0 };
        }

        other = cloneWithOffset(other, base);
        if (base.isBefore(other)) {
            res = positiveMomentsDifference(base, other);
        } else {
            res = positiveMomentsDifference(other, base);
            res.milliseconds = -res.milliseconds;
            res.months = -res.months;
        }

        return res;
    }

    // TODO: remove 'name' arg after deprecation is removed
    function createAdder(direction, name) {
        return function (val, period) {
            var dur, tmp;
            //invert the arguments, but complain about it
            if (period !== null && !isNaN(+period)) {
                deprecateSimple(
                    name,
                    "moment()." +
                        name +
                        "(period, number) is deprecated. Please use moment()." +
                        name +
                        "(number, period). " +
                        "See http://momentjs.com/guides/#/warnings/add-inverted-param/ for more info."
                );
                tmp = val;
                val = period;
                period = tmp;
            }

            dur = createDuration(val, period);
            addSubtract(this, dur, direction);
            return this;
        };
    }

    function addSubtract(mom, duration, isAdding, updateOffset) {
        var milliseconds = duration._milliseconds,
            days = absRound(duration._days),
            months = absRound(duration._months);

        if (!mom.isValid()) {
            // No op
            return;
        }

        updateOffset = updateOffset == null ? true : updateOffset;

        if (months) {
            setMonth(mom, get(mom, "Month") + months * isAdding);
        }
        if (days) {
            set$1(mom, "Date", get(mom, "Date") + days * isAdding);
        }
        if (milliseconds) {
            mom._d.setTime(mom._d.valueOf() + milliseconds * isAdding);
        }
        if (updateOffset) {
            hooks.updateOffset(mom, days || months);
        }
    }

    var add = createAdder(1, "add"),
        subtract = createAdder(-1, "subtract");

    function isString(input) {
        return typeof input === "string" || input instanceof String;
    }

    // type MomentInput = Moment | Date | string | number | (number | string)[] | MomentInputObject | void; // null | undefined
    function isMomentInput(input) {
        return (
            isMoment(input) ||
            isDate(input) ||
            isString(input) ||
            isNumber(input) ||
            isNumberOrStringArray(input) ||
            isMomentInputObject(input) ||
            input === null ||
            input === undefined
        );
    }

    function isMomentInputObject(input) {
        var objectTest = isObject(input) && !isObjectEmpty(input),
            propertyTest = false,
            properties = [
                "years",
                "year",
                "y",
                "months",
                "month",
                "M",
                "days",
                "day",
                "d",
                "dates",
                "date",
                "D",
                "hours",
                "hour",
                "h",
                "minutes",
                "minute",
                "m",
                "seconds",
                "second",
                "s",
                "milliseconds",
                "millisecond",
                "ms",
            ],
            i,
            property;

        for (i = 0; i < properties.length; i += 1) {
            property = properties[i];
            propertyTest = propertyTest || hasOwnProp(input, property);
        }

        return objectTest && propertyTest;
    }

    function isNumberOrStringArray(input) {
        var arrayTest = isArray(input),
            dataTypeTest = false;
        if (arrayTest) {
            dataTypeTest =
                input.filter(function (item) {
                    return !isNumber(item) && isString(input);
                }).length === 0;
        }
        return arrayTest && dataTypeTest;
    }

    function isCalendarSpec(input) {
        var objectTest = isObject(input) && !isObjectEmpty(input),
            propertyTest = false,
            properties = [
                "sameDay",
                "nextDay",
                "lastDay",
                "nextWeek",
                "lastWeek",
                "sameElse",
            ],
            i,
            property;

        for (i = 0; i < properties.length; i += 1) {
            property = properties[i];
            propertyTest = propertyTest || hasOwnProp(input, property);
        }

        return objectTest && propertyTest;
    }

    function getCalendarFormat(myMoment, now) {
        var diff = myMoment.diff(now, "days", true);
        return diff < -6
            ? "sameElse"
            : diff < -1
            ? "lastWeek"
            : diff < 0
            ? "lastDay"
            : diff < 1
            ? "sameDay"
            : diff < 2
            ? "nextDay"
            : diff < 7
            ? "nextWeek"
            : "sameElse";
    }

    function calendar$1(time, formats) {
        // Support for single parameter, formats only overload to the calendar function
        if (arguments.length === 1) {
            if (!arguments[0]) {
                time = undefined;
                formats = undefined;
            } else if (isMomentInput(arguments[0])) {
                time = arguments[0];
                formats = undefined;
            } else if (isCalendarSpec(arguments[0])) {
                formats = arguments[0];
                time = undefined;
            }
        }
        // We want to compare the start of today, vs this.
        // Getting start-of-today depends on whether we're local/utc/offset or not.
        var now = time || createLocal(),
            sod = cloneWithOffset(now, this).startOf("day"),
            format = hooks.calendarFormat(this, sod) || "sameElse",
            output =
                formats &&
                (isFunction(formats[format])
                    ? formats[format].call(this, now)
                    : formats[format]);

        return this.format(
            output || this.localeData().calendar(format, this, createLocal(now))
        );
    }

    function clone() {
        return new Moment(this);
    }

    function isAfter(input, units) {
        var localInput = isMoment(input) ? input : createLocal(input);
        if (!(this.isValid() && localInput.isValid())) {
            return false;
        }
        units = normalizeUnits(units) || "millisecond";
        if (units === "millisecond") {
            return this.valueOf() > localInput.valueOf();
        } else {
            return localInput.valueOf() < this.clone().startOf(units).valueOf();
        }
    }

    function isBefore(input, units) {
        var localInput = isMoment(input) ? input : createLocal(input);
        if (!(this.isValid() && localInput.isValid())) {
            return false;
        }
        units = normalizeUnits(units) || "millisecond";
        if (units === "millisecond") {
            return this.valueOf() < localInput.valueOf();
        } else {
            return this.clone().endOf(units).valueOf() < localInput.valueOf();
        }
    }

    function isBetween(from, to, units, inclusivity) {
        var localFrom = isMoment(from) ? from : createLocal(from),
            localTo = isMoment(to) ? to : createLocal(to);
        if (!(this.isValid() && localFrom.isValid() && localTo.isValid())) {
            return false;
        }
        inclusivity = inclusivity || "()";
        return (
            (inclusivity[0] === "("
                ? this.isAfter(localFrom, units)
                : !this.isBefore(localFrom, units)) &&
            (inclusivity[1] === ")"
                ? this.isBefore(localTo, units)
                : !this.isAfter(localTo, units))
        );
    }

    function isSame(input, units) {
        var localInput = isMoment(input) ? input : createLocal(input),
            inputMs;
        if (!(this.isValid() && localInput.isValid())) {
            return false;
        }
        units = normalizeUnits(units) || "millisecond";
        if (units === "millisecond") {
            return this.valueOf() === localInput.valueOf();
        } else {
            inputMs = localInput.valueOf();
            return (
                this.clone().startOf(units).valueOf() <= inputMs &&
                inputMs <= this.clone().endOf(units).valueOf()
            );
        }
    }

    function isSameOrAfter(input, units) {
        return this.isSame(input, units) || this.isAfter(input, units);
    }

    function isSameOrBefore(input, units) {
        return this.isSame(input, units) || this.isBefore(input, units);
    }

    function diff(input, units, asFloat) {
        var that, zoneDelta, output;

        if (!this.isValid()) {
            return NaN;
        }

        that = cloneWithOffset(input, this);

        if (!that.isValid()) {
            return NaN;
        }

        zoneDelta = (that.utcOffset() - this.utcOffset()) * 6e4;

        units = normalizeUnits(units);

        switch (units) {
            case "year":
                output = monthDiff(this, that) / 12;
                break;
            case "month":
                output = monthDiff(this, that);
                break;
            case "quarter":
                output = monthDiff(this, that) / 3;
                break;
            case "second":
                output = (this - that) / 1e3;
                break; // 1000
            case "minute":
                output = (this - that) / 6e4;
                break; // 1000 * 60
            case "hour":
                output = (this - that) / 36e5;
                break; // 1000 * 60 * 60
            case "day":
                output = (this - that - zoneDelta) / 864e5;
                break; // 1000 * 60 * 60 * 24, negate dst
            case "week":
                output = (this - that - zoneDelta) / 6048e5;
                break; // 1000 * 60 * 60 * 24 * 7, negate dst
            default:
                output = this - that;
        }

        return asFloat ? output : absFloor(output);
    }

    function monthDiff(a, b) {
        if (a.date() < b.date()) {
            // end-of-month calculations work correct when the start month has more
            // days than the end month.
            return -monthDiff(b, a);
        }
        // difference in months
        var wholeMonthDiff =
                (b.year() - a.year()) * 12 + (b.month() - a.month()),
            // b is in (anchor - 1 month, anchor + 1 month)
            anchor = a.clone().add(wholeMonthDiff, "months"),
            anchor2,
            adjust;

        if (b - anchor < 0) {
            anchor2 = a.clone().add(wholeMonthDiff - 1, "months");
            // linear across the month
            adjust = (b - anchor) / (anchor - anchor2);
        } else {
            anchor2 = a.clone().add(wholeMonthDiff + 1, "months");
            // linear across the month
            adjust = (b - anchor) / (anchor2 - anchor);
        }

        //check for negative zero, return zero if negative zero
        return -(wholeMonthDiff + adjust) || 0;
    }

    hooks.defaultFormat = "YYYY-MM-DDTHH:mm:ssZ";
    hooks.defaultFormatUtc = "YYYY-MM-DDTHH:mm:ss[Z]";

    function toString() {
        return this.clone()
            .locale("en")
            .format("ddd MMM DD YYYY HH:mm:ss [GMT]ZZ");
    }

    function toISOString(keepOffset) {
        if (!this.isValid()) {
            return null;
        }
        var utc = keepOffset !== true,
            m = utc ? this.clone().utc() : this;
        if (m.year() < 0 || m.year() > 9999) {
            return formatMoment(
                m,
                utc
                    ? "YYYYYY-MM-DD[T]HH:mm:ss.SSS[Z]"
                    : "YYYYYY-MM-DD[T]HH:mm:ss.SSSZ"
            );
        }
        if (isFunction(Date.prototype.toISOString)) {
            // native implementation is ~50x faster, use it when we can
            if (utc) {
                return this.toDate().toISOString();
            } else {
                return new Date(this.valueOf() + this.utcOffset() * 60 * 1000)
                    .toISOString()
                    .replace("Z", formatMoment(m, "Z"));
            }
        }
        return formatMoment(
            m,
            utc ? "YYYY-MM-DD[T]HH:mm:ss.SSS[Z]" : "YYYY-MM-DD[T]HH:mm:ss.SSSZ"
        );
    }

    /**
     * Return a human readable representation of a moment that can
     * also be evaluated to get a new moment which is the same
     *
     * @link https://nodejs.org/dist/latest/docs/api/util.html#util_custom_inspect_function_on_objects
     */
    function inspect() {
        if (!this.isValid()) {
            return "moment.invalid(/* " + this._i + " */)";
        }
        var func = "moment",
            zone = "",
            prefix,
            year,
            datetime,
            suffix;
        if (!this.isLocal()) {
            func = this.utcOffset() === 0 ? "moment.utc" : "moment.parseZone";
            zone = "Z";
        }
        prefix = "[" + func + '("]';
        year = 0 <= this.year() && this.year() <= 9999 ? "YYYY" : "YYYYYY";
        datetime = "-MM-DD[T]HH:mm:ss.SSS";
        suffix = zone + '[")]';

        return this.format(prefix + year + datetime + suffix);
    }

    function format(inputString) {
        if (!inputString) {
            inputString = this.isUtc()
                ? hooks.defaultFormatUtc
                : hooks.defaultFormat;
        }
        var output = formatMoment(this, inputString);
        return this.localeData().postformat(output);
    }

    function from(time, withoutSuffix) {
        if (
            this.isValid() &&
            ((isMoment(time) && time.isValid()) || createLocal(time).isValid())
        ) {
            return createDuration({ to: this, from: time })
                .locale(this.locale())
                .humanize(!withoutSuffix);
        } else {
            return this.localeData().invalidDate();
        }
    }

    function fromNow(withoutSuffix) {
        return this.from(createLocal(), withoutSuffix);
    }

    function to(time, withoutSuffix) {
        if (
            this.isValid() &&
            ((isMoment(time) && time.isValid()) || createLocal(time).isValid())
        ) {
            return createDuration({ from: this, to: time })
                .locale(this.locale())
                .humanize(!withoutSuffix);
        } else {
            return this.localeData().invalidDate();
        }
    }

    function toNow(withoutSuffix) {
        return this.to(createLocal(), withoutSuffix);
    }

    // If passed a locale key, it will set the locale for this
    // instance.  Otherwise, it will return the locale configuration
    // variables for this instance.
    function locale(key) {
        var newLocaleData;

        if (key === undefined) {
            return this._locale._abbr;
        } else {
            newLocaleData = getLocale(key);
            if (newLocaleData != null) {
                this._locale = newLocaleData;
            }
            return this;
        }
    }

    var lang = deprecate(
        "moment().lang() is deprecated. Instead, use moment().localeData() to get the language configuration. Use moment().locale() to change languages.",
        function (key) {
            if (key === undefined) {
                return this.localeData();
            } else {
                return this.locale(key);
            }
        }
    );

    function localeData() {
        return this._locale;
    }

    var MS_PER_SECOND = 1000,
        MS_PER_MINUTE = 60 * MS_PER_SECOND,
        MS_PER_HOUR = 60 * MS_PER_MINUTE,
        MS_PER_400_YEARS = (365 * 400 + 97) * 24 * MS_PER_HOUR;

    // actual modulo - handles negative numbers (for dates before 1970):
    function mod$1(dividend, divisor) {
        return ((dividend % divisor) + divisor) % divisor;
    }

    function localStartOfDate(y, m, d) {
        // the date constructor remaps years 0-99 to 1900-1999
        if (y < 100 && y >= 0) {
            // preserve leap years using a full 400 year cycle, then reset
            return new Date(y + 400, m, d) - MS_PER_400_YEARS;
        } else {
            return new Date(y, m, d).valueOf();
        }
    }

    function utcStartOfDate(y, m, d) {
        // Date.UTC remaps years 0-99 to 1900-1999
        if (y < 100 && y >= 0) {
            // preserve leap years using a full 400 year cycle, then reset
            return Date.UTC(y + 400, m, d) - MS_PER_400_YEARS;
        } else {
            return Date.UTC(y, m, d);
        }
    }

    function startOf(units) {
        var time, startOfDate;
        units = normalizeUnits(units);
        if (units === undefined || units === "millisecond" || !this.isValid()) {
            return this;
        }

        startOfDate = this._isUTC ? utcStartOfDate : localStartOfDate;

        switch (units) {
            case "year":
                time = startOfDate(this.year(), 0, 1);
                break;
            case "quarter":
                time = startOfDate(
                    this.year(),
                    this.month() - (this.month() % 3),
                    1
                );
                break;
            case "month":
                time = startOfDate(this.year(), this.month(), 1);
                break;
            case "week":
                time = startOfDate(
                    this.year(),
                    this.month(),
                    this.date() - this.weekday()
                );
                break;
            case "isoWeek":
                time = startOfDate(
                    this.year(),
                    this.month(),
                    this.date() - (this.isoWeekday() - 1)
                );
                break;
            case "day":
            case "date":
                time = startOfDate(this.year(), this.month(), this.date());
                break;
            case "hour":
                time = this._d.valueOf();
                time -= mod$1(
                    time + (this._isUTC ? 0 : this.utcOffset() * MS_PER_MINUTE),
                    MS_PER_HOUR
                );
                break;
            case "minute":
                time = this._d.valueOf();
                time -= mod$1(time, MS_PER_MINUTE);
                break;
            case "second":
                time = this._d.valueOf();
                time -= mod$1(time, MS_PER_SECOND);
                break;
        }

        this._d.setTime(time);
        hooks.updateOffset(this, true);
        return this;
    }

    function endOf(units) {
        var time, startOfDate;
        units = normalizeUnits(units);
        if (units === undefined || units === "millisecond" || !this.isValid()) {
            return this;
        }

        startOfDate = this._isUTC ? utcStartOfDate : localStartOfDate;

        switch (units) {
            case "year":
                time = startOfDate(this.year() + 1, 0, 1) - 1;
                break;
            case "quarter":
                time =
                    startOfDate(
                        this.year(),
                        this.month() - (this.month() % 3) + 3,
                        1
                    ) - 1;
                break;
            case "month":
                time = startOfDate(this.year(), this.month() + 1, 1) - 1;
                break;
            case "week":
                time =
                    startOfDate(
                        this.year(),
                        this.month(),
                        this.date() - this.weekday() + 7
                    ) - 1;
                break;
            case "isoWeek":
                time =
                    startOfDate(
                        this.year(),
                        this.month(),
                        this.date() - (this.isoWeekday() - 1) + 7
                    ) - 1;
                break;
            case "day":
            case "date":
                time =
                    startOfDate(this.year(), this.month(), this.date() + 1) - 1;
                break;
            case "hour":
                time = this._d.valueOf();
                time +=
                    MS_PER_HOUR -
                    mod$1(
                        time +
                            (this._isUTC
                                ? 0
                                : this.utcOffset() * MS_PER_MINUTE),
                        MS_PER_HOUR
                    ) -
                    1;
                break;
            case "minute":
                time = this._d.valueOf();
                time += MS_PER_MINUTE - mod$1(time, MS_PER_MINUTE) - 1;
                break;
            case "second":
                time = this._d.valueOf();
                time += MS_PER_SECOND - mod$1(time, MS_PER_SECOND) - 1;
                break;
        }

        this._d.setTime(time);
        hooks.updateOffset(this, true);
        return this;
    }

    function valueOf() {
        return this._d.valueOf() - (this._offset || 0) * 60000;
    }

    function unix() {
        return Math.floor(this.valueOf() / 1000);
    }

    function toDate() {
        return new Date(this.valueOf());
    }

    function toArray() {
        var m = this;
        return [
            m.year(),
            m.month(),
            m.date(),
            m.hour(),
            m.minute(),
            m.second(),
            m.millisecond(),
        ];
    }

    function toObject() {
        var m = this;
        return {
            years: m.year(),
            months: m.month(),
            date: m.date(),
            hours: m.hours(),
            minutes: m.minutes(),
            seconds: m.seconds(),
            milliseconds: m.milliseconds(),
        };
    }

    function toJSON() {
        // new Date(NaN).toJSON() === null
        return this.isValid() ? this.toISOString() : null;
    }

    function isValid$2() {
        return isValid(this);
    }

    function parsingFlags() {
        return extend({}, getParsingFlags(this));
    }

    function invalidAt() {
        return getParsingFlags(this).overflow;
    }

    function creationData() {
        return {
            input: this._i,
            format: this._f,
            locale: this._locale,
            isUTC: this._isUTC,
            strict: this._strict,
        };
    }

    addFormatToken("N", 0, 0, "eraAbbr");
    addFormatToken("NN", 0, 0, "eraAbbr");
    addFormatToken("NNN", 0, 0, "eraAbbr");
    addFormatToken("NNNN", 0, 0, "eraName");
    addFormatToken("NNNNN", 0, 0, "eraNarrow");

    addFormatToken("y", ["y", 1], "yo", "eraYear");
    addFormatToken("y", ["yy", 2], 0, "eraYear");
    addFormatToken("y", ["yyy", 3], 0, "eraYear");
    addFormatToken("y", ["yyyy", 4], 0, "eraYear");

    addRegexToken("N", matchEraAbbr);
    addRegexToken("NN", matchEraAbbr);
    addRegexToken("NNN", matchEraAbbr);
    addRegexToken("NNNN", matchEraName);
    addRegexToken("NNNNN", matchEraNarrow);

    addParseToken(
        ["N", "NN", "NNN", "NNNN", "NNNNN"],
        function (input, array, config, token) {
            var era = config._locale.erasParse(input, token, config._strict);
            if (era) {
                getParsingFlags(config).era = era;
            } else {
                getParsingFlags(config).invalidEra = input;
            }
        }
    );

    addRegexToken("y", matchUnsigned);
    addRegexToken("yy", matchUnsigned);
    addRegexToken("yyy", matchUnsigned);
    addRegexToken("yyyy", matchUnsigned);
    addRegexToken("yo", matchEraYearOrdinal);

    addParseToken(["y", "yy", "yyy", "yyyy"], YEAR);
    addParseToken(["yo"], function (input, array, config, token) {
        var match;
        if (config._locale._eraYearOrdinalRegex) {
            match = input.match(config._locale._eraYearOrdinalRegex);
        }

        if (config._locale.eraYearOrdinalParse) {
            array[YEAR] = config._locale.eraYearOrdinalParse(input, match);
        } else {
            array[YEAR] = parseInt(input, 10);
        }
    });

    function localeEras(m, format) {
        var i,
            l,
            date,
            eras = this._eras || getLocale("en")._eras;
        for (i = 0, l = eras.length; i < l; ++i) {
            switch (typeof eras[i].since) {
                case "string":
                    // truncate time
                    date = hooks(eras[i].since).startOf("day");
                    eras[i].since = date.valueOf();
                    break;
            }

            switch (typeof eras[i].until) {
                case "undefined":
                    eras[i].until = +Infinity;
                    break;
                case "string":
                    // truncate time
                    date = hooks(eras[i].until).startOf("day").valueOf();
                    eras[i].until = date.valueOf();
                    break;
            }
        }
        return eras;
    }

    function localeErasParse(eraName, format, strict) {
        var i,
            l,
            eras = this.eras(),
            name,
            abbr,
            narrow;
        eraName = eraName.toUpperCase();

        for (i = 0, l = eras.length; i < l; ++i) {
            name = eras[i].name.toUpperCase();
            abbr = eras[i].abbr.toUpperCase();
            narrow = eras[i].narrow.toUpperCase();

            if (strict) {
                switch (format) {
                    case "N":
                    case "NN":
                    case "NNN":
                        if (abbr === eraName) {
                            return eras[i];
                        }
                        break;

                    case "NNNN":
                        if (name === eraName) {
                            return eras[i];
                        }
                        break;

                    case "NNNNN":
                        if (narrow === eraName) {
                            return eras[i];
                        }
                        break;
                }
            } else if ([name, abbr, narrow].indexOf(eraName) >= 0) {
                return eras[i];
            }
        }
    }

    function localeErasConvertYear(era, year) {
        var dir = era.since <= era.until ? +1 : -1;
        if (year === undefined) {
            return hooks(era.since).year();
        } else {
            return hooks(era.since).year() + (year - era.offset) * dir;
        }
    }

    function getEraName() {
        var i,
            l,
            val,
            eras = this.localeData().eras();
        for (i = 0, l = eras.length; i < l; ++i) {
            // truncate time
            val = this.clone().startOf("day").valueOf();

            if (eras[i].since <= val && val <= eras[i].until) {
                return eras[i].name;
            }
            if (eras[i].until <= val && val <= eras[i].since) {
                return eras[i].name;
            }
        }

        return "";
    }

    function getEraNarrow() {
        var i,
            l,
            val,
            eras = this.localeData().eras();
        for (i = 0, l = eras.length; i < l; ++i) {
            // truncate time
            val = this.clone().startOf("day").valueOf();

            if (eras[i].since <= val && val <= eras[i].until) {
                return eras[i].narrow;
            }
            if (eras[i].until <= val && val <= eras[i].since) {
                return eras[i].narrow;
            }
        }

        return "";
    }

    function getEraAbbr() {
        var i,
            l,
            val,
            eras = this.localeData().eras();
        for (i = 0, l = eras.length; i < l; ++i) {
            // truncate time
            val = this.clone().startOf("day").valueOf();

            if (eras[i].since <= val && val <= eras[i].until) {
                return eras[i].abbr;
            }
            if (eras[i].until <= val && val <= eras[i].since) {
                return eras[i].abbr;
            }
        }

        return "";
    }

    function getEraYear() {
        var i,
            l,
            dir,
            val,
            eras = this.localeData().eras();
        for (i = 0, l = eras.length; i < l; ++i) {
            dir = eras[i].since <= eras[i].until ? +1 : -1;

            // truncate time
            val = this.clone().startOf("day").valueOf();

            if (
                (eras[i].since <= val && val <= eras[i].until) ||
                (eras[i].until <= val && val <= eras[i].since)
            ) {
                return (
                    (this.year() - hooks(eras[i].since).year()) * dir +
                    eras[i].offset
                );
            }
        }

        return this.year();
    }

    function erasNameRegex(isStrict) {
        if (!hasOwnProp(this, "_erasNameRegex")) {
            computeErasParse.call(this);
        }
        return isStrict ? this._erasNameRegex : this._erasRegex;
    }

    function erasAbbrRegex(isStrict) {
        if (!hasOwnProp(this, "_erasAbbrRegex")) {
            computeErasParse.call(this);
        }
        return isStrict ? this._erasAbbrRegex : this._erasRegex;
    }

    function erasNarrowRegex(isStrict) {
        if (!hasOwnProp(this, "_erasNarrowRegex")) {
            computeErasParse.call(this);
        }
        return isStrict ? this._erasNarrowRegex : this._erasRegex;
    }

    function matchEraAbbr(isStrict, locale) {
        return locale.erasAbbrRegex(isStrict);
    }

    function matchEraName(isStrict, locale) {
        return locale.erasNameRegex(isStrict);
    }

    function matchEraNarrow(isStrict, locale) {
        return locale.erasNarrowRegex(isStrict);
    }

    function matchEraYearOrdinal(isStrict, locale) {
        return locale._eraYearOrdinalRegex || matchUnsigned;
    }

    function computeErasParse() {
        var abbrPieces = [],
            namePieces = [],
            narrowPieces = [],
            mixedPieces = [],
            i,
            l,
            eras = this.eras();

        for (i = 0, l = eras.length; i < l; ++i) {
            namePieces.push(regexEscape(eras[i].name));
            abbrPieces.push(regexEscape(eras[i].abbr));
            narrowPieces.push(regexEscape(eras[i].narrow));

            mixedPieces.push(regexEscape(eras[i].name));
            mixedPieces.push(regexEscape(eras[i].abbr));
            mixedPieces.push(regexEscape(eras[i].narrow));
        }

        this._erasRegex = new RegExp("^(" + mixedPieces.join("|") + ")", "i");
        this._erasNameRegex = new RegExp(
            "^(" + namePieces.join("|") + ")",
            "i"
        );
        this._erasAbbrRegex = new RegExp(
            "^(" + abbrPieces.join("|") + ")",
            "i"
        );
        this._erasNarrowRegex = new RegExp(
            "^(" + narrowPieces.join("|") + ")",
            "i"
        );
    }

    // FORMATTING

    addFormatToken(0, ["gg", 2], 0, function () {
        return this.weekYear() % 100;
    });

    addFormatToken(0, ["GG", 2], 0, function () {
        return this.isoWeekYear() % 100;
    });

    function addWeekYearFormatToken(token, getter) {
        addFormatToken(0, [token, token.length], 0, getter);
    }

    addWeekYearFormatToken("gggg", "weekYear");
    addWeekYearFormatToken("ggggg", "weekYear");
    addWeekYearFormatToken("GGGG", "isoWeekYear");
    addWeekYearFormatToken("GGGGG", "isoWeekYear");

    // ALIASES

    addUnitAlias("weekYear", "gg");
    addUnitAlias("isoWeekYear", "GG");

    // PRIORITY

    addUnitPriority("weekYear", 1);
    addUnitPriority("isoWeekYear", 1);

    // PARSING

    addRegexToken("G", matchSigned);
    addRegexToken("g", matchSigned);
    addRegexToken("GG", match1to2, match2);
    addRegexToken("gg", match1to2, match2);
    addRegexToken("GGGG", match1to4, match4);
    addRegexToken("gggg", match1to4, match4);
    addRegexToken("GGGGG", match1to6, match6);
    addRegexToken("ggggg", match1to6, match6);

    addWeekParseToken(
        ["gggg", "ggggg", "GGGG", "GGGGG"],
        function (input, week, config, token) {
            week[token.substr(0, 2)] = toInt(input);
        }
    );

    addWeekParseToken(["gg", "GG"], function (input, week, config, token) {
        week[token] = hooks.parseTwoDigitYear(input);
    });

    // MOMENTS

    function getSetWeekYear(input) {
        return getSetWeekYearHelper.call(
            this,
            input,
            this.week(),
            this.weekday(),
            this.localeData()._week.dow,
            this.localeData()._week.doy
        );
    }

    function getSetISOWeekYear(input) {
        return getSetWeekYearHelper.call(
            this,
            input,
            this.isoWeek(),
            this.isoWeekday(),
            1,
            4
        );
    }

    function getISOWeeksInYear() {
        return weeksInYear(this.year(), 1, 4);
    }

    function getISOWeeksInISOWeekYear() {
        return weeksInYear(this.isoWeekYear(), 1, 4);
    }

    function getWeeksInYear() {
        var weekInfo = this.localeData()._week;
        return weeksInYear(this.year(), weekInfo.dow, weekInfo.doy);
    }

    function getWeeksInWeekYear() {
        var weekInfo = this.localeData()._week;
        return weeksInYear(this.weekYear(), weekInfo.dow, weekInfo.doy);
    }

    function getSetWeekYearHelper(input, week, weekday, dow, doy) {
        var weeksTarget;
        if (input == null) {
            return weekOfYear(this, dow, doy).year;
        } else {
            weeksTarget = weeksInYear(input, dow, doy);
            if (week > weeksTarget) {
                week = weeksTarget;
            }
            return setWeekAll.call(this, input, week, weekday, dow, doy);
        }
    }

    function setWeekAll(weekYear, week, weekday, dow, doy) {
        var dayOfYearData = dayOfYearFromWeeks(
                weekYear,
                week,
                weekday,
                dow,
                doy
            ),
            date = createUTCDate(
                dayOfYearData.year,
                0,
                dayOfYearData.dayOfYear
            );

        this.year(date.getUTCFullYear());
        this.month(date.getUTCMonth());
        this.date(date.getUTCDate());
        return this;
    }

    // FORMATTING

    addFormatToken("Q", 0, "Qo", "quarter");

    // ALIASES

    addUnitAlias("quarter", "Q");

    // PRIORITY

    addUnitPriority("quarter", 7);

    // PARSING

    addRegexToken("Q", match1);
    addParseToken("Q", function (input, array) {
        array[MONTH] = (toInt(input) - 1) * 3;
    });

    // MOMENTS

    function getSetQuarter(input) {
        return input == null
            ? Math.ceil((this.month() + 1) / 3)
            : this.month((input - 1) * 3 + (this.month() % 3));
    }

    // FORMATTING

    addFormatToken("D", ["DD", 2], "Do", "date");

    // ALIASES

    addUnitAlias("date", "D");

    // PRIORITY
    addUnitPriority("date", 9);

    // PARSING

    addRegexToken("D", match1to2);
    addRegexToken("DD", match1to2, match2);
    addRegexToken("Do", function (isStrict, locale) {
        // TODO: Remove "ordinalParse" fallback in next major release.
        return isStrict
            ? locale._dayOfMonthOrdinalParse || locale._ordinalParse
            : locale._dayOfMonthOrdinalParseLenient;
    });

    addParseToken(["D", "DD"], DATE);
    addParseToken("Do", function (input, array) {
        array[DATE] = toInt(input.match(match1to2)[0]);
    });

    // MOMENTS

    var getSetDayOfMonth = makeGetSet("Date", true);

    // FORMATTING

    addFormatToken("DDD", ["DDDD", 3], "DDDo", "dayOfYear");

    // ALIASES

    addUnitAlias("dayOfYear", "DDD");

    // PRIORITY
    addUnitPriority("dayOfYear", 4);

    // PARSING

    addRegexToken("DDD", match1to3);
    addRegexToken("DDDD", match3);
    addParseToken(["DDD", "DDDD"], function (input, array, config) {
        config._dayOfYear = toInt(input);
    });

    // HELPERS

    // MOMENTS

    function getSetDayOfYear(input) {
        var dayOfYear =
            Math.round(
                (this.clone().startOf("day") - this.clone().startOf("year")) /
                    864e5
            ) + 1;
        return input == null ? dayOfYear : this.add(input - dayOfYear, "d");
    }

    // FORMATTING

    addFormatToken("m", ["mm", 2], 0, "minute");

    // ALIASES

    addUnitAlias("minute", "m");

    // PRIORITY

    addUnitPriority("minute", 14);

    // PARSING

    addRegexToken("m", match1to2);
    addRegexToken("mm", match1to2, match2);
    addParseToken(["m", "mm"], MINUTE);

    // MOMENTS

    var getSetMinute = makeGetSet("Minutes", false);

    // FORMATTING

    addFormatToken("s", ["ss", 2], 0, "second");

    // ALIASES

    addUnitAlias("second", "s");

    // PRIORITY

    addUnitPriority("second", 15);

    // PARSING

    addRegexToken("s", match1to2);
    addRegexToken("ss", match1to2, match2);
    addParseToken(["s", "ss"], SECOND);

    // MOMENTS

    var getSetSecond = makeGetSet("Seconds", false);

    // FORMATTING

    addFormatToken("S", 0, 0, function () {
        return ~~(this.millisecond() / 100);
    });

    addFormatToken(0, ["SS", 2], 0, function () {
        return ~~(this.millisecond() / 10);
    });

    addFormatToken(0, ["SSS", 3], 0, "millisecond");
    addFormatToken(0, ["SSSS", 4], 0, function () {
        return this.millisecond() * 10;
    });
    addFormatToken(0, ["SSSSS", 5], 0, function () {
        return this.millisecond() * 100;
    });
    addFormatToken(0, ["SSSSSS", 6], 0, function () {
        return this.millisecond() * 1000;
    });
    addFormatToken(0, ["SSSSSSS", 7], 0, function () {
        return this.millisecond() * 10000;
    });
    addFormatToken(0, ["SSSSSSSS", 8], 0, function () {
        return this.millisecond() * 100000;
    });
    addFormatToken(0, ["SSSSSSSSS", 9], 0, function () {
        return this.millisecond() * 1000000;
    });

    // ALIASES

    addUnitAlias("millisecond", "ms");

    // PRIORITY

    addUnitPriority("millisecond", 16);

    // PARSING

    addRegexToken("S", match1to3, match1);
    addRegexToken("SS", match1to3, match2);
    addRegexToken("SSS", match1to3, match3);

    var token, getSetMillisecond;
    for (token = "SSSS"; token.length <= 9; token += "S") {
        addRegexToken(token, matchUnsigned);
    }

    function parseMs(input, array) {
        array[MILLISECOND] = toInt(("0." + input) * 1000);
    }

    for (token = "S"; token.length <= 9; token += "S") {
        addParseToken(token, parseMs);
    }

    getSetMillisecond = makeGetSet("Milliseconds", false);

    // FORMATTING

    addFormatToken("z", 0, 0, "zoneAbbr");
    addFormatToken("zz", 0, 0, "zoneName");

    // MOMENTS

    function getZoneAbbr() {
        return this._isUTC ? "UTC" : "";
    }

    function getZoneName() {
        return this._isUTC ? "Coordinated Universal Time" : "";
    }

    var proto = Moment.prototype;

    proto.add = add;
    proto.calendar = calendar$1;
    proto.clone = clone;
    proto.diff = diff;
    proto.endOf = endOf;
    proto.format = format;
    proto.from = from;
    proto.fromNow = fromNow;
    proto.to = to;
    proto.toNow = toNow;
    proto.get = stringGet;
    proto.invalidAt = invalidAt;
    proto.isAfter = isAfter;
    proto.isBefore = isBefore;
    proto.isBetween = isBetween;
    proto.isSame = isSame;
    proto.isSameOrAfter = isSameOrAfter;
    proto.isSameOrBefore = isSameOrBefore;
    proto.isValid = isValid$2;
    proto.lang = lang;
    proto.locale = locale;
    proto.localeData = localeData;
    proto.max = prototypeMax;
    proto.min = prototypeMin;
    proto.parsingFlags = parsingFlags;
    proto.set = stringSet;
    proto.startOf = startOf;
    proto.subtract = subtract;
    proto.toArray = toArray;
    proto.toObject = toObject;
    proto.toDate = toDate;
    proto.toISOString = toISOString;
    proto.inspect = inspect;
    if (typeof Symbol !== "undefined" && Symbol.for != null) {
        proto[Symbol.for("nodejs.util.inspect.custom")] = function () {
            return "Moment<" + this.format() + ">";
        };
    }
    proto.toJSON = toJSON;
    proto.toString = toString;
    proto.unix = unix;
    proto.valueOf = valueOf;
    proto.creationData = creationData;
    proto.eraName = getEraName;
    proto.eraNarrow = getEraNarrow;
    proto.eraAbbr = getEraAbbr;
    proto.eraYear = getEraYear;
    proto.year = getSetYear;
    proto.isLeapYear = getIsLeapYear;
    proto.weekYear = getSetWeekYear;
    proto.isoWeekYear = getSetISOWeekYear;
    proto.quarter = proto.quarters = getSetQuarter;
    proto.month = getSetMonth;
    proto.daysInMonth = getDaysInMonth;
    proto.week = proto.weeks = getSetWeek;
    proto.isoWeek = proto.isoWeeks = getSetISOWeek;
    proto.weeksInYear = getWeeksInYear;
    proto.weeksInWeekYear = getWeeksInWeekYear;
    proto.isoWeeksInYear = getISOWeeksInYear;
    proto.isoWeeksInISOWeekYear = getISOWeeksInISOWeekYear;
    proto.date = getSetDayOfMonth;
    proto.day = proto.days = getSetDayOfWeek;
    proto.weekday = getSetLocaleDayOfWeek;
    proto.isoWeekday = getSetISODayOfWeek;
    proto.dayOfYear = getSetDayOfYear;
    proto.hour = proto.hours = getSetHour;
    proto.minute = proto.minutes = getSetMinute;
    proto.second = proto.seconds = getSetSecond;
    proto.millisecond = proto.milliseconds = getSetMillisecond;
    proto.utcOffset = getSetOffset;
    proto.utc = setOffsetToUTC;
    proto.local = setOffsetToLocal;
    proto.parseZone = setOffsetToParsedOffset;
    proto.hasAlignedHourOffset = hasAlignedHourOffset;
    proto.isDST = isDaylightSavingTime;
    proto.isLocal = isLocal;
    proto.isUtcOffset = isUtcOffset;
    proto.isUtc = isUtc;
    proto.isUTC = isUtc;
    proto.zoneAbbr = getZoneAbbr;
    proto.zoneName = getZoneName;
    proto.dates = deprecate(
        "dates accessor is deprecated. Use date instead.",
        getSetDayOfMonth
    );
    proto.months = deprecate(
        "months accessor is deprecated. Use month instead",
        getSetMonth
    );
    proto.years = deprecate(
        "years accessor is deprecated. Use year instead",
        getSetYear
    );
    proto.zone = deprecate(
        "moment().zone is deprecated, use moment().utcOffset instead. http://momentjs.com/guides/#/warnings/zone/",
        getSetZone
    );
    proto.isDSTShifted = deprecate(
        "isDSTShifted is deprecated. See http://momentjs.com/guides/#/warnings/dst-shifted/ for more information",
        isDaylightSavingTimeShifted
    );

    function createUnix(input) {
        return createLocal(input * 1000);
    }

    function createInZone() {
        return createLocal.apply(null, arguments).parseZone();
    }

    function preParsePostFormat(string) {
        return string;
    }

    var proto$1 = Locale.prototype;

    proto$1.calendar = calendar;
    proto$1.longDateFormat = longDateFormat;
    proto$1.invalidDate = invalidDate;
    proto$1.ordinal = ordinal;
    proto$1.preparse = preParsePostFormat;
    proto$1.postformat = preParsePostFormat;
    proto$1.relativeTime = relativeTime;
    proto$1.pastFuture = pastFuture;
    proto$1.set = set;
    proto$1.eras = localeEras;
    proto$1.erasParse = localeErasParse;
    proto$1.erasConvertYear = localeErasConvertYear;
    proto$1.erasAbbrRegex = erasAbbrRegex;
    proto$1.erasNameRegex = erasNameRegex;
    proto$1.erasNarrowRegex = erasNarrowRegex;

    proto$1.months = localeMonths;
    proto$1.monthsShort = localeMonthsShort;
    proto$1.monthsParse = localeMonthsParse;
    proto$1.monthsRegex = monthsRegex;
    proto$1.monthsShortRegex = monthsShortRegex;
    proto$1.week = localeWeek;
    proto$1.firstDayOfYear = localeFirstDayOfYear;
    proto$1.firstDayOfWeek = localeFirstDayOfWeek;

    proto$1.weekdays = localeWeekdays;
    proto$1.weekdaysMin = localeWeekdaysMin;
    proto$1.weekdaysShort = localeWeekdaysShort;
    proto$1.weekdaysParse = localeWeekdaysParse;

    proto$1.weekdaysRegex = weekdaysRegex;
    proto$1.weekdaysShortRegex = weekdaysShortRegex;
    proto$1.weekdaysMinRegex = weekdaysMinRegex;

    proto$1.isPM = localeIsPM;
    proto$1.meridiem = localeMeridiem;

    function get$1(format, index, field, setter) {
        var locale = getLocale(),
            utc = createUTC().set(setter, index);
        return locale[field](utc, format);
    }

    function listMonthsImpl(format, index, field) {
        if (isNumber(format)) {
            index = format;
            format = undefined;
        }

        format = format || "";

        if (index != null) {
            return get$1(format, index, field, "month");
        }

        var i,
            out = [];
        for (i = 0; i < 12; i++) {
            out[i] = get$1(format, i, field, "month");
        }
        return out;
    }

    // ()
    // (5)
    // (fmt, 5)
    // (fmt)
    // (true)
    // (true, 5)
    // (true, fmt, 5)
    // (true, fmt)
    function listWeekdaysImpl(localeSorted, format, index, field) {
        if (typeof localeSorted === "boolean") {
            if (isNumber(format)) {
                index = format;
                format = undefined;
            }

            format = format || "";
        } else {
            format = localeSorted;
            index = format;
            localeSorted = false;

            if (isNumber(format)) {
                index = format;
                format = undefined;
            }

            format = format || "";
        }

        var locale = getLocale(),
            shift = localeSorted ? locale._week.dow : 0,
            i,
            out = [];

        if (index != null) {
            return get$1(format, (index + shift) % 7, field, "day");
        }

        for (i = 0; i < 7; i++) {
            out[i] = get$1(format, (i + shift) % 7, field, "day");
        }
        return out;
    }

    function listMonths(format, index) {
        return listMonthsImpl(format, index, "months");
    }

    function listMonthsShort(format, index) {
        return listMonthsImpl(format, index, "monthsShort");
    }

    function listWeekdays(localeSorted, format, index) {
        return listWeekdaysImpl(localeSorted, format, index, "weekdays");
    }

    function listWeekdaysShort(localeSorted, format, index) {
        return listWeekdaysImpl(localeSorted, format, index, "weekdaysShort");
    }

    function listWeekdaysMin(localeSorted, format, index) {
        return listWeekdaysImpl(localeSorted, format, index, "weekdaysMin");
    }

    getSetGlobalLocale("en", {
        eras: [
            {
                since: "0001-01-01",
                until: +Infinity,
                offset: 1,
                name: "Anno Domini",
                narrow: "AD",
                abbr: "AD",
            },
            {
                since: "0000-12-31",
                until: -Infinity,
                offset: 1,
                name: "Before Christ",
                narrow: "BC",
                abbr: "BC",
            },
        ],
        dayOfMonthOrdinalParse: /\d{1,2}(th|st|nd|rd)/,
        ordinal: function (number) {
            var b = number % 10,
                output =
                    toInt((number % 100) / 10) === 1
                        ? "th"
                        : b === 1
                        ? "st"
                        : b === 2
                        ? "nd"
                        : b === 3
                        ? "rd"
                        : "th";
            return number + output;
        },
    });

    // Side effect imports

    hooks.lang = deprecate(
        "moment.lang is deprecated. Use moment.locale instead.",
        getSetGlobalLocale
    );
    hooks.langData = deprecate(
        "moment.langData is deprecated. Use moment.localeData instead.",
        getLocale
    );

    var mathAbs = Math.abs;

    function abs() {
        var data = this._data;

        this._milliseconds = mathAbs(this._milliseconds);
        this._days = mathAbs(this._days);
        this._months = mathAbs(this._months);

        data.milliseconds = mathAbs(data.milliseconds);
        data.seconds = mathAbs(data.seconds);
        data.minutes = mathAbs(data.minutes);
        data.hours = mathAbs(data.hours);
        data.months = mathAbs(data.months);
        data.years = mathAbs(data.years);

        return this;
    }

    function addSubtract$1(duration, input, value, direction) {
        var other = createDuration(input, value);

        duration._milliseconds += direction * other._milliseconds;
        duration._days += direction * other._days;
        duration._months += direction * other._months;

        return duration._bubble();
    }

    // supports only 2.0-style add(1, 's') or add(duration)
    function add$1(input, value) {
        return addSubtract$1(this, input, value, 1);
    }

    // supports only 2.0-style subtract(1, 's') or subtract(duration)
    function subtract$1(input, value) {
        return addSubtract$1(this, input, value, -1);
    }

    function absCeil(number) {
        if (number < 0) {
            return Math.floor(number);
        } else {
            return Math.ceil(number);
        }
    }

    function bubble() {
        var milliseconds = this._milliseconds,
            days = this._days,
            months = this._months,
            data = this._data,
            seconds,
            minutes,
            hours,
            years,
            monthsFromDays;

        // if we have a mix of positive and negative values, bubble down first
        // check: https://github.com/moment/moment/issues/2166
        if (
            !(
                (milliseconds >= 0 && days >= 0 && months >= 0) ||
                (milliseconds <= 0 && days <= 0 && months <= 0)
            )
        ) {
            milliseconds += absCeil(monthsToDays(months) + days) * 864e5;
            days = 0;
            months = 0;
        }

        // The following code bubbles up values, see the tests for
        // examples of what that means.
        data.milliseconds = milliseconds % 1000;

        seconds = absFloor(milliseconds / 1000);
        data.seconds = seconds % 60;

        minutes = absFloor(seconds / 60);
        data.minutes = minutes % 60;

        hours = absFloor(minutes / 60);
        data.hours = hours % 24;

        days += absFloor(hours / 24);

        // convert days to months
        monthsFromDays = absFloor(daysToMonths(days));
        months += monthsFromDays;
        days -= absCeil(monthsToDays(monthsFromDays));

        // 12 months -> 1 year
        years = absFloor(months / 12);
        months %= 12;

        data.days = days;
        data.months = months;
        data.years = years;

        return this;
    }

    function daysToMonths(days) {
        // 400 years have 146097 days (taking into account leap year rules)
        // 400 years have 12 months === 4800
        return (days * 4800) / 146097;
    }

    function monthsToDays(months) {
        // the reverse of daysToMonths
        return (months * 146097) / 4800;
    }

    function as(units) {
        if (!this.isValid()) {
            return NaN;
        }
        var days,
            months,
            milliseconds = this._milliseconds;

        units = normalizeUnits(units);

        if (units === "month" || units === "quarter" || units === "year") {
            days = this._days + milliseconds / 864e5;
            months = this._months + daysToMonths(days);
            switch (units) {
                case "month":
                    return months;
                case "quarter":
                    return months / 3;
                case "year":
                    return months / 12;
            }
        } else {
            // handle milliseconds separately because of floating point math errors (issue #1867)
            days = this._days + Math.round(monthsToDays(this._months));
            switch (units) {
                case "week":
                    return days / 7 + milliseconds / 6048e5;
                case "day":
                    return days + milliseconds / 864e5;
                case "hour":
                    return days * 24 + milliseconds / 36e5;
                case "minute":
                    return days * 1440 + milliseconds / 6e4;
                case "second":
                    return days * 86400 + milliseconds / 1000;
                // Math.floor prevents floating point math errors here
                case "millisecond":
                    return Math.floor(days * 864e5) + milliseconds;
                default:
                    throw new Error("Unknown unit " + units);
            }
        }
    }

    // TODO: Use this.as('ms')?
    function valueOf$1() {
        if (!this.isValid()) {
            return NaN;
        }
        return (
            this._milliseconds +
            this._days * 864e5 +
            (this._months % 12) * 2592e6 +
            toInt(this._months / 12) * 31536e6
        );
    }

    function makeAs(alias) {
        return function () {
            return this.as(alias);
        };
    }

    var asMilliseconds = makeAs("ms"),
        asSeconds = makeAs("s"),
        asMinutes = makeAs("m"),
        asHours = makeAs("h"),
        asDays = makeAs("d"),
        asWeeks = makeAs("w"),
        asMonths = makeAs("M"),
        asQuarters = makeAs("Q"),
        asYears = makeAs("y");

    function clone$1() {
        return createDuration(this);
    }

    function get$2(units) {
        units = normalizeUnits(units);
        return this.isValid() ? this[units + "s"]() : NaN;
    }

    function makeGetter(name) {
        return function () {
            return this.isValid() ? this._data[name] : NaN;
        };
    }

    var milliseconds = makeGetter("milliseconds"),
        seconds = makeGetter("seconds"),
        minutes = makeGetter("minutes"),
        hours = makeGetter("hours"),
        days = makeGetter("days"),
        months = makeGetter("months"),
        years = makeGetter("years");

    function weeks() {
        return absFloor(this.days() / 7);
    }

    var round = Math.round,
        thresholds = {
            ss: 44, // a few seconds to seconds
            s: 45, // seconds to minute
            m: 45, // minutes to hour
            h: 22, // hours to day
            d: 26, // days to month/week
            w: null, // weeks to month
            M: 11, // months to year
        };

    // helper function for moment.fn.from, moment.fn.fromNow, and moment.duration.fn.humanize
    function substituteTimeAgo(
        string,
        number,
        withoutSuffix,
        isFuture,
        locale
    ) {
        return locale.relativeTime(
            number || 1,
            !!withoutSuffix,
            string,
            isFuture
        );
    }

    function relativeTime$1(posNegDuration, withoutSuffix, thresholds, locale) {
        var duration = createDuration(posNegDuration).abs(),
            seconds = round(duration.as("s")),
            minutes = round(duration.as("m")),
            hours = round(duration.as("h")),
            days = round(duration.as("d")),
            months = round(duration.as("M")),
            weeks = round(duration.as("w")),
            years = round(duration.as("y")),
            a =
                (seconds <= thresholds.ss && ["s", seconds]) ||
                (seconds < thresholds.s && ["ss", seconds]) ||
                (minutes <= 1 && ["m"]) ||
                (minutes < thresholds.m && ["mm", minutes]) ||
                (hours <= 1 && ["h"]) ||
                (hours < thresholds.h && ["hh", hours]) ||
                (days <= 1 && ["d"]) ||
                (days < thresholds.d && ["dd", days]);

        if (thresholds.w != null) {
            a =
                a ||
                (weeks <= 1 && ["w"]) ||
                (weeks < thresholds.w && ["ww", weeks]);
        }
        a = a ||
            (months <= 1 && ["M"]) ||
            (months < thresholds.M && ["MM", months]) ||
            (years <= 1 && ["y"]) || ["yy", years];

        a[2] = withoutSuffix;
        a[3] = +posNegDuration > 0;
        a[4] = locale;
        return substituteTimeAgo.apply(null, a);
    }

    // This function allows you to set the rounding function for relative time strings
    function getSetRelativeTimeRounding(roundingFunction) {
        if (roundingFunction === undefined) {
            return round;
        }
        if (typeof roundingFunction === "function") {
            round = roundingFunction;
            return true;
        }
        return false;
    }

    // This function allows you to set a threshold for relative time strings
    function getSetRelativeTimeThreshold(threshold, limit) {
        if (thresholds[threshold] === undefined) {
            return false;
        }
        if (limit === undefined) {
            return thresholds[threshold];
        }
        thresholds[threshold] = limit;
        if (threshold === "s") {
            thresholds.ss = limit - 1;
        }
        return true;
    }

    function humanize(argWithSuffix, argThresholds) {
        if (!this.isValid()) {
            return this.localeData().invalidDate();
        }

        var withSuffix = false,
            th = thresholds,
            locale,
            output;

        if (typeof argWithSuffix === "object") {
            argThresholds = argWithSuffix;
            argWithSuffix = false;
        }
        if (typeof argWithSuffix === "boolean") {
            withSuffix = argWithSuffix;
        }
        if (typeof argThresholds === "object") {
            th = Object.assign({}, thresholds, argThresholds);
            if (argThresholds.s != null && argThresholds.ss == null) {
                th.ss = argThresholds.s - 1;
            }
        }

        locale = this.localeData();
        output = relativeTime$1(this, !withSuffix, th, locale);

        if (withSuffix) {
            output = locale.pastFuture(+this, output);
        }

        return locale.postformat(output);
    }

    var abs$1 = Math.abs;

    function sign(x) {
        return (x > 0) - (x < 0) || +x;
    }

    function toISOString$1() {
        // for ISO strings we do not use the normal bubbling rules:
        //  * milliseconds bubble up until they become hours
        //  * days do not bubble at all
        //  * months bubble up until they become years
        // This is because there is no context-free conversion between hours and days
        // (think of clock changes)
        // and also not between days and months (28-31 days per month)
        if (!this.isValid()) {
            return this.localeData().invalidDate();
        }

        var seconds = abs$1(this._milliseconds) / 1000,
            days = abs$1(this._days),
            months = abs$1(this._months),
            minutes,
            hours,
            years,
            s,
            total = this.asSeconds(),
            totalSign,
            ymSign,
            daysSign,
            hmsSign;

        if (!total) {
            // this is the same as C#'s (Noda) and python (isodate)...
            // but not other JS (goog.date)
            return "P0D";
        }

        // 3600 seconds -> 60 minutes -> 1 hour
        minutes = absFloor(seconds / 60);
        hours = absFloor(minutes / 60);
        seconds %= 60;
        minutes %= 60;

        // 12 months -> 1 year
        years = absFloor(months / 12);
        months %= 12;

        // inspired by https://github.com/dordille/moment-isoduration/blob/master/moment.isoduration.js
        s = seconds ? seconds.toFixed(3).replace(/\.?0+$/, "") : "";

        totalSign = total < 0 ? "-" : "";
        ymSign = sign(this._months) !== sign(total) ? "-" : "";
        daysSign = sign(this._days) !== sign(total) ? "-" : "";
        hmsSign = sign(this._milliseconds) !== sign(total) ? "-" : "";

        return (
            totalSign +
            "P" +
            (years ? ymSign + years + "Y" : "") +
            (months ? ymSign + months + "M" : "") +
            (days ? daysSign + days + "D" : "") +
            (hours || minutes || seconds ? "T" : "") +
            (hours ? hmsSign + hours + "H" : "") +
            (minutes ? hmsSign + minutes + "M" : "") +
            (seconds ? hmsSign + s + "S" : "")
        );
    }

    var proto$2 = Duration.prototype;

    proto$2.isValid = isValid$1;
    proto$2.abs = abs;
    proto$2.add = add$1;
    proto$2.subtract = subtract$1;
    proto$2.as = as;
    proto$2.asMilliseconds = asMilliseconds;
    proto$2.asSeconds = asSeconds;
    proto$2.asMinutes = asMinutes;
    proto$2.asHours = asHours;
    proto$2.asDays = asDays;
    proto$2.asWeeks = asWeeks;
    proto$2.asMonths = asMonths;
    proto$2.asQuarters = asQuarters;
    proto$2.asYears = asYears;
    proto$2.valueOf = valueOf$1;
    proto$2._bubble = bubble;
    proto$2.clone = clone$1;
    proto$2.get = get$2;
    proto$2.milliseconds = milliseconds;
    proto$2.seconds = seconds;
    proto$2.minutes = minutes;
    proto$2.hours = hours;
    proto$2.days = days;
    proto$2.weeks = weeks;
    proto$2.months = months;
    proto$2.years = years;
    proto$2.humanize = humanize;
    proto$2.toISOString = toISOString$1;
    proto$2.toString = toISOString$1;
    proto$2.toJSON = toISOString$1;
    proto$2.locale = locale;
    proto$2.localeData = localeData;

    proto$2.toIsoString = deprecate(
        "toIsoString() is deprecated. Please use toISOString() instead (notice the capitals)",
        toISOString$1
    );
    proto$2.lang = lang;

    // FORMATTING

    addFormatToken("X", 0, 0, "unix");
    addFormatToken("x", 0, 0, "valueOf");

    // PARSING

    addRegexToken("x", matchSigned);
    addRegexToken("X", matchTimestamp);
    addParseToken("X", function (input, array, config) {
        config._d = new Date(parseFloat(input) * 1000);
    });
    addParseToken("x", function (input, array, config) {
        config._d = new Date(toInt(input));
    });

    //! moment.js

    hooks.version = "2.29.1";

    setHookCallback(createLocal);

    hooks.fn = proto;
    hooks.min = min;
    hooks.max = max;
    hooks.now = now;
    hooks.utc = createUTC;
    hooks.unix = createUnix;
    hooks.months = listMonths;
    hooks.isDate = isDate;
    hooks.locale = getSetGlobalLocale;
    hooks.invalid = createInvalid;
    hooks.duration = createDuration;
    hooks.isMoment = isMoment;
    hooks.weekdays = listWeekdays;
    hooks.parseZone = createInZone;
    hooks.localeData = getLocale;
    hooks.isDuration = isDuration;
    hooks.monthsShort = listMonthsShort;
    hooks.weekdaysMin = listWeekdaysMin;
    hooks.defineLocale = defineLocale;
    hooks.updateLocale = updateLocale;
    hooks.locales = listLocales;
    hooks.weekdaysShort = listWeekdaysShort;
    hooks.normalizeUnits = normalizeUnits;
    hooks.relativeTimeRounding = getSetRelativeTimeRounding;
    hooks.relativeTimeThreshold = getSetRelativeTimeThreshold;
    hooks.calendarFormat = getCalendarFormat;
    hooks.prototype = proto;

    // currently HTML5 input type only supports 24-hour formats
    hooks.HTML5_FMT = {
        DATETIME_LOCAL: "YYYY-MM-DDTHH:mm", // <input type="datetime-local" />
        DATETIME_LOCAL_SECONDS: "YYYY-MM-DDTHH:mm:ss", // <input type="datetime-local" step="1" />
        DATETIME_LOCAL_MS: "YYYY-MM-DDTHH:mm:ss.SSS", // <input type="datetime-local" step="0.001" />
        DATE: "YYYY-MM-DD", // <input type="date" />
        TIME: "HH:mm", // <input type="time" />
        TIME_SECONDS: "HH:mm:ss", // <input type="time" step="1" />
        TIME_MS: "HH:mm:ss.SSS", // <input type="time" step="0.001" />
        WEEK: "GGGG-[W]WW", // <input type="week" />
        MONTH: "YYYY-MM", // <input type="month" />
    };

    return hooks;
});

/**
 * SimpleBar.js - v5.3.6
 * Scrollbars, simpler.
 * https://grsmto.github.io/simplebar/
 *
 * Made by Adrien Denat from a fork by Jonathan Nicol
 * Under MIT License
 */

!(function (t, e) {
    "object" == typeof exports && "undefined" != typeof module
        ? (module.exports = e())
        : "function" == typeof define && define.amd
        ? define(e)
        : ((t = t || self).SimpleBar = e());
})(this, function () {
    "use strict";
    var t =
        "undefined" != typeof globalThis
            ? globalThis
            : "undefined" != typeof window
            ? window
            : "undefined" != typeof global
            ? global
            : "undefined" != typeof self
            ? self
            : {};
    function e(t, e) {
        return t((e = { exports: {} }), e.exports), e.exports;
    }
    var r,
        i,
        n,
        o = "object",
        s = function (t) {
            return t && t.Math == Math && t;
        },
        a =
            s(typeof globalThis == o && globalThis) ||
            s(typeof window == o && window) ||
            s(typeof self == o && self) ||
            s(typeof t == o && t) ||
            Function("return this")(),
        c = function (t) {
            try {
                return !!t();
            } catch (t) {
                return !0;
            }
        },
        l = !c(function () {
            return (
                7 !=
                Object.defineProperty({}, "a", {
                    get: function () {
                        return 7;
                    },
                }).a
            );
        }),
        u = {}.propertyIsEnumerable,
        f = Object.getOwnPropertyDescriptor,
        h = {
            f:
                f && !u.call({ 1: 2 }, 1)
                    ? function (t) {
                          var e = f(this, t);
                          return !!e && e.enumerable;
                      }
                    : u,
        },
        d = function (t, e) {
            return {
                enumerable: !(1 & t),
                configurable: !(2 & t),
                writable: !(4 & t),
                value: e,
            };
        },
        p = {}.toString,
        v = function (t) {
            return p.call(t).slice(8, -1);
        },
        g = "".split,
        b = c(function () {
            return !Object("z").propertyIsEnumerable(0);
        })
            ? function (t) {
                  return "String" == v(t) ? g.call(t, "") : Object(t);
              }
            : Object,
        y = function (t) {
            if (null == t) throw TypeError("Can't call method on " + t);
            return t;
        },
        m = function (t) {
            return b(y(t));
        },
        x = function (t) {
            return "object" == typeof t ? null !== t : "function" == typeof t;
        },
        E = function (t, e) {
            if (!x(t)) return t;
            var r, i;
            if (
                e &&
                "function" == typeof (r = t.toString) &&
                !x((i = r.call(t)))
            )
                return i;
            if ("function" == typeof (r = t.valueOf) && !x((i = r.call(t))))
                return i;
            if (
                !e &&
                "function" == typeof (r = t.toString) &&
                !x((i = r.call(t)))
            )
                return i;
            throw TypeError("Can't convert object to primitive value");
        },
        w = {}.hasOwnProperty,
        S = function (t, e) {
            return w.call(t, e);
        },
        O = a.document,
        k = x(O) && x(O.createElement),
        A = function (t) {
            return k ? O.createElement(t) : {};
        },
        T =
            !l &&
            !c(function () {
                return (
                    7 !=
                    Object.defineProperty(A("div"), "a", {
                        get: function () {
                            return 7;
                        },
                    }).a
                );
            }),
        L = Object.getOwnPropertyDescriptor,
        z = {
            f: l
                ? L
                : function (t, e) {
                      if (((t = m(t)), (e = E(e, !0)), T))
                          try {
                              return L(t, e);
                          } catch (t) {}
                      if (S(t, e)) return d(!h.f.call(t, e), t[e]);
                  },
        },
        R = function (t) {
            if (!x(t)) throw TypeError(String(t) + " is not an object");
            return t;
        },
        _ = Object.defineProperty,
        M = {
            f: l
                ? _
                : function (t, e, r) {
                      if ((R(t), (e = E(e, !0)), R(r), T))
                          try {
                              return _(t, e, r);
                          } catch (t) {}
                      if ("get" in r || "set" in r)
                          throw TypeError("Accessors not supported");
                      return "value" in r && (t[e] = r.value), t;
                  },
        },
        C = l
            ? function (t, e, r) {
                  return M.f(t, e, d(1, r));
              }
            : function (t, e, r) {
                  return (t[e] = r), t;
              },
        W = function (t, e) {
            try {
                C(a, t, e);
            } catch (r) {
                a[t] = e;
            }
            return e;
        },
        j = e(function (t) {
            var e = a["__core-js_shared__"] || W("__core-js_shared__", {});
            (t.exports = function (t, r) {
                return e[t] || (e[t] = void 0 !== r ? r : {});
            })("versions", []).push({
                version: "3.2.1",
                mode: "global",
                copyright: "Â© 2019 Denis Pushkarev (zloirock.ru)",
            });
        }),
        N = j("native-function-to-string", Function.toString),
        I = a.WeakMap,
        B = "function" == typeof I && /native code/.test(N.call(I)),
        D = 0,
        P = Math.random(),
        F = function (t) {
            return (
                "Symbol(" +
                String(void 0 === t ? "" : t) +
                ")_" +
                (++D + P).toString(36)
            );
        },
        V = j("keys"),
        X = function (t) {
            return V[t] || (V[t] = F(t));
        },
        H = {},
        q = a.WeakMap;
    if (B) {
        var $ = new q(),
            Y = $.get,
            G = $.has,
            U = $.set;
        (r = function (t, e) {
            return U.call($, t, e), e;
        }),
            (i = function (t) {
                return Y.call($, t) || {};
            }),
            (n = function (t) {
                return G.call($, t);
            });
    } else {
        var Q = X("state");
        (H[Q] = !0),
            (r = function (t, e) {
                return C(t, Q, e), e;
            }),
            (i = function (t) {
                return S(t, Q) ? t[Q] : {};
            }),
            (n = function (t) {
                return S(t, Q);
            });
    }
    var K = {
            set: r,
            get: i,
            has: n,
            enforce: function (t) {
                return n(t) ? i(t) : r(t, {});
            },
            getterFor: function (t) {
                return function (e) {
                    var r;
                    if (!x(e) || (r = i(e)).type !== t)
                        throw TypeError(
                            "Incompatible receiver, " + t + " required"
                        );
                    return r;
                };
            },
        },
        J = e(function (t) {
            var e = K.get,
                r = K.enforce,
                i = String(N).split("toString");
            j("inspectSource", function (t) {
                return N.call(t);
            }),
                (t.exports = function (t, e, n, o) {
                    var s = !!o && !!o.unsafe,
                        c = !!o && !!o.enumerable,
                        l = !!o && !!o.noTargetGet;
                    "function" == typeof n &&
                        ("string" != typeof e ||
                            S(n, "name") ||
                            C(n, "name", e),
                        (r(n).source = i.join("string" == typeof e ? e : ""))),
                        t !== a
                            ? (s ? !l && t[e] && (c = !0) : delete t[e],
                              c ? (t[e] = n) : C(t, e, n))
                            : c
                            ? (t[e] = n)
                            : W(e, n);
                })(Function.prototype, "toString", function () {
                    return (
                        ("function" == typeof this && e(this).source) ||
                        N.call(this)
                    );
                });
        }),
        Z = a,
        tt = function (t) {
            return "function" == typeof t ? t : void 0;
        },
        et = function (t, e) {
            return arguments.length < 2
                ? tt(Z[t]) || tt(a[t])
                : (Z[t] && Z[t][e]) || (a[t] && a[t][e]);
        },
        rt = Math.ceil,
        it = Math.floor,
        nt = function (t) {
            return isNaN((t = +t)) ? 0 : (t > 0 ? it : rt)(t);
        },
        ot = Math.min,
        st = function (t) {
            return t > 0 ? ot(nt(t), 9007199254740991) : 0;
        },
        at = Math.max,
        ct = Math.min,
        lt = function (t) {
            return function (e, r, i) {
                var n,
                    o = m(e),
                    s = st(o.length),
                    a = (function (t, e) {
                        var r = nt(t);
                        return r < 0 ? at(r + e, 0) : ct(r, e);
                    })(i, s);
                if (t && r != r) {
                    for (; s > a; ) if ((n = o[a++]) != n) return !0;
                } else
                    for (; s > a; a++)
                        if ((t || a in o) && o[a] === r) return t || a || 0;
                return !t && -1;
            };
        },
        ut = { includes: lt(!0), indexOf: lt(!1) }.indexOf,
        ft = function (t, e) {
            var r,
                i = m(t),
                n = 0,
                o = [];
            for (r in i) !S(H, r) && S(i, r) && o.push(r);
            for (; e.length > n; )
                S(i, (r = e[n++])) && (~ut(o, r) || o.push(r));
            return o;
        },
        ht = [
            "constructor",
            "hasOwnProperty",
            "isPrototypeOf",
            "propertyIsEnumerable",
            "toLocaleString",
            "toString",
            "valueOf",
        ],
        dt = ht.concat("length", "prototype"),
        pt = {
            f:
                Object.getOwnPropertyNames ||
                function (t) {
                    return ft(t, dt);
                },
        },
        vt = { f: Object.getOwnPropertySymbols },
        gt =
            et("Reflect", "ownKeys") ||
            function (t) {
                var e = pt.f(R(t)),
                    r = vt.f;
                return r ? e.concat(r(t)) : e;
            },
        bt = function (t, e) {
            for (var r = gt(e), i = M.f, n = z.f, o = 0; o < r.length; o++) {
                var s = r[o];
                S(t, s) || i(t, s, n(e, s));
            }
        },
        yt = /#|\.prototype\./,
        mt = function (t, e) {
            var r = Et[xt(t)];
            return (
                r == St || (r != wt && ("function" == typeof e ? c(e) : !!e))
            );
        },
        xt = (mt.normalize = function (t) {
            return String(t).replace(yt, ".").toLowerCase();
        }),
        Et = (mt.data = {}),
        wt = (mt.NATIVE = "N"),
        St = (mt.POLYFILL = "P"),
        Ot = mt,
        kt = z.f,
        At = function (t, e) {
            var r,
                i,
                n,
                o,
                s,
                c = t.target,
                l = t.global,
                u = t.stat;
            if ((r = l ? a : u ? a[c] || W(c, {}) : (a[c] || {}).prototype))
                for (i in e) {
                    if (
                        ((o = e[i]),
                        (n = t.noTargetGet ? (s = kt(r, i)) && s.value : r[i]),
                        !Ot(l ? i : c + (u ? "." : "#") + i, t.forced) &&
                            void 0 !== n)
                    ) {
                        if (typeof o == typeof n) continue;
                        bt(o, n);
                    }
                    (t.sham || (n && n.sham)) && C(o, "sham", !0),
                        J(r, i, o, t);
                }
        },
        Tt = function (t) {
            if ("function" != typeof t)
                throw TypeError(String(t) + " is not a function");
            return t;
        },
        Lt = function (t, e, r) {
            if ((Tt(t), void 0 === e)) return t;
            switch (r) {
                case 0:
                    return function () {
                        return t.call(e);
                    };
                case 1:
                    return function (r) {
                        return t.call(e, r);
                    };
                case 2:
                    return function (r, i) {
                        return t.call(e, r, i);
                    };
                case 3:
                    return function (r, i, n) {
                        return t.call(e, r, i, n);
                    };
            }
            return function () {
                return t.apply(e, arguments);
            };
        },
        zt = function (t) {
            return Object(y(t));
        },
        Rt =
            Array.isArray ||
            function (t) {
                return "Array" == v(t);
            },
        _t =
            !!Object.getOwnPropertySymbols &&
            !c(function () {
                return !String(Symbol());
            }),
        Mt = a.Symbol,
        Ct = j("wks"),
        Wt = function (t) {
            return (
                Ct[t] || (Ct[t] = (_t && Mt[t]) || (_t ? Mt : F)("Symbol." + t))
            );
        },
        jt = Wt("species"),
        Nt = function (t, e) {
            var r;
            return (
                Rt(t) &&
                    ("function" != typeof (r = t.constructor) ||
                    (r !== Array && !Rt(r.prototype))
                        ? x(r) && null === (r = r[jt]) && (r = void 0)
                        : (r = void 0)),
                new (void 0 === r ? Array : r)(0 === e ? 0 : e)
            );
        },
        It = [].push,
        Bt = function (t) {
            var e = 1 == t,
                r = 2 == t,
                i = 3 == t,
                n = 4 == t,
                o = 6 == t,
                s = 5 == t || o;
            return function (a, c, l, u) {
                for (
                    var f,
                        h,
                        d = zt(a),
                        p = b(d),
                        v = Lt(c, l, 3),
                        g = st(p.length),
                        y = 0,
                        m = u || Nt,
                        x = e ? m(a, g) : r ? m(a, 0) : void 0;
                    g > y;
                    y++
                )
                    if ((s || y in p) && ((h = v((f = p[y]), y, d)), t))
                        if (e) x[y] = h;
                        else if (h)
                            switch (t) {
                                case 3:
                                    return !0;
                                case 5:
                                    return f;
                                case 6:
                                    return y;
                                case 2:
                                    It.call(x, f);
                            }
                        else if (n) return !1;
                return o ? -1 : i || n ? n : x;
            };
        },
        Dt = {
            forEach: Bt(0),
            map: Bt(1),
            filter: Bt(2),
            some: Bt(3),
            every: Bt(4),
            find: Bt(5),
            findIndex: Bt(6),
        },
        Pt = function (t, e) {
            var r = [][t];
            return (
                !r ||
                !c(function () {
                    r.call(
                        null,
                        e ||
                            function () {
                                throw 1;
                            },
                        1
                    );
                })
            );
        },
        Ft = Dt.forEach,
        Vt = Pt("forEach")
            ? function (t) {
                  return Ft(
                      this,
                      t,
                      arguments.length > 1 ? arguments[1] : void 0
                  );
              }
            : [].forEach;
    At(
        { target: "Array", proto: !0, forced: [].forEach != Vt },
        { forEach: Vt }
    );
    var Xt = {
        CSSRuleList: 0,
        CSSStyleDeclaration: 0,
        CSSValueList: 0,
        ClientRectList: 0,
        DOMRectList: 0,
        DOMStringList: 0,
        DOMTokenList: 1,
        DataTransferItemList: 0,
        FileList: 0,
        HTMLAllCollection: 0,
        HTMLCollection: 0,
        HTMLFormElement: 0,
        HTMLSelectElement: 0,
        MediaList: 0,
        MimeTypeArray: 0,
        NamedNodeMap: 0,
        NodeList: 1,
        PaintRequestList: 0,
        Plugin: 0,
        PluginArray: 0,
        SVGLengthList: 0,
        SVGNumberList: 0,
        SVGPathSegList: 0,
        SVGPointList: 0,
        SVGStringList: 0,
        SVGTransformList: 0,
        SourceBufferList: 0,
        StyleSheetList: 0,
        TextTrackCueList: 0,
        TextTrackList: 0,
        TouchList: 0,
    };
    for (var Ht in Xt) {
        var qt = a[Ht],
            $t = qt && qt.prototype;
        if ($t && $t.forEach !== Vt)
            try {
                C($t, "forEach", Vt);
            } catch (t) {
                $t.forEach = Vt;
            }
    }
    var Yt = !(
            "undefined" == typeof window ||
            !window.document ||
            !window.document.createElement
        ),
        Gt = Wt("species"),
        Ut = Dt.filter;
    At(
        {
            target: "Array",
            proto: !0,
            forced: !(function (t) {
                return !c(function () {
                    var e = [];
                    return (
                        ((e.constructor = {})[Gt] = function () {
                            return { foo: 1 };
                        }),
                        1 !== e[t](Boolean).foo
                    );
                });
            })("filter"),
        },
        {
            filter: function (t) {
                return Ut(
                    this,
                    t,
                    arguments.length > 1 ? arguments[1] : void 0
                );
            },
        }
    );
    var Qt =
            Object.keys ||
            function (t) {
                return ft(t, ht);
            },
        Kt = l
            ? Object.defineProperties
            : function (t, e) {
                  R(t);
                  for (var r, i = Qt(e), n = i.length, o = 0; n > o; )
                      M.f(t, (r = i[o++]), e[r]);
                  return t;
              },
        Jt = et("document", "documentElement"),
        Zt = X("IE_PROTO"),
        te = function () {},
        ee = function () {
            var t,
                e = A("iframe"),
                r = ht.length;
            for (
                e.style.display = "none",
                    Jt.appendChild(e),
                    e.src = String("javascript:"),
                    (t = e.contentWindow.document).open(),
                    t.write("<script>document.F=Object</script>"),
                    t.close(),
                    ee = t.F;
                r--;

            )
                delete ee.prototype[ht[r]];
            return ee();
        },
        re =
            Object.create ||
            function (t, e) {
                var r;
                return (
                    null !== t
                        ? ((te.prototype = R(t)),
                          (r = new te()),
                          (te.prototype = null),
                          (r[Zt] = t))
                        : (r = ee()),
                    void 0 === e ? r : Kt(r, e)
                );
            };
    H[Zt] = !0;
    var ie = Wt("unscopables"),
        ne = Array.prototype;
    null == ne[ie] && C(ne, ie, re(null));
    var oe,
        se,
        ae,
        ce = function (t) {
            ne[ie][t] = !0;
        },
        le = {},
        ue = !c(function () {
            function t() {}
            return (
                (t.prototype.constructor = null),
                Object.getPrototypeOf(new t()) !== t.prototype
            );
        }),
        fe = X("IE_PROTO"),
        he = Object.prototype,
        de = ue
            ? Object.getPrototypeOf
            : function (t) {
                  return (
                      (t = zt(t)),
                      S(t, fe)
                          ? t[fe]
                          : "function" == typeof t.constructor &&
                            t instanceof t.constructor
                          ? t.constructor.prototype
                          : t instanceof Object
                          ? he
                          : null
                  );
              },
        pe = Wt("iterator"),
        ve = !1;
    [].keys &&
        ("next" in (ae = [].keys())
            ? (se = de(de(ae))) !== Object.prototype && (oe = se)
            : (ve = !0)),
        null == oe && (oe = {}),
        S(oe, pe) ||
            C(oe, pe, function () {
                return this;
            });
    var ge = { IteratorPrototype: oe, BUGGY_SAFARI_ITERATORS: ve },
        be = M.f,
        ye = Wt("toStringTag"),
        me = function (t, e, r) {
            t &&
                !S((t = r ? t : t.prototype), ye) &&
                be(t, ye, { configurable: !0, value: e });
        },
        xe = ge.IteratorPrototype,
        Ee = function () {
            return this;
        },
        we =
            Object.setPrototypeOf ||
            ("__proto__" in {}
                ? (function () {
                      var t,
                          e = !1,
                          r = {};
                      try {
                          (t = Object.getOwnPropertyDescriptor(
                              Object.prototype,
                              "__proto__"
                          ).set).call(r, []),
                              (e = r instanceof Array);
                      } catch (t) {}
                      return function (r, i) {
                          return (
                              R(r),
                              (function (t) {
                                  if (!x(t) && null !== t)
                                      throw TypeError(
                                          "Can't set " +
                                              String(t) +
                                              " as a prototype"
                                      );
                              })(i),
                              e ? t.call(r, i) : (r.__proto__ = i),
                              r
                          );
                      };
                  })()
                : void 0),
        Se = ge.IteratorPrototype,
        Oe = ge.BUGGY_SAFARI_ITERATORS,
        ke = Wt("iterator"),
        Ae = function () {
            return this;
        },
        Te = function (t, e, r, i, n, o, s) {
            !(function (t, e, r) {
                var i = e + " Iterator";
                (t.prototype = re(xe, { next: d(1, r) })),
                    me(t, i, !1),
                    (le[i] = Ee);
            })(r, e, i);
            var a,
                c,
                l,
                u = function (t) {
                    if (t === n && g) return g;
                    if (!Oe && t in p) return p[t];
                    switch (t) {
                        case "keys":
                        case "values":
                        case "entries":
                            return function () {
                                return new r(this, t);
                            };
                    }
                    return function () {
                        return new r(this);
                    };
                },
                f = e + " Iterator",
                h = !1,
                p = t.prototype,
                v = p[ke] || p["@@iterator"] || (n && p[n]),
                g = (!Oe && v) || u(n),
                b = ("Array" == e && p.entries) || v;
            if (
                (b &&
                    ((a = de(b.call(new t()))),
                    Se !== Object.prototype &&
                        a.next &&
                        (de(a) !== Se &&
                            (we
                                ? we(a, Se)
                                : "function" != typeof a[ke] && C(a, ke, Ae)),
                        me(a, f, !0))),
                "values" == n &&
                    v &&
                    "values" !== v.name &&
                    ((h = !0),
                    (g = function () {
                        return v.call(this);
                    })),
                p[ke] !== g && C(p, ke, g),
                (le[e] = g),
                n)
            )
                if (
                    ((c = {
                        values: u("values"),
                        keys: o ? g : u("keys"),
                        entries: u("entries"),
                    }),
                    s)
                )
                    for (l in c) (!Oe && !h && l in p) || J(p, l, c[l]);
                else At({ target: e, proto: !0, forced: Oe || h }, c);
            return c;
        },
        Le = K.set,
        ze = K.getterFor("Array Iterator"),
        Re = Te(
            Array,
            "Array",
            function (t, e) {
                Le(this, {
                    type: "Array Iterator",
                    target: m(t),
                    index: 0,
                    kind: e,
                });
            },
            function () {
                var t = ze(this),
                    e = t.target,
                    r = t.kind,
                    i = t.index++;
                return !e || i >= e.length
                    ? ((t.target = void 0), { value: void 0, done: !0 })
                    : "keys" == r
                    ? { value: i, done: !1 }
                    : "values" == r
                    ? { value: e[i], done: !1 }
                    : { value: [i, e[i]], done: !1 };
            },
            "values"
        );
    (le.Arguments = le.Array), ce("keys"), ce("values"), ce("entries");
    var _e = Object.assign,
        Me =
            !_e ||
            c(function () {
                var t = {},
                    e = {},
                    r = Symbol();
                return (
                    (t[r] = 7),
                    "abcdefghijklmnopqrst".split("").forEach(function (t) {
                        e[t] = t;
                    }),
                    7 != _e({}, t)[r] ||
                        "abcdefghijklmnopqrst" != Qt(_e({}, e)).join("")
                );
            })
                ? function (t, e) {
                      for (
                          var r = zt(t),
                              i = arguments.length,
                              n = 1,
                              o = vt.f,
                              s = h.f;
                          i > n;

                      )
                          for (
                              var a,
                                  c = b(arguments[n++]),
                                  u = o ? Qt(c).concat(o(c)) : Qt(c),
                                  f = u.length,
                                  d = 0;
                              f > d;

                          )
                              (a = u[d++]),
                                  (l && !s.call(c, a)) || (r[a] = c[a]);
                      return r;
                  }
                : _e;
    At(
        { target: "Object", stat: !0, forced: Object.assign !== Me },
        { assign: Me }
    );
    var Ce = Wt("toStringTag"),
        We =
            "Arguments" ==
            v(
                (function () {
                    return arguments;
                })()
            ),
        je = function (t) {
            var e, r, i;
            return void 0 === t
                ? "Undefined"
                : null === t
                ? "Null"
                : "string" ==
                  typeof (r = (function (t, e) {
                      try {
                          return t[e];
                      } catch (t) {}
                  })((e = Object(t)), Ce))
                ? r
                : We
                ? v(e)
                : "Object" == (i = v(e)) && "function" == typeof e.callee
                ? "Arguments"
                : i;
        },
        Ne = {};
    Ne[Wt("toStringTag")] = "z";
    var Ie =
            "[object z]" !== String(Ne)
                ? function () {
                      return "[object " + je(this) + "]";
                  }
                : Ne.toString,
        Be = Object.prototype;
    Ie !== Be.toString && J(Be, "toString", Ie, { unsafe: !0 });
    var De =
            "\t\n\v\f\r Â áš€â€€â€â€‚â€ƒâ€„â€…â€†â€‡â€ˆâ€‰â€Šâ€¯âŸã€€\u2028\u2029\ufeff",
        Pe = "[" + De + "]",
        Fe = RegExp("^" + Pe + Pe + "*"),
        Ve = RegExp(Pe + Pe + "*$"),
        Xe = function (t) {
            return function (e) {
                var r = String(y(e));
                return (
                    1 & t && (r = r.replace(Fe, "")),
                    2 & t && (r = r.replace(Ve, "")),
                    r
                );
            };
        },
        He = { start: Xe(1), end: Xe(2), trim: Xe(3) }.trim,
        qe = a.parseInt,
        $e = /^[+-]?0[Xx]/,
        Ye =
            8 !== qe(De + "08") || 22 !== qe(De + "0x16")
                ? function (t, e) {
                      var r = He(String(t));
                      return qe(r, e >>> 0 || ($e.test(r) ? 16 : 10));
                  }
                : qe;
    At({ global: !0, forced: parseInt != Ye }, { parseInt: Ye });
    var Ge = function (t) {
            return function (e, r) {
                var i,
                    n,
                    o = String(y(e)),
                    s = nt(r),
                    a = o.length;
                return s < 0 || s >= a
                    ? t
                        ? ""
                        : void 0
                    : (i = o.charCodeAt(s)) < 55296 ||
                      i > 56319 ||
                      s + 1 === a ||
                      (n = o.charCodeAt(s + 1)) < 56320 ||
                      n > 57343
                    ? t
                        ? o.charAt(s)
                        : i
                    : t
                    ? o.slice(s, s + 2)
                    : n - 56320 + ((i - 55296) << 10) + 65536;
            };
        },
        Ue = { codeAt: Ge(!1), charAt: Ge(!0) },
        Qe = Ue.charAt,
        Ke = K.set,
        Je = K.getterFor("String Iterator");
    Te(
        String,
        "String",
        function (t) {
            Ke(this, { type: "String Iterator", string: String(t), index: 0 });
        },
        function () {
            var t,
                e = Je(this),
                r = e.string,
                i = e.index;
            return i >= r.length
                ? { value: void 0, done: !0 }
                : ((t = Qe(r, i)),
                  (e.index += t.length),
                  { value: t, done: !1 });
        }
    );
    var Ze = function (t, e, r) {
            for (var i in e) J(t, i, e[i], r);
            return t;
        },
        tr = !c(function () {
            return Object.isExtensible(Object.preventExtensions({}));
        }),
        er = e(function (t) {
            var e = M.f,
                r = F("meta"),
                i = 0,
                n =
                    Object.isExtensible ||
                    function () {
                        return !0;
                    },
                o = function (t) {
                    e(t, r, { value: { objectID: "O" + ++i, weakData: {} } });
                },
                s = (t.exports = {
                    REQUIRED: !1,
                    fastKey: function (t, e) {
                        if (!x(t))
                            return "symbol" == typeof t
                                ? t
                                : ("string" == typeof t ? "S" : "P") + t;
                        if (!S(t, r)) {
                            if (!n(t)) return "F";
                            if (!e) return "E";
                            o(t);
                        }
                        return t[r].objectID;
                    },
                    getWeakData: function (t, e) {
                        if (!S(t, r)) {
                            if (!n(t)) return !0;
                            if (!e) return !1;
                            o(t);
                        }
                        return t[r].weakData;
                    },
                    onFreeze: function (t) {
                        return tr && s.REQUIRED && n(t) && !S(t, r) && o(t), t;
                    },
                });
            H[r] = !0;
        }),
        rr =
            (er.REQUIRED,
            er.fastKey,
            er.getWeakData,
            er.onFreeze,
            Wt("iterator")),
        ir = Array.prototype,
        nr = Wt("iterator"),
        or = function (t, e, r, i) {
            try {
                return i ? e(R(r)[0], r[1]) : e(r);
            } catch (e) {
                var n = t.return;
                throw (void 0 !== n && R(n.call(t)), e);
            }
        },
        sr = e(function (t) {
            var e = function (t, e) {
                (this.stopped = t), (this.result = e);
            };
            (t.exports = function (t, r, i, n, o) {
                var s,
                    a,
                    c,
                    l,
                    u,
                    f,
                    h,
                    d = Lt(r, i, n ? 2 : 1);
                if (o) s = t;
                else {
                    if (
                        "function" !=
                        typeof (a = (function (t) {
                            if (null != t)
                                return t[nr] || t["@@iterator"] || le[je(t)];
                        })(t))
                    )
                        throw TypeError("Target is not iterable");
                    if (
                        void 0 !== (h = a) &&
                        (le.Array === h || ir[rr] === h)
                    ) {
                        for (c = 0, l = st(t.length); l > c; c++)
                            if (
                                (u = n ? d(R((f = t[c]))[0], f[1]) : d(t[c])) &&
                                u instanceof e
                            )
                                return u;
                        return new e(!1);
                    }
                    s = a.call(t);
                }
                for (; !(f = s.next()).done; )
                    if ((u = or(s, d, f.value, n)) && u instanceof e) return u;
                return new e(!1);
            }).stop = function (t) {
                return new e(!0, t);
            };
        }),
        ar = function (t, e, r) {
            if (!(t instanceof e))
                throw TypeError(
                    "Incorrect " + (r ? r + " " : "") + "invocation"
                );
            return t;
        },
        cr = Wt("iterator"),
        lr = !1;
    try {
        var ur = 0,
            fr = {
                next: function () {
                    return { done: !!ur++ };
                },
                return: function () {
                    lr = !0;
                },
            };
        (fr[cr] = function () {
            return this;
        }),
            Array.from(fr, function () {
                throw 2;
            });
    } catch (t) {}
    var hr = function (t, e, r, i, n) {
            var o = a[t],
                s = o && o.prototype,
                l = o,
                u = i ? "set" : "add",
                f = {},
                h = function (t) {
                    var e = s[t];
                    J(
                        s,
                        t,
                        "add" == t
                            ? function (t) {
                                  return e.call(this, 0 === t ? 0 : t), this;
                              }
                            : "delete" == t
                            ? function (t) {
                                  return (
                                      !(n && !x(t)) &&
                                      e.call(this, 0 === t ? 0 : t)
                                  );
                              }
                            : "get" == t
                            ? function (t) {
                                  return n && !x(t)
                                      ? void 0
                                      : e.call(this, 0 === t ? 0 : t);
                              }
                            : "has" == t
                            ? function (t) {
                                  return (
                                      !(n && !x(t)) &&
                                      e.call(this, 0 === t ? 0 : t)
                                  );
                              }
                            : function (t, r) {
                                  return e.call(this, 0 === t ? 0 : t, r), this;
                              }
                    );
                };
            if (
                Ot(
                    t,
                    "function" != typeof o ||
                        !(
                            n ||
                            (s.forEach &&
                                !c(function () {
                                    new o().entries().next();
                                }))
                        )
                )
            )
                (l = r.getConstructor(e, t, i, u)), (er.REQUIRED = !0);
            else if (Ot(t, !0)) {
                var d = new l(),
                    p = d[u](n ? {} : -0, 1) != d,
                    v = c(function () {
                        d.has(1);
                    }),
                    g = (function (t, e) {
                        if (!e && !lr) return !1;
                        var r = !1;
                        try {
                            var i = {};
                            (i[cr] = function () {
                                return {
                                    next: function () {
                                        return { done: (r = !0) };
                                    },
                                };
                            }),
                                t(i);
                        } catch (t) {}
                        return r;
                    })(function (t) {
                        new o(t);
                    }),
                    b =
                        !n &&
                        c(function () {
                            for (var t = new o(), e = 5; e--; ) t[u](e, e);
                            return !t.has(-0);
                        });
                g ||
                    (((l = e(function (e, r) {
                        ar(e, l, t);
                        var n = (function (t, e, r) {
                            var i, n;
                            return (
                                we &&
                                    "function" == typeof (i = e.constructor) &&
                                    i !== r &&
                                    x((n = i.prototype)) &&
                                    n !== r.prototype &&
                                    we(t, n),
                                t
                            );
                        })(new o(), e, l);
                        return null != r && sr(r, n[u], n, i), n;
                    })).prototype = s),
                    (s.constructor = l)),
                    (v || b) && (h("delete"), h("has"), i && h("get")),
                    (b || p) && h(u),
                    n && s.clear && delete s.clear;
            }
            return (
                (f[t] = l),
                At({ global: !0, forced: l != o }, f),
                me(l, t),
                n || r.setStrong(l, t, i),
                l
            );
        },
        dr = er.getWeakData,
        pr = K.set,
        vr = K.getterFor,
        gr = Dt.find,
        br = Dt.findIndex,
        yr = 0,
        mr = function (t) {
            return t.frozen || (t.frozen = new xr());
        },
        xr = function () {
            this.entries = [];
        },
        Er = function (t, e) {
            return gr(t.entries, function (t) {
                return t[0] === e;
            });
        };
    xr.prototype = {
        get: function (t) {
            var e = Er(this, t);
            if (e) return e[1];
        },
        has: function (t) {
            return !!Er(this, t);
        },
        set: function (t, e) {
            var r = Er(this, t);
            r ? (r[1] = e) : this.entries.push([t, e]);
        },
        delete: function (t) {
            var e = br(this.entries, function (e) {
                return e[0] === t;
            });
            return ~e && this.entries.splice(e, 1), !!~e;
        },
    };
    var wr = {
            getConstructor: function (t, e, r, i) {
                var n = t(function (t, o) {
                        ar(t, n, e),
                            pr(t, { type: e, id: yr++, frozen: void 0 }),
                            null != o && sr(o, t[i], t, r);
                    }),
                    o = vr(e),
                    s = function (t, e, r) {
                        var i = o(t),
                            n = dr(R(e), !0);
                        return !0 === n ? mr(i).set(e, r) : (n[i.id] = r), t;
                    };
                return (
                    Ze(n.prototype, {
                        delete: function (t) {
                            var e = o(this);
                            if (!x(t)) return !1;
                            var r = dr(t);
                            return !0 === r
                                ? mr(e).delete(t)
                                : r && S(r, e.id) && delete r[e.id];
                        },
                        has: function (t) {
                            var e = o(this);
                            if (!x(t)) return !1;
                            var r = dr(t);
                            return !0 === r ? mr(e).has(t) : r && S(r, e.id);
                        },
                    }),
                    Ze(
                        n.prototype,
                        r
                            ? {
                                  get: function (t) {
                                      var e = o(this);
                                      if (x(t)) {
                                          var r = dr(t);
                                          return !0 === r
                                              ? mr(e).get(t)
                                              : r
                                              ? r[e.id]
                                              : void 0;
                                      }
                                  },
                                  set: function (t, e) {
                                      return s(this, t, e);
                                  },
                              }
                            : {
                                  add: function (t) {
                                      return s(this, t, !0);
                                  },
                              }
                    ),
                    n
                );
            },
        },
        Sr =
            (e(function (t) {
                var e,
                    r = K.enforce,
                    i = !a.ActiveXObject && "ActiveXObject" in a,
                    n = Object.isExtensible,
                    o = function (t) {
                        return function () {
                            return t(
                                this,
                                arguments.length ? arguments[0] : void 0
                            );
                        };
                    },
                    s = (t.exports = hr("WeakMap", o, wr, !0, !0));
                if (B && i) {
                    (e = wr.getConstructor(o, "WeakMap", !0)),
                        (er.REQUIRED = !0);
                    var c = s.prototype,
                        l = c.delete,
                        u = c.has,
                        f = c.get,
                        h = c.set;
                    Ze(c, {
                        delete: function (t) {
                            if (x(t) && !n(t)) {
                                var i = r(this);
                                return (
                                    i.frozen || (i.frozen = new e()),
                                    l.call(this, t) || i.frozen.delete(t)
                                );
                            }
                            return l.call(this, t);
                        },
                        has: function (t) {
                            if (x(t) && !n(t)) {
                                var i = r(this);
                                return (
                                    i.frozen || (i.frozen = new e()),
                                    u.call(this, t) || i.frozen.has(t)
                                );
                            }
                            return u.call(this, t);
                        },
                        get: function (t) {
                            if (x(t) && !n(t)) {
                                var i = r(this);
                                return (
                                    i.frozen || (i.frozen = new e()),
                                    u.call(this, t)
                                        ? f.call(this, t)
                                        : i.frozen.get(t)
                                );
                            }
                            return f.call(this, t);
                        },
                        set: function (t, i) {
                            if (x(t) && !n(t)) {
                                var o = r(this);
                                o.frozen || (o.frozen = new e()),
                                    u.call(this, t)
                                        ? h.call(this, t, i)
                                        : o.frozen.set(t, i);
                            } else h.call(this, t, i);
                            return this;
                        },
                    });
                }
            }),
            Wt("iterator")),
        Or = Wt("toStringTag"),
        kr = Re.values;
    for (var Ar in Xt) {
        var Tr = a[Ar],
            Lr = Tr && Tr.prototype;
        if (Lr) {
            if (Lr[Sr] !== kr)
                try {
                    C(Lr, Sr, kr);
                } catch (t) {
                    Lr[Sr] = kr;
                }
            if ((Lr[Or] || C(Lr, Or, Ar), Xt[Ar]))
                for (var zr in Re)
                    if (Lr[zr] !== Re[zr])
                        try {
                            C(Lr, zr, Re[zr]);
                        } catch (t) {
                            Lr[zr] = Re[zr];
                        }
        }
    }
    var Rr = "Expected a function",
        _r = NaN,
        Mr = "[object Symbol]",
        Cr = /^\s+|\s+$/g,
        Wr = /^[-+]0x[0-9a-f]+$/i,
        jr = /^0b[01]+$/i,
        Nr = /^0o[0-7]+$/i,
        Ir = parseInt,
        Br = "object" == typeof t && t && t.Object === Object && t,
        Dr = "object" == typeof self && self && self.Object === Object && self,
        Pr = Br || Dr || Function("return this")(),
        Fr = Object.prototype.toString,
        Vr = Math.max,
        Xr = Math.min,
        Hr = function () {
            return Pr.Date.now();
        };
    function qr(t, e, r) {
        var i,
            n,
            o,
            s,
            a,
            c,
            l = 0,
            u = !1,
            f = !1,
            h = !0;
        if ("function" != typeof t) throw new TypeError(Rr);
        function d(e) {
            var r = i,
                o = n;
            return (i = n = void 0), (l = e), (s = t.apply(o, r));
        }
        function p(t) {
            var r = t - c;
            return void 0 === c || r >= e || r < 0 || (f && t - l >= o);
        }
        function v() {
            var t = Hr();
            if (p(t)) return g(t);
            a = setTimeout(
                v,
                (function (t) {
                    var r = e - (t - c);
                    return f ? Xr(r, o - (t - l)) : r;
                })(t)
            );
        }
        function g(t) {
            return (a = void 0), h && i ? d(t) : ((i = n = void 0), s);
        }
        function b() {
            var t = Hr(),
                r = p(t);
            if (((i = arguments), (n = this), (c = t), r)) {
                if (void 0 === a)
                    return (function (t) {
                        return (l = t), (a = setTimeout(v, e)), u ? d(t) : s;
                    })(c);
                if (f) return (a = setTimeout(v, e)), d(c);
            }
            return void 0 === a && (a = setTimeout(v, e)), s;
        }
        return (
            (e = Yr(e) || 0),
            $r(r) &&
                ((u = !!r.leading),
                (o = (f = "maxWait" in r) ? Vr(Yr(r.maxWait) || 0, e) : o),
                (h = "trailing" in r ? !!r.trailing : h)),
            (b.cancel = function () {
                void 0 !== a && clearTimeout(a),
                    (l = 0),
                    (i = c = n = a = void 0);
            }),
            (b.flush = function () {
                return void 0 === a ? s : g(Hr());
            }),
            b
        );
    }
    function $r(t) {
        var e = typeof t;
        return !!t && ("object" == e || "function" == e);
    }
    function Yr(t) {
        if ("number" == typeof t) return t;
        if (
            (function (t) {
                return (
                    "symbol" == typeof t ||
                    ((function (t) {
                        return !!t && "object" == typeof t;
                    })(t) &&
                        Fr.call(t) == Mr)
                );
            })(t)
        )
            return _r;
        if ($r(t)) {
            var e = "function" == typeof t.valueOf ? t.valueOf() : t;
            t = $r(e) ? e + "" : e;
        }
        if ("string" != typeof t) return 0 === t ? t : +t;
        t = t.replace(Cr, "");
        var r = jr.test(t);
        return r || Nr.test(t)
            ? Ir(t.slice(2), r ? 2 : 8)
            : Wr.test(t)
            ? _r
            : +t;
    }
    var Gr = function (t, e, r) {
            var i = !0,
                n = !0;
            if ("function" != typeof t) throw new TypeError(Rr);
            return (
                $r(r) &&
                    ((i = "leading" in r ? !!r.leading : i),
                    (n = "trailing" in r ? !!r.trailing : n)),
                qr(t, e, { leading: i, maxWait: e, trailing: n })
            );
        },
        Ur = "Expected a function",
        Qr = NaN,
        Kr = "[object Symbol]",
        Jr = /^\s+|\s+$/g,
        Zr = /^[-+]0x[0-9a-f]+$/i,
        ti = /^0b[01]+$/i,
        ei = /^0o[0-7]+$/i,
        ri = parseInt,
        ii = "object" == typeof t && t && t.Object === Object && t,
        ni = "object" == typeof self && self && self.Object === Object && self,
        oi = ii || ni || Function("return this")(),
        si = Object.prototype.toString,
        ai = Math.max,
        ci = Math.min,
        li = function () {
            return oi.Date.now();
        };
    function ui(t) {
        var e = typeof t;
        return !!t && ("object" == e || "function" == e);
    }
    function fi(t) {
        if ("number" == typeof t) return t;
        if (
            (function (t) {
                return (
                    "symbol" == typeof t ||
                    ((function (t) {
                        return !!t && "object" == typeof t;
                    })(t) &&
                        si.call(t) == Kr)
                );
            })(t)
        )
            return Qr;
        if (ui(t)) {
            var e = "function" == typeof t.valueOf ? t.valueOf() : t;
            t = ui(e) ? e + "" : e;
        }
        if ("string" != typeof t) return 0 === t ? t : +t;
        t = t.replace(Jr, "");
        var r = ti.test(t);
        return r || ei.test(t)
            ? ri(t.slice(2), r ? 2 : 8)
            : Zr.test(t)
            ? Qr
            : +t;
    }
    var hi = function (t, e, r) {
            var i,
                n,
                o,
                s,
                a,
                c,
                l = 0,
                u = !1,
                f = !1,
                h = !0;
            if ("function" != typeof t) throw new TypeError(Ur);
            function d(e) {
                var r = i,
                    o = n;
                return (i = n = void 0), (l = e), (s = t.apply(o, r));
            }
            function p(t) {
                var r = t - c;
                return void 0 === c || r >= e || r < 0 || (f && t - l >= o);
            }
            function v() {
                var t = li();
                if (p(t)) return g(t);
                a = setTimeout(
                    v,
                    (function (t) {
                        var r = e - (t - c);
                        return f ? ci(r, o - (t - l)) : r;
                    })(t)
                );
            }
            function g(t) {
                return (a = void 0), h && i ? d(t) : ((i = n = void 0), s);
            }
            function b() {
                var t = li(),
                    r = p(t);
                if (((i = arguments), (n = this), (c = t), r)) {
                    if (void 0 === a)
                        return (function (t) {
                            return (
                                (l = t), (a = setTimeout(v, e)), u ? d(t) : s
                            );
                        })(c);
                    if (f) return (a = setTimeout(v, e)), d(c);
                }
                return void 0 === a && (a = setTimeout(v, e)), s;
            }
            return (
                (e = fi(e) || 0),
                ui(r) &&
                    ((u = !!r.leading),
                    (o = (f = "maxWait" in r) ? ai(fi(r.maxWait) || 0, e) : o),
                    (h = "trailing" in r ? !!r.trailing : h)),
                (b.cancel = function () {
                    void 0 !== a && clearTimeout(a),
                        (l = 0),
                        (i = c = n = a = void 0);
                }),
                (b.flush = function () {
                    return void 0 === a ? s : g(li());
                }),
                b
            );
        },
        di = "Expected a function",
        pi = "__lodash_hash_undefined__",
        vi = "[object Function]",
        gi = "[object GeneratorFunction]",
        bi = /^\[object .+?Constructor\]$/,
        yi = "object" == typeof t && t && t.Object === Object && t,
        mi = "object" == typeof self && self && self.Object === Object && self,
        xi = yi || mi || Function("return this")();
    var Ei = Array.prototype,
        wi = Function.prototype,
        Si = Object.prototype,
        Oi = xi["__core-js_shared__"],
        ki = (function () {
            var t = /[^.]+$/.exec((Oi && Oi.keys && Oi.keys.IE_PROTO) || "");
            return t ? "Symbol(src)_1." + t : "";
        })(),
        Ai = wi.toString,
        Ti = Si.hasOwnProperty,
        Li = Si.toString,
        zi = RegExp(
            "^" +
                Ai.call(Ti)
                    .replace(/[\\^$.*+?()[\]{}|]/g, "\\$&")
                    .replace(
                        /hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g,
                        "$1.*?"
                    ) +
                "$"
        ),
        Ri = Ei.splice,
        _i = Di(xi, "Map"),
        Mi = Di(Object, "create");
    function Ci(t) {
        var e = -1,
            r = t ? t.length : 0;
        for (this.clear(); ++e < r; ) {
            var i = t[e];
            this.set(i[0], i[1]);
        }
    }
    function Wi(t) {
        var e = -1,
            r = t ? t.length : 0;
        for (this.clear(); ++e < r; ) {
            var i = t[e];
            this.set(i[0], i[1]);
        }
    }
    function ji(t) {
        var e = -1,
            r = t ? t.length : 0;
        for (this.clear(); ++e < r; ) {
            var i = t[e];
            this.set(i[0], i[1]);
        }
    }
    function Ni(t, e) {
        for (var r, i, n = t.length; n--; )
            if ((r = t[n][0]) === (i = e) || (r != r && i != i)) return n;
        return -1;
    }
    function Ii(t) {
        return (
            !(!Fi(t) || ((e = t), ki && ki in e)) &&
            ((function (t) {
                var e = Fi(t) ? Li.call(t) : "";
                return e == vi || e == gi;
            })(t) ||
            (function (t) {
                var e = !1;
                if (null != t && "function" != typeof t.toString)
                    try {
                        e = !!(t + "");
                    } catch (t) {}
                return e;
            })(t)
                ? zi
                : bi
            ).test(
                (function (t) {
                    if (null != t) {
                        try {
                            return Ai.call(t);
                        } catch (t) {}
                        try {
                            return t + "";
                        } catch (t) {}
                    }
                    return "";
                })(t)
            )
        );
        var e;
    }
    function Bi(t, e) {
        var r,
            i,
            n = t.__data__;
        return (
            "string" == (i = typeof (r = e)) ||
            "number" == i ||
            "symbol" == i ||
            "boolean" == i
                ? "__proto__" !== r
                : null === r
        )
            ? n["string" == typeof e ? "string" : "hash"]
            : n.map;
    }
    function Di(t, e) {
        var r = (function (t, e) {
            return null == t ? void 0 : t[e];
        })(t, e);
        return Ii(r) ? r : void 0;
    }
    function Pi(t, e) {
        if ("function" != typeof t || (e && "function" != typeof e))
            throw new TypeError(di);
        var r = function () {
            var i = arguments,
                n = e ? e.apply(this, i) : i[0],
                o = r.cache;
            if (o.has(n)) return o.get(n);
            var s = t.apply(this, i);
            return (r.cache = o.set(n, s)), s;
        };
        return (r.cache = new (Pi.Cache || ji)()), r;
    }
    function Fi(t) {
        var e = typeof t;
        return !!t && ("object" == e || "function" == e);
    }
    (Ci.prototype.clear = function () {
        this.__data__ = Mi ? Mi(null) : {};
    }),
        (Ci.prototype.delete = function (t) {
            return this.has(t) && delete this.__data__[t];
        }),
        (Ci.prototype.get = function (t) {
            var e = this.__data__;
            if (Mi) {
                var r = e[t];
                return r === pi ? void 0 : r;
            }
            return Ti.call(e, t) ? e[t] : void 0;
        }),
        (Ci.prototype.has = function (t) {
            var e = this.__data__;
            return Mi ? void 0 !== e[t] : Ti.call(e, t);
        }),
        (Ci.prototype.set = function (t, e) {
            return (this.__data__[t] = Mi && void 0 === e ? pi : e), this;
        }),
        (Wi.prototype.clear = function () {
            this.__data__ = [];
        }),
        (Wi.prototype.delete = function (t) {
            var e = this.__data__,
                r = Ni(e, t);
            return (
                !(r < 0) && (r == e.length - 1 ? e.pop() : Ri.call(e, r, 1), !0)
            );
        }),
        (Wi.prototype.get = function (t) {
            var e = this.__data__,
                r = Ni(e, t);
            return r < 0 ? void 0 : e[r][1];
        }),
        (Wi.prototype.has = function (t) {
            return Ni(this.__data__, t) > -1;
        }),
        (Wi.prototype.set = function (t, e) {
            var r = this.__data__,
                i = Ni(r, t);
            return i < 0 ? r.push([t, e]) : (r[i][1] = e), this;
        }),
        (ji.prototype.clear = function () {
            this.__data__ = {
                hash: new Ci(),
                map: new (_i || Wi)(),
                string: new Ci(),
            };
        }),
        (ji.prototype.delete = function (t) {
            return Bi(this, t).delete(t);
        }),
        (ji.prototype.get = function (t) {
            return Bi(this, t).get(t);
        }),
        (ji.prototype.has = function (t) {
            return Bi(this, t).has(t);
        }),
        (ji.prototype.set = function (t, e) {
            return Bi(this, t).set(t, e), this;
        }),
        (Pi.Cache = ji);
    var Vi,
        Xi = Pi,
        Hi = [],
        qi = "ResizeObserver loop completed with undelivered notifications.";
    !(function (t) {
        (t.BORDER_BOX = "border-box"),
            (t.CONTENT_BOX = "content-box"),
            (t.DEVICE_PIXEL_CONTENT_BOX = "device-pixel-content-box");
    })(Vi || (Vi = {}));
    var $i,
        Yi = function (t) {
            return Object.freeze(t);
        },
        Gi = function (t, e) {
            (this.inlineSize = t), (this.blockSize = e), Yi(this);
        },
        Ui = (function () {
            function t(t, e, r, i) {
                return (
                    (this.x = t),
                    (this.y = e),
                    (this.width = r),
                    (this.height = i),
                    (this.top = this.y),
                    (this.left = this.x),
                    (this.bottom = this.top + this.height),
                    (this.right = this.left + this.width),
                    Yi(this)
                );
            }
            return (
                (t.prototype.toJSON = function () {
                    var t = this;
                    return {
                        x: t.x,
                        y: t.y,
                        top: t.top,
                        right: t.right,
                        bottom: t.bottom,
                        left: t.left,
                        width: t.width,
                        height: t.height,
                    };
                }),
                (t.fromRect = function (e) {
                    return new t(e.x, e.y, e.width, e.height);
                }),
                t
            );
        })(),
        Qi = function (t) {
            return t instanceof SVGElement && "getBBox" in t;
        },
        Ki = function (t) {
            if (Qi(t)) {
                var e = t.getBBox(),
                    r = e.width,
                    i = e.height;
                return !r && !i;
            }
            var n = t,
                o = n.offsetWidth,
                s = n.offsetHeight;
            return !(o || s || t.getClientRects().length);
        },
        Ji = function (t) {
            var e, r;
            if (t instanceof Element) return !0;
            var i =
                null ===
                    (r =
                        null === (e = t) || void 0 === e
                            ? void 0
                            : e.ownerDocument) || void 0 === r
                    ? void 0
                    : r.defaultView;
            return !!(i && t instanceof i.Element);
        },
        Zi = "undefined" != typeof window ? window : {},
        tn = new WeakMap(),
        en = /auto|scroll/,
        rn = /^tb|vertical/,
        nn = /msie|trident/i.test(Zi.navigator && Zi.navigator.userAgent),
        on = function (t) {
            return parseFloat(t || "0");
        },
        sn = function (t, e, r) {
            return (
                void 0 === t && (t = 0),
                void 0 === e && (e = 0),
                void 0 === r && (r = !1),
                new Gi((r ? e : t) || 0, (r ? t : e) || 0)
            );
        },
        an = Yi({
            devicePixelContentBoxSize: sn(),
            borderBoxSize: sn(),
            contentBoxSize: sn(),
            contentRect: new Ui(0, 0, 0, 0),
        }),
        cn = function (t, e) {
            if ((void 0 === e && (e = !1), tn.has(t) && !e)) return tn.get(t);
            if (Ki(t)) return tn.set(t, an), an;
            var r = getComputedStyle(t),
                i = Qi(t) && t.ownerSVGElement && t.getBBox(),
                n = !nn && "border-box" === r.boxSizing,
                o = rn.test(r.writingMode || ""),
                s = !i && en.test(r.overflowY || ""),
                a = !i && en.test(r.overflowX || ""),
                c = i ? 0 : on(r.paddingTop),
                l = i ? 0 : on(r.paddingRight),
                u = i ? 0 : on(r.paddingBottom),
                f = i ? 0 : on(r.paddingLeft),
                h = i ? 0 : on(r.borderTopWidth),
                d = i ? 0 : on(r.borderRightWidth),
                p = i ? 0 : on(r.borderBottomWidth),
                v = f + l,
                g = c + u,
                b = (i ? 0 : on(r.borderLeftWidth)) + d,
                y = h + p,
                m = a ? t.offsetHeight - y - t.clientHeight : 0,
                x = s ? t.offsetWidth - b - t.clientWidth : 0,
                E = n ? v + b : 0,
                w = n ? g + y : 0,
                S = i ? i.width : on(r.width) - E - x,
                O = i ? i.height : on(r.height) - w - m,
                k = S + v + x + b,
                A = O + g + m + y,
                T = Yi({
                    devicePixelContentBoxSize: sn(
                        Math.round(S * devicePixelRatio),
                        Math.round(O * devicePixelRatio),
                        o
                    ),
                    borderBoxSize: sn(k, A, o),
                    contentBoxSize: sn(S, O, o),
                    contentRect: new Ui(f, c, S, O),
                });
            return tn.set(t, T), T;
        },
        ln = function (t, e, r) {
            var i = cn(t, r),
                n = i.borderBoxSize,
                o = i.contentBoxSize,
                s = i.devicePixelContentBoxSize;
            switch (e) {
                case Vi.DEVICE_PIXEL_CONTENT_BOX:
                    return s;
                case Vi.BORDER_BOX:
                    return n;
                default:
                    return o;
            }
        },
        un = function (t) {
            var e = cn(t);
            (this.target = t),
                (this.contentRect = e.contentRect),
                (this.borderBoxSize = Yi([e.borderBoxSize])),
                (this.contentBoxSize = Yi([e.contentBoxSize])),
                (this.devicePixelContentBoxSize = Yi([
                    e.devicePixelContentBoxSize,
                ]));
        },
        fn = function (t) {
            if (Ki(t)) return 1 / 0;
            for (var e = 0, r = t.parentNode; r; ) (e += 1), (r = r.parentNode);
            return e;
        },
        hn = function () {
            var t = 1 / 0,
                e = [];
            Hi.forEach(function (r) {
                if (0 !== r.activeTargets.length) {
                    var i = [];
                    r.activeTargets.forEach(function (e) {
                        var r = new un(e.target),
                            n = fn(e.target);
                        i.push(r),
                            (e.lastReportedSize = ln(e.target, e.observedBox)),
                            n < t && (t = n);
                    }),
                        e.push(function () {
                            r.callback.call(r.observer, i, r.observer);
                        }),
                        r.activeTargets.splice(0, r.activeTargets.length);
                }
            });
            for (var r = 0, i = e; r < i.length; r++) {
                (0, i[r])();
            }
            return t;
        },
        dn = function (t) {
            Hi.forEach(function (e) {
                e.activeTargets.splice(0, e.activeTargets.length),
                    e.skippedTargets.splice(0, e.skippedTargets.length),
                    e.observationTargets.forEach(function (r) {
                        r.isActive() &&
                            (fn(r.target) > t
                                ? e.activeTargets.push(r)
                                : e.skippedTargets.push(r));
                    });
            });
        },
        pn = function () {
            var t,
                e = 0;
            for (
                dn(e);
                Hi.some(function (t) {
                    return t.activeTargets.length > 0;
                });

            )
                (e = hn()), dn(e);
            return (
                Hi.some(function (t) {
                    return t.skippedTargets.length > 0;
                }) &&
                    ("function" == typeof ErrorEvent
                        ? (t = new ErrorEvent("error", { message: qi }))
                        : ((t = document.createEvent("Event")).initEvent(
                              "error",
                              !1,
                              !1
                          ),
                          (t.message = qi)),
                    window.dispatchEvent(t)),
                e > 0
            );
        },
        vn = [],
        gn = function (t) {
            if (!$i) {
                var e = 0,
                    r = document.createTextNode("");
                new MutationObserver(function () {
                    return vn.splice(0).forEach(function (t) {
                        return t();
                    });
                }).observe(r, { characterData: !0 }),
                    ($i = function () {
                        r.textContent = "" + (e ? e-- : e++);
                    });
            }
            vn.push(t), $i();
        },
        bn = 0,
        yn = { attributes: !0, characterData: !0, childList: !0, subtree: !0 },
        mn = [
            "resize",
            "load",
            "transitionend",
            "animationend",
            "animationstart",
            "animationiteration",
            "keyup",
            "keydown",
            "mouseup",
            "mousedown",
            "mouseover",
            "mouseout",
            "blur",
            "focus",
        ],
        xn = function (t) {
            return void 0 === t && (t = 0), Date.now() + t;
        },
        En = !1,
        wn = new ((function () {
            function t() {
                var t = this;
                (this.stopped = !0),
                    (this.listener = function () {
                        return t.schedule();
                    });
            }
            return (
                (t.prototype.run = function (t) {
                    var e = this;
                    if ((void 0 === t && (t = 250), !En)) {
                        En = !0;
                        var r,
                            i = xn(t);
                        (r = function () {
                            var r = !1;
                            try {
                                r = pn();
                            } finally {
                                if (((En = !1), (t = i - xn()), !bn)) return;
                                r ? e.run(1e3) : t > 0 ? e.run(t) : e.start();
                            }
                        }),
                            gn(function () {
                                requestAnimationFrame(r);
                            });
                    }
                }),
                (t.prototype.schedule = function () {
                    this.stop(), this.run();
                }),
                (t.prototype.observe = function () {
                    var t = this,
                        e = function () {
                            return (
                                t.observer &&
                                t.observer.observe(document.body, yn)
                            );
                        };
                    document.body
                        ? e()
                        : Zi.addEventListener("DOMContentLoaded", e);
                }),
                (t.prototype.start = function () {
                    var t = this;
                    this.stopped &&
                        ((this.stopped = !1),
                        (this.observer = new MutationObserver(this.listener)),
                        this.observe(),
                        mn.forEach(function (e) {
                            return Zi.addEventListener(e, t.listener, !0);
                        }));
                }),
                (t.prototype.stop = function () {
                    var t = this;
                    this.stopped ||
                        (this.observer && this.observer.disconnect(),
                        mn.forEach(function (e) {
                            return Zi.removeEventListener(e, t.listener, !0);
                        }),
                        (this.stopped = !0));
                }),
                t
            );
        })())(),
        Sn = function (t) {
            !bn && t > 0 && wn.start(), !(bn += t) && wn.stop();
        },
        On = (function () {
            function t(t, e) {
                (this.target = t),
                    (this.observedBox = e || Vi.CONTENT_BOX),
                    (this.lastReportedSize = { inlineSize: 0, blockSize: 0 });
            }
            return (
                (t.prototype.isActive = function () {
                    var t,
                        e = ln(this.target, this.observedBox, !0);
                    return (
                        (t = this.target),
                        Qi(t) ||
                            (function (t) {
                                switch (t.tagName) {
                                    case "INPUT":
                                        if ("image" !== t.type) break;
                                    case "VIDEO":
                                    case "AUDIO":
                                    case "EMBED":
                                    case "OBJECT":
                                    case "CANVAS":
                                    case "IFRAME":
                                    case "IMG":
                                        return !0;
                                }
                                return !1;
                            })(t) ||
                            "inline" !== getComputedStyle(t).display ||
                            (this.lastReportedSize = e),
                        this.lastReportedSize.inlineSize !== e.inlineSize ||
                            this.lastReportedSize.blockSize !== e.blockSize
                    );
                }),
                t
            );
        })(),
        kn = function (t, e) {
            (this.activeTargets = []),
                (this.skippedTargets = []),
                (this.observationTargets = []),
                (this.observer = t),
                (this.callback = e);
        },
        An = new WeakMap(),
        Tn = function (t, e) {
            for (var r = 0; r < t.length; r += 1)
                if (t[r].target === e) return r;
            return -1;
        },
        Ln = (function () {
            function t() {}
            return (
                (t.connect = function (t, e) {
                    var r = new kn(t, e);
                    An.set(t, r);
                }),
                (t.observe = function (t, e, r) {
                    var i = An.get(t),
                        n = 0 === i.observationTargets.length;
                    Tn(i.observationTargets, e) < 0 &&
                        (n && Hi.push(i),
                        i.observationTargets.push(new On(e, r && r.box)),
                        Sn(1),
                        wn.schedule());
                }),
                (t.unobserve = function (t, e) {
                    var r = An.get(t),
                        i = Tn(r.observationTargets, e),
                        n = 1 === r.observationTargets.length;
                    i >= 0 &&
                        (n && Hi.splice(Hi.indexOf(r), 1),
                        r.observationTargets.splice(i, 1),
                        Sn(-1));
                }),
                (t.disconnect = function (t) {
                    var e = this,
                        r = An.get(t);
                    r.observationTargets.slice().forEach(function (r) {
                        return e.unobserve(t, r.target);
                    }),
                        r.activeTargets.splice(0, r.activeTargets.length);
                }),
                t
            );
        })(),
        zn = (function () {
            function t(t) {
                if (0 === arguments.length)
                    throw new TypeError(
                        "Failed to construct 'ResizeObserver': 1 argument required, but only 0 present."
                    );
                if ("function" != typeof t)
                    throw new TypeError(
                        "Failed to construct 'ResizeObserver': The callback provided as parameter 1 is not a function."
                    );
                Ln.connect(this, t);
            }
            return (
                (t.prototype.observe = function (t, e) {
                    if (0 === arguments.length)
                        throw new TypeError(
                            "Failed to execute 'observe' on 'ResizeObserver': 1 argument required, but only 0 present."
                        );
                    if (!Ji(t))
                        throw new TypeError(
                            "Failed to execute 'observe' on 'ResizeObserver': parameter 1 is not of type 'Element"
                        );
                    Ln.observe(this, t, e);
                }),
                (t.prototype.unobserve = function (t) {
                    if (0 === arguments.length)
                        throw new TypeError(
                            "Failed to execute 'unobserve' on 'ResizeObserver': 1 argument required, but only 0 present."
                        );
                    if (!Ji(t))
                        throw new TypeError(
                            "Failed to execute 'unobserve' on 'ResizeObserver': parameter 1 is not of type 'Element"
                        );
                    Ln.unobserve(this, t);
                }),
                (t.prototype.disconnect = function () {
                    Ln.disconnect(this);
                }),
                (t.toString = function () {
                    return "function ResizeObserver () { [polyfill code] }";
                }),
                t
            );
        })(),
        Rn = function (t) {
            return function (e, r, i, n) {
                Tt(r);
                var o = zt(e),
                    s = b(o),
                    a = st(o.length),
                    c = t ? a - 1 : 0,
                    l = t ? -1 : 1;
                if (i < 2)
                    for (;;) {
                        if (c in s) {
                            (n = s[c]), (c += l);
                            break;
                        }
                        if (((c += l), t ? c < 0 : a <= c))
                            throw TypeError(
                                "Reduce of empty array with no initial value"
                            );
                    }
                for (; t ? c >= 0 : a > c; c += l)
                    c in s && (n = r(n, s[c], c, o));
                return n;
            };
        },
        _n = { left: Rn(!1), right: Rn(!0) }.left;
    At(
        { target: "Array", proto: !0, forced: Pt("reduce") },
        {
            reduce: function (t) {
                return _n(
                    this,
                    t,
                    arguments.length,
                    arguments.length > 1 ? arguments[1] : void 0
                );
            },
        }
    );
    var Mn = M.f,
        Cn = Function.prototype,
        Wn = Cn.toString,
        jn = /^\s*function ([^ (]*)/;
    !l ||
        "name" in Cn ||
        Mn(Cn, "name", {
            configurable: !0,
            get: function () {
                try {
                    return Wn.call(this).match(jn)[1];
                } catch (t) {
                    return "";
                }
            },
        });
    var Nn,
        In,
        Bn = function () {
            var t = R(this),
                e = "";
            return (
                t.global && (e += "g"),
                t.ignoreCase && (e += "i"),
                t.multiline && (e += "m"),
                t.dotAll && (e += "s"),
                t.unicode && (e += "u"),
                t.sticky && (e += "y"),
                e
            );
        },
        Dn = RegExp.prototype.exec,
        Pn = String.prototype.replace,
        Fn = Dn,
        Vn =
            ((Nn = /a/),
            (In = /b*/g),
            Dn.call(Nn, "a"),
            Dn.call(In, "a"),
            0 !== Nn.lastIndex || 0 !== In.lastIndex),
        Xn = void 0 !== /()??/.exec("")[1];
    (Vn || Xn) &&
        (Fn = function (t) {
            var e,
                r,
                i,
                n,
                o = this;
            return (
                Xn && (r = new RegExp("^" + o.source + "$(?!\\s)", Bn.call(o))),
                Vn && (e = o.lastIndex),
                (i = Dn.call(o, t)),
                Vn && i && (o.lastIndex = o.global ? i.index + i[0].length : e),
                Xn &&
                    i &&
                    i.length > 1 &&
                    Pn.call(i[0], r, function () {
                        for (n = 1; n < arguments.length - 2; n++)
                            void 0 === arguments[n] && (i[n] = void 0);
                    }),
                i
            );
        });
    var Hn = Fn;
    At({ target: "RegExp", proto: !0, forced: /./.exec !== Hn }, { exec: Hn });
    var qn = Wt("species"),
        $n = !c(function () {
            var t = /./;
            return (
                (t.exec = function () {
                    var t = [];
                    return (t.groups = { a: "7" }), t;
                }),
                "7" !== "".replace(t, "$<a>")
            );
        }),
        Yn = !c(function () {
            var t = /(?:)/,
                e = t.exec;
            t.exec = function () {
                return e.apply(this, arguments);
            };
            var r = "ab".split(t);
            return 2 !== r.length || "a" !== r[0] || "b" !== r[1];
        }),
        Gn = function (t, e, r, i) {
            var n = Wt(t),
                o = !c(function () {
                    var e = {};
                    return (
                        (e[n] = function () {
                            return 7;
                        }),
                        7 != ""[t](e)
                    );
                }),
                s =
                    o &&
                    !c(function () {
                        var e = !1,
                            r = /a/;
                        return (
                            (r.exec = function () {
                                return (e = !0), null;
                            }),
                            "split" === t &&
                                ((r.constructor = {}),
                                (r.constructor[qn] = function () {
                                    return r;
                                })),
                            r[n](""),
                            !e
                        );
                    });
            if (
                !o ||
                !s ||
                ("replace" === t && !$n) ||
                ("split" === t && !Yn)
            ) {
                var a = /./[n],
                    l = r(n, ""[t], function (t, e, r, i, n) {
                        return e.exec === Hn
                            ? o && !n
                                ? { done: !0, value: a.call(e, r, i) }
                                : { done: !0, value: t.call(r, e, i) }
                            : { done: !1 };
                    }),
                    u = l[0],
                    f = l[1];
                J(String.prototype, t, u),
                    J(
                        RegExp.prototype,
                        n,
                        2 == e
                            ? function (t, e) {
                                  return f.call(t, this, e);
                              }
                            : function (t) {
                                  return f.call(t, this);
                              }
                    ),
                    i && C(RegExp.prototype[n], "sham", !0);
            }
        },
        Un = Ue.charAt,
        Qn = function (t, e, r) {
            return e + (r ? Un(t, e).length : 1);
        },
        Kn = function (t, e) {
            var r = t.exec;
            if ("function" == typeof r) {
                var i = r.call(t, e);
                if ("object" != typeof i)
                    throw TypeError(
                        "RegExp exec method returned something other than an Object or null"
                    );
                return i;
            }
            if ("RegExp" !== v(t))
                throw TypeError("RegExp#exec called on incompatible receiver");
            return Hn.call(t, e);
        };
    Gn("match", 1, function (t, e, r) {
        return [
            function (e) {
                var r = y(this),
                    i = null == e ? void 0 : e[t];
                return void 0 !== i
                    ? i.call(e, r)
                    : new RegExp(e)[t](String(r));
            },
            function (t) {
                var i = r(e, t, this);
                if (i.done) return i.value;
                var n = R(t),
                    o = String(this);
                if (!n.global) return Kn(n, o);
                var s = n.unicode;
                n.lastIndex = 0;
                for (var a, c = [], l = 0; null !== (a = Kn(n, o)); ) {
                    var u = String(a[0]);
                    (c[l] = u),
                        "" === u && (n.lastIndex = Qn(o, st(n.lastIndex), s)),
                        l++;
                }
                return 0 === l ? null : c;
            },
        ];
    });
    var Jn = Math.max,
        Zn = Math.min,
        to = Math.floor,
        eo = /\$([$&'`]|\d\d?|<[^>]*>)/g,
        ro = /\$([$&'`]|\d\d?)/g;
    Gn("replace", 2, function (t, e, r) {
        return [
            function (r, i) {
                var n = y(this),
                    o = null == r ? void 0 : r[t];
                return void 0 !== o ? o.call(r, n, i) : e.call(String(n), r, i);
            },
            function (t, n) {
                var o = r(e, t, this, n);
                if (o.done) return o.value;
                var s = R(t),
                    a = String(this),
                    c = "function" == typeof n;
                c || (n = String(n));
                var l = s.global;
                if (l) {
                    var u = s.unicode;
                    s.lastIndex = 0;
                }
                for (var f = []; ; ) {
                    var h = Kn(s, a);
                    if (null === h) break;
                    if ((f.push(h), !l)) break;
                    "" === String(h[0]) &&
                        (s.lastIndex = Qn(a, st(s.lastIndex), u));
                }
                for (var d, p = "", v = 0, g = 0; g < f.length; g++) {
                    h = f[g];
                    for (
                        var b = String(h[0]),
                            y = Jn(Zn(nt(h.index), a.length), 0),
                            m = [],
                            x = 1;
                        x < h.length;
                        x++
                    )
                        m.push(void 0 === (d = h[x]) ? d : String(d));
                    var E = h.groups;
                    if (c) {
                        var w = [b].concat(m, y, a);
                        void 0 !== E && w.push(E);
                        var S = String(n.apply(void 0, w));
                    } else S = i(b, a, y, m, E, n);
                    y >= v && ((p += a.slice(v, y) + S), (v = y + b.length));
                }
                return p + a.slice(v);
            },
        ];
        function i(t, r, i, n, o, s) {
            var a = i + t.length,
                c = n.length,
                l = ro;
            return (
                void 0 !== o && ((o = zt(o)), (l = eo)),
                e.call(s, l, function (e, s) {
                    var l;
                    switch (s.charAt(0)) {
                        case "$":
                            return "$";
                        case "&":
                            return t;
                        case "`":
                            return r.slice(0, i);
                        case "'":
                            return r.slice(a);
                        case "<":
                            l = o[s.slice(1, -1)];
                            break;
                        default:
                            var u = +s;
                            if (0 === u) return e;
                            if (u > c) {
                                var f = to(u / 10);
                                return 0 === f
                                    ? e
                                    : f <= c
                                    ? void 0 === n[f - 1]
                                        ? s.charAt(1)
                                        : n[f - 1] + s.charAt(1)
                                    : e;
                            }
                            l = n[u - 1];
                    }
                    return void 0 === l ? "" : l;
                })
            );
        }
    });
    var io = function (t) {
        return Array.prototype.reduce.call(
            t,
            function (t, e) {
                var r = e.name.match(/data-simplebar-(.+)/);
                if (r) {
                    var i = r[1].replace(/\W+(.)/g, function (t, e) {
                        return e.toUpperCase();
                    });
                    switch (e.value) {
                        case "true":
                            t[i] = !0;
                            break;
                        case "false":
                            t[i] = !1;
                            break;
                        case void 0:
                            t[i] = !0;
                            break;
                        default:
                            t[i] = e.value;
                    }
                }
                return t;
            },
            {}
        );
    };
    function no(t) {
        return t && t.ownerDocument && t.ownerDocument.defaultView
            ? t.ownerDocument.defaultView
            : window;
    }
    function oo(t) {
        return t && t.ownerDocument ? t.ownerDocument : document;
    }
    var so = null,
        ao = null;
    function co(t) {
        if (null === so) {
            var e = oo(t);
            if (void 0 === e) return (so = 0);
            var r = e.body,
                i = e.createElement("div");
            i.classList.add("simplebar-hide-scrollbar"), r.appendChild(i);
            var n = i.getBoundingClientRect().right;
            r.removeChild(i), (so = n);
        }
        return so;
    }
    Yt &&
        window.addEventListener("resize", function () {
            ao !== window.devicePixelRatio &&
                ((ao = window.devicePixelRatio), (so = null));
        });
    var lo = (function () {
        function t(e, r) {
            var i = this;
            (this.onScroll = function () {
                var t = no(i.el);
                i.scrollXTicking ||
                    (t.requestAnimationFrame(i.scrollX),
                    (i.scrollXTicking = !0)),
                    i.scrollYTicking ||
                        (t.requestAnimationFrame(i.scrollY),
                        (i.scrollYTicking = !0));
            }),
                (this.scrollX = function () {
                    i.axis.x.isOverflowing &&
                        (i.showScrollbar("x"), i.positionScrollbar("x")),
                        (i.scrollXTicking = !1);
                }),
                (this.scrollY = function () {
                    i.axis.y.isOverflowing &&
                        (i.showScrollbar("y"), i.positionScrollbar("y")),
                        (i.scrollYTicking = !1);
                }),
                (this.onMouseEnter = function () {
                    i.showScrollbar("x"), i.showScrollbar("y");
                }),
                (this.onMouseMove = function (t) {
                    (i.mouseX = t.clientX),
                        (i.mouseY = t.clientY),
                        (i.axis.x.isOverflowing || i.axis.x.forceVisible) &&
                            i.onMouseMoveForAxis("x"),
                        (i.axis.y.isOverflowing || i.axis.y.forceVisible) &&
                            i.onMouseMoveForAxis("y");
                }),
                (this.onMouseLeave = function () {
                    i.onMouseMove.cancel(),
                        (i.axis.x.isOverflowing || i.axis.x.forceVisible) &&
                            i.onMouseLeaveForAxis("x"),
                        (i.axis.y.isOverflowing || i.axis.y.forceVisible) &&
                            i.onMouseLeaveForAxis("y"),
                        (i.mouseX = -1),
                        (i.mouseY = -1);
                }),
                (this.onWindowResize = function () {
                    (i.scrollbarWidth = i.getScrollbarWidth()),
                        i.hideNativeScrollbar();
                }),
                (this.hideScrollbars = function () {
                    (i.axis.x.track.rect =
                        i.axis.x.track.el.getBoundingClientRect()),
                        (i.axis.y.track.rect =
                            i.axis.y.track.el.getBoundingClientRect()),
                        i.isWithinBounds(i.axis.y.track.rect) ||
                            (i.axis.y.scrollbar.el.classList.remove(
                                i.classNames.visible
                            ),
                            (i.axis.y.isVisible = !1)),
                        i.isWithinBounds(i.axis.x.track.rect) ||
                            (i.axis.x.scrollbar.el.classList.remove(
                                i.classNames.visible
                            ),
                            (i.axis.x.isVisible = !1));
                }),
                (this.onPointerEvent = function (t) {
                    var e, r;
                    (i.axis.x.track.rect =
                        i.axis.x.track.el.getBoundingClientRect()),
                        (i.axis.y.track.rect =
                            i.axis.y.track.el.getBoundingClientRect()),
                        (i.axis.x.isOverflowing || i.axis.x.forceVisible) &&
                            (e = i.isWithinBounds(i.axis.x.track.rect)),
                        (i.axis.y.isOverflowing || i.axis.y.forceVisible) &&
                            (r = i.isWithinBounds(i.axis.y.track.rect)),
                        (e || r) &&
                            (t.preventDefault(),
                            t.stopPropagation(),
                            "mousedown" === t.type &&
                                (e &&
                                    ((i.axis.x.scrollbar.rect =
                                        i.axis.x.scrollbar.el.getBoundingClientRect()),
                                    i.isWithinBounds(i.axis.x.scrollbar.rect)
                                        ? i.onDragStart(t, "x")
                                        : i.onTrackClick(t, "x")),
                                r &&
                                    ((i.axis.y.scrollbar.rect =
                                        i.axis.y.scrollbar.el.getBoundingClientRect()),
                                    i.isWithinBounds(i.axis.y.scrollbar.rect)
                                        ? i.onDragStart(t, "y")
                                        : i.onTrackClick(t, "y"))));
                }),
                (this.drag = function (e) {
                    var r = i.axis[i.draggedAxis].track,
                        n = r.rect[i.axis[i.draggedAxis].sizeAttr],
                        o = i.axis[i.draggedAxis].scrollbar,
                        s =
                            i.contentWrapperEl[
                                i.axis[i.draggedAxis].scrollSizeAttr
                            ],
                        a = parseInt(
                            i.elStyles[i.axis[i.draggedAxis].sizeAttr],
                            10
                        );
                    e.preventDefault(), e.stopPropagation();
                    var c =
                        ((("y" === i.draggedAxis ? e.pageY : e.pageX) -
                            r.rect[i.axis[i.draggedAxis].offsetAttr] -
                            i.axis[i.draggedAxis].dragOffset) /
                            (n - o.size)) *
                        (s - a);
                    "x" === i.draggedAxis &&
                        ((c =
                            i.isRtl && t.getRtlHelpers().isRtlScrollbarInverted
                                ? c - (n + o.size)
                                : c),
                        (c =
                            i.isRtl && t.getRtlHelpers().isRtlScrollingInverted
                                ? -c
                                : c)),
                        (i.contentWrapperEl[
                            i.axis[i.draggedAxis].scrollOffsetAttr
                        ] = c);
                }),
                (this.onEndDrag = function (t) {
                    var e = oo(i.el),
                        r = no(i.el);
                    t.preventDefault(),
                        t.stopPropagation(),
                        i.el.classList.remove(i.classNames.dragging),
                        e.removeEventListener("mousemove", i.drag, !0),
                        e.removeEventListener("mouseup", i.onEndDrag, !0),
                        (i.removePreventClickId = r.setTimeout(function () {
                            e.removeEventListener("click", i.preventClick, !0),
                                e.removeEventListener(
                                    "dblclick",
                                    i.preventClick,
                                    !0
                                ),
                                (i.removePreventClickId = null);
                        }));
                }),
                (this.preventClick = function (t) {
                    t.preventDefault(), t.stopPropagation();
                }),
                (this.el = e),
                (this.minScrollbarWidth = 20),
                (this.options = Object.assign({}, t.defaultOptions, {}, r)),
                (this.classNames = Object.assign(
                    {},
                    t.defaultOptions.classNames,
                    {},
                    this.options.classNames
                )),
                (this.axis = {
                    x: {
                        scrollOffsetAttr: "scrollLeft",
                        sizeAttr: "width",
                        scrollSizeAttr: "scrollWidth",
                        offsetSizeAttr: "offsetWidth",
                        offsetAttr: "left",
                        overflowAttr: "overflowX",
                        dragOffset: 0,
                        isOverflowing: !0,
                        isVisible: !1,
                        forceVisible: !1,
                        track: {},
                        scrollbar: {},
                    },
                    y: {
                        scrollOffsetAttr: "scrollTop",
                        sizeAttr: "height",
                        scrollSizeAttr: "scrollHeight",
                        offsetSizeAttr: "offsetHeight",
                        offsetAttr: "top",
                        overflowAttr: "overflowY",
                        dragOffset: 0,
                        isOverflowing: !0,
                        isVisible: !1,
                        forceVisible: !1,
                        track: {},
                        scrollbar: {},
                    },
                }),
                (this.removePreventClickId = null),
                t.instances.has(this.el) ||
                    ((this.recalculate = Gr(this.recalculate.bind(this), 64)),
                    (this.onMouseMove = Gr(this.onMouseMove.bind(this), 64)),
                    (this.hideScrollbars = hi(
                        this.hideScrollbars.bind(this),
                        this.options.timeout
                    )),
                    (this.onWindowResize = hi(
                        this.onWindowResize.bind(this),
                        64,
                        { leading: !0 }
                    )),
                    (t.getRtlHelpers = Xi(t.getRtlHelpers)),
                    this.init());
        }
        (t.getRtlHelpers = function () {
            var e = document.createElement("div");
            e.innerHTML =
                '<div class="hs-dummy-scrollbar-size"><div style="height: 200%; width: 200%; margin: 10px 0;"></div></div>';
            var r = e.firstElementChild;
            document.body.appendChild(r);
            var i = r.firstElementChild;
            r.scrollLeft = 0;
            var n = t.getOffset(r),
                o = t.getOffset(i);
            r.scrollLeft = 999;
            var s = t.getOffset(i);
            return {
                isRtlScrollingInverted:
                    n.left !== o.left && o.left - s.left != 0,
                isRtlScrollbarInverted: n.left !== o.left,
            };
        }),
            (t.getOffset = function (t) {
                var e = t.getBoundingClientRect(),
                    r = oo(t),
                    i = no(t);
                return {
                    top: e.top + (i.pageYOffset || r.documentElement.scrollTop),
                    left:
                        e.left +
                        (i.pageXOffset || r.documentElement.scrollLeft),
                };
            });
        var e = t.prototype;
        return (
            (e.init = function () {
                t.instances.set(this.el, this),
                    Yt &&
                        (this.initDOM(),
                        this.setAccessibilityAttributes(),
                        (this.scrollbarWidth = this.getScrollbarWidth()),
                        this.recalculate(),
                        this.initListeners());
            }),
            (e.initDOM = function () {
                var t = this;
                if (
                    Array.prototype.filter.call(this.el.children, function (e) {
                        return e.classList.contains(t.classNames.wrapper);
                    }).length
                )
                    (this.wrapperEl = this.el.querySelector(
                        "." + this.classNames.wrapper
                    )),
                        (this.contentWrapperEl =
                            this.options.scrollableNode ||
                            this.el.querySelector(
                                "." + this.classNames.contentWrapper
                            )),
                        (this.contentEl =
                            this.options.contentNode ||
                            this.el.querySelector(
                                "." + this.classNames.contentEl
                            )),
                        (this.offsetEl = this.el.querySelector(
                            "." + this.classNames.offset
                        )),
                        (this.maskEl = this.el.querySelector(
                            "." + this.classNames.mask
                        )),
                        (this.placeholderEl = this.findChild(
                            this.wrapperEl,
                            "." + this.classNames.placeholder
                        )),
                        (this.heightAutoObserverWrapperEl =
                            this.el.querySelector(
                                "." +
                                    this.classNames.heightAutoObserverWrapperEl
                            )),
                        (this.heightAutoObserverEl = this.el.querySelector(
                            "." + this.classNames.heightAutoObserverEl
                        )),
                        (this.axis.x.track.el = this.findChild(
                            this.el,
                            "." +
                                this.classNames.track +
                                "." +
                                this.classNames.horizontal
                        )),
                        (this.axis.y.track.el = this.findChild(
                            this.el,
                            "." +
                                this.classNames.track +
                                "." +
                                this.classNames.vertical
                        ));
                else {
                    for (
                        this.wrapperEl = document.createElement("div"),
                            this.contentWrapperEl =
                                document.createElement("div"),
                            this.offsetEl = document.createElement("div"),
                            this.maskEl = document.createElement("div"),
                            this.contentEl = document.createElement("div"),
                            this.placeholderEl = document.createElement("div"),
                            this.heightAutoObserverWrapperEl =
                                document.createElement("div"),
                            this.heightAutoObserverEl =
                                document.createElement("div"),
                            this.wrapperEl.classList.add(
                                this.classNames.wrapper
                            ),
                            this.contentWrapperEl.classList.add(
                                this.classNames.contentWrapper
                            ),
                            this.offsetEl.classList.add(this.classNames.offset),
                            this.maskEl.classList.add(this.classNames.mask),
                            this.contentEl.classList.add(
                                this.classNames.contentEl
                            ),
                            this.placeholderEl.classList.add(
                                this.classNames.placeholder
                            ),
                            this.heightAutoObserverWrapperEl.classList.add(
                                this.classNames.heightAutoObserverWrapperEl
                            ),
                            this.heightAutoObserverEl.classList.add(
                                this.classNames.heightAutoObserverEl
                            );
                        this.el.firstChild;

                    )
                        this.contentEl.appendChild(this.el.firstChild);
                    this.contentWrapperEl.appendChild(this.contentEl),
                        this.offsetEl.appendChild(this.contentWrapperEl),
                        this.maskEl.appendChild(this.offsetEl),
                        this.heightAutoObserverWrapperEl.appendChild(
                            this.heightAutoObserverEl
                        ),
                        this.wrapperEl.appendChild(
                            this.heightAutoObserverWrapperEl
                        ),
                        this.wrapperEl.appendChild(this.maskEl),
                        this.wrapperEl.appendChild(this.placeholderEl),
                        this.el.appendChild(this.wrapperEl);
                }
                if (!this.axis.x.track.el || !this.axis.y.track.el) {
                    var e = document.createElement("div"),
                        r = document.createElement("div");
                    e.classList.add(this.classNames.track),
                        r.classList.add(this.classNames.scrollbar),
                        e.appendChild(r),
                        (this.axis.x.track.el = e.cloneNode(!0)),
                        this.axis.x.track.el.classList.add(
                            this.classNames.horizontal
                        ),
                        (this.axis.y.track.el = e.cloneNode(!0)),
                        this.axis.y.track.el.classList.add(
                            this.classNames.vertical
                        ),
                        this.el.appendChild(this.axis.x.track.el),
                        this.el.appendChild(this.axis.y.track.el);
                }
                (this.axis.x.scrollbar.el = this.axis.x.track.el.querySelector(
                    "." + this.classNames.scrollbar
                )),
                    (this.axis.y.scrollbar.el =
                        this.axis.y.track.el.querySelector(
                            "." + this.classNames.scrollbar
                        )),
                    this.options.autoHide ||
                        (this.axis.x.scrollbar.el.classList.add(
                            this.classNames.visible
                        ),
                        this.axis.y.scrollbar.el.classList.add(
                            this.classNames.visible
                        )),
                    this.el.setAttribute("data-simplebar", "init");
            }),
            (e.setAccessibilityAttributes = function () {
                var t = this.options.ariaLabel || "scrollable content";
                this.contentWrapperEl.setAttribute("tabindex", "0"),
                    this.contentWrapperEl.setAttribute("role", "region"),
                    this.contentWrapperEl.setAttribute("aria-label", t);
            }),
            (e.initListeners = function () {
                var t = this,
                    e = no(this.el);
                this.options.autoHide &&
                    this.el.addEventListener("mouseenter", this.onMouseEnter),
                    ["mousedown", "click", "dblclick"].forEach(function (e) {
                        t.el.addEventListener(e, t.onPointerEvent, !0);
                    }),
                    ["touchstart", "touchend", "touchmove"].forEach(function (
                        e
                    ) {
                        t.el.addEventListener(e, t.onPointerEvent, {
                            capture: !0,
                            passive: !0,
                        });
                    }),
                    this.el.addEventListener("mousemove", this.onMouseMove),
                    this.el.addEventListener("mouseleave", this.onMouseLeave),
                    this.contentWrapperEl.addEventListener(
                        "scroll",
                        this.onScroll
                    ),
                    e.addEventListener("resize", this.onWindowResize);
                var r = !1,
                    i = e.ResizeObserver || zn;
                (this.resizeObserver = new i(function () {
                    r && t.recalculate();
                })),
                    this.resizeObserver.observe(this.el),
                    this.resizeObserver.observe(this.contentEl),
                    e.requestAnimationFrame(function () {
                        r = !0;
                    }),
                    (this.mutationObserver = new e.MutationObserver(
                        this.recalculate
                    )),
                    this.mutationObserver.observe(this.contentEl, {
                        childList: !0,
                        subtree: !0,
                        characterData: !0,
                    });
            }),
            (e.recalculate = function () {
                var t = no(this.el);
                (this.elStyles = t.getComputedStyle(this.el)),
                    (this.isRtl = "rtl" === this.elStyles.direction);
                var e = this.heightAutoObserverEl.offsetHeight <= 1,
                    r = this.heightAutoObserverEl.offsetWidth <= 1,
                    i = this.contentEl.offsetWidth,
                    n = this.contentWrapperEl.offsetWidth,
                    o = this.elStyles.overflowX,
                    s = this.elStyles.overflowY;
                (this.contentEl.style.padding =
                    this.elStyles.paddingTop +
                    " " +
                    this.elStyles.paddingRight +
                    " " +
                    this.elStyles.paddingBottom +
                    " " +
                    this.elStyles.paddingLeft),
                    (this.wrapperEl.style.margin =
                        "-" +
                        this.elStyles.paddingTop +
                        " -" +
                        this.elStyles.paddingRight +
                        " -" +
                        this.elStyles.paddingBottom +
                        " -" +
                        this.elStyles.paddingLeft);
                var a = this.contentEl.scrollHeight,
                    c = this.contentEl.scrollWidth;
                (this.contentWrapperEl.style.height = e ? "auto" : "100%"),
                    (this.placeholderEl.style.width = r ? i + "px" : "auto"),
                    (this.placeholderEl.style.height = a + "px");
                var l = this.contentWrapperEl.offsetHeight;
                (this.axis.x.isOverflowing = c > i),
                    (this.axis.y.isOverflowing = a > l),
                    (this.axis.x.isOverflowing =
                        "hidden" !== o && this.axis.x.isOverflowing),
                    (this.axis.y.isOverflowing =
                        "hidden" !== s && this.axis.y.isOverflowing),
                    (this.axis.x.forceVisible =
                        "x" === this.options.forceVisible ||
                        !0 === this.options.forceVisible),
                    (this.axis.y.forceVisible =
                        "y" === this.options.forceVisible ||
                        !0 === this.options.forceVisible),
                    this.hideNativeScrollbar();
                var u = this.axis.x.isOverflowing ? this.scrollbarWidth : 0,
                    f = this.axis.y.isOverflowing ? this.scrollbarWidth : 0;
                (this.axis.x.isOverflowing =
                    this.axis.x.isOverflowing && c > n - f),
                    (this.axis.y.isOverflowing =
                        this.axis.y.isOverflowing && a > l - u),
                    (this.axis.x.scrollbar.size = this.getScrollbarSize("x")),
                    (this.axis.y.scrollbar.size = this.getScrollbarSize("y")),
                    (this.axis.x.scrollbar.el.style.width =
                        this.axis.x.scrollbar.size + "px"),
                    (this.axis.y.scrollbar.el.style.height =
                        this.axis.y.scrollbar.size + "px"),
                    this.positionScrollbar("x"),
                    this.positionScrollbar("y"),
                    this.toggleTrackVisibility("x"),
                    this.toggleTrackVisibility("y");
            }),
            (e.getScrollbarSize = function (t) {
                if ((void 0 === t && (t = "y"), !this.axis[t].isOverflowing))
                    return 0;
                var e,
                    r = this.contentEl[this.axis[t].scrollSizeAttr],
                    i = this.axis[t].track.el[this.axis[t].offsetSizeAttr],
                    n = i / r;
                return (
                    (e = Math.max(~~(n * i), this.options.scrollbarMinSize)),
                    this.options.scrollbarMaxSize &&
                        (e = Math.min(e, this.options.scrollbarMaxSize)),
                    e
                );
            }),
            (e.positionScrollbar = function (e) {
                if ((void 0 === e && (e = "y"), this.axis[e].isOverflowing)) {
                    var r = this.contentWrapperEl[this.axis[e].scrollSizeAttr],
                        i = this.axis[e].track.el[this.axis[e].offsetSizeAttr],
                        n = parseInt(this.elStyles[this.axis[e].sizeAttr], 10),
                        o = t