@extends('layouts.dashboard.app')

@section('content')
    <div class="container-fluid mt-2 ">
        <div class="row">
            <div class="col-12">
                <form action="{{ route('Contradictoire.update', $contradictoire->id) }}" method="post">
                    @csrf
                    @method('PUT')
                    <div class="card">
                        <div class="card-body mt-1">
                            <div class="row">
                                <input type="hidden" name="dossier_id" value="{{ $dossier->id }}" >
                                <div class="form-group col-4 mb-2">
                                    <label for="adverse_id">Nom Expert Adverse</label>
                                   <select class="form-select @error('adverse_id') is-invalid @enderror" name="adverse_id" id="">
                                    <option selected value="{{$contradictoire->adverse->id ?? null}}">{{$contradictoire->adverse->name ?? null}}</option>
                                    @foreach ($adverses as $expert)
                                    <option value="{{ $expert->id }}">{{ $expert->name }}</option>
                                    @endforeach
                                   </select>
                                    @error('adverse_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group col-4 mb-2">
                                    <label for="date_reception_adverse">Date Reception Adverse</label>
                                    <input type="date" name="date_reception_adverse"
                                        value="{{ $contradictoire->date_reception_adverse ?? null }}"
                                        class="form-control @error('date_reception_adverse') is-invalid @enderror">
                                    @error('date_reception_adverse')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group col-4 mb-2">
                                    <label for="adverse_montant_accord">Adverse Montant Accord</label>
                                    <input type="number" name="adverse_montant_accord"
                                        value="{{ $contradictoire->adverse_montant_accord ?? null }}"
                                        class="form-control @error('adverse_montant_accord') is-invalid @enderror">
                                    @error('adverse_montant_accord')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group col-4 mb-2">
                                    <label for="libelle">Date Accord Adverse</label>
                                    <input type="date" name="date_accord_adverse"
                                        value="{{ $contradictoire->date_accord_adverse ?? null }}"
                                        class="form-control @error('date_accord_adverse') is-invalid @enderror">
                                    @error('date_accord_adverse')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="form-group col-4 mb-2">
                                    <label for="arbitre_id">Nom Expert Arbitre</label>
                                   <select class="form-select @error('arbitre_id') is-invalid @enderror" name="arbitre_id" id="">
                                   <option selected value="{{$contradictoire->arbitre->id ?? null}}">{{$contradictoire->arbitre->name ?? null}}</option>
                                    <option value="">Aucun</option>

                                    @foreach ($arbitres as $expert)
                                    <option value="{{ $expert->id }}">{{ $expert->name }}</option>
                                    @endforeach
                                   </select>
                                    @error('arbitre_id')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group col-4 mb-2">
                                    <label for="date_reception_arbitre">Date Reception arbitre</label>
                                    <input type="date" name="date_reception_arbitre"
                                        value="{{ $contradictoire->date_reception_arbitre ?? null }}"
                                        class="form-control @error('date_reception_arbitre') is-invalid @enderror">
                                    @error('date_reception_arbitre')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group col-4 mb-2">
                                    <label for="arbitre_montant_accord">Arbitre Montant Accord</label>
                                    <input type="number" name="arbitre_montant_accord"
                                        value="{{ $contradictoire->arbitre_montant_accord ?? null }}"
                                        class="form-control @error('arbitre_montant_accord') is-invalid @enderror">
                                    @error('arbitre_montant_accord')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="form-group col-4 mb-2">
                                    <label for="libelle">Date Accord arbitre</label>
                                    <input type="date" name="date_accord_arbitre"
                                        value="{{ $contradictoire->date_accord_arbitre ?? null }}"
                                        class="form-control @error('date_accord_arbitre') is-invalid @enderror">
                                    @error('date_accord_arbitre')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-info">Modifier</button>
                        </div>
                </form>
            </div>
        </div>
    </div>
    </div>
@endsection
