<!DOCTYPE html>
<html>

<head>
    <title>PDF Template</title>
    <style>
        /* Global styles for the PDF */
        body {
            font-family: Arial, sans-serif;
        }

        .header {
            text-align: center;
        }

        .footer {
            position: fixed;
            bottom: 0;
            width: 100%;
            text-align: center;
        }

        .logo {
            max-width: 100px;
            max-height: 100px;
            margin: 10px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        th,
        td {
            border: 1px solid black;
            padding: 8px;
            font-size: 12px
        }
    </style>
</head>

<body>
    <div class="header">
        <h4>Canevas de récupération des pièces</h4>
    </div>
    <table>
        <thead>
            <tr>
                <th>SINISTRE</th>
            </tr>
        </thead>
    </table>
    <table>

        <tbody>
            <tr>
                <td>Garagiste : {{ $dossier->garage->libelle ?? null }}</td>
                <td>Tel : {{ $dossier->insured->telephone ?? null }}</td>
                <td>Matricule : {{ $dossier->new_matricule ?? $dossier->matricule }}</td>
            </tr>
            <tr>
                <td>Numero Sinistre : {{ $dossier->numero_sinistre ?? null }}</td>
                <td>Date Sinistre : {{ $dossier->date_sinistre ?? null }}</td>
                <td>Date Accord : {{ $dossier->date_reception }}</td>
            </tr>
            <tr>
                <td>Partie du chock : @foreach ($dossier->shockpoint as $point)
                        {{ $point->point }}
                    @endforeach
                </td>
                <td>Date prévisionnelle de sortie:</td>
                <td></td>
            </tr>
        </tbody>
    </table>

    <table style="margin-top: 10px">
        <thead>
            <tr>
                <th>Vehicule</th>
            </tr>
        </thead>
    </table>
    <table>

        <tbody>
            <tr>
                <td>Type Vehicule : {{ $dossier->typevehicule->type ?? null }}</td>
                <td>Marque : {{ $dossier->vehiculemodel->brand->brand ?? null }}</td>
                <td>Modéle : {{ $dossier->vehiculemodel->name ?? null }}</td>
            </tr>
            <tr>
                <td>MEC : {{ $dossier->date_circulation ?? null }}</td>
                <td>VIN : {{ $dossier->numero_chassis ?? null }}</td>
                <td>Kilométrage : {{ $dossier->kilometrage ?? null }}</td>
            </tr>

        </tbody>
    </table>

    <table style="margin-top: 10px">
        <thead>
            <tr>
                <th>Piéce Remplacées</th>
            </tr>
        </thead>
    </table>
    <table>

        <thead>
            <tr>
                <th>Designation</th>
                <th>Quantite</th>
                <th>
                    Gravité
                    <br>
                    <hr>
                    Moyen/Faible
                </th>
                <th>Etat
                    <br>
                    <hr>
                    Valorisable : <br>
                    OUI/NON
                </th>
                <th>Montant Accord</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($rapport->piece as $piece)
                <tr>
                    <td>{{ $piece->piecetype->type ?? null }}</td>
                    <td>{{ $piece->pivot->qte ?? null }}</td>
                    <td>{{ $piece->gravite ?? null }}</td>
                    <td>{{ $piece->etat ?? null }}</td>
                    <td>{{ $piece->prix_unitaire*$piece->pivot->qte ?? null }}</td>
                </tr>
            @endforeach

        </tbody>
    </table>
    <h4>Observation</h4>
    <div style="border:1px solid black;width:100%,height:300px">
        <div style="padding: 15px">
            @foreach ($observations as $observation)
            <p style="font-size: 14px">{{ $observation->observation ?? null }}</p>
            @endforeach
        </div>
    </div>
    <table>
        <thead>
            <tr>
                <th>Visa Garage</th>
                <th>Visa Expert</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td>
                    <br>
                    <br>
                    <br>
                </td>
                <td>
                    <br>
                    <br>
                    <br>
                </td>
            </tr>
        </tbody>
    </table>



</body>

</html>
