@extends('layouts.dashboard.app')
@section('style')
@endsection
@section('content')
    <div class="col-md-12">
        <div class="card">
            <div class="card-body">
                <div class="col-md-4 mb-5">
                    <a style="float: left" href="{{ route('Dossier.show', $id) }}" class="btn btn-outline-dark ">Dossier</a>
                </div>
                <form action="{{ route('Document.signer', $id) }}" method="post">
                    @csrf
                    <div class="col-md-6 mb-3">
                        <label for="date" class="form-label">Observation :</label>
                        <textarea class="form-control mb-2  @error('observation') is-invalid @enderror" name="observation" id=""
                            cols="10" rows="3"></textarea>
                        @error('observation')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>

                    <div class="mr-2 mt-1 ">
                        <div id="galley" class="row mt-3 ">
                            @can('download', App\Models\Document::class)
                                <input type="hidden" name="attachements" id="docs">
                            @endcan
                            @foreach ($imgs as $doc)
                                <div class="col-4">
                                    @if ($doc->signer)
                                        <span class="badge bg-success">Signer</span>
                                    @elseif ($doc->rejected)
                                        <span class="badge bg-danger">Rejeter</span>
                                    @else
                                        <input type="checkbox" value="{{ $doc->id }}" class="check">
                                    @endif <img
                                        data-original="{{ Storage::disk('s3')->temporaryUrl($doc->path, now()->addMinutes(30)) }}"
                                        id="img{{ $doc->id }}" style="width: 100%;"
                                        src="{{ Storage::disk('s3')->temporaryUrl($doc->path, now()->addMinutes(30)) }}"
                                        alt="">
                                    <span>{{ $doc->typedocument->type ?? null }}</span>
                                </div>
                            @endforeach
                        </div>

                        {{-- @can('download', App\Models\Document::class) --}}
                        <div class="row mt-4">
                            <div class="col-12">
                                <button style="display: inline-block;" type="submit" name="action" value="signer"
                                    class="btn btn-lg btn-success">
                                    Signer A Droite
                                </button>
                                <button style="display: inline-block;" type="submit" name="action" value="signer3"
                                    class="btn btn-lg btn-success">
                                    Signer Au Centre
                                </button>
                                <button style="display: inline-block;" type="submit" name="action" value="signer2"
                                    class="btn btn-lg btn-success">
                                    Signer A Gauche
                                </button>
                                <button style="display: inline-block; float: right;" type="submit" name="action"
                                    value="rejeter" class="btn btn-lg btn-danger">
                                    Rejeter
                                </button>
                            </div>
                        </div>
                        {{-- @endcan --}}
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
@section('script')
    <script>
        var checkboxes = document.getElementsByClassName('check');
        var array = [];
        var docs = document.getElementById('docs');

        for (var i = 0; i < checkboxes.length; i++) {
            checkboxes[i].addEventListener('change', function() {
                if (this.checked) {
                    array.push(this.value);
                    console.log(array);
                    docs.value = array;
                } else {
                    var carIndex = array.indexOf(this.value); //get   index
                    array.splice(carIndex, 1);
                    console.log(array);
                    docs.value = array;
                }
            });

        }
    </script>
@endsection
