@extends('layouts.config_dashboard.app')

@section('content')
    <div class="container-fluid ">

        <div class="row">
            <div class="card">
                <div class="card-body">
                    <form style="display: inline" action="{{ route('Email.attach', $email->id) }}" method="post">
                        @csrf
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Id</th>
                                    <th>Etape</th>
                                    <th>Email</th>
                                    <th>Delai</th>
                                    <th>Modifier</th>
                                    <th>Supprimer</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>{{ $email->id }}</td>
                                    <td>
                                        <span class="badge bg-info">{{ $email->step->step ?? null }}</span>
                                    </td>
                                    <td>{{ $email->content ?? null }}</td>
                                    <td>{{ $email->delai ?? null }}</td>
                                    @can('update', App\Models\Email::class)
                                        <td> <a class="btn btn-sm btn-primary rounded-pill"
                                                href="{{ route('Email.edit', [$email->id]) }}">
                                                <i class="uil uil-pen fs-5"></i>
                                            </a>
                                        </td>
                                    @endcan

                                    <td>
                                        @can('destroy', App\Models\Email::class)
                                            <form action="{{ route('Email.destroy', [$email->id]) }}" method="post">
                                                @csrf
                                                @method('DELETE')
                                                <button class="btn btn-sm btn-danger rounded-pill" type="submit">
                                                    <i class="uil uil-trash fs-5"></i>
                                                </button>
                                            </form>
                                        @endcan
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-body">
                                    <form method="POST" action="{{ route('Email.attach', $email->id) }}">
                                        @csrf
                                        <div class="mr-2 mt-1">
                                            <h4>Assigner un Type Document</h4>
                                            <hr>
                                            @forelse ($types as $type)
                                                @if ($email->hasType($type->type))
                                                    <div class="form-check form-check-inline form-checkbox-dark ">
                                                        <input type="checkbox" checked class="form-check-input"
                                                            value="{{ $type->id }}" name="type[]"
                                                            id="customSwitch3{{ $type->id }}">
                                                        <label class="form-check-label fs-4"
                                                            for="customSwitch3{{ $type->id }}">{{ $type->type }}</label>
                                                    </div>
                                                @else
                                                    <div class="form-check form-check-inline form-checkbox-secondary ">
                                                        <input type="checkbox" class="form-check-input"
                                                            value="{{ $type->id }}" name="type[]"
                                                            id="customSwitch3{{ $type->id }}">
                                                        <label class="form-check-label fs-4"
                                                            for="customSwitch3{{ $type->id }}">{{ $type->type }}</label>
                                                    </div>
                                                @endif

                                            @empty
                                                <h5>Tableau Vide</h5>
                                            @endforelse
                                        </div>
                                        <div class="mt-2">
                                            <button type="submit" class="btn btn-success">Attacher</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>

                    </form>
                </div>

            </div>
        </div>
    </div>
@endsection
