@extends('layouts.dashboard.app')
@section('style')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.4.0/min/dropzone.min.css">
    <link rel="stylesheet" href="{{ asset('css/viewer.css') }}">
    <style>
        /* ============================================
           RAPPORT DOCUMENTS PAGE - DOSSIER DESIGN
           ============================================ */
        
        * {
            box-sizing: border-box;
        }

        /* Page Header */
        .dossier-header {
            background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%);
            border-radius: 16px;
            padding: 20px 25px;
            margin-bottom: 20px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.15);
        }

        .dossier-header-top {
            display: flex;
            align-items: center;
            justify-content: space-between;
            flex-wrap: wrap;
            gap: 15px;
        }

        .dossier-title {
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .dossier-title h4 {
            color: #fff;
            font-size: 22px;
            font-weight: 700;
            margin: 0;
        }

        .dossier-ref {
            color: #10b981;
            font-weight: 600;
        }

        .dossier-badges {
            display: flex;
            align-items: center;
            gap: 10px;
            flex-wrap: wrap;
        }

        /* Modern Card */
        .modern-card {
            background: #fff;
            border-radius: 16px;
            box-shadow: 0 2px 20px rgba(0, 0, 0, 0.06);
            overflow: hidden;
            border: none;
            height: 100%;
            display: flex;
            flex-direction: column;
        }

        .modern-card .card-header {
            background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
            border-bottom: 1px solid #e2e8f0;
            padding: 12px 15px;
        }

        .modern-card .card-header h5 {
            margin: 0;
            font-size: 14px;
            font-weight: 600;
            color: #1e293b;
        }

        .img-container {
            position: relative;
            height: 200px;
            overflow: hidden;
            background: #f1f5f9;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .img-container img {
            width: 100%;
            height: 100%;
            object-fit: contain; /* Maintain aspect ratio */
            transition: transform 0.3s ease;
        }
        
        .img-container:hover img {
             transform: scale(1.05);
        }

        .modern-card .card-body {
            padding: 15px;
            flex-grow: 1;
            display: flex;
            flex-direction: column;
        }

        .form-control-custom {
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            padding: 10px;
            font-size: 13px;
            width: 100%;
            resize: none;
            flex-grow: 1;
             background: #f8fafc;
        }
        
        .form-control-custom:focus {
            outline: none;
            border-color: #10b981;
            background: #fff;
            box-shadow: 0 0 0 3px rgba(16, 185, 129, 0.1);
        }

        .selection-checkbox {
            position: absolute;
            top: 10px;
            right: 10px;
            z-index: 10;
            width: 20px;
            height: 20px;
            cursor: pointer;
        }
    </style>
@endsection

@section('content')

    <form action="{{ route('Rapport.attachments', $id) }}" method="POST">
        @csrf
        
        <!-- Header Section -->
        <div class="dossier-header">
            <div class="dossier-header-top">
                <div class="dossier-title">
                    <h4>Documents & Photos <span class="dossier-ref">#{{ $rapport->dossier->ref ?? '' }}</span></h4>
                </div>
                <div class="dossier-badges">
                    <a href="{{ route('Rapport.edit', $id) }}" class="btn btn-outline-light rounded-pill">
                        <i class="uil uil-arrow-left"></i> Retour à l'Édition
                    </a>
                    <button type="submit" class="btn btn-success rounded-pill">
                        <i class="uil uil-check-circle"></i> Enregistrer
                    </button>
                </div>
            </div>
        </div>

        <div class="row g-4">
            @foreach ($docs as $doc)
                <div class="col-md-3">
                    <div class="modern-card">
                        <div class="card-header">
                            <h5>{{ $doc->typedocument->type ?? 'Document' }}</h5>
                        </div>
                        <div class="img-container">
                             {{-- Adding a hidden default checkbox if you needed selection logic, but based on previous code it was implicit via img[] hidden input --}}
                            <a href="{{ Storage::disk('s3')->temporaryUrl($doc->path, now()->addMinutes(30)) }}" target="_blank">
                                <img src="{{ Storage::disk('s3')->temporaryUrl($doc->path, now()->addMinutes(30)) }}" alt="Document Image">
                            </a>
                        </div>
                         <input type="hidden" name="img[]" value="{{ $doc->id }}">
                        <div class="card-body">
                            <label class="form-label text-muted small">Observation</label>
                            <textarea name="body[]" class="form-control-custom" rows="3" placeholder="Ajouter une note...">{{ $doc->rapports[0]->pivot->observation ?? null }}</textarea>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
        
        @if(count($docs) == 0)
            <div class="alert alert-info mt-4">
                Aucune image disponible pour ce dossier. Veuillez vérifier qu'elles ne sont pas des PDF.
            </div>
        @endif

    </form>
@endsection
