@extends('layouts.dashboard.app')
@section('style')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.4.0/min/dropzone.min.css">
    <link rel="stylesheet" href="{{ asset('css/viewer.css') }}">
    <style>
       
        
        * {
            box-sizing: border-box;
        }

        /* Page Header */
        .dossier-header {
            background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%);
            border-radius: 16px;
            padding: 20px 25px;
            margin-bottom: 20px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.15);
        }

        .dossier-header-top {
            display: flex;
            align-items: center;
            justify-content: space-between;
            flex-wrap: wrap;
            gap: 15px;
        }

        .dossier-title {
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .dossier-title h4 {
            color: #fff;
            font-size: 22px;
            font-weight: 700;
            margin: 0;
        }

        .dossier-ref {
            color: #10b981;
            font-weight: 600;
        }

        .dossier-badges {
            display: flex;
            align-items: center;
            gap: 10px;
            flex-wrap: wrap;
        }

        /* Modern Card */
        .modern-card {
            background: #fff;
            border-radius: 16px;
            box-shadow: 0 2px 20px rgba(0, 0, 0, 0.06);
            overflow: hidden;
            margin-bottom: 20px;
            border: none;
        }

        .modern-card .card-header {
            background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
            border-bottom: 1px solid #e2e8f0;
            padding: 16px 20px;
        }

        .modern-card .card-header h4 {
            margin: 0;
            font-size: 16px;
            font-weight: 600;
            color: #1e293b;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .modern-card .card-header h4 i {
            color: #10b981;
            font-size: 20px;
        }

        .modern-card .card-body {
            padding: 20px;
        }

        /* Info Grid - Responsive Key-Value Layout */
        .info-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 12px;
        }

        .info-item {
            display: flex;
            align-items: center;
            padding: 12px 15px;
            background: #f8fafc;
            border-radius: 10px;
            border-left: 3px solid #10b981;
            transition: all 0.2s ease;
        }

        .info-item:hover {
            background: #f1f5f9;
            transform: translateX(3px);
        }

        .info-label {
            font-size: 12px;
            color: #64748b;
            font-weight: 500;
            min-width: 120px;
            flex-shrink: 0;
        }

        .info-value {
            font-size: 14px;
            color: #1e293b;
            font-weight: 600;
            word-break: break-word;
        }

        /* Tables override */
        .table thead th {
             border-top: 0;
             border-bottom-width: 1px;
             font-weight: 600;
             text-transform: uppercase;
             font-size: 0.8rem;
             color: #6c757d;
             background-color: #f8fafc;
        }

        /* MEDIA GALLERY STYLES */
        .doc-count-badge {
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
            color: #fff;
            padding: 4px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
        }

        .media-filter-tabs {
            display: flex;
            flex-wrap: wrap;
            gap: 8px;
            margin-bottom: 20px;
            padding-bottom: 15px;
            border-bottom: 1px solid #e2e8f0;
        }

        .filter-tab {
            padding: 8px 16px;
            border: 1px solid #e2e8f0;
            background: #fff;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 500;
            color: #64748b;
            cursor: pointer;
            transition: all 0.2s ease;
            display: flex;
            align-items: center;
            gap: 6px;
        }

        .filter-tab:hover {
            border-color: #10b981;
            color: #10b981;
        }

        .filter-tab.active {
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
            border-color: #10b981;
            color: #fff;
        }

        .media-gallery {
            max-height: 500px;
            overflow-y: auto;
            padding-right: 5px;
        }

        .media-gallery::-webkit-scrollbar { width: 6px; }
        .media-gallery::-webkit-scrollbar-track { background: #f1f5f9; border-radius: 3px; }
        .media-gallery::-webkit-scrollbar-thumb { background: #cbd5e1; border-radius: 3px; }

        .media-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(120px, 1fr));
            gap: 12px;
        }

        .media-item {
            position: relative;
            border-radius: 12px;
            overflow: hidden;
            background: #f8fafc;
            border: 1px solid #e2e8f0;
            aspect-ratio: 1;
            transition: all 0.3s ease;
        }

        .media-item:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.12);
            border-color: #10b981;
        }

        .media-image {
            width: 100%;
            height: 100%;
            object-fit: cover;
            cursor: pointer;
        }
        
        .media-badge {
            position: absolute;
            bottom: 0;
            left: 0;
            right: 0;
            padding: 4px;
            font-size: 10px;
            font-weight: 600;
            text-align: center;
            background: rgba(0,0,0,0.6);
            color: #fff;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }
    </style>
@endsection

@section('content')

    <!-- Header Section -->
    <div class="dossier-header">
        <div class="dossier-header-top">
            <div class="dossier-title">
                <h4>Rapport <span class="dossier-ref">#{{ $dossier->ref }}</span></h4>
            </div>
            <div class="dossier-badges">
                <!-- Actions -->
                <a href="{{ route('Rapport.edit', $rapport->id) }}" class="btn btn-warning rounded-pill">
                    <i class="uil uil-edit"></i> Modifier
                </a>
                
                <a href="{{ route('Dossier.show', $dossier->id) }}" class="btn btn-outline-light rounded-pill">
                    <i class="uil uil-arrow-left"></i> Retour au Dossier
                </a>

                @if ($rapport->rapport_status_id == 5)
                     <form action="{{ route('Rapport.send') }}" method="post" style="display:inline;">
                        @csrf
                        <input type="hidden" name="rapport_id" value="{{ $rapport->id }}">
                        <button type="submit" class="btn btn-success rounded-pill">
                            <i class="uil uil-message"></i> Envoyer A Signer
                        </button>
                    </form>
                    <a href="{{ route('Rapport.doc', $rapport->id) }}" target="_blank" class="btn btn-primary rounded-pill">
                        <i class="uil uil-file-download-alt"></i> Génerer PDF
                    </a>
                @endif
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Main Column: Rapport Details & Pieces -->
        <div class="col-lg-12">
            
            <!-- Dossier & Rapport Info -->
            <div class="modern-card">
                <div class="card-header">
                    <h4><i class="uil uil-file-info-alt"></i> Informations Principales</h4>
                </div>
                <div class="card-body">
                    <div class="info-grid">
                         <div class="info-item">
                            <span class="info-label">Reference:</span>
                            <span class="info-value">{{ $dossier->ref }}</span>
                        </div>
                        <div class="info-item">
                            <span class="info-label">Matricule:</span>
                            <span class="info-value">{{ $dossier->matricule }}</span>
                        </div>
                        <div class="info-item">
                            <span class="info-label">Compagnie:</span>
                            <span class="info-value">{{ $dossier->company->company ?? '-' }}</span>
                        </div>
                        <div class="info-item">
                            <span class="info-label">Assuré:</span>
                            <span class="info-value">{{ $dossier->insured->name ?? '-' }}</span>
                        </div>
                         <div class="info-item">
                            <span class="info-label">Status Rapport:</span>
                            <span class="info-value">
                                @if($rapport->rapport_status_id == 5) <span class="badge bg-warning">En cours</span>
                                @elseif($rapport->rapport_status_id == 2) <span class="badge bg-success">Signé</span>
                                @elseif($rapport->rapport_status_id == 3) <span class="badge bg-primary">Envoyé</span>
                                @else <span class="badge bg-secondary">{{ $rapport->status->status ?? $rapport->rapport_status_id }}</span>
                                @endif
                            </span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Taux Section (Read Only) -->
            <div class="modern-card">
                 <div class="card-header">
                    <h4><i class="uil uil-calculator"></i> Taux Appliqués</h4>
                </div>
                <div class="card-body">
                     @if($rapport->taux)
                     <div class="info-grid">
                        <div class="info-item">
                            <span class="info-label">Taux 1:</span>
                            <span class="info-value">{{ $rapport->taux->taux_1 ?? 0 }} {{ $dossier->currency->symbole ?? '' }}/h</span>
                        </div>
                        <div class="info-item">
                             <span class="info-label">Taux 2:</span>
                             <span class="info-value">{{ $rapport->taux->taux_2 ?? 0 }} {{ $dossier->currency->symbole ?? '' }}/h</span>
                        </div>
                         <div class="info-item">
                             <span class="info-label">MO Peinture:</span>
                             <span class="info-value">{{ $rapport->taux->taux_mo_peinture ?? 0 }} {{ $dossier->currency->symbole ?? '' }}/h</span>
                        </div>
                        <div class="info-item">
                             <span class="info-label">Vétusté:</span>
                             <span class="info-value">{{ $rapport->taux->vetuste ? 'Compagnie' : 'Client' }}</span>
                        </div>
                     </div>
                     @else
                        <div class="alert alert-warning">Aucun taux défini.</div>
                     @endif
                </div>
            </div>

            <!-- Pieces Table -->
            <div class="modern-card">
                 <div class="card-header">
                    <h4><i class="uil uil-wrench"></i> Pièces et Opérations</h4>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-centered mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th>Pièce</th>
                                    <th>Opération</th>
                                    <th>Réparation</th>
                                    <th>Prix Unitaire</th>
                                    <th>Qte</th>
                                    <th>Gravité</th>
                                    <th>Etat</th>
                                    <th>Vétusté</th>
                                    <th>Remise</th>
                                    <th>Total (HT)</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($rapport->piece as $piece)
                                <tr>
                                    <td>{{ $piece->piece }}</td>
                                    <td>{{ $piece->pivot->operation->operation ?? '-' }}</td>
                                    <td>{{ $piece->pivot->typereparation->type ?? '-' }}</td>
                                    <td>{{ $piece->pivot->prix_unitaire }} {{ $dossier->currency->symbole ?? '' }}</td>
                                    <td>{{ $piece->pivot->qte }}</td>
                                    <td>{{ $piece->pivot->gravite }}</td>
                                    <td>{{ $piece->pivot->etat }}</td>
                                    <td>{{ $piece->pivot->vetuste }}%</td>
                                    <td>{{ $piece->pivot->remise }}%</td>
                                    @php
                                        $total = $piece->pivot->prix_unitaire * $piece->pivot->qte;
                                    @endphp
                                    <td class="font-weight-bold">{{ number_format($total, 2) }}</td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

        </div>
    </div>
@endsection