<!DOCTYPE html>
<html lang="fr">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>Rapport d'Expertise - <?php echo e($dossier->ref ?? 'N/A'); ?></title>
</head>
<style>
    @page {
        margin: 12mm 8mm 15mm 8mm;
    }
    
    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
    }
    
    body {
        font-family: 'DejaVu Sans', Arial, sans-serif;
        font-size: 9px;
        line-height: 1.2;
        color: #000;
    }

    .page-break {
        page-break-after: always;
    }

    /* Header Styles */
    .header-container {
        width: 100%;
        margin-bottom: 8px;
        border-bottom: 2px solid #1a365d;
        padding-bottom: 5px;
    }
    
    .logo-cell {
        width: 25%;
        vertical-align: middle;
    }
    
    .title-cell {
        width: 50%;
        text-align: center;
        vertical-align: middle;
    }
    
    .ref-cell {
        width: 25%;
        text-align: right;
        vertical-align: middle;
    }
    
    .report-title {
        font-size: 14px;
        font-weight: bold;
        color: #1a365d;
        text-transform: uppercase;
        letter-spacing: 1px;
    }
    
    .report-subtitle {
        font-size: 10px;
        color: #2d3748;
        margin-top: 3px;
    }

    /* Section Headers */
    .section-header {
        background-color: #1a365d;
        color: white;
        font-size: 9px;
        font-weight: bold;
        padding: 4px 8px;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        margin-top: 8px;
        margin-bottom: 4px;
    }

    /* Data Tables */
    .data-table {
        width: 100%;
        border-collapse: collapse;
        font-size: 8px;
        margin-bottom: 6px;
    }
    
    .data-table th {
        background-color: #e2e8f0;
        border: 1px solid #718096;
        padding: 3px 5px;
        text-align: left;
        font-weight: 600;
        color: #1a365d;
        width: 40%;
    }
    
    .data-table td {
        border: 1px solid #718096;
        padding: 3px 5px;
        text-align: left;
        background-color: #fff;
    }
    
    /* Two Column Layout */
    .two-col-table {
        width: 100%;
        border-collapse: separate;
        border-spacing: 8px 0;
    }
    
    .two-col-table > tbody > tr > td {
        width: 50%;
        vertical-align: top;
    }

    /* Financial Tables */
    .finance-table {
        width: 100%;
        border-collapse: collapse;
        font-size: 8px;
    }
    
    .finance-table th {
        background-color: #1a365d;
        color: white;
        border: 1px solid #1a365d;
        padding: 4px 5px;
        text-align: center;
        font-weight: 600;
    }
    
    .finance-table td {
        border: 1px solid #718096;
        padding: 3px 5px;
        text-align: center;
    }
    
    .finance-table .label-cell {
        background-color: #e2e8f0;
        text-align: left;
        font-weight: 600;
    }
    
    .finance-table .total-row td {
        background-color: #bee3f8;
        font-weight: bold;
    }
    
    .finance-table .highlight-row td {
        background-color: #c6f6d5;
        font-weight: bold;
    }

    /* Pieces Table */
    .pieces-table {
        width: 100%;
        border-collapse: collapse;
        font-size: 7px;
    }
    
    .pieces-table th {
        background-color: #1a365d;
        color: white;
        border: 1px solid #1a365d;
        padding: 4px 3px;
        text-align: center;
        font-weight: 600;
    }
    
    .pieces-table td {
        border: 1px solid #a0aec0;
        padding: 3px;
        text-align: center;
    }
    
    .pieces-table tr:nth-child(even) {
        background-color: #f7fafc;
    }

    /* Shock Point & Observations */
    .shock-obs-table {
        width: 100%;
        margin-top: 8px;
    }
    
    .shock-cell {
        width: 40%;
        vertical-align: top;
        text-align: center;
    }
    
    .obs-cell {
        width: 60%;
        vertical-align: top;
        padding-left: 10px;
    }
    
    .shock-box {
        border: 1px solid #718096;
        padding: 5px;
        background: #f7fafc;
    }
    
    .shock-title {
        background-color: #1a365d;
        color: white;
        font-size: 8px;
        font-weight: bold;
        padding: 3px 6px;
        text-align: center;
        margin-bottom: 5px;
    }
    
    .shock-image {
        max-width: 200px;
        height: auto;
        max-height: 140px;
    }
    
    .shock-points {
        font-size: 7px;
        color: #4a5568;
        margin-top: 5px;
        text-align: left;
        padding: 3px;
        background: #edf2f7;
    }
    
    .obs-box {
        border: 1px solid #718096;
        padding: 8px;
        background: #fffaf0;
        min-height: 140px;
    }
    
    .obs-title {
        font-weight: bold;
        font-size: 9px;
        color: #1a365d;
        border-bottom: 1px solid #e2e8f0;
        padding-bottom: 4px;
        margin-bottom: 6px;
    }
    
    .obs-item {
        font-size: 8px;
        margin-bottom: 4px;
        padding-left: 8px;
        border-left: 2px solid #ed8936;
    }

    /* Values Table */
    .values-table {
        width: 48%;
        border-collapse: collapse;
        font-size: 8px;
    }
    
    .values-table th {
        background-color: #e2e8f0;
        border: 1px solid #718096;
        padding: 3px 5px;
        text-align: left;
        font-weight: 600;
    }
    
    .values-table td {
        border: 1px solid #718096;
        padding: 3px 5px;
        text-align: center;
    }

    /* Footer */
    .page-footer {
        text-align: center;
        font-size: 7px;
        color: #4a5568;
        margin-top: 10px;
        padding-top: 8px;
        border-top: 1px solid #a0aec0;
    }
    
    .company-info {
        font-size: 7px;
        line-height: 1.4;
    }

    /* Signatures */
    .signature-table {
        width: 100%;
        margin-top: 15px;
    }
    
    .signature-cell {
        width: 50%;
        text-align: center;
        vertical-align: top;
        padding: 10px;
    }
    
    .signature-line {
        border-bottom: 1px solid #000;
        width: 80%;
        margin: 30px auto 5px;
    }
    
    .signature-label {
        font-size: 8px;
        font-weight: bold;
    }

    /* Warning */
    .warning-box {
        border: 2px solid #c53030;
        color: #c53030;
        font-size: 8px;
        font-weight: bold;
        text-align: center;
        padding: 6px;
        margin: 10px 0;
        background: #fff5f5;
    }

    /* Image Gallery */
    .gallery-header {
        background-color: #1a365d;
        color: white;
        font-size: 10px;
        font-weight: bold;
        padding: 6px 10px;
        margin-bottom: 10px;
    }
    
    .gallery-table {
        width: 100%;
        border-collapse: separate;
        border-spacing: 5px;
    }
    
    .gallery-cell {
        width: 32%;
        text-align: center;
        vertical-align: top;
        border: 1px solid #e2e8f0;
        padding: 4px;
        background: #f7fafc;
    }
    
    .gallery-img {
        width: 100%;
        height: 130px;
        object-fit: contain;
    }
    
    .gallery-label {
        font-size: 7px;
        color: #4a5568;
        margin-top: 3px;
    }

    /* Checkbox styling */
    .checkbox {
        display: inline-block;
        width: 10px;
        height: 10px;
        border: 1px solid #000;
        vertical-align: middle;
        margin-right: 3px;
        text-align: center;
        font-size: 8px;
        line-height: 10px;
    }
    
    .checkbox.checked::before {
        content: "✓";
    }
</style>

<body>
    <!-- ======================== PAGE 1: MAIN REPORT ======================== -->
    
    <!-- HEADER -->
    <table class="header-container" style="width: 100%;">
        <tr>
            <td class="logo-cell">
                <img src="img/amea2.png" style="height: 50px; width: auto;" alt="AMEA">
            </td>
            <td class="title-cell">
                <div class="report-title">RAPPORT D'EXPERTISE AUTOMOBILE</div>
                <div class="report-subtitle"><?php echo e($dossier->typeexpertise->type ?? 'Expertise'); ?> - <?php echo e($dossier->mode->mode ?? ''); ?></div>
            </td>
            <td class="ref-cell">
                <div style="font-size: 10px; font-weight: bold; color: #1a365d;">Réf: <?php echo e($dossier->ref ?? 'N/A'); ?></div>
                <div style="font-size: 8px; margin-top: 3px;">N° Sinistre: <?php echo e($dossier->numero_sinistre ?? 'N/A'); ?></div>
            </td>
        </tr>
    </table>

    <!-- ASSURANCE & DATES - Side by Side -->
    <table class="two-col-table">
        <tr>
            <td>
                <div class="section-header">COMPAGNIE D'ASSURANCE</div>
                <table class="data-table">
                    <tr>
                        <th>Assurance</th>
                        <td><?php echo e($dossier->company->company ?? '-'); ?></td>
                    </tr>
                    <tr>
                        <th>Expert</th>
                        <td>AMEA</td>
                    </tr>
                    <tr>
                        <th>Intermédiaire</th>
                        <td><?php echo e($dossier->intermidiaire->company ?? '-'); ?></td>
                    </tr>
                    <tr>
                        <th>Garantie</th>
                        <td><?php echo e($dossier->guarantee->guarantee ?? '-'); ?></td>
                    </tr>
                </table>
            </td>
            <td>
                <div class="section-header">DATES & RÉFÉRENCES</div>
                <table class="data-table">
                    <tr>
                        <th>Date Réception Mission</th>
                        <td><?php echo e($dossier->date_reception ?? '-'); ?></td>
                    </tr>
                    <tr>
                        <th>Date d'Expertise</th>
                        <td><?php if($meeting): ?><?php echo e($meeting->date ?? '-'); ?><?php else: ?> - <?php endif; ?></td>
                    </tr>
                    <tr>
                        <th>Date du Sinistre</th>
                        <td><?php echo e($dossier->date_sinistre ?? '-'); ?></td>
                    </tr>
                    <tr>
                        <th>Date Rapport Définitif</th>
                        <td><?php echo e($dossier->onerapport->created_at->format('Y-m-d') ?? '-'); ?></td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>

    <!-- VEHICULES - Side by Side -->
    <table class="two-col-table">
        <tr>
            <td>
                <div class="section-header">VÉHICULE EXPERTISÉ</div>
                <table class="data-table">
                    <tr>
                        <th>Assuré</th>
                        <td><?php echo e($dossier->insured->name ?? '-'); ?></td>
                    </tr>
                    <tr>
                        <th>N° Police</th>
                        <td><?php echo e($dossier->numero_police ?? '-'); ?></td>
                    </tr>
                    <tr>
                        <th>Immatriculation</th>
                        <td><strong><?php echo e($dossier->matricule ?? $dossier->new_matricule); ?></strong></td>
                    </tr>
                    <tr>
                        <th>Marque / Modèle</th>
                        <td><?php echo e($dossier->vehiculemodel->brand->brand ?? ''); ?> <?php echo e($dossier->vehiculemodel->name ?? ''); ?></td>
                    </tr>
                    <tr>
                        <th>N° Chassis</th>
                        <td style="font-size: 7px;"><?php echo e($dossier->numero_chassis ?? '-'); ?></td>
                    </tr>
                    <tr>
                        <th>DMC</th>
                        <td><?php echo e($dossier->date_circulation ?? '-'); ?></td>
                    </tr>
                    <tr>
                        <th>Kilométrage</th>
                        <td><?php echo e($dossier->kilometrage ?? '-'); ?> Km</td>
                    </tr>
                    <tr>
                        <th>Puissance Fiscale</th>
                        <td><?php echo e($dossier->puissance_fiscale ?? '-'); ?> CV</td>
                    </tr>
                    <tr>
                        <th>Carburant</th>
                        <td><?php echo e($dossier->carburant->name ?? '-'); ?></td>
                    </tr>
                </table>
            </td>
            <td>
                <div class="section-header">VÉHICULE ADVERSE</div>
                <table class="data-table">
                    <tr>
                        <th>Nom</th>
                        <td><?php echo e($dossier->opponent->name ?? '-'); ?></td>
                    </tr>
                    <tr>
                        <th>Compagnie</th>
                        <td><?php echo e($dossier->opponent->company->company ?? '-'); ?></td>
                    </tr>
                    <tr>
                        <th>Immatriculation</th>
                        <td><?php echo e($dossier->opponent->matricule ?? '-'); ?></td>
                    </tr>
                    <tr>
                        <th>N° Police</th>
                        <td><?php echo e($dossier->opponent->numero_attestation ?? '-'); ?></td>
                    </tr>
                </table>
                
                <!-- Checkboxes -->
                <table class="data-table" style="margin-top: 8px;">
                    <tr>
                        <th>Lieu de Visite</th>
                        <td style="font-size: 7px;"><?php echo e(Str::limit($dossier->garage->libelle ?? '-', 30)); ?></td>
                    </tr>
                    <tr>
                        <th>Visite en Cours</th>
                        <td><?php if($encours): ?><?php echo e($encours->created_at->format('Y-m-d')); ?><?php else: ?> - <?php endif; ?></td>
                    </tr>
                    <tr>
                        <th>Visite Fin Travaux</th>
                        <td><?php if($apres): ?><?php echo e($apres->created_at->format('Y-m-d')); ?><?php else: ?> - <?php endif; ?></td>
                    </tr>
                </table>
                
                <table style="width: 100%; font-size: 8px; margin-top: 5px;">
                    <tr>
                        <td style="padding: 2px;">
                            <span class="checkbox <?php if($rapport->taux && $rapport->taux->tva_deductible): ?> checked <?php endif; ?>"></span> TVA Récup.
                        </td>
                        <td style="padding: 2px;">
                            <span class="checkbox <?php if($dossier->mode_id == 2): ?> checked <?php endif; ?>"></span> Réforme Éco.
                        </td>
                    </tr>
                    <tr>
                        <td style="padding: 2px;">
                            <span class="checkbox <?php if($dossier->type_expertise_id == 10): ?> checked <?php endif; ?>"></span> Prise en Charge
                        </td>
                        <td style="padding: 2px;">
                            <span class="checkbox <?php if($dossier->mode_id == 3): ?> checked <?php endif; ?>"></span> Réforme Tech.
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>

    <!-- FINANCIAL SUMMARY -->
    <div class="section-header">RÉCAPITULATIF FINANCIER</div>
    <table class="two-col-table">
        <tr>
            <td>
                <table class="finance-table">
                    <tr>
                        <th colspan="2">DÉTAIL DES COÛTS</th>
                    </tr>
                    <tr>
                        <td class="label-cell">Devis Initial</td>
                        <td><?php if($devis): ?><?php echo e(number_format($devis->montant_devis, 2, ',', ' ')); ?><?php else: ?> 0,00 <?php endif; ?> <?php echo e($dossier->currency->symbole ?? 'MAD'); ?></td>
                    </tr>
                    <tr>
                        <td class="label-cell">Pièces Récup. HT</td>
                        <td><?php echo e(number_format($recup, 2, ',', ' ')); ?> <?php echo e($dossier->currency->symbole ?? 'MAD'); ?></td>
                    </tr>
                    <tr>
                        <td class="label-cell">Pièces Origine HT</td>
                        <td><?php echo e(number_format($org, 2, ',', ' ')); ?> <?php echo e($dossier->currency->symbole ?? 'MAD'); ?></td>
                    </tr>
                    <tr>
                        <td class="label-cell">Pièces Adaptables HT</td>
                        <td><?php echo e(number_format($adpt, 2, ',', ' ')); ?> <?php echo e($dossier->currency->symbole ?? 'MAD'); ?></td>
                    </tr>
                    <tr>
                        <td class="label-cell">Ingrédients</td>
                        <td><?php echo e(number_format($ingr, 2, ',', ' ')); ?> <?php echo e($dossier->currency->symbole ?? 'MAD'); ?></td>
                    </tr>
                    <tr class="total-row">
                        <td class="label-cell">Total HT</td>
                        <td><?php echo e(number_format($ht, 2, ',', ' ')); ?> <?php echo e($dossier->currency->symbole ?? 'MAD'); ?></td>
                    </tr>
                </table>
            </td>
            <td>
                <table class="finance-table">
                    <tr>
                        <th colspan="2">MONTANTS FINAUX</th>
                    </tr>
                    <tr>
                        <td class="label-cell">Montant TVA</td>
                        <td><?php echo e(number_format($tva, 2, ',', ' ')); ?> <?php echo e($dossier->currency->symbole ?? 'MAD'); ?></td>
                    </tr>
                    <tr>
                        <td class="label-cell">Total TTC</td>
                        <td><?php echo e(number_format($ttl, 2, ',', ' ')); ?> <?php echo e($dossier->currency->symbole ?? 'MAD'); ?></td>
                    </tr>
                    <tr>
                        <td class="label-cell">Vétusté</td>
                        <td><?php echo e(number_format($vet, 2, ',', ' ')); ?> <?php echo e($dossier->currency->symbole ?? 'MAD'); ?></td>
                    </tr>
                    <tr>
                        <td class="label-cell">Franchise</td>
                        <td><?php echo e(number_format($fr, 2, ',', ' ')); ?> <?php echo e($dossier->currency->symbole ?? 'MAD'); ?></td>
                    </tr>
                    <tr>
                        <td class="label-cell">Remise</td>
                        <td><?php echo e(number_format($remise, 2, ',', ' ')); ?> <?php echo e($dossier->currency->symbole ?? 'MAD'); ?></td>
                    </tr>
                    <tr class="highlight-row">
                        <td class="label-cell">Montant Compagnie</td>
                        <td><?php echo e(number_format($montantcompany, 2, ',', ' ')); ?> <?php echo e($dossier->currency->symbole ?? 'MAD'); ?></td>
                    </tr>
                    <tr>
                        <td class="label-cell">Montant Client</td>
                        <td><?php echo e(number_format($montantclient, 2, ',', ' ')); ?> <?php echo e($dossier->currency->symbole ?? 'MAD'); ?></td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>

    <!-- DETAILS EN % / RÉPARTITION -->
    <table class="two-col-table" style="margin-top: 8px;">
        <tr>
            <td>
                <?php
                    // Calculate total Main d'œuvre (all main0X values)
                    $totalMainOeuvre = $main01 + $main02 + $main03 + $main04 + $main05 + $main06 + $main07;
                    $totalIngredient = $ingr;
                    $totalPieces = $montantpieces;
                    $grandTotal = $totalMainOeuvre + $totalIngredient + $totalPieces;
                    
                    // Calculate percentages
                    $pctMainOeuvre = $grandTotal > 0 ? round(($totalMainOeuvre / $grandTotal) * 100, 1) : 0;
                    $pctIngredient = $grandTotal > 0 ? round(($totalIngredient / $grandTotal) * 100, 1) : 0;
                    $pctPieces = $grandTotal > 0 ? round(($totalPieces / $grandTotal) * 100, 1) : 0;
                ?>
                <div style="border: 1px solid #718096; padding: 8px; background: #f7fafc;">
                    <div style="background-color: #1a365d; color: white; font-size: 9px; font-weight: bold; padding: 5px; margin-bottom: 8px; text-align: center;">RÉPARTITION DES COÛTS</div>
                    
                    <!-- Stacked Bar Chart (simulates pie chart) -->
                    <div style="width: 100%; height: 30px; border: 1px solid #718096; overflow: hidden; margin-bottom: 8px;">
                        <?php if($pctMainOeuvre > 0): ?>
                            <div style="display: inline-block; width: <?php echo e($pctMainOeuvre); ?>%; height: 100%; background: #2b6cb0; float: left;"></div>
                        <?php endif; ?>
                        <?php if($pctIngredient > 0): ?>
                            <div style="display: inline-block; width: <?php echo e($pctIngredient); ?>%; height: 100%; background: #38a169; float: left;"></div>
                        <?php endif; ?>
                        <?php if($pctPieces > 0): ?>
                            <div style="display: inline-block; width: <?php echo e($pctPieces); ?>%; height: 100%; background: #ed8936; float: left;"></div>
                        <?php endif; ?>
                    </div>
                    
                    <!-- Legend with bars -->
                    <table style="width: 100%; font-size: 7px; border-collapse: collapse;">
                        <tr>
                            <td style="padding: 3px; width: 35%;">
                                <span style="display: inline-block; width: 12px; height: 12px; background: #2b6cb0; vertical-align: middle; margin-right: 3px;"></span>
                                <strong>Main d'œuvre</strong>
                            </td>
                            <td style="padding: 3px; text-align: right; width: 30%;"><?php echo e(number_format($totalMainOeuvre, 0, ',', ' ')); ?> <?php echo e($dossier->currency->symbole ?? 'MAD'); ?></td>
                            <td style="padding: 3px; text-align: right; width: 15%; font-weight: bold; color: #2b6cb0;"><?php echo e($pctMainOeuvre); ?>%</td>
                        </tr>
                        <tr>
                            <td style="padding: 3px;">
                                <span style="display: inline-block; width: 12px; height: 12px; background: #38a169; vertical-align: middle; margin-right: 3px;"></span>
                                <strong>Ingrédient</strong>
                            </td>
                            <td style="padding: 3px; text-align: right;"><?php echo e(number_format($totalIngredient, 0, ',', ' ')); ?> <?php echo e($dossier->currency->symbole ?? 'MAD'); ?></td>
                            <td style="padding: 3px; text-align: right; font-weight: bold; color: #38a169;"><?php echo e($pctIngredient); ?>%</td>
                        </tr>
                        <tr>
                            <td style="padding: 3px;">
                                <span style="display: inline-block; width: 12px; height: 12px; background: #ed8936; vertical-align: middle; margin-right: 3px;"></span>
                                <strong>Pièces</strong>
                            </td>
                            <td style="padding: 3px; text-align: right;"><?php echo e(number_format($totalPieces, 0, ',', ' ')); ?> <?php echo e($dossier->currency->symbole ?? 'MAD'); ?></td>
                            <td style="padding: 3px; text-align: right; font-weight: bold; color: #ed8936;"><?php echo e($pctPieces); ?>%</td>
                        </tr>
                        <tr style="border-top: 1px solid #718096; background: #e2e8f0;">
                            <td style="padding: 4px; font-weight: bold;">TOTAL</td>
                            <td style="padding: 4px; text-align: right; font-weight: bold;"><?php echo e(number_format($grandTotal, 0, ',', ' ')); ?> <?php echo e($dossier->currency->symbole ?? 'MAD'); ?></td>
                            <td style="padding: 4px; text-align: right; font-weight: bold;">100%</td>
                        </tr>
                    </table>
                </div>
            </td>
            <td>
                <!-- SHOCK POINT -->
                <?php if($chock): ?>
                <div class="shock-box">
                    <div class="shock-title">POINT DE CHOC</div>
                    <img class="shock-image" src="<?php echo e(Storage::disk('s3')->temporaryUrl($chock->path, now()->addMinutes(30))); ?>" alt="Point de Choc">
                    <div class="shock-points">
                        <strong>Points:</strong>
                        <?php $__currentLoopData = $dossier->shockpoint; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $point): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php echo e($point->point); ?><?php if(!$loop->last): ?>, <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
                <?php endif; ?>
            </td>
        </tr>
    </table>

    <!-- OBSERVATIONS -->
    <table class="two-col-table" style="margin-top: 8px;">
        <tr>
            <td colspan="2">
                <div class="obs-box">
                    <div class="obs-title">OBSERVATIONS</div>
                    <?php if(count($observations) > 0): ?>
                        <?php $__currentLoopData = $observations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $observation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="obs-item"><?php echo e($observation->observation); ?></div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <div style="font-size: 8px; color: #999; font-style: italic;">Aucune observation</div>
                    <?php endif; ?>
                </div>
            </td>
        </tr>
    </table>

    <!-- SIGNATURE SECTION -->
    <?php if($sign > 0): ?>
        <table class="signature-table">
            <tr>
                <td class="signature-cell">
                    <img src="img/sign.png" style="height: 50px; width: auto;">
                    <div class="signature-label">L'EXPERT</div>
                </td>
                <td class="signature-cell">
                    <div class="signature-line"></div>
                    <div class="signature-label">
                        <?php if($dossier->contradictoire): ?>
                            <?php echo e($dossier->contradictoire->adverse->name ?? 'EXPERT ADVERSE'); ?>

                        <?php else: ?>
                            EXPERT ADVERSE
                        <?php endif; ?>
                    </div>
                </td>
            </tr>
        </table>
    <?php endif; ?>

    <!-- FOOTER -->
    <div class="page-footer">
        <div class="company-info">
            <strong>AMEA - Cabinet d'Expertise Automobile Agréé</strong><br>
            Parc Plaza Bd. Yaakoub Al Mansour Imm.G2 28800 - Mohammedia<br>
            Tél: 052330564 - Fax: 0523305672 - Email: amea.maroc@gmail.com<br>
            RC: 12583 | TP: 39570820 | IF: 14392431 | CNSS: 4472213 | ICE: 001376800000001
        </div>
    </div>

    <!-- ======================== PAGE 2: PIECES DETAIL ======================== -->
    <div class="page-break"></div>
    
    <table class="header-container" style="width: 100%;">
        <tr>
            <td class="logo-cell">
                <img src="img/amea2.png" style="height: 40px; width: auto;" alt="AMEA">
            </td>
            <td class="title-cell">
                <div style="font-size: 12px; font-weight: bold; color: #1a365d;">DÉTAIL DES PIÈCES ET OPÉRATIONS</div>
            </td>
            <td class="ref-cell">
                <div style="font-size: 9px; font-weight: bold;">Réf: <?php echo e($dossier->ref ?? 'N/A'); ?></div>
            </td>
        </tr>
    </table>

    <div class="section-header">LISTE DES PIÈCES</div>
    <table class="pieces-table">
        <tr>
            <th style="width: 20%;">Désignation</th>
            <th style="width: 8%;">Qté</th>
            <th style="width: 15%;">Opération</th>
            <th style="width: 10%;">Type</th>
            <th style="width: 10%;">Remise</th>
            <th style="width: 10%;">Vétusté</th>
            <th style="width: 12%;">Prix U.</th>
            <th style="width: 15%;">Montant</th>
        </tr>
        <?php if($rapport->piece): ?>
            <?php $__currentLoopData = $rapport->piece; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $piece): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td style="text-align: left;"><?php echo e($piece->piece ?? '-'); ?></td>
                    <td><?php echo e($piece->pivot->qte ?? '-'); ?></td>
                    <td><?php echo e($piece->pivot->operation->operation ?? '-'); ?></td>
                    <td><?php echo e($piece->pivot->typereparation->type ?? '-'); ?></td>
                    <td><?php echo e($piece->pivot->remise ?? 0); ?>%</td>
                    <td><?php echo e($piece->pivot->vetuste ?? 0); ?>%</td>
                    <td><?php echo e(number_format($piece->pivot->prix_unitaire ?? 0, 2, ',', ' ')); ?></td>
                    <td>
                        <?php if($piece->pivot->type_reparation_id == 1): ?>
                            <?php
                                $rem = $piece->pivot->qte * $piece->pivot->prix_unitaire * ($piece->pivot->remise / 100);
                                $montantpieces = $piece->pivot->prix_unitaire * $piece->pivot->qte - $rem;
                                $vet = $montantpieces * ($piece->pivot->vetuste / 100);
                                $montantpieces = $montantpieces - $vet;
                            ?>
                        <?php else: ?>
                            <?php
                                $rem = $piece->pivot->qte * $piece->pivot->prix_unitaire * ($piece->pivot->remise / 100);
                                $tvaa = ($piece->pivot->prix_unitaire * $piece->pivot->qte - $rem) * 0.2;
                                $montantpieces = $piece->pivot->prix_unitaire * $piece->pivot->qte - $rem + $tvaa;
                                if ($rapport->taux && $rapport->taux->tva_deductible) {
                                    $vet = ($piece->pivot->qte * $piece->pivot->prix_unitaire - $rem) * ($piece->pivot->vetuste / 100);
                                } else {
                                    $vet = ($piece->pivot->qte * $piece->pivot->prix_unitaire - $rem + $tvaa) * ($piece->pivot->vetuste / 100);
                                }
                                $montantpieces = $montantpieces - $vet;
                            ?>
                        <?php endif; ?>
                        <?php echo e(number_format($montantpieces, 2, ',', ' ')); ?>

                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>
    </table>

    <!-- CONTRADICTOIRE SECTION -->
    <div style="margin-top: 15px; font-size: 8px; border: 1px solid #718096; padding: 8px; background: #f7fafc;">
        <strong>Examen Contradictoire effectué en présence de:</strong> <?php echo e($dossier->insured->civility ?? ''); ?> <?php echo e($dossier->insured->name ?? '-'); ?><br>
        <em>Visé après accord sur les dégâts apparents constatés</em>
    </div>

    <!-- WARNING -->
    <div class="warning-box">
        ⚠️ CECI N'EST PAS UN BON DE PRISE EN CHARGE NI UN ORDRE DE PAIEMENT
    </div>

    <div style="font-size: 7px; text-align: center; margin-top: 10px;">
        POUR FAIRE VALOIR LE PRÉSENT DOCUMENT, IL DOIT ÊTRE COSIGNÉ DES DEUX PARTIES
    </div>

    <!-- SIGNATURE SECTION PAGE 2 -->
    <table class="signature-table">
        <tr>
            <td class="signature-cell">
                <?php if($sign > 0): ?>
                    <img src="img/sign.png" style="height: 40px; width: auto;">
                <?php else: ?>
                    <div class="signature-line"></div>
                <?php endif; ?>
                <div class="signature-label">L'EXPERT</div>
            </td>
            <td class="signature-cell">
                <div class="signature-line"></div>
                <div class="signature-label">
                    <?php if($dossier->contradictoire): ?>
                        <?php echo e($dossier->contradictoire->adverse->name ?? 'EXPERT ADVERSE'); ?>

                    <?php else: ?>
                        EXPERT ADVERSE
                    <?php endif; ?>
                </div>
            </td>
        </tr>
    </table>

    <!-- FOOTER PAGE 2 -->
    <div class="page-footer">
        <div class="company-info">
            AMEA - Parc Plaza Bd. Yaakoub Al Mansour Imm.G2 28800 Mohammedia | Tél: 052330564 | ICE: 001376800000001
        </div>
    </div>

    <!-- ======================== PAGE 3: PHOTO GALLERY ======================== -->
    <?php if($rapport->documents_count > 0): ?>
        <div class="page-break"></div>
        
        <table class="header-container" style="width: 100%;">
            <tr>
                <td class="logo-cell">
                    <img src="img/amea2.png" style="height: 40px; width: auto;" alt="AMEA">
                </td>
                <td class="title-cell">
                    <div style="font-size: 12px; font-weight: bold; color: #1a365d;">DOCUMENTATION PHOTOGRAPHIQUE</div>
                </td>
                <td class="ref-cell">
                    <div style="font-size: 9px; font-weight: bold;">Réf: <?php echo e($dossier->ref ?? 'N/A'); ?></div>
                </td>
            </tr>
        </table>

        <table class="gallery-table">
            <?php $__currentLoopData = $rapport->documents->chunk(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <?php $__currentLoopData = $row; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $doc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <td class="gallery-cell">
                            <img class="gallery-img" src="<?php echo e(Storage::disk('s3')->temporaryUrl($doc->path, now()->addMinutes(30))); ?>" alt="Photo <?php echo e($loop->parent->index * 3 + $loop->index + 1); ?>">
                            <div class="gallery-label"><?php echo e($doc->typedocument->type ?? 'Photo'); ?> #<?php echo e($loop->parent->index * 3 + $loop->index + 1); ?></div>
                        </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php for($i = $row->count(); $i < 3; $i++): ?>
                        <td class="gallery-cell" style="background: transparent; border: none;"></td>
                    <?php endfor; ?>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </table>

        <div class="page-footer">
            <div class="company-info">
                AMEA - Cabinet d'Expertise Automobile Agréé | ICE: 001376800000001
            </div>
        </div>
    <?php endif; ?>

    <script type="text/php">
        if (isset($pdf)) {
            $pageText = "Page {PAGE_NUM} / {PAGE_COUNT}";
            $font = $fontMetrics->get_font("DejaVu Sans", "normal");
            $size = 8;
            $color = array(0.4, 0.4, 0.4);
            $x = 270;
            $y = 820;
            $pdf->page_text($x, $y, $pageText, $font, $size, $color);
        }
    </script>
</body>

</html>
<?php /**PATH /home/amea/public_html/demo4.ameaengi.com/resources/views/configuration/pdf/normalnew.blade.php ENDPATH**/ ?>