<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" class="menuitem-active">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>

    <link rel="shortcut icon" href="<?php echo e(asset('img/icon.png')); ?>" type="image/png">
    <title><?php echo e(config('app.name', 'AMEA')); ?></title>

    
    

    
    <script>
        window.onload = function(){
            document.getElementById('content').style.display ="block";
            document.getElementById('content').style.backgroundColor ="#ffffff";
            document.getElementById('loading').style.display ="none";
        }
    </script>
    <style>
        body{
            background: #b6cdff !important;
        }
        .scrollable-container {
    overflow: auto; /* or overflow: scroll; */
}

        #content {
            /* margin: 0;
            height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            background-color: rgb(237, 222, 222); */
            display: none;


        }

        #loading {
            width: 100%;
            height: 100%;
            position: relative;
            display: flex;
            align-items: center;
            justify-content: center;
            background-color: rgba(255, 255, 255, 0.3);
            z-index: 1;
        }

        .loader {
            width: 11.7em;
            height: 4.2em;
            font-size: 20px;
            position: absolute;
            color: #313a46;
            z-index: 9999;
            position: fixed;
            top: 40%;
            left: 40%;

        }

        .car {
            position: absolute;
            width: inherit;
            height: 2em;
            background-color: #313a46;
            top: 1.5em;
            border-radius: 0 5em 1em 0 / 0 4em 1em 0;
            animation: run 0.25s linear infinite;
        }

        @keyframes run {
            0% {
                transform: translate(0.2em, 0.1em);
            }

            20% {
                transform: translate(0.1em, 0.2em);
            }

            40% {
                transform: translate(0.1em, -0.1em);
            }

            60% {
                transform: translate(-0.1em, 0.2em);
            }

            80% {
                transform: translate(-0.1em, 0.1em);
            }

            100% {
                transform: translate(0.2em, 0.1em);
            }
        }

        .car::before {
            content: '';
            position: absolute;
            width: 0;
            height: 0;
            border: 0.6em solid transparent;
            top: -0.5em;
            border-left-width: 0;
            border-right-color: currentColor;
            transform-origin: left;
            transform: rotate(-45deg);
        }

        .body {
            position: absolute;
            width: 7.5em;
            height: 3.5em;
            box-sizing: border-box;
            border: 0.4em solid;
            top: -1.5em;
            left: 1.2em;
            border-radius: 3em 4.5em 0 0 / 3em 4em 0 0;
        }

        .body::before {
            content: '';
            position: absolute;
            width: 3.5em;
            height: inherit;
            background-color: #313a46;
            border-top-left-radius: inherit;
            top: -0.4em;
            left: -0.4em;
        }

        .wheels::before,
        .wheels::after {
            content: '';
            position: absolute;
            box-sizing: border-box;
            width: 2.6em;
            height: 2.6em;
            background-color: rgb(188, 228, 231);
            border-radius: 50%;
            bottom: -1em;
            border: 0.3em solid rgb(188, 228, 231);
            background-image:
                linear-gradient(135deg,
                    transparent 45%,
                    currentColor 46%, currentColor 54%,
                    transparent 55%),
                linear-gradient(90deg,
                    transparent 45%,
                    currentColor 46%, currentColor 54%,
                    transparent 55%),
                linear-gradient(45deg,
                    transparent 45%,
                    currentColor 46%, currentColor 54%,
                    transparent 55%),
                linear-gradient(0deg,
                    transparent 45%,
                    currentColor 46%, currentColor 54%,
                    transparent 55%),
                radial-gradient(currentColor 29%,
                    transparent 30%, transparent 50%,
                    currentColor 51%);
            animation: rotating 0.5s linear infinite;
        }

        .wheels::before {
            left: 1.2em;
        }

        .wheels::after {
            right: 0.8em;
        }

        @keyframes rotating {
            to {
                transform: rotate(1turn);
            }
        }

        .strikes {
            position: absolute;
            width: 1em;
            height: inherit;
            left: -1em;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
        }

        .strikes span {
            height: 0.1em;
            background-color: #313a46;
            animation: drift 0.2s linear infinite;
            animation-delay: calc(var(--n) * -0.05s);
        }

        @keyframes drift {
            from {
                transform: translate(3.5em);
            }

            to {
                transform: translate(-8em);
                filter: opacity(0);
            }
        }

        .strikes span:nth-child(1) {
            --n: 1;
        }

        .strikes span:nth-child(2) {
            --n: 2;
        }

        .strikes span:nth-child(3) {
            --n: 3;
        }

        .strikes span:nth-child(4) {
            --n: 4;
        }

        .strikes span:nth-child(5) {
            --n: 5;
        }
        /* Go To Top / Bottom Buttons */
.scroll-buttons {
    position: fixed;
    right: 20px;
    bottom: 20px;
    display: flex;
    flex-direction: column;
    gap: 8px;
    z-index: 1050; /* Above most content, below modals (if any) */
}

.scroll-btn {
    width: 48px;
    height: 48px;
    border-radius: 12px;
    background: linear-gradient(135deg, #10b981, #059669);
    color: white;
    border: none;
    box-shadow: 0 4px 12px rgba(16, 185, 129, 0.4);
    cursor: pointer;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 20px;
    transition: all 0.3s ease;
    opacity: 0;
    transform: translateY(20px);
    visibility: hidden;
}

.scroll-btn.visible {
    opacity: 1;
    transform: translateY(0);
    visibility: visible;
}

.scroll-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 16px rgba(16, 185, 129, 0.6);
}

.scroll-btn:active {
    transform: scale(0.95);
}

/* Optional: Hide on very small screens */
@media (max-width: 576px) {
    .scroll-buttons {
        right: 15px;
        bottom: 15px;
    }
    
    .scroll-btn {
        width: 42px;
        height: 42px;
        font-size: 18px;
    }
}
    </style>

    <link rel="stylesheet" href="<?php echo e(asset('css/dataTables/dataTables.bootstrap.css')); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.1/css/all.min.css">
    <link rel="stylesheet" href="<?php echo e(asset('css/icons.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/app.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/search.css')); ?>">
    <?php echo $__env->yieldContent('style'); ?>
    <?php echo \Livewire\Livewire::styles(); ?>



</head>

<body id="body" data-layout-color="light" data-layout-mode="fluid" data-rightbar-onstart="true" data-leftbar-theme="dark"
    style="">




    <div class="wrapper" id="content">
        <?php echo $__env->make('layouts.dashboard.partials.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="content-page">
            <div class="content">
                <?php echo $__env->make('layouts.config_dashboard.partials.topbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="container-fluid m-0 p-0 mt-1 ">

                    <?php echo $__env->make('errors.alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php echo $__env->yieldContent('content'); ?>
                </div>
            </div>

            <footer class="footer mt-3">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-md-6">
                            ENGI - BLK consulting
                        </div>
                    </div>
                </div>
            </footer>
        </div>
    </div>
          <!-- Go To Top / Bottom Button -->
<div id="scrollButtons" class="scroll-buttons">
    <button id="goToTopBtn" class="scroll-btn top-btn" title="Aller en haut">
        <i class="uil uil-arrow-up"></i>
    </button>
    <button id="goToBottomBtn" class="scroll-btn bottom-btn" title="Aller en bas">
        <i class="uil uil-arrow-down"></i>
    </button>
</div>

    <!-- Scripts -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.16.9/xlsx.full.min.js"></script>

    <script src="<?php echo e(asset('js/vendor.js')); ?>"></script>
    <script src="<?php echo e(asset('js/app.js')); ?>" defer></script>
    

    <script src="<?php echo e(asset('js/dataTables.js/dataTables.js')); ?>"></script>
    <script src="<?php echo e(asset('js/viewer.js')); ?>"></script>
    

    <script>
        $(document).ready(function() {
            var allTables = $('table.dataTable').DataTable();
            allTables.column(0).search('mySearchTerm').draw();
            $('#myTable').DataTable({
                language: {
                    url: "https://cdn.datatables.net/plug-ins/1.12.1/i18n/fr-FR.json"
                },
                // dom: 'Bfrtip',
                // buttons: [
                //     'copy', 'csv', 'excel', 'pdf', 'print'
                // ],
                // pagingType: "numbers"
            });
            $('#myTable2').DataTable({
                language: {
                    url: "https://cdn.datatables.net/plug-ins/1.12.1/i18n/fr-FR.json"
                } //,
                // pagingType: "numbers"
            });




        });
        console.log(10);
    </script>
   <script>
        function exportToExcel() {
    var table = $('#myTable').DataTable();

    // Set a reasonable chunk size (you can adjust this based on your needs)
    var chunkSize = 500;

    // Save current page
    var currentPage = table.page();

    // Get the total number of rows
    var totalRows = table.rows().count();

    // Calculate the number of chunks needed
    var totalChunks = Math.ceil(totalRows / chunkSize);

    // Create a new workbook
    var wb = XLSX.utils.book_new();

    // Loop through each chunk
    for (var i = 0; i < totalChunks; i++) {
        // Go to the page
        table.page(i).draw('page');

        // Get all data from the current page
        var currentPageData = [];
        table.rows().every(function () {
            var rowData = [];
            $(this.node()).find('td').each(function () {
                rowData.push($(this).text());
            });
            currentPageData.push(rowData);
        });

        // Convert the data to a SheetJS worksheet
        var ws = XLSX.utils.aoa_to_sheet(currentPageData);

        // Add the worksheet to the workbook
        XLSX.utils.book_append_sheet(wb, ws, 'Chunk ' + (i + 1));
    }

    // Restore the original page
    table.page(currentPage).draw('page');

    // Convert the workbook to a binary Excel file
    var wbout = XLSX.write(wb, {
        bookType: 'xlsx',
        type: 'binary'
    });

    function s2ab(s) {
        var buf = new ArrayBuffer(s.length);
        var view = new Uint8Array(buf);
        for (var i = 0; i < s.length; i++) view[i] = s.charCodeAt(i) & 0xFF;
        return buf;
    }

    // Save the Excel file
    saveAs(new Blob([s2ab(wbout)], {
        type: 'application/octet-stream'
    }), 'exported_data.xlsx');
}



        // SaveAs function from https://github.com/eligrey/FileSaver.js/
        function saveAs(blob, filename) {
            var url = window.URL.createObjectURL(blob);
            var a = document.createElement('a');
            a.href = url;
            a.download = filename || 'download';
            var clickHandler = function() {
                setTimeout(function() {
                    window.URL.revokeObjectURL(url);
                }, 1500);
            };
            a.addEventListener('click', clickHandler, false);
            a.click();
            return a;
        }
    </script>

    <script>
document.addEventListener('DOMContentLoaded', function() {
    const goToTopBtn = document.getElementById('goToTopBtn');
    const goToBottomBtn = document.getElementById('goToBottomBtn');

    // Show buttons only after scrolling down a bit
    window.addEventListener('scroll', function() {
        const scrollPos = window.scrollY;
        const isVisible = scrollPos > 300;

        if (isVisible) {
            goToTopBtn.classList.add('visible');
        } else {
            goToTopBtn.classList.remove('visible');
        }

        // Optional: Show Bottom button only if not near bottom
        const scrollHeight = document.documentElement.scrollHeight;
        const clientHeight = document.documentElement.clientHeight;
        const nearBottom = scrollPos + clientHeight >= scrollHeight - 200;
        
        if (scrollPos > 100 && !nearBottom) {
            goToBottomBtn.classList.add('visible');
        } else {
            goToBottomBtn.classList.remove('visible');
        }
    });

    // Smooth scroll to top
    goToTopBtn?.addEventListener('click', function(e) {
        e.preventDefault();
        window.scrollTo({
            top: 0,
            behavior: 'smooth'
        });
    });

    // Smooth scroll to bottom
    goToBottomBtn?.addEventListener('click', function(e) {
        e.preventDefault();
        window.scrollTo({
            top: document.documentElement.scrollHeight,
            behavior: 'smooth'
        });
    });
});
</script>
  
    <?php echo \Livewire\Livewire::scripts(); ?>

    <?php echo $__env->yieldContent('script'); ?>
</body>

</html>
<?php /**PATH /home/amea/public_html/demo4.ameaengi.com/resources/views/layouts/config_dashboard/app.blade.php ENDPATH**/ ?>