<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" class="menuitem-active">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />

    <link rel="shortcut icon" href="<?php echo e(asset('img/icon.png')); ?>" type="image/png">
    <title><?php echo e(config('app.name', 'AMEA')); ?></title>

    
    <script>
        window.onload = function() {
            document.getElementById('content').style.display = "block";
            document.getElementById('content').style.backgroundColor = "#ffffff";
            document.getElementById('loading').style.opacity = "0";
            setTimeout(function() {
                document.getElementById('loading').style.display = "none";
            }, 300);
        }
    </script>
    <style>
        :root {
            --primary-color: #10b981;
            --primary-dark: #059669;
            --bg-dark: #1a1a2e;
            --bg-darker: #16213e;
        }

        body {
            background: #f1f5f9 !important;
            margin: 0;
            padding: 0;
        }

        #content {
            display: none;
        }

        /* ============================================
           PROFESSIONAL LOADING SCREEN
           ============================================ */
        #loading {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            background: linear-gradient(135deg, var(--bg-dark) 0%, var(--bg-darker) 100%);
            z-index: 99999;
            transition: opacity 0.3s ease;
        }

        /* Logo Container */
        .loader-logo {
            margin-bottom: 40px;
            animation: float 2s ease-in-out infinite;
        }

        .loader-logo img {
            width: 120px;
            height: auto;
            filter: drop-shadow(0 10px 30px rgba(16, 185, 129, 0.3));
        }

        /* Fallback if no logo - Text Logo */
        .loader-logo-text {
            font-size: 42px;
            font-weight: 800;
            background: linear-gradient(135deg, #10b981 0%, #34d399 50%, #10b981 100%);
            background-size: 200% auto;
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            animation: shimmer 2s linear infinite;
            letter-spacing: 4px;
        }

        @keyframes shimmer {
            to {
                background-position: 200% center;
            }
        }

        @keyframes float {
            0%, 100% {
                transform: translateY(0);
            }
            50% {
                transform: translateY(-10px);
            }
        }

        /* Modern Spinner */
        .loader-spinner {
            position: relative;
            width: 60px;
            height: 60px;
            margin-bottom: 30px;
        }

        .loader-spinner::before,
        .loader-spinner::after {
            content: '';
            position: absolute;
            border-radius: 50%;
        }

        .loader-spinner::before {
            width: 100%;
            height: 100%;
            border: 3px solid rgba(255, 255, 255, 0.1);
            border-top-color: var(--primary-color);
            animation: spin 1s linear infinite;
        }

        .loader-spinner::after {
            width: 70%;
            height: 70%;
            top: 15%;
            left: 15%;
            border: 3px solid rgba(255, 255, 255, 0.05);
            border-bottom-color: var(--primary-dark);
            animation: spin 0.8s linear infinite reverse;
        }

        @keyframes spin {
            to {
                transform: rotate(360deg);
            }
        }

        /* Progress Bar */
        .loader-progress {
            width: 200px;
            height: 4px;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 4px;
            overflow: hidden;
            margin-bottom: 20px;
        }

        .loader-progress-bar {
            height: 100%;
            width: 30%;
            background: linear-gradient(90deg, var(--primary-color), var(--primary-dark), var(--primary-color));
            background-size: 200% 100%;
            border-radius: 4px;
            animation: progress 1.5s ease-in-out infinite;
        }

        @keyframes progress {
            0% {
                width: 0%;
                margin-left: 0;
            }
            50% {
                width: 60%;
                margin-left: 20%;
            }
            100% {
                width: 0%;
                margin-left: 100%;
            }
        }

        /* Loading Text */
        .loader-text {
            color: rgba(255, 255, 255, 0.7);
            font-size: 14px;
            font-weight: 500;
            letter-spacing: 2px;
            text-transform: uppercase;
        }

        .loader-text span {
            display: inline-block;
            animation: bounce 1.4s ease-in-out infinite;
        }

        .loader-text span:nth-child(1) { animation-delay: 0s; }
        .loader-text span:nth-child(2) { animation-delay: 0.1s; }
        .loader-text span:nth-child(3) { animation-delay: 0.2s; }
        .loader-text span:nth-child(4) { animation-delay: 0.3s; }
        .loader-text span:nth-child(5) { animation-delay: 0.4s; }
        .loader-text span:nth-child(6) { animation-delay: 0.5s; }
        .loader-text span:nth-child(7) { animation-delay: 0.6s; }
        .loader-text span:nth-child(8) { animation-delay: 0.7s; }
        .loader-text span:nth-child(9) { animation-delay: 0.8s; }
        .loader-text span:nth-child(10) { animation-delay: 0.9s; }

        @keyframes bounce {
            0%, 60%, 100% {
                transform: translateY(0);
                opacity: 0.7;
            }
            30% {
                transform: translateY(-5px);
                opacity: 1;
            }
        }

        /* Decorative Elements */
        .loader-dots {
            position: absolute;
            bottom: 50px;
            display: flex;
            gap: 8px;
        }

        .loader-dots span {
            width: 8px;
            height: 8px;
            background: var(--primary-color);
            border-radius: 50%;
            animation: dotPulse 1.5s ease-in-out infinite;
        }

        .loader-dots span:nth-child(1) { animation-delay: 0s; }
        .loader-dots span:nth-child(2) { animation-delay: 0.2s; }
        .loader-dots span:nth-child(3) { animation-delay: 0.4s; }

        @keyframes dotPulse {
            0%, 100% {
                transform: scale(1);
                opacity: 0.5;
            }
            50% {
                transform: scale(1.5);
                opacity: 1;
            }
        }

        /* Background Decoration */
        .loader-bg-circles {
            position: absolute;
            width: 100%;
            height: 100%;
            overflow: hidden;
            pointer-events: none;
        }

        .loader-bg-circles span {
            position: absolute;
            border-radius: 50%;
            background: linear-gradient(135deg, rgba(16, 185, 129, 0.1), rgba(16, 185, 129, 0.05));
            animation: floatBubble 15s infinite;
        }

        .loader-bg-circles span:nth-child(1) {
            width: 80px;
            height: 80px;
            top: 10%;
            left: 10%;
            animation-delay: 0s;
        }

        .loader-bg-circles span:nth-child(2) {
            width: 120px;
            height: 120px;
            top: 70%;
            right: 10%;
            animation-delay: 2s;
        }

        .loader-bg-circles span:nth-child(3) {
            width: 60px;
            height: 60px;
            bottom: 20%;
            left: 20%;
            animation-delay: 4s;
        }

        .loader-bg-circles span:nth-child(4) {
            width: 100px;
            height: 100px;
            top: 30%;
            right: 20%;
            animation-delay: 6s;
        }

        @keyframes floatBubble {
            0%, 100% {
                transform: translateY(0) rotate(0deg);
                opacity: 0.3;
            }
            50% {
                transform: translateY(-30px) rotate(180deg);
                opacity: 0.6;
            }
        }

        /* Side Navigation Items */
        .side-nav-item {
            cursor: pointer;
        }

        .side-nav-link {
            cursor: pointer;
        }
    </style>

    <link rel="stylesheet" href="<?php echo e(asset('css/dataTables/dataTables.bootstrap.css')); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.1/css/all.min.css">
    <link rel="stylesheet" href="<?php echo e(asset('css/icons.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/app.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/search.css')); ?>">
    <?php echo $__env->yieldContent('style'); ?>
    <?php echo \Livewire\Livewire::styles(); ?>

</head>

<body id="body" data-layout-color="light" data-layout-mode="fluid" data-rightbar-onstart="true"
    data-leftbar-theme="dark">

    <!-- Professional Loading Screen -->
    <div id="loading">
        <!-- Background Decoration -->
        <div class="loader-bg-circles">
            <span></span>
            <span></span>
            <span></span>
            <span></span>
        </div>

        <!-- Logo -->
        <div class="loader-logo">
            
            
            <div class="loader-logo-text">AMEA</div>
        </div>

        <!-- Spinner -->
        <div class="loader-spinner"></div>

        <!-- Progress Bar -->
        <div class="loader-progress">
            <div class="loader-progress-bar"></div>
        </div>

        <!-- Loading Text -->
        <div class="loader-text">
            <span>C</span><span>h</span><span>a</span><span>r</span><span>g</span><span>e</span><span>m</span><span>e</span><span>n</span><span>t</span><span>.</span><span>.</span><span>.</span>
        </div>

        <!-- Bottom Dots -->
        <div class="loader-dots">
            <span></span>
            <span></span>
            <span></span>
        </div>
    </div>

    <!-- Main Content -->
    <div class="wrapper" id="content">
        <?php echo $__env->make('layouts.config_dashboard.partials.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="content-page">
            <div class="content">
                <?php echo $__env->make('layouts.config_dashboard.partials.topbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="container-fluid m-0 p-0 mt-1">
                    <?php echo $__env->make('errors.alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <?php echo $__env->yieldContent('content'); ?>
                </div>
            </div>

            <footer class="footer mt-3">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-md-6">
                            ENGI V0.1 - BLK consulting
                        </div>
                    </div>
                </div>
            </footer>
        </div>
    </div>

    <!-- Scripts -->
    <script src="<?php echo e(asset('js/vendor.js')); ?>"></script>
    <script src="<?php echo e(asset('js/app.js')); ?>" defer></script>
    <script src="<?php echo e(asset('js/dataTables.js/dataTables.js')); ?>"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.16.9/xlsx.full.min.js"></script>

    <script>
        $(document).ready(function() {
            var allTables = $('table.dataTable').DataTable();
            allTables.column(0).search('mySearchTerm').draw();
            $('#myTable').DataTable({
                language: {
                    url: "https://cdn.datatables.net/plug-ins/1.12.1/i18n/fr-FR.json"
                },
            });
            $('#myTable').on('page.dt', function() {
                console.log('Page changed');
            });
            $('#myTable2').DataTable({
                language: {
                    url: "https://cdn.datatables.net/plug-ins/1.12.1/i18n/fr-FR.json"
                }
            });
        });
    </script>

    <script>
        function exportToExcel() {
            var table = $('#myTable').DataTable();
            var chunkSize = 500;
            var currentPage = table.page();
            var totalRows = table.rows().count();
            var totalChunks = Math.ceil(totalRows / chunkSize);
            var wb = XLSX.utils.book_new();

            for (var i = 0; i < totalChunks; i++) {
                table.page(i).draw('page');
                var currentPageData = [];
                table.rows().every(function() {
                    var rowData = [];
                    $(this.node()).find('td').each(function() {
                        rowData.push($(this).text());
                    });
                    currentPageData.push(rowData);
                });
                var ws = XLSX.utils.aoa_to_sheet(currentPageData);
                XLSX.utils.book_append_sheet(wb, ws, 'Chunk ' + (i + 1));
            }

            table.page(currentPage).draw('page');

            var wbout = XLSX.write(wb, {
                bookType: 'xlsx',
                type: 'binary'
            });

            function s2ab(s) {
                var buf = new ArrayBuffer(s.length);
                var view = new Uint8Array(buf);
                for (var i = 0; i < s.length; i++) view[i] = s.charCodeAt(i) & 0xFF;
                return buf;
            }

            saveAs(new Blob([s2ab(wbout)], {
                type: 'application/octet-stream'
            }), 'exported_data.xlsx');
        }

        function saveAs(blob, filename) {
            var url = window.URL.createObjectURL(blob);
            var a = document.createElement('a');
            a.href = url;
            a.download = filename || 'download';
            var clickHandler = function() {
                setTimeout(function() {
                    window.URL.revokeObjectURL(url);
                }, 1500);
            };
            a.addEventListener('click', clickHandler, false);
            a.click();
            return a;
        }
    </script>

    <?php echo \Livewire\Livewire::scripts(); ?>

    <?php echo $__env->yieldContent('script'); ?>
</body>

</html><?php /**PATH /home/amea/public_html/demo4.ameaengi.com/resources/views/layouts/test.blade.php ENDPATH**/ ?>