
<?php $__env->startSection('style'); ?>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/dropzone/5.4.0/min/dropzone.min.css">
    <link rel="stylesheet" href="<?php echo e(asset('css/viewer.css')); ?>">
    <style>
        /* ============================================
           DOSSIER SHOW PAGE - MODERN REDESIGN
           ============================================ */
        
        * {
            box-sizing: border-box;
        }

        /* Page Header */
        .dossier-header {
            background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%);
            border-radius: 16px;
            padding: 20px 25px;
            margin-bottom: 20px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.15);
        }

        .dossier-header-top {
            display: flex;
            align-items: center;
            justify-content: space-between;
            flex-wrap: wrap;
            gap: 15px;
        }

        .dossier-title {
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .dossier-title h4 {
            color: #fff;
            font-size: 22px;
            font-weight: 700;
            margin: 0;
        }

        .dossier-ref {
            color: #10b981;
            font-weight: 600;
        }

        .dossier-badges {
            display: flex;
            align-items: center;
            gap: 10px;
            flex-wrap: wrap;
        }

        .badge-time {
            display: flex;
            align-items: center;
            gap: 8px;
            padding: 8px 16px;
            border-radius: 25px;
            font-size: 14px;
            font-weight: 600;
        }

        .badge-time.warning {
            background: rgba(245, 158, 11, 0.2);
            color: #fbbf24;
        }

        .badge-time.danger {
            background: rgba(239, 68, 68, 0.2);
            color: #f87171;
        }

        .badge-time i {
            font-size: 16px;
        }

        /* Status Row */
        .dossier-status-row {
            display: flex;
            align-items: center;
            gap: 10px;
            margin-top: 15px;
            flex-wrap: wrap;
        }

        /* Modern Card */
        .modern-card {
            background: #fff;
            border-radius: 16px;
            box-shadow: 0 2px 20px rgba(0, 0, 0, 0.06);
            overflow: hidden;
            margin-bottom: 20px;
            border: none;
        }

        .modern-card .card-header {
            background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
            border-bottom: 1px solid #e2e8f0;
            padding: 16px 20px;
        }

        .modern-card .card-header h4 {
            margin: 0;
            font-size: 16px;
            font-weight: 600;
            color: #1e293b;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .modern-card .card-header h4 i {
            color: #10b981;
            font-size: 20px;
        }

        .modern-card .card-body {
            padding: 20px;
        }

        /* Info Grid - Responsive Key-Value Layout */
        .info-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 12px;
        }

        .info-item {
            display: flex;
            align-items: center;
            padding: 12px 15px;
            background: #f8fafc;
            border-radius: 10px;
            border-left: 3px solid #10b981;
            transition: all 0.2s ease;
        }

        .info-item:hover {
            background: #f1f5f9;
            transform: translateX(3px);
        }

        .info-label {
            font-size: 12px;
            color: #64748b;
            font-weight: 500;
            min-width: 120px;
            flex-shrink: 0;
        }

        .info-value {
            font-size: 14px;
            color: #1e293b;
            font-weight: 600;
            word-break: break-word;
        }

        /* Summary Cards Row */
        .summary-row {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
            margin-bottom: 20px;
        }

        .summary-card {
            background: #fff;
            border-radius: 12px;
            padding: 20px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
            display: flex;
            align-items: center;
            gap: 15px;
            transition: all 0.2s ease;
        }

        .summary-card:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
        }

        .summary-icon {
            width: 50px;
            height: 50px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 24px;
        }

        .summary-icon.primary {
            background: rgba(59, 130, 246, 0.1);
            color: #3b82f6;
        }

        .summary-icon.success {
            background: rgba(16, 185, 129, 0.1);
            color: #10b981;
        }

        .summary-icon.warning {
            background: rgba(245, 158, 11, 0.1);
            color: #f59e0b;
        }

        .summary-icon.info {
            background: rgba(6, 182, 212, 0.1);
            color: #06b6d4;
        }

        .summary-content h5 {
            font-size: 12px;
            color: #64748b;
            font-weight: 500;
            margin: 0 0 5px 0;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .summary-content p {
            font-size: 18px;
            font-weight: 700;
            color: #1e293b;
            margin: 0;
        }

        /* Two Column Layout */
        .two-col-layout {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 20px;
        }

        @media (max-width: 991px) {
            .two-col-layout {
                grid-template-columns: 1fr;
            }
        }

        /* Tables */
        .modern-table {
            width: 100%;
            border-collapse: separate;
            border-spacing: 0;
        }

        .modern-table thead th {
            background: #f8fafc;
            color: #475569;
            font-size: 11px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            padding: 12px 15px;
            border-bottom: 2px solid #e2e8f0;
            white-space: nowrap;
        }

        .modern-table tbody td {
            padding: 12px 15px;
            color: #334155;
            font-size: 13px;
            border-bottom: 1px solid #f1f5f9;
            vertical-align: middle;
        }

        .modern-table tbody tr:hover {
            background: #f8fafc;
        }

        /* Observations Section */
        .observation-list {
            max-height: 300px;
            overflow-y: auto;
            margin-bottom: 15px;
        }

        .observation-item {
            background: #f8fafc;
            border-radius: 10px;
            padding: 15px;
            margin-bottom: 10px;
            border-left: 3px solid #3b82f6;
        }

        .observation-item .author {
            font-size: 13px;
            font-weight: 600;
            color: #1e293b;
            display: flex;
            align-items: center;
            gap: 8px;
            margin-bottom: 8px;
        }

        .observation-item .author i {
            color: #3b82f6;
        }

        .observation-item .date {
            font-size: 11px;
            color: #94a3b8;
            margin-left: auto;
        }

        .observation-item .content {
            font-size: 13px;
            color: #475569;
            line-height: 1.5;
        }

        /* Shock Points */
        .shock-points {
            display: flex;
            flex-wrap: wrap;
            gap: 8px;
        }

        .shock-point-badge {
            background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);
            color: #fff;
            padding: 8px 15px;
            border-radius: 20px;
            font-size: 13px;
            font-weight: 600;
        }

        /* Responsive Tables */
        .table-responsive-card {
            overflow-x: auto;
            -webkit-overflow-scrolling: touch;
        }

        @media (max-width: 767px) {
            .dossier-header {
                padding: 15px;
            }

            .dossier-title h4 {
                font-size: 18px;
            }

            .info-grid {
                grid-template-columns: 1fr;
            }

            .summary-row {
                grid-template-columns: 1fr;
            }

            .badge-time {
                padding: 6px 12px;
                font-size: 12px;
            }
        }

        /* Action Icon */
        .action-icon-btn {
            width: 32px;
            height: 32px;
            border-radius: 8px;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            background: rgba(59, 130, 246, 0.1);
            color: #3b82f6;
            transition: all 0.2s ease;
        }

        .action-icon-btn:hover {
            background: #3b82f6;
            color: #fff;
        }
        .dossier-actions .card-body {
    display: flex;
    flex-wrap: wrap;  /* This makes buttons wrap! */
    gap: 10px;
}
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        
        <!-- Page Header -->
        <div class="dossier-header">
            <div class="dossier-header-top">
                <div class="dossier-title">
                    <h4>
                        <i class="uil uil-folder-open"></i>
                        Dossier <span class="dossier-ref"><?php echo e($dossier->ref); ?></span>
                    </h4>
                    <?php if($dossier->dossier_status_id === 1): ?>
                        <span class="badge bg-danger">Anomalie</span>
                    <?php endif; ?>
                    <?php if($dossier->sinistre_douteux): ?>
                        <span class="badge bg-warning">Sinistre Douteux</span>
                    <?php endif; ?>
                </div>
                <div class="dossier-badges">
                    <div class="badge-time warning">
                        <i class="uil uil-clock"></i>
                        <?php echo e($time->d); ?>j : <?php echo e($time->h); ?>h
                    </div>
                    <?php if($dossier->dossier_status_id != 3): ?>
                        <div class="badge-time danger">
                            <i class="uil uil-hourglass"></i>
                            <?php echo e($timeleft); ?>H restant
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            <div class="dossier-status-row">
                <span class="badge bg-<?php echo e($dossier->status->color ?? 'secondary'); ?> fs-6">
                    <?php echo e($dossier->status->status ?? 'N/A'); ?>

                </span>
                <?php if($dossier->dossier_status_id == 3): ?>
                    <span class="badge bg-warning">Facturé</span>
                    <span class="badge bg-primary"><?php echo e($dossier->date_facturation); ?></span>
                <?php endif; ?>
                <span class="badge bg-success"><?php echo e($dossier->currentStep->step ?? 'N/A'); ?></span>
            </div>
        </div>

        <!-- Action Buttons -->
        <?php echo $__env->make('dossiers.buttons', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <!-- Summary Cards -->
        <div class="summary-row">
            <div class="summary-card">
                <div class="summary-icon primary">
                    <i class="uil uil-car"></i>
                </div>
                <div class="summary-content">
                    <h5>Matricule</h5>
                    <p><?php echo e($dossier->matricule ?? $dossier->new_matricule ?? 'N/A'); ?></p>
                </div>
            </div>
            <div class="summary-card">
                <div class="summary-icon success">
                    <i class="uil uil-building"></i>
                </div>
                <div class="summary-content">
                    <h5>Compagnie</h5>
                    <p><?php echo e($dossier->company->company ?? 'N/A'); ?></p>
                </div>
            </div>
            <div class="summary-card">
                <div class="summary-icon warning">
                    <i class="uil uil-calendar-alt"></i>
                </div>
                <div class="summary-content">
                    <h5>Date Sinistre</h5>
                    <p><?php echo e($dossier->date_sinistre ?? 'N/A'); ?></p>
                </div>
            </div>
            <div class="summary-card">
                <div class="summary-icon info">
                    <i class="uil uil-layers"></i>
                </div>
                <div class="summary-content">
                    <h5>Type / Mode</h5>
                    <p><?php echo e($dossier->typeexpertise->type ?? 'N/A'); ?></p>
                </div>
            </div>
        </div>

        <!-- Main Content Grid -->
        <div class="two-col-layout">
            <!-- Left Column - Dossier Details -->
            <div class="modern-card">
                <div class="card-header">
                    <h4><i class="uil uil-file-info-alt"></i> Détails du Dossier</h4>
                </div>
                <div class="card-body">
                    <div class="info-grid">
                        <div class="info-item">
                            <span class="info-label">Assuré</span>
                            <span class="info-value"><?php echo e($dossier->insured->civility ?? ''); ?> <?php echo e($dossier->insured->name ?? 'N/A'); ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-label">Téléphone</span>
                            <span class="info-value"><?php echo e($dossier->insured->telephone ?? 'N/A'); ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-label">Véhicule</span>
                            <span class="info-value"><?php echo e($dossier->typevehicule->type ?? ''); ?> <?php echo e($dossier->vehiculemodel->brand->brand ?? ''); ?> <?php echo e($dossier->vehiculemodel->name ?? 'N/A'); ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-label">Intermédiaire</span>
                            <span class="info-value"><?php echo e($dossier->intermidiaire->company ?? 'N/A'); ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-label">Garantie</span>
                            <span class="info-value"><?php echo e($dossier->guarantee->guarantee ?? 'N/A'); ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-label">Mode</span>
                            <span class="info-value"><?php echo e($dossier->mode->mode ?? 'N/A'); ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-label">N° Sinistre</span>
                            <span class="info-value"><?php echo e($dossier->numero_sinistre ?? 'N/A'); ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-label">N° Chassis</span>
                            <span class="info-value"><?php echo e($dossier->numero_chassis ?? 'N/A'); ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-label">N° Police</span>
                            <span class="info-value"><?php echo e($dossier->numero_police ?? 'N/A'); ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-label">N° Attestation</span>
                            <span class="info-value"><?php echo e($dossier->numero_attestation ?? 'N/A'); ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-label">DMC</span>
                            <span class="info-value"><?php echo e($dossier->date_circulation ?? 'N/A'); ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-label">Ville</span>
                            <span class="info-value"><?php echo e($dossier->city->city ?? 'N/A'); ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-label">Garage</span>
                            <span class="info-value"><?php echo e($dossier->garage->libelle ?? 'N/A'); ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-label">Kilométrage</span>
                            <span class="info-value"><?php echo e($dossier->kilometrage ?? 'N/A'); ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-label">Puissance Fiscale</span>
                            <span class="info-value"><?php echo e($dossier->puissance_fiscale ?? 'N/A'); ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-label">Carburant</span>
                            <span class="info-value"><?php echo e($dossier->carburant->name ?? 'N/A'); ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-label">Date Réception</span>
                            <span class="info-value"><?php echo e($dossier->date_reception ?? 'N/A'); ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-label">Date Création</span>
                            <span class="info-value"><?php echo e($dossier->created_at->format('Y-m-d') ?? 'N/A'); ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-label">Devise</span>
                            <span class="info-value"><?php echo e($dossier->currency->name ?? 'N/A'); ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-label">Mt. Accord Adverse</span>
                            <span class="info-value"><?php echo e($dossier->montant_accord_adverse ?? 0); ?> <?php echo e($dossier->currency->symbole ?? ''); ?></span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Right Column - Media Box -->
            <?php echo $__env->make('dossiers.box', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>

        <!-- Adversaire & Valeurs -->
        <div class="two-col-layout">
            <!-- Adversaire -->
            <div class="modern-card">
                <div class="card-header">
                    <h4><i class="uil uil-user-exclamation"></i> Adversaire</h4>
                </div>
                <div class="card-body">
                    <div class="info-grid">
                        <div class="info-item">
                            <span class="info-label">Nom</span>
                            <span class="info-value"><?php echo e($dossier->opponent->civility ?? ''); ?> <?php echo e($dossier->opponent->name ?? 'N/A'); ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-label">Matricule</span>
                            <span class="info-value"><?php echo e($dossier->opponent->matricule ?? 'N/A'); ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-label">Téléphone</span>
                            <span class="info-value"><?php echo e($dossier->opponent->telephone ?? 'N/A'); ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-label">Véhicule</span>
                            <span class="info-value"><?php echo e($dossier->opponent->vehiculemodel->brand->brand ?? ''); ?> <?php echo e($dossier->opponent->vehiculemodel->name ?? 'N/A'); ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-label">Compagnie</span>
                            <span class="info-value"><?php echo e($dossier->opponent->company->company ?? 'N/A'); ?></span>
                        </div>
                        <div class="info-item">
                            <span class="info-label">N° Attestation</span>
                            <span class="info-value"><?php echo e($dossier->opponent->numero_attestation ?? 'N/A'); ?></span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Valeurs -->
            <div class="modern-card">
                <div class="card-header">
                    <h4><i class="uil uil-dollar-sign"></i> Valeurs</h4>
                </div>
                <div class="card-body">
                    <div class="table-responsive-card">
                        <table class="modern-table">
                            <thead>
                                <tr>
                                    <th>Type</th>
                                    <th>À Neuf</th>
                                    <th>Hors Sinistre</th>
                                    <th>Définitive</th>
                                    <th>Épave</th>
                                    <th>Vénale</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td><span class="badge bg-secondary">HT</span></td>
                                    <td><?php echo e(number_format($dossier->valeurneuf ?? 0, 2)); ?></td>
                                    <td><?php echo e(number_format($dossier->horssinistre ?? 0, 2)); ?></td>
                                    <td><?php echo e(number_format($dossier->valeuradire ?? 0, 2)); ?></td>
                                    <td><?php echo e(number_format($dossier->valeurepave ?? 0, 2)); ?></td>
                                    <td><?php echo e(number_format($dossier->valeurvenale ?? 0, 2)); ?></td>
                                </tr>
                                <tr>
                                    <td><span class="badge bg-primary">TTC</span></td>
                                    <td><?php echo e(number_format($dossier->valeurneuf_ttc ?? 0, 2)); ?></td>
                                    <td><?php echo e(number_format($dossier->horssinistre_ttc ?? 0, 2)); ?></td>
                                    <td><?php echo e(number_format($dossier->valeuradire_ttc ?? 0, 2)); ?></td>
                                    <td><?php echo e(number_format($dossier->valeurepave_ttc ?? 0, 2)); ?></td>
                                    <td><?php echo e(number_format($dossier->valeurvenale_ttc ?? 0, 2)); ?></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Montant Section -->
        <?php if($montant): ?>
        <div class="modern-card">
            <div class="card-header">
                <h4><i class="uil uil-money-bill"></i> Montants</h4>
            </div>
            <div class="card-body">
                <div class="summary-row" style="margin-bottom: 0;">
                    <div class="summary-card">
                        <div class="summary-icon primary">
                            <i class="uil uil-file-edit-alt"></i>
                        </div>
                        <div class="summary-content">
                            <h5>Montant Devis</h5>
                            <p><?php echo e(number_format($montant->devis->montant_devis ?? 0, 2)); ?> <?php echo e($dossier->currency->symbole ?? ''); ?></p>
                        </div>
                    </div>
                    <div class="summary-card">
                        <div class="summary-icon success">
                            <i class="uil uil-check-circle"></i>
                        </div>
                        <div class="summary-content">
                            <h5>Montant Accord</h5>
                            <p><?php echo e(number_format($montant->montant_accord ?? 0, 2)); ?> <?php echo e($dossier->currency->symbole ?? ''); ?></p>
                        </div>
                    </div>
                    <div class="summary-card">
                        <div class="summary-icon warning">
                            <i class="uil uil-receipt"></i>
                        </div>
                        <div class="summary-content">
                            <h5>Montant Facture</h5>
                            <p><?php echo e(number_format($montant->facture->montant_facture ?? 0, 2)); ?> <?php echo e($dossier->currency->symbole ?? ''); ?></p>
                        </div>
                    </div>
                    <div class="summary-card">
                        <div class="summary-icon info">
                            <i class="uil uil-file-alt"></i>
                        </div>
                        <div class="summary-content">
                            <h5>Montant Rapport</h5>
                            <p><?php echo e(number_format($montant->montant_rapport ?? 0, 2)); ?> <?php echo e($dossier->currency->symbole ?? ''); ?></p>
                        </div>
                    </div>
                </div>
                <?php if(Auth::user()->role_id == 4): ?>
                <div class="text-end mt-3">
                    <a href="<?php echo e(route('Montant.edit', $montant->id)); ?>" class="btn btn-sm btn-primary">
                        <i class="uil uil-edit"></i> Modifier
                    </a>
                </div>
                <?php endif; ?>
            </div>
        </div>
        <?php endif; ?>

        <!-- Observations & Shock Points -->
        <div class="two-col-layout">
            <!-- Observations -->
            <div class="modern-card">
                <div class="card-header">
                    <h4><i class="uil uil-comment-alt-notes"></i> Observations</h4>
                </div>
                <div class="card-body">
                    <?php if($observations && count($observations) > 0): ?>
                    <div class="observation-list">
                        <?php $__currentLoopData = $observations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $observation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="observation-item">
                            <div class="author">
                                <i class="uil uil-user"></i>
                                <?php echo e($observation->user->name); ?>

                                <span class="date"><?php echo e($observation->created_at->format('d/m/Y H:i')); ?></span>
                            </div>
                            <div class="content"><?php echo e($observation->observation); ?></div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <?php else: ?>
                    <p class="text-muted text-center py-3">Aucune observation</p>
                    <?php endif; ?>

                    <form method="POST" action="<?php echo e(route('Observation.store')); ?>">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="dossier_id" value="<?php echo e($dossier->id); ?>">
                        <textarea name="observation" class="form-control <?php $__errorArgs = ['observation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                            placeholder="Ajouter une observation..." rows="3"></textarea>
                        <?php $__errorArgs = ['observation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="invalid-feedback" role="alert">
                                <strong><?php echo e($message); ?></strong>
                            </span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        <button type="submit" class="btn btn-primary btn-sm mt-2">
                            <i class="uil uil-plus"></i> Ajouter
                        </button>
                    </form>
                </div>
            </div>

            <!-- Points de Choc -->
            <div class="modern-card">
                <div class="card-header">
                    <h4><i class="uil uil-crosshairs"></i> Points de Choc</h4>
                </div>
                <div class="card-body">
                    <?php if($dossier->shockpoint && count($dossier->shockpoint) > 0): ?>
                    <div class="shock-points">
                        <?php $__currentLoopData = $dossier->shockpoint; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $point): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <span class="shock-point-badge"><?php echo e($point->point); ?></span>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <?php else: ?>
                    <div class="text-center py-4">
                        <i class="uil uil-crosshairs text-muted" style="font-size: 40px;"></i>
                        <p class="text-muted mt-2 mb-3">Aucun point de choc défini</p>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $dossier)): ?>
                            <a href="<?php echo e(route('ShockPoint.create', $dossier->id)); ?>" class="btn btn-warning btn-sm">
                                <i class="uil uil-plus"></i> Créer
                            </a>
                        <?php endif; ?>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Historique Véhicule -->
        <?php if($historiques && count($historiques) > 0): ?>
        <div class="modern-card">
            <div class="card-header">
                <h4><i class="uil uil-history"></i> Historique Véhicule</h4>
            </div>
            <div class="card-body">
                <div class="table-responsive-card">
                    <table class="modern-table">
                        <thead>
                            <tr>
                                <th>Réf</th>
                                <th>Compagnie</th>
                                <th>Matricule WW</th>
                                <th>Matricule</th>
                                <th>Assuré</th>
                                <th>Date Sinistre</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $historiques; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hist): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><strong><?php echo e($hist->ref ?? 'N/A'); ?></strong></td>
                                <td><?php echo e($hist->company->company ?? 'N/A'); ?></td>
                                <td><?php echo e($hist->new_matricule ?? 'N/A'); ?></td>
                                <td><?php echo e($hist->matricule ?? 'N/A'); ?></td>
                                <td><?php echo e($hist->insured->name ?? 'N/A'); ?></td>
                                <td><?php echo e($hist->date_sinistre ?? 'N/A'); ?></td>
                                <td>
                                    <span class="badge bg-<?php echo e($hist->status->color ?? 'secondary'); ?>">
                                        <?php echo e($hist->status->status ?? 'N/A'); ?>

                                    </span>
                                </td>
                                <td>
                                    <a href="<?php echo e(route('Dossier.show', $hist->id)); ?>" class="action-icon-btn">
                                        <i class="uil uil-eye"></i>
                                    </a>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <?php endif; ?>

    </div>

    <?php echo $__env->make('document.modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.config_dashboard.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/amea/public_html/demo4.ameaengi.com/resources/views/dossiers/show.blade.php ENDPATH**/ ?>