@extends('layouts.config_dashboard.app')

@section('style')
<style>
/* Filter Bar */
.filter-bar {
    background: #fff;
    border-radius: 12px;
    box-shadow: 0 2px 12px rgba(0, 0, 0, 0.06);
    padding: 20px;
    margin-bottom: 20px;
}

.filter-bar-title {
    font-size: 14px;
    font-weight: 600;
    color: #1e293b;
    margin-bottom: 15px;
    display: flex;
    align-items: center;
    gap: 8px;
}

.filter-bar-title i {
    color: #3b82f6;
}

.filter-row {
    display: flex;
    flex-wrap: wrap;
    gap: 15px;
    align-items: flex-end;
}

.filter-group {
    display: flex;
    flex-direction: column;
    gap: 6px;
    min-width: 140px;
    flex: 1;
}

.filter-group label {
    font-size: 11px;
    font-weight: 600;
    color: #64748b;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.filter-group select,
.filter-group input {
    padding: 10px 12px;
    border: 1px solid #e2e8f0;
    border-radius: 8px;
    font-size: 13px;
    color: #334155;
    background: #f8fafc;
    transition: all 0.2s;
}

.filter-group select:focus,
.filter-group input:focus {
    border-color: #3b82f6;
    outline: none;
    box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
}

/* Search Input */
.search-group {
    position: relative;
}

.search-group input {
    padding-left: 38px;
}

.search-group .search-icon {
    position: absolute;
    left: 12px;
    bottom: 12px;
    color: #94a3b8;
    font-size: 16px;
}

.filter-buttons {
    display: flex;
    gap: 8px;
}

.btn-filter {
    padding: 10px 20px;
    border-radius: 8px;
    font-size: 13px;
    font-weight: 500;
    border: none;
    cursor: pointer;
    display: inline-flex;
    align-items: center;
    gap: 6px;
    transition: all 0.2s;
}

.btn-filter.primary {
    background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
    color: #fff;
}

.btn-filter.primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(59, 130, 246, 0.3);
}

.btn-filter.secondary {
    background: #f1f5f9;
    color: #64748b;
    border: 1px solid #e2e8f0;
}

.btn-filter.secondary:hover {
    background: #e2e8f0;
}

/* Table Styles - Matching Dashboard */
.dossier-table {
    width: 100%;
    border-collapse: collapse;
}

.dossier-table thead th {
    background: #f8fafc;
    border-bottom: 2px solid #e2e8f0;
    color: #475569;
    font-weight: 600;
    font-size: 11px;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    padding: 14px 10px;
    white-space: nowrap;
}

.dossier-table tbody td {
    padding: 12px 10px;
    vertical-align: middle;
    border-bottom: 1px solid #f1f5f9;
    color: #334155;
    font-size: 13px;
}

.dossier-table tbody tr:hover {
    background-color: #f8fafc;
}

/* Reference Cell */
.ref-cell {
    font-weight: 700;
    color: #1e293b;
}

/* Badges */
.badge-type {
    background: #e0f2fe;
    color: #0369a1;
    padding: 5px 10px;
    border-radius: 6px;
    font-size: 11px;
    font-weight: 600;
}

.badge-mode {
    background: #fef3c7;
    color: #b45309;
    padding: 5px 10px;
    border-radius: 6px;
    font-size: 11px;
    font-weight: 600;
}

.badge-amount {
    background: #f1f5f9;
    color: #334155;
    padding: 5px 10px;
    border-radius: 6px;
    font-size: 11px;
    font-weight: 600;
}

.badge-step {
    background: #ede9fe;
    color: #6d28d9;
    padding: 5px 10px;
    border-radius: 6px;
    font-size: 11px;
    font-weight: 600;
}

.badge-time {
    font-weight: 700;
    padding: 6px 10px;
    border-radius: 6px;
    font-size: 11px;
}

.badge-time.positive {
    background: #dcfce7;
    color: #15803d;
}

.badge-time.negative {
    background: #fee2e2;
    color: #b91c1c;
}

/* Document Links */
.action-links {
    display: flex;
    gap: 6px;
    flex-wrap: wrap;
}

.doc-link {
    padding: 5px 10px;
    border-radius: 6px;
    font-size: 11px;
    font-weight: 600;
    text-decoration: none;
    transition: all 0.2s ease;
}

.doc-link.devis {
    background: #dbeafe;
    color: #1d4ed8;
}

.doc-link.devis:hover {
    background: #bfdbfe;
}

.doc-link.rapport {
    background: #dcfce7;
    color: #15803d;
}

.doc-link.rapport:hover {
    background: #bbf7d0;
}

.doc-link.facture {
    background: #fef3c7;
    color: #b45309;
}

.doc-link.facture:hover {
    background: #fde68a;
}

/* View Button */
.view-btn {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    width: 36px;
    height: 36px;
    background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
    color: #fff;
    border-radius: 8px;
    transition: all 0.2s ease;
    text-decoration: none;
}

.view-btn:hover {
    transform: scale(1.1);
    box-shadow: 0 4px 12px rgba(59, 130, 246, 0.4);
    color: #fff;
}

.view-btn i {
    font-size: 16px;
}

/* Page Header */
.page-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 20px;
}

.page-header h4 {
    margin: 0;
    font-weight: 600;
    color: #1e293b;
}

/* Table Card */
.table-card {
    background: #fff;
    border-radius: 12px;
    box-shadow: 0 2px 12px rgba(0, 0, 0, 0.06);
    overflow: hidden;
    position: relative;
}

.table-card .card-body {
    padding: 0;
}

/* Table Loader Overlay */
.table-loader {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(255, 255, 255, 0.9);
    display: none;
    align-items: center;
    justify-content: center;
    z-index: 100;
    flex-direction: column;
    gap: 15px;
}

.table-loader.active {
    display: flex;
}

.table-loader-spinner {
    width: 50px;
    height: 50px;
    border: 3px solid #e2e8f0;
    border-top-color: #3b82f6;
    border-radius: 50%;
    animation: spin 0.8s linear infinite;
}

@keyframes spin {
    to { transform: rotate(360deg); }
}

.table-loader-text {
    color: #64748b;
    font-size: 14px;
    font-weight: 500;
}

/* Pagination */
.pagination-wrapper {
    padding: 15px 20px;
    background: #f8fafc;
    border-top: 1px solid #e2e8f0;
}

/* Results Info */
.results-info {
    padding: 12px 20px;
    background: #f0f9ff;
    border-bottom: 1px solid #e0f2fe;
    font-size: 13px;
    color: #0369a1;
}

.results-info strong {
    font-weight: 600;
}

/* Empty State */
.empty-row td {
    padding: 60px 20px !important;
}

/* Responsive */
@media (max-width: 768px) {
    .filter-row {
        flex-direction: column;
    }
    .filter-group {
        width: 100%;
    }
}
</style>
@endsection

@section('content')
<div class="container-fluid">
    <div class="page-header">
        <h4><i class="mdi mdi-folder-open me-2"></i>Dossiers <span class="badge bg-success">En cours</span></h4>
        <form action="{{ route('Dossier.export') }}" method="post" class="d-inline">
            @csrf
            <button type="submit" class="btn btn-success">
                <i class="mdi mdi-file-export me-1"></i> Export Excel
            </button>
        </form>
    </div>

    <!-- Filter Bar -->
    <div class="filter-bar">
        <div class="filter-bar-title">
            <i class="mdi mdi-filter-variant"></i> Filtres

        </div>
        <div class="filter-row">
            <!-- Live Search -->
            <div class="filter-group search-group" style="flex: 2;">
                <label>Recherche</label>
                <i class="mdi mdi-magnify search-icon"></i>
                <input type="text" id="liveSearch" placeholder="Référence, Assuré, Matricule, N° Sinistre..." value="{{ request('search') }}">
            </div>
            
            <!-- Date Range -->
            <div class="filter-group">
                <label>Date Début</label>
                <input type="date" id="filterDateFrom" value="{{ request('date_from') }}">
            </div>
            <div class="filter-group">
                <label>Date Fin</label>
                <input type="date" id="filterDateTo" value="{{ request('date_to') }}">
            </div>
            
            <!-- Company -->
            <div class="filter-group">
                <label>Compagnie</label>
                <select id="filterCompany">
                    <option value="">-- Toutes --</option>
                    @foreach($companies ?? [] as $company)
                        <option value="{{ $company->id }}" {{ request('company') == $company->id ? 'selected' : '' }}>
                            {{ $company->company }}
                        </option>
                    @endforeach
                </select>
            </div>
            
            <!-- Type -->
            <div class="filter-group">
                <label>Type Expertise</label>
                <select id="filterType">
                    <option value="">-- Tous --</option>
                    @foreach($types ?? [] as $type)
                        <option value="{{ $type->id }}" {{ request('type') == $type->id ? 'selected' : '' }}>
                            {{ $type->type }}
                        </option>
                    @endforeach
                </select>
            </div>
            
            <!-- Mode -->
            <div class="filter-group">
                <label>Mode</label>
                <select id="filterMode">
                    <option value="">-- Tous --</option>
                    @foreach($modes ?? [] as $mode)
                        <option value="{{ $mode->id }}" {{ request('mode') == $mode->id ? 'selected' : '' }}>
                            {{ $mode->mode }}
                        </option>
                    @endforeach
                </select>
            </div>
            
            <!-- Step -->
            <div class="filter-group">
                <label>Étape</label>
                <select id="filterStep">
                    <option value="">-- Toutes --</option>
                    @foreach($steps ?? [] as $step)
                        <option value="{{ $step->id }}" {{ request('step') == $step->id ? 'selected' : '' }}>
                            {{ $step->step }}
                        </option>
                    @endforeach
                </select>
            </div>
            
            <!-- Reset Button -->
            <div class="filter-group" style="flex: 0 0 auto;">
                <label>&nbsp;</label>
                <button type="button" id="resetFilters" class="btn-filter secondary">
                    <i class="mdi mdi-refresh"></i> Reset
                </button>
            </div>
        </div>
    </div>

    <div class="table-card">
        <!-- Table Loader -->
        <div class="table-loader" id="tableLoader">
            <div class="table-loader-spinner"></div>
            <div class="table-loader-text">Chargement des dossiers...</div>
        </div>
        
        <div class="card-body">
            <!-- Results Info -->
            <div class="results-info" id="resultsInfo">
                <strong id="resultsCount">{{ $dossiers->total() }}</strong> dossier(s) trouvé(s)
            </div>
            
            <div class="table-responsive">
                <table class="dossier-table" id="dossiersTable">
                    <thead>
                        <tr>
                            <th>Action</th>
                            <th>Référence</th>
                            <th>Compagnie</th>
                            <th>Assuré</th>
                            <th>Matricule</th>
                            <th>N° Sinistre</th>
                            <th>Type</th>
                            <th>Mode</th>
                            <th>Mt. Devis</th>
                            <th>Mt. Facture</th>
                            <th>Etape</th>
                            <th>Délai</th>
                            <th>Status</th>
                            <th>Documents</th>
                        </tr>
                    </thead>
                    <tbody id="dossiersBody">
                        @forelse ($dossiers as $dossier)
                        <tr>
                            <!-- Action -->
                            <td>
                                @can('view', $dossier)
                                <a href="{{ route('Dossier.show', $dossier->id) }}" class="view-btn" title="Voir le dossier">
                                    <i class="mdi mdi-eye"></i>
                                </a>
                                @endcan
                            </td>
                            
                            <!-- Référence -->
                            <td class="ref-cell">{{ $dossier->ref ?? '-' }}</td>
                            
                            <!-- Compagnie -->
                            <td>{{ $dossier->company->company ?? '-' }}</td>
                            
                            <!-- Assuré -->
                            <td><strong>{{ $dossier->insured->name ?? '-' }}</strong></td>
                            
                            <!-- Matricule -->
                            <td>{{ $dossier->matricule ?? '-' }}</td>
                            
                            <!-- N° Sinistre -->
                            <td>{{ $dossier->numero_sinistre ?? '-' }}</td>
                            
                            <!-- Type -->
                            <td><span class="badge-type">{{ $dossier->typeexpertise->type ?? '-' }}</span></td>
                            
                            <!-- Mode -->
                            <td><span class="badge-mode">{{ $dossier->mode->mode ?? '-' }}</span></td>
                            
                            <!-- Mt. Devis -->
                            <td>
                                @php
                                    $montantDevis = $dossier->devis ? $dossier->devis->where('devis_status_id', '!=', 7)->sum('montant_ht') : 0;
                                @endphp
                                <span class="badge-amount">{{ number_format($montantDevis, 2, ',', ' ') }}</span>
                            </td>
                            
                            <!-- Mt. Facture -->
                            <td>
                                @php
                                    $montantFacture = $dossier->facture ? $dossier->facture->where('devis_status_id', '!=', 7)->sum('montant_ht') : 0;
                                @endphp
                                <span class="badge-amount">{{ number_format($montantFacture, 2, ',', ' ') }}</span>
                            </td>
                            
                            <!-- Etape -->
                            <td><span class="badge-step">{{ $dossier->currentStep->step ?? '-' }}</span></td>
                            
                            <!-- Délai -->
                            <td>
                                @php
                                    $timeleft = $dossier->timeleft ?? 0;
                                @endphp
                                @if($timeleft >= 0)
                                    <span class="badge-time positive">{{ $timeleft }}H</span>
                                @else
                                    <span class="badge-time negative">{{ $timeleft }}H</span>
                                @endif
                            </td>
                            
                            <!-- Status -->
                            <td>
                                @php
                                    $status = is_object($dossier->dossierstatus) && !($dossier->dossierstatus instanceof \Illuminate\Support\Collection) 
                                        ? $dossier->dossierstatus 
                                        : ($dossier->dossierstatus->first() ?? null);
                                @endphp
                                <span class="badge bg-{{ $status->color ?? 'secondary' }}">
                                    {{ $status->status ?? '-' }}
                                </span>
                            </td>
                            
                            <!-- Documents -->
                            <td>
                                <div class="action-links">
                                    <a href="/Devis/Dossier/{{ $dossier->id }}" class="doc-link devis">Devis</a>
                                    <a href="/Rapport/{{ $dossier->id }}" class="doc-link rapport">Rapport</a>
                                    <a href="/Dossier/{{ $dossier->id }}/Facture" class="doc-link facture">Facture</a>
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr class="empty-row">
                            <td colspan="14" class="text-center py-4 text-muted">
                                <i class="mdi mdi-folder-open-outline" style="font-size: 48px;"></i>
                                <p class="mt-2 mb-0">Aucun dossier trouvé</p>
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
            
            <div class="pagination-wrapper" id="paginationWrapper">
                <div class="d-flex justify-content-center">
                    {!! $dossiers->appends(request()->query())->links() !!}
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('script')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Elements
    const liveSearch = document.getElementById('liveSearch');
    const filterDateFrom = document.getElementById('filterDateFrom');
    const filterDateTo = document.getElementById('filterDateTo');
    const filterCompany = document.getElementById('filterCompany');
    const filterType = document.getElementById('filterType');
    const filterMode = document.getElementById('filterMode');
    const filterStep = document.getElementById('filterStep');
    const resetBtn = document.getElementById('resetFilters');
    const tableLoader = document.getElementById('tableLoader');
    const resultsCount = document.getElementById('resultsCount');
    
    let searchTimeout = null;
    let currentPage = 1;
    
    // Show loader
    function showLoader() {
        tableLoader.classList.add('active');
    }
    
    // Hide loader
    function hideLoader() {
        tableLoader.classList.remove('active');
    }
    
    // Build query params
    function buildParams() {
        const params = new URLSearchParams();
        
        if (liveSearch.value) params.set('search', liveSearch.value);
        if (filterDateFrom.value) params.set('date_from', filterDateFrom.value);
        if (filterDateTo.value) params.set('date_to', filterDateTo.value);
        if (filterCompany.value) params.set('company', filterCompany.value);
        if (filterType.value) params.set('type', filterType.value);
        if (filterMode.value) params.set('mode', filterMode.value);
        if (filterStep.value) params.set('step', filterStep.value);
        if (currentPage > 1) params.set('page', currentPage);
        
        return params.toString();
    }
    
    // Perform search
    function performSearch() {
        showLoader();
        
        const params = buildParams();
        const url = '{{ route("Dossier.index") }}' + (params ? '?' + params : '');
        
        // Update URL without reload
        window.history.replaceState({}, '', url);
        
        fetch(url, {
            headers: {
                'X-Requested-With': 'XMLHttpRequest',
                'Accept': 'text/html'
            }
        })
        .then(response => response.text())
        .then(html => {
            // Parse the response
            const parser = new DOMParser();
            const doc = parser.parseFromString(html, 'text/html');
            
            // Update table body
            const newBody = doc.getElementById('dossiersBody');
            if (newBody) {
                document.getElementById('dossiersBody').innerHTML = newBody.innerHTML;
            }
            
            // Update results count
            const newCount = doc.getElementById('resultsCount');
            if (newCount) {
                resultsCount.textContent = newCount.textContent;
            }
            
            // Update pagination
            const newPagination = doc.getElementById('paginationWrapper');
            if (newPagination) {
                document.getElementById('paginationWrapper').innerHTML = newPagination.innerHTML;
                bindPaginationLinks();
            }
            
            hideLoader();
        })
        .catch(error => {
            console.error('Search error:', error);
            hideLoader();
        });
    }
    
    // Debounced search for text input
    function debouncedSearch() {
        clearTimeout(searchTimeout);
        currentPage = 1;
        searchTimeout = setTimeout(performSearch, 300);
    }
    
    // Immediate search for selects/dates
    function immediateSearch() {
        currentPage = 1;
        performSearch();
    }
    
    // Bind pagination links
    function bindPaginationLinks() {
        document.querySelectorAll('#paginationWrapper a').forEach(link => {
            link.addEventListener('click', function(e) {
                e.preventDefault();
                const url = new URL(this.href);
                currentPage = url.searchParams.get('page') || 1;
                performSearch();
            });
        });
    }
    
    // Event listeners
    liveSearch.addEventListener('input', debouncedSearch);
    filterDateFrom.addEventListener('change', immediateSearch);
    filterDateTo.addEventListener('change', immediateSearch);
    filterCompany.addEventListener('change', immediateSearch);
    filterType.addEventListener('change', immediateSearch);
    filterMode.addEventListener('change', immediateSearch);
    filterStep.addEventListener('change', immediateSearch);
    
    // Reset filters
    resetBtn.addEventListener('click', function() {
        liveSearch.value = '';
        filterDateFrom.value = '';
        filterDateTo.value = '';
        filterCompany.value = '';
        filterType.value = '';
        filterMode.value = '';
        filterStep.value = '';
        currentPage = 1;
        performSearch();
    });
    
    // Initial pagination binding
    bindPaginationLinks();
});
</script>
@endsection
