<?php

namespace App\Http\Controllers;

use App\Models\City;
use App\Models\Company;
use App\Models\Garage;
use App\Models\Piece;
use App\Models\Step;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class CompanyController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $this->authorize('viewAny', Company::class);
        $companies = Company::all();
        return view('configuration.company.index', compact('companies'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $this->authorize('create', Company::class);
        return view('configuration.company.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->authorize('create', Company::class);

        $request->validate([
            'company' => 'required|unique:companies,company',
            'phone' => 'required|unique:companies,phone',
            'email' => 'required|email|unique:companies,email',
            'ice' => 'required|unique:companies,ice',
            'email_pro'=>'nullable|unique:companies,email_pro',
            'password'=>'nullable'
        ]);

        $company = Company::create([
            'company' => $request->company,
            'phone' => $request->phone,
            'email' => $request->email,
            'email_pro' => $request->email_pro,
            'password' => $request->password,
            'ice' => $request->ice,
            'adress'=>$request->adress
        ]);
        $steps = Step::all();
        $company->step()->attach($steps);

        return redirect()->route('Company.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Company  $company
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        // $steps = Step::all();
        // $companies = Company::all();
        // foreach ($companies as $company) {
        //     $company->step()->attach($steps);
        // }
        // should create companies in web for generate
        $company = Company::whereId($id)->with('step')->first();
        $steps = Step::all();
        // dd($steps);
        return view('configuration.company.show', compact('company'));
    }


    public function company(Request $request, $id)
    {
        $garage = Garage::whereId($id)->first();
        $this->authorize('update',Garage::class);
        if ($request->has('company')) {
            $garage->company()->detach();
            foreach ($request->company as $c) {
                $company = Company::findOrFail($c);
                $garage->company()->syncWithoutDetaching($company);
            }
        } else {
            $garage->company()->wherePivot('garage_id', '=', $id)->detach();
        }
        return redirect()->back();
    }
    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Company  $company
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $this->authorize('update', Company::class);
        $company = Company::whereId($id)->firstOrFail();
        return view('configuration.company.edit', compact('company'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Company  $company
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->authorize('update', Company::class);

        $company = Company::whereId($id)->firstOrFail();
        $request->validate([
            'company' => 'required|unique:companies,company,' . $id,
            'phone' => 'required|unique:companies,phone,' . $id,
            'email' => 'required|email|unique:companies,email,' . $id,
            'ice' => 'required|unique:companies,ice,' . $id,
            'email_pro'=>'nullable|unique:companies,email_pro,'. $id,
            'password'=>'nullable'

        ]);
        $company->company = $request->company;
        $company->phone = $request->phone;
        $company->email = $request->email;
        $company->ice = $request->ice;
        $company->adress = $request->adress;
        $company->email_pro = $request->email_pro;
        $company->password = $request->password;
        $company->update();

        return redirect()->route('Company.index');
    }

    public function attach(Request $request, $id)
    {
        $company = Company::whereId($id)->first();
        $company->step()->detach();
        for ($i = 0; $i < count($request['step']); $i++) {
            $step = Step::findOrFail($request['step'][$i]);
            //dd($step,$request['delai'][$i]);
            $company->step()->attach($step, ['time' => $request['delai'][$i]]);
        }
        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Company  $company
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {

        $company = Company::whereId($id)->firstOrFail();
        $company->delete();
        return redirect()->route('Company.index');
    }

    public function deleted()
    {
        $companies = Company::onlyTrashed()->get();
        return view('configuration.company.deleted', compact('companies'));
    }

    public function restore($id)
    {
        Company::withTrashed()->find($id)->restore();
        return redirect()->route('Company.index');
    }
}
