<?php

namespace App\Policies;

use App\Models\Rapport;
use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;
use Illuminate\Support\Facades\Auth;

class RapportPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view any models.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function viewAny(User $user)
    {
        if( $user->role_id === 4 || $user->hasPermission('naviguer_rapport') || $user->hasRolePermission('naviguer_rapport') ){
            return true;
        }
    }

    /**
     * Determine whether the user can view the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Rapport  $rapport
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function view(User $user)
    {
        if( $user->role_id === 4 || $user->hasPermission('afficher_rapport') || $user->hasRolePermission('afficher_rapport') )
        {
            return true;
        }
    }

    /**
     * Determine whether the user can create models.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function create(User $user)
    {
        if( $user->role_id === 4 || $user->hasPermission('ajouter_rapport') || $user->hasRolePermission('ajouter_rapport') ){
            return true;
        }
    }

    /**
     * Determine whether the user can update the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Rapport  $rapport
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function update(User $user)
    {
        if( $user->role_id === 4 || $user->hasPermission('modifier_rapport') || $user->hasRolePermission('modifier_rapport') ){
            return true;
        }
    }

    public function signer(User $user)
    {
        if( $user->role_id === 4 || $user->hasPermission('Signer_Rapport') || $user->hasRolePermission('Signer_Rapport') ){
            return true;
        }
    }
    /**
     * Determine whether the user can delete the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Rapport  $rapport
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function delete(User $user)
    {

    }

    /**
     * Determine whether the user can restore the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Rapport  $rapport
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function restore(User $user)
    {

    }

    /**
     * Determine whether the user can permanently delete the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Rapport  $rapport
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function forceDelete(User $user, Rapport $rapport)
    {
        //
    }
}
