@extends('layouts.dashboard.app')
@section('style')
    <style>
        #description {
            font-family: Roboto;
            font-size: 15px;
            font-weight: 300;
        }

        #infowindow-content .title {
            font-weight: bold;
        }

        #infowindow-content {
            display: none;
        }

        #map #infowindow-content {
            display: inline;
        }

        .pac-card {
            background-color: #fff;
            border: 0;
            border-radius: 2px;
            box-shadow: 0 1px 4px -1px rgba(0, 0, 0, 0.3);
            margin: 10px;
            padding: 0 0.5em;
            font: 400 18px Roboto, Arial, sans-serif;
            overflow: hidden;
            font-family: Roboto;
            padding: 0;
        }

        #pac-container {
            padding-bottom: 12px;
            margin-right: 12px;
        }

        .pac-controls {
            display: inline-block;
            padding: 5px 11px;
        }

        .pac-controls label {
            font-family: Roboto;
            font-size: 13px;
            font-weight: 300;
        }

        #pac-input {
            background-color: #fff;
            font-family: Roboto;
            font-size: 15px;
            font-weight: 300;
            margin-left: 12px;
            padding: 0 11px 0 13px;
            text-overflow: ellipsis;
            width: 400px;
        }

        #pac-input:focus {
            border-color: #4d90fe;
        }

        #title {
            color: #fff;
            background-color: #4d90fe;
            font-size: 25px;
            font-weight: 500;
            padding: 6px 12px;
        }

        #target {
            width: 345px;
        }
    </style>
@endsection
@section('content')
    <div class="container-fluid mt-2 ">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body mt-1">
                        <form action="{{ route('Expert.update',$expert->id) }}" method="post">
                            @csrf
                            @method('PUT')
                            <div class="form-group mb-2">
                                <label for="name">Nom *:</label>
                                <input type="text" name="name" value="{{ $expert->name }}" required
                                    class="form-control @error('name') is-invalid @enderror">
                                @error('name')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="form-group mb-2">
                                <label for="email">Email</label>
                                <input type="email" name="email" value="{{ $expert->email }}" 
                                    class="form-control @error('email') is-invalid @enderror">
                                @error('email')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>

                            <div class="form-group mb-2">
                                <label for="city">Ville</label>
                                <select class="form-select " name="city_id" id="city">
                                    <option value="{{ $expert->city->id ?? null }}">
                                        {{ $expert->city->city ?? 'Selectionner une Ville' }}</option>
                                    @foreach ($cities as $city)
                                        <option value="{{ $city->id }}">{{ $city->city }}</option>
                                    @endforeach
                                </select>

                            </div>

                            <div class="form-group mb-2">
                                <label for="adress">Adresse</label>
                                <input type="text" name="adress" value="{{ $expert->adress }}"
                                    class="form-control @error('adress') is-invalid @enderror">
                                @error('adress')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class=" form-group mb-3">
                                <label for="simpleinput" class="form-label">Telephone </label>
                                <input type="text" id="tel" name="tel" value="{{ $expert->tel }}"
                                    pattern="(\+212|0)([ \-_/]*)(\d[ \-_/]*){9}"
                                    class="form-control @error('tel') is-invalid  @enderror">
                                @error('tel')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>



                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success">Modifier</button>
                    </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
