@extends('layouts.dashboard.app')

@section('content')
    <div class="container-fluid">
        <div class="row mb-3">
            <div class="col-12">
                <div class="page-title-box">
                    {{-- @if (is_null($check)) --}}
                    <div class="page-title-right">
                        <a href="{{ route('Meeting.create', $id) }}" class="btn btn-outline-primary"> Créer Nouveau
                            Mission
                        </a>
                    </div>
                    {{-- @endif --}}

                    <div class="page-title-left ">
                        <a href="{{ route('Dossier.show', $id) }}" class="mt-2 btn btn-outline-dark">Dossier</a>
                    </div>
                </div>
            </div>
        </div>
        <div class="table-responsive">
            <table class="table table-centered table-nowrap mb-0" id="myTable">
                <thead class="table-light">
                    <tr>

                        <th>Reference </th>
                        <th>Agent</th>
                        <th>Assuré</th>
                        <th>Date de Meet</th>
                        <th>Heure du Meet</th>
                        <th>Expertise</th>
                        <th>Status</th>
                        <th style="width: 125px;">Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($meetings as $meeting)
                        <tr>

                            <td>{{ $meeting->id }} </td>
                            <td>
                                {{ $meeting->user->name }}
                            </td>
                            <td>
                                @if ($meeting->assure)
                                    <h5>
                                        Assuré
                                    </h5>
                                @else
                                    <h5>
                                        Adversaire
                                    </h5>
                                @endif
                            </td>

                            <td>
                                <h5>
                                    {{ $meeting->date_fin ?? null }}
                                </h5>
                            </td>
                            <td>
                                {{ $meeting->start }}
                            </td>
                            <td>
                                <span class="text-primary">
                                    @if ($meeting->type == '2')
                                        Expertisen Avant
                                    @elseif ($meeting->type == '5')
                                        Expertisen En cours
                                    @elseif ($meeting->type == '10')
                                        Expertisen Aprés
                                    @endif

                                </span>
                            </td>
                            <td>
                                <span class="badge bg-{{ $meeting->meetingstatus->color }}">
                                    {{ $meeting->meetingstatus->status }}</span>
                            </td>
                            <td>
                                @can('view', App\Models\Meeting::class)
                                    <a href="{{ route('Meeting.show', $meeting->id) }}" class="action-icon text-dark"> <i
                                            class="mdi mdi-eye"></i></a>
                                @endcan
                                @if ($meeting->meeting_status_id == 2)
                                    @can('update', App\Models\Meeting::class)
                                        <a href="{{ route('Meeting.editing', $meeting->id) }}" class="action-icon text-info">
                                            <i class="mdi mdi-pen"></i></a>
                                    @endcan
                                @endif
                            </td>


                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div> <!-- end card-body-->
    </div> <!-- end card-->
    </div> <!-- end col -->
    </div>

    </div>

    </div>



    </div>

    </div>
@endsection
