@extends('layouts.dashboard.app')

@section('style')
    <link rel="stylesheet" href="{{ asset('css/viewer.css') }}">
    <style>
        .container {
            position: relative;
            width: 33%;
        }

        .image {
            opacity: 1;
            display: block;
            width: 100%;
            height: auto;
            transition: .5s ease;
            backface-visibility: hidden;
        }

        .middle {
            transition: .5s ease;
            opacity: 0;
            position: absolute;
            top: 28%;
            left: 82%;
            transform: translate(-50%, -50%);
            -ms-transform: translate(-50%, -50%);
            text-align: center;
        }

        .container:hover .image {
            opacity: 0.8;
        }

        .container:hover .middle {
            opacity: 1;
        }

        .text {
            color: rgb(0, 0, 0);
            font-size: 16px;
        }
    </style>
@endsection

@section('content')
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex ">
                        <div class="col-md-4">
                            <a style="float: left" href="{{ route('Dossier.show', $dossier->id) }}"
                                class="btn btn-outline-dark rounded-pill">Dossier</a>
                        </div>

                        <div class="col-md-8">
                            @if ($rapport->rapport_status_id == 5)
                                <div class="col-md-2" style="float: left">
                                    <form action="{{ route('Rapport.send') }}" method="post">
                                        @csrf
                                        <input type="hidden" name="rapport_id" value="{{ $rapport->id }}">

                                        <button style="float: right" type="submit" class="btn btn-success rounded-pill">
                                            Envoyer A Signer
                                        </button>
                                    </form>
                                </div>
                                <div class="col-md-2" style="float: right">
                                    <form action="{{ route('pdf.normal', $rapport->id) }}" target="_blank" method="get">
                                        <button style="" type="submit" class="btn btn-primary rounded-pill">
                                            Génerer Rapport
                                        </button>
                                    </form>
                                </div>
                                <div class="col-md-2" style="float: right;margin-right:23%">
                                    <a class="btn btn-info rounded-pill""
                                        href="{{ route('Rapport.documents', $rapport->id) }}"> Attacher
                                        Images </a>
                                </div>
                            @endif
                            @if ($rapport->rapport_status_id != 5)
                                <div style="float: right" class="col-md-3">
                                    <a style="float: right" href="{{ route('rapport.signature', $rapport->id) }}"
                                        class="btn btn-primary rounded-pill">Status</a>
                                </div>
                            @endif
                        </div>



                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="header-title mb-3">Dossier {{ $dossier->ref }}</h4>
                    <div class="table-responsive">
                        <table class="table mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th>Reference</th>
                                    <th>Matricule</th>
                                    <th>Compagnie</th>
                                    <th>Garantie</th>
                                    <th>Date Sinistre</th>
                                    <th>Type de Dossier</th>
                                    <th>Mode</th>
                                    <th>Vehicule</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <input type="hidden" value="{{ $dossier->id }}" id="id">
                                    <td>{{ $dossier->ref ?? null }}</td>
                                    <td>{{ $dossier->matricule ?? null }}</td>
                                    <td>{{ $dossier->company->company ?? null }}</td>
                                    <td>{{ $dossier->guarantee->guarantee ?? null }}</td>
                                    <td>{{ $dossier->date_sinistre ?? null }}</td>
                                    <td> <span
                                            class="badge badge-info-lighten">{{ $dossier->typeexpertise->type ?? null }}</span>
                                    </td>
                                    <td> <span
                                            class="badge badge-success-lighten">{{ $dossier->mode->mode ?? null }}</span>
                                    </td>
                                    <td>{{ $dossier->vehiculemodel->name ?? null }}/{{ $dossier->vehiculemodel->brand->brand ?? null }}
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <!-- end table-responsive -->
                </div>
            </div>
        </div> <!-- end col -->


    </div>
    <div class="row mt-3">
        <div class="col-6">
            <div class="card">
                <div class="card-body">

                    <h4 class="header-title mb-3">Assuré</h4>

                    <div class="table-responsive">
                        <table class="table mb-0 ">
                            <thead class="table-light">
                                <tr>
                                    <th>Civilité</th>
                                    <th>Nom </th>
                                    <th>Telephone</th>
                                    <th>Garage</th>

                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>{{ $dossier->insured->civility ?? null }}</td>
                                    <td>{{ $dossier->insured->name ?? null }}</td>
                                    <td>{{ $dossier->insured->telephone ?? null }}</td>
                                    <td>{{ $dossier->garage->libelle ?? null }}</td>

                                </tr>

                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>

        <div class="col-lg-6">
            <div class="card">
                <div class="card-body">
                    <h4 class="header-title mb-3">Adversaire</h4>
                    <div class="table-responsive">
                        <table class="table mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th>Civilité</th>
                                    <th>Nom </th>
                                    <th>Matricule</th>
                                    <th>Telephone</th>
                                    <th>Vehicule</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>{{ $dossier->opponent->civility ?? null }}</td>
                                    <td>{{ $dossier->opponent->name ?? null }}</td>
                                    <td>{{ $dossier->opponent->matricule ?? null }}</td>
                                    <td>{{ $dossier->opponent->telephone ?? null }}</td>
                                    <td>{{ $dossier->opponent->vehiculemodel->brand->brand ?? null }}{{ $dossier->opponent->vehiculemodel->name ?? null }}
                                    </td>
                                </tr>
                                </form>
                            </tbody>

                        </table>

                    </div>
                </div>
            </div>
        </div>
    </div>


    <form action="{{ route('Rapport.store') }}" method="post">
        @csrf

        @if ($dossier->dossier_status_id != 3)
            @if ($rapport->rapport_status_id != 2 && $rapport->rapport_status_id != 3)
                <button type="submit" class="btn btn-info mb-3"> Valider Point de Shock </button>
            @endif
        @endif
        <div class="row mb-4">
            <div class="col-6">
                <input type="hidden" value="{{ $rapport->id }}" name="rapport_id">
                <input type="hidden" id="point" name="points">
                @if ($rapport)
                    @foreach ($rapport->piecetype as $type)
                        <input type="hidden" class="checked" value="{{ $type->id }}">
                    @endforeach
                @endif
                <div style="width: 400px" class="mt-3 mb-3">
                    <svg id="voiture" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
                        viewBox="0 0 737.82 829.06">
                        <defs>
                            <style>
                                .fil {
                                    fill: rgb(255, 123, 0);
                                }

                                .cls-1 {
                                    fill: url(#linear-gradient);
                                }

                                .cls-2 {
                                    fill: url(#linear-gradient-2);
                                }

                                .cls-3 {
                                    fill: url(#linear-gradient-3);
                                }

                                .cls-4 {
                                    fill: url(#linear-gradient-4);
                                }

                                .cls-5 {
                                    fill: #edf9f9;
                                }

                                .cls-6 {
                                    fill: url(#linear-gradient-5);
                                }

                                .cls-7 {
                                    fill: url(#linear-gradient-6);
                                }

                                .cls-8 {
                                    fill: url(#linear-gradient-7);
                                }

                                .cls-9 {
                                    fill: url(#linear-gradient-8);
                                }

                                .cls-10 {
                                    fill: url(#linear-gradient-9);
                                }

                                .cls-11 {
                                    fill: url(#linear-gradient-10);
                                }

                                .cls-12 {
                                    fill: url(#linear-gradient-11);
                                }

                                .cls-13 {
                                    fill: url(#linear-gradient-12);
                                }

                                .cls-14 {
                                    fill: url(#linear-gradient-13);
                                }

                                .cls-15 {
                                    fill: url(#linear-gradient-14);
                                }

                                .cls-16 {
                                    fill: url(#linear-gradient-15);
                                }

                                .cls-17 {
                                    fill: url(#linear-gradient-16);
                                }

                                .cls-18 {
                                    fill: url(#linear-gradient-17);
                                }

                                .cls-19 {
                                    fill: url(#linear-gradient-18);
                                }

                                .cls-20 {
                                    fill: url(#linear-gradient-19);
                                }

                                .cls-21 {
                                    fill: #fff;
                                }

                                .cls-22 {
                                    fill: url(#linear-gradient-20);
                                }

                                .cls-23 {
                                    fill: url(#linear-gradient-21);
                                }

                                .cls-24 {
                                    fill: url(#linear-gradient-22);
                                }

                                .cls-25 {
                                    fill: url(#linear-gradient-23);
                                }

                                .cls-26 {
                                    fill: url(#linear-gradient-24);
                                }

                                .cls-27 {
                                    fill: url(#linear-gradient-25);
                                }
                            </style>
                            <linearGradient id="linear-gradient" x1="350.7" y1="-140.03" x2="387.13" y2="-140.03"
                                gradientTransform="matrix(1, 0, 0, -1, -149.84, 478.46)" gradientUnits="userSpaceOnUse">
                                <stop offset="0" stop-color="#c7c6c6" />
                                <stop offset="1" stop-color="#91918a" />
                            </linearGradient>
                            <linearGradient id="linear-gradient-2" x1="387.66" y1="-25.81" x2="405.2"
                                y2="-25.81" xlink:href="#linear-gradient" />
                            <linearGradient id="linear-gradient-3" x1="336.06" y1="92.87" x2="400.38"
                                y2="92.87" xlink:href="#linear-gradient" />
                            <linearGradient id="linear-gradient-4" x1="149.84" y1="52.3" x2="171.46"
                                y2="52.3" xlink:href="#linear-gradient" />
                            <linearGradient id="linear-gradient-5" x1="220.86" y1="-229.7" x2="342.56"
                                y2="-229.7" xlink:href="#linear-gradient" />
                            <linearGradient id="linear-gradient-6" x1="194.73" y1="270.09" x2="313.51"
                                y2="270.09" xlink:href="#linear-gradient" />
                            <linearGradient id="linear-gradient-7" x1="646.85" y1="-140.63" x2="684.58"
                                y2="-140.63" xlink:href="#linear-gradient" />
                            <linearGradient id="linear-gradient-8" x1="641.3" y1="-26.17" x2="658.81"
                                y2="-26.17" xlink:href="#linear-gradient" />
                            <linearGradient id="linear-gradient-9" x1="638.98" y1="93.32" x2="703.82"
                                y2="93.32" xlink:href="#linear-gradient" />
                            <linearGradient id="linear-gradient-10" x1="866.11" y1="52.21" x2="887.66"
                                y2="52.21" xlink:href="#linear-gradient" />
                            <linearGradient id="linear-gradient-11" x1="694.18" y1="-230.04" x2="816.36"
                                y2="-230.04" xlink:href="#linear-gradient" />
                            <linearGradient id="linear-gradient-12" x1="724.34" y1="270" x2="843.57"
                                y2="270" xlink:href="#linear-gradient" />
                            <linearGradient id="linear-gradient-13" x1="406.79" y1="-324.78" x2="644.47"
                                y2="-324.78" xlink:href="#linear-gradient" />
                            <linearGradient id="linear-gradient-14" x1="423.87" y1="-252.05" x2="628.24"
                                y2="-252.05" xlink:href="#linear-gradient" />
                            <linearGradient id="linear-gradient-15" x1="438.5" y1="-16.44" x2="610.55"
                                y2="-16.44" xlink:href="#linear-gradient" />
                            <linearGradient id="linear-gradient-16" x1="389.49" y1="297.68" x2="655.61"
                                y2="297.68" xlink:href="#linear-gradient" />
                            <linearGradient id="linear-gradient-17" x1="690.17" y1="443.98" x2="759.66"
                                y2="443.98" xlink:href="#linear-gradient" />
                            <linearGradient id="linear-gradient-18" x1="275.92" y1="443.27" x2="345.49"
                                y2="443.27" xlink:href="#linear-gradient" />
                            <linearGradient id="linear-gradient-19" x1="195.95" y1="76.77" x2="361.44"
                                y2="76.77" xlink:href="#linear-gradient" />
                            <linearGradient id="linear-gradient-20" x1="196.06" y1="-71.14" x2="358.3"
                                y2="-71.14" xlink:href="#linear-gradient" />
                            <linearGradient id="linear-gradient-21" x1="421.17" y1="-140.38" x2="629.27"
                                y2="-140.38" xlink:href="#linear-gradient" />
                            <linearGradient id="linear-gradient-22" x1="680.35" y1="-71.19" x2="842.29"
                                y2="-71.19" xlink:href="#linear-gradient" />
                            <linearGradient id="linear-gradient-23" x1="396.28" y1="128.54" x2="649.13"
                                y2="128.54" xlink:href="#linear-gradient" />
                            <linearGradient id="linear-gradient-24" x1="395.2" y1="431.1" x2="644.72"
                                y2="431.1" xlink:href="#linear-gradient" />
                            <linearGradient id="linear-gradient-25" x1="681.43" y1="76.65" x2="847.24"
                                y2="76.65" xlink:href="#linear-gradient" />
                        </defs>
                        <path id="25" data-name="25" class="cls-1"
                            d="M206.29,658.59c-6.1-6.78-7.37-27.66-2.24-35.11,8.92-13,17.6-26.11,26.5-39.1a18.88,18.88,0,0,1,6.74-6C230.4,606.47,226.51,635.48,206.29,658.59Z"
                            transform="translate(0 -0.01)" />
                        <path id="33" data-name=" 33" class="cls-2"
                            d="M255.22,464.18c-1.7,30-3.47,60-5.06,90-.33,6.11-5,5.35-8.31,5-1.62-.18-4.17-4.07-4-6.12,2.25-33.47,4.84-66.91,7.47-100.34.1-1.25,1.43-2.4,2.19-3.59,2.51,1.85,6,3.2,7.24,5.68s.28,6.18.28,9.33Z"
                            transform="translate(0 -0.01)" />
                        <path id="23" data-name="23" class="cls-3"
                            d="M191,345.59c5.28,6,10.56,11.88,15.67,17.89,14,16.45,27.73,33,41.77,49.42,5.48,6.39-1.19,9-3.83,12.63-.27.39-5.26-1.47-6.77-3.33-16.15-20-32.08-40.23-48-60.44C184.75,355.26,184.94,353,191,345.59Z"
                            transform="translate(0 -0.01)" />
                        <path id="31" data-name=" 31" class="cls-4"
                            d="M.49,426.19c0-30.94-.07-61.88.15-92.82,0-2.28,2.3-6.53,3.35-6.48,4.54.24,10.92-1.3,11.72,6,.83,7.59,1.21,15.23,1.43,22.87Q18.86,415,20.39,474.37c.35,12.79.42,25.6,1.19,38.37.36,6-1.83,8.67-7.38,10.27C-.07,527.13,0,527.31,0,512.53V426.19Z"
                            transform="translate(0 -0.01)" />
                        <path id="36" data-name="36" class="cls-5"
                            d="M127.34,504.63s-3,35.62,4.53,42.7,21,4.73,28.81,4.26,40-9.41,40.18-18.83,0-28.49,0-28.49l-61.51-13.39S125.68,496.73,127.34,504.63Z"
                            transform="translate(0 -0.01)" />
                        <path id="21" data-name=" 21" class="cls-6"
                            d="M94.4,638.52c19.78,3.62,38.35,6.62,56.67,10.71,3.34.75,7,5.45,8.29,9.12C165,674.27,170,690.45,175,706.62c6.08,19.82,12,39.69,17.63,59.65.51,1.8-1.34,6.06-2.61,6.29-10.33,1.82-21,2-31.15,4.54-11.39,2.81-18.34-3.51-25.65-9.74C107.63,745.57,93.47,716.49,81.71,686q-5.82-15.12-10.62-30.61c-.46-1.47,1.4-4.49,3-5.61,4.85-3.38,10.06-6.26,15.22-9.17A34.72,34.72,0,0,1,94.4,638.52Z"
                            transform="translate(0 -0.01)" />
                        <path id="18" data-name=" 18" class="cls-7"
                            d="M45.26,126c0-13.15.15-26.3-.08-39.44-.08-4.63,1.6-6.32,6.12-6a53.86,53.86,0,0,0,10.47,0c8-1,14.35,1.79,20.37,7,2.7,2.36,7,3.58,10.75,3.89,6.93.58,14,.07,20.94.11,17.53.08,29.18,9,35.31,25.53,8.18,22,13.69,44.63,14.39,67.93.63,20.59-1,41.28-2.37,61.88-.89,13.2-2.25,26.52-5.16,39.39-3.3,14.6-8.18,28.89-13.19,43-1.93,5.43-6,8.93-13.29,6-26.35-10.59-53-20.53-79.3-31.16-2.4-1-4.67-5-5-7.88-.71-6.75,0-13.63-.25-20.44-.16-4.48,1.83-5.11,5.87-5.72,10.39-1.57,21.49-2.28,30.75-6.64,17.38-8.19,23.14-25,23.23-42.8A80.72,80.72,0,0,0,98.56,189C93.65,177.61,82.29,173.7,70,173.43a153.77,153.77,0,0,1-20.23-1.34c-1.8-.28-4.36-3.76-4.42-5.84-.4-13.47-.2-27-.2-40.43Z"
                            transform="translate(0 -0.01)" />
                        <path id="16" data-name=" 16" class="cls-8"
                            d="M529.92,659.75c-21.64-23.76-24.13-53.08-32.91-80l2.1-1.32c1.51,1.44,3.34,2.66,4.48,4.35,9.86,14.58,19.74,29.15,29.22,44A14.56,14.56,0,0,1,534.6,636C533.52,643.81,531.61,651.46,529.92,659.75Z"
                            transform="translate(0 -0.01)" />
                        <path id="15" data-name=" 15" class="cls-9"
                            d="M509,554.86c-.79.83-2.41,4-4.48,4.38-4,.63-8.34.36-8.62-5.91-.94-21.07-2.21-42.12-3.27-63.18-.55-10.79-1.29-21.58-1.11-32.36,0-2.72,3.2-5.44,5.18-8,.1-.12,3.72,1.54,3.8,2.54C503.39,485.81,506.07,519.17,509,554.86Z"
                            transform="translate(0 -0.01)" />
                        <path id="14" data-name=" 14" class="cls-10"
                            d="M548.75,344.66c6,6.55,7,11.35,2.18,17.22C534.28,382.16,518,402.75,501.35,423c-1.3,1.58-6,2.84-6.12,2.57-2.15-3.77-9.48-6.09-4.23-12.24,7.76-9.08,15.68-18,23.47-27.09q15.42-17.94,30.71-36A48.1,48.1,0,0,0,548.75,344.66Z"
                            transform="translate(0 -0.01)" />
                        <path id="13" data-name=" 13" class="cls-11"
                            d="M737.74,426.81c0,31.1-.08,62.21.08,93.31,0,5-1.16,6.36-6.27,5.07-15.29-3.84-15.59-3.66-15.19-19.11q1.93-75.51,4.22-151c.19-6.8.88-13.59,1.06-20.4.22-8.23,6.46-8,11.7-7.74,1.42.07,3.69,4.9,3.72,7.56.26,30.77.16,61.54.16,92.32Z"
                            transform="translate(0 -0.01)" />
                        <path id="12" data-name="12" class="cls-12"
                            d="M588.43,778.11l-32.38-5.43a8.28,8.28,0,0,0-1-.13c-12-1-12.29-1.09-8.7-13.26,7.53-25.49,15.36-50.9,23.24-76.29,2.95-9.49,6.09-19,9.78-28.18a10.6,10.6,0,0,1,6.61-5.64c18.56-3.75,37.2-7,55.86-10.25,1.82-.31,4.08.67,5.84,1.62,5.52,3,11,6.08,16.26,9.44,1.29.81,2.88,3.17,2.53,4.21-14.72,44.21-29.65,88.36-68.93,118.21A100.67,100.67,0,0,1,588.43,778.11Z"
                            transform="translate(0 -0.01)" />
                        <path id="9" data-name="9" class="cls-13"
                            d="M693.45,126.19c0,13-.14,26,.07,39,.1,5.76-1.89,6.8-7.81,7.46-14,1.55-29.15-1.08-41,10.08-12.71,12.08-12.6,27.64-10.71,42.8,3.87,30.87,21.1,45.21,52.32,44.81,5.82-.08,7.7,1.63,7.24,7.3a84.15,84.15,0,0,0,.06,15.47c.73,6.95-2.17,10.69-8.55,13.08-25.36,9.52-50.59,19.41-75.93,29-7.1,2.68-12,.39-14.48-7.91-5-16.76-10.72-33.54-13.45-50.74-3.57-22.57-5.33-45.52-6.4-68.37a219.57,219.57,0,0,1,7.44-69.54c3.85-13.8,6.87-28.7,18.78-38.26,5.35-4.29,12.71-6.51,19.52-8.35,4.65-1.27,10-.66,14.9-.19,10.22,1,18.71-1.36,27.06-8.14,4.09-3.32,11.85-2.75,18-2.83,14.72-.2,12.69-2.17,12.85,12.43.12,11,0,22,0,33Z"
                            transform="translate(0 -0.01)" />
                        <path id="7" data-name="7" class="cls-14"
                            d="M494,778a32.74,32.74,0,0,1,.63,4.83c-.17,8-.32,16-.74,23.93-.38,7.3-7.54,12.94-16.92,14.09-17.24,2.09-34.4,5.15-51.69,6.37-20.36,1.43-40.84,2.24-61.22,1.64-20.16-.6-40.31-2.82-60.35-5.27a182.83,182.83,0,0,1-32-7.28c-3.82-1.19-8.39-5.15-9.54-8.81-3-9.61-4.3-19.76-5.22-30.11,12.1,15.22,26.88,24.86,45.66,27.87,9.19,1.47,18.43,3.44,27.67,3.55,33.37.38,66.78,1,100.09-.38,15.15-.61,31.17-2.42,44-12.45C481.16,790.74,487,784.46,494,778Z"
                            transform="translate(0 -0.01)" />
                        <path id="6" data-name="6" class="cls-15"
                            d="M274.1,665.13c16,4.84,30.76,10.92,46.15,13.62,21.13,3.7,42.75,7,64.09,6.59,30.36-.5,59.78-8.35,88.24-19.22,3.85-1.48,5.33-.59,5.63,4.22,1.42,22.59-5.57,43.89-9.32,65.67-1.88,10.93-3.2,22.12-6.7,32.54-1.78,5.33-7,11.45-12.07,13.34-14.53,5.4-29.57,10.75-44.82,12.5a219.35,219.35,0,0,1-53.89-.33c-21.14-2.85-42.1-8.45-60.82-19.51-2.78-1.64-4.81-6.35-5.26-9.88-4-31.34-7.55-62.74-11.2-94.12A44.54,44.54,0,0,1,274.1,665.13Z"
                            transform="translate(0 -0.01)" />
                        <path id="5" data-name="5" class="cls-5"
                            d="M295.12,586s52.23,20.82,107.29,15,52.24-15,52.24-15l18.82,44.14s-1.88,13.52-29.18,16.21-93.64,8.34-104,4.57-51.76-10.84-56-12-8-8.76-8-8.76S287.59,586,291.35,586Z"
                            transform="translate(0 -0.01)" />
                        <path id="4" data-name="4" class="cls-16"
                            d="M289.08,487.71c0-15.32-.07-30.64,0-46,.08-12.49,3-16.94,15-19,14-2.46,28.24-4.91,42.39-5.07,26.75-.28,53.52.86,80.26,1.94,6.2.24,13.06,1.33,18.25,4.37a30.94,30.94,0,0,1,12.36,13.77c2.65,6.37,3,14,3.16,21,.37,21.14.13,42.29.12,63.44,0,30.26-3,35-31.57,45.09a75.84,75.84,0,0,1-23.31,4.6c-20.61.45-41.35,1-61.84-.77a83.29,83.29,0,0,1-47.69-19.72c-4.33-3.75-6.64-11.6-7-17.76-1-15.25-.32-30.62-.32-45.93Z"
                            transform="translate(0 -0.01)" />
                        <path id="2" data-name="2" class="cls-17"
                            d="M239.7,261.18c-.23-41.54,1.38-83.07,14.44-122.88,6.49-19.79,15.93-38.62,24.33-57.76a8.11,8.11,0,0,1,5.58-3.9C303.05,74.45,322,71.08,341,71c33.82-.13,67.63,2.23,101.46,2.69,18.15.25,26.73,11,32,26C481.67,120.33,489,141,494.94,162c10.83,38.6,11.32,78.34,10.63,118-.19,10.72-2.14,11.32-12.75,10.05-29.65-3.53-59.36-6.49-89-9.76-34.61-3.81-69,.48-103.33,3.32-11,.91-21.8,3.85-32.76,5.22A188.74,188.74,0,0,1,243.49,290c-1.25,0-3.47-3.1-3.56-4.84C239.49,277.15,239.7,269.16,239.7,261.18Z"
                            transform="translate(0 -0.01)" />
                        <path id="30" data-name="30" class="cls-5"
                            d="M570.7,19.36s-12.7,4.95-13.05,7.37,0,20.63,0,20.63l10,4.83h31.11s8.06-4.22,8.06-7.29-3.88-9.12-3.88-9.12-2.12-4.4-8-10.5a19.29,19.29,0,0,0-13.25-5.92Z"
                            transform="translate(0 -0.01)" />
                        <path id="8" data-name="8" class="cls-18"
                            d="M580.16,55.4c-5.16,0-10.5.84-15.41-.26-3.93-.88-7.91-3.54-10.8-6.46-3-3.08-4.71-5.34-7.64-.18-.71,1.26-2.84,1.73-4.31,2.56-.54-1.45-1.51-2.9-1.53-4.36-.14-9.32-.27-18.65.11-28,.07-1.86,2.33-3.63,3.57-5.45a33.17,33.17,0,0,1,2.46,5.18c.51,1.72,0,3.81.73,5.37.85,1.84,2.56,3.29,3.89,4.9,1.46-1.2,3.35-2.14,4.31-3.67,4-6.32,9.72-8.8,17-8.38,14,.82,27.23,3.34,34.79,17.22,6.11,11.23.54,21.15-12.15,21.55-5,.15-10,0-15,0Zm7.64-5.63h1c3.61-.51,7.36-.61,10.77-1.73,1.54-.51,3.52-3.16,3.39-4.69-.75-9.23-10.69-19.74-19.74-20.91a23.1,23.1,0,0,0-6.91-.33,19.85,19.85,0,0,1-3.93.07c-12.15-.84-13.52,5.2-10.91,17.06a3.41,3.41,0,0,1,0,1.49C560,47,564,48.34,568.77,48.5c6.72.22,11.79,1.27,18.4,1.27Z"
                            transform="translate(0 -0.01)" />
                        <path id="34" data-name=" 34" class="cls-5"
                            d="M176.36,28.77s-4.63-9.6-10-9.41-26.88,5.92-26.88,5.92l-6.54,9.93-3.06,10.07,3.06,7.3h39.95l8.83-10.37,3.07-7Z"
                            transform="translate(0 -0.01)" />
                        <path id="17" data-name="17" class="cls-19"
                            d="M155,56c-5.48,0-11,.47-16.44-.1-10.37-1.08-14.72-8.51-11.36-18.55,3.77-11.31,16-19,30.79-19.95,9.67-.63,18.32.14,23.47,10,.37.7,5.08.44,5.49-.44,1.29-2.74,1.34-6,2.17-9a21.67,21.67,0,0,1,2.31-4.26c1.31,1.11,3.73,2.18,3.78,3.34.41,11,.46,21.92.43,32.89,0,.74-1.7,2.24-2.23,2.09-1.45-.42-3.24-1.22-3.92-2.43-3.21-5.68-4.86-2.92-8.2.32-3.18,3.1-7.94,5.18-12.36,6.22s-9.27.23-13.93.23Zm-1.41-6c6.53-.45,11.7-.53,16.76-1.31a6.54,6.54,0,0,0,4.5-3.59c4.15-14.23-.34-20.44-15-21.29h-.5c-16.7-1.52-20.87,1.24-25.78,17.17-1.41,4.54-1,7.85,5,8,5.49.14,10.93.74,15,1Z"
                            transform="translate(0 -0.01)" />
                        <path id="35" data-name="35" class="cls-5"
                            d="M140.76,375.52s-16.83,28.46-16.65,42,8.65,28.78,13.36,32.23,59.77,15.6,59.77,15.6,12.56-1.32,11.22-12.15-7.6-22.58-7.6-22.58Z"
                            transform="translate(0 -0.01)" />
                        <path id="19" data-name="19" class="cls-20"
                            d="M211.6,440.06c-.94,11.87-1.43,21.18-2.63,30.4-.2,1.55-3.7,4.1-5.29,3.84-22.13-3.66-44.3-7.19-66.23-11.84-28.37-6-56.51-13.07-84.78-19.54-5-1.13-6.59-3.77-6.56-8.78q.27-49.93,0-99.87c0-4.83,1.18-6.31,6.06-4.42,27,10.43,54.34,20,80.85,31.43,8.54,3.7,15.18,12.13,22.19,18.91Q182,406,208.13,432.42C210.5,434.81,211.09,438.86,211.6,440.06Zm-11.16-.59c-.79-1.36-2.09-4.92-4.47-7.45-6.6-7-13.63-13.66-20.55-20.38-8.72-8.46-17.39-17-26.37-25.14-1.23-1.11-5.21-1.34-6-.38-3.16,3.74-7,7.83-7.89,12.34-1.31,6.49-1,13.54-.09,20.19,1,7.72,3.9,15.2,4.85,22.92.6,4.9,2,7.57,6.9,8.74,15.51,3.73,30.93,7.84,46.48,11.36,1.44.32,4.82-2.2,5.18-3.87C199.59,452.65,199.7,447.27,200.44,439.47Z"
                            transform="translate(0 -0.01)" />
                        <path id="24" data-name="24" class="cls-5"
                            d="M614.49,515.35S602.34,488.56,577,494.9s-38,2.8-37,16.22,8.07,36.21,8.07,36.21,45.8,21.19,56.43,11.55S614.49,515.35,614.49,515.35Z"
                            transform="translate(0 -0.01)" />
                        <path id="37" data-name="37" class="cls-21"
                            d="M169.94,559.41s-19.76,8.09-17.41,12.84S161.16,586,163.67,586s4.92-1.43,9.6-10.37,5.14-14.82,4.2-16.12S169.94,559.41,169.94,559.41Z"
                            transform="translate(0 -0.01)" />
                        <path id="20" data-name=" 20" class="cls-22"
                            d="M208.46,502.23c-1.77,9.72-3.38,17.2-4.41,24.77-.64,4.64.88,10-.83,14-2.78,6.62-7.17,12.64-11.38,18.57-2.27,3.19-6.68,5.15-8.18,8.54-4.44,10-7.3,20.83-11.94,30.78-4.94,10.6-11.14,20.62-17,30.75-.37.64-3.19.61-4.31,0q-37.62-22.11-75.08-44.47c-4-2.41-3.15-5-.46-8.1,9.88-11.31,11.91-29.12,2.38-36.65-6.89-5.46-16.4-8-25.1-10.62-4.17-1.28-5.95-2.66-5.93-6.84.07-16.47.11-33,0-49.43,0-3.67.87-5,4.93-4.25,31.82,6.18,63.66,12.18,95.5,18.2,17.78,3.37,35.61,6.5,53.33,10.13C203.16,498.22,206,500.81,208.46,502.23Zm-73.54,15.5a7.4,7.4,0,0,0,.05,3c1.76,8.11,3.42,16.26,5.78,24.2.4,1.34,4.29,2.74,6.18,2.33,7.79-1.68,15.31-4.8,23.14-6,16.53-2.53,26.5-9.71,24.85-28.31-.41-4.59-.67-7.06-5.6-7.86-12.32-2-24.63-4-36.83-6.61-5.41-1.15-9.11-1.2-10,5.4-.15,1.16-1.36,3.15-2.06,3.14-6.87-.12-5.1,4.89-5.51,10.71Zm25.76,53.56c1.59,4,2.29,5.92,3.23,7.72.07.13,2.4-.35,2.78-1,2.39-4.33,4.61-8.77,6.57-13.32.17-.4-2.81-2.73-2.94-2.61C166.92,565.08,163.71,568.31,160.68,571.29Z"
                            transform="translate(0 -0.01)" />
                        <path id="29" data-name=" 29" class="cls-23"
                            d="M377.75,657.27c-34.75-.8-66.93-3.83-97.7-15.39-9.74-3.65-10.07-4.92-7-14.81,4.36-14.14,8.55-28.33,12.78-42.52,1.28-4.3,2.05-5.39,7.33-2.67,9.45,4.89,19.91,9.69,30.28,10.55A736.23,736.23,0,0,0,401.89,595c14-.34,27.92-5,41.85-7.76a9.36,9.36,0,0,0,4.9-2.24c6-6.55,9.42-3.48,12,3,6.32,15.54,12.73,31,18.71,46.7.51,1.35-1.53,5-3.15,5.63-24.18,9.52-49.45,14.17-75.3,15.88C392.48,656.69,384,657,377.75,657.27Zm-46.53-23.46.3-2.11a22.29,22.29,0,0,1,2.83-.18c11.15.53,22.21,1.14,33.48.81,14.29-.41,29.19,3.86,43,8.61,7.14,2.46,13.38,3.78,20.41,2.26,11.52-2.5,23-5,34.44-8,1.62-.42,4.09-3.61,3.73-4.75C465.22,617.2,460.57,604.11,456,591a17.56,17.56,0,0,0-2.87.57c-28,12.12-57.61,14.21-87.53,12.76-10.13-.49-20.09-3.86-30.23-5.13-6.32-.8-13,.68-19.22-.37-6.8-1.14-13.42-3.74-19.9-6.28-3.59-1.4-5.13-.77-6.09,2.82-2.15,8-4.64,16-6.68,24-3.56,14-3.45,14,11.11,17.86,35,9.18,70.69,9.66,106.51,8.75a78.06,78.06,0,0,0,7.91-1c-8-6.87-34-13.35-41.06-10.32,5.19,1,10,2.09,14.93,2.91,4.71.8,9.47,1.34,14.21,2l-.47,2.73Z"
                            transform="translate(0 -0.01)" />
                        <path id="32" data-name="32" class="cls-21"
                            d="M579.44,566.88s-15.85-16.23-18.68-11.29,4.93,18.35,4.94,20.47,13.74,9.9,13.74,9.9,8.85-5,6.74-10.61A18.16,18.16,0,0,0,579.44,566.88Z"
                            transform="translate(0 -0.01)" />
                        <path id="11" data-name=" 11" class="cls-24"
                            d="M692.37,498.31v24.48c0,4-1.2,6.15-5.86,6.82a71.31,71.31,0,0,0-18.18,5c-14.51,6.36-17.62,28-5.76,40.93,4.62,5,4.16,7.63-1.53,11-23.52,13.78-46.91,27.8-70.32,41.77-3.58,2.14-6.06,3.13-9.22-1.51a112.93,112.93,0,0,1-15.94-34.94c-3.23-12-7.4-24.67-19-32.76-7.55-5.29-11.86-12.09-11-22.83.75-9-2.59-18.33-4.62-27.41-1.55-7,1.13-10.36,7.75-11.54,24.38-4.34,48.78-8.53,73.11-13.13q36.24-6.84,72.33-14.48c6.4-1.37,8.78-.33,8.25,6.62-.55,7.29-.12,14.65-.12,22Zm-87.88,18.21c-1-3.59-1.72-8.46-2.38-8.45-6.07.1-5.75-4.74-7.46-8.21a5.06,5.06,0,0,0-4.24-2.08c-14.24,2.39-28.45,4.94-42.59,7.81-1.57.32-3.83,3-3.78,4.52a125.88,125.88,0,0,0,2.06,19.26c.44,2.31,2.53,5.5,4.54,6.14,13.58,4.31,27.35,8,41,12,4.17,1.19,5.59-.58,6-4.66a110.36,110.36,0,0,1,2.83-15.4A109.18,109.18,0,0,1,604.49,516.52Zm-26.56,55.8c-2.36-3-4.52-6.33-7.23-9.06-1-1-3.33-.79-5-1.12.12,1.66-.14,3.48.45,5a41,41,0,0,0,4.2,7.87c1.1,1.6,2.88,2.74,4.35,4.08Z"
                            transform="translate(0 -0.01)" />
                        <path id="3" data-name="3" class="cls-5"
                            d="M299.22,313.25s-30-.34-36.1,5.81-6.53,10.16-6.53,10.16l29.19,56.37,10,6.83s63.74-14.59,88.7-11.14,66.44,11.14,66.44,11.14L459,380.9l32.5-55.68s-14.45-10.5-24.44-12-76.41-4.93-76.41-4.93H330.7Z"
                            transform="translate(0 -0.01)" />
                        <path id="28" data-name=" 28" class="cls-25"
                            d="M370.22,300.25c40.28,2.32,78.61,3.93,115.75,15,15.42,4.6,16.83,11.88,7.44,26.13-10.46,15.89-19,33-28.66,49.45-3.33,5.67-6.41,10.58-15.42,8.09-46.56-12.85-93.61-12.36-140.76-3.25-5.87,1.14-11.61,3-17.51,3.85-1.94.27-5.26-1.24-6.13-2.89-12.63-24-24.91-48.17-37.39-72.24-2.06-4-1.34-6.44,3.07-7.26,24.77-4.61,49.47-9.74,74.38-13.46C340.55,301.36,356.43,301.23,370.22,300.25Zm2.41,73.8a25.38,25.38,0,0,0,5.9,1.41c22.84,1.6,45.85,1.88,67.78,9.94,1.44.53,4.64-.41,5.32-1.62q15.48-27.61,30.29-55.6c.55-1-1-4.7-2-4.88-19.82-3.55-39.69-6.77-59.55-10.05l-.34,2.11,37.81,5.07c-.07.8-.15,1.59-.22,2.39a22.55,22.55,0,0,1-4.1.43c-8.11-.58-16.22-1.59-24.34-1.77-3.72-.08-7.7,2.61-11.19,2-15.1-2.73-29.93-7.69-45.11-9-18-1.62-36.36-.39-54.55-.39v1.44l53.76,3.61c-13.16,2.66-26,4.85-38.93,5.24-16.12.5-32.24-.58-47.21-8-1.48-.73-3.92-.41-5.58.26-3.38,1.38-6.44,3.56-9.82,5-3.22,1.35-6.67,2.16-10.33,3.31,9.66,19.29,18.71,37.62,28.14,55.75.94,1.81,4.33,3.62,6.34,3.38,19.43-2.3,38.81-5.05,58.21-7.62,5.81-.86,11.66-1.49,19.72-2.41Zm-38.77-51.62-.07-1.59-23.5-1.52-.08,1.49Zm58.57-6c-.09.42-.18.84-.26,1.27l27.23,4c.06-.45.13-.89.2-1.34Z"
                            transform="translate(0 -0.01)" />
                        <path id="26" data-name="26" class="cls-21"
                            d="M327.82,13.71s-19.76,20.6-34.58,20.77-12.68-3.57-10.59-10.39S317.08,7.82,321,7.12,327.82,13.71,327.82,13.71Z"
                            transform="translate(0 -0.01)" />
                        <path id="27" data-name="27" class="cls-21"
                            d="M423.12,15.13s10.3,12.16,19.62,13.57,15.78,9.48,22.73,4.78-6.76-13.19-7.09-13.57S431.62,7.38,429.24,7.44s-5.68,3-5.48,4.59A5.65,5.65,0,0,1,423.12,15.13Z"
                            transform="translate(0 -0.01)" />
                        <path id="1" data-name="1" class="cls-26"
                            d="M494,94.71c-4.57-10.3-9-19.7-13-29.36-4.53-11.25-11.82-20.18-23.46-23.54-16.7-4.84-33.63-10.13-50.78-11.66a363.74,363.74,0,0,0-64.92.31c-22.07,2-43.9,7-63.56,18.46-15.2,8.83-21.91,23.73-28.12,39-.86,2.12-1.75,4.23-2.63,6.35l-2.17-.2c.24-5.16,0-10.39.77-15.48,2.65-18.57,5-38.11,21.2-50.07A171.9,171.9,0,0,1,309.47,5.81C321.38,1.42,335,.37,347.85.16,371.23-.23,394.74,0,418,2.23c10.62,1,21,6.74,31,11.41C481.28,28.56,499.16,60.72,494,94.71ZM431.31,11l-4.74,2.24c.77,1.16,1.29,3,2.35,3.36,8,3,16,6,24.19,8.52,1.65.52,3.85-.71,5.8-1.13-1.27-1.58-2.23-4-3.87-4.61C447.09,16.31,439,13.68,431.31,11ZM293.93,26.73c8.07-3.2,16.65-6.51,25.11-10.08,1-.42,1.38-2.31,2-3.53-1.16-.39-2.5-1.36-3.46-1.07-8.8,2.65-17.56,5.43-26.23,8.46-1.2.42-1.87,2.37-2.79,3.62Z"
                            transform="translate(0 -0.01)" />
                        <path id="22" data-name="22" class="cls-5"
                            d="M601.47,375.52s-54.58,47.13-57.88,54.66-6.11,31.82,0,35.2S582,461.7,582,461.7s19.3.16,28.31-11.92,8.54-54.64,8.54-57.36S609.45,375.92,601.47,375.52Z"
                            transform="translate(0 -0.01)" />
                        <path id="10" data-name="10" class="cls-27"
                            d="M697.3,384.42c0,16.31-.14,32.62.1,48.92.07,5.24-1.29,8.34-6.87,9.54-35.8,7.7-71.53,15.72-107.34,23.39-14.44,3.08-29,5.66-43.56,8.1-1.51.25-4.76-1.78-4.94-3.07-1.31-9.2-2-18.5-3-27.75-.53-5.26.93-9.19,5-13.12,22.11-21.14,43.79-42.73,65.74-64a25.37,25.37,0,0,1,8.14-5.51c26.15-10.24,52.44-20.13,78.57-30.41,6.21-2.45,8.42-1.81,8.21,5.54C697,352.14,697.29,368.29,697.3,384.42Zm-87,13.92-4.5.15c-1-1.92-2.19-3.8-3.12-5.77-1.34-2.87-2.54-5.81-3.8-8.72-2.38,1.56-5.09,2.79-7.1,4.73-14.56,14.08-29.24,28.08-43.35,42.63-2.81,2.89-4.07,7.89-4.67,12.12s.56,8.57.94,12.87,2.25,6.08,6.93,4.87c14.15-3.66,28.27-7.65,42.64-10.2,7.73-1.38,9.34-5.28,9.37-11.82a78,78,0,0,1,1-13.3c1.7-9.23,3.79-18.38,5.7-27.56Z"
                            transform="translate(0 -0.01)" />
                    </svg>
                </div>
            </div>
            <div class="col-6 mt-4">
                <div class="">
                    <ul class="nav nav-tabs nav-stacked ">
                        @foreach ($typedocuments as $type)
                            <li class="nav-item ">
                                <button type="button" data-filter="{{ $type->type }}" class="link nav-link"
                                    style=" cursor: pointer;" value="{{ $type->id }}">{{ $type->type }} </button>
                            </li>
                        @endforeach

                    </ul>
                    <div class="card-body m-1" id="galley" style="height: 300px; overflow-y:auto">
                        <input type="hidden" id="id" name="dossier_id" value="{{ $dossier->id }}">
                        @if ($dossier->document)
                            <ul style=" list-style-type: none;" id="row" class="row">
                               @foreach ($dossier->document as $doc)
    @if ($doc->type_document_id != 10)
        @php
            $cacheKey = 'document_image_' . $doc->id;
            $cacheTime = 1800; // in minutes
            $imageUrl = cache()->remember($cacheKey, $cacheTime, function () use ($doc) {
                return Storage::disk('s3')->temporaryUrl($doc->path, now()->addMinutes(30));
            });
        @endphp

        <li class="box container col-3 media {{ $doc->typedocument->type }} ">
            <img data-original="{{ $imageUrl }}" src="{{ $imageUrl }}" alt="img" class="img-fluid m-1" srcset="">
            <div class="middle">
                <a href="{{ route('Document.edit', $doc->id) }}" class="text append icon dripicons-document-edit"></a>
            </div>
            <span class="badge bg-primary m-1" style="display: block;">{{ $doc->typedocument->type ?? null }}</span>
        </li>
    @endif
@endforeach


                            </ul>
                        @endif
                    </div>
                    {{-- @include('dossiers.modal', ['id' => $dossier->id]) --}}


                </div>
            </div>
        </div>

    </form>
    @if ($dossier->dossier_status_id != 3)
        @if ($rapport->rapport_status_id != 2 && $rapport->rapport_status_id != 3)
            <button type="button" class="btn btn-primary mt-2 mb-2" data-bs-toggle="modal"
                data-bs-target="#signup-modal">
                Assigner Une
                Piece
            </button>

            @include('rapport.modal')
            @can('create', App\Models\Piece::class)
            <button style="float: right" type="button" class="btn btn-info mt-2 mb-2" data-bs-toggle="modal"
                data-bs-target="#create">
                Ajouter Une
                Piece
            </button>
            @include('devis.modal')
            @endcan
        @endif
    @endif
    <div class="row" id="elementId">
        <div class="col-12">
            <div class="card mb-2">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>Categorie</th>
                                    <th>Piéce</th>
                                    <th>Operation</th>
                                    <th>Reparation</th>
                                    <th>Prix Unitaire</th>
                                    <th>Qte</th>
                                    <th>Gravite</th>
                                    <th>Etat</th>
                                    <th>Vetuste %</th>
                                    <th>Remise %</th>
                                    <th>Select</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($rapport->piece as $piece)
                                    <tr>
                                        <td>
                                            @if ($rapport->rapport_status_id == 2 || $rapport->rapport_status_id == 3)
                                                <input type="text" id="t{{ $piece->id }}" name="operation"
                                                    class="form-control" readonly value="{{ $piece->piecetype->type }}">
                                            @else
                                                <select class="form-select" name="piecetype" id="pt{{ $piece->id }}"
                                                    onchange="list({{ $piece->id }},this.value)">
                                                    <option selected value="{{ $piece->piecetype->id }}">
                                                        {{ $piece->piecetype->type }}</option>

                                                    @foreach ($piecetypes as $piecetype)
                                                        @if ($piecetype->id != $piece->piecetype->id)
                                                            <option value="{{ $piecetype->id }}">
                                                                {{ $piecetype->type }}
                                                            </option>
                                                        @endif
                                                    @endforeach
                                                </select>
                                            @endif
                                        </td>
                                        <td>

                                            @if ($rapport->rapport_status_id == 2 || $rapport->rapport_status_id == 3)
                                                <input type="text" id="pc{{ $piece->id }}" name="pc"
                                                    class="form-control" readonly value="{{ $piece->piece }}">
                                            @else
                                                <select class="form-select" name="pc" id="pc{{ $piece->id }}">
                                                    <option selected value="{{ $piece->id }}">
                                                        {{ $piece->piece }}
                                                    </option>
                                                </select>
                                            @endif
                                        <td>
                                            @if ($rapport->rapport_status_id == 2 || $rapport->rapport_status_id == 3)
                                                <input type="text" id="t{{ $piece->id }}" name="operation"
                                                    class="form-control" readonly
                                                    value="{{ $piece->pivot->operation->operation }}">
                                            @else
                                                <select class="form-select" name="operation" id="o{{ $piece->id }}">
                                                    <option selected value="{{ $piece->pivot->operation->id ?? null }}">
                                                        {{ $piece->pivot->operation->operation ?? null }}</option>

                                                    @foreach ($operations as $operation)
                                                        @if ($operation->id != $piece->pivot->operation->id)
                                                            <option value="{{ $operation->id }}">
                                                                {{ $operation->operation }}
                                                            </option>
                                                        @endif
                                                    @endforeach

                                                </select>
                                            @endif
                                        </td>
                                        <td>
                                            @if ($rapport->rapport_status_id == 2 || $rapport->rapport_status_id == 3)
                                                <input type="text" id="t{{ $piece->id }}" name="type"
                                                    class="form-control" readonly
                                                    value="{{ $piece->pivot->typereparation->type }}">
                                            @else
                                                <select class="form-select" name="type" id="t{{ $piece->id }}">
                                                    <option selected value="{{ $piece->pivot->typereparation->id }}">
                                                        {{ $piece->pivot->typereparation->type }}</option>

                                                    @foreach ($types as $type)
                                                        @if ($type->id != $piece->pivot->typereparation->id)
                                                            <option value="{{ $type->id }}">{{ $type->type }}
                                                            </option>
                                                        @endif
                                                    @endforeach
                                                </select>
                                            @endif
                                        </td>
                                        <td> <input class="form-control" name="prix_unitaire" id="p{{ $piece->id }}"
                                                @if ($rapport->rapport_status_id == 2 || $rapport->rapport_status_id == 3) readonly @endif type="number"
                                                step="0.0" value="{{ $piece->pivot->prix_unitaire }}"
                                                min="1">
                                            {{ $dossier->currency->symbole ?? null }}</td>
                                        <td>
                                            <input class="form-control" name="qte" id="q{{ $piece->id }}"
                                                @if ($rapport->rapport_status_id == 2 || $rapport->rapport_status_id == 3) readonly @endif type="number"
                                                value="{{ $piece->pivot->qte }}" min="1">
                                        </td>
                                        <td>

                                            @if ($rapport->rapport_status_id == 2 || $rapport->rapport_status_id == 3)
                                                <input type="number" id="v{{ $piece->id }}" min="0"
                                                    name="vetuste" class="form-control" readonly
                                                    value="{{ $piece->pivot->gravite }}">
                                            @else
                                                <select class="form-select" name="gravite" id="g{{ $piece->id }}">
                                                    <option selected value="{{ $piece->pivot->gravite }}">
                                                        {{ $piece->pivot->gravite }}</option>
                                                    @if ($piece->pivot->gravite == 'Moyen')
                                                        <option value="Faible">Faible</option>
                                                    @elseif($piece->pivot->gravite == 'Faible')
                                                        <option value="Moyen">Moyen</option>
                                                    @else
                                                        <option value="Moyen">Moyen</option>
                                                        <option value="Faible">Faible</option>
                                                    @endif
                                                </select>
                                            @endif
                                        </td>
                                        <td>

                                            @if ($rapport->rapport_status_id == 2 || $rapport->rapport_status_id == 3)
                                                <input type="number" id="e{{ $piece->id }}" min="0"
                                                    name="vetuste" class="form-control" readonly
                                                    value="{{ $piece->pivot->etat }}">
                                            @else
                                                <select class="form-select" name="etat" id="e{{ $piece->id }}">
                                                    <option selected value="{{ $piece->pivot->etat }}">
                                                        {{ $piece->pivot->etat }}</option>
                                                    @if ($piece->pivot->etat == 'OUI')
                                                        <option value="NON">NON</option>
                                                    @elseif($piece->pivot->etat == 'NON')
                                                        <option value="OUI">OUI</option>
                                                    @else
                                                        <option value="OUI">OUI</option>
                                                        <option value="NON">NON</option>
                                                    @endif

                                                </select>
                                            @endif
                                        </td>

                                        <td>

                                            <input type="number" id="v{{ $piece->id }}" min="0"
                                                name="vetuste" class="form-control"
                                                @if ($rapport->rapport_status_id == 2 || $rapport->rapport_status_id == 3) readonly @endif
                                                value="{{ $piece->pivot->vetuste }}">
                                        </td>
                                        <td>
                                           <input type="number" id="r{{ $piece->id }}" name="remise"
                                                step="0.01" min="0" max="100"
                                                @if ($rapport->rapport_status_id == 2 || $rapport->rapport_status_id == 3) readonly @endif class="form-control"
                                                value="{{ number_format($piece->pivot->remise, 2, '.', '') }}">
                                        </td>
                                        <td>
                                            <input class="form-check-input check" type="checkbox" name="piece" checked
                                                @if ($rapport->rapport_status_id == 2 || $rapport->rapport_status_id == 3) readonly @endif
                                                value="{{ $piece->id }}">
                                        </td>
                                    </tr>
                                @endforeach

                            </tbody>
                        </table>
                        @if ($dossier->dossier_status_id != 3 && $dossier->update != 1)
                            @if ($rapport->rapport_status_id != 2 && $rapport->rapport_status_id != 3)
                                <a class="btn btn-dark mt-3 save"> Enregistrer Piece</a>
                            @endif
                        @endif
                        <button style="float: right" type="button" class=" mt-3 btn btn-danger" data-bs-toggle="modal"
                            data-bs-target="#full-width-modal">Ajouter Taux Rapport</button>
                        @include('rapport.taux')
                    </div>
                </div>
            </div>
        </div>
    </div>
    {{-- <div class="row mt-3">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h4>Liste des Ancien Piece du {{ $dossier->vehiculemodel->name ?? 'Modéle' }}</h4>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table" id="myTable2">
                            <thead>
                                <tr>
                                    <th>Categorie</th>
                                    <th>Piéce</th>
                                    <th>Operation</th>
                                    <th>Reparation</th>
                                    <th>Prix Unitaire</th>
                                    <th>Gravite</th>
                                    <th>Etat</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($pieces as $piece)
                                    <tr>
                                        <td>{{ $piece->piecetype->type ?? null }}</td>
                                        <td>{{ $piece->piece ?? null }}</td>
                                        <td>{{ $piece->operation->operation ?? null }}</td>
                                        <td>{{ $piece->typereparation->type ?? null }}</td>
                                        <td>{{ $piece->rapport[0]->pivot->prix_unitaire ?? null }}</td>
                                        <td>{{ $piece->rapport[0]->pivot->gravite ?? null }}</td>
                                        <td>{{ $piece->rapport[0]->pivot->etat ?? null }}</td>
                                    </tr>
                                @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div> --}}
    <div class="row mt-2">
        <div class="col-lg-6">
            <div class="card">
                <div class="card-body">

                    <h4 class="header-title mb-3" style="color: black">Observation</h4>
                    @if ($dossier->observation)
                        <div class="accordion" id="">
                            @foreach ($dossier->observation as $key => $observation)
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="headingOne" style="margin-top: unset;">
                                        <button class="accordion-button collapsed" type="button"
                                            data-bs-toggle="collapse" data-bs-target="#collapse-{{ $key }}"
                                            aria-expanded="false" aria-controls="">
                                            {{ $observation->user->name }}
                                        </button>
                                    </h2>
                                    <div id="collapse-{{ $key }}" class="accordion-collapse collapse "
                                        aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                                        <div class="accordion-body">
                                            <strong class="text-dark">{{ $observation->observation }}.</strong>
                                            <span>{{ $observation->created_at }}</span>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @endif
                    @if ($dossier->dossier_status_id != 3 && $dossier->update != 1)
                        <form method="POST" action="{{ route('Observation.store') }}">
                            @csrf
                            <div class="col-md-12 mt-1 ml-3">
                                <input type="hidden" name="for_rapport" value="1">
                                <input type="hidden" name="dossier_id" value="{{ $dossier->id }}">
                                <input type="hidden" name="rapport_id" value="{{ $rapport->id }}">
                                <textarea name="observation" class="form-control mb-2" id="observation" cols="30" rows="10"></textarea>

                                <button class="mt-2 btn btn-info">Créer</button>
                            </div>
                        </form>
                    @endif
                </div>
            </div>
        </div>

    </div>

@endsection

@section('script')
    <script src="{{ asset('js/viewer.js') }}"></script>
    <script>
        // function scrollToElement(elementId) {
        //     const element = document.getElementById(elementId);
        //     if (element) {
        //         element.scrollIntoView({ behavior: 'smooth' });
        //     }
        // }
        // scrollToElement('elementId')

    </script>
    <script>


        var $mediaElements = $('.media');

        $('.link').click(function(e) {
            e.preventDefault();
            // get the category from the attribute
            var filterVal = $(this).data('filter');
            console.log(filterVal);
            var type_id = this.value;
            if (filterVal === 'AA') {
                $mediaElements.show();
            } else {
                // hide all then filter the ones to show
                $mediaElements.hide().filter('.' + filterVal).show();
            }
        });

        //viewer
        window.addEventListener('DOMContentLoaded', function() {
            var galley = document.getElementById('galley');
            var maxOffsetPercentage = 0.9;
            var viewer = new Viewer(galley, {
                url: 'data-original',
                backdrop: 'static',
                move: function(event) {
                    var viewerData = viewer.viewerData;
                    var imageData = viewer.imageData;
                    var maxOffsetHorizontal = viewerData.width * maxOffsetPercentage;
                    var maxOffsetVertical = viewerData.height * maxOffsetPercentage;
                    var detail = event.detail;
                    var left = detail.x;
                    var top = detail.y;
                    var right = viewerData.width - (left + imageData.width);
                    var bottom = viewerData.height - (top + imageData.height);
                    if (
                        // Move left
                        (detail.x < detail.oldX && right > 0 && right > maxOffsetHorizontal)
                        // Move right
                        ||
                        (detail.x > detail.oldX && left > 0 && left > maxOffsetHorizontal)
                        // Move up
                        ||
                        (detail.y < detail.oldY && bottom > 0 && bottom > maxOffsetVertical)
                        // Move down
                        ||
                        (detail.y > detail.oldY && top > 0 && top > maxOffsetVertical)
                    ) {
                        event.preventDefault();
                    }
                },
                zoomed: function(event) {
                    var detail = event.detail;
                    // Zoom out
                    if (detail.ratio < detail.oldRatio) {
                        var viewerData = viewer.viewerData;
                        var imageData = viewer.imageData;
                        var maxOffsetHorizontal = viewerData.width * maxOffsetPercentage;
                        var maxOffsetVertical = viewerData.height * maxOffsetPercentage;
                        var left = imageData.x;
                        var top = imageData.y;
                        var right = viewerData.width - (left + imageData.width);
                        var bottom = viewerData.height - (top + imageData.height);
                        var x = 0;
                        var y = 0;
                        if (right > 0 && right > maxOffsetHorizontal) {
                            x = maxOffsetHorizontal - right;
                        }
                        if (left > 0 && left > maxOffsetHorizontal) {
                            x = maxOffsetHorizontal - left;
                        }

                        if (bottom > 0 && bottom > maxOffsetVertical) {
                            y = bottom - maxOffsetVertical;
                        }

                        if (top > 0 && top > maxOffsetVertical) {
                            y = top - maxOffsetVertical;
                        }

                        // Move the image into view if it is invisible
                        if (x !== 0 || y !== 0) {
                            viewer.move(x, y);
                        }
                    }
                },
            });
        });
        //list
        function list(some, type) {
            // console.log(some, type);

            var type_id = type;
            $.ajax({
                url: '/TypePiece/' + type_id,
                type: 'get',
                success: function(result) {
                    var selectElement = $("#pc" + some); // Corrected line
                    console.log(result);
                    console.log(selectElement);
                    selectElement.empty(); // Clear previous options

                    $.each(result, function(key, value) {
                        selectElement.append('<option value="' + value.id + '">' + value.piece +
                            '</option>');
                    });
                }
            });
        }
        //attach
        $(document).ready(function() {

            $(".save").click(function(event) {

                event.preventDefault();

                var checkedRowIndices = [];
                var checkedRowIndices1 = [];
                var checkedRowIndices2 = [];
                var qtes = [];
                var vetustes = [];
                var remises = [];
                var prices = [];
                var gravities = [];
                var etats = [];

                var piecetypes = [];
                var pieces = [];
                var types = [];
                var operations = [];

                $('input[type=checkbox]').each(function(value) {

                    if ($(this)[0].checked) {

                        checkedRowIndices.push($(this)[0].value);

                        piecetypes.push($("#pt" + $(this)[0].value).val());
                        pieces.push($("#pc" + $(this)[0].value).val());
                        types.push($("#t" + $(this)[0].value).val());
                        operations.push($("#o" + $(this)[0].value).val());


                        qtes.push($("#q" + $(this)[0].value).val());
                        vetustes.push($("#v" + $(this)[0].value).val());
                        remises.push($("#r" + $(this)[0].value).val());

                        prices.push($("#p" + $(this)[0].value).val());
                        gravities.push($("#g" + $(this)[0].value).val());
                        etats.push($("#e" + $(this)[0].value).val());

                    }

                });
                // console.log(piecetypes);
                // console.log(pieces);
                // console.log(types);
                // console.log(operations);
                // console.log(qtes);
                // console.log(vetustes);
                // console.log(remises);
                // console.log(prices);
                // console.log(gravities);
                // console.log(etats);

                // console.log(checkedRowIndices);

                let qte = qtes;
                let piece = checkedRowIndices;
                let rapport_id = $("input[name=rapport_id]").val();
                let vetuste = vetustes;
                let remise = remises;
                let _token = $('meta[name="csrf-token"]').attr('content');

                // console.log(piece);
                // console.log(rapport_id);
                // console.log(qte);

                $.ajax({
                    url: "/Rapport/attach",
                    type: "POST",
                    data: {
                        piecetype: piecetypes,
                        libelle: pieces,
                        type: types,
                        operation: operations,
                        piece: piece,
                        rapport_id: rapport_id,
                        qte: qte,
                        vetuste: vetustes,
                        remise: remises,
                        prix_unitaire: prices,
                        etat: etats,
                        gravite: gravities,
                        _token: _token
                    },
                    success: function(response) {
                        // console.log(response);
                        if (response) {
                            $('.success').text(response.success);
                            alert('enregistrer');
                        }
                    },
                });
            });





        });

        //  let table = document.getElementById('items');
        //  for(var i = 0; i < table.childElementCount; i++){
        //         tr = document.getElementById("tr'+i+'");
        //         console.log(tr);
        //     }

        let points = document.getElementsByClassName('checked')
        for (var i = 0; i < points.length; i++) {
            console.log(points[i].value);
            let el = document.getElementById(points[i].value);
            el.removeAttribute('class');
            el.classList.add('fil');
        }

        let elements = document.getElementsByTagName('path');
        for (var i = 0; i < elements.length; i++) {
            elements[i].addEventListener('click', function(e) {
                let piece = document.getElementById(e.target.id);

                const fill = document.getElementsByClassName('fil');
                if (piece.classList.contains('fil')) {
                    piece.removeAttribute('class');
                    piece.classList.add('cls-4');
                } else {
                    piece.removeAttribute('class');
                    piece.classList.add('fil');
                }
                const input = document.getElementById('point');
                let array = [];
                for (var i = 0; i < fill.length; i++) {
                    console.log(fill[i].dataset.name);
                    array.push(fill[i].dataset.name)
                }
                var markup = $('<tr id="tr' + i + '"><td>' + e.target.dataset.name +
                    '</td><td> <div class="form-check form-radio-warning mb-2"><input type="radio" checked  id="customRadiocolor' +
                    i + '" name="customRadiocolor' + i +
                    '" class="form-check-input radio" > </div> </td> <td> <div class="form-check form-radio-success mb-2"><input type="radio" id="customRadiocolor' +
                    i + '" name="customRadiocolor' + i +
                    '" class="form-check-input" > </div> </td><td> <div class="form-check form-radio-danger mb-2"><input type="radio" id="customRadiocolor' +
                    i + '" name="customRadiocolor' + i +
                    '" class="form-check-input" > </div> </td>  </tr>');
                $("#items").append(markup);
                input.value = array;
                console.log(array);

            });
        }
    </script>
@endsection
