<?php

use App\Http\Controllers\api\ApiController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\api\AuthController;
use App\Http\Controllers\LocationController;
use App\Http\Controllers\RendezvousController;
use App\Http\Controllers\StatusRendezvousController;
use App\Models\User;
use Illuminate\Support\Facades\Auth;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    //  $request->user();
     $user = User::whereId(Auth::user()->id)->with('role')->first();
     return $user;
});

//check macadress for tel
Route::post('/check', [ApiController::class, 'check']);
Route::post('/login', [AuthController::class, 'login']);
Route::get('/Meeting/status/{id}',[ApiController::class, 'getstatus']);


//mobile Apis ba9i khss nchuf blan d steps mn creation l EAR
Route::middleware('auth:sanctum')->group(function () {

Route::post('/logout', [AuthController::class, 'logout']);


Route::put('meeting/cloturer/{id}', [ApiController::class, 'cloturer']);//testnow
Route::post('/meeting/upload/{id}', [ApiController::class, 'upload']); //testnow


Route::put('/user/update/token', [ApiController::class, 'updatetoken']);

//upodte km and num chassisù

Route::put('/dossier/update/{id}', [ApiController::class, 'update']);


Route::get('/role', [AuthController::class, 'role']);

// agent all  meetings with status en cours

Route::get('/meeting', [ApiController::class, 'meeting']);
Route::get('/meeting/{id}', [ApiController::class, 'showmeeting']);
Route::get('/meeting/ref/{id}', [ApiController::class, 'getref']);



// agent create observation
Route::post('/meeting/observation', [ApiController::class, 'observation']);
//show dossier
Route::get('/dossier/show/{id}', [ApiController::class, 'showdossier']);
//update meeting status
Route::put('/meeting/status/{meeting_id}', [ApiController::class, 'status']);
//all type needed
Route::get('/typedocument', [ApiController::class, 'typedocument']);

// Route::get('/typeobservation', [ApiController::class, 'typeobservation']);
// search with matricule or new matricule
Route::post('/meeting/search', [ApiController::class, 'search']);
//Agent Location every 15m
Route::post('/location', [LocationController::class, 'store']);
//Todo  add documents and image with their type
Route::get('/document/dossier/{id}', [ApiController::class, 'getDossierWithDocs']);
// get docs
Route::get('/dossier/search/{matricule}', [ApiController::class, 'getdossier']);
//demande meet
Route::post('/Demande/meeting', [ApiController::class, 'Demande']);

// Route::post('/Dossier/observation/{id}', [ApiController::class, 'observation']);


});

// web market Apis
Route::get('/dossier/{ref}', [ApiController::class, 'dossier']);
Route::get('/Garage/index', [ApiController::class, 'garages']);
//RDV
Route::get('/Rdv',[RendezvousController::class,'index']);
Route::post('/rdv',[ApiController::class,'store']);
Route::put('/Rdv/{id}',[RendezvousController::class,'update']);
Route::get('/TypeRendezVous',[ApiController::class,'typerendezvous']);
Route::get('/StatusRendezVous',[StatusRendezvousController::class,'index']);


