<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('meetings', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->nullable()->constrained()->onDelete(null);
            $table->foreignId('dossier_id')->nullable()->constrained()->onDelete(null);
            $table->foreignId('garage_id')->nullable()->constrained()->onDelete(null);
            $table->foreignId('meeting_status_id')->nullable()->constrained()->onDelete(null);
            $table->string('adress')->nullable();
            $table->time('start')->nullable();
            $table->date('date')->nullable();
            $table->double('lat')->nullable();
            $table->double('lng')->nullable();
            $table->enum('type',[2,5,10]);
            $table->boolean('assure');//if false is adversaire
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('meetings');
    }
};
