<?php

namespace App\Http\Controllers;

use App\Models\Contradictoire;
use App\Models\Dossier;
use App\Models\Expert;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ContradictoireController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create($id)
    {
        $dossier = Dossier::whereId($id)->with('contradictoire')->firstOrFail();
        $experts = Expert::all();
        if ($dossier->update != 0 && Auth::user()->role_id != 4 ||  $dossier->dossier_status_id == 3 && Auth::user()->role_id != 4) {
            return redirect()->route('Dossier.show', $dossier->id)->with('error', 'Dossier est interdit de le modifier Envoyer une demande a Admin ');
        }
        if ($dossier->type_expertise_id == 4 || $dossier->type_expertise_id == 5 || $dossier->type_expertise_id == 6|| $dossier->type_expertise_id == 7) {

            $cc = Contradictoire::where('dossier_id', $id)->count();

            if ($cc == 0) {
                return view('avis.create', compact('id', 'experts',));
         } else {
                return redirect()->route('Contradictoire.edit', $id);
            }
        } else {
            return redirect()->back()->with('error', 'juste pour les Dossier CONTRADICTOIRE et COLLEGIALE  ');
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $dossier = Dossier::whereId($request->dossier_id)->firstOrFail();
        if ($dossier->update != 0 && Auth::user()->role_id != 4 ||  $dossier->dossier_status_id == 3 && Auth::user()->role_id != 4) {
            return redirect()->route('Dossier.show', $dossier->id)->with('error', 'Dossier est interdit de le modifier Envoyer une demande a Admin ');
        }
        $request->validate([
            'adverse_montant_accord' => 'numeric|nullable',
            'arbitre_montant_accord' => 'numeric|nullable',
            'date_reception_adverse' => 'nullable|date',
            'date_reception_arbitre' => 'nullable|date',
            'date_envoi_avis' => 'nullable|date',
            'date_envoi_demande_arbitrage' => 'nullable|date',
            'date_accord_adverse' => 'nullable|date',
            'date_accord_arbitre' => 'nullable|date',
            'arbitre_id' => 'nullable',
            'adverse_id' => 'required',

        ]);
        if ($request->arbitre_id === $request->adverse_id) {
            return redirect()->route('Contradictoire.create',$dossier->id)->with('error', 'Expert Adverse Doit étre Different du Expert Arbitre');
        }

        Contradictoire::updateOrCreate([
            'dossier_id' => $request->dossier_id
        ], [
            'adverse_id' => $request->adverse_id,
            'arbitre_id' => $request->arbitre_id,
            'adverse_montant_accord' => $request->adverse_montant_accord,
            'arbitre_montant_accord' => $request->arbitre_montant_accord,
            'date_reception_adverse' => $request->date_reception_adverse,
            'date_reception_arbitre' => $request->date_reception_arbitre,
            'date_envoi_avis' => $request->date_envoi_avis,
            'date_envoi_demande_arbitrage' => $request->date_envoi_demande_arbitrage,
            'date_accord_adverse' => $request->date_accord_adverse,
            'date_accord_arbitre' => $request->date_accord_arbitre,
        ]);

        return redirect()->route('Dossier.show',$dossier->id)->with('success',"Experts Ajouter avec Succés");
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Contradictoire  $contradictoire
     * @return \Illuminate\Http\Response
     */
    public function show(Contradictoire $contradictoire)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Contradictoire  $Contradictoire
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $dossier = Dossier::whereId($id)->with('contradictoire')->firstOrFail();
        $contradictoire = Contradictoire::where('dossier_id',$id)->with('adverse','arbitre')->firstOrFail();
        if ($dossier->update != 0 && Auth::user()->role_id != 4 ||  $dossier->dossier_status_id == 3 && Auth::user()->role_id != 4) {
            return redirect()->route('Dossier.edit', $dossier->id)->with('error', 'Dossier est interdit de le modifier Envoyer une demande a Admin ');
        }
        $arbitres = Expert::where('id', '!=' , $contradictoire->arbitre_id ?? null)->get();
        $adverses = Expert::where('id', '!=' , $contradictoire->adverse_id ?? null)->get();

        return view('avis.edit', compact('contradictoire', 'dossier','adverses', 'arbitres'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\AvisDommage  $avisDommage
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        $dossier = Dossier::whereId($request->dossier_id)->firstOrFail();
        if ($dossier->update != 0 && Auth::user()->role_id != 4 ||  $dossier->dossier_status_id == 3 && Auth::user()->role_id != 4) {
            return redirect()->route('Dossier.show', $dossier->id)->with('error', 'Dossier est interdit de le modifier Envoyer une demande a Admin ');
        }

        $request->validate([
            'arbitre_id' => 'nullable',
            'adverse_id' => 'required',
            'adverse_montant_accord' => 'numeric|nullable',
            'arbitre_montant_accord' => 'numeric|nullable',
            'date_reception_adverse' => 'nullable|date',
            'date_reception_arbitre' => 'nullable|date',
            'date_envoi_avis' => 'nullable|date',
            'date_envoi_demande_arbitrage' => 'nullable|date',
            'date_accord_adverse' => 'nullable|date',
            'date_accord_arbitre' => 'nullable|date'
        ]);

        if ($request->arbitre_id === $request->adverse_id) {
            return redirect()->route('Contradictoire.edit',$dossier->id)->with('error', 'Expert Adverse Doit étre Different du Expert Arbitre');
        }

        $cc = Contradictoire::whereId($id)->firstOrFail();
        $cc->adverse_id = $request->adverse_id;
        $cc->arbitre_id = $request->arbitre_id;
        $cc->adverse_montant_accord = $request->adverse_montant_accord;
        $cc->arbitre_montant_accord = $request->arbitre_montant_accord;
        $cc->date_reception_adverse = $request->date_reception_adverse;
        $cc->date_reception_arbitre = $request->date_reception_arbitre;
        $cc->date_envoi_avis = $request->date_envoi_avis;
        $cc->date_envoi_demande_arbitrage = $request->date_envoi_demande_arbitrage;
        $cc->date_accord_adverse = $request->date_accord_adverse;
        $cc->date_accord_arbitre = $request->date_accord_arbitre;
        $cc->update();

        return redirect()->route('Dossier.show',$dossier->id)->with('success',"Experts Modifier avec Succés");
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Contradictoire  $Contradictoire
     * @return \Illuminate\Http\Response
        */
    public function destroy(Contradictoire $Contradictoire)
    {
        //
    }
}
