<?php

namespace App\Mail;

use App\Models\Devis;
use App\Models\Document;
use App\Models\Email;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use Illuminate\Mail\Mailables\Address;
use Illuminate\Mail\Mailables\Attachment;
use Illuminate\Support\Facades\Auth;

class SendAccordMail extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public $documents;
    public $subject;
    public $content;
    public $to;


    public function __construct($documents ,$content, $subject)
    {
        $this->documents = $documents;
        $this->subject = $subject;
        $this->content = $content;


    }

    /**
     * Get the message envelope.
     *
     * @return \Illuminate\Mail\Mailables\Envelope
     */
    public function envelope()
    {

        $mail = Auth::user()->email;
        return new Envelope(
            subject: $this->subject,
        );

    }

    /**
     * Get the message content definition.
     *
     * @return \Illuminate\Mail\Mailables\Content
     */
    public function content()
    {
        return new Content(
            view: 'email.send',
        );
    }

    /**
     * Get the attachments for the message.
     *
     * @return array
     */
    public function attachments()
    {
        $docs = [];

        foreach ($this->documents as $file) {
            array_push($docs, Attachment::fromStorageDisk('s3', $file->path));
        }
        return $docs;
    }
}
