<?php

namespace App\Mail;

use App\Models\Email;
use App\Models\Rapport;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Auth;
use Illuminate\Mail\Mailables\Attachment;
use Illuminate\Mail\Mailables\Address;


class SendRapportMail extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public $rapport;


    public function __construct(Rapport $rapport)
    {
        $this->rapport = $rapport;
    }

    /**
     * Get the message envelope.
     *
     * @return \Illuminate\Mail\Mailables\Envelope
     */
    public function envelope()
    {
        $mail = Auth::user()->email;
        return new Envelope(
            from: new Address('amea@engimanagment.ma', Auth::user()->name),
            subject: 'Rapport Signer',
        );
    }

    /**
     * Get the message content definition.
     *
     * @return \Illuminate\Mail\Mailables\Content
     */
    public function content()
    {
         $email = Email::where('type_email_id',3)->first();
        return new Content(
            view: 'email.carence'
        );
    }

    /**
     * Get the attachments for the message.
     *
     * @return array
     */
    public function attachments()
    {
        return [
            Attachment::fromStorageDisk('s3', $this->rapport->document->path)
        ];
    }
}
