<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Transaction extends Model
{
    use HasFactory;

    protected $fillable=[
        'to',
        'from',
        'subject',
        'body',
        'dossier_id',
        'user_id'
    ];

    public function document()
    {
        return $this->belongsToMany(Document::class,'document_transaction')->withTimestamps();
    }

    public function dossier()
    {
        return $this->belongsTo(Dossier::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }




}
