<?php

namespace App\Policies;

use App\Models\Call;
use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class CallPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view any models.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function viewAny(User $user)
    {
        if( $user->role_id === 4 || $user->hasPermission('naviguer_enregistrement') || $user->hasRolePermission('naviguer_enregistrement') ){
            return true;
        }
    }

    /**
     * Determine whether the user can view the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Call  $call
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function view(User $user)
    {
         if( $user->role_id === 4 || $user->hasPermission('enregistrer_meet') || $user->hasRolePermission('enregistrer_meet') ){
            return true;
        }
    }

    /**
     * Determine whether the user can create models.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function create(User $user)
    {
        if( $user->role_id === 4 || $user->hasPermission('creer_meet_enligne') || $user->hasRolePermission('creer_meet_enligne') ){
            return true;
        }
    }

    /**
     * Determine whether the user can update the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Call  $call
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function update(User $user)
    {
        if( $user->role_id === 4 || $user->hasPermission('enregistrer_meet') || $user->hasRolePermission('enregistrer_meet') ){
            return true;
        }
    }

    /**
     * Determine whether the user can delete the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Call  $call
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function screen(User $user)
    {
        if( $user->role_id === 4 || $user->hasPermission('capturer_ecran') || $user->hasRolePermission('capturer_ecran') ){
            return true;
        }
    }

    /**
     * Determine whether the user can restore the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Call  $call
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function restore(User $user)
    {
        //
    }

    /**
     * Determine whether the user can permanently delete the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Call  $call
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function forceDelete(User $user)
    {
        //
    }
}
