<?php

namespace App\Policies;

use App\Models\User;
use App\Models\Observation;
use Illuminate\Support\Facades\Auth;
use Illuminate\Auth\Access\HandlesAuthorization;

class ObservationPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view any models.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function viewAny(User $user)
    {
        $user = User::findOrFail(Auth::user()->id);
        if( $user->role_id === 4 || $user->hasPermission('naviguer_observations') || $user->hasRolePermission('naviguer_observations') ){
            return true;
        }
    }

    /**
     * Determine whether the user can view the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Observation  $observation
     * @return \Illuminate\Auth\Access\Response|bool
     */

    public function view(User $user, Observation $observation)
    {
        $user = User::whereId(Auth::user()->id)->first();
        if( $user->role_id === 4  ||  $user->hasPermission('view_observations') || $user->hasRolePermission('view_observations')){
            return true;
        }
    }

    /**
     * Determine whether the user can create models.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function create(User $user)
    {
        $user = User::findOrFail(Auth::user()->id);
        if($user->hasPermission('ajouter_observations') || $user->hasRolePermission('ajouter_observations') || $user->role_id === 4 ){
            return true;
        }
    }

    /**
     * Determine whether the user can update the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Observation  $observation
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function update(User $user, Observation $observation)
    {
        $user = User::findOrFail(Auth::user()->id);
        if( $user->role_id === 4 || $user->hasPermission('modifier_observations') || $user->hasRolePermission('modifier_observations')  ){
            return true;
        }
    }

    /**
     * Determine whether the user can delete the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Observation  $observation
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function delete(User $user, Observation $observation)
    {
        //
    }

    /**
     * Determine whether the user can restore the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Observation  $observation
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function restore(User $user, Observation $observation)
    {
        //
    }

    /**
     * Determine whether the user can permanently delete the model.
     *
     * @param  \App\Models\User  $user
     * @param  \App\Models\Observation  $observation
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function forceDelete(User $user, Observation $observation)
    {
        //
    }
}
