<?php $__env->startSection('style'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="container mt-1">
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <h4 class="header-title text-info mb-3">Dossier <?php echo e($dossier->ref); ?>

                            <?php if($dossier->sinistre_douteux): ?>
                                <span class="badge bg-success">Sinistre Douteux</span>
                            <?php endif; ?>
                        </h4>
                        <div class="table-responsive">
                            <table class="table mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th>Reference</th>
                                        <th>Matricule</th>
                                        <th>Compagnie</th>
                                        <th>Garantie</th>
                                        <th>Date Sinistre</th>
                                        <th>Date Reception</th>
                                        <th>Type de Dossier</th>
                                        <th>Mode</th>
                                        <th>Vehicule</th>

                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <input type="hidden" value="<?php echo e($dossier->id); ?>" id="id">
                                        <td class="text-dark"><?php echo e($dossier->ref ?? null); ?></td>
                                        <td class="text-dark"><?php echo e($dossier->matricule ?? null); ?></td>
                                        <td class="text-dark"><?php echo e($dossier->company->company ?? null); ?></td>
                                        <td class="text-dark"><?php echo e($dossier->guarantee->guarantee ?? null); ?></td>
                                        <td class="text-dark"><?php echo e($dossier->date_sinistre ?? null); ?></td>
                                        <td class="text-dark"><?php echo e($dossier->date_reception ?? null); ?></td>
                                        <td> <span
                                                class="badge badge-primary-lighten"><?php echo e($dossier->typeexpertise->type ?? null); ?></span>
                                        </td>
                                        <td> <span
                                                class="badge badge-success-lighten"><?php echo e($dossier->mode->mode ?? null); ?></span>
                                        </td>
                                        <td><?php echo e($dossier->vehiculemodel->name ?? null); ?>/<?php echo e($dossier->vehiculemodel->brand->brand ?? null); ?>

                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <!-- end table-responsive -->
                    </div>
                </div>
            </div> <!-- end col -->
        </div>
        <div class="card">
            <div class="card-body">
                <h4 class="card-title mb-3">Ajouter Facture : </h4>
                <div class="row mb-5" style="margin-left: 35px;">
                    <form id="myForm" method="POST" enctype="multipart/form-data" action="<?php echo e(route('Dossier.cloturer')); ?>">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="dossier_id" value="<?php echo e($dossier->id); ?>" required>
                        <div class="form-group mb-1">
                            <label for="facture">Telecharger  :</label>

                            <input name="files[]" class="form-control <?php $__errorArgs = ['files'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required
                                onchange="onUpload(this.files)" multiple type="file" accept="image/*,.pdf" />
                            <input type="hidden" name="pdfs" id="pdf" value="">
                            <?php $__errorArgs = ['facture'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="invalid-feedback" role="alert">
                                    <strong><?php echo e($message); ?></strong>
                                </span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="row mt-3">
                            <div class="col-6">
                                <button id="btn" class="btn btn-success" type="submit"> Cloturer Dossier</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdf.js/2.2.228/pdf.min.js"></script>
    <script>
        // $(document).ready(function() {
        //     $('input[type="file"]').imageuploadify();
        // });
        var table = [];

        function onUpload(files) {
            for (let i = 0; i < files.length; i++) {
                const file = files[i];
                if (file.type === 'application/pdf') {
                    const reader = new FileReader();
                    reader.onload = e => {
                        const data = atob(e.target.result.replace(/.*base64,/, ''));
                        console.log(data);
                        renderPDF(data);
                    }
                    reader.readAsDataURL(file);
                }
            }
        }

        async function renderPDF(data) {
            const pdf = await pdfjsLib.getDocument({
                data
            }).promise;
            for (let i = 1; i <= pdf.numPages; i++) {
                const image = document.createElement('img');
                const page = await pdf.getPage(i);
                const viewport = page.getViewport({
                    scale: 2
                });
                const canvas = document.createElement('canvas');
                const canvasContext = canvas.getContext('2d');
                canvas.height = viewport.height;
                canvas.width = viewport.width;
                await page.render({
                    canvasContext,
                    viewport
                }).promise;
                const dataUrl = canvas.toDataURL('image/png');
                image.src = dataUrl;
                image.classList.add('img');
                table.push(dataUrl);
            }
            const btn = document.getElementById('btn');
            btn.addEventListener('click', e => {
                e.preventDefault();
                const input = document.getElementById('pdf');
                input.value = JSON.stringify(table);
                document.getElementById('myForm').submit();
            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\engi.ameamaroc.ma\resources\views/dossiers/facturation.blade.php ENDPATH**/ ?>