<?php $__env->startSection('style'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <!-- tasks panel -->
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="header-title text-info mb-3">Dossier <?php echo e($dossier->ref); ?> <?php if($dossier->sinistre_douteux): ?>
                            <span class="badge bg-success">Sinistre Douteux</span>
                        <?php endif; ?>
                    </h4>
                    <div class="table-responsive">
                        <table class="table mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th>Reference</th>
                                    <th>Matricule</th>
                                    <th>Compagnie</th>
                                    <th>Garantie</th>
                                    <th>Date Sinistre</th>
                                    <th>Date Reception</th>
                                    <th>Type de Dossier</th>
                                    <th>Mode</th>
                                    <th>Vehicule</th>

                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <input type="hidden" value="<?php echo e($dossier->id); ?>" id="id">
                                    <td class="text-dark"><?php echo e($dossier->ref ?? null); ?></td>
                                    <td class="text-dark"><?php echo e($dossier->matricule ?? null); ?></td>
                                    <td class="text-dark"><?php echo e($dossier->company->company ?? null); ?></td>
                                    <td class="text-dark"><?php echo e($dossier->guarantee->guarantee ?? null); ?></td>
                                    <td class="text-dark"><?php echo e($dossier->date_sinistre ?? null); ?></td>
                                    <td class="text-dark"><?php echo e($dossier->date_reception ?? null); ?></td>
                                    <td> <span
                                            class="badge badge-primary-lighten"><?php echo e($dossier->typeexpertise->type ?? null); ?></span>
                                    </td>
                                    <td> <span class="badge badge-success-lighten"><?php echo e($dossier->mode->mode ?? null); ?></span>
                                    </td>
                                    <td><?php echo e($dossier->vehiculemodel->name ?? null); ?>/<?php echo e($dossier->vehiculemodel->brand->brand ?? null); ?>

                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <!-- end table-responsive -->
                </div>
            </div>
        </div> <!-- end col -->


    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <form method="POST" action="<?php echo e(route('Dossier.affecter')); ?>">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="dossier_id" value="<?php echo e($dossier->id); ?>">
                        <div class="col-md-6">
                            <label for="type" class="form-label">Type des photos</label>
                            <select name="user_id" id="user_id"
                                class="form-select <?php $__errorArgs = ['user_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> ">
                                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($user->id); ?>"><?php echo e($user->name ?? null); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            </select>
                            <?php $__errorArgs = ['user_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="invalid-feedback" role="alert">
                                    <strong><?php echo e($message); ?></strong>
                                </span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <button style="float: right" class="btn btn-success mt-3" type="submit"> Affecter</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <?php $__currentLoopData = $dossier->dossierstatus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <span class="badge bg-<?php echo e($status->color ?? null); ?>"><?php echo e($status->status ?? null); ?></span> On <span><?php echo e($status->pivot->created_at ?? null); ?></span>
                    <hr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
    <div class="mt-2">

        <?php $__currentLoopData = $historique; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hist): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="collapse show" id="todayTasks">
            <div class="card mb-0">
                <div class="card-body">
                        <!-- task -->
                        <div class="row justify-content-sm-between">
                            <div class="col-sm-6 mb-2 mb-sm-0">
                                <div class="form-check">
                                    <label class="form-check-label" for="task1">
                                        <?php echo e($hist->name); ?>

                                    </label>
                                </div> <!-- end checkbox -->
                            </div> <!-- end col -->
                            <div class="col-sm-6">
                                <div class="d-flex justify-content-between">
                                    <div id="tooltip-container">

                                        <h6><span class="badge bg-success"><?php echo e($hist->step); ?></span></h6>

                                    </div>
                                    <div>
                                        <ul class="list-inline font-13 text-end">
                                            <li class="list-inline-item">
                                                <i class='uil uil-schedule font-16 me-1'></i> <?php echo e($hist->created_at); ?>

                                            </li>
                                            
                                        </ul>
                                    </div>
                                </div> <!-- end .d-flex-->
                            </div> <!-- end col -->
                        </div>

                    <!-- end task -->
                </div> <!-- end card-body-->
            </div> <!-- end card -->
        </div> <!-- end .collapse-->
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    </div> <!-- end .mt-2-->

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\engi\resources\views/dossiers/historique.blade.php ENDPATH**/ ?>