<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" class="menuitem-active">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link rel="shortcut icon" href="<?php echo e(asset('img/icon.png')); ?>" type="image/png">
    <title><?php echo e(config('app.name', 'AMEA')); ?></title>

    
    <link rel="stylesheet" href="<?php echo e(asset('css/dataTables/dataTables.bootstrap.css')); ?>">
    

    

    <link rel="stylesheet" href="<?php echo e(asset('css/icons.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/app.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('css/search.css')); ?>">
    <script src="<?php echo e(asset('js/fabric/fabric.js')); ?>"></script>
    <script src="<?php echo e(asset('js/fabric/fabric.arrow.js')); ?>"></script>
    <script src="<?php echo e(asset('js/jquery.js')); ?>"></script>
    <script src="<?php echo e(asset('js/fabric/smart-framework.pak.js')); ?>"></script>
    <script src="<?php echo e(asset('js/fabric/fabric-editor.js')); ?>"></script>
    <?php echo \Livewire\Livewire::styles(); ?>

    <?php echo $__env->yieldContent('style'); ?>


</head>

<body data-layout-color="light" data-layout-mode="fluid" data-rightbar-onstart="true" data-leftbar-theme="dark"
    style="">
    <div class="wrapper">
        <?php echo $__env->make('layouts.dashboard.partials.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="content-page">
            <div class="content">
                <?php echo $__env->make('layouts.config_dashboard.partials.topbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="container-fluid mt-1">
                    <?php echo $__env->yieldContent('content'); ?>
                </div>
            </div>

            <footer class="footer">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-md-6">
                            ©Amea - Powered by IS-TECH
                        </div>
                    </div>
                </div>
            </footer>
        </div>
    </div>

    <!-- Scripts -->

    <script src="<?php echo e(asset('js/vendor.js')); ?>"></script>
    <script src="<?php echo e(asset('js/app.js')); ?>" defer></script>
    <script src="<?php echo e(asset('js/dataTables.js/dataTables.js')); ?>"></script>

    


    <script>
        $(document).ready(function() {
            var allTables = $('table.dataTable').DataTable();
            allTables.column(0).search('mySearchTerm').draw();
            $('#myTable').DataTable({
                language: {
                    url: "https://cdn.datatables.net/plug-ins/1.12.1/i18n/fr-FR.json"
                } //,
                // pagingType: "numbers"
            });
            $('#myTable2').DataTable({
                language: {
                    url: "https://cdn.datatables.net/plug-ins/1.12.1/i18n/fr-FR.json"
                } //,
                // pagingType: "numbers"
            });

        });
    </script>
    <?php echo \Livewire\Livewire::scripts(); ?>

    <?php echo $__env->yieldContent('script'); ?>
</body>

</html>
<?php /**PATH C:\laragon\www\AMEA\resources\views/layouts/config_dashboard/app.blade.php ENDPATH**/ ?>