<?php $__env->startSection('content'); ?>
    <div class="container-fluid mt-4">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped" id="">
                                <thead>
                                    <tr>
                                        <th>Id</th>
                                        <th>Libelle</th>
                                        <th>Email</th>
                                        <th>Adresse</th>
                                        <th>Ville</th>
                                        <th>Agreer</th>
                                        <th>Site</th>
                                        <th>Modifier</th>
                                        <th>Supprimer</th>

                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td><?php echo e($garage->id); ?></td>
                                        <td><?php echo e($garage->libelle ?? null); ?></td>
                                        <td><?php echo e($garage->email ?? null); ?></td>
                                        <td><?php echo e($garage->adress ?? null); ?></td>
                                        <td><?php echo e($garage->city->city ?? null); ?></td>
                                        <td>
                                            <?php echo e($garage->tel ?? null); ?>

                                        </td>
                                        <td> <a class="btn btn-sm btn-dark rounded-pill" target="_blank"
                                                href="<?php echo e($garage->url); ?>">Site</a>
                                        </td>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $garage)): ?>
                                            <td> <a class="btn btn-sm btn-primary rounded-pill"
                                                    href="<?php echo e(route('Garage.edit', [$garage->id])); ?>"><i
                                                        class="uil uil-pen fs-5">
                                                    </i></a>
                                            </td>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete', $garage)): ?>
                                            <td>
                                                <form action="<?php echo e(route('Garage.destroy', [$garage->id])); ?>" method="post">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button class="btn btn-sm btn-danger rounded-pill" type="submit"><i
                                                            class="uil uil-trash fs-5"></i></button>
                                                </form>
                                            </td>
                                        <?php endif; ?>

                                    </tr>
                                </tbody>
                                <input type="hidden" value="<?php echo e($garage->lat); ?>" name="lat" id="lat">
                                <input type="hidden" value="<?php echo e($garage->lng); ?>" name="lng" id="lng">

                            </table>
                        </div>
                        <form action="<?php echo e(route('GarageCompany.asign', $garage->id)); ?>" method="POST" class="mb-4">
                            <?php echo csrf_field(); ?>
                            <div class="col-md-12 mr-2 mb-2 mt-1">
                                <h4>Agréer par :</h4>
                                <hr>
                                <?php $__empty_1 = true; $__currentLoopData = $companies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $company): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <?php if($garage->hascompany($company->company)): ?>
                                        <div class="form-check form-check-inline form-checkbox-primary ">
                                            <input type="checkbox" checked class="form-check-input"
                                                value="<?php echo e($company->id); ?>" name="company[]"
                                                id="customSwitch3<?php echo e($company->id); ?>">
                                            <label class="form-check-label fs-4"
                                                for="customSwitch3<?php echo e($company->id); ?>"><?php echo e($company->company); ?></label>
                                        </div>
                                    <?php else: ?>
                                        <div class="form-check form-check-inline form-checkbox-dark ">
                                            <input type="checkbox" class="form-check-input" value="<?php echo e($company->id); ?>"
                                                name="company[]" id="customSwitch3<?php echo e($company->id); ?>">
                                            <label class="form-check-label fs-4"
                                                for="customSwitch3<?php echo e($company->id); ?>"><?php echo e($company->company); ?></label>
                                        </div>
                                    <?php endif; ?>

                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <h3>Tableau Vide</h3>
                                <?php endif; ?>


                            </div>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $garage)): ?>
                                <button style="float:right" type="submit" class="btn btn-outline-primary mb-">Asigner
                                    Companie</button>
                            <?php endif; ?>
                        </form>
                        <form action="<?php echo e(route('GarageService.asign', $garage->id)); ?>" method="POST" class="mb-4">
                            <?php echo csrf_field(); ?>
                            <div class="col-md-12 mr-2 mb-2 mt-1">
                                <h4>Assigner un Service</h4>
                                <hr>
                                <?php $__empty_1 = true; $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <?php if($garage->hasService($service->service)): ?>
                                        <div class="form-check form-check-inline form-checkbox-success ">
                                            <input type="checkbox" checked class="form-check-input"
                                                value="<?php echo e($service->id); ?>" name="service[]"
                                                id="customSwitch3<?php echo e($service->id); ?>">
                                            <label class="form-check-label fs-4"
                                                for="customSwitch3<?php echo e($service->id); ?>"><?php echo e($service->service); ?></label>
                                        </div>
                                    <?php else: ?>
                                        <div class="form-check form-check-inline form-checkbox-warning ">
                                            <input type="checkbox" class="form-check-input" value="<?php echo e($service->id); ?>"
                                                name="service[]" id="customSwitch3<?php echo e($service->id); ?>">
                                            <label class="form-check-label fs-4"
                                                for="customSwitch3<?php echo e($service->id); ?>"><?php echo e($service->service); ?></label>
                                        </div>
                                    <?php endif; ?>

                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <h3>Tableau Vide</h3>
                                <?php endif; ?>


                            </div>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', $garage)): ?>
                                <button style="float:right" type="submit" class="btn btn-outline-success mb-">Asigner
                                    Service</button>
                            <?php endif; ?>
                        </form>
                        <div class="col-md-12 mt-3">
                            <h3>Localisation :</h3>
                            <hr>
                            <div id="map" class="gmaps" style="height: 60vh">
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script src="https://maps.googleapis.com/maps/api/js?key=<?php echo e(env('GOOGLE_MAP_KEY')); ?>&callback=initMap" async defer>
    </script>
    <script>
        let map;

        function initMap() {
            map = new google.maps.Map(document.getElementById("map"), {
                center: {
                    lat: parseFloat($('#lat').val()),
                    lng: parseFloat($('#lng').val())
                },
                zoom: 13,
                scrollwheel: true,
            });
            const uluru = {
                lat: parseFloat($('#lat').val()),
                lng: parseFloat($('#lng').val())
            };
            let marker = new google.maps.Marker({
                position: uluru,
                map: map,
                draggable: true
            });

        }

        window.initMap = initMap;
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\AMEA\resources\views/configuration/Garage/show.blade.php ENDPATH**/ ?>