<?php $__env->startSection('style'); ?>
    <style>
        #description {
            font-family: Roboto;
            font-size: 15px;
            font-weight: 300;
        }

        #infowindow-content .title {
            font-weight: bold;
        }

        #infowindow-content {
            display: none;
        }

        #map #infowindow-content {
            display: inline;
        }

        .pac-card {
            background-color: #fff;
            border: 0;
            border-radius: 2px;
            box-shadow: 0 1px 4px -1px rgba(0, 0, 0, 0.3);
            margin: 10px;
            padding: 0 0.5em;
            font: 400 18px Roboto, Arial, sans-serif;
            overflow: hidden;
            font-family: Roboto;
            padding: 0;
        }

        #pac-container {
            padding-bottom: 12px;
            margin-right: 12px;
        }

        .pac-controls {
            display: inline-block;
            padding: 5px 11px;
        }

        .pac-controls label {
            font-family: Roboto;
            font-size: 13px;
            font-weight: 300;
        }

        #pac-input {
            background-color: #fff;
            font-family: Roboto;
            font-size: 15px;
            font-weight: 300;
            margin-left: 12px;
            padding: 0 11px 0 13px;
            text-overflow: ellipsis;
            width: 400px;
        }

        #pac-input:focus {
            border-color: #4d90fe;
        }

        #title {
            color: #fff;
            background-color: #4d90fe;
            font-size: 25px;
            font-weight: 500;
            padding: 6px 12px;
        }

        #target {
            width: 345px;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row mt-2">
        <div class="col-12">
            <div class="card mb-2">
                <div class="card-body">
                    <div class="col-12">
                        <div class="page-title-box">
                            <h4 class="page-title" style="font-size: 25px">Créer Meeting :</h4>
                        </div>
                    </div>
                    <form action="<?php echo e(route('Meeting.store')); ?>" method="post" autocomplete="off">
                        <?php echo csrf_field(); ?>
                        <div class="row g-2">
                            <div class="col-md-4 mb-3">
                                <label for="user" class="form-label">Agent :</label>
                                <select name="user" id="user_id"
                                    class="form-select select2 <?php $__errorArgs = ['user'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" data-toggle="select2">
                                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(old('user') == $user->id): ?>
                                            <option data-user-id="<?php echo e($user->id); ?>" value="<?php echo e($user->id); ?>">
                                                <?php echo e($user->name); ?></option>
                                        <?php else: ?>
                                            <option data-user-id="<?php echo e($user->id); ?>" value="<?php echo e($user->id); ?>">
                                                <?php echo e($user->name); ?></option>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['user'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($message); ?></strong>
                                    </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                            </div>
                            <input type="hidden" value="<?php echo e($id); ?>" name="dossier_id">
                            <div class="col-md-4 mb-3">
                                <label for="garage_id" class="form-label">Garages</label>
                                <select name="garage_id" id="garage_id"
                                    class="form-select <?php $__errorArgs = ['garage_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> select2"
                                    data-toggle="select2">
                                    <option value="">Selectioner Un Garage</option>
                                    <?php $__currentLoopData = $garages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $garage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option data-garage-id="<?php echo e($garage->id); ?>" value="<?php echo e($garage->id); ?>">
                                            <?php echo e($garage->libelle); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['garage_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($message); ?></strong>
                                    </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="col-md-4 ">
                                <label for="sinister_number" class="form-label">Adresse</label>
                                <input type="text" class="form-control <?php $__errorArgs = ['adress'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    value="<?php echo e(old('adress')); ?>" id="adress" name="adress">
                                <?php $__errorArgs = ['adress'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($message); ?></strong>
                                    </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                        </div>
                        <div class="row g-2">
                            <div class="col-md-4 mb-3">
                                <label for="date" class="form-label">Date :</label>
                                <input type="date" name="date" value="<?php echo e(old('date')); ?>"
                                    class="form-control <?php $__errorArgs = ['date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">

                                <?php $__errorArgs = ['date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($message); ?></strong>
                                    </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="start" class="form-label">Heure :</label>
                                <input type="time" id="start" name="start" value="<?php echo e(old('start')); ?>"
                                    class="form-control <?php $__errorArgs = ['start'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                <?php $__errorArgs = ['start'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback" role="alert">
                                        <strong><?php echo e($message); ?></strong>
                                    </span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="row g-2 mt-2">
                                <div class="col-md-4 mb-3">
                                    <label for="date" class="form-label">Observation :</label>
                                    <textarea class="form-control <?php $__errorArgs = ['observation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> mb-2" name="observation" id=""
                                        cols="30" rows="5"><?php echo e(old('observation')); ?></textarea>
                                    <?php $__errorArgs = ['observation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-md-4">
                                    <label for="type" class="form-label">Type des photos</label>
                                    <select name="type" id="type"
                                        class="form-select <?php $__errorArgs = ['type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> ">
                                        <option value="2">PhotoAvant</option>
                                        <option value="5">PhotoEncours</option>
                                        <option value="10">PhotoApres</option>

                                    </select>
                                    <?php $__errorArgs = ['type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                <div class="col-md-4">
                                    <label for="assure" class="form-label">Vehicule A Expertiser</label>
                                    <select name="assure" id="assure"
                                        class="form-select <?php $__errorArgs = ['assure'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?> ">
                                        <option selected value="1">Assuré</option>
                                        <option value="0">Adversaire</option>

                                    </select>
                                    <?php $__errorArgs = ['assure'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="invalid-feedback" role="alert">
                                            <strong><?php echo e($message); ?></strong>
                                        </span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>

                            </div>

                            <div class="row g-2">

                                <div class="col-md-6">
                                    <h4 class="header-title mb-2 mt-3">Localisation :</h4>
                                    <input id="pac-input" class="controls" type="text" placeholder="Search Box" />
                                    <div id="map" class="gmaps" style="height: 60vh">
                                    </div>
                                </div>
                                <div class="col-6">
                                    <h4 class="header-title mb-2 mt-3">Meetings :</h4>
                                    <div class="card">
                                        <div class="card-body">
                                            <table id="myTable" class="table table-striped">
                                                <thead>
                                                    <tr>
                                                        <th>User</th>
                                                        <th>Account No.</th>
                                                        <th>Date</th>
                                                        <th>Start</th>
                                                        <th>Status</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php $__currentLoopData = $meetings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $meeting): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <tr>
                                                            <td class="table-user"><?php echo e($meeting->user->name); ?></td>
                                                            <td><?php echo e($meeting->dossier->ref); ?></td>
                                                            <td><?php echo e($meeting->date); ?></td>
                                                            <td><?php echo e($meeting->start); ?></td>
                                                            <td><span
                                                                    class="badge bg-primary"><?php echo e($meeting->meetingstatus->status); ?></span>
                                                            </td>
                                                        </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row mt-2">
                                <div class="col-md-6">

                                    <div class="form-group mb-2">
                                        <label for="lng">Longitude</label>
                                        <input type="text" id="lng" name="lng" value="<?php echo e(old('lng')); ?>"
                                            class="form-control <?php $__errorArgs = ['lng'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                        <?php $__errorArgs = ['lng'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="invalid-feedback" role="alert">
                                                <strong><?php echo e($message); ?></strong>
                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group mb-2">
                                        <label for="lat">Lattitude</label>
                                        <input type="text" id="lat" name="lat" value="<?php echo e(old('lat')); ?>"
                                            class="form-control <?php $__errorArgs = ['lat'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                        <?php $__errorArgs = ['lat'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="invalid-feedback" role="alert">
                                                <strong><?php echo e($message); ?></strong>
                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                            </div>


                        </div>
                        <div class="row g-2">
                            <button class="btn btn-primary"> Créer </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        $(document).ready(function() {
            $('#user_id').on('change', function() {
                var user_id = this.value;
                $.ajax({
                    url: '/Meeting/user/' + user_id,
                    type: 'get',
                    success: function(response) {
                        console.log(response);
                        var html = '';
                        $.each(response, function(k, v) {
                            console.log(v);

                            html += "<tr>";
                            html += "<td>" + v.user.name + "</td>";
                            html += "<td>" + v.dossier.ref + "</td>";
                            html += "<td>" + v.date + "</td>";
                            html += "<td>" + v.start + "</td>";
                            html += "<td > <span class='badge bg-info' >" + v
                                .meetingstatus
                                .status + "</span> </td>";
                            html += "</tr>";
                        });
                        html += '';

                        $("#myTable tbody").html(html)
                    }
                });
            });
            $('#garage_id').on('change', function() {
                var garage_id = this.value;
                $.ajax({
                    url: '/Meeting/garage/' + garage_id,
                    type: 'get',
                    success: function(response) {
                        console.log(response[0][0]);
                        document.getElementById('adress').value = response[0][0].adress;
                        document.getElementById('lat').value = response[0][0].lat;
                        document.getElementById('lng').value = response[0][0].lng;


                        const Blocations = response[0];
                        const Clocations = response[1];

                        initMap2(Blocations, Clocations);
                    }
                });
            });

        });
    </script>
    <script
        src="https://maps.googleapis.com/maps/api/js?key=<?php echo e(env('GOOGLE_MAP_KEY')); ?>&callback=initAutocomplete&libraries=places&v=weekly"
        defer></script>
    <script>
        function initAutocomplete() {
            const map = new google.maps.Map(document.getElementById("map"), {
                center: {
                    lat: 33.37562245379103,
                    lng: -7.579586521130635
                },
                zoom: 13,
                mapTypeId: "roadmap",
            });
            const uluru = {
                lat: 33.37562245379103,
                lng: -7.579586521130635
            };
            let marker = new google.maps.Marker({
                position: uluru,
                map: map,
                draggable: true
            });
            google.maps.event.addListener(marker, 'position_changed',
                function() {
                    let lat = marker.position.lat()
                    let lng = marker.position.lng()
                    $('#lat').val(lat)
                    $('#lng').val(lng)
                })

            google.maps.event.addListener(map, 'click',
                function(event) {
                    pos = event.latLng
                    marker.setPosition(pos)
                })
            // Create the search box and link it to the UI element.
            const input = document.getElementById("pac-input");
            const searchBox = new google.maps.places.SearchBox(input);

            map.controls[google.maps.ControlPosition.TOP_LEFT].push(input);
            // Bias the SearchBox results towards current map's viewport.
            map.addListener("bounds_changed", () => {
                searchBox.setBounds(map.getBounds());
            });

            let markers = [];

            // Listen for the event fired when the user selects a prediction and retrieve
            // more details for that place.
            searchBox.addListener("places_changed", () => {
                const places = searchBox.getPlaces();

                if (places.length == 0) {
                    return;
                }

                // Clear out the old markers.
                markers.forEach((marker) => {
                    marker.setMap(null);
                });
                markers = [];

                // For each place, get the icon, name and location.
                const bounds = new google.maps.LatLngBounds();

                places.forEach((place) => {
                    if (!place.geometry || !place.geometry.location) {
                        console.log("Returned place contains no geometry");
                        return;
                    }

                    const icon = {
                        url: place.icon,
                        size: new google.maps.Size(71, 71),
                        origin: new google.maps.Point(0, 0),
                        anchor: new google.maps.Point(17, 34),
                        scaledSize: new google.maps.Size(25, 25),
                    };


                    // Create a marker for each place.
                    markers.push(
                        new google.maps.Marker({
                            map,
                            icon,
                            title: place.name,
                            position: place.geometry.location,
                        })
                    );
                    if (place.geometry.viewport) {
                        // Only geocodes have viewport.
                        bounds.union(place.geometry.viewport);
                    } else {
                        bounds.extend(place.geometry.location);
                    }
                });
                map.fitBounds(bounds);

            });
            setMarkers(map);
            setMarkers2(map);
        }

        window.initAutocomplete = initAutocomplete;
    </script>
    
    <script>
        // function initMap() {
        //     const map = new google.maps.Map(document.getElementById("map"), {
        //         zoom: 10,
        //         center: {
        //             lat: 33.45568426885455,
        //             lng: -7.61802005374749,
        //             zoom: 12
        //         },

        //     });
        //     const uluru = {
        //         lat: 33.45568426885455,
        //         lng: -7.61802005374749,
        //     };
        //     let marker = new google.maps.Marker({
        //         position: uluru,
        //         map: map,
        //         draggable: true
        //     });
        //     google.maps.event.addListener(marker, 'position_changed',
        //         function() {
        //             let lat = marker.position.lat()
        //             let lng = marker.position.lng()
        //             $('#lat').val(lat)
        //             $('#lng').val(lng)
        //         })

        //     google.maps.event.addListener(map, 'click',
        //         function(event) {
        //             pos = event.latLng
        //             marker.setPosition(pos)
        //         })


        //     setMarkers(map);
        //     setMarkers2(map);

        // }
        const locations = <?php print json_encode($markers); ?>;
        const image1 = "<?php print asset('img/car.png'); ?>";

        function setMarkers(map) {

            for (let i = 0; i < locations.length; i++) {
                const location = locations[i];

                new google.maps.Marker({
                    position: {
                        lat: parseFloat(location.lat),
                        lng: parseFloat(location.lng)
                    },
                    label: {
                        color: 'blue',
                        fontWeight: 'bold',
                        text: location.libelle,
                    },
                    icon: {
                        url: image1,
                        size: new google.maps.Size(36, 50),
                        scaledSize: new google.maps.Size(36, 50),
                        anchor: new google.maps.Point(0, 50),
                        labelOrigin: new google.maps.Point(9, 8)

                    },
                    map,
                    title: location.libelle,
                    zIndex: location.lng,
                });

                // console.log(locations[i]);
            }
        }
        const Alocations = <?php print json_encode($agents); ?>;
        console.log(Alocations);
        const image =
            "https://upload.wikimedia.org/wikipedia/commons/thumb/5/59/User-avatar.svg/1200px-User-avatar.svg.png";

        function setMarkers2(map) {

            for (let i = 0; i < Alocations.length; i++) {
                const location = Alocations[i];

                new google.maps.Marker({
                    position: {
                        lat: parseFloat(location.lat),
                        lng: parseFloat(location.lng)
                    },
                    label: {
                        color: 'black',
                        fontWeight: 'bold',
                        text: location.user.name,

                    },
                    icon: {
                        url: image,
                        size: new google.maps.Size(36, 50),
                        scaledSize: new google.maps.Size(36, 50),
                        anchor: new google.maps.Point(0, 50),
                        labelOrigin: new google.maps.Point(9, 8)

                    },
                    map,
                    zIndex: location.lng,
                });

                // console.log(locations[i]);
            }
        }

        function initMap2(Blocations, Clocations) {
            const map = new google.maps.Map(document.getElementById("map"), {
                zoom: 10,
                center: {
                    lat: 33.37562245379103,
                    lng: -7.579586521130635,
                    zoom: 12
                },

            });
            const uluru = {
                lat: 33.37562245379103,
                lng: -7.579586521130635
            };
            // let marker = new google.maps.Marker({
            //     position: uluru,
            //     map: map,
            //     draggable: true
            // });
            // google.maps.event.addListener(marker, 'position_changed',
            //     function() {
            //         let lat = marker.position.lat()
            //         let lng = marker.position.lng()
            //         $('#lat').val(lat)
            //         $('#lng').val(lng)
            //     })

            // google.maps.event.addListener(map, 'click',
            //     function(event) {
            //         pos = event.latLng
            //         marker.setPosition(pos)
            //     })

            setMarkers3(map, Blocations);
            setMarkers4(map, Clocations);

        }

        function setMarkers3(map, Blocations) {

            const image2 = "https://cdn-icons-png.flaticon.com/512/75/75751.png";
            for (let i = 0; i < Blocations.length; i++) {
                const location = Blocations[i];

                new google.maps.Marker({
                    position: {
                        lat: parseFloat(location.lat),
                        lng: parseFloat(location.lng)
                    },
                    label: {
                        color: 'red',
                        fontWeight: 'bold',
                        text: location.libelle,

                    },
                    icon: {
                        url: image2,
                        size: new google.maps.Size(36, 50),
                        scaledSize: new google.maps.Size(36, 50),
                        anchor: new google.maps.Point(0, 50),
                        labelOrigin: new google.maps.Point(9, 8)
                    },
                    map,
                    zIndex: location.lng,
                });

                // console.log(locations[i]);
            }
        }

        function setMarkers4(map, Clocations) {

            for (let i = 0; i < Clocations.length; i++) {
                const location = Clocations[i];
                console.log(location);

                new google.maps.Marker({
                    position: {
                        lat: parseFloat(location.lat),
                        lng: parseFloat(location.lng)
                    },
                    label: {
                        color: 'black',
                        fontWeight: 'bold',
                        text: location.user.name,

                    },
                    icon: {
                        url: image,
                        size: new google.maps.Size(36, 50),
                        scaledSize: new google.maps.Size(36, 50),
                        anchor: new google.maps.Point(0, 50),
                        labelOrigin: new google.maps.Point(9, 8)

                    },
                    map,
                    zIndex: location.lng,
                });

                // console.log(locations[i]);
            }
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\AMEA\resources\views/configuration/meeting/create.blade.php ENDPATH**/ ?>