<?php $__env->startSection('content'); ?>
    <div class="container-fluid mt-4">

        <div class="row mb-3">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <h2>Gestion de Tickets</h2>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create', App\Models\Ticket::class)): ?>
                            <a class="btn btn-info" style="float: right"
                                href="<?php echo e(route('Ticket.create', $ticket->dossier->id)); ?>">Ajouter</a>
                        <?php endif; ?>

                        <a class="btn btn-primary" href="<?php echo e(route('Dossier.show', $ticket->dossier->id)); ?>">Dossier</a>

                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">

                        <div class="table-responsive">
                            <table class="table" id="">
                                <thead>
                                    <tr>
                                        <th>Dossier</th>
                                        <th>Reclameur</th>
                                        <th>Utilisateur</th>
                                        <th>Status</th>
                                        <th>Date Reponse</th>
                                        <th>Date Creation</th>
                                        <th>Modifier</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td><a
                                                href="<?php echo e(route('Dossier.show', $ticket->dossier_id)); ?>"><?php echo e($ticket->dossier->ref); ?></a>
                                        </td>
                                        <td><?php echo e($ticket->creator->name); ?></td>
                                        <td><?php echo e($ticket->user->name); ?></td>
                                        <td>
                                            <span
                                                class="badge <?php switch($ticket->status->id): case (1): ?>           bg-danger           <?php break; ?>       <?php case (2): ?>           bg-primary            <?php break; ?>        <?php default: ?>            bg-success <?php endswitch; ?>"><?php echo e($ticket->status->status); ?></span>
                                        </td>
                                        <td><?php echo e($ticket->answer_at); ?></td>
                                        <td><?php echo e($ticket->created_at); ?></td>

                                        <td>
                                            <?php if($ticket->user_id == Auth::user()->id): ?>
                                                <?php if($ticket->status_rendezvous_id == 2): ?>
                                                    <a class="btn btn-sm btn-info rounded-pill"
                                                        href="<?php echo e(route('Ticket.edit', [$ticket->id])); ?>"><i
                                                            class="uil uil-pen fs-5"></i></a>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        </td>



                                    </tr>

                                </tbody>
                            </table>
                        </div>


                    </div>
                </div>

            </div>
        </div>
        <div class="row">

            <div class="card">
                <div class="card-body">
                    <div class="col-12">
                        <div class="col-6">
                            <label for="">Reclamation</label>
                            <textarea readonly class="form-control" name="" id="" cols="30" rows="10">
                            <?php echo e($ticket->motif); ?>

                        </textarea>
                        </div>
                        <div class="col-6 mt-2">
                            <label for="">Reponse</label>
                            <textarea readonly class="form-control" name="" id="" cols="30" rows="10">
                            <?php echo e($ticket->answer); ?>

                        </textarea>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.config_dashboard.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\engi\resources\views/configuration/ticket/show.blade.php ENDPATH**/ ?>