<?php $__env->startSection('style'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="container mt-1">
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <h4 class="header-title text-info mb-3">Dossier <?php echo e($dossier->ref); ?>

                            <?php if($dossier->sinistre_douteux): ?>
                                <span class="badge bg-success">Sinistre Douteux</span>
                            <?php endif; ?>
                        </h4>
                        <div class="table-responsive">
                            <table class="table mb-0">
                                <thead class="table-light">
                                    <tr>
                                        <th>Reference</th>
                                        <th>Matricule</th>
                                        <th>Compagnie</th>
                                        <th>Garantie</th>
                                        <th>Date Sinistre</th>
                                        <th>Date Reception</th>
                                        <th>Type de Dossier</th>
                                        <th>Mode</th>
                                        <th>Vehicule</th>

                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <input type="hidden" value="<?php echo e($dossier->id); ?>" id="id">
                                        <td class="text-dark"><?php echo e($dossier->ref ?? null); ?></td>
                                        <td class="text-dark"><?php echo e($dossier->matricule ?? null); ?></td>
                                        <td class="text-dark"><?php echo e($dossier->company->company ?? null); ?></td>
                                        <td class="text-dark"><?php echo e($dossier->guarantee->guarantee ?? null); ?></td>
                                        <td class="text-dark"><?php echo e($dossier->date_sinistre ?? null); ?></td>
                                        <td class="text-dark"><?php echo e($dossier->date_reception ?? null); ?></td>
                                        <td> <span
                                                class="badge badge-primary-lighten"><?php echo e($dossier->typeexpertise->type ?? null); ?></span>
                                        </td>
                                        <td> <span
                                                class="badge badge-success-lighten"><?php echo e($dossier->mode->mode ?? null); ?></span>
                                        </td>
                                        <td><?php echo e($dossier->vehiculemodel->name ?? null); ?>/<?php echo e($dossier->vehiculemodel->brand->brand ?? null); ?>

                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <!-- end table-responsive -->
                    </div>
                </div>
            </div> <!-- end col -->
        </div>
        <div class="card">
            <div class="card-body">
                <h4 class="card-title mb-5">Selectionner les Type de Documents : </h4>
                <div class="row mb-5" style="margin-left: 35px;">
                    <form method="POST" action="<?php echo e(route('signedurl.store')); ?>">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="dossier_id" value="<?php echo e($dossier->id); ?>">
                        <?php $__currentLoopData = $typedocuments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            
                            

                                <div class="form-check form-check-inline form-checkbox-warning col-2">
                                    <input type="checkbox" class="form-check-input mb-2" value="<?php echo e($type->id); ?>"
                                        name="<?php echo e($type->type); ?>" id="customSwitch3<?php echo e($type->id); ?>">
                                    <label class="form-check-label fs-4"
                                        for="customSwitch3<?php echo e($type->id); ?>"><?php echo e($type->type); ?></label>
                                </div>

                            
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <div class="row mt-3">
                            <div class="col-6">
                                <button class="btn btn-success" type="submit"> Génerer Lien Externe</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\AMEA\resources\views/dossiers/signedurl.blade.php ENDPATH**/ ?>