<?php $__env->startSection('style'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('css/viewer.css')); ?>">
    <style>
        .container {
            position: relative;
            width: 33%;
        }

        .image {
            opacity: 1;
            display: block;
            width: 100%;
            height: auto;
            transition: .5s ease;
            backface-visibility: hidden;
        }

        .middle {
            transition: .5s ease;
            opacity: 0;
            position: absolute;
            top: 28%;
            left: 82%;
            transform: translate(-50%, -50%);
            -ms-transform: translate(-50%, -50%);
            text-align: center;
        }

        .container:hover .image {
            opacity: 0.8;
        }

        .container:hover .middle {
            opacity: 1;
        }

        .text {
            color: rgb(0, 0, 0);
            font-size: 15px;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row mt-2">
        <div class="page-title-box">
            <div class="page-title-left mb-">
                <a href="<?php echo e(route('Dossier.show', $devis->dossier_id)); ?>" class="mt-2 btn btn-outline-dark">Dossier</a>
            </div>
            <div class="page-title-right mb-1">
                <?php if(intval($devis->devis) == 1): ?>
                    <span class="badge bg-dark"><?php echo e($devis->devis); ?>er Devis </span>
                <?php elseif(intval($devis->devis) > 1): ?>
                    <span class="badge bg-dark"><?php echo e($devis->devis); ?>éme Devis </span>
                <?php endif; ?>
            </div>
        </div>
        <div class="page-title-box">
            <?php if($devis->devisstatus): ?>
                <?php $__currentLoopData = $devis->devisstatus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <span class="badge bg-<?php echo e($item->color); ?>"><?php echo e($item->status); ?></span>
                    <input type="hidden" style="display:none"
                        value="<?php echo e($user = App\Models\User::whereId($item->user_id)->first()); ?>">
                    <span class="badge bg-black"><?php echo e($user->name ?? null); ?></span>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
        </div>
        <div class="col-12">
            <form action="<?php echo e(route('Devis.status', $devis->id)); ?>" class="" method="post">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', App\Models\Devis::class)): ?>
                    <?php if($devis->devis_status_id == 2): ?>
                        <?php if(Auth::user()->role_id == 1 || Auth::user()->role_id == 4): ?>
                            <div class="card mb-2">
                                <div class="card-body">
                                    <div class="col-12">
                                        <div class="btn-group" role="group" aria-label="Basic example">
                                            <button name="action" value="envoyer" class="btn btn-primary ml-3">
                                                Envoyer
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    <?php endif; ?>

                    <?php if($devis->devis_status_id == 5): ?>
                        <?php if(Auth::user()->role_id == 4 || Auth::user()->role_id == 2): ?>
                            <div class="card mb-2">
                                <div class="card-body">
                                    <div class="col-12">
                                        <div class="btn-group" role="group" aria-label="Basic example">
                                            <button style="" name="action" value="accord" class="btn btn-success ml-3">
                                                Accord
                                            </button>
                                            <button style="" name="action" value="rejeter" class="btn btn-danger ml-3">
                                                Rejeter
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    <?php elseif($devis->devis_status_id == 4): ?>
                        <?php if(Auth::user()->role_id == 4 || Auth::user()->role_id == 2): ?>
                            <div class="card mb-2">
                                <div class="card-body">
                                    <div class="col-12">
                                        <div class="btn-group" role="group" aria-label="Basic example">
                                            <button style="" name="action" value="accord" class="btn btn-success ml-3">
                                                Accord
                                            </button>
                                            <button style="" name="action" value="rejeter" class="btn btn-danger ml-3">
                                                Rejeter
                                            </button>
                                            <button style="" name="action" value="avis" class="btn btn-warning ml-3">
                                                Demander Avis
                                            </button>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    <?php elseif($devis->devis_status_id == 3): ?>
                        <?php if(Auth::user()->role_id == 4): ?>
                            <div class="card mb-2">
                                <div class="card-body">
                                    <div class="col-12">
                                        <div class="btn-group" role="group" aria-label="Basic example">
                                            <button style="" name="action" value="accord" class="btn btn-success ml-3">
                                                Accord
                                            </button>
                                            <button style="" name="action" value="retraiter"
                                                class="btn btn-warning ml-3">
                                                Retraiter
                                            </button>
                                            <button style="" name="action" value="rejeter" class="btn btn-danger ml-3">
                                                Rejeter
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php else: ?>
                            <div class="card mb-2">
                                <div class="card-body">
                                    <div class="col-12">
                                        <span class="badge-bg-<?php echo e($devis->status->color); ?>"><?php echo e($devis->status->status); ?></span>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    <?php endif; ?>
                <?php endif; ?>
        </div>
    </div>

    <div class="row mt-2">
        <div class="col-12">
            <div class="card mb-2">
                <div class="card-body">
                    <div class="page-title-box">
                        <h4 class="page-title" style="font-size: 22px">
                            Devis
                            <span class="badge bg-<?php echo e($devis->status->color); ?>"><?php echo e($devis->status->status); ?></span>
                        </h4>
                        <?php if($devis->dossier->sinistre_douteux): ?>
                            <span class="badge bg-danger">Sinistre Douteux</span>
                        <?php endif; ?>
                    </div>
                    <div class="table-responsive">
                        <div class="col-12">

                            <table class="table" id="">
                                <thead>
                                    <tr>
                                        <th>Ref</th>
                                        <th>Date Reception</th>
                                        <th>Montant Devis</th>
                                        <th>Montant Accord</th>
                                        <th>Montant Facture</th>
                                        <th>Montant Rapport</th>
                                        <th>Modifier</th>
                                    </tr>
                                </thead>

                                <tbody>

                                    <tr>
                                        <td>
                                            <?php echo e($devis->ref ?? null); ?>

                                        </td>
                                        <td>
                                            <?php echo e($devis->date_reception ?? null); ?>

                                        </td>
                                        <td class="col-3">
                                            <input type="text" name="montant_devis" readonly
                                                value="<?php echo e($montant->devis->montant_devis ?? null); ?>" name="montant_devis"
                                                class="form-control  <?php $__errorArgs = ['montant_devis'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                            <?php $__errorArgs = ['montant_devis'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="invalid-feedback" role="alert">
                                                    <strong><?php echo e($message); ?></strong>
                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </td>
                                        <td class="col-3">
                                            <input type="text" name="montant_accord" readonly
                                                value="<?php echo e($montant->montant_accord ?? null); ?>" name="montant_accord"
                                                class="form-control <?php $__errorArgs = ['montant_accord'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                            <?php $__errorArgs = ['montant_accord'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="invalid-feedback" role="alert">
                                                    <strong><?php echo e($message); ?></strong>
                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </td>
                                        <td class="col-3">
                                            <input type="text"readonly
                                                value="<?php echo e($montant->facture->montant_facture ?? null); ?>"
                                                name="montant_facture"
                                                class="form-control <?php $__errorArgs = ['montant_facture'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                            <?php $__errorArgs = ['montant_facture'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="invalid-feedback" role="alert">
                                                    <strong><?php echo e($message); ?></strong>
                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </td>
                                        <td class="col-3">
                                            <input type="text" value="<?php echo e($montant->montant_rapport ?? null); ?>"
                                                name="montant_rapport" readonly
                                                class="form-control <?php $__errorArgs = ['montant_rapport'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                            <?php $__errorArgs = ['montant_rapport'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="invalid-feedback" role="alert">
                                                    <strong><?php echo e($message); ?></strong>
                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </td>
                                        <td class="col-3">
                                            <a href="<?php echo e(route('Montant.edit', $montant->id)); ?>"
                                                class="btn btn-sm btn-outline-primary" href="">
                                                <i class="uil uil-pen fs-5"></i>
                                            </a>
                                            </button>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>



                </div>
            </div>
        </div>

    </div>
    <div style="" class="row mt-1">
        <div class="col-6">
            <div class="card mb-2">
                <div class="card-body">
                    <h4 class="page-title text-dark" style="font-size: 22px">
                        Devis
                    </h4>
                    <hr>
                    <?php if($docdevis): ?>
                        <div class="row" id="galley">

                            <?php $__currentLoopData = $docdevis; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $doc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-3 container">
                                    <img src="<?php echo e(Storage::disk('s3')->temporaryUrl($doc->path, now()->addMinutes(30)) ?? null); ?>"
                                        data-original="<?php echo e(Storage::disk('s3')->temporaryUrl($doc->path, now()->addMinutes(30))); ?>"alt="img"
                                        class="img-fluid m-1" srcset="">
                                    <div class="middle">
                                        <a href="<?php echo e(route('Document.edit', $doc->id)); ?>"
                                            class="text append icon dripicons-document-edit"></a>
                                    </div>
                                    <?php if($doc->edited): ?>
                                        <span class="badge bg-danger m-1" style="display: block;">Devis</span>
                                    <?php else: ?>
                                        <span class="badge bg-primary m-1" style="display: block;">Devis</span>
                                    <?php endif; ?>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <div class="col-6 mt-4">
            <div class="">
                <ul class="nav nav-tabs nav-stacked ">
                    <?php $__currentLoopData = $typedocuments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="nav-item ">
                            <button type="button" data-filter="<?php echo e($type->type); ?>" class="link nav-link"
                                style=" cursor: pointer;" value="<?php echo e($type->id); ?>"><?php echo e($type->type); ?> </button>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </ul>
                <div class="card-body m-1" id="galley" style="height: 300px; overflow-y:auto">
                    <input type="hidden" id="id" name="dossier_id" value="<?php echo e($dossier->id); ?>">
                    <?php if($dossier->document): ?>
                        <ul style=" list-style-type: none;" id="row" class="row">
                            <?php $__currentLoopData = $dossier->document; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $doc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($doc->type_document_id != 10): ?>
                                    <li class="box container col-3 media <?php echo e($doc->typedocument->type ?? null); ?> ">
                                        <img data-original="<?php echo e(Storage::disk('s3')->temporaryUrl($doc->path, now()->addMinutes(30))); ?>"
                                            src="<?php echo e(Storage::disk('s3')->temporaryUrl($doc->path, now()->addMinutes(30))); ?>"
                                            alt="img" class="img-fluid m-1" srcset="">
                                        <div class="middle">
                                            <a href="<?php echo e(route('Document.edit', $doc->id)); ?>"
                                                class="text append icon dripicons-document-edit"></a>
                                        </div>
                                        <?php if($doc->edited): ?>
                                            <span class="badge bg-danger m-1"
                                                style="display: block;"><?php echo e($doc->typedocument->type ?? null); ?></span>
                                        <?php else: ?>
                                            <span class="badge bg-primary m-1"
                                                style="display: block;"><?php echo e($doc->typedocument->type ?? null); ?></span>
                                        <?php endif; ?>

                                    </li>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    <?php endif; ?>
                </div>


            </div>
        </div>

    </div>

    <div class="row">
        <div class="col-md-4 mb-3">
            <label for="date" class="form-label">Observation :</label>
            <textarea class="form-control mb-2  <?php $__errorArgs = ['observation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="observation" id=""
                cols="31" rows="5"></textarea>
            <?php $__errorArgs = ['observation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <span class="invalid-feedback" role="alert">
                    <strong><?php echo e($message); ?></strong>
                </span>
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

        </div>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('update', App\Models\Devis::class)): ?>
            <div class="col-8">
                <?php if($observations): ?>
                    <div class="accordion" id="">
                        <?php $__currentLoopData = $observations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $observation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="headingOne" style="margin-top: unset;">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#collapse-<?php echo e($key); ?>" aria-expanded="false"
                                        aria-controls="">
                                        <?php echo e($observation->user->name); ?>

                                    </button>
                                </h2>
                                <div id="collapse-<?php echo e($key); ?>" class="accordion-collapse collapse "
                                    aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                                    <div class="accordion-body">
                                        <strong class="text-dark"><?php echo e($observation->observation); ?>.</strong>
                                        <span><?php echo e($observation->created_at); ?></span>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php endif; ?>
            </div>
        <?php endif; ?>
        </form>

    </div>
    <?php if($devis->devis_status_id != 2 && $devis->devis_status_id != 7 && $devis->devis_status_id != 6): ?>
        <button type="button" class="btn btn-info mb-2" data-bs-toggle="modal" data-bs-target="#signup-modal">
            Créer Une Piece
        </button>
        <?php echo $__env->make('devis.modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>

    <input type="hidden" value="<?php echo e($devis->id); ?>" name="devis_id">
    <div class="row">
        <div class="col-12">
            <div class="card mb-2">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table" id="myTable">
                            <thead>
                                <tr>
                                    <th>Piéce</th>
                                    <th>Type de Piéce</th>
                                    <th>Modele</th>
                                    <th>Prix Unitaire</th>
                                    <th>Qte</th>
                                    <th>Vetuste %</th>
                                    <th>Remise %</th>
                                    <th>Select</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $devis->piece; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $piece): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($piece->piece); ?></td>
                                        <td><?php echo e($piece->typereparation->type); ?></td>
                                        <td><?php echo e($piece->model_year); ?></td>
                                        <td><?php echo e($piece->prix_unitaire); ?>DH</td>
                                        <td class="col-2">
                                            <input class="form-control" name="qte" id="id<?php echo e($piece->id); ?>"
                                                <?php if($devis->devis_status_id == 2 || $devis->devis_status_id == 7 || $devis->devis_status_id == 6): ?>
                                                readonly
                                                <?php endif; ?> type="number"
                                                value="<?php echo e($piece->pivot->qte); ?>" min="1">
                                        </td>
                                        <td>

                                            <input type="number" id="v<?php echo e($piece->id); ?>" min="0"
                                            <?php if($devis->devis_status_id == 2 || $devis->devis_status_id == 7 || $devis->devis_status_id == 6): ?>
                                            readonly
                                            <?php endif; ?>
                                                name="vetuste" class="form-control"
                                                value="<?php echo e($piece->pivot->vetuste); ?>">
                                        </td>
                                        <td>
                                            <input type="number" id="r<?php echo e($piece->id); ?>" name="remise"
                                            <?php if($devis->devis_status_id == 2 || $devis->devis_status_id == 7 || $devis->devis_status_id == 6): ?>
                                            readonly
                                            <?php endif; ?>
                                                class="form-control" value="<?php echo e($piece->pivot->remise); ?>">
                                        </td>
                                        <td>
                                            <input class="form-check-input check" type="checkbox" name="piece" checked
                                            <?php if($devis->devis_status_id == 2 || $devis->devis_status_id == 7 || $devis->devis_status_id == 6): ?>
                                            readonly
                                            disabled="disabled"
                                            <?php endif; ?>
                                                value="<?php echo e($piece->id); ?>">
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php if($devis->devis_status_id != 2 && $devis->devis_status_id != 7 && $devis->devis_status_id != 6): ?>
                                    <?php $__currentLoopData = $pieces; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $piece): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($piece->piece); ?></td>
                                            <td><?php echo e($piece->typereparation->type); ?></td>
                                            <td><?php echo e($piece->model_year); ?></td>
                                            <td><?php echo e($piece->prix_unitaire); ?>DH</td>
                                            <td class="col-2">
                                                <input class="form-control" name="qte" id="id<?php echo e($piece->id); ?>"
                                                    type="number" value="1" min="1">
                                            </td>
                                            <td>

                                                <input type="number" id="v<?php echo e($piece->id); ?>" min="0"
                                                    name="vetuste" class="form-control" value="0">
                                            </td>
                                            <td>
                                                <input type="number" id="r<?php echo e($piece->id); ?>" name="remise"
                                                    class="form-control" value="0">
                                            </td>
                                            <td>
                                                <input class="form-check-input check" type="checkbox" name="piece"
                                                    value="<?php echo e($piece->id); ?>">
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </tbody>

                        </table>
                        <?php if($dossier->dossier_status_id != 3): ?>
                            <?php if($devis->devis_status_id != 2 && $devis->devis_status_id != 7 && $devis->devis_status_id != 6): ?>
                                <a class="btn btn-success save mt-3"> Enregistrer Piece</a>

                            <?php endif; ?>
                        <?php endif; ?>
                        <button style="float: right" type="button" class=" mt-3 btn btn-primary" data-bs-toggle="modal" data-bs-target="#full-width-modal">Taux Devis</button>
                        <?php echo $__env->make('devis.taux', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


                    </div>
                </div>
            </div>
        </div>
    </div>


<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script src="<?php echo e(asset('js/viewer.js')); ?>"></script>

    <script>
        window.addEventListener('DOMContentLoaded', function() {
            var galley = document.getElementById('galley');
            var maxOffsetPercentage = 0.9;
            var viewer = new Viewer(galley, {
                url: 'data-original',
                backdrop: 'static',
                move: function(event) {
                    var viewerData = viewer.viewerData;
                    var imageData = viewer.imageData;
                    var maxOffsetHorizontal = viewerData.width * maxOffsetPercentage;
                    var maxOffsetVertical = viewerData.height * maxOffsetPercentage;
                    var detail = event.detail;
                    var left = detail.x;
                    var top = detail.y;
                    var right = viewerData.width - (left + imageData.width);
                    var bottom = viewerData.height - (top + imageData.height);
                    if (
                        // Move left
                        (detail.x < detail.oldX && right > 0 && right > maxOffsetHorizontal)
                        // Move right
                        ||
                        (detail.x > detail.oldX && left > 0 && left > maxOffsetHorizontal)
                        // Move up
                        ||
                        (detail.y < detail.oldY && bottom > 0 && bottom > maxOffsetVertical)
                        // Move down
                        ||
                        (detail.y > detail.oldY && top > 0 && top > maxOffsetVertical)
                    ) {
                        event.preventDefault();
                    }
                },
                zoomed: function(event) {
                    var detail = event.detail;
                    // Zoom out
                    if (detail.ratio < detail.oldRatio) {
                        var viewerData = viewer.viewerData;
                        var imageData = viewer.imageData;
                        var maxOffsetHorizontal = viewerData.width * maxOffsetPercentage;
                        var maxOffsetVertical = viewerData.height * maxOffsetPercentage;
                        var left = imageData.x;
                        var top = imageData.y;
                        var right = viewerData.width - (left + imageData.width);
                        var bottom = viewerData.height - (top + imageData.height);
                        var x = 0;
                        var y = 0;
                        if (right > 0 && right > maxOffsetHorizontal) {
                            x = maxOffsetHorizontal - right;
                        }
                        if (left > 0 && left > maxOffsetHorizontal) {
                            x = maxOffsetHorizontal - left;
                        }

                        if (bottom > 0 && bottom > maxOffsetVertical) {
                            y = bottom - maxOffsetVertical;
                        }

                        if (top > 0 && top > maxOffsetVertical) {
                            y = top - maxOffsetVertical;
                        }

                        // Move the image into view if it is invisible
                        if (x !== 0 || y !== 0) {
                            viewer.move(x, y);
                        }
                    }
                },
            });
        });
        var links = document.getElementsByClassName('link');
        for (var i = 0; i < links.length; i++) {

            links[i].addEventListener('click', function() {
                console.log('clcl');
                var galley = document.getElementById('galley');
                var maxOffsetPercentage = 0.9;
                var viewer = new Viewer(galley, {
                    url: 'data-original',
                    backdrop: 'static',
                    move: function(event) {
                        var viewerData = viewer.viewerData;
                        var imageData = viewer.imageData;
                        var maxOffsetHorizontal = viewerData.width * maxOffsetPercentage;
                        var maxOffsetVertical = viewerData.height * maxOffsetPercentage;
                        var detail = event.detail;
                        var left = detail.x;
                        var top = detail.y;
                        var right = viewerData.width - (left + imageData.width);
                        var bottom = viewerData.height - (top + imageData.height);
                        if (
                            // Move left
                            (detail.x < detail.oldX && right > 0 && right > maxOffsetHorizontal)
                            // Move right
                            ||
                            (detail.x > detail.oldX && left > 0 && left > maxOffsetHorizontal)
                            // Move up
                            ||
                            (detail.y < detail.oldY && bottom > 0 && bottom > maxOffsetVertical)
                            // Move down
                            ||
                            (detail.y > detail.oldY && top > 0 && top > maxOffsetVertical)
                        ) {
                            event.preventDefault();
                        }
                    },
                    zoomed: function(event) {
                        var detail = event.detail;
                        // Zoom out
                        if (detail.ratio < detail.oldRatio) {
                            var viewerData = viewer.viewerData;
                            var imageData = viewer.imageData;
                            var maxOffsetHorizontal = viewerData.width * maxOffsetPercentage;
                            var maxOffsetVertical = viewerData.height * maxOffsetPercentage;
                            var left = imageData.x;
                            var top = imageData.y;
                            var right = viewerData.width - (left + imageData.width);
                            var bottom = viewerData.height - (top + imageData.height);
                            var x = 0;
                            var y = 0;
                            if (right > 0 && right > maxOffsetHorizontal) {
                                x = maxOffsetHorizontal - right;
                            }
                            if (left > 0 && left > maxOffsetHorizontal) {
                                x = maxOffsetHorizontal - left;
                            }

                            if (bottom > 0 && bottom > maxOffsetVertical) {
                                y = bottom - maxOffsetVertical;
                            }

                            if (top > 0 && top > maxOffsetVertical) {
                                y = top - maxOffsetVertical;
                            }

                            // Move the image into view if it is invisible
                            if (x !== 0 || y !== 0) {
                                viewer.move(x, y);
                            }
                        }
                    },
                });
            });
        }
    </script>
    <script>
        //attach
        $(document).ready(function() {

            $(".save").click(function(event) {

                event.preventDefault();

                var checkedRowIndices = [];
                var checkedRowIndices1 = [];
                var checkedRowIndices2 = [];
                var qtes = [];
                var vetustes = [];
                var remises = [];


                $('input[type=checkbox]').each(function(value) {

                    if ($(this)[0].checked) {

                        checkedRowIndices.push($(this)[0].value);
                        qtes.push($("#id" + $(this)[0].value).val());
                        vetustes.push($("#v" + $(this)[0].value).val());
                        remises.push($("#r" + $(this)[0].value).val());

                    }


                });

                console.log(qtes);
                console.log(vetustes);
                console.log(remises);

                // console.log(checkedRowIndices);

                let qte = qtes;
                let piece = checkedRowIndices;
                let devis_id = $("input[name=devis_id]").val();
                let vetuste = vetustes;
                let remise = remises;
                let _token = $('meta[name="csrf-token"]').attr('content');

                // console.log(piece);
                // console.log(rapport_id);
                // console.log(qte);

                $.ajax({
                    url: "/Devis/attach",
                    type: "POST",
                    data: {
                        piece: piece,
                        devis_id: devis_id,
                        qte: qte,
                        vetuste: vetustes,
                        remise: remises,
                        _token: _token
                    },
                    success: function(response) {
                        // console.log(response);
                        if (response) {
                            $('.success').text(response.success);
                            alert('enregistrer');
                        }
                    },
                });
            });





        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dashboard.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\AMEA\resources\views/devis/show.blade.php ENDPATH**/ ?>