@extends('layouts.config_dashboard.app')

@section('content')

<div class="container-fluid mt-4">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <form action="{{ route('Device.update',$device->id) }}" method="post">
                        @csrf
                        @method('PUT')
                        <div class=" form-group mb-3">
                            <label for="mac_address" class="form-label">Mac Address</label>
                            <input type="text" 
                             id="mac_address" name="mac_address" value="{{ $device->mac_address }}"
                                class="form-control @error('mac_address') is-invalid  @enderror">
                            @error('mac_address')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        <div class="form-group  mb-2">
                            <label for="user_id">Nom Agent :</label>
                           <select class="form-select @error('user_id') is-invalid @enderror" name="user_id" id="">
                            <option value="{{ $device->user->id ?? null }}">{{ $device->user->name ?? 'Selectionner Un Agent' }}</option>
                            @foreach ($users as $agent)
                            <option value="{{ $agent->id }}">{{ $agent->name }}</option>
                            @endforeach
                           </select>
                            @error('user_id')
                                <span class="invalid-feedback" role="alert">
                                    <strong>{{ $message }}</strong>
                                </span>
                            @enderror
                        </div>
                        <div class="mr-3">
                            <button class="btn btn-success" type="submit">Modifier</button>
                        </div>
                    </form>
                </div>
            </div>

        </div>
    </div>
</div>

@endsection
