@extends('layouts.config_dashboard.app')

@section('content')
    <div class="container-fluid ">
        <div class="row">
            <div class="col-12">
                <div class="page-title-box">
                    <h4 class="page-title" style="font-size: 25px">Liste des IP</h4>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row mb-3">
                            <div class="d-flex ">
                                <div class="col-md-6">
                                    <a style="float: left" href="{{ route('IP.create') }}"
                                        class="btn btn-success rounded-pill"> Créer</a>
                                </div>
                                {{-- <div class="col-md-6">
                                    <a style="float: right" href=""
                                        class="btn btn-warning rounded-pill"> Restorer </a>
                                </div> --}}
                            </div>
                        </div>
                        <div class="table-responsive">
                            <table class="table" id="myTable">
                                <thead>
                                    <tr>
                                        <th>id</th>
                                        <th>IP Address </th>
                                        <th>Description </th>
                                        <th>Modifier</th>
                                        <th>Supprimer</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse ($ips as $ip)
                                        <tr>
                                            <td>{{ $ip->id }}</td>
                                            <td>{{ $ip->ip }}</td>
                                            {{-- <td>@if ($ip->activated)
                                                <span class="badge badge-success">Activé</span>
                                                @else
                                                <span class="badge badge-danger">Désactivée</span>
                                            @endif</td> --}}
                                            <td>{{ $ip->description }}</td>


                                            <td>
                                                <a class="btn btn-primary rounded-pill" href="{{ route('IP.edit',$ip->id) }}"> <i class="uil uil-pen fs-5"></i></a>
                                            </td>
                                            <td>
                                                <form action="{{ route('IP.destroy', $ip->id) }}"
                                                    method="post">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button class="btn btn-sm btn-danger rounded-pill" type="submit">
                                                        <i class="uil uil-trash fs-5"></i>
                                                    </button>
                                                </form>
                                            </td>
                                        </tr>
                                    @empty
                                        <h3>Tableau Vide</h3>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
@endsection
