@extends('layouts.dashboard.app')

@section('content')
    <div class="row mt-2">
        <div class="col-12">
            <div class="card mb-2">
                <div class="card-body">
                    <div class="col-12">
                        <div class="page-title-box">
                            <h4 class="page-title" style="font-size: 25px">Modifier Mission :</h4>
                        </div>
                    </div>
                    <form action="{{ route('Meeting.update',$meeting->id) }}" method="post" autocomplete="off">
                        @method('PUT')
                        @csrf
                        <div class="row g-2">
                            <div class="col-md-4 mb-3">
                                <label for="user" class="form-label">Agent :</label>
                                <select name="user" id="user_id"
                                    class="form-select select2 @error('user') is-invalid @enderror" data-toggle="select2">
                                    <option selected value="{{ $meeting->user->id }}">{{ $meeting->user->name }}</option>
                                    @foreach ($users as $user)
                                        <option data-user-id="{{ $user->id }}" value="{{ $user->id }}">
                                            {{ $user->name }}</option>
                                    @endforeach
                                </select>
                                @error('user')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror

                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="garage_id" class="form-label">Garages</label>
                                <select name="garage_id" id="garage_id"
                                    class="form-select @error('garage_id') is-invalid @enderror select2"
                                    data-toggle="select2">

                                    <option selected value="{{ $meeting->garage->id ?? null}}">{{ $meeting->garage->libelle ?? 'Selectionner Un Garage' }}</option>
                                    @foreach ($garages as $garage)
                                        <option data-garage-id="{{ $garage->id }}" value="{{ $garage->id }}">
                                            {{ $garage->libelle }}</option>
                                    @endforeach
                                </select>
                                @error('garage_id')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>

                            <div class="col-md-4 ">
                                <label for="sinister_number" class="form-label">Adresse</label>
                                <input type="text" class="form-control @error('adress') is-invalid @enderror"
                                  value="{{ $meeting->adress }}"  id="adress" name="adress">
                                @error('adress')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>

                        </div>
                        <div class="row g-2">
                            <div class="col-md-4 mb-3">
                                <label for="date" class="form-label">Date :</label>
                                <input type="date"  name="date" value="{{ $meeting->date}}"
                                    class="form-control @error('date') is-invalid @enderror">

                                @error('date')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="start" class="form-label">Heure :</label>
                                <input type="time" id="start" name="start" value="{{ $meeting->start }}"
                                    class="form-control @error('start') is-invalid @enderror">
                                @error('start')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="row g-2 mt-2">
                                <div class="col-md-4 mb-3">
                                    <label for="date" class="form-label">Observation :</label>
                                    <textarea class="form-control @error('observation') is-invalid @enderror mb-2" name="observation" id="" cols="30" rows="5"></textarea>
                                    @error('observation')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="col-md-4">
                                    <label for="type" class="form-label">Type des photos</label>
                                    <select name="type" id="type"
                                        class="form-select @error('type') is-invalid @enderror ">*
                                        @if ($meeting->type === 2)
                                        <option selected value="2">PhotoAvant</option>
                                        <option value="5">PhotoEncours</option>
                                        <option value="10">PhotoApres</option>

                                        @elseif ($meeting->type === 5)
                                        <option selected value="2">PhotoAvant</option>
                                        <option value="5">PhotoEncours</option>
                                        <option value="10">PhotoApres</option>

                                        @elseif ($meeting->type === 10)
                                        <option selected value="2">PhotoAvant</option>
                                        <option value="5">PhotoEncours</option>
                                        <option value="10">PhotoApres</option>
                                        @else
                                        <option  value="2">PhotoAvant</option>
                                        <option value="5">PhotoEncours</option>
                                        <option value="10">PhotoApres</option>
                                        @endif()

                                    </select>
                                    @error('type')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="col-md-4">
                                    <label for="assure" class="form-label">Vehicule A Expertiser</label>
                                    <select name="assure" id="assure"
                                        class="form-select @error('assure') is-invalid @enderror ">
                                        @if ($meeting->assure)
                                        <option selected value="1">Assuré</option>
                                        <option value="0">Adversaire</option>
                                        @else
                                        <option  value="1">Assuré</option>
                                        <option selected value="0">Adversaire</option>
                                        @endif


                                    </select>
                                    @error('assure')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>

                            </div>

                            <div class="row g-2">

                                <div class="col-md-6">
                                    <h4 class="header-title mb-2 mt-3">Localisation :</h4>
                                    <div id="map" class="gmaps" style="height: 60vh">
                                    </div>
                                </div>
                                <div class="col-6">
                                    <h4 class="header-title mb-2 mt-3">Meetings :</h4>
                                    <div class="card">
                                        <div class="card-body">
                                            <table id="myTable" class="table table-striped">
                                                <thead>
                                                    <tr>
                                                        <th>User</th>
                                                        <th>Account No.</th>
                                                        <th>Date</th>
                                                        <th>Start</th>
                                                        <th>Status</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach ($meetings as $meeting)
                                                        <tr>
                                                            <td class="table-user">{{ $meeting->user->name }}</td>
                                                            <td>{{ $meeting->dossier->ref }}</td>
                                                            <td>{{ $meeting->date }}</td>
                                                            <td>{{ $meeting->start }}</td>
                                                            <td><span
                                                                    class="badge bg-primary">{{ $meeting->meetingstatus->status }}</span>
                                                            </td>
                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row mt-2">
                                <div class="col-md-6">

                                    <div class="form-group mb-2">
                                        <label for="lng">Longitude</label>
                                        <input type="text" id="lng" name="lng" value="{{ $meeting->lng ?? null}}"
                                            class="form-control @error('lng') is-invalid @enderror">
                                        @error('lng')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group mb-2">
                                        <label for="lat">Lattitude</label>
                                        <input type="text" id="lat" name="lat" value="{{ $meeting->lat ?? null}}"
                                            class="form-control @error('lat') is-invalid @enderror">
                                        @error('lat')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                            </div>


                        </div>
                        <div class="row g-2">
                            <button class="btn btn-primary"> Modifier </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')
    <script>
        $(document).ready(function() {

            $('#user_id').on('change', function() {
                var user_id = this.value;
                $.ajax({
                    url: '/Meeting/user/' + user_id,
                    type: 'get',
                    success: function(response) {
                        // console.log(response);
                        var html = '';
                        $.each(response, function(k, v) {
                            // console.log(v);

                            html += "<tr>";
                            html += "<td>" + v.user.name + "</td>";
                            html += "<td>" + v.dossier.ref + "</td>";
                            html += "<td>" + v.date + "</td>";
                            html += "<td>" + v.start + "</td>";
                            html += "<td class=/'badge bg-primary/'>" + v.meetingstatus
                                .status + "</td>";
                            html += "</tr>";
                        });
                        html += '';

                        $("#myTable tbody").html(html)
                    }
                });
            });
            $('#garage_id').on('change', function() {
                var garage_id = this.value;
                $.ajax({
                    url: '/Meeting/garage/' + garage_id,
                    type: 'get',
                    success: function(response) {
                        // console.log(response);
                        document.getElementById('adress').value = response[0][0].adress;
                        document.getElementById('lat').value = response[0][0].lat;
                        document.getElementById('lng').value = response[0][0].lng;

                        const Blocations = response[0];
                        const Clocations = response[1];

                        initMap2(Blocations, Clocations);
                    }
                });
            });

        });
    </script>

    <script src="https://maps.googleapis.com/maps/api/js?key={{ env('GOOGLE_MAP_KEY') }}&libraries=places&callback=initMap"
        async defer></script>
    <script>
        function initMap() {
            const map = new google.maps.Map(document.getElementById("map"), {
                zoom: 6,
                center: {
                    lat: 33.45568426885455,
                    lng: -7.61802005374749,
                    zoom: 6
                },

            });
            const uluru = {
                lat: 33.45568426885455,
                lng: -7.61802005374749,
            };
            let marker = new google.maps.Marker({
                position: uluru,
                map: map,
                draggable: true
            });
            google.maps.event.addListener(marker, 'position_changed',
                function() {
                    let lat = marker.position.lat()
                    let lng = marker.position.lng()
                    $('#lat').val(lat)
                    $('#lng').val(lng)
                })

            google.maps.event.addListener(map, 'click',
                function(event) {
                    pos = event.latLng
                    marker.setPosition(pos)
                })


            setMarkers(map);
            setMarkers2(map);

        }
        const locations = <?php print json_encode($markers); ?>;
        const image1 = "<?php print asset('img/car.png'); ?>";

        function setMarkers(map) {

            for (let i = 0; i < locations.length; i++) {
                const location = locations[i];

                new google.maps.Marker({
                    position: {
                        lat: parseFloat(location.lat),
                        lng: parseFloat(location.lng)
                    },
                    label: {
                        color: 'blue',
                        fontWeight: 'bold',
                        text: location.libelle,
                    },
                    icon: {
                        url: image1,
                        size: new google.maps.Size(36, 50),
                        scaledSize: new google.maps.Size(36, 50),
                        anchor: new google.maps.Point(0, 50),
                        labelOrigin: new google.maps.Point(9, 8)

                    },
                    map,
                    title: location.libelle,
                    zIndex: location.lng,
                });

                // console.log(locations[i]);
            }
        }
        const Alocations = <?php print json_encode($agents); ?>;
        // console.log(Alocations);
        const image = "https://upload.wikimedia.org/wikipedia/commons/thumb/5/59/User-avatar.svg/1200px-User-avatar.svg.png";

        function setMarkers2(map) {

            for (let i = 0; i < Alocations.length; i++) {
                const location = Alocations[i];

                new google.maps.Marker({
                    position: {
                        lat: parseFloat(location.lat),
                        lng: parseFloat(location.lng)
                    },
                    label: {
                        color: 'black',
                        fontWeight: 'bold',
                        text: location.user.name,

                    },
                    icon: {
                        url: image,
                        size: new google.maps.Size(36, 50),
                        scaledSize: new google.maps.Size(36, 50),
                        anchor: new google.maps.Point(0, 50),
                        labelOrigin: new google.maps.Point(9, 8)

                    },
                    map,
                    zIndex: location.lng,
                });

                // console.log(locations[i]);
            }
        }

        function initMap2(Blocations, Clocations) {
            const map = new google.maps.Map(document.getElementById("map"), {
                zoom: 10,
                center: {
                    lat: 30.168831728404875,
                    lng: -7.46378273987113,
                    zoom: 12
                },

            });
            const uluru = {
                lat: 30.168831728404875,
                lng: -7.46378273987113,
            };
            let marker = new google.maps.Marker({
                position: uluru,
                map: map,
                draggable: true

            });
            google.maps.event.addListener(marker, 'position_changed',
                function() {
                    let lat = marker.position.lat()
                    let lng = marker.position.lng()
                    $('#lat').val(lat)
                    $('#lng').val(lng)
                })

            google.maps.event.addListener(map, 'click',
                function(event) {
                    pos = event.latLng
                    marker.setPosition(pos)
                })

            setMarkers3(map, Blocations);
            setMarkers4(map, Clocations);

        }

        function setMarkers3(map, Blocations) {

            const image2 = "https://img.favpng.com/10/6/8/computer-icons-button-user-avatar-png-favpng-ZbDCkqLSnQtr3HjsWyk6rDLXa.jpg";
            for (let i = 0; i < Blocations.length; i++) {
                const location = Blocations[i];

                new google.maps.Marker({
                    position: {
                        lat: parseFloat(location.lat),
                        lng: parseFloat(location.lng)
                    },
                    label: {
                        color: 'red',
                        fontWeight: 'bold',
                        text: location.libelle,

                    },
                    icon: {
                        url: image1,
                        size: new google.maps.Size(36, 50),
                        scaledSize: new google.maps.Size(36, 50),
                        anchor: new google.maps.Point(0, 50),
                        labelOrigin: new google.maps.Point(9, 8)
                    },
                    map,
                    zIndex: location.lng,
                });

                // console.log(locations[i]);
            }
        }

        function setMarkers4(map, Clocations) {

            for (let i = 0; i < Clocations.length; i++) {
                const location = Clocations[i];

                new google.maps.Marker({
                    position: {
                        lat: parseFloat(location.lat),
                        lng: parseFloat(location.lng)
                    },
                    label: {
                        color: 'black',
                        fontWeight: 'bold',
                        text: location.agent,

                    },
                    icon: {
                        url: image,
                        size: new google.maps.Size(36, 50),
                        scaledSize: new google.maps.Size(36, 50),
                        anchor: new google.maps.Point(0, 50),
                        labelOrigin: new google.maps.Point(9, 8)

                    },
                    map,
                    zIndex: location.lng,
                });

                // console.log(locations[i]);
            }
        }

    </script>

@endsection
