@extends('layouts.config_dashboard.app')
@section('style')
    <link rel="stylesheet"
        href="https://cdn.scaleflex.it/plugins/js-cloudimage-responsive/4.8.5/js-cloudimage-responsive.min.css?vh=a076ef&func=proxy" />
@endsection
@section('content')

    <div class="container-fluid mt-4">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <input type="hidden" name="doc" id="img" value="{{ Storage::disk('s3')->temporaryUrl($document->path, now()->addMinutes(30)) }}">
                    <div id="editor_container" class="card-body">
                        <img id="editor_container" class="img-thumbnail"
                            alt="" srcset="" >
                    </div>
                </div>

            </div>
        </div>

    </div>
@endsection
@section('scripts')
<script src="https://scaleflex.cloudimg.io/v7/plugins/filerobot-image-editor/latest/filerobot-image-editor.min.js"></script>

<script>
    // console.log(document.getElementById('img').src);
    // const {
    //     TABS,
    //     TOOLS
    // } = FilerobotImageEditor;

    // const config = {
    //     source: document.getElementById('img').src,
    //     onSave: (editedImageObject, designState) =>
    //         console.log('saved', editedImageObject, designState),
    //     annotationsCommon: {
    //         fill: '#ff0000',
    //     },
    //     Text: {
    //         text: 'Filerobot...'
    //     },
    //     Rotate: {
    //         angle: 90,
    //         componentType: 'slider'
    //     },
    //     translations: {
    //         profile: 'Profile',
    //         coverPhoto: 'Cover photo',
    //         facebook: 'Facebook',
    //         socialMedia: 'Social Media',
    //         fbProfileSize: '180x180px',
    //         fbCoverPhotoSize: '820x312px',
    //     },
    //     Crop: {
    //         presetsItems: [{
    //                 titleKey: 'classicTv',
    //                 descriptionKey: '4:3',
    //                 ratio: 4 / 3,
    //                 // icon: CropClassicTv, // optional, CropClassicTv is a React Function component. Possible (React Function component, string or HTML Element)
    //             },
    //             {
    //                 titleKey: 'cinemascope',
    //                 descriptionKey: '21:9',
    //                 ratio: 21 / 9,
    //                 // icon: CropCinemaScope, // optional, CropCinemaScope is a React Function component.  Possible (React Function component, string or HTML Element)
    //             },
    //         ],
    //         presetsFolders: [{
    //             titleKey: 'socialMedia', // will be translated into Social Media as backend contains this translation key
    //             // icon: Social, // optional, Social is a React Function component. Possible (React Function component, string or HTML Element)
    //             groups: [{
    //                 titleKey: 'facebook',
    //                 items: [{
    //                         titleKey: 'profile',
    //                         width: 180,
    //                         height: 180,
    //                         descriptionKey: 'fbProfileSize',
    //                     },
    //                     {
    //                         titleKey: 'coverPhoto',
    //                         width: 820,
    //                         height: 312,
    //                         descriptionKey: 'fbCoverPhotoSize',
    //                     },
    //                 ],
    //             }, ],
    //         }, ],
    //     },
    //     tabsIds: [TABS.ADJUST, TABS.ANNOTATE, TABS.WATERMARK], // or ['Adjust', 'Annotate', 'Watermark']
    //     defaultTabId: TABS.ANNOTATE, // or 'Annotate'
    //     defaultToolId: TOOLS.TEXT, // or 'Text'
    // };

    // // Assuming we have a div with id="editor_container"
    // const filerobotImageEditor = new FilerobotImageEditor(
    //     document.querySelector('#editor_container'),
    //     config,
    // );

    // filerobotImageEditor.render({
    //     onClose: (closingReason) => {
    //         console.log('Closing reason', closingReason);
    //         filerobotImageEditor.terminate();
    //     },
    // });
    // let image1 = document.getElementById('img1');
    // image1.addEventListener("click", (e) => {
    //    document.getElementById('img').remove();
    //    e.target.id = 'img';
    // });

console.log(document.getElementById('img').value);
const { TABS, TOOLS } = FilerobotImageEditor;
const config = {
  source: document.getElementById('img').value,
  onSave: (editedImageObject, designState) =>
    console.log('saved', editedImageObject, designState),
  annotationsCommon: {
    fill: '#ff0000',
  },
  Text: { text: 'Filerobot...' },
  Rotate: { angle: 90, componentType: 'slider' },
  translations: {
    profile: 'Profile',
    coverPhoto: 'Cover photo',
    facebook: 'Facebook',
    socialMedia: 'Social Media',
    fbProfileSize: '180x180px',
    fbCoverPhotoSize: '820x312px',
  },
  Crop: {
    presetsItems: [
      {
        titleKey: 'classicTv',
        descriptionKey: '4:3',
        ratio: 4 / 3,
        // icon: CropClassicTv, // optional, CropClassicTv is a React Function component. Possible (React Function component, string or HTML Element)
      },
      {
        titleKey: 'cinemascope',
        descriptionKey: '21:9',
        ratio: 21 / 9,
        // icon: CropCinemaScope, // optional, CropCinemaScope is a React Function component.  Possible (React Function component, string or HTML Element)
      },
    ],
    presetsFolders: [
      {
        titleKey: 'socialMedia', // will be translated into Social Media as backend contains this translation key
        // icon: Social, // optional, Social is a React Function component. Possible (React Function component, string or HTML Element)
        groups: [
          {
            titleKey: 'facebook',
            items: [
              {
                titleKey: 'profile',
                width: 180,
                height: 180,
                descriptionKey: 'fbProfileSize',
              },
              {
                titleKey: 'coverPhoto',
                width: 820,
                height: 312,
                descriptionKey: 'fbCoverPhotoSize',
              },
            ],
          },
        ],
      },
    ],
  },
  tabsIds: [TABS.ADJUST, TABS.ANNOTATE, TABS.WATERMARK], // or ['Adjust', 'Annotate', 'Watermark']
  defaultTabId: TABS.ANNOTATE, // or 'Annotate'
  defaultToolId: TOOLS.TEXT, // or 'Text'
};

// Assuming we have a div with id="editor_container"
const filerobotImageEditor = new FilerobotImageEditor(
  document.querySelector('#editor_container'),
  config,
);

filerobotImageEditor.render({
  onClose: (closingReason) => {
    console.log('Closing reason', closingReason);
    filerobotImageEditor.terminate();
  },
});

</script>

@endsection
