@extends('layouts.config_dashboard.app')

@section('content')
    <div class="container-fluid mt-4">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <form action="{{ route('Email.send') }}" method="POST">
                            @csrf
                            <input type="hidden" name="dossier_id" value="{{ $dossier->id }}">
                            <div class="row">
                                <h2>Email :</h2>

                                <div class="col-3">
                                    <label for="">From :</label>
                                    <input class="form-control @error('from') is-invalid @enderror" name="from"
                                        value="{{ $dossier->company->email_pro ?? null }}" readonly type="email">
                                    @error('from')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="col-3">
                                    <label for="">To</label>
                                    <input class="form-control @error('to') is-invalid @enderror" name="to"
                                        value="{{ $dossier->company->email ?? null }}" type="email">
                                    @error('to')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>

                                <div class="col-6">
                                    <label for="">Sujet</label>
                                    <input class="form-control @error('subject') is-invalid @enderror" name="subject"
                                        type="text">
                                    @error('subject')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>

                                <div class="col-12 mt-2">
                                    <label for="">Contenu</label>
                                    <textarea @error('content') is-invalid @enderror class="form-control" name="content" id="" cols="15"
                                        rows="5">

                                    </textarea>
                                    @error('content')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>

                            </div>
                            <input type="hidden" name="attachements" id="docs">

                            <div class=" mt-3">
                                <button type="submit" style="float: right" class="btn btn-success">Envoyer</button>
                            </div>
                            <div class="row mt-3">
                                <h3>Selectionner Les Documents </h3>
                            </div>
                            <hr>
                            <div class="form-check form-check-inline form-checkbox-warning ">
                                <label class="form-check-label fs-4" for="selectAll">Selectioner Tout
                                </label>
                                <input type="checkbox" id="selectAll" class="check form-check-input">
                            </div>
                            <hr>
                            <div class="row mt-3">
                                @foreach ($imgs as $doc)
                                    <div class="col-4 mb-2">
                                        <input type="checkbox" value="{{ $doc->id }}" class="check">
                                        <img id="img{{ $doc->id }}" style="width: 300px;height:250px"
                                            src="{{ Storage::disk('s3')->temporaryUrl($doc->path, now()->addMinutes(30)) }}"
                                            alt="">
                                        <span>{{ $doc->typedocument->type ?? null }}</span>
                                    </div>
                                @endforeach
                            </div>
                            <div class="row mt-3">
                                @foreach ($pdfs as $doc)
                                    <div class="col-4">
                                        <input type="checkbox" value="{{ $doc->id }}" class="check">
                                        <embed style="width: 300px;height:250px"
                                            src="{{ Storage::disk('s3')->temporaryUrl($doc->path, now()->addMinutes(30)) }}"
                                            width="600" height="500" alt="pdf" />

                                        <span>{{ $doc->typedocument->type }}</span>
                                    </div>
                                @endforeach
                            </div>
                        </form>

                    </div>
                </div>

            </div>
        </div>
    </div>
@endsection
@section('script')
    <script>
        var checkboxes = document.getElementsByClassName('check');
        var array = [];
        var docs = document.getElementById('docs');

        const selectAllCheckbox = document.getElementById('selectAll');

        // Add a click event listener to the "Select All" checkbox
        selectAllCheckbox.addEventListener('click', function() {
            console.log(5);
            const isChecked = selectAllCheckbox.checked;

            // Update the state of all other checkboxes
            checkboxes.forEach((checkbox) => {
                checkbox.checked = isChecked;
                array.push(checkbox.value);
            });
        });

        // Add a click event listener to each individual checkbox
        checkboxes.forEach((checkbox) => {
            checkbox.addEventListener('click', function() {
                // Check if all other checkboxes are checked and update the "Select All" checkbox accordingly
                selectAllCheckbox.checked = checkboxes.length === document.querySelectorAll(
                    '.checkbox-item:checked').length;

            });
        });
        for (var i = 0; i < checkboxes.length; i++) {
            checkboxes[i].addEventListener('change', function() {
                if (this.checked) {
                    array.push(this.value);
                    console.log(array);
                    docs.value = array;
                } else {
                    var carIndex = array.indexOf(this.value); //get   index
                    array.splice(carIndex, 1);
                    console.log(array);
                    docs.value = array;
                }
            });

        }
    </script>
@endsection
