<div align="center">
	<p><img src="art/header.jpg" alt="PowerGrid Logo"></p>
    <p align="center">
        <a href="https://packagist.org/packages/power-components/livewire-powergrid"><img alt="Latest Version" src="https://img.shields.io/static/v1?label=laravel&message=%E2%89%A58.0&color=0078BE&logo=laravel&style=flat-square"></a>
        <a href="https://packagist.org/packages/power-components/livewire-powergrid"><img alt="Total Downloads" src="https://img.shields.io/packagist/dt/power-components/livewire-powergrid"></a>
        <a href="https://github.com/Power-Components/livewire-powergrid/actions">
            <img alt="Tests Passing" src="https://github.com/Power-Components/livewire-powergrid/workflows/Powergrid%20Tests/badge.svg" />
        </a>
        <a href="https://packagist.org/packages/power-components/livewire-powergrid"><img alt="Latest Version" src="https://img.shields.io/packagist/v/power-components/livewire-powergrid"></a>
        <a href="https://packagist.org/packages/power-components/livewire-powergrid"><img alt="License" src="https://img.shields.io/packagist/l/power-components/livewire-powergrid"></a>
    </p>
    <a href="https://livewire-powergrid.com" target="_blank">📚 Documentation</a> |
    <a href="#features">🔥 Features</a> |
    <a href="#get-started">⌨️ Get started</a>
</div>

------

# Livewire ⚡PowerGrid⚡

<br/>

PowerGrid creates modern, powerful and easy to customize Datatables based on Laravel [Livewire](https://laravel-livewire.com) library.

<br/>

➔  **Zero Configuration**: Tables have basic features activated by default.

➔  **It fits your needs**: Extend and customize your table including components (checkbox, action buttons, editable fields), global search feature, column data filters and data export tool.

➔  **Full Stubs**: Table components include feature examples. Just uncomment some code, enter your data, and it works!


<br/>

## 🚀 Instant Demo

Get a view of what PowerGrid can offer in just 2 commands:

Install

```bash
composer require power-components/livewire-powergrid
```

Run

```bash
php artisan powergrid:demo
```

<br/>

## Features

With PowerGrid you get right out of the box:

- **Filters & Search**

- **Column Sorting**

- **Column Sum, Count & Average in Header/Footer**

- **Pagination**

- **Action Checkboxes**

- **Action Buttons**

- **Bulk Actions**

- **Action Rules: Conditionally disable, hide and modify Action Buttons, Checkboxes and rows**

- **Toggle button**

- **Click to edit**

- **Click to copy**

- **Link inside a table cell**

- **Livewire Modal Integration ([Wire Elements Modal](https://github.com/wire-elements/modal))**

- **Data Export to XLSX/CSV ([OpenSpout](https://github.com/openspout/openspout))**

- **Queue Export for large tables**

- **Works with Bootstrap 5 or Tailwind CSS 3x**

- **Translations available for 🇺🇸 🇧🇷 🇪🇸 🇮🇹 🇩🇪 and others...**

<br/>

 ![Laravel Livewire Tables](https://github.com/Power-Components/powergrid-doc/blob/main/docs/_media/example.gif?raw=true)

------

# Get started

## 1. Requirements

- PHP 8.0+
- [Laravel 8.75+](https://laravel.com/docs/9.x/installation)
- [Livewire 2.10x](https://laravel-livewire.com)
- [Tailwind 3x](https://tailwindcss.com/docs/guides/laravel) or [Bootstrap 5](https://getbootstrap.com/docs/5.0/getting-started/introduction/)

<br/>

## 2. Install

Please follow the steps indicated in our [Documentation - Install](https://livewire-powergrid.com/#/get-started/install) page.

<br/>

## 3. Support

For questions, issues, bug reports and feature requests, please use our [Issues](https://github.com/Power-Components/livewire-powergrid/issues).

Before submitting a new request, please look into our previous issues.

Verify if your bug/question or feature request has been previously submitted.

<br/>

## 4. How to contribute

We appreciate your interest in contributing with PowerGrid.

Please read the [Contributing Guide](https://github.com/Power-Components/livewire-powergrid/blob/main/CONTRIBUTING.md).

<br/>

## 5. Credits

Created by: [Luan Freitas](https://twitter.com/luanfreitasdev)

- [Contributors](../../contributors)
- Logo & artwork by [Caneco](https://twitter.com/caneco)

<br/>

<sup><b>Notice of Non-Affiliation and Disclaimer:</b> Livewire PowerGrid is not affiliated, associated, endorsed by, or in any way officially connected with the Laravel Livewire - copyright by Caleb Porzio.</sup>

<hr>

<p>Sponsored by:</p>
<p>
  <!--DevSquad-->
  <a href="http://devsquad.com" target="_blank">
    <img src="https://livewire-powergrid.com/_media/logos/devsquad.png" alt="DevSquad" height="undefined">
  </a>

</p>
<p></p>
<p></p>
<p>Supported by:</p>
<p>
  <!-- PHPStorm -->
  <a href="https://www.jetbrains.com/phpstorm/" target="_blank">
    <img src="https://livewire-powergrid.com/_media/logos/phpstorm.png" alt="PHPStorm" height="32">
  </a>
  <!-- Araxis Merge -->
  <a href="https://www.araxis.com/merge/" target="_blank">
    <img src="https://livewire-powergrid.com/_media/logos/araxis.png" alt="Araxis Merge" height="32">
  </a>
</p>

<hr>

<sup><b>Notice of Non-Affiliation and Disclaimer:</b> Livewire PowerGrid is not affiliated, associated, endorsed by, or in any way officially connected with the Laravel Livewire - copyright by Caleb Porzio.</sup>

