@extends('layouts.dashboard.app')
@section('style')
    <style>
        #description {
            font-family: Roboto;
            font-size: 15px;
            font-weight: 300;
        }

        #infowindow-content .title {
            font-weight: bold;
        }

        #infowindow-content {
            display: none;
        }

        #map #infowindow-content {
            display: inline;
        }

        .pac-card {
            background-color: #fff;
            border: 0;
            border-radius: 2px;
            box-shadow: 0 1px 4px -1px rgba(0, 0, 0, 0.3);
            margin: 10px;
            padding: 0 0.5em;
            font: 400 18px Roboto, Arial, sans-serif;
            overflow: hidden;
            font-family: Roboto;
            padding: 0;
        }

        #pac-container {
            padding-bottom: 12px;
            margin-right: 12px;
        }

        .pac-controls {
            display: inline-block;
            padding: 5px 11px;
        }

        .pac-controls label {
            font-family: Roboto;
            font-size: 13px;
            font-weight: 300;
        }

        #pac-input {
            background-color: #fff;
            font-family: Roboto;
            font-size: 15px;
            font-weight: 300;
            margin-left: 12px;
            padding: 0 11px 0 13px;
            text-overflow: ellipsis;
            width: 400px;
        }

        #pac-input:focus {
            border-color: #4d90fe;
        }

        #title {
            color: #fff;
            background-color: #4d90fe;
            font-size: 25px;
            font-weight: 500;
            padding: 6px 12px;
        }

        #target {
            width: 345px;
        }
    </style>
@endsection
@section('content')
    <div class="container-fluid mt-2 ">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body mt-1">
                        <form action="{{ route('Garage.store') }}" method="post">
                            @csrf
                            <div class="form-group mb-2">
                                <label for="libelle">Libelle</label>
                                <input type="text" name="libelle" value="{{ old('libelle') }}" required
                                    class="form-control @error('libelle') is-invalid @enderror">
                                @error('libelle')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="form-group mb-2">
                                <label for="email">Email</label>
                                <input type="email" name="email" value="{{ old('email') }}" required
                                    class="form-control @error('email') is-invalid @enderror">
                                @error('email')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>

                            <div class="form-group mb-2">
                                <label for="city">Ville</label>
                                <select class="form-select " name="city" id="city">
                                    @foreach ($cities as $city)
                                        <option value="{{ $city->id }}">{{ $city->city }}</option>
                                    @endforeach
                                </select>

                            </div>

                            <div class="form-group mb-2">
                                <label for="adress">Adresse</label>
                                <input type="text" name="adress" value="{{ old('adress') }}"
                                    class="form-control @error('adress') is-invalid @enderror">
                                @error('adress')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class=" form-group mb-3">
                                <label for="simpleinput" class="form-label">Telephone </label>
                                <input type="text" id="tel" name="tel" value="{{ old('tel') }}"
                                    pattern="(\+212|0)([ \-_/]*)(\d[ \-_/]*){9}"
                                    class="form-control @error('tel') is-invalid  @enderror">
                                @error('tel')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="row">
                                <div class="col-md-6">

                                    <div class="form-group mb-2">
                                        <label for="url">Lien</label>
                                        <input type="text" id="url" name="url" value="{{ old('url') }}"
                                            class="form-control @error('url') is-invalid @enderror">
                                        @error('url')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                                {{-- <div class="form-group mb-1">
                                    <div class="form-check form-check-inline form-checkbox">
                                        <input type="checkbox" class="form-check-input"
                                            name="verified">
                                        <label class="form-check-label fs-4"
                                            for="customSwitch3">Agréer</label>
                                    </div>
                                </div> --}}
                            </div>
                            <div class="row">
                                <div class="col-md-6">

                                    <div class="form-group mb-2">
                                        <label for="lng">Longitude</label>
                                        <input type="text" id="lng" name="lng" value="{{ old('lng') }}"
                                            class="form-control @error('lng') is-invalid @enderror">
                                        @error('lng')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="form-group mb-2">
                                        <label for="lat">Lattitude</label>
                                        <input type="text" id="lat" name="lat" value="{{ old('lat') }}"
                                            class="form-control @error('lat') is-invalid @enderror">
                                        @error('lat')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                            </div>

                            <h4 class="header-title mb-3">Localisation :</h4>
                            <div class="col-md-12">
                                <input id="pac-input" class="controls" type="text" placeholder="Search Box" />
                                <div id="map" class="gmaps" style="height: 60vh">
                                </div>
                            </div>

                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary">Créer</button>
                    </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('script')
    <script
        src="https://maps.googleapis.com/maps/api/js?key={{ env('GOOGLE_MAP_KEY') }}&callback=initAutocomplete&libraries=places&v=weekly"
        defer></script>
    <script>
        function initAutocomplete() {
            const map = new google.maps.Map(document.getElementById("map"), {
                center: {
                    lat: 33.37562245379103,
                    lng: -7.579586521130635
                },
                zoom: 13,
                mapTypeId: "roadmap",

            });
            const uluru = {
                lat: 33.37562245379103,
                lng: -7.579586521130635
            };
            let marker = new google.maps.Marker({
                position: uluru,
                map: map,
                draggable: true
            });
            google.maps.event.addListener(marker, 'position_changed',
                function() {
                    let lat = marker.position.lat()
                    let lng = marker.position.lng()
                    $('#lat').val(lat)
                    $('#lng').val(lng)
                })

            google.maps.event.addListener(map, 'click',
                function(event) {
                    pos = event.latLng
                    marker.setPosition(pos)
                })
            // Create the search box and link it to the UI element.
            const input = document.getElementById("pac-input");
            const searchBox = new google.maps.places.SearchBox(input);

            map.controls[google.maps.ControlPosition.TOP_LEFT].push(input);
            // Bias the SearchBox results towards current map's viewport.
            map.addListener("bounds_changed", () => {
                searchBox.setBounds(map.getBounds());
            });

            let markers = [];

            // Listen for the event fired when the user selects a prediction and retrieve
            // more details for that place.
            searchBox.addListener("places_changed", () => {
                const places = searchBox.getPlaces();

                if (places.length == 0) {
                    return;
                }

                // Clear out the old markers.
                markers.forEach((marker) => {
                    marker.setMap(null);
                });
                markers = [];

                // For each place, get the icon, name and location.
                const bounds = new google.maps.LatLngBounds();

                places.forEach((place) => {
                    if (!place.geometry || !place.geometry.location) {
                        console.log("Returned place contains no geometry");
                        return;
                    }

                    const icon = {
                        url: place.icon,
                        size: new google.maps.Size(71, 71),
                        origin: new google.maps.Point(0, 0),
                        anchor: new google.maps.Point(17, 34),
                        scaledSize: new google.maps.Size(25, 25),
                    };


                    // Create a marker for each place.
                    markers.push(
                        new google.maps.Marker({
                            map,
                            icon,
                            title: place.name,
                            position: place.geometry.location,
                        })
                    );
                    if (place.geometry.viewport) {
                        // Only geocodes have viewport.
                        bounds.union(place.geometry.viewport);
                    } else {
                        bounds.extend(place.geometry.location);
                    }
                });

                map.fitBounds(bounds);
            });
        }

        window.initAutocomplete = initAutocomplete;
    </script>
    {{-- <script src="https://maps.googleapis.com/maps/api/js?key={{ env('GOOGLE_MAP_KEY') }}&callback=initMap" async
        defer></script>

    <script>
        let map;

       function initMap() {
             map = new google.maps.Map(document.getElementById("map"), {
                center: {
                    lat: 33.45568426885455,
                    lng: -7.61802005374749
                },
                zoom: 10,
                scrollwheel: true,
            });
            const uluru = {
                lat: 33.38568426885455,
                lng: -7.61802005374749
            };
            let marker = new google.maps.Marker({
                position: uluru,
                map: map,
                draggable: true
            });
            google.maps.event.addListener(marker, 'position_changed',
                function() {
                    let lat = marker.position.lat()
                    let lng = marker.position.lng()
                    $('#lat').val(lat)
                    $('#lng').val(lng)
                })

            google.maps.event.addListener(map, 'click',
                function(event) {
                    pos = event.latLng
                    marker.setPosition(pos)
                })
        }

        window.initMap = initMap;
    </script> --}}
@endsection
