@extends('layouts.test')
@section('content')

    <!-- Loader Overlay -->
    <div id="loaderOverlay" style="position: fixed; top: 0; left: 0; right: 0; bottom: 0; background: rgba(255,255,255,0.9); display: flex; flex-direction: column; align-items: center; justify-content: center; z-index: 9999;">
        <div style="width: 50px; height: 50px; border: 4px solid #e2e8f0; border-top-color: #3498db; border-radius: 50%; animation: spin 0.8s linear infinite;"></div>
        <div style="margin-top: 20px; font-size: 16px; font-weight: 600; color: #333;">Chargement des dossiers...</div>
        <div id="loaderSubtext" style="margin-top: 8px; font-size: 14px; color: #666;">Préparation des données</div>
        <div style="margin-top: 15px; width: 200px; height: 4px; background: #e2e8f0; border-radius: 2px; overflow: hidden;">
            <div id="loaderProgressBar" style="height: 100%; background: linear-gradient(90deg, #3498db, #2ecc71); width: 0%; transition: width 0.3s;"></div>
        </div>
    </div>
    <style>
        @keyframes spin { to { transform: rotate(360deg); } }
        #loaderOverlay.hidden { display: none !important; }
    </style>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <h2 class="my-1 mx-1 text-dark" id="title">Dossiers</h2>
                    <div class="d-flex gap-3 mt-2">
                        <small class="text-muted">Total: <strong id="statTotal">0</strong></small>
                        <small class="text-muted">Chargés: <strong id="statLoaded">0</strong></small>
                        <small id="statPending" class="text-muted" style="display:none;">En attente: <strong id="statPendingValue">0</strong></small>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row mt-1">
        <div id="pagination">
            <button class="btn btn-outline-success mb-2" onclick="exportToExcel()">Exporter Excel</button>
            <span id="loadProgress" style="display:none; margin-left: 15px;">
                <span id="progressText" class="text-muted">Chargement...</span>
            </span>
        </div>
        <div class="col-12">
            <div class="card">
                <div style="overflow: scroll" class="card-body">
                    <table style="overflow: scroll" class="table table-stripped" id="myTable">
                        <thead>
                            <tr>
                                <th scope="col">Reference Dossier</th>
                                <th scope="col">Compagnie</th>
                                <th scope="col">Assuré</th>
                                <th scope="col">Matricule</th>
                                <th>Numero Sinistre</th>
                                <th scope="col">Type De Dossier</th>
                                <th>Mode</th>
                                <th>Montant Devis</th>
                                <th>Montant Facture</th>
                                <th scope="col">Etape</th>
                                <th scope="col">Delai</th>
                                <th scope="col">Status</th>
                                <th scope="col">Devis</th>
                                <th scope="col">Rapport</th>
                                <th scope="col">Facture</th>
                                <th scope="col">Action</th>
                            </tr>
                        </thead>
                        <tbody id="tableBody">
                        </tbody>
                    </table>
                </div>
            </div>
            <input type="hidden" id="role" value="{{ Auth::user()->role_id }}">
            <input type="hidden" id="currentFilter" value="default">
        </div>
    </div>

@endsection
@section('script')
    <script>
    (function() {
        "use strict";

        // Configuration
        var CONFIG = {
            INITIAL_LOAD: 500,
            BATCH_SIZE: 1000,
            API_URL: "/api/dossiers/data",
            EXPORT_URL: "/export/dossiers",
            CSRF_TOKEN: document.querySelector("meta[name=csrf-token]") ? document.querySelector("meta[name=csrf-token]").getAttribute("content") : ""
        };

        // State
        var State = {
            currentFilter: "default",
            allData: [],
            totalRecords: 0,
            isLoading: false,
            isFullyLoaded: false,
            dataTable: null
        };

        // Filter mapping
        var FILTER_MAP = {
            "/Expertiser": "expertiser",
            "/Expertise/encours": "enexp",
            "/Reporter": "areport",
            "/Devis/Carence": "carencedevis",
            "/Facture/Carence": "carencefacture",
            "/Carence/Rapport": "carencerapport",
            "/Devis/Retraiter": "devisretraiter",
            "/Facture/Retraiter": "factureretraiter",
            "/Retraiter/Rapport": "rapportaretraiter",
            "/Devis/Traitement": "traitdevis",
            "/Facture/Traitement": "traitfacture",
            "/Signer/Rapport": "rapportasigner",
            "/Instance/Rapport": "traitrapport",
            "/Devis/Envoyer": "senddevis",
            "/Facture/Envoyer": "sendfacture",
            "/Envoyer/Rapport": "sendrapport",
            "/Devis/Avis": "avisdevis",
            "/Facture/Avis": "avisfacture",
            "/Devis/Deuxieme": "deuxdevis",
            "/Facture/Deuxieme": "deuxfacture",
            "/Deuxieme/Rapport": "deuxrapport",
            "/Douteux": "douteux",
            "/Tribunale": "tribunale",
            "/Warning": "warning",
            "/Signer/Document": "docasigner",
            "/Signe/Document": "docsigner",
            "/Rapide": "rapide",
            "/Base": "basedoc",
            "/Facturation": "facturation",
            "/Devis/Trait": "devisentraitement",
            "/Facture/Trait": "factureentraitement",
            "/Devis/Photo": "attdevisav",
            "/Facture/Photo": "attfactureap",
            "/Expertise/Apres": "attexpap",
            "/Devis/Controler": "controldevis"
        };

        // DataTable language config
        var DT_LANGUAGE = {
            lengthMenu: "Afficher _MENU_ entrées",
            zeroRecords: "Aucun dossier trouvé",
            info: "Affichage de _START_ à _END_ sur _TOTAL_ entrées",
            infoEmpty: "Aucune entrée disponible",
            infoFiltered: "(filtré de _MAX_ entrées totales)",
            search: "Rechercher:",
            paginate: {
                first: "Premier",
                last: "Dernier",
                next: "Suivant",
                previous: "Précédent"
            }
        };

        // UI Functions
        function showLoader() {
            document.getElementById("loaderOverlay").classList.remove("hidden");
        }

        function hideLoader() {
            document.getElementById("loaderOverlay").classList.add("hidden");
        }

        function updateLoaderProgress(percent, text) {
            document.getElementById("loaderProgressBar").style.width = percent + "%";
            if (text) document.getElementById("loaderSubtext").textContent = text;
        }

        function updateStats(total, loaded) {
            document.getElementById("statTotal").textContent = total;
            document.getElementById("statLoaded").textContent = loaded;
            var pending = total - loaded;
            if (pending > 0) {
                document.getElementById("statPending").style.display = "inline";
                document.getElementById("statPendingValue").textContent = pending;
            } else {
                document.getElementById("statPending").style.display = "none";
            }
        }

        // Format table row
        function formatRow(v) {
            var html = "";
            if (v.is_updated == 1) {
                html += "<tr class=\"table-success\">";
            } else {
                html += "<tr>";
            }
            html += "<td>" + (v.ref || ".") + "</td>";
            html += "<td>" + (v.company || ".") + "</td>";
            html += "<td>" + (v.insured_name || ".") + "</td>";
            html += "<td>" + (v.matricule || ".") + "</td>";
            html += "<td>" + (v.numero_sinistre || ".") + "</td>";
            html += "<td><span class=\"badge bg-success\">" + (v.type_expertise || ".") + "</span></td>";
            html += "<td><span class=\"badge bg-info\">" + (v.mode || ".") + "</span></td>";
            html += "<td><span class=\"badge bg-secondary\">" + (v.montant_devis || ".") + "</span></td>";
            html += "<td><span class=\"badge bg-secondary\">" + (v.montant_facture || ".") + "</span></td>";
            html += "<td><span class=\"badge bg-dark\">" + (v.step || ".") + "</span></td>";
            if (v.timeleft > 0) {
                html += "<td><span class=\"badge bg-warning\">" + v.timeleft + "H</span></td>";
            } else {
                html += "<td><span class=\"badge bg-danger\">" + v.timeleft + "H</span></td>";
            }
            html += "<td><span class=\"badge bg-" + (v.status_color || "secondary") + "\">" + (v.status || ".") + "</span></td>";
            html += "<td><a href=\"Devis/Dossier/" + v.id + "\" class=\"text-info rounded-pill\">Devis</a></td>";
            html += "<td><a href=\"Rapport/" + v.id + "\" class=\"text-info rounded-pill\">Rapport</a></td>";
            html += "<td><a href=\"Dossier/" + v.id + "/Facture\" class=\"text-info rounded-pill\">Facture</a></td>";
            html += "<td><a href=\"Dossier/" + v.id + "\" class=\"text-info rounded-pill\"><i class=\"uil uil-eye fs-4\"></i></a></td>";
            html += "</tr>";
            return html;
        }

        // Safely destroy DataTable
        function destroyDataTable() {
            try {
                if ($.fn.DataTable && $.fn.DataTable.isDataTable("#myTable")) {
                    $("#myTable").DataTable().destroy();
                }
            } catch (e) {
                console.log("DataTable destroy warning:", e);
            }
            State.dataTable = null;
        }

        // Initialize DataTable with events
        function initDataTable() {
            State.dataTable = $("#myTable").DataTable({
                paging: true,
                pageLength: 25,
                lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "Tout"]],
                ordering: true,
                order: [[0, "desc"]],
                searching: true,
                info: true,
                autoWidth: false,
                language: DT_LANGUAGE
            });

            // Bind events
            State.dataTable.on("page.dt", function() {
                if (!State.isFullyLoaded && State.allData.length < State.totalRecords) {
                    loadRemaining();
                }
            });

            State.dataTable.on("length.dt", function(e, settings, len) {
                if (!State.isFullyLoaded && State.allData.length < State.totalRecords) {
                    if (len > State.allData.length || len === -1) {
                        loadRemaining();
                    }
                }
            });
        }

        // Build table body HTML
        function buildTableBody() {
            var tbody = document.getElementById("tableBody");
            var html = "";
            for (var i = 0; i < State.allData.length; i++) {
                html += formatRow(State.allData[i]);
            }
            tbody.innerHTML = html;
        }

        // Fetch data from API
        function fetchBatch(filter, start, length, callback) {
            var xhr = new XMLHttpRequest();
            var params = "filter=" + encodeURIComponent(filter) + "&start=" + start + "&length=" + length + "&draw=1";
            xhr.open("GET", CONFIG.API_URL + "?" + params, true);
            xhr.setRequestHeader("X-Requested-With", "XMLHttpRequest");
            xhr.onreadystatechange = function() {
                if (xhr.readyState === 4) {
                    if (xhr.status === 200) {
                        try {
                            callback(null, JSON.parse(xhr.responseText));
                        } catch (e) {
                            callback(e, null);
                        }
                    } else {
                        callback(new Error("Network error: " + xhr.status), null);
                    }
                }
            };
            xhr.send();
        }

        // Load initial data
        function loadInitial(filter) {
            State.isLoading = true;
            State.isFullyLoaded = false;
            State.allData = [];
            State.currentFilter = filter;

            showLoader();
            updateLoaderProgress(20, "Connexion au serveur...");

            fetchBatch(filter, 0, CONFIG.INITIAL_LOAD, function(err, result) {
                if (err) {
                    console.error("Error loading data:", err);
                    hideLoader();
                    alert("Erreur lors du chargement des données");
                    State.isLoading = false;
                    return;
                }

                State.allData = result.data || [];
                State.totalRecords = result.recordsTotal || 0;

                updateLoaderProgress(80, "Affichage des données...");
                
                renderTable();
                updateStats(State.totalRecords, State.allData.length);

                if (State.allData.length >= State.totalRecords) {
                    State.isFullyLoaded = true;
                    document.getElementById("loadProgress").style.display = "none";
                } else {
                    document.getElementById("loadProgress").style.display = "inline";
                    document.getElementById("progressText").textContent = "Cliquez page suivante pour charger plus";
                }

                updateLoaderProgress(100, "Terminé");
                setTimeout(hideLoader, 300);
                State.isLoading = false;
            });
        }

        // Load remaining data in background
        function loadRemaining() {
            if (State.isFullyLoaded || State.isLoading) return;
            if (State.allData.length >= State.totalRecords) {
                State.isFullyLoaded = true;
                return;
            }

            State.isLoading = true;
            document.getElementById("loadProgress").style.display = "inline";

            function loadNextBatch() {
                if (State.allData.length >= State.totalRecords) {
                    State.isFullyLoaded = true;
                    State.isLoading = false;
                    document.getElementById("statPending").style.display = "none";
                    document.getElementById("progressText").textContent = "Chargement terminé! (" + State.allData.length + " dossiers)";
                    refreshTable();
                    return;
                }

                var pct = Math.round((State.allData.length / State.totalRecords) * 100);
                document.getElementById("progressText").textContent = State.allData.length + " / " + State.totalRecords + " (" + pct + "%)";

                fetchBatch(State.currentFilter, State.allData.length, CONFIG.BATCH_SIZE, function(err, result) {
                    if (err || !result.data || result.data.length === 0) {
                        State.isFullyLoaded = true;
                        State.isLoading = false;
                        document.getElementById("progressText").textContent = "Terminé (" + State.allData.length + ")";
                        refreshTable();
                        return;
                    }

                    State.allData = State.allData.concat(result.data);
                    updateStats(State.totalRecords, State.allData.length);
                    loadNextBatch();
                });
            }

            loadNextBatch();
        }

        // Refresh table with new data
        function refreshTable() {
            var currentPage = 0;
            var currentSearch = "";

            if (State.dataTable) {
                try {
                    currentPage = State.dataTable.page();
                    currentSearch = State.dataTable.search();
                } catch (e) {}
            }

            destroyDataTable();
            buildTableBody();
            initDataTable();

            if (currentSearch) {
                State.dataTable.search(currentSearch).draw(false);
            }
            
            var totalPages = State.dataTable.page.info().pages;
            if (currentPage > 0 && currentPage < totalPages) {
                State.dataTable.page(currentPage).draw(false);
            }
        }

        // Render table (initial)
        function renderTable() {
            destroyDataTable();
            buildTableBody();
            initDataTable();
        }

        // Load data for sidebar filter
        function loadData(url, title) {
            var filter = FILTER_MAP[url] || "default";
            State.currentFilter = filter;
            document.getElementById("currentFilter").value = filter;
            document.getElementById("title").textContent = title;
            loadInitial(filter);
        }

        // Export to Excel
        function exportToExcel() {
            var form = document.createElement("form");
            form.method = "POST";
            form.action = CONFIG.EXPORT_URL;

            var filterInput = document.createElement("input");
            filterInput.type = "hidden";
            filterInput.name = "filter";
            filterInput.value = State.currentFilter;
            form.appendChild(filterInput);

            var csrfInput = document.createElement("input");
            csrfInput.type = "hidden";
            csrfInput.name = "_token";
            csrfInput.value = CONFIG.CSRF_TOKEN;
            form.appendChild(csrfInput);

            document.body.appendChild(form);
            form.submit();
            document.body.removeChild(form);
        }

        // Bind sidebar events
        function bindSidebarEvents() {
            var bindings = {
                "collapse1": ["/Expertiser", "Attente Photo Avant"],
                "collapse92": ["/Expertise/encours", "Dossier En Expertise"],
                "collapse95": ["/Instance/Rapport", "Instance Rapport"],
                "collapse2": ["/Devis/Carence", "Attente Devis"],
                "collapse3": ["/Facture/Carence", "Attente Facture"],
                "collapse4": ["/Carence/Rapport", "Attente Rapport"],
                "collapse13": ["/Devis/Envoyer", "Accord Devis"],
                "collapse14": ["/Facture/Envoyer", "Accord Facture"],
                "collapse15": ["/Envoyer/Rapport", "Rapport A Envoyer"],
                "collapse15b": ["/Envoyer/Rapport", "Rapport A Envoyer"],
                "collapse16": ["/Devis/Deuxieme", "2ème Devis"],
                "collapse17": ["/Facture/Deuxieme", "2ème Facture"],
                "collapse05": ["/Deuxieme/Rapport", "Rapport Refusé"],
                "collapse90": ["/Facture/Trait", "Facture en Attente Accord"],
                "collapse91": ["/Devis/Trait", "Devis en Attente Accord"],
                "collapse72": ["/Base", "Attente Doc de Base"],
                "collapse50": ["/Signer/Document", "Documents A Signer"],
                "collapse80": ["/Devis/Photo", "Devis Sans Photo"],
                "collapse81": ["/Facture/Photo", "Facture Sans Photo"],
                "collapse96": ["/Expertise/Apres", "Attente Photo Après"],
                "collapse5": ["/Devis/Retraiter", "Devis A Retraiter"],
                "collapse6": ["/Facture/Retraiter", "Facture A Retraiter"],
                "collapse77": ["/Devis/Traitement", "Devis A Traiter"],
                "collapse9": ["/Facture/Traitement", "Facture A Traiter"],
                "collapse93": ["/Devis/Controler", "Devis A Contrôler"],
                "collapse8": ["/Signer/Rapport", "Rapport A Signer"],
                "collapse10": ["/Devis/Avis", "Demande Avis Devis"],
                "collapse11": ["/Facture/Avis", "Demande Avis Facture"],
                "collapse20": ["/Douteux", "Sinistre Douteux"],
                "collapse21": ["/Tribunale", "Dossier Tribunale"],
                "collapse85": ["/Facturation", "Dossier A Facturer"],
                "collapse71": ["/Rapide", "Dossier Rapide"],
                "collapse88": ["/Signe/Document", "Documents Signés"],
                "collapse7": ["/Retraiter/Rapport", "Rapport A Retraiter"]
            };

            for (var id in bindings) {
                (function(elemId, url, title) {
                    var el = document.getElementById(elemId);
                    if (el) {
                        el.addEventListener("click", function(e) {
                            e.preventDefault();
                            loadData(url, title);
                        });
                        el.style.cursor = "pointer";
                    }
                })(id, bindings[id][0], bindings[id][1]);
            }
        }

        // Initialize on DOM ready
        $(document).ready(function() {
            destroyDataTable();
            bindSidebarEvents();
            loadInitial("default");
        });

        // Expose globally
        window.loadData = loadData;
        window.exportToExcel = exportToExcel;

    })();
    </script>
@endsection