@extends('layouts.dashboard.app')
@section('style')
    <style>
        .custom-checkbox-label {
            display: inline-block;
            margin-right: 10px;
            /* Adjust as needed for spacing */
        }
    </style>
@endsection
@section('content')
    <div class="col-md-12">
        <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="page-title-box mb-3">
                        <div class="page-title-left mb-">
                            <a href="{{ route('Dossier.show', $id) }}" class="mt-2 btn btn-outline-dark">Dossier</a>
                        </div>
                    </div>
                    <div class="col-6">
                        {{-- <button id="selectAll" class="btn btn-sm btn-info">Selectioner Tout</button> --}}
                    </div>
                    <div class="col-6">
                        @if (Auth::user()->role_id == 4)
                            <a href="{{ route('Document.asigner', $id) }}" class="btn btn-outline-success"
                                style="float: right;">
                                Documents A Signer
                            </a>
                        @endif


                    </div>
                </div>
                @can('download', App\Models\Document::class)
                    <form action="{{ route('Document.pdf') }}" method="post">
                        @csrf
                    @endcan
                    <div class="mr-2 mt-1">
                        <div class="row">
                            @can('download', App\Models\Document::class)
                                {{-- <div class="form-check form-check-inline form-checkbox-warning mb-3">
                                    <label class="form-check-label fs-4" for="selectAll">Selectioner Tout </label>
                                    <input type="checkbox" id="selectAll" class="check form-check-input">
                                </div> --}}
                                <input type="hidden" name="attachements" id="docs">
                                @foreach ($types as $type)
                                    <div class="col-1">
                                        <div class="form-check form-check-inline">
                                            <input type="checkbox" id="{{ $type->id }}"
                                                class="type-checkbox form-check-input" data-type="{{ $type->type }}">
                                            <label class="form-check-label fs-3"
                                                for="{{ $type->id }}">{{ $type->type }}</label>
                                        </div>
                                    </div>
                                @endforeach
                            @endcan
                        </div>
                        <div class="row mt-3">
                            @foreach ($imgs as $doc)
                                <div class="col-4">
                                    <input type="checkbox" value="{{ $doc->id }}" class="check"
                                        data-type="{{ $doc->typedocument->type ?? null }}">
                                    <img id="img{{ $doc->id }}" style="width: 300px;height:250px"
                                        src="{{ Storage::disk('s3')->temporaryUrl($doc->path, now()->addMinutes(30)) }}"
                                        alt="">
                                    <span>{{ $doc->typedocument->type ?? null }}</span>
                                </div>
                            @endforeach
                        </div>
                        <div class="row mt-3">
                            @foreach ($pdfs as $doc)
                                <div class="col-4">
                                    <embed style="width: 300px;height:250px"
                                        src="{{ Storage::disk('s3')->temporaryUrl($doc->path, now()->addMinutes(30)) }}"
                                        width="600" height="500" alt="pdf" />

                                    <span>{{ $doc->typedocument->type }}</span>
                                </div>
                            @endforeach
                        </div>

                        <div class="row">
                            @can('download', App\Models\Document::class)
                                <div class="col-md-4"> <button type="submit" value="pdf" name="action"
                                        class="btn btn-success">
                                        Telecharger PDF
                                    </button>
                                </div>
                            @endcan
                            @can('download', App\Models\Document::class)
                                <div class="col-md-4"> <button type="submit" value="zip" name="action"
                                        class="btn btn-warning">
                                        Telecharger Zip
                                    </button>
                                </div>
                            @endcan

                            @if (Auth::user()->role_id == 4)

                                <div class="col-md-4"> <button type="submit" id="down" value="delete" name="action"
                                        class="btn btn-danger">
                                        Supprimer
                                    </button>
                                </div>
                            @endif

                        </div>




                    </div>
                </form>
            </div>
        </div>
    @endsection
    @section('script')
        <script>
            var checkboxes = document.getElementsByClassName('check');
            var array = [];
            var docs = document.getElementById('docs');
            $(document).ready(function() {
                var array = []; // Initialize an array to store related checkbox values

                // Add a click event listener to type checkboxes
                $(".type-checkbox").on("change", function() {
                    var type = $(this).data("type"); // Get the type value from data-type attribute
                    var relatedCheckboxes = $("[data-type='" + type +
                        "'][type='checkbox']"); // Find related checkboxes

                    // Check or uncheck the related checkboxes based on the type checkbox's status
                    relatedCheckboxes.prop("checked", this.checked);

                    if (this.checked) {
                        relatedCheckboxes.each(function() {
                            var checkboxValue = $(this)
                                .val(); // Get the value attribute of the checkbox
                            console.log(checkboxValue);
                            array.push(checkboxValue);
                        });
                    } else {
                        relatedCheckboxes.each(function() {
                            var checkboxValue = $(this)
                                .val(); // Get the value attribute of the checkbox
                            var checkboxIndex = array.indexOf(checkboxValue); // Get the index
                            if (checkboxIndex !== -1) {
                                array.splice(checkboxIndex, 1);
                            }
                        });
                    }

                    // Update the hidden input with the selected checkbox values
                    $("#docs").val(array.join(',')); // Set the hidden input value as a comma-separated string
                    console.log(array);
                });
            });






            for (var i = 0; i < checkboxes.length; i++) {
                checkboxes[i].addEventListener('change', function() {
                    if (this.checked) {
                        array.push(this.value);
                        docs.value = array;
                    } else {
                        var carIndex = array.indexOf(this.value); //get   index
                        array.splice(carIndex, 1);
                        docs.value = array;
                    }
                });

            }
        </script>
        <script>
            function func() {
                if (document.getElementById("frame").style.display = "none") {
                    document.getElementById("frame").style.display = "block";
                } else {
                    document.getElementById("frame").style.display = "none"
                }
            }
        </script>
    @endsection
