@extends('layouts.dashboard.app')

@section('content')
    <div class="row mt-2">
        <div class="table-responsive">
            <div class="col-12">
                <form method="POST" action="{{ route('Montant.update',$montant->id) }}">
                    @method('PUT')
                    @csrf

                    <table class="table" id="">
                        <thead>
                            <tr>
                                <th>Montant Devis</th>
                                <th>Montant Accord</th>
                                <th>Montant Facture</th>
                                <th>Montant Rapport</th>
                                <th>Modifier</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td class="col-3"> <input type="text" name="montant_devis"
                                        value="{{ $montant->devis->montant_devis ?? null }}"
                                        @if ($devis < 1) readonly @endif  name="montant_devis"
                                        class="form-control  @error('montant_devis') is-invalid @enderror">
                                    @error('montant_devis')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </td>
                                <td class="col-3"> <input type="text" name="montant_accord"
                                        value="{{ $montant->montant_accord ?? null }}"   @if ($devis < 1) readonly @endif
                                        class="form-control @error('montant_accord') is-invalid @enderror">
                                    @error('montant_accord')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </td>
                                <td class="col-3">
                                    <input type="text"  value="{{ $montant->facture->montant_facture ?? null }}"
                                        name="montant_facture" @if ($facture < 1) readonly @endif
                                        class="form-control @error('montant_facture') is-invalid @enderror">
                                    @error('montant_facture')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </td>
                                <td class="col-3"> <input type="text" readonly value="{{ $montant->montant_rapport ?? null }}"
                                        name="montant_rapport"
                                        class="form-control @error('montant_rapport') is-invalid @enderror">
                                    @error('montant_rapport')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </td>
                                <td class="col-3">
                                    <button type="submit" class="btn btn-sm btn-outline-primary"> Modifier</button>
                                </td>
                            </tr>

                        </tbody>
                    </table>
                </form>
            </div>
        </div>
    </div>
@endsection
