@extends('layouts.config_dashboard.app')

@section('content')
    <div class="container-fluid mt-4 ">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body mt-1">
                        <form action="{{ route('Modele.update', $model->id) }}" method="post">
                            @csrf
                            @method('PUT')

                            <div class="form-group mb-1">
                                <label for="Role">Marque :</label>
                                <select class="form-select " name="brand" id="brand">
                                    <option selected value="{{ $model->brand->id }}">{{ $model->brand->brand }}</option>
                                    @foreach ($brands as $brand)
                                        <option value="{{ $brand->id }}">{{ $brand->brand }}</option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="form-group mb-1">
                                <label for="name">Modele :</label>
                                <input type="text" name="name" value="{{ $model->name }}" required
                                    class="form-control @error('model') is-invalid @enderror">
                                @error('model')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="form-group mb-1">
                                <label for="code">Code :</label>
                                <input type="text" name="code" value="{{ $model->code }}" required
                                    class="form-control @error('model') is-invalid @enderror">
                                @error('model')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>

                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary">Modifier</button>
                    </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
