@extends('layouts.config_dashboard.app')

@section('content')
    <div class="container-fluid ">
        <div class="row">
            <div class="col-12">
                <div class="page-title-box">
                    <h4 class="page-title" style="font-size: 25px">Liste des Marques</h4>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row mb-3">
                            <div class="d-flex ">
                                <div class="col-md-6">
                                    @can('create', App\Models\Brand::class)
                                        <a style="float: left" href="{{ route('Brand.create') }}"
                                            class="btn btn-success rounded-pill"> Créer</a>
                                    @endcan

                                </div>
                                <div class="col-md-4"></div>
                                @can('delete', App\Models\Brand::class)
                                    <a style="float: right" href="{{ route('Brand.deleted') }}"
                                        class="btn btn-warning rounded-pill"> Restaurer</a>
                                @endcan
                            </div>
                        </div>

                        <div class="table-responsive">
                            <table class="table" id="myTable">
                                <thead>
                                    <tr>
                                        <th>Id</th>
                                        <th>Marque</th>
                                        <th>Modifier</th>
                                        <th>Supprimer</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse ($brands as $brand)
                                        <tr>
                                            <td>{{ $brand->id }}</td>
                                            <td>{{ $brand->brand }}</td>
                                            <td>
                                                @can('update', App\Models\Brand::class)
                                                    <a class="btn btn-sm btn-primary rounded-pill"
                                                        href="{{ route('Brand.edit', [$brand->id]) }}"><i
                                                            class="uil uil-pen fs-5"></i>
                                                    </a>
                                                @endcan

                                            </td>
                                            <td>
                                                @can('delete', App\Models\Brand::class)
                                                    <form action="{{ route('Brand.destroy', [$brand->id]) }}" method="post">
                                                        @method('DELETE')
                                                        @csrf
                                                        <button class="btn btn-sm btn-danger rounded-pill" type="submit">
                                                            <i class="uil uil-trash fs-5"></i>
                                                        </button>
                                                    </form>
                                                @endcan

                                            </td>
                                        </tr>
                                    @empty
                                        <h3>Tableau Vide</h3>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>

                    </div>
                </div>

            </div>
        </div>
    </div>
@endsection
