@extends('layouts.dashboard.app')

@section('content')
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="page-title-box">
                    <h4 class="page-title text-success">Réglements </h4>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="card shadow bg-body rounded">
                <div class="card-body">
                    <div class="col-12">
                        <div class="table-responsive">

                            <table class="table table-stripped text-dark" id="">
                                <thead class="table-light">
                                    <tr>

                                        <th>Reglement</th>
                                        <th>Compagnie</th>
                                        <th>Montant</th>
                                        <th>Montant Restant</th>
                                        <th>Banque</th>
                                        <th>Mode</th>
                                        <th>Date facture</th>
                                        <th>Date de Paiement</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>

                                        <td style="color: black; font-weight:bold">
                                            {{ $settlement->id }}
                                        </td>
                                        <td>
                                            {{ $settlement->company->company ?? null }}
                                        </td>

                                        <td>
                                            {{ $settlement->montant ?? null }} DH
                                        </td>
                                        <td>
                                            <span class="badge bg-info">{{ $settlement->reste ?? null }} DH</span>
                                        </td>
                                        <td>
                                            {{ $settlement->banque ?? null }}
                                        </td>
                                        <td>
                                            {{ $settlement->mode_paiement ?? null }}
                                        </td>
                                        <td>
                                            {{ $settlement->date_facture ?? null }}
                                        </td>
                                        <td>
                                            {{ $settlement->date_paiement ?? null }}
                                        </td>


                                    </tr>
                                </tbody>
                            </table>


                        </div>
                    </div>
                </div>
            </div>

        </div>
        <div class="row">
            <div class="card shadow bg-body rounded">
                <div class="card-body">
                    <div class="col-12">
                        <div class="table-responsive">

                            <table class="table table-stripped text-dark" id="">
                                <thead class="table-light">
                                    <tr>

                                        <th>Facture Ref</th>
                                        <th>Facture Ref</th>
                                        <th>Montant</th>


                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($payments as $payment)
                                        <tr>

                                            <td style="color: black; font-weight:bold">
                                                {{ $payment->ref ?? null}}
                                            </td>
                                            <td>
                                                {{ $payment->dossier->ref ?? null }}
                                            </td>
                                            <td>
                                                <span class="badge bg-info">{{ $payment->montant ?? null }} DH</span>
                                            </td>

                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>


                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
@endsection
